# include "InterProc.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"
# include "CallGraph.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 21 "InterProc.puma" */


# undef  DEBUG

# define MODULE "InterProc"


# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "Traverse.h"
# include "StrUnparse.h"
# include <string.h>

# include "Common.h"
# include "Types.h"           /* ArrayFormals, ... */

# include "Rank.h"
# include "Calling.h"
# include "CallGraphFns.h"
# include "Nesting.h"
# include "DefTable.h"
# include "Objects.h"
# include "RegShadow.h"

typedef void CallFunction ();

static int overlap_update;

static int  ip_update;         /* used globally for terminating  */
static int  ip_phases;         /* counts phases                  */

static char CalledRoutine  [MAX_ID_LENGTH];
static char CallingRoutine [MAX_ID_LENGTH];



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyInterProc.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* InterProc_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module InterProc, routine %s failed\n",
  yyFunction);
 InterProc_Exit ();
}

void Interprocedural ARGS ((tTree t));
static void IP_Analysis ARGS ((tTree t));
static void Dummy ARGS ((tDefinitions actual_obj, tDefinitions formal_obj));
static void BottomUp ARGS ((tCallGraph t, CallFunction f));
static void TopDown ARGS ((tCallGraph t, CallFunction f));
static void UnMark ARGS ((tCallGraph c));
static void ApplyToCalls ARGS ((tDefinitions obj, CallFunction f));
static void DoFunction ARGS ((tTree t));
static void SetSameOverlap ARGS ((tDefinitions actual_obj, tDefinitions formal_obj));
static tDefinitions GetCommonReference ARGS ((tDefinitions common_obj));
static void ProtocolUpdate ARGS ((tDefinitions actual_obj, tDefinitions formal_obj, int kind));
static void CompareShadow ARGS ((tDefinitions actual, tDefinitions dummy));
static void SetSameOverlapFormals ARGS ((tTree actuallist, tTree dummylist));
static void SetSameOverlapSize ARGS ((tTree actual, tTree dummy));

void Interprocedural
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 67 "InterProc.puma" */

char msg[100];

  if (t->Kind == kCOMP_UNIT) {
/* line 77 "InterProc.puma" */
  {
/* line 82 "InterProc.puma" */
   FullTraverseAST (t->COMP_UNIT.COMP_ELEMENTS, IP_Analysis);
/* line 84 "InterProc.puma" */
 if (protocol_errors () == 0)

       {  BeginCalling ();
          Calling (t);
          CloseCalling ();

          

          do {

             ip_update = 0;

             UnMark (TheCallGraph);
             print_protocol ("INTERPROCEDURAL : TOP DOWN (start)");
             TopDown (TheCallGraph, DoFunction);
             print_protocol ("INTERPROCEDURAL : TOP DOWN (end)");
             sprintf (msg, "  there were %d updates\n", ip_update);
             print_protocol (msg);

             if (ip_update != 0)

               { ip_update = 0;
                 UnMark (TheCallGraph);
                 print_protocol ("INTERPROCEDURAL : BOTTOM UP (start)");
                 BottomUp (TheCallGraph, DoFunction);
                 print_protocol ("INTERPROCEDURAL : BOTTOM UP (end)");
                 sprintf (msg, "  there were %d updates\n", ip_update);
                 print_protocol (msg);
               }
 
          } while (ip_update != 0);

         PrintShadowInfo ();

       }

    
  }
   return;

  }
;
}

static void IP_Analysis
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMMON_DECL) {
/* line 135 "InterProc.puma" */
  {
/* line 137 "InterProc.puma" */
   CheckCommonDescriptors (t, Dummy);
  }
   return;

  }
  if (t->Kind == kCALL_STMT) {
/* line 140 "InterProc.puma" */
  {
/* line 142 "InterProc.puma" */
   CheckActualDescriptors (t, Dummy);
  }
   return;

  }
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 145 "InterProc.puma" */
  {
/* line 147 "InterProc.puma" */
   CheckActualDescriptors (t, Dummy);
  }
   return;

  }
;
}

static void Dummy
# if defined __STDC__ | defined __cplusplus
(register tDefinitions actual_obj, register tDefinitions formal_obj)
# else
(actual_obj, formal_obj)
 register tDefinitions actual_obj;
 register tDefinitions formal_obj;
# endif
{
  if (formal_obj->Kind == kVarObject) {
  if (formal_obj->VarObject.Kind->Kind == kVarCommon) {
/* line 152 "InterProc.puma" */
  {
/* line 156 "InterProc.puma" */
   formal_obj->VarObject.Kind->VarCommon.ref_obj = actual_obj;
  }
   return;

  }
  }
/* line 159 "InterProc.puma" */
   return;

;
}

static void BottomUp
# if defined __STDC__ | defined __cplusplus
(register tCallGraph t, CallFunction f)
# else
(t, f)
 register tCallGraph t;
 CallFunction f;
# endif
{
 yyRecursion:
/* line 178 "InterProc.puma" */
  {
/* line 179 "InterProc.puma" */
   if (! ((t == NoCallGraph))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kCallingGraph) {
/* line 182 "InterProc.puma" */
  {
/* line 184 "InterProc.puma" */

#ifdef DEBUG
    printf ("Bottom Up Visting of all Nodes\n");
#endif 
    
/* line 190 "InterProc.puma" */
   UnMark (t->CallingGraph.UserNodes);
/* line 191 "InterProc.puma" */
   t = t->CallingGraph.UserNodes;
   goto yyRecursion;
  }

  }
  if (t->Kind == kCallNodeList) {
/* line 194 "InterProc.puma" */
  {
/* line 195 "InterProc.puma" */
   BottomUp (t->CallNodeList.Elem, f);
/* line 196 "InterProc.puma" */
   t = t->CallNodeList.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kCallNode) {
/* line 199 "InterProc.puma" */
  {
/* line 200 "InterProc.puma" */
   if (! ((t->CallNode.unitkind == 2))) goto yyL4;
  }
   return;
yyL4:;

/* line 203 "InterProc.puma" */
  {
/* line 205 "InterProc.puma" */
   if (! ((t->CallNode.unitkind == 1))) goto yyL5;
  {
/* line 207 "InterProc.puma" */
   ApplyToCalls (t->CallNode.val, f);
/* line 209 "InterProc.puma" */
   t->CallNode.unitkind = 2;
  }
  }
   return;
yyL5:;

/* line 212 "InterProc.puma" */
  {
/* line 214 "InterProc.puma" */
   if (! ((UnitKind (t->CallNode.val) == 0))) goto yyL6;
  {
/* line 218 "InterProc.puma" */
   t->CallNode.unitkind = 1;
/* line 220 "InterProc.puma" */
   BottomUp (t->CallNode.calling, f);
/* line 222 "InterProc.puma" */
   ApplyToCalls (t->CallNode.val, f);
/* line 224 "InterProc.puma" */
   t->CallNode.unitkind = 2;
  }
  }
   return;
yyL6:;

  }
  if (t->Kind == kCallEdgeList) {
/* line 227 "InterProc.puma" */
  {
/* line 228 "InterProc.puma" */
   BottomUp (t->CallEdgeList.Node, f);
/* line 229 "InterProc.puma" */
   t = t->CallEdgeList.Next;
   goto yyRecursion;
  }

  }
;
}

static void TopDown
# if defined __STDC__ | defined __cplusplus
(register tCallGraph t, CallFunction f)
# else
(t, f)
 register tCallGraph t;
 CallFunction f;
# endif
{
 yyRecursion:
/* line 248 "InterProc.puma" */
  {
/* line 249 "InterProc.puma" */
   if (! ((t == NoCallGraph))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kCallingGraph) {
/* line 252 "InterProc.puma" */
  {
/* line 254 "InterProc.puma" */

#ifdef DEBUG
    printf ("Top Down Visting of all Nodes\n");
#endif 
    
/* line 260 "InterProc.puma" */
   UnMark (t->CallingGraph.UserNodes);
/* line 261 "InterProc.puma" */
   t = t->CallingGraph.UserNodes;
   goto yyRecursion;
  }

  }
  if (t->Kind == kCallNodeList) {
/* line 264 "InterProc.puma" */
  {
/* line 265 "InterProc.puma" */
   TopDown (t->CallNodeList.Elem, f);
/* line 266 "InterProc.puma" */
   t = t->CallNodeList.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kCallNode) {
/* line 269 "InterProc.puma" */
  {
/* line 270 "InterProc.puma" */
   if (! ((t->CallNode.unitkind == 2))) goto yyL4;
  }
   return;
yyL4:;

/* line 273 "InterProc.puma" */
  {
/* line 275 "InterProc.puma" */
   if (! ((t->CallNode.unitkind == 1))) goto yyL5;
  {
/* line 277 "InterProc.puma" */
   ApplyToCalls (t->CallNode.val, f);
/* line 279 "InterProc.puma" */
   t->CallNode.unitkind = 2;
  }
  }
   return;
yyL5:;

/* line 282 "InterProc.puma" */
  {
/* line 284 "InterProc.puma" */
   if (! ((UnitKind (t->CallNode.val) == 0))) goto yyL6;
  {
/* line 288 "InterProc.puma" */
   t->CallNode.unitkind = 1;
/* line 290 "InterProc.puma" */
   TopDown (t->CallNode.called_by, f);
/* line 292 "InterProc.puma" */
   ApplyToCalls (t->CallNode.val, f);
/* line 294 "InterProc.puma" */
   t->CallNode.unitkind = 2;
  }
  }
   return;
yyL6:;

  }
  if (t->Kind == kCallEdgeList) {
/* line 297 "InterProc.puma" */
  {
/* line 299 "InterProc.puma" */
   TopDown (t->CallEdgeList.Node, f);
/* line 300 "InterProc.puma" */
   t = t->CallEdgeList.Next;
   goto yyRecursion;
  }

  }
;
}

static void UnMark
# if defined __STDC__ | defined __cplusplus
(register tCallGraph c)
# else
(c)
 register tCallGraph c;
# endif
{
 yyRecursion:
/* line 311 "InterProc.puma" */
  {
/* line 312 "InterProc.puma" */
   if (! ((c == NoCallGraph))) goto yyL1;
  }
   return;
yyL1:;

  if (c->Kind == kCallingGraph) {
/* line 315 "InterProc.puma" */
  {
/* line 316 "InterProc.puma" */
   UnMark (c->CallingGraph.UserNodes);
/* line 317 "InterProc.puma" */
   UnMark (c->CallingGraph.IntrinsicNodes);
/* line 318 "InterProc.puma" */
   c = c->CallingGraph.ExternalNodes;
   goto yyRecursion;
  }

  }
  if (c->Kind == kCallNodeList) {
/* line 321 "InterProc.puma" */
  {
/* line 322 "InterProc.puma" */
   UnMark (c->CallNodeList.Elem);
/* line 323 "InterProc.puma" */
   c = c->CallNodeList.Next;
   goto yyRecursion;
  }

  }
  if (c->Kind == kCallNode) {
/* line 326 "InterProc.puma" */
  {
/* line 327 "InterProc.puma" */
   c->CallNode.unitkind = 0;
  }
   return;

  }
;
}

static void ApplyToCalls
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, CallFunction f)
# else
(obj, f)
 register tDefinitions obj;
 CallFunction f;
# endif
{
  if (obj->Kind == kProcObject) {
  if (obj->ProcObject.decl->Kind == kPROGRAM_DECL) {
/* line 340 "InterProc.puma" */
  {
/* line 342 "InterProc.puma" */
   if (! ((obj->ProcObject.decl->PROGRAM_DECL.PROGRAM_BODY != NoTree))) goto yyL1;
  {
/* line 344 "InterProc.puma" */
   GetString (obj->ProcObject.Ident, CallingRoutine);
/* line 345 "InterProc.puma" */
   NestOpenUnitObj (obj);
/* line 346 "InterProc.puma" */
   FullTraverseAST (obj->ProcObject.decl->PROGRAM_DECL.PROGRAM_BODY, f);
/* line 347 "InterProc.puma" */
   NestCloseUnitObj (obj);
  }
  }
   return;
yyL1:;

  }
  if (obj->ProcObject.decl->Kind == kPROC_DECL) {
/* line 350 "InterProc.puma" */
  {
/* line 352 "InterProc.puma" */
   if (! ((obj->ProcObject.decl->PROC_DECL.PROC_BODY != NoTree))) goto yyL2;
  {
/* line 354 "InterProc.puma" */
   GetString (obj->ProcObject.Ident, CallingRoutine);
/* line 355 "InterProc.puma" */
   NestOpenUnitObj (obj);
/* line 356 "InterProc.puma" */
   FullTraverseAST (obj->ProcObject.decl->PROC_DECL.PROC_BODY, f);
/* line 357 "InterProc.puma" */
   NestCloseUnitObj (obj);
  }
  }
   return;
yyL2:;

  }
  }
  if (obj->Kind == kFuncObject) {
/* line 360 "InterProc.puma" */
  {
/* line 362 "InterProc.puma" */
   GetString (obj->FuncObject.Ident, CallingRoutine);
/* line 363 "InterProc.puma" */
   NestOpenUnitObj (obj);
/* line 364 "InterProc.puma" */
   FullTraverseAST (obj->FuncObject.decl, f);
/* line 365 "InterProc.puma" */
   NestCloseUnitObj (obj);
  }
   return;

  }
;
}

static void DoFunction
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMMON_DECL) {
/* line 383 "InterProc.puma" */
  {
/* line 385 "InterProc.puma" */
   CheckCommonDescriptors (t, SetSameOverlap);
  }
   return;

  }
  if (t->Kind == kCALL_STMT) {
/* line 388 "InterProc.puma" */
  {
/* line 392 "InterProc.puma" */
   GetString (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, CalledRoutine);
/* line 397 "InterProc.puma" */
   CheckActualDescriptors (t, SetSameOverlap);
  }
   return;

  }
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 400 "InterProc.puma" */
  {
/* line 404 "InterProc.puma" */
   GetString (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, CalledRoutine);
/* line 405 "InterProc.puma" */
   CheckActualDescriptors (t, SetSameOverlap);
  }
   return;

  }
;
}

static void SetSameOverlap
# if defined __STDC__ | defined __cplusplus
(register tDefinitions actual_obj, register tDefinitions formal_obj)
# else
(actual_obj, formal_obj)
 register tDefinitions actual_obj;
 register tDefinitions formal_obj;
# endif
{
/* line 419 "InterProc.puma" */
  {
/* line 421 "InterProc.puma" */
   if (! ((VarRank (actual_obj) != VarRank (formal_obj)))) goto yyL1;
  {
/* line 425 "InterProc.puma" */
 if (semantic_check == 0)
       warning_protocol ("no overlap update: rank of dummy/actual mismatch");
     else
       error_protocol ("no overlap update: rank of dummy/actual mismatch");
    obj_protocol ("actual : ", actual_obj);
    obj_protocol ("dummy  : ", formal_obj);
  
  }
  }
   return;
yyL1:;

/* line 434 "InterProc.puma" */
  {
/* line 436 "InterProc.puma" */
   if (! ((VarRank (formal_obj) == 0))) goto yyL2;
  }
   return;
yyL2:;

/* line 439 "InterProc.puma" */
 {
  tDefinitions ref_actual_obj;
  {
/* line 441 "InterProc.puma" */
   overlap_update = 0;
/* line 443 "InterProc.puma" */
   CompareShadow (actual_obj, formal_obj);
/* line 445 "InterProc.puma" */
   ProtocolUpdate (actual_obj, formal_obj, overlap_update);
/* line 447 "InterProc.puma" */
 if (overlap_update) ip_update++; 
/* line 461 "InterProc.puma" */
 if ( IsVarCommon(actual_obj) && IsVarDummy(formal_obj))
    
     {   ref_actual_obj = GetCommonReference (actual_obj);

         if (ref_actual_obj != NoObject)

            SetSameOverlap (actual_obj, ref_actual_obj);
     }
  
  }
   return;
 }

;
}

static tDefinitions GetCommonReference
# if defined __STDC__ | defined __cplusplus
(register tDefinitions common_obj)
# else
(common_obj)
 register tDefinitions common_obj;
# endif
{
  if (common_obj->Kind == kVarObject) {
  if (common_obj->VarObject.Kind->Kind == kVarCommon) {
/* line 474 "InterProc.puma" */
   return common_obj->VarObject.Kind->VarCommon.ref_obj;

  }
  }
/* line 478 "InterProc.puma" */
  {
/* line 479 "InterProc.puma" */
   obj_error_protocol ("common object expected ", common_obj);
/* line 480 "InterProc.puma" */
   failure_protocol (MODULE, "GetCommonReference", common_obj->Object.decl);
  }
   return NoObject;

}

static void ProtocolUpdate
# if defined __STDC__ | defined __cplusplus
(register tDefinitions actual_obj, register tDefinitions formal_obj, register int kind)
# else
(actual_obj, formal_obj, kind)
 register tDefinitions actual_obj;
 register tDefinitions formal_obj;
 register int kind;
# endif
{
/* line 486 "InterProc.puma" */

char msg[100];

/* line 490 "InterProc.puma" */
  {
/* line 493 "InterProc.puma" */
   goto yyL1;
  }
yyL1:;

/* line 496 "InterProc.puma" */
  {
/* line 498 "InterProc.puma" */
 if (kind == 1)
        print_protocol ("inherited overlap from formal");
      else if (kind == 2)
       print_protocol ("inherited overlap from actual");
     else 
       print_protocol ("now same overlap");

     if (IsVarDummy (formal_obj))
       { sprintf (msg, "   by calling subroutine %s in %s", 
                       CalledRoutine, CallingRoutine);
         print_protocol (msg);
       }
      else
         print_protocol ("   from reference common");

     obj_protocol ("actual : ", actual_obj);
     obj_protocol ("formal : ", formal_obj);
  
  }
   return;

;
}

static void CompareShadow
# if defined __STDC__ | defined __cplusplus
(register tDefinitions actual, register tDefinitions dummy)
# else
(actual, dummy)
 register tDefinitions actual;
 register tDefinitions dummy;
# endif
{
 yyRecursion:
  if (actual->Kind == kVarObject) {
  if (dummy->Kind == kVarObject) {
/* line 526 "InterProc.puma" */
  {
/* line 528 "InterProc.puma" */
   if (! ((IsZeroShadow (actual->VarObject.shadow)))) goto yyL1;
  {
/* line 529 "InterProc.puma" */
   if (! ((IsZeroShadow (dummy->VarObject.shadow)))) goto yyL1;
  }
  }
   return;
yyL1:;

/* line 534 "InterProc.puma" */
  {
/* line 536 "InterProc.puma" */
   if (! ((actual->VarObject.shadow == NoTree))) goto yyL2;
  {
/* line 538 "InterProc.puma" */
   SetDefaultShadow (actual);
/* line 539 "InterProc.puma" */
   goto yyRecursion;
  }
  }
yyL2:;

/* line 542 "InterProc.puma" */
  {
/* line 544 "InterProc.puma" */
   if (! ((dummy->VarObject.shadow == NoTree))) goto yyL3;
  {
/* line 546 "InterProc.puma" */
   SetDefaultShadow (dummy);
/* line 547 "InterProc.puma" */
   goto yyRecursion;
  }
  }
yyL3:;

/* line 550 "InterProc.puma" */
  {
/* line 554 "InterProc.puma" */
   FixShadowVarObject (actual);
/* line 555 "InterProc.puma" */
   FixShadowVarObject (dummy);
/* line 557 "InterProc.puma" */
   SetSameOverlapFormals (actual->VarObject.shadow, dummy->VarObject.shadow);
  }
   return;

  }
  }
;
}

static void SetSameOverlapFormals
# if defined __STDC__ | defined __cplusplus
(register tTree actuallist, register tTree dummylist)
# else
(actuallist, dummylist)
 register tTree actuallist;
 register tTree dummylist;
# endif
{
 yyRecursion:
  if (actuallist->Kind == kSHADOW_LIST) {
  if (dummylist->Kind == kSHADOW_LIST) {
/* line 572 "InterProc.puma" */
  {
/* line 574 "InterProc.puma" */
   SetSameOverlapSize (actuallist->SHADOW_LIST.Elem, dummylist->SHADOW_LIST.Elem);
/* line 575 "InterProc.puma" */
   actuallist = actuallist->SHADOW_LIST.Next;
   dummylist = dummylist->SHADOW_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  if (actuallist->Kind == kSHADOW_EMPTY) {
  if (dummylist->Kind == kSHADOW_EMPTY) {
/* line 578 "InterProc.puma" */
   return;

  }
  }
/* line 583 "InterProc.puma" */
  {
/* line 585 "InterProc.puma" */
   failure2_protocol (MODULE, "SetSameOverlapFormals", actuallist, dummylist);
  }
   return;

;
}

static void SetSameOverlapSize
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree dummy)
# else
(actual, dummy)
 register tTree actual;
 register tTree dummy;
# endif
{
  if (actual->Kind == kSHADOW_SPEC) {
  if (dummy->Kind == kSHADOW_SPEC) {
/* line 602 "InterProc.puma" */
  {
/* line 605 "InterProc.puma" */
 if (actual->SHADOW_SPEC.left_size < dummy->SHADOW_SPEC.left_size)  { actual->SHADOW_SPEC.left_size = dummy->SHADOW_SPEC.left_size;  overlap_update = overlap_update | 1; }
    if (dummy->SHADOW_SPEC.left_size < actual->SHADOW_SPEC.left_size)  { dummy->SHADOW_SPEC.left_size = actual->SHADOW_SPEC.left_size;  overlap_update = overlap_update | 2; }
    if (actual->SHADOW_SPEC.right_size < dummy->SHADOW_SPEC.right_size)  { actual->SHADOW_SPEC.right_size = dummy->SHADOW_SPEC.right_size;  overlap_update = overlap_update | 1; }
    if (dummy->SHADOW_SPEC.right_size < actual->SHADOW_SPEC.right_size)  { dummy->SHADOW_SPEC.right_size = actual->SHADOW_SPEC.right_size;  overlap_update = overlap_update | 2; }
  
  }
   return;

  }
  }
/* line 612 "InterProc.puma" */
  {
/* line 614 "InterProc.puma" */
   failure2_protocol (MODULE, "SetSameOverlapSize", actual, dummy);
  }
   return;

;
}

void BeginInterProc ARGS ((void))
{
}

void CloseInterProc ARGS ((void))
{
}
