# include "InitAllocate.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 41 "InitAllocate.puma" */


# define MODULE "InitAllocate"

# undef DEBUG

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "DefTable.h"

# include "Transform.h"    /* AppendDECLS */
# include "Expressions.h"  /* MakeConstant */
# include "Types.h"

# include "Shapes.h"      
# include "MakeLoops.h"
# include "Nesting.h"
# include "Objects.h"
# include "Distributions.h"
# include "Traverse.h"
# include "ArrayDescriptor.h"    /* GetDspKind             */

# include "protocol.h"

# include "Temporary.h"

static tTree NewInitStatements;
static tTree NewExitStatements;

static rbool IsMain;          /* indicates a main unit */

/* Important : counter variable that indicatest the current loop nest */

static int  loop_nest   = 0;
static int  line_number = 0;   /* used globally to avoid argument */
static tEntries ObjScope;       /* used globally for current scope */

static rbool is_init;           /* selector for create/free        */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyInitAllocate.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* InitAllocate_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module InitAllocate, routine %s failed\n",
  yyFunction);
 InitAllocate_Exit ();
}

void InitAllocate ARGS ((tTree t, tTree unit));
static void InsertNewStatements ARGS ((tTree body, tTree unit));
static tTree GetDspStatements ARGS ((tTree var, tTree decls, tDefinitions scope));
static tTree MakeDspStmts ARGS ((tTree var, tIdent id, tTree indexes, int kind, rbool do_dsp, rbool do_alloc));
static tTree DerivTypeStmts ARGS ((tTree var, tDefinitions obj, tTree type));
static void GetDspActions ARGS ((tDefinitions obj, rbool * yyP3, rbool * yyP2, int * yyP1));
static rbool MustBeAllocated ARGS ((tDefinitions obj));
static rbool InheritDescriptor ARGS ((tDefinitions obj, int kind));
static rbool IsStaticObject ARGS ((tDefinitions var));
static rbool StopDspAllocate ARGS ((tTree t));
static tTree GetDspAllocate ARGS ((tTree t));
static tTree GetCompDspStatements ARGS ((tTree params));
static tTree BuildCompDspStmts ARGS ((tTree var, tTree type));
static tTree GetTypeDspStatements ARGS ((tTree var, tDefinitions t));
static tTree CreateDspStmt ARGS ((tTree var, tIdent name, tTree indexes, int kind));
static tTree FreeDspStmt ARGS ((tTree var, tIdent name, int kind));
static tTree MakeAllocate ARGS ((tTree var, tIdent name, tTree indexes));
static tTree MakeExpList ARGS ((tTree t));
static tTree MakeDeallocate ARGS ((tTree var, tIdent name));
static tTree MakeVariable ARGS ((tTree var, tIdent name));
static void SetObject ARGS ((tTree t));
static tDefinitions GetCurrentObject ARGS ((tIdent name));
static void GetTypeInfo ARGS ((tTree type, tDefinitions * yyP4));

void InitAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree unit)
# else
(t, unit)
 register tTree t;
 register tTree unit;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 104 "InitAllocate.puma" */
  {
/* line 106 "InitAllocate.puma" */
   IsMain = IsMainUnit (unit);
/* line 108 "InitAllocate.puma" */
   TemporaryInit (t);
/* line 110 "InitAllocate.puma" */
   is_init = rtrue;
/* line 112 "InitAllocate.puma" */
   NewInitStatements = GetDspStatements (NoTree, t->BODY_NODE.DECLS, GetCurrentScope ());
/* line 114 "InitAllocate.puma" */
   is_init = rfalse;
/* line 116 "InitAllocate.puma" */
   NewExitStatements = GetDspStatements (NoTree, t->BODY_NODE.DECLS, GetCurrentScope ());
/* line 120 "InitAllocate.puma" */
   tree_protocol ("new inits : \n", NewInitStatements);
/* line 121 "InitAllocate.puma" */
   tree_protocol ("new exits : \n", NewExitStatements);
/* line 125 "InitAllocate.puma" */
   t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopDspAllocate, GetDspAllocate);
/* line 127 "InitAllocate.puma" */
   InsertNewStatements (t, unit);
/* line 129 "InitAllocate.puma" */
   TemporaryDone (t);
  }
   return;

  }
/* line 132 "InitAllocate.puma" */
  {
/* line 134 "InitAllocate.puma" */
   failure_protocol (MODULE, "InitAllocate", t);
  }
   return;

;
}

static void InsertNewStatements
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree unit)
# else
(body, unit)
 register tTree body;
 register tTree unit;
# endif
{
  if (unit->Kind == kBLOCK_DATA_DECL) {
/* line 145 "InitAllocate.puma" */
   return;

  }
  if (body->Kind == kBODY_NODE) {
  if (unit->Kind == kMODULE_DECL) {
/* line 148 "InitAllocate.puma" */
  {
/* line 152 "InitAllocate.puma" */
 body->BODY_NODE.STATS = CombineACF (NewInitStatements, body->BODY_NODE.STATS); 
  }
   return;

  }
/* line 155 "InitAllocate.puma" */
  {
/* line 157 "InitAllocate.puma" */
   if ((NewExitStatements != NoTree)) {
/* line 159 "InitAllocate.puma" */
   body->BODY_NODE.STATS = CombineACF (body->BODY_NODE.STATS, CompleteACFs (NewExitStatements));
   }
/* line 163 "InitAllocate.puma" */
   body->BODY_NODE.STATS = CombineACF (NewInitStatements, body->BODY_NODE.STATS);
  }
   return;

  }
;
}

static tTree GetDspStatements
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree decls, register tDefinitions scope)
# else
(var, decls, scope)
 register tTree var;
 register tTree decls;
 register tDefinitions scope;
# endif
{
  if (decls->Kind == kDECL_LIST) {
/* line 183 "InitAllocate.puma" */
  {
/* line 185 "InitAllocate.puma" */
   if (! ((is_init))) goto yyL1;
  }
   return CombineACF (GetDspStatements (var, decls->DECL_LIST.Elem, scope), GetDspStatements (var, decls->DECL_LIST.Next, scope));
yyL1:;

/* line 193 "InitAllocate.puma" */
   return CombineACF (GetDspStatements (var, decls->DECL_LIST.Next, scope), GetDspStatements (var, decls->DECL_LIST.Elem, scope));

  }
  if (decls->Kind == kVAR_DECL) {
  if (decls->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
/* line 199 "InitAllocate.puma" */
 {
  tDefinitions Obj;
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  tTree dstmts;
  tTree tstmts;
  {
/* line 201 "InitAllocate.puma" */
   ObjScope = scope;
/* line 205 "InitAllocate.puma" */
   if ((var == NoTree)) {
/* line 205 "InitAllocate.puma" */
   line_number = decls->VAR_DECL.Line;
   }
/* line 207 "InitAllocate.puma" */
   Obj = GetCurrentObject (decls->VAR_DECL.Ident);
/* line 209 "InitAllocate.puma" */
   GetDspActions (Obj, & yyV1, & yyV2, & yyV3);
/* line 213 "InitAllocate.puma" */
   dstmts = MakeDspStmts (var, decls->VAR_DECL.Ident, decls->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES, yyV3, yyV1, yyV2);
/* line 216 "InitAllocate.puma" */
   if ((IsStaticObject (Obj))) {
/* line 218 "InitAllocate.puma" */
   tstmts = DerivTypeStmts (var, Obj, GetBaseType (decls->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE));
/* line 220 "InitAllocate.puma" */
   if ((is_init)) {
/* line 221 "InitAllocate.puma" */
   dstmts = CombineACF (dstmts, tstmts);
   } else {
/* line 223 "InitAllocate.puma" */
   dstmts = CombineACF (tstmts, dstmts);
   }
   }
  }
   return dstmts;
 }

  }
/* line 231 "InitAllocate.puma" */
 {
  tDefinitions Obj;
  {
/* line 233 "InitAllocate.puma" */
   ObjScope = scope;
/* line 235 "InitAllocate.puma" */
   if ((var == NoTree)) {
/* line 235 "InitAllocate.puma" */
   line_number = decls->VAR_DECL.Line;
   }
/* line 237 "InitAllocate.puma" */
   Obj = GetCurrentObject (decls->VAR_DECL.Ident);
/* line 239 "InitAllocate.puma" */
   if (! ((IsStaticObject (Obj)))) goto yyL4;
  }
   return DerivTypeStmts (var, Obj, GetBaseType (decls->VAR_DECL.VAL));
 }
yyL4:;

  }
  if (decls->Kind == kTEMPLATE_DECL) {
/* line 244 "InitAllocate.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 246 "InitAllocate.puma" */
   line_number = decls->TEMPLATE_DECL.Line;
/* line 247 "InitAllocate.puma" */
   ObjScope = scope;
/* line 249 "InitAllocate.puma" */
   GetDspActions (GetCurrentObject (decls->TEMPLATE_DECL.Ident), & yyV1, & yyV2, & yyV3);
  }
   return MakeDspStmts (var, decls->TEMPLATE_DECL.Ident, decls->TEMPLATE_DECL.DIMENSIONS, yyV3, yyV1, yyV2);
 }

  }
  if (decls->Kind == kPROCESSORS_DECL) {
/* line 254 "InitAllocate.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 256 "InitAllocate.puma" */
   line_number = decls->PROCESSORS_DECL.Line;
/* line 257 "InitAllocate.puma" */
   ObjScope = scope;
/* line 259 "InitAllocate.puma" */
   GetDspActions (GetCurrentObject (decls->PROCESSORS_DECL.Ident), & yyV1, & yyV2, & yyV3);
  }
   return MakeDspStmts (var, decls->PROCESSORS_DECL.Ident, decls->PROCESSORS_DECL.DIMENSIONS, yyV3, yyV1, yyV2);
 }

  }
  if (decls->Kind == kRAGGED_DECL) {
/* line 264 "InitAllocate.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 266 "InitAllocate.puma" */
   line_number = decls->RAGGED_DECL.Line;
/* line 267 "InitAllocate.puma" */
   ObjScope = scope;
/* line 269 "InitAllocate.puma" */
   GetDspActions (GetCurrentObject (decls->RAGGED_DECL.Ident), & yyV1, & yyV2, & yyV3);
  }
   return MakeDspStmts (var, decls->RAGGED_DECL.Ident, decls->RAGGED_DECL.DIMENSIONS, yyV3, yyV1, yyV2);
 }

  }
/* line 274 "InitAllocate.puma" */
   return NoTree;

}

static tTree MakeDspStmts
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent id, register tTree indexes, register int kind, register rbool do_dsp, register rbool do_alloc)
# else
(var, id, indexes, kind, do_dsp, do_alloc)
 register tTree var;
 register tIdent id;
 register tTree indexes;
 register int kind;
 register rbool do_dsp;
 register rbool do_alloc;
# endif
{
/* line 289 "InitAllocate.puma" */
 {
  tTree stmt1;
  tTree stmt2;
  {
/* line 291 "InitAllocate.puma" */
   if (! ((is_init))) goto yyL1;
  {
/* line 296 "InitAllocate.puma" */
 stmt1 = NoTree;
     stmt2 = NoTree;

     if (do_dsp) 
        stmt1 = CreateDspStmt (var, id, indexes, kind);

     if (do_alloc)
        stmt2 = MakeAllocate (var, id, indexes);
   
  }
  }
   return CombineACF (stmt1, stmt2);
 }
yyL1:;

/* line 309 "InitAllocate.puma" */
 {
  tTree stmt1;
  tTree stmt2;
  {
/* line 314 "InitAllocate.puma" */
 stmt1 = NoTree;
     stmt2 = NoTree;

     if (do_dsp) 
        stmt1 = FreeDspStmt (var, id, kind);

     if (do_alloc)
        stmt2 = MakeDeallocate (var, id);
   
  }
   return CombineACF (stmt2, stmt1);
 }

}

static tTree DerivTypeStmts
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions obj, register tTree type)
# else
(var, obj, type)
 register tTree var;
 register tDefinitions obj;
 register tTree type;
# endif
{
/* line 338 "InitAllocate.puma" */
 {
  tDefinitions yyV1;
  tTree var_tree;
  tTree dsp_stmts;
  {
/* line 340 "InitAllocate.puma" */
   GetTypeInfo (type, & yyV1);
/* line 342 "InitAllocate.puma" */
   if (! ((yyV1 != NoObject))) goto yyL1;
  {
/* line 349 "InitAllocate.puma" */
   var_tree = MakeVariable (var, obj->Object.Ident);
/* line 350 "InitAllocate.puma" */
   dsp_stmts = BuildCompDspStmts (var_tree, type);
  }
  }
   return dsp_stmts;
 }
yyL1:;

/* line 355 "InitAllocate.puma" */
   return NoTree;

}

static void GetDspActions
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register rbool * yyP3, register rbool * yyP2, register int * yyP1)
# else
(obj, yyP3, yyP2, yyP1)
 register tDefinitions obj;
 register rbool * yyP3;
 register rbool * yyP2;
 register int * yyP1;
# endif
{
/* line 380 "InitAllocate.puma" */
 {
  rbool do_it;
  rbool do_alloc;
  int kind;
  {
/* line 386 "InitAllocate.puma" */
   CheckDspKind (obj);
/* line 388 "InitAllocate.puma" */
 kind     = GetDspKind (obj);
      do_it    = (kind != kNO_DSP);

      if (kind == kALLOCATE_DSP)
         do_alloc = MustBeAllocated (obj);
        else
         do_alloc = rfalse;
    
  }
   * yyP3 = do_it;
   * yyP2 = do_alloc;
   * yyP1 = kind;
   return;
 }

;
}

static rbool MustBeAllocated
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 409 "InitAllocate.puma" */
  {
/* line 411 "InitAllocate.puma" */
   if (! ((obj->VarObject.arr_kind != arr_allocatable))) goto yyL1;
  {
/* line 412 "InitAllocate.puma" */
   if (! ((obj->VarObject.arr_kind != arr_pointer))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static rbool InheritDescriptor
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int kind)
# else
(obj, kind)
 register tDefinitions obj;
 register int kind;
# endif
{
/* line 425 "InitAllocate.puma" */
  {
/* line 427 "InitAllocate.puma" */
   if (! ((safety == 0))) goto yyL1;
  {
/* line 428 "InitAllocate.puma" */
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 431 "InitAllocate.puma" */
  {
/* line 433 "InitAllocate.puma" */
   if (! ((safety == 0))) goto yyL2;
  {
/* line 434 "InitAllocate.puma" */
   if (! ((kind == kASSUMED_DSP))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapInherited) {
/* line 445 "InitAllocate.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static rbool IsStaticObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions var)
# else
(var)
 register tDefinitions var;
# endif
{
  if (var->Kind == kVarObject) {
  if (var->VarObject.Kind->Kind == kVarLocal) {
/* line 459 "InitAllocate.puma" */
  {
/* line 461 "InitAllocate.puma" */
   if (! ((var->VarObject.arr_kind != arr_pointer))) goto yyL1;
  {
/* line 462 "InitAllocate.puma" */
   if (! ((var->VarObject.arr_kind != arr_allocatable))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

static rbool StopDspAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 473 "InitAllocate.puma" */
  {
/* line 474 "InitAllocate.puma" */
   return rfalse;
  }

}

static tTree GetDspAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
/* line 487 "InitAllocate.puma" */
 {
  tTree dsp_stmts;
  {
/* line 491 "InitAllocate.puma" */
   line_number = t->ACF_BASIC.Line;
/* line 492 "InitAllocate.puma" */
   is_init = rtrue;
/* line 494 "InitAllocate.puma" */
   dsp_stmts = GetCompDspStatements (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS);
/* line 496 "InitAllocate.puma" */
 if (dsp_stmts != NoTree)

        { stmt_protocol ("new create dsp statements generated");
          tree_protocol ("stmts = \n", dsp_stmts);
        }
   
  }
   return CombineACF (t, dsp_stmts);
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
/* line 506 "InitAllocate.puma" */
 {
  tTree dsp_stmts;
  {
/* line 510 "InitAllocate.puma" */
   line_number = t->ACF_BASIC.Line;
/* line 511 "InitAllocate.puma" */
   is_init = rfalse;
/* line 513 "InitAllocate.puma" */
   dsp_stmts = GetCompDspStatements (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS);
/* line 515 "InitAllocate.puma" */
 if (dsp_stmts != NoTree)

        { stmt_protocol ("new free dsp statements generated");
          tree_protocol ("stmts = \n", dsp_stmts);
        }
   
  }
   return CombineACF (dsp_stmts, t);
 }

  }
  }
/* line 525 "InitAllocate.puma" */
   return t;

}

static tTree GetCompDspStatements
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
/* line 546 "InitAllocate.puma" */
  {
/* line 548 "InitAllocate.puma" */
   if (! ((is_init))) goto yyL1;
  }
   return CombineACF (GetCompDspStatements (params->BTP_LIST.Elem), GetCompDspStatements (params->BTP_LIST.Next));
yyL1:;

/* line 554 "InitAllocate.puma" */
   return CombineACF (GetCompDspStatements (params->BTP_LIST.Next), GetCompDspStatements (params->BTP_LIST.Elem));

  }
  if (params->Kind == kBTP_EMPTY) {
/* line 560 "InitAllocate.puma" */
   return NoTree;

  }
  if (params->Kind == kVAR_PARAM) {
/* line 565 "InitAllocate.puma" */
   return BuildCompDspStmts (params->VAR_PARAM.V, TreeType (params->VAR_PARAM.V));

  }
/* line 570 "InitAllocate.puma" */
  {
/* line 572 "InitAllocate.puma" */
   failure_protocol (MODULE, "GetCompDspStatements", params);
  }
   return NoTree;

}

static tTree BuildCompDspStmts
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree type)
# else
(var, type)
 register tTree var;
 register tTree type;
# endif
{
/* line 589 "InitAllocate.puma" */


int          i;    /* loop variable */
struct_shape shp;  /* will contain of var to create loops */

tTree  new_var;    /* var with loop variables */
tTree  dsp_stmts;  /* new created statements  */

/* line 598 "InitAllocate.puma" */
 {
  tDefinitions yyV1;
  {
/* line 600 "InitAllocate.puma" */
   GetTypeInfo (type, & yyV1);
/* line 602 "InitAllocate.puma" */
   if (! ((yyV1 != NoObject))) goto yyL1;
  {
/* line 606 "InitAllocate.puma" */
   new_var = MakeFullShape (CopyTree (var));
/* line 608 "InitAllocate.puma" */
 

     GetActualShape (new_var, &shp);

     for (i=0; i<shp.rank; i++) shp.perm[i] += loop_nest;

     loop_nest += shp.rank;

     if (shp.rank > 0)  SetActualShape (new_var, &shp);

     

     dsp_stmts = GetTypeDspStatements (new_var, yyV1);

     loop_nest -= shp.rank; 

   
/* line 627 "InitAllocate.puma" */
   if (! ((dsp_stmts != NoTree))) goto yyL1;
  {
/* line 629 "InitAllocate.puma" */
   dsp_stmts = MakeOuterLoops (line_number, & shp, CompleteACFs (dsp_stmts), GEN_DO_SERIAL);
  }
  }
  }
   return dsp_stmts;
 }
yyL1:;

/* line 637 "InitAllocate.puma" */
   return NoTree;

}

static tTree GetTypeDspStatements
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions t)
# else
(var, t)
 register tTree var;
 register tDefinitions t;
# endif
{
  if (t->Kind == kTypeObject) {
  if (t->TypeObject.decl->Kind == kTYPE_DECL) {
  if (t->TypeObject.decl->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
/* line 652 "InitAllocate.puma" */
 {
  tTree stmt_list;
  {
/* line 657 "InitAllocate.puma" */
   stmt_list = GetDspStatements (var, t->TypeObject.decl->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS, t->TypeObject.Components);
  }
   return stmt_list;
 }

  }
  }
  }
/* line 662 "InitAllocate.puma" */
  {
/* line 664 "InitAllocate.puma" */
   failure_protocol (MODULE, "GetTypeDspStatements", t->Object.decl);
  }
   return NoTree;

}

static tTree CreateDspStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent name, register tTree indexes, register int kind)
# else
(var, name, indexes, kind)
 register tTree var;
 register tIdent name;
 register tTree indexes;
 register int kind;
# endif
{
/* line 711 "InitAllocate.puma" */
 {
  tTree t;
  {
/* line 713 "InitAllocate.puma" */
   if (! ((InheritDescriptor (GetCurrentObject (name), kind)))) goto yyL1;
  {
/* line 717 "InitAllocate.puma" */
 t = MakeVariable (var, name);
     t = mACF_BASIC (mINHERIT_DSP_STMT (t, indexes, kind, safety));
     LineACFNode (t, line_number);
   
  }
  }
   return t;
 }
yyL1:;

/* line 725 "InitAllocate.puma" */
 {
  tTree t;
  {
/* line 729 "InitAllocate.puma" */
 t = MakeVariable (var, name);
     t = mACF_BASIC (mCREATE_DSP_STMT (t, indexes, kind));
     LineACFNode (t, line_number);
   
  }
   return t;
 }

}

static tTree FreeDspStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent name, register int kind)
# else
(var, name, kind)
 register tTree var;
 register tIdent name;
 register int kind;
# endif
{
/* line 745 "InitAllocate.puma" */
  {
/* line 747 "InitAllocate.puma" */
   if (! ((InheritDescriptor (GetCurrentObject (name), kind)))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 752 "InitAllocate.puma" */
 {
  tTree t;
  {
/* line 756 "InitAllocate.puma" */
 t = MakeVariable (var, name);
     t = mACF_BASIC (mFREE_DSP_STMT (t, kind));
     LineACFNode (t, line_number);
   
  }
   return t;
 }

}

static tTree MakeAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent name, register tTree indexes)
# else
(var, name, indexes)
 register tTree var;
 register tIdent name;
 register tTree indexes;
# endif
{
/* line 774 "InitAllocate.puma" */
 {
  tTree t;
  {
/* line 778 "InitAllocate.puma" */
 t = MakeVariable (var, name);
     t = mINDEXED_VAR (t, MakeExpList (indexes));
     t = mBTP_LIST (mVAR_PARAM (t), mBTP_EMPTY());
     t = mACF_BASIC (mALLOCATE_STMT (t, mDUMMY_VAR()));
     LineACFNode (t, line_number);
   
  }
   return t;
 }

}

static tTree MakeExpList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kSHAPE_LIST) {
/* line 798 "InitAllocate.puma" */
   return mBTE_LIST (MakeExpList (t->SHAPE_LIST.Elem), MakeExpList (t->SHAPE_LIST.Next));

  }
  if (t->Kind == kSHAPE_EMPTY) {
/* line 804 "InitAllocate.puma" */
   return mBTE_EMPTY ();

  }
  if (t->Kind == kEXPLICIT_SHAPE) {
/* line 811 "InitAllocate.puma" */
   return (mSLICE_EXP (CopyTree (t->EXPLICIT_SHAPE.LOWER), CopyTree (t->EXPLICIT_SHAPE.UPPER), mDUMMY_EXP ()));

  }
/* line 816 "InitAllocate.puma" */
  {
/* line 818 "InitAllocate.puma" */
   failure_protocol (MODULE, "MakeExpList", t);
  }
   return NoTree;

}

static tTree MakeDeallocate
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent name)
# else
(var, name)
 register tTree var;
 register tIdent name;
# endif
{
/* line 834 "InitAllocate.puma" */
 {
  tTree t;
  {
/* line 838 "InitAllocate.puma" */
 t = MakeVariable (var, name);
      t = mBTP_LIST (mVAR_PARAM (t), mBTP_EMPTY());
      t = mACF_BASIC (mDEALLOCATE_STMT (t, mDUMMY_VAR()));
      LineACFNode (t, line_number);
    
  }
   return t;
 }

}

static tTree MakeVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent name)
# else
(var, name)
 register tTree var;
 register tIdent name;
# endif
{
/* line 861 "InitAllocate.puma" */
 {
  tTree new;
  {
/* line 863 "InitAllocate.puma" */
   if (! ((var == NoTree))) goto yyL1;
  {
/* line 865 "InitAllocate.puma" */
   new = mVAR_OBJ (0, name);
/* line 867 "InitAllocate.puma" */
   SetObject (new);
/* line 868 "InitAllocate.puma" */
   new = mUSED_VAR (new);
  }
  }
   return new;
 }
yyL1:;

/* line 873 "InitAllocate.puma" */
 {
  tTree new;
  {
/* line 875 "InitAllocate.puma" */
   new = mREC_COMP (name);
/* line 877 "InitAllocate.puma" */
   SetObject (new);
/* line 878 "InitAllocate.puma" */
   new = mSELECTED_VAR (var, new);
  }
   return new;
 }

}

static void SetObject
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_OBJ) {
/* line 891 "InitAllocate.puma" */
  {
/* line 893 "InitAllocate.puma" */
 t->VAR_OBJ.Object = GetCurrentObject (t->VAR_OBJ.Ident); 
  }
   return;

  }
  if (t->Kind == kREC_COMP) {
/* line 896 "InitAllocate.puma" */
  {
/* line 898 "InitAllocate.puma" */
 t->REC_COMP.Object = GetDeclEntry (t->REC_COMP.Ident, ObjScope); 

     if (t->REC_COMP.Object == NoObject) 
        failure_protocol (MODULE, "SetObject", t);
   
  }
   return;

  }
/* line 905 "InitAllocate.puma" */
  {
/* line 907 "InitAllocate.puma" */
   failure_protocol (MODULE, "SetObject", t);
  }
   return;

;
}

static tDefinitions GetCurrentObject
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 912 "InitAllocate.puma" */
 {
  tDefinitions obj;
  {
/* line 916 "InitAllocate.puma" */
   obj = GetDeclEntry (name, ObjScope);
/* line 918 "InitAllocate.puma" */

     if (obj == NoObject) 
        failure_protocol (MODULE, "SetObject", NoTree);
   
  }
   return obj;
 }

}

static void GetTypeInfo
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tDefinitions * yyP4)
# else
(type, yyP4)
 register tTree type;
 register tDefinitions * yyP4;
# endif
{
  if (type->Kind == kTYPE_ID) {
  if (type->TYPE_ID.ID->TYPE_OBJ.Object->Kind == kTypeObject) {
/* line 936 "InitAllocate.puma" */
   * yyP4 = type->TYPE_ID.ID->TYPE_OBJ.Object;
   return;

  }
  }
/* line 939 "InitAllocate.puma" */
   * yyP4 = NoObject;
   return;

;
}

void BeginInitAllocate ARGS ((void))
{
}

void CloseInitAllocate ARGS ((void))
{
}
