# include "IndexShapes.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 38 "IndexShapes.puma" */

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "Expressions.h"    /* AddConstant */

# define MODULE "IndexShapes"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyIndexShapes.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* IndexShapes_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module IndexShapes, routine %s failed\n",
  yyFunction);
 IndexShapes_Exit ();
}

tTree FindShapeExp ARGS ((tTree actual, tTree fstart, tTree fstop, tTree finc, tTree exp));
tTree MakeSliceSize ARGS ((tTree fstart, tTree fstop, tTree finc));
static tTree IndexSub ARGS ((tTree exp, tTree sub));
static tTree IndexAdd ARGS ((tTree exp, tTree add));
tTree IndexDivMult ARGS ((tTree exp, tTree divisor, tTree mult));
static tTree ConstIndexDivMult ARGS ((tTree exp, int divisor, int mult));
static void GetIncrement ARGS ((tTree inc, rbool * found, int * val));
static rbool IsOneIncrement ARGS ((tTree t));

tTree FindShapeExp
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree fstart, register tTree fstop, register tTree finc, register tTree exp)
# else
(actual, fstart, fstop, finc, exp)
 register tTree actual;
 register tTree fstart;
 register tTree fstop;
 register tTree finc;
 register tTree exp;
# endif
{
  if (actual->Kind == kSLICE_EXP) {
/* line 85 "IndexShapes.puma" */
 {
  tTree newexp;
  {
/* line 89 "IndexShapes.puma" */
 

     newexp = exp;

     newexp = IndexSub (newexp, fstart);           

     newexp = IndexDivMult (newexp, finc, actual->SLICE_EXP.INC);   

     newexp = IndexAdd (newexp, actual->SLICE_EXP.FIRST);           

   
  }
   return newexp;
 }

  }
/* line 104 "IndexShapes.puma" */
  {
/* line 106 "IndexShapes.puma" */
   failure_protocol (MODULE, "FindShapeExp", actual);
  }
   return exp;

}

tTree MakeSliceSize
# if defined __STDC__ | defined __cplusplus
(register tTree fstart, register tTree fstop, register tTree finc)
# else
(fstart, fstop, finc)
 register tTree fstart;
 register tTree fstop;
 register tTree finc;
# endif
{
/* line 120 "IndexShapes.puma" */
 {
  tTree newexp;
  {
/* line 124 "IndexShapes.puma" */
 newexp = IndexSub (fstop , fstart);
     newexp = IndexDivMult (newexp, finc, NoTree);
     newexp = AddConstant (newexp, 1);
   
  }
   return newexp;
 }

}

static tTree IndexSub
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree sub)
# else
(exp, sub)
 register tTree exp;
 register tTree sub;
# endif
{
/* line 140 "IndexShapes.puma" */

rbool found;
int  val;

/* line 145 "IndexShapes.puma" */
  {
/* line 146 "IndexShapes.puma" */
   GetIntConstValue (sub, & found, & val);
/* line 147 "IndexShapes.puma" */
   if (! ((found == rtrue))) goto yyL1;
  }
   return AddConstant (exp, - val);
yyL1:;

/* line 151 "IndexShapes.puma" */
   return mOP_EXP (mOP_MINUS (), exp, sub);

}

static tTree IndexAdd
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree add)
# else
(exp, add)
 register tTree exp;
 register tTree add;
# endif
{
/* line 176 "IndexShapes.puma" */

rbool found;
int  val;

 yyRecursion:
/* line 181 "IndexShapes.puma" */
  {
/* line 182 "IndexShapes.puma" */
   GetIntConstValue (add, & found, & val);
/* line 183 "IndexShapes.puma" */
   if (! ((found == rtrue))) goto yyL1;
  }
   return AddConstant (exp, val);
yyL1:;

  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
/* line 187 "IndexShapes.puma" */
  {
/* line 188 "IndexShapes.puma" */
   GetConstDifference (add, exp->OP_EXP.OPND2, & found, & val);
/* line 189 "IndexShapes.puma" */
   if (! ((found == rtrue))) goto yyL2;
  }
   return AddConstant (exp->OP_EXP.OPND1, val);
yyL2:;

/* line 193 "IndexShapes.puma" */
  {
/* line 194 "IndexShapes.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & found, & val);
/* line 195 "IndexShapes.puma" */
   if (! ((found == rtrue))) goto yyL3;
  }
   exp = exp->OP_EXP.OPND1;
   add = AddConstant (add, - val);
   goto yyRecursion;
yyL3:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
/* line 199 "IndexShapes.puma" */
  {
/* line 200 "IndexShapes.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & found, & val);
/* line 201 "IndexShapes.puma" */
   if (! ((found == rtrue))) goto yyL4;
  }
   exp = exp->OP_EXP.OPND1;
   add = AddConstant (add, val);
   goto yyRecursion;
yyL4:;

  }
  }
/* line 205 "IndexShapes.puma" */
   return mOP_EXP (mOP_PLUS (), exp, add);

}

tTree IndexDivMult
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree divisor, register tTree mult)
# else
(exp, divisor, mult)
 register tTree exp;
 register tTree divisor;
 register tTree mult;
# endif
{
/* line 221 "IndexShapes.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  {
/* line 222 "IndexShapes.puma" */
   GetIncrement (divisor, & yyV1, & yyV2);
/* line 223 "IndexShapes.puma" */
   if (! ((yyV1 == rtrue))) goto yyL1;
  {
/* line 224 "IndexShapes.puma" */
   GetIncrement (mult, & yyV3, & yyV4);
/* line 225 "IndexShapes.puma" */
   if (! ((yyV3 == rtrue))) goto yyL1;
  }
  }
   return ConstIndexDivMult (exp, yyV2, yyV4);
 }
yyL1:;

/* line 231 "IndexShapes.puma" */
  {
/* line 232 "IndexShapes.puma" */
   if (! ((divisor != NoTree))) goto yyL2;
  {
/* line 233 "IndexShapes.puma" */
   if (! ((mult != NoTree))) goto yyL2;
  {
/* line 234 "IndexShapes.puma" */
   if (! ((EqualExpression (divisor, mult) == rtrue))) goto yyL2;
  }
  }
  }
   return exp;
yyL2:;

/* line 241 "IndexShapes.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 242 "IndexShapes.puma" */
   GetIncrement (divisor, & yyV1, & yyV2);
/* line 243 "IndexShapes.puma" */
   if (! ((yyV1 == rtrue))) goto yyL3;
  {
/* line 244 "IndexShapes.puma" */
   if (! ((yyV2 == 1))) goto yyL3;
  }
  }
   return mOP_EXP (mOP_TIMES (), exp, mult);
 }
yyL3:;

/* line 248 "IndexShapes.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 249 "IndexShapes.puma" */
   GetIncrement (mult, & yyV1, & yyV2);
/* line 250 "IndexShapes.puma" */
   if (! ((yyV1 == rtrue))) goto yyL4;
  {
/* line 251 "IndexShapes.puma" */
   if (! ((yyV2 == 1))) goto yyL4;
  }
  }
   return mOP_EXP (mOP_DIVIDE (), exp, divisor);
 }
yyL4:;

/* line 255 "IndexShapes.puma" */
   return mOP_EXP (mOP_TIMES (), mOP_EXP (mOP_DIVIDE (), exp, divisor), mult);

}

static tTree ConstIndexDivMult
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int divisor, register int mult)
# else
(exp, divisor, mult)
 register tTree exp;
 register int divisor;
 register int mult;
# endif
{
/* line 263 "IndexShapes.puma" */
  {
/* line 264 "IndexShapes.puma" */
   if (! (((mult % divisor) == 0))) goto yyL1;
  }
   return MultConstant (exp, mult / divisor);
yyL1:;

/* line 268 "IndexShapes.puma" */
  {
/* line 269 "IndexShapes.puma" */
   if (! (((divisor % mult) == 0))) goto yyL2;
  }
   return DivConstant (exp, divisor / mult);
yyL2:;

/* line 275 "IndexShapes.puma" */
   return MultConstant (DivConstant (exp, divisor), mult);

}

static void GetIncrement
# if defined __STDC__ | defined __cplusplus
(register tTree inc, register rbool * found, register int * val)
# else
(inc, found, val)
 register tTree inc;
 register rbool * found;
 register int * val;
# endif
{
/* line 287 "IndexShapes.puma" */
  {
/* line 288 "IndexShapes.puma" */
   if (! (IsOneIncrement (inc))) goto yyL1;
  }
   * found = rtrue;
   * val = 1;
   return;
yyL1:;

/* line 291 "IndexShapes.puma" */
 {
  rbool found1;
  int val1;
  {
/* line 296 "IndexShapes.puma" */
   GetIntConstValue (inc, & found1, & val1);
  }
   * found = found1;
   * val = val1;
   return;
 }

;
}

static rbool IsOneIncrement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 307 "IndexShapes.puma" */
  {
/* line 308 "IndexShapes.puma" */
   if (! ((t == NoTree))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (t->Kind == kDUMMY_EXP) {
/* line 311 "IndexShapes.puma" */
   return rtrue;

  }
  if (t->Kind == kCONST_EXP) {
  if (t->CONST_EXP.C->Kind == kINT_CONSTANT) {
  if (equalint (t->CONST_EXP.C->INT_CONSTANT.value, 1)) {
/* line 314 "IndexShapes.puma" */
   return rtrue;

  }
  }
  }
  return rfalse;
}

void BeginIndexShapes ARGS ((void))
{
}

void CloseIndexShapes ARGS ((void))
{
}
