# include "Independence.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 19 "Independence.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"
# include "Traverse.h"
# include "TreeOps.h"   /* TreeVarName */

# define MODULE "Independence"

static tTree global_red_vars;
static tTree global_new_vars;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyIndependence.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Independence_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Independence, routine %s failed\n",
  yyFunction);
 Independence_Exit ();
}

void CheckIndependence ARGS ((tTree t));
static void SetExceptionVars ARGS ((tTree t));
static void SetReductionVars ARGS ((tTree t, tTree red_vars));
static void SetNewVars ARGS ((tTree t));
static void SetGlobalReductionVars ARGS ((tTree t));
static void AddGlobalNewVars ARGS ((tTree t));
static tTree AddVars ARGS ((tTree red_vars, tTree new_red_vars));
static tTree AddVarToList ARGS ((tTree varlist, tTree new_var));

void CheckIndependence
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 44 "Independence.puma" */
  {
/* line 46 "Independence.puma" */
   FullTraverseAST (t->BODY_NODE.STATS, SetExceptionVars);
  }
   return;

  }
/* line 49 "Independence.puma" */
  {
/* line 50 "Independence.puma" */
   failure_protocol (MODULE, "CheckIndepence", t);
  }
   return;

;
}

static void SetExceptionVars
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 55 "Independence.puma" */
  {
/* line 58 "Independence.puma" */
   SetNewVars (t);
/* line 60 "Independence.puma" */
   set_protocol_stmt (t);
/* line 61 "Independence.puma" */
   stmt_protocol ("Exception Vars");
/* line 62 "Independence.puma" */
   tree_protocol ("new variables : ", t->ACF_DO.DO_DEP_INFO->INDEP_INFO.new_vars);
/* line 63 "Independence.puma" */
   tree_protocol ("reduction variables : ", t->ACF_DO.DO_DEP_INFO->INDEP_INFO.red_vars);
  }
   return;

  }
  }
  if (t->Kind == kACF_REDUCTION) {
/* line 66 "Independence.puma" */
  {
/* line 68 "Independence.puma" */
   SetReductionVars (t, t->ACF_REDUCTION.REDUCTION_VAR);
  }
   return;

  }
;
}

static void SetReductionVars
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree red_vars)
# else
(t, red_vars)
 register tTree t;
 register tTree red_vars;
# endif
{
/* line 81 "Independence.puma" */
  {
/* line 83 "Independence.puma" */
   global_red_vars = red_vars;
/* line 85 "Independence.puma" */
   FullTraverseAST (t, SetGlobalReductionVars);
  }
   return;

;
}

static void SetNewVars
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 95 "Independence.puma" */
  {
/* line 97 "Independence.puma" */
   global_new_vars = NoTree;
/* line 99 "Independence.puma" */
   FullTraverseAST (t, AddGlobalNewVars);
/* line 101 "Independence.puma" */
 t->ACF_DO.DO_DEP_INFO->INDEP_INFO.new_vars = global_new_vars; 
  }
   return;

  }
  }
/* line 104 "Independence.puma" */
  {
/* line 106 "Independence.puma" */
   failure_protocol (MODULE, "SetNewVars", t);
  }
   return;

;
}

static void SetGlobalReductionVars
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 117 "Independence.puma" */
  {
/* line 119 "Independence.puma" */
 t->ACF_DO.DO_DEP_INFO->INDEP_INFO.red_vars = AddVars (t->ACF_DO.DO_DEP_INFO->INDEP_INFO.red_vars, global_red_vars); 
  }
   return;

  }
  }
;
}

static void AddGlobalNewVars
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_NEW) {
/* line 130 "Independence.puma" */
  {
/* line 132 "Independence.puma" */
 global_new_vars = AddVars (global_new_vars, t->ACF_NEW.NEW_VAR); 
  }
   return;

  }
;
}

static tTree AddVars
# if defined __STDC__ | defined __cplusplus
(register tTree red_vars, register tTree new_red_vars)
# else
(red_vars, new_red_vars)
 register tTree red_vars;
 register tTree new_red_vars;
# endif
{
 yyRecursion:
  if (new_red_vars->Kind == kBTV_EMPTY) {
/* line 143 "Independence.puma" */
   return red_vars;

  }
  if (new_red_vars->Kind == kBTV_LIST) {
/* line 148 "Independence.puma" */
   red_vars = AddVarToList (red_vars, new_red_vars->BTV_LIST.Elem);
   new_red_vars = new_red_vars->BTV_LIST.Next;
   goto yyRecursion;

  }
/* line 153 "Independence.puma" */
  {
/* line 155 "Independence.puma" */
   failure_protocol (MODULE, "AddVars", new_red_vars);
  }
   return NoTree;

}

static tTree AddVarToList
# if defined __STDC__ | defined __cplusplus
(register tTree varlist, register tTree new_var)
# else
(varlist, new_var)
 register tTree varlist;
 register tTree new_var;
# endif
{
/* line 168 "Independence.puma" */
  {
/* line 170 "Independence.puma" */
   if (! ((varlist == NoTree))) goto yyL1;
  }
   return mBTV_LIST (CopyTree (new_var), mBTV_EMPTY ());
yyL1:;

  if (varlist->Kind == kBTV_EMPTY) {
/* line 175 "Independence.puma" */
   return mBTV_LIST (CopyTree (new_var), varlist);

  }
  if (varlist->Kind == kBTV_LIST) {
/* line 180 "Independence.puma" */
  {
/* line 182 "Independence.puma" */
   if (! ((TreeVarName (varlist->BTV_LIST.Elem) == TreeVarName (new_var)))) goto yyL3;
  }
   return varlist;
yyL3:;

/* line 187 "Independence.puma" */
  {
/* line 189 "Independence.puma" */
 varlist->BTV_LIST.Next = AddVarToList (varlist->BTV_LIST.Next, new_var); 
  }
   return varlist;

  }
/* line 194 "Independence.puma" */
  {
/* line 196 "Independence.puma" */
   failure_protocol (MODULE, "AddVarToList", varlist);
  }
   return NoTree;

}

void BeginIndependence ARGS ((void))
{
}

void CloseIndependence ARGS ((void))
{
}
