# include "IndShadow.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 33 "IndShadow.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Nesting.h"
# include "ParNest.h"

# include "Transform.h"
# include "Reductions.h"

# include "Objects.h"        /* GetVarShadow      */
# include "Types.h"          /* GetTreeType       */
# include "Temporary.h"      /* GetVDPtrTemporary */
# include "Distributions.h"  /* IsHPFDynamic      */
# include "Expansion.h"      /* FullExpansion     */

# define MODULE "IndShadow"

static int schedule_id = 0;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyIndShadow.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* IndShadow_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module IndShadow, routine %s failed\n",
  yyFunction);
 IndShadow_Exit ();
}

rbool IsIndShadowVariable ARGS ((tTree var, pvar home));
static rbool IndLastIndex ARGS ((tTree indexes));
static rbool HasDynamicOverlap ARGS ((tDefinitions obj, int rank));
static rbool IsDynOverlapDim ARGS ((tTree shadow_specs, int n));
static rbool IsDummyExp ARGS ((tTree exp));
void MakeIndShadowGet ARGS ((tTree var, tTree * yyP2, tTree * yyP1));
void MakeIndShadowPut ARGS ((tTree var, tTree * yyP4, tTree * yyP3));
void MakeIndShadowReduce ARGS ((tTree var, tTree red_fn, tTree * yyP6, tTree * yyP5));
static void GetLastIndexVar ARGS ((tTree indexes, tTree * yyP10, tTree * yyP9, tTree * yyP8, tTree * yyP7));
static tTree GetFullVar ARGS ((tTree tmp));

rbool IsIndShadowVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 70 "IndShadow.puma" */
 {
  var_descriptor vard;
  rbool okay;
  int i;
  int rank;
  {
/* line 79 "IndShadow.puma" */
   SetVarDescriptor (var, & vard);
/* line 84 "IndShadow.puma" */
 okay = rtrue;

     rank = vard.formal_rank;

     

     for (i=0; i<rank-1; i++)
        if (vard.distribution_kind[i] != kSERIAL_DIM) okay = rfalse;

     

     if (vard.distribution_kind[rank-1] == kSERIAL_DIM) okay = rfalse;

     

     if (okay)

        okay = HasDynamicOverlap (vard.var_obj, rank);

   
/* line 105 "IndShadow.puma" */
   if (! ((okay))) goto yyL1;
  {
/* line 109 "IndShadow.puma" */
   if (! ((IndLastIndex (var->INDEXED_VAR.IND_EXPS)))) goto yyL1;
  }
  }
   return rtrue;
 }
yyL1:;

  }
  return rfalse;
}

static rbool IndLastIndex
# if defined __STDC__ | defined __cplusplus
(register tTree indexes)
# else
(indexes)
 register tTree indexes;
# endif
{
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kVAR_EXP) {
  if (indexes->BTE_LIST.Elem->VAR_EXP.V->Kind == kINDEXED_VAR) {
  if (indexes->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 114 "IndShadow.puma" */
   return rtrue;

  }
  }
  }
/* line 117 "IndShadow.puma" */
  {
/* line 119 "IndShadow.puma" */
   if (! ((IndLastIndex (indexes->BTE_LIST.Next)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

static rbool HasDynamicOverlap
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int rank)
# else
(obj, rank)
 register tDefinitions obj;
 register int rank;
# endif
{
/* line 124 "IndShadow.puma" */
  {
/* line 126 "IndShadow.puma" */
   if (! ((IsHPFDynamic (obj)))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 129 "IndShadow.puma" */
  {
/* line 131 "IndShadow.puma" */
   if (! ((IsDynOverlapDim (GetVarShadow (obj), rank)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  return rfalse;
}

static rbool IsDynOverlapDim
# if defined __STDC__ | defined __cplusplus
(register tTree shadow_specs, register int n)
# else
(shadow_specs, n)
 register tTree shadow_specs;
 register int n;
# endif
{
/* line 136 "IndShadow.puma" */
  {
/* line 138 "IndShadow.puma" */
   if (! ((shadow_specs == NoTree))) goto yyL1;
  {
/* line 139 "IndShadow.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (shadow_specs->Kind == kSHADOW_LIST) {
/* line 142 "IndShadow.puma" */
  {
/* line 145 "IndShadow.puma" */
   if (! ((n == 1))) goto yyL2;
  {
/* line 146 "IndShadow.puma" */
   if (! ((IsDummyExp (shadow_specs->SHADOW_LIST.Elem->SHADOW_SPEC.SHADOW_RIGHT)))) goto yyL2;
  {
/* line 147 "IndShadow.puma" */
   if (! ((! IsDummyExp (shadow_specs->SHADOW_LIST.Elem->SHADOW_SPEC.SHADOW_LEFT)))) goto yyL2;
  }
  }
  }
   return rtrue;
yyL2:;

/* line 150 "IndShadow.puma" */
  {
/* line 152 "IndShadow.puma" */
   if (! ((n > 1))) goto yyL3;
  {
/* line 153 "IndShadow.puma" */
   if (! ((IsDynOverlapDim (shadow_specs->SHADOW_LIST.Next, n - 1)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

static rbool IsDummyExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kDUMMY_EXP) {
/* line 158 "IndShadow.puma" */
   return rtrue;

  }
  return rfalse;
}

void MakeIndShadowGet
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree * yyP2, register tTree * yyP1)
# else
(var, yyP2, yyP1)
 register tTree var;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 169 "IndShadow.puma" */
 {
  tTree create_stmt;
  tTree get_stmt;
  tTree free_stmt;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 175 "IndShadow.puma" */
   GetLastIndexVar (var->INDEXED_VAR.IND_EXPS, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 177 "IndShadow.puma" */
 schedule_id++;   

     create_stmt = mIND_SHADOW_CREATE (schedule_id,
                                       var->INDEXED_VAR.IND_VAR, yyV1, mDUMMY_VAR (), yyV2);

     create_stmt = mACF_BASIC (create_stmt);

     get_stmt    = mIND_SHADOW_GET (schedule_id, var->INDEXED_VAR.IND_VAR);
     get_stmt    = mACF_BASIC (get_stmt);

     create_stmt = mACF_LIST (create_stmt, mACF_LIST (get_stmt, NoTree));
     create_stmt = CombineACF (yyV3, create_stmt);

     free_stmt   = mIND_SHADOW_FREE (schedule_id, yyV2);

     free_stmt   = mACF_LIST (mACF_BASIC (free_stmt), NoTree);
     free_stmt   = CombineACF (free_stmt, yyV4);
   
  }
   * yyP2 = create_stmt;
   * yyP1 = free_stmt;
   return;
 }

  }
;
}

void MakeIndShadowPut
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree * yyP4, register tTree * yyP3)
# else
(var, yyP4, yyP3)
 register tTree var;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 205 "IndShadow.puma" */
 {
  tTree create_stmt;
  tTree put_stmt;
  tTree free_stmt;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 211 "IndShadow.puma" */
   GetLastIndexVar (var->INDEXED_VAR.IND_EXPS, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 213 "IndShadow.puma" */
 schedule_id++;   

     create_stmt = mIND_SHADOW_CREATE (schedule_id,
                                       var->INDEXED_VAR.IND_VAR, yyV1, mDUMMY_VAR (), yyV2);

     create_stmt = mACF_BASIC (create_stmt);
     create_stmt = mACF_LIST (create_stmt, NoTree);
     create_stmt = CombineACF (yyV3, create_stmt);

     put_stmt    = mIND_SHADOW_PUT (schedule_id, 0, var->INDEXED_VAR.IND_VAR);
     put_stmt    = mACF_BASIC (put_stmt);

     free_stmt   = mIND_SHADOW_FREE (schedule_id, yyV1);

     free_stmt   = mACF_LIST (mACF_BASIC (free_stmt), NoTree);
     free_stmt   = CombineACF (put_stmt, free_stmt);
     free_stmt   = CombineACF (free_stmt, yyV4);
   
  }
   * yyP4 = create_stmt;
   * yyP3 = free_stmt;
   return;
 }

  }
;
}

void MakeIndShadowReduce
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree red_fn, register tTree * yyP6, register tTree * yyP5)
# else
(var, red_fn, yyP6, yyP5)
 register tTree var;
 register tTree red_fn;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
  if (red_fn->Kind == kPROC_OBJ) {
/* line 241 "IndShadow.puma" */
 {
  tTree create_stmt;
  tTree set_stmt;
  tTree put_stmt;
  tTree free_stmt;
  int op;
  tTree init_val;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 250 "IndShadow.puma" */
   GetLastIndexVar (var->INDEXED_VAR.IND_EXPS, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 252 "IndShadow.puma" */
 schedule_id++;   

     create_stmt = mIND_SHADOW_CREATE (schedule_id, var->INDEXED_VAR.IND_VAR, 
                                       yyV1, mDUMMY_VAR (), yyV2);

     create_stmt = mACF_BASIC (create_stmt);

     init_val    = GetReductionZero (TreeType (var), red_fn->PROC_OBJ.Ident);
     set_stmt    = mIND_SHADOW_SET (schedule_id, var->INDEXED_VAR.IND_VAR, mCONST_EXP (init_val));
     set_stmt    = mACF_BASIC (set_stmt);

     op          = GetGlobalOp (TreeType(var), red_fn->PROC_OBJ.Ident);
     put_stmt    = mIND_SHADOW_PUT (schedule_id, op, var->INDEXED_VAR.IND_VAR);
     put_stmt    = mACF_BASIC (put_stmt);

     create_stmt = mACF_LIST (create_stmt, mACF_LIST (set_stmt, NoTree));
     create_stmt = CombineACF (yyV3, create_stmt);

     free_stmt   = mIND_SHADOW_FREE (schedule_id, yyV1);
     free_stmt   = mACF_BASIC (free_stmt);

     free_stmt   = mACF_LIST (put_stmt, mACF_LIST (free_stmt, NoTree));
     free_stmt   = CombineACF (free_stmt, yyV4);
   
  }
   * yyP6 = create_stmt;
   * yyP5 = free_stmt;
   return;
 }

  }
  }
/* line 278 "IndShadow.puma" */
  {
/* line 280 "IndShadow.puma" */
   failure_protocol (MODULE, "MakeIndShadowReduce", var);
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

;
}

static void GetLastIndexVar
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register tTree * yyP10, register tTree * yyP9, register tTree * yyP8, register tTree * yyP7)
# else
(indexes, yyP10, yyP9, yyP8, yyP7)
 register tTree indexes;
 register tTree * yyP10;
 register tTree * yyP9;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kVAR_EXP) {
  if (indexes->BTE_LIST.Elem->VAR_EXP.V->Kind == kINDEXED_VAR) {
  if (indexes->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 291 "IndShadow.puma" */
 {
  tTree pre;
  tTree post;
  tTree tmp;
  tTree var;
  var_descriptor vard;
  {
/* line 301 "IndShadow.puma" */
   SetVarDescriptor (indexes->BTE_LIST.Elem->VAR_EXP.V, & vard);
/* line 302 "IndShadow.puma" */
   FullExpansion (& vard);
/* line 306 "IndShadow.puma" */
 tmp = GetVDPtrTemporary (&vard);
     var = indexes->BTE_LIST.Elem->VAR_EXP.V->INDEXED_VAR.IND_VAR;

     if (tmp == NoTree)

        { error_protocol ("could not create temporary");
          pre  = NoTree;
          post = NoTree;
        }

      else

        { GetMemoryStmts (&pre, &post);
          pre = CombineACF (pre, NoTree);
          post = CombineACF (post, NoTree);
        }

      indexes->BTE_LIST.Elem->VAR_EXP.V = CopyTree (tmp);

      tmp  = GetFullVar (tmp);   
   
  }
   * yyP10 = var;
   * yyP9 = tmp;
   * yyP8 = pre;
   * yyP7 = post;
   return;
 }

  }
  }
  }
/* line 329 "IndShadow.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 331 "IndShadow.puma" */
   GetLastIndexVar (indexes->BTE_LIST.Next, & yyV1, & yyV2, & yyV3, & yyV4);
  }
   * yyP10 = yyV1;
   * yyP9 = yyV2;
   * yyP8 = yyV3;
   * yyP7 = yyV4;
   return;
 }

  }
/* line 334 "IndShadow.puma" */
  {
/* line 336 "IndShadow.puma" */
   failure_protocol (MODULE, "GetLastIndexVar", indexes);
  }
   * yyP10 = NoTree;
   * yyP9 = NoTree;
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

;
}

static tTree GetFullVar
# if defined __STDC__ | defined __cplusplus
(register tTree tmp)
# else
(tmp)
 register tTree tmp;
# endif
{
  if (tmp->Kind == kINDEXED_VAR) {
/* line 341 "IndShadow.puma" */
   return tmp->INDEXED_VAR.IND_VAR;

  }
/* line 346 "IndShadow.puma" */
   return tmp;

}

void BeginIndShadow ARGS ((void))
{
}

void CloseIndShadow ARGS ((void))
{
}
