# include "ImplMapping.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 26 "ImplMapping.puma" */


# include "Idents.h"
# include "StringM.h"

# include "protocol.h"
# include "SemMap.h"

# include "DefTable.h"

# include "Traverse.h"
# include "Objects.h"       /* IsTypeObj           */
# include "Types.h"         /* GetBaseType         */
# include "Nesting.h"       /* GetCurrentModel     */
# include "Rank.h"          /* to get the VarRank  */

# include "DerivedTypes.h"  /* IsExplicitlyMappedType */

# define MODULE "ImplMapping"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyImplMapping.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* ImplMapping_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ImplMapping, routine %s failed\n",
  yyFunction);
 ImplMapping_Exit ();
}

void ImplMapping ARGS ((tTree t));
static rbool Stop_IMPL_MAPPING ARGS ((tTree t));
static tTree Do_IMPL_MAPPING ARGS ((tTree t));
static tTree Do_SHARED_MAPPING ARGS ((tTree t));
static tTree AddNewDecls ARGS ((tTree obj_decl, tTree new_decl1, tTree new_decl2));
static void GetImplicitMapDecl ARGS ((tDefinitions obj, tTree * yyP1));
static void GetImplicitRangeDecl ARGS ((tDefinitions obj, tTree * yyP2));
static void GetImplicitSharedDecl ARGS ((tDefinitions obj, tTree * yyP3));
static void UpdateDecl ARGS ((tDefinitions obj, tTree new));
static rbool HasImplicitMapping ARGS ((tDefinitions obj));
static rbool HasDefaultRange ARGS ((tDefinitions obj));
static rbool HasDefaultShared ARGS ((tDefinitions obj));
static void GetImplicitMapping ARGS ((tDefinitions v, int * yyP4));
static void GetImplicitRange ARGS ((tDefinitions v, int * yyP5));
static void GetImplicitShared ARGS ((tDefinitions v, int * yyP6));
static rbool LegalSharedMapping ARGS ((tDefinitions spec));
static rbool HasInheritedAttribute ARGS ((tDefinitions d));
static tTree MakeDistributeDirective ARGS ((int kind, int rank));
static tTree MakeRangeDirective ARGS ((int kind, int rank));
static tTree MakeSharedDirective ARGS ((int kind));
static rbool IsCharacterArray ARGS ((tTree t));
static rbool IsMappedTypeArray ARGS ((tTree t));
static void SetMappingDirective ARGS ((tDefinitions obj, tTree decl));
static void MakeDeclMapping ARGS ((tDefinitions d, tTree decl));
static void SetRangeDirective ARGS ((tDefinitions obj, tTree decl));
static void MakeDeclRange ARGS ((tDefinitions d, tTree decl));
static void SetSharedDirective ARGS ((tDefinitions obj, tTree decl));
static void MakeDistributions ARGS ((tDefinitions t));
static void CheckDefaultObjects ARGS ((tDefinitions t));
static void EvalDistributedObjects ARGS ((tDefinitions t));
static void EvalAlignedObjects ARGS ((tDefinitions t));
static void EvalRangedObjects ARGS ((tDefinitions t));
static void VerifyMapping ARGS ((tDefinitions obj));

void ImplMapping
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMP_UNIT) {
/* line 58 "ImplMapping.puma" */
 {
  tTree result;
  {
/* line 62 "ImplMapping.puma" */
 t->COMP_UNIT.COMP_ELEMENTS = ReplaceAST (t->COMP_UNIT.COMP_ELEMENTS, Stop_IMPL_MAPPING, 
                                              Do_IMPL_MAPPING);

     if (shared_flag)

        t->COMP_UNIT.COMP_ELEMENTS = ReplaceAST (t->COMP_UNIT.COMP_ELEMENTS, Stop_IMPL_MAPPING, 
                                                 Do_SHARED_MAPPING);

     

     t->COMP_UNIT.USED_ELEMENTS   = ReplaceAST (t->COMP_UNIT.USED_ELEMENTS  , Stop_IMPL_MAPPING, 
                                              Do_IMPL_MAPPING);

     if (shared_flag)

        t->COMP_UNIT.USED_ELEMENTS   = ReplaceAST (t->COMP_UNIT.USED_ELEMENTS  , Stop_IMPL_MAPPING, 
                                                 Do_SHARED_MAPPING);

   
  }
   return;
 }

  }
;
}

static rbool Stop_IMPL_MAPPING
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_LIST) {
/* line 95 "ImplMapping.puma" */
   return rtrue;

  }
  if (t->Kind == kCOMMON_DECL) {
/* line 98 "ImplMapping.puma" */
   return rtrue;

  }
  return rfalse;
}

static tTree Do_IMPL_MAPPING
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 114 "ImplMapping.puma" */
  {
/* line 116 "ImplMapping.puma" */
   MakeDistributions (GetCurrentScope ());
  }
   return t;

  }
  if (t->Kind == kRECORD_TYPE) {
/* line 120 "ImplMapping.puma" */
 {
  tDefinitions tobj;
  {
/* line 126 "ImplMapping.puma" */
   tobj = GetLocalObject (t->RECORD_TYPE.Name);
/* line 128 "ImplMapping.puma" */
   MakeDistributions (tobj->TypeObject.Components);
  }
   return t;
 }

  }
  if (t->Kind == kVAR_DECL) {
/* line 132 "ImplMapping.puma" */
 {
  tDefinitions obj;
  tTree yyV1;
  tTree yyV2;
  {
/* line 136 "ImplMapping.puma" */
   obj = GetLocalObject (t->VAR_DECL.Ident);
/* line 138 "ImplMapping.puma" */
   GetImplicitMapDecl (obj, & yyV1);
/* line 139 "ImplMapping.puma" */
   GetImplicitRangeDecl (obj, & yyV2);
  }
   return AddNewDecls (t, yyV1, yyV2);
 }

  }
  if (t->Kind == kTEMPLATE_DECL) {
/* line 144 "ImplMapping.puma" */
 {
  tDefinitions obj;
  tTree yyV1;
  tTree yyV2;
  {
/* line 148 "ImplMapping.puma" */
   obj = GetLocalObject (t->TEMPLATE_DECL.Ident);
/* line 150 "ImplMapping.puma" */
   GetImplicitMapDecl (obj, & yyV1);
/* line 151 "ImplMapping.puma" */
   GetImplicitRangeDecl (obj, & yyV2);
  }
   return AddNewDecls (t, yyV1, yyV2);
 }

  }
/* line 156 "ImplMapping.puma" */
   return t;

}

static tTree Do_SHARED_MAPPING
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
/* line 174 "ImplMapping.puma" */
 {
  tDefinitions obj;
  tTree yyV1;
  {
/* line 178 "ImplMapping.puma" */
   obj = GetLocalObject (t->VAR_DECL.Ident);
/* line 180 "ImplMapping.puma" */
   GetImplicitSharedDecl (obj, & yyV1);
  }
   return AddNewDecls (t, NoTree, yyV1);
 }

  }
/* line 185 "ImplMapping.puma" */
   return t;

}

static tTree AddNewDecls
# if defined __STDC__ | defined __cplusplus
(register tTree obj_decl, register tTree new_decl1, register tTree new_decl2)
# else
(obj_decl, new_decl1, new_decl2)
 register tTree obj_decl;
 register tTree new_decl1;
 register tTree new_decl2;
# endif
{
/* line 199 "ImplMapping.puma" */
  {
/* line 201 "ImplMapping.puma" */
   if (! ((new_decl1 == NoTree))) goto yyL1;
  {
/* line 202 "ImplMapping.puma" */
   if (! ((new_decl2 == NoTree))) goto yyL1;
  }
  }
   return obj_decl;
yyL1:;

/* line 207 "ImplMapping.puma" */
 {
  tTree new_decls;
  {
/* line 211 "ImplMapping.puma" */
   new_decls = NoTree;
/* line 213 "ImplMapping.puma" */
   if ((new_decl2 != NoTree)) {
/* line 214 "ImplMapping.puma" */
   new_decls = mDECL_LIST (new_decl2, new_decls);
   }
/* line 216 "ImplMapping.puma" */
   if ((new_decl1 != NoTree)) {
/* line 217 "ImplMapping.puma" */
   new_decls = mDECL_LIST (new_decl1, new_decls);
   }
/* line 219 "ImplMapping.puma" */
   new_decls = mDECL_LIST (obj_decl, new_decls);
  }
   return new_decls;
 }

}

static void GetImplicitMapDecl
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree * yyP1)
# else
(obj, yyP1)
 register tDefinitions obj;
 register tTree * yyP1;
# endif
{
/* line 232 "ImplMapping.puma" */
 {
  tTree map_decl;
  int yyV1;
  {
/* line 236 "ImplMapping.puma" */
   if (! ((HasImplicitMapping (obj)))) goto yyL1;
  {
/* line 238 "ImplMapping.puma" */
   GetImplicitMapping (obj, & yyV1);
/* line 240 "ImplMapping.puma" */
   map_decl = MakeDistributeDirective (yyV1, VarRank (obj));
/* line 242 "ImplMapping.puma" */
   UpdateDecl (obj, map_decl);
/* line 244 "ImplMapping.puma" */
   SetMappingDirective (obj, map_decl);
/* line 246 "ImplMapping.puma" */
 if (map_decl != NoTree)
        tree_protocol ("new distribute directive :\n", map_decl);
   
  }
  }
   * yyP1 = map_decl;
   return;
 }
yyL1:;

/* line 251 "ImplMapping.puma" */
   * yyP1 = NoTree;
   return;

;
}

static void GetImplicitRangeDecl
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree * yyP2)
# else
(obj, yyP2)
 register tDefinitions obj;
 register tTree * yyP2;
# endif
{
/* line 262 "ImplMapping.puma" */
 {
  tTree range_decl;
  int yyV1;
  {
/* line 266 "ImplMapping.puma" */
   if (! ((HasDefaultRange (obj)))) goto yyL1;
  {
/* line 268 "ImplMapping.puma" */
   GetImplicitRange (obj, & yyV1);
/* line 270 "ImplMapping.puma" */
   range_decl = MakeRangeDirective (yyV1, VarRank (obj));
/* line 272 "ImplMapping.puma" */
   UpdateDecl (obj, range_decl);
/* line 274 "ImplMapping.puma" */
   SetRangeDirective (obj, range_decl);
/* line 276 "ImplMapping.puma" */
 if (range_decl != NoTree)
        tree_protocol ("new range directive : ", range_decl);
   
  }
  }
   * yyP2 = range_decl;
   return;
 }
yyL1:;

/* line 281 "ImplMapping.puma" */
   * yyP2 = NoTree;
   return;

;
}

static void GetImplicitSharedDecl
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree * yyP3)
# else
(obj, yyP3)
 register tDefinitions obj;
 register tTree * yyP3;
# endif
{
/* line 292 "ImplMapping.puma" */
 {
  tTree shared_decl;
  int yyV1;
  {
/* line 296 "ImplMapping.puma" */
   if (! ((HasDefaultShared (obj)))) goto yyL1;
  {
/* line 298 "ImplMapping.puma" */
   GetImplicitShared (obj, & yyV1);
/* line 300 "ImplMapping.puma" */
   shared_decl = MakeSharedDirective (yyV1);
/* line 302 "ImplMapping.puma" */
   UpdateDecl (obj, shared_decl);
/* line 304 "ImplMapping.puma" */
   SetSharedDirective (obj, shared_decl);
/* line 306 "ImplMapping.puma" */
 if (shared_decl != NoTree)
        tree_protocol ("new shared directive : ", shared_decl);
   
  }
  }
   * yyP3 = shared_decl;
   return;
 }
yyL1:;

/* line 311 "ImplMapping.puma" */
   * yyP3 = NoTree;
   return;

;
}

static void UpdateDecl
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree new)
# else
(obj, new)
 register tDefinitions obj;
 register tTree new;
# endif
{
/* line 324 "ImplMapping.puma" */
  {
/* line 326 "ImplMapping.puma" */
   if (! ((new == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (Tree_IsType (obj->Object.decl, kDECL_NODE)) {
  if (Tree_IsType (new, kDECL_NODE)) {
/* line 329 "ImplMapping.puma" */
  {
/* line 331 "ImplMapping.puma" */
 new->DECL_NODE.Ident = obj->Object.decl->DECL_NODE.Ident; new->DECL_NODE.Line = obj->Object.decl->DECL_NODE.Line; 
  }
   return;

  }
  }
;
}

static rbool HasImplicitMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapDefault) {
/* line 342 "ImplMapping.puma" */
  {
/* line 344 "ImplMapping.puma" */
   obj_protocol ("variable has default mapping", obj);
  }
   return rtrue;

  }
  }
  if (obj->Kind == kTemplateObject) {
  if (obj->TemplateObject.Dist->Mapping.spec->Kind == kMapDefault) {
/* line 347 "ImplMapping.puma" */
  {
/* line 349 "ImplMapping.puma" */
   obj_protocol ("template has default mapping", obj);
  }
   return rtrue;

  }
  }
  return rfalse;
}

static rbool HasDefaultRange
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.range->Kind == kRangeDefault) {
/* line 360 "ImplMapping.puma" */
  {
/* line 362 "ImplMapping.puma" */
   obj_protocol ("variable has default range", obj);
  }
   return rtrue;

  }
  }
  if (obj->Kind == kTemplateObject) {
  if (obj->TemplateObject.Dist->Mapping.range->Kind == kRangeDefault) {
/* line 365 "ImplMapping.puma" */
  {
/* line 367 "ImplMapping.puma" */
   obj_protocol ("template has default range", obj);
  }
   return rtrue;

  }
  }
  return rfalse;
}

static rbool HasDefaultShared
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 378 "ImplMapping.puma" */
  {
/* line 380 "ImplMapping.puma" */
   obj_protocol ("variable has default shared attribute", obj);
  }
   return rtrue;

  }
  return rfalse;
}

static void GetImplicitMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v, register int * yyP4)
# else
(v, yyP4)
 register tDefinitions v;
 register int * yyP4;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarCommon) {
/* line 402 "ImplMapping.puma" */
 {
  tDefinitions Obj;
  {
/* line 405 "ImplMapping.puma" */
   Obj = GetDeclEntry (v->VarObject.Kind->VarCommon.Block, GetCommonEntries ());
/* line 406 "ImplMapping.puma" */
   if (! ((Obj->CommonObject.sequence == 1))) goto yyL1;
  }
   * yyP4 = 0;
   return;
 }
yyL1:;

  }
/* line 413 "ImplMapping.puma" */
  {
/* line 415 "ImplMapping.puma" */
   if (! ((IsVarAssumedSize (v)))) goto yyL2;
  }
   * yyP4 = 0;
   return;
yyL2:;

/* line 422 "ImplMapping.puma" */
  {
/* line 424 "ImplMapping.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL3;
  }
   * yyP4 = 0;
   return;
yyL3:;

/* line 431 "ImplMapping.puma" */
  {
/* line 433 "ImplMapping.puma" */
   if (! ((VarRank (v) == 0))) goto yyL4;
  }
   * yyP4 = 0;
   return;
yyL4:;

/* line 442 "ImplMapping.puma" */
  {
/* line 444 "ImplMapping.puma" */
   if (! ((HasInheritedAttribute (v->VarObject.Dist)))) goto yyL5;
  }
   * yyP4 = 2;
   return;
yyL5:;

/* line 451 "ImplMapping.puma" */
  {
/* line 453 "ImplMapping.puma" */
   if (! ((IsCharacterArray (v->VarObject.decl)))) goto yyL6;
  }
   * yyP4 = 0;
   return;
yyL6:;

/* line 461 "ImplMapping.puma" */
  {
/* line 463 "ImplMapping.puma" */
   if (! ((IsVarAssumedShape (v)))) goto yyL7;
  {
/* line 464 "ImplMapping.puma" */
   if (! ((GetCurrentModel () == HPF_LOCAL))) goto yyL7;
  }
  }
   * yyP4 = 2;
   return;
yyL7:;

/* line 471 "ImplMapping.puma" */
  {
/* line 473 "ImplMapping.puma" */
   if (! ((ddefault_kind == DDEFAULT_REPLICATED))) goto yyL8;
  }
   * yyP4 = 0;
   return;
yyL8:;

/* line 481 "ImplMapping.puma" */
  {
/* line 483 "ImplMapping.puma" */
   if (! ((IsMappedTypeArray (v->VarObject.decl)))) goto yyL9;
  }
   * yyP4 = 0;
   return;
yyL9:;

/* line 490 "ImplMapping.puma" */
  {
/* line 492 "ImplMapping.puma" */
   if (! ((IsTypeObj (v->VarObject.in)))) goto yyL10;
  }
   * yyP4 = 0;
   return;
yyL10:;

/* line 499 "ImplMapping.puma" */
   * yyP4 = 1;
   return;

  }
  if (v->Kind == kTemplateObject) {
/* line 506 "ImplMapping.puma" */
  {
/* line 508 "ImplMapping.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL12;
  }
   * yyP4 = 0;
   return;
yyL12:;

/* line 515 "ImplMapping.puma" */
  {
/* line 517 "ImplMapping.puma" */
   if (! ((ddefault_kind == DDEFAULT_REPLICATED))) goto yyL13;
  }
   * yyP4 = 0;
   return;
yyL13:;

/* line 520 "ImplMapping.puma" */
   * yyP4 = 1;
   return;

  }
/* line 523 "ImplMapping.puma" */
   * yyP4 = 0;
   return;

;
}

static void GetImplicitRange
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v, register int * yyP5)
# else
(v, yyP5)
 register tDefinitions v;
 register int * yyP5;
# endif
{
  if (v->Kind == kVarObject) {
/* line 539 "ImplMapping.puma" */
  {
/* line 541 "ImplMapping.puma" */
   if (! ((v->VarObject.Dist->Mapping.dynamic))) goto yyL1;
  }
   * yyP5 = 2;
   return;
yyL1:;

  if (v->VarObject.Dist->Mapping.spec->Kind == kMapInherited) {
/* line 549 "ImplMapping.puma" */
   * yyP5 = 2;
   return;

  }
  }
  if (v->Kind == kTemplateObject) {
/* line 544 "ImplMapping.puma" */
  {
/* line 546 "ImplMapping.puma" */
   if (! ((v->TemplateObject.Dist->Mapping.dynamic))) goto yyL2;
  }
   * yyP5 = 2;
   return;
yyL2:;

  }
/* line 552 "ImplMapping.puma" */
   * yyP5 = 0;
   return;

;
}

static void GetImplicitShared
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v, register int * yyP6)
# else
(v, yyP6)
 register tDefinitions v;
 register int * yyP6;
# endif
{
  if (v->Kind == kVarObject) {
/* line 569 "ImplMapping.puma" */
  {
/* line 571 "ImplMapping.puma" */
   if (! ((shared_flag))) goto yyL1;
  {
/* line 573 "ImplMapping.puma" */
   if (! ((LegalSharedMapping (v->VarObject.Dist->Mapping.spec)))) goto yyL1;
  }
  }
   * yyP6 = 1;
   return;
yyL1:;

  }
/* line 576 "ImplMapping.puma" */
   * yyP6 = 0;
   return;

;
}

static rbool LegalSharedMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions spec)
# else
(spec)
 register tDefinitions spec;
# endif
{
  if (spec->Kind == kMapDist) {
/* line 581 "ImplMapping.puma" */
   return rtrue;

  }
  if (spec->Kind == kMapAlign) {
/* line 582 "ImplMapping.puma" */
   return rtrue;

  }
  if (spec->Kind == kMapDecl) {
/* line 583 "ImplMapping.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool HasInheritedAttribute
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d)
# else
(d)
 register tDefinitions d;
# endif
{
  if (d->Mapping.spec->Kind == kMapInherited) {
/* line 593 "ImplMapping.puma" */
   return rtrue;

  }
  return rfalse;
}

static tTree MakeDistributeDirective
# if defined __STDC__ | defined __cplusplus
(register int kind, register int rank)
# else
(kind, rank)
 register int kind;
 register int rank;
# endif
{
/* line 608 "ImplMapping.puma" */

int i;
tTree decl;

/* line 613 "ImplMapping.puma" */
  {
/* line 615 "ImplMapping.puma" */
   if (! ((rank == 0))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 620 "ImplMapping.puma" */
  {
/* line 622 "ImplMapping.puma" */
   if (! ((kind == 0))) goto yyL2;
  {
/* line 624 "ImplMapping.puma" */
 

     decl = mDIST_EMPTY ();
     for (i=0; i<rank; i++)
        decl = mDIST_LIST (mSERIAL_DISTRIBUTION (), decl);

     decl = mNODE_DISTRIBUTION (0, decl);

     decl = mDISTRIBUTE_DECL (DefaultId(), 0, decl,
                              mDEFAULT_PROCESSOR_ARRAY());
   
  }
  }
   return decl;
yyL2:;

/* line 639 "ImplMapping.puma" */
  {
/* line 641 "ImplMapping.puma" */
   if (! ((kind == 1))) goto yyL3;
  {
/* line 643 "ImplMapping.puma" */
 

     decl = mDIST_EMPTY ();
     for (i=0; i<rank; i++)
        decl = mDIST_LIST (mBLOCK_DISTRIBUTION (mDUMMY_EXP()), decl);

     decl = mNODE_DISTRIBUTION (0, decl);

     decl = mDISTRIBUTE_DECL (DefaultId(), 0, decl,
                              mDEFAULT_PROCESSOR_ARRAY());
   
  }
  }
   return decl;
yyL3:;

/* line 658 "ImplMapping.puma" */
  {
/* line 660 "ImplMapping.puma" */
   if (! ((kind == 2))) goto yyL4;
  }
   return NoTree;
yyL4:;

/* line 665 "ImplMapping.puma" */
  {
/* line 667 "ImplMapping.puma" */
   failure_protocol (MODULE, "MakeDistributeDirective", NoTree);
  }
   return NoTree;

}

static tTree MakeRangeDirective
# if defined __STDC__ | defined __cplusplus
(register int kind, register int rank)
# else
(kind, rank)
 register int kind;
 register int rank;
# endif
{
/* line 682 "ImplMapping.puma" */

int i;
tTree decl;

/* line 687 "ImplMapping.puma" */
  {
/* line 689 "ImplMapping.puma" */
   if (! ((rank == 0))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 694 "ImplMapping.puma" */
  {
/* line 696 "ImplMapping.puma" */
   if (! ((kind == 0))) goto yyL2;
  }
   return NoTree;
yyL2:;

/* line 701 "ImplMapping.puma" */
  {
/* line 703 "ImplMapping.puma" */
   if (! ((rank > 0))) goto yyL3;
  {
/* line 704 "ImplMapping.puma" */
   if (! ((rank <= MAX_DIMENSIONS))) goto yyL3;
  {
/* line 706 "ImplMapping.puma" */
 

     decl = mDIST_EMPTY ();
     for (i=0; i<rank; i++)
        decl = mDIST_LIST (mANY_DIM_DISTRIBUTION (), decl);

     decl = mNODE_DISTRIBUTION (0, decl);

     decl = mRANGE_LIST (decl, mRANGE_EMPTY ());

     decl = mRANGE_DECL (DefaultId(), 0, decl);

   
  }
  }
  }
   return decl;
yyL3:;

 yyAbort ("MakeRangeDirective");
 { tTree yyDummy; return yyDummy; }
}

static tTree MakeSharedDirective
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
/* line 733 "ImplMapping.puma" */
  {
/* line 735 "ImplMapping.puma" */
   if (! ((kind == 0))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 740 "ImplMapping.puma" */
   return mSHARED_DECL (DefaultId (), 0, kind);

}

static rbool IsCharacterArray
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
/* line 753 "ImplMapping.puma" */
  {
/* line 754 "ImplMapping.puma" */
   if (! ((IsCharacterArray (GetBaseType (t->VAR_DECL.VAL))))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kVAR_PARAM_DECL) {
/* line 757 "ImplMapping.puma" */
  {
/* line 758 "ImplMapping.puma" */
   if (! ((IsCharacterArray (GetBaseType (t->VAR_PARAM_DECL.VAL))))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (t->Kind == kSTRING_TYPE) {
/* line 761 "ImplMapping.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool IsMappedTypeArray
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
/* line 772 "ImplMapping.puma" */
  {
/* line 774 "ImplMapping.puma" */
   if (! ((IsExplicitlyMappedType (GetBaseType (t->VAR_DECL.VAL))))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kVAR_PARAM_DECL) {
/* line 777 "ImplMapping.puma" */
  {
/* line 779 "ImplMapping.puma" */
   if (! ((IsExplicitlyMappedType (GetBaseType (t->VAR_PARAM_DECL.VAL))))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

static void SetMappingDirective
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree decl)
# else
(obj, decl)
 register tDefinitions obj;
 register tTree decl;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 796 "ImplMapping.puma" */
  {
/* line 798 "ImplMapping.puma" */
   MakeDeclMapping (obj->VarObject.Dist, decl);
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
/* line 801 "ImplMapping.puma" */
  {
/* line 803 "ImplMapping.puma" */
   MakeDeclMapping (obj->TemplateObject.Dist, decl);
  }
   return;

  }
/* line 806 "ImplMapping.puma" */
  {
/* line 808 "ImplMapping.puma" */
   obj_error_protocol ("internal distribute directive for illegal obj", obj);
/* line 809 "ImplMapping.puma" */
   failure_protocol (MODULE, "SetMappingDirective", decl);
  }
   return;

;
}

static void MakeDeclMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, register tTree decl)
# else
(d, decl)
 register tDefinitions d;
 register tTree decl;
# endif
{
  if (d->Mapping.spec->Kind == kMapDefault) {
/* line 820 "ImplMapping.puma" */
  {
/* line 822 "ImplMapping.puma" */
   if (! ((decl == NoTree))) goto yyL1;
  {
/* line 824 "ImplMapping.puma" */
 d->Mapping.spec = mMapReplicated (); 
  }
  }
   return;
yyL1:;

/* line 827 "ImplMapping.puma" */
  {
/* line 829 "ImplMapping.puma" */
 d->Mapping.spec = mMapDecl (decl); 
  }
   return;

  }
/* line 832 "ImplMapping.puma" */
  {
/* line 834 "ImplMapping.puma" */
   failure_protocol (MODULE, "MakeDeclMapping", decl);
  }
   return;

;
}

static void SetRangeDirective
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree decl)
# else
(obj, decl)
 register tDefinitions obj;
 register tTree decl;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 845 "ImplMapping.puma" */
  {
/* line 847 "ImplMapping.puma" */
   MakeDeclRange (obj->VarObject.Dist, decl);
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
/* line 850 "ImplMapping.puma" */
  {
/* line 852 "ImplMapping.puma" */
   MakeDeclRange (obj->TemplateObject.Dist, decl);
  }
   return;

  }
/* line 855 "ImplMapping.puma" */
  {
/* line 857 "ImplMapping.puma" */
   obj_error_protocol ("internal range directive for illegal obj", obj);
/* line 858 "ImplMapping.puma" */
   failure_protocol (MODULE, "SetRangeDirective", decl);
  }
   return;

;
}

static void MakeDeclRange
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, register tTree decl)
# else
(d, decl)
 register tDefinitions d;
 register tTree decl;
# endif
{
  if (d->Mapping.range->Kind == kRangeDefault) {
/* line 863 "ImplMapping.puma" */
  {
/* line 865 "ImplMapping.puma" */
   if (! ((decl == NoTree))) goto yyL1;
  {
/* line 867 "ImplMapping.puma" */
 d->Mapping.range = mRangeNone (); 
  }
  }
   return;
yyL1:;

/* line 870 "ImplMapping.puma" */
  {
/* line 872 "ImplMapping.puma" */
 d->Mapping.range = mRangeDecl (decl); 
  }
   return;

  }
/* line 875 "ImplMapping.puma" */
  {
/* line 877 "ImplMapping.puma" */
   failure_protocol (MODULE, "MakeDeclRange", NoTree);
  }
   return;

;
}

static void SetSharedDirective
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree decl)
# else
(obj, decl)
 register tDefinitions obj;
 register tTree decl;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 888 "ImplMapping.puma" */
  {
/* line 890 "ImplMapping.puma" */
   if (! ((decl == NoTree))) goto yyL1;
  {
/* line 892 "ImplMapping.puma" */
 obj->VarObject.Dist->Mapping.shared = kNOT_SHARED; 
  }
  }
   return;
yyL1:;

  if (decl->Kind == kSHARED_DECL) {
/* line 895 "ImplMapping.puma" */
  {
/* line 897 "ImplMapping.puma" */
 obj->VarObject.Dist->Mapping.shared = decl->SHARED_DECL.kind; 
  }
   return;

  }
  }
/* line 900 "ImplMapping.puma" */
  {
/* line 902 "ImplMapping.puma" */
   obj_error_protocol ("internal shared directive for illegal obj", obj);
/* line 903 "ImplMapping.puma" */
   failure_protocol (MODULE, "SetSharedDirective", decl);
  }
   return;

;
}

static void MakeDistributions
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
/* line 922 "ImplMapping.puma" */
  {
/* line 924 "ImplMapping.puma" */
   CheckDefaultObjects (t);
/* line 925 "ImplMapping.puma" */
   EvalDistributedObjects (t);
/* line 926 "ImplMapping.puma" */
   EvalAlignedObjects (t);
/* line 927 "ImplMapping.puma" */
   EvalRangedObjects (t);
  }
   return;

;
}

static void CheckDefaultObjects
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
 yyRecursion:
  if (t->Kind == kENTRY_LIST) {
/* line 938 "ImplMapping.puma" */
  {
/* line 940 "ImplMapping.puma" */
   VerifyMapping (t->ENTRY_LIST.Elem);
/* line 941 "ImplMapping.puma" */
   t = t->ENTRY_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kENTRY_EMPTY) {
/* line 944 "ImplMapping.puma" */
   return;

  }
;
}

static void EvalDistributedObjects
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
 yyRecursion:
  if (t->Kind == kENTRY_LIST) {
/* line 955 "ImplMapping.puma" */
  {
/* line 957 "ImplMapping.puma" */
   EvalDistributedObjects (t->ENTRY_LIST.Elem);
/* line 958 "ImplMapping.puma" */
   t = t->ENTRY_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kENTRY_EMPTY) {
/* line 961 "ImplMapping.puma" */
   return;

  }
  if (t->Kind == kVarObject) {
  if (t->VarObject.Dist->Mapping.spec->Kind == kMapDecl) {
  if (t->VarObject.Dist->Mapping.spec->MapDecl.decl->Kind == kDISTRIBUTE_DECL) {
/* line 964 "ImplMapping.puma" */
  {
/* line 966 "ImplMapping.puma" */
   EvalObjSpecMapping (t);
/* line 967 "ImplMapping.puma" */
   obj_protocol ("evaluated distribution : ", t);
  }
   return;

  }
  }
  }
  if (t->Kind == kTemplateObject) {
  if (t->TemplateObject.Dist->Mapping.spec->Kind == kMapDecl) {
  if (t->TemplateObject.Dist->Mapping.spec->MapDecl.decl->Kind == kDISTRIBUTE_DECL) {
/* line 970 "ImplMapping.puma" */
  {
/* line 972 "ImplMapping.puma" */
   EvalObjSpecMapping (t);
/* line 973 "ImplMapping.puma" */
   obj_protocol ("evaluated distribution : ", t);
  }
   return;

  }
  }
  }
;
}

static void EvalAlignedObjects
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
 yyRecursion:
  if (t->Kind == kENTRY_LIST) {
/* line 984 "ImplMapping.puma" */
  {
/* line 986 "ImplMapping.puma" */
   EvalAlignedObjects (t->ENTRY_LIST.Elem);
/* line 987 "ImplMapping.puma" */
   t = t->ENTRY_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kENTRY_EMPTY) {
/* line 990 "ImplMapping.puma" */
   return;

  }
  if (t->Kind == kVarObject) {
  if (t->VarObject.Dist->Mapping.spec->Kind == kMapDecl) {
  if (t->VarObject.Dist->Mapping.spec->MapDecl.decl->Kind == kALIGN_DECL) {
/* line 993 "ImplMapping.puma" */
  {
/* line 995 "ImplMapping.puma" */
   EvalObjSpecMapping (t);
/* line 996 "ImplMapping.puma" */
   obj_protocol ("evaluated alignment : ", t);
  }
   return;

  }
  }
  }
;
}

static void EvalRangedObjects
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
 yyRecursion:
  if (t->Kind == kENTRY_LIST) {
/* line 1007 "ImplMapping.puma" */
  {
/* line 1009 "ImplMapping.puma" */
   EvalRangedObjects (t->ENTRY_LIST.Elem);
/* line 1010 "ImplMapping.puma" */
   t = t->ENTRY_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kENTRY_EMPTY) {
/* line 1013 "ImplMapping.puma" */
   return;

  }
  if (t->Kind == kVarObject) {
  if (t->VarObject.Dist->Mapping.range->Kind == kRangeDecl) {
  if (t->VarObject.Dist->Mapping.range->RangeDecl.decl->Kind == kRANGE_DECL) {
/* line 1016 "ImplMapping.puma" */
  {
/* line 1018 "ImplMapping.puma" */
   EvalObjRangeMapping (t);
/* line 1019 "ImplMapping.puma" */
   obj_protocol ("evaluated range : ", t);
  }
   return;

  }
  }
  }
;
}

static void VerifyMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapDefault) {
/* line 1032 "ImplMapping.puma" */
  {
/* line 1034 "ImplMapping.puma" */
 obj->VarObject.Dist->Mapping.spec = mMapReplicated (); 
/* line 1036 "ImplMapping.puma" */
   goto yyL1;
  }
yyL1:;

  }
  if (obj->VarObject.Dist->Mapping.range->Kind == kRangeDefault) {
/* line 1039 "ImplMapping.puma" */
  {
/* line 1041 "ImplMapping.puma" */
 obj->VarObject.Dist->Mapping.range  = mRangeNone (); 
  }
   return;

  }
  }
;
}

void BeginImplMapping ARGS ((void))
{
}

void CloseImplMapping ARGS ((void))
{
}
