# include "ImplDefs.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 37 "ImplDefs.puma" */


# undef DEBUG

# include <stdlib.h>

# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "Transform.h"      /* MakeRealType, ... */
# include "Types.h"          /* IsDummyType       */
# include "Objects.h"        /* IsVarResult       */

# define MODULE "ImplDefs"

/*********************************************************************
*                                                                    * 
*    I M P L I C I T   T Y P E S   T A B L E                         * 
*                                                                    * 
*********************************************************************/

static tTree dummy_type = NoTree;
static tTree int_type   = NoTree;
static tTree real_type  = NoTree;    /* predefined types */

static int table_stack_top = -1;

typedef struct

    { tTree impl_table [26];   /* A - Z */

      rbool global_save_attribute;
      rbool global_public_attribute;
      rbool global_private_attribute;
      rbool global_sequence_attribute;
      rbool global_nosequence_attribute;

    } ImplicitTable;

tTree impl_table [26];   /* A - Z */

rbool global_save_attribute;
rbool global_public_attribute;
rbool global_private_attribute;
rbool global_sequence_attribute;
rbool global_nosequence_attribute;

#define MAX_TABLES 128
#define NO_TABLE ((ImplicitTable *) 0)

static ImplicitTable *table_stack [MAX_TABLES];

static void init_stack ()

{ int i;

  for (i=0; i<MAX_TABLES; i++) table_stack [i] = NO_TABLE;

} /* init_stack */

static void make_stack_entry (pos) 

int pos;

{ if (pos >= MAX_TABLES)

     failure_protocol (MODULE, "too high SUBPROGRAM nesting", NoTree);

  if (table_stack [pos] != NO_TABLE) return;  /* entry exists, reuse it */

  table_stack [pos] = (ImplicitTable *) malloc (sizeof(ImplicitTable));

} /* make_stack_entry */

        /*************************************************
        *  void push_context (ImplicitTable *table)      * 
        *************************************************/

static void push_context (table)

ImplicitTable *table;

{ int i;

  for (i=0; i<26; i++) 
      table->impl_table [i] = impl_table[i];

  table->global_save_attribute       = global_save_attribute;
  table->global_public_attribute     = global_public_attribute;
  table->global_private_attribute    = global_private_attribute;
  table->global_sequence_attribute   = global_sequence_attribute;
  table->global_nosequence_attribute = global_nosequence_attribute;

} /* push_context */

        /*************************************************
        *  void pop_context (ImplicitTable *table)       * 
        *************************************************/

static void pop_context (table)

ImplicitTable *table;

{ int i;

  for (i=0; i<26; i++) 
      impl_table [i] = table->impl_table[i];

  global_save_attribute       = table->global_save_attribute;
  global_public_attribute     = table->global_public_attribute;
  global_private_attribute    = table->global_private_attribute;
  global_sequence_attribute   = table->global_sequence_attribute;
  global_nosequence_attribute = table->global_nosequence_attribute;

} /* push_context */

static int check_impl_char (c)

char c;

{ return ( (c >= 'A') && (c <= 'Z') ); }



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyImplDefs.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* ImplDefs_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ImplDefs, routine %s failed\n",
  yyFunction);
 ImplDefs_Exit ();
}

void InitImplicitTable ARGS ((void));
void PushImplicitTable ARGS ((void));
void PopImplicitTable ARGS ((void));
void CharSetImplicitTable ARGS ((char first, char last, tTree val));
void SetImplicitTable ARGS ((tIdent first, tIdent last, tTree val));
static tTree GetImplicitTable ARGS ((tIdent name));
void CheckImplicitDecls ARGS ((tDefinitions t));
static tTree ReplaceDummyType ARGS ((tTree t, tTree newval));

void InitImplicitTable
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 173 "ImplDefs.puma" */
  {
/* line 175 "ImplDefs.puma" */
   real_type = MakeRealType (default_real_size);
/* line 176 "ImplDefs.puma" */
   int_type = MakeIntegerType (default_int_size);
/* line 177 "ImplDefs.puma" */
   dummy_type = mDUMMY_TYPE ();
/* line 179 "ImplDefs.puma" */
   table_stack_top = 0;
/* line 181 "ImplDefs.puma" */
   init_stack ();
  }
   return;

;
}

void PushImplicitTable
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 194 "ImplDefs.puma" */
  {
/* line 196 "ImplDefs.puma" */
 if (table_stack_top >= 0)

       { make_stack_entry (table_stack_top);

         

         push_context (table_stack[table_stack_top]);

       }

    table_stack_top++;

#ifdef DEBUG
    printf ("PushImplicitTable, stack_top = %d\n", table_stack_top);
#endif

    

    CharSetImplicitTable ('A','H', real_type);
    CharSetImplicitTable ('I','N', int_type);
    CharSetImplicitTable ('O','Z', real_type);
    global_save_attribute       = rfalse;
    global_public_attribute     = rfalse;
    global_private_attribute    = rfalse;
    global_sequence_attribute   = rfalse;
    global_nosequence_attribute = rfalse;
  
  }
   return;

;
}

void PopImplicitTable
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 227 "ImplDefs.puma" */
  {
/* line 229 "ImplDefs.puma" */
 if (table_stack_top > 0)

       pop_context (table_stack[table_stack_top-1]);
       
    table_stack_top--;

#ifdef DEBUG
    printf ("PopImplicitTable, stack_top = %d\n", table_stack_top);
#endif

  
  }
   return;

;
}

void CharSetImplicitTable
# if defined __STDC__ | defined __cplusplus
(register char first, register char last, register tTree val)
# else
(first, last, val)
 register char first;
 register char last;
 register tTree val;
# endif
{
/* line 252 "ImplDefs.puma" */
  {
/* line 254 "ImplDefs.puma" */
 char i;
    char m[100];
    if (!check_impl_char (first) || !check_impl_char (last))
      { sprintf (m, "Implicit Declaration: %c - %c not valid\\n",
                    first, last);
        simple_error_protocol (m);
      }
    for (i=first;i<=last;i++)
        impl_table[i-'A'] = val;
  
  }
   return;

;
}

void SetImplicitTable
# if defined __STDC__ | defined __cplusplus
(register tIdent first, register tIdent last, register tTree val)
# else
(first, last, val)
 register tIdent first;
 register tIdent last;
 register tTree val;
# endif
{
/* line 276 "ImplDefs.puma" */
  {
/* line 278 "ImplDefs.puma" */
 char cf, cl, name[100];
    GetString (first, name);
    cf = name[0];
    GetString (last, name);
    cl = name[0];
    CharSetImplicitTable (cf, cl, val);
  
  }
   return;

;
}

static tTree GetImplicitTable
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 289 "ImplDefs.puma" */
 {
  tTree t;
  {
/* line 293 "ImplDefs.puma" */
 char c, word[100];
     GetString (name, word);
     c = word[0];
     if (check_impl_char (c))
        t = impl_table[c-'A'];
      else
        t = dummy_type;
   
  }
   return t;
 }

}

void CheckImplicitDecls
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
/* line 312 "ImplDefs.puma" */
 
char string[50], msg[100]; 

 yyRecursion:
  if (t->Kind == kENTRY_LIST) {
/* line 316 "ImplDefs.puma" */
  {
/* line 318 "ImplDefs.puma" */
   CheckImplicitDecls (t->ENTRY_LIST.Elem);
/* line 319 "ImplDefs.puma" */
   t = t->ENTRY_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kENTRY_EMPTY) {
/* line 322 "ImplDefs.puma" */
   return;

  }
  if (Definitions_IsType (t, kObject)) {
/* line 325 "ImplDefs.puma" */
  {
/* line 327 "ImplDefs.puma" */
   if (! ((t->Object.private == Default))) goto yyL3;
  {
/* line 329 "ImplDefs.puma" */
 if (global_private_attribute)
         t->Object.private = Private; 
      else if (global_public_attribute)
         t->Object.private = Public;
   
/* line 335 "ImplDefs.puma" */
   goto yyL3;
  }
  }
yyL3:;

  }
  if (t->Kind == kVarObject) {
  if (t->VarObject.decl->Kind == kVAR_DECL) {
/* line 338 "ImplDefs.puma" */
  {
/* line 340 "ImplDefs.puma" */
   if (! ((IsDummyType (t->VarObject.decl->VAR_DECL.VAL)))) goto yyL4;
  {
/* line 342 "ImplDefs.puma" */
   set_protocol_stmt (t->VarObject.decl);
/* line 343 "ImplDefs.puma" */
   stmt_protocol ("implicitly defined variable");
/* line 345 "ImplDefs.puma" */
 t->VarObject.decl->VAR_DECL.VAL = ReplaceDummyType (t->VarObject.decl->VAR_DECL.VAL, GetImplicitTable (t->VarObject.Ident));
     GetString (t->VarObject.Ident, string);
     sprintf (msg, "var %s is implicitly defined, type = ",string);
     tree_warning_protocol (msg, t->VarObject.decl->VAR_DECL.VAL);
   
  }
  }
   return;
yyL4:;

  }
  if (t->VarObject.decl->Kind == kVAR_PARAM_DECL) {
/* line 352 "ImplDefs.puma" */
  {
/* line 354 "ImplDefs.puma" */
   if (! ((IsDummyType (t->VarObject.decl->VAR_PARAM_DECL.VAL)))) goto yyL5;
  {
/* line 355 "ImplDefs.puma" */
   if (! ((IsVarResult (t)))) goto yyL5;
  {
/* line 357 "ImplDefs.puma" */
 t->VarObject.decl->VAR_PARAM_DECL.VAL = ReplaceDummyType (t->VarObject.decl->VAR_PARAM_DECL.VAL, GetImplicitTable (t->VarObject.Ident));
     GetString (t->VarObject.Ident, string);
     sprintf (msg, "function result %s is implicitly defined, type = ",string);
     tree_warning_protocol (msg, t->VarObject.decl->VAR_PARAM_DECL.VAL);
   
  }
  }
  }
   return;
yyL5:;

/* line 364 "ImplDefs.puma" */
  {
/* line 366 "ImplDefs.puma" */
   if (! ((IsDummyType (t->VarObject.decl->VAR_PARAM_DECL.VAL)))) goto yyL6;
  {
/* line 368 "ImplDefs.puma" */
 t->VarObject.decl->VAR_PARAM_DECL.VAL = ReplaceDummyType (t->VarObject.decl->VAR_PARAM_DECL.VAL, GetImplicitTable (t->VarObject.Ident));
     GetString (t->VarObject.Ident, string);
     sprintf (msg, "dummy %s is implicitly defined, type = ",string);
     tree_warning_protocol (msg, t->VarObject.decl->VAR_PARAM_DECL.VAL);
   
  }
  }
   return;
yyL6:;

  }
  }
  if (t->Kind == kFuncObject) {
  if (t->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 375 "ImplDefs.puma" */
  {
/* line 378 "ImplDefs.puma" */
   if (! ((t->FuncObject.decl->FUNC_DECL.RESULT_ID == DefaultId ()))) goto yyL7;
  {
/* line 379 "ImplDefs.puma" */
   if (! ((IsDummyType (t->FuncObject.decl->FUNC_DECL.RESULT_TYPE)))) goto yyL7;
  {
/* line 381 "ImplDefs.puma" */
 t->FuncObject.decl->FUNC_DECL.RESULT_TYPE = ReplaceDummyType (t->FuncObject.decl->FUNC_DECL.RESULT_TYPE, GetImplicitTable (t->FuncObject.Ident));
     GetString (t->FuncObject.Ident, string);
     sprintf (msg, "function %s is implicitly defined, type = ",
                    string);
     tree_warning_protocol (msg, t->FuncObject.decl->FUNC_DECL.RESULT_TYPE);
   
  }
  }
  }
   return;
yyL7:;

/* line 389 "ImplDefs.puma" */
   return;

  }
  if (t->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
/* line 394 "ImplDefs.puma" */
  {
/* line 396 "ImplDefs.puma" */
   if (! ((IsDummyType (t->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE)))) goto yyL9;
  {
/* line 398 "ImplDefs.puma" */
 t->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE = ReplaceDummyType (t->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE, GetImplicitTable (t->FuncObject.Ident));
     GetString (t->FuncObject.Ident, string);
     sprintf (msg, "statement function %s is implicitly defined, type = ",
                    string);
     tree_warning_protocol (msg, t->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE);
   
  }
  }
   return;
yyL9:;

  }
  }
;
}

static tTree ReplaceDummyType
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree newval)
# else
(t, newval)
 register tTree t;
 register tTree newval;
# endif
{
  if (t->Kind == kDUMMY_TYPE) {
/* line 414 "ImplDefs.puma" */
   return newval;

  }
  if (t->Kind == kALIGN_TYPE) {
  if (newval->Kind == kDUMMY_TYPE) {
/* line 419 "ImplDefs.puma" */
   return int_type;

  }
/* line 424 "ImplDefs.puma" */
   return newval;

  }
  if (t->Kind == kARRAY_TYPE) {
  if (t->ARRAY_TYPE.ARRAY_COMP_TYPE->Kind == kDUMMY_TYPE) {
/* line 429 "ImplDefs.puma" */
   return mARRAY_TYPE (t->ARRAY_TYPE.ARRAY_INDEX_TYPES, newval);

  }
  }
/* line 433 "ImplDefs.puma" */
   return t;

}

void BeginImplDefs ARGS ((void))
{
}

void CloseImplDefs ARGS ((void))
{
}
