# include "HomeTraverse.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 23 "HomeTraverse.puma" */


# include <stdio.h>
# include "protocol.h"
# include "Tree.h"
# include "Idents.h"
# include "StringM.h"

# include "Transform.h"     /* ReplaceACF, ReplaceDECL */
# include "HomeDescriptor.h"

# define MODULE "HomeTraverse"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyHomeTraverse.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* HomeTraverse_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module HomeTraverse, routine %s failed\n",
  yyFunction);
 HomeTraverse_Exit ();
}

tTree HomeReplaceAST ARGS ((tTree t, pvar home, UserFunction1 visit));

tTree HomeReplaceAST
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar home, UserFunction1 visit)
# else
(t, home, visit)
 register tTree t;
 pvar home;
 UserFunction1 visit;
# endif
{
/* line 49 "HomeTraverse.puma" */
  {
/* line 51 "HomeTraverse.puma" */
   if (! ((t == NoTree))) goto yyL1;
  }
   return t;
yyL1:;


  switch (t->Kind) {
  case kACF_LIST:
/* line 61 "HomeTraverse.puma" */
 {
  tTree newacf;
  {
/* line 65 "HomeTraverse.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 67 "HomeTraverse.puma" */
 newacf = HomeReplaceAST (t->ACF_LIST.Elem, home, visit);     
     t->ACF_LIST.Next   = HomeReplaceAST (t->ACF_LIST.Next, home, visit);     
   
/* line 71 "HomeTraverse.puma" */
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
   return newacf;
 }

  case kACF_EMPTY:
/* line 76 "HomeTraverse.puma" */
   return t;

  case kACF_BASIC:
/* line 81 "HomeTraverse.puma" */
   return visit (t, home);

  case kACF_DUMMY:
/* line 86 "HomeTraverse.puma" */
   return visit (t, home);

  case kACF_WHILE:
/* line 91 "HomeTraverse.puma" */
  {
/* line 93 "HomeTraverse.puma" */
 t->ACF_WHILE.WHILE_BODY = HomeReplaceAST (t->ACF_WHILE.WHILE_BODY, home, visit); 
  }
   return visit (t, home);

  case kACF_DO:
  if (t->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
/* line 104 "HomeTraverse.puma" */
 {
  var_descriptor home_body;
  {
/* line 107 "HomeTraverse.puma" */
   if (! ((t->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var != NoTree))) goto yyL7;
  {
/* line 108 "HomeTraverse.puma" */
   if (! ((t->ACF_DO.DO_HOME_INFO->COMM_INFO.is_local))) goto yyL7;
  {
/* line 112 "HomeTraverse.puma" */
   SetVarDescriptor (t->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var, & home_body);
/* line 116 "HomeTraverse.puma" */
 t->ACF_DO.DO_BODY  = HomeReplaceAST (t->ACF_DO.DO_BODY, &home_body, visit); 
  }
  }
  }
   return visit (t, home);
 }
yyL7:;

  }
/* line 121 "HomeTraverse.puma" */
  {
/* line 123 "HomeTraverse.puma" */
 t->ACF_DO.DO_BODY  = HomeReplaceAST (t->ACF_DO.DO_BODY, home, visit); 
  }
   return visit (t, home);

  case kACF_FORALL:
/* line 128 "HomeTraverse.puma" */
  {
/* line 130 "HomeTraverse.puma" */
 t->ACF_FORALL.FORALL_BODY  = HomeReplaceAST (t->ACF_FORALL.FORALL_BODY, home, visit); 
  }
   return visit (t, home);

  case kACF_IF:
/* line 135 "HomeTraverse.puma" */
  {
/* line 137 "HomeTraverse.puma" */
 t->ACF_IF.THEN_PART = HomeReplaceAST (t->ACF_IF.THEN_PART, home, visit);
     t->ACF_IF.ELSE_PART = HomeReplaceAST (t->ACF_IF.ELSE_PART, home, visit);
   
  }
   return visit (t, home);

  case kACF_HOME:
  if (t->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
/* line 148 "HomeTraverse.puma" */
 {
  var_descriptor on_home;
  {
/* line 152 "HomeTraverse.puma" */
   SetVarDescriptor (t->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & on_home);
/* line 154 "HomeTraverse.puma" */
 t->ACF_HOME.HOME_BODY = HomeReplaceAST (t->ACF_HOME.HOME_BODY, &on_home, visit); 
  }
   return visit (t, home);
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_PROC_CLAUSE) {
/* line 163 "HomeTraverse.puma" */
 {
  var_descriptor on_home;
  {
/* line 167 "HomeTraverse.puma" */
   SetProcDescriptor (t->ACF_HOME.HOME_VAR->ON_PROC_CLAUSE.ON_PROC, & on_home);
/* line 169 "HomeTraverse.puma" */
 t->ACF_HOME.HOME_BODY = HomeReplaceAST (t->ACF_HOME.HOME_BODY, &on_home, visit); 
  }
   return visit (t, home);
 }

  }
  if (t->ACF_HOME.HOME_VAR->Kind == kON_HOST_CLAUSE) {
/* line 178 "HomeTraverse.puma" */
 {
  var_descriptor on_home;
  {
/* line 182 "HomeTraverse.puma" */
   MakeHostDescriptor (& on_home);
/* line 184 "HomeTraverse.puma" */
 t->ACF_HOME.HOME_BODY = HomeReplaceAST (t->ACF_HOME.HOME_BODY, &on_home, visit); 
  }
   return visit (t, home);
 }

  }
  break;
  case kACF_RESIDENT:
/* line 189 "HomeTraverse.puma" */
  {
/* line 191 "HomeTraverse.puma" */
 t->ACF_RESIDENT.RESIDENT_BODY = HomeReplaceAST (t->ACF_RESIDENT.RESIDENT_BODY, home, visit); 
  }
   return visit (t, home);

  case kACF_NEW:
/* line 196 "HomeTraverse.puma" */
  {
/* line 198 "HomeTraverse.puma" */
 t->ACF_NEW.NEW_BODY = HomeReplaceAST (t->ACF_NEW.NEW_BODY, home, visit); 
  }
   return visit (t, home);

  case kACF_REDUCTION:
/* line 203 "HomeTraverse.puma" */
  {
/* line 205 "HomeTraverse.puma" */
 t->ACF_REDUCTION.REDUCTION_BODY = HomeReplaceAST (t->ACF_REDUCTION.REDUCTION_BODY, home, visit); 
  }
   return visit (t, home);

  case kACF_TASK_REGION:
/* line 210 "HomeTraverse.puma" */
  {
/* line 212 "HomeTraverse.puma" */
 t->ACF_TASK_REGION.TASK_BODY = HomeReplaceAST (t->ACF_TASK_REGION.TASK_BODY, home, visit); 
  }
   return visit (t, home);

  }

/* line 217 "HomeTraverse.puma" */
  {
/* line 219 "HomeTraverse.puma" */
   failure_protocol (MODULE, "HomeReplaceAST", t);
  }
   return NoTree;

}

void BeginHomeTraverse ARGS ((void))
{
}

void CloseHomeTraverse ARGS ((void))
{
}
