# include "HomeTemps.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 44 "HomeTemps.puma" */


# undef DEBUG

# include "Idents.h"
# include "protocol.h"

# include "Descriptor.h"      /* PrintableDescriptorVar  */
# include "DefTable.h"        /* GetDefaultTopology      */

# include "TreeOps.h"
# include "Expressions.h"     /* ResolveExpression       */
# include "Nesting.h"         /* GetLoopId, ...          */
# include "ParNest.h"         /* GetParNestACF, ...      */
# include "MoveControl.h"
# include "Rank.h"
# include "HomeDescriptor.h"
# include "ExpDescriptor.h"
# include "Loops.h"           /* IsLoopInvariant         */

# define MODULE "HomeTemps"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyHomeTemps.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* HomeTemps_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module HomeTemps, routine %s failed\n",
  yyFunction);
 HomeTemps_Exit ();
}

void HomeTempVar ARGS ((tTree var, pvar home_vard, int intent, pvar new_var));
void FullHomeTemp ARGS ((tTree exp, pvar home_vard, pvar new_var));
static void FindHomeTempVar ARGS ((tTree var, pvar home_vard, int intent, pvar new_var));
static void ReplicateForHome ARGS ((pvar vard));
static void MakeNestDescriptor ARGS ((tTree var, int intent, pvar vard));
static void AddNewDimension ARGS ((tTree var, int intent, pvar vard, tTree loop));
static void AlignToHome ARGS ((pvar new_var, pvar home_var));
static void GetSourceAlignment ARGS ((tTree index, pvar home_var, int * yyP3, int * yyP2, int * yyP1));

void HomeTempVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home_vard, register int intent, pvar new_var)
# else
(var, home_vard, intent, new_var)
 register tTree var;
 pvar home_vard;
 register int intent;
 pvar new_var;
# endif
{
/* line 96 "HomeTemps.puma" */
  {
/* line 98 "HomeTemps.puma" */
   if (! ((IsHostDescriptor (home_vard)))) goto yyL1;
  {
/* line 100 "HomeTemps.puma" */
   FullHomeTemp (var, home_vard, new_var);
  }
  }
   return;
yyL1:;

/* line 103 "HomeTemps.puma" */
  {
/* line 105 "HomeTemps.puma" */
   FindHomeTempVar (var, home_vard, intent, new_var);
/* line 107 "HomeTemps.puma" */
 
#ifdef DEBUG
    printf ("FindHomeTempVar :  var = ");
    FileUnparse (stdout, var);
    printf (" , home = ");
    FileUnparse (stdout, PrintableDescriptorVar (home_vard));
    printf (", intent = %d, is: \n", intent);
    PrintVarDescriptor (new_var);
#endif
  
/* line 118 "HomeTemps.puma" */
   SetExpType (var, new_var);
/* line 122 "HomeTemps.puma" */
   if ((! VDIsOwner (home_vard, new_var))) {
/* line 124 "HomeTemps.puma" */
   error_protocol ("illegal new variable created (not local)");
/* line 125 "HomeTemps.puma" */
   tree_protocol ("var = ", var);
/* line 126 "HomeTemps.puma" */
   tree_protocol ("home = ", PrintableDescriptorVar (home_vard));
/* line 127 "HomeTemps.puma" */
   tree_protocol ("new_var = ", PrintableDescriptorVar (new_var));
   }
/* line 131 "HomeTemps.puma" */
 
#ifdef DEBUG
    printf ("made sure that it is owner\n");
    PrintVarDescriptor (new_var);
#endif
  
/* line 138 "HomeTemps.puma" */
   if ((! VDIsSingleOwner (home_vard, new_var))) {
   }
/* line 144 "HomeTemps.puma" */
   if ((new_var -> actual_rank != TreeRank (var))) {
/* line 148 "HomeTemps.puma" */
   error_protocol ("illegal new variable created (rank problem)");
/* line 149 "HomeTemps.puma" */
   tree_protocol ("var = ", var);
/* line 150 "HomeTemps.puma" */
   tree_protocol ("home = ", PrintableDescriptorVar (home_vard));
/* line 151 "HomeTemps.puma" */
   tree_protocol ("new_var = ", PrintableDescriptorVar (new_var));
   }
/* line 155 "HomeTemps.puma" */

#ifdef DEBUG
    printf ("end of HomeTempVar\n");
    PrintVarDescriptor (new_var);
#endif
  
  }
   return;

;
}

void FullHomeTemp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar home_vard, pvar new_var)
# else
(exp, home_vard, new_var)
 register tTree exp;
 pvar home_vard;
 pvar new_var;
# endif
{
/* line 184 "HomeTemps.puma" */
  {
/* line 186 "HomeTemps.puma" */
   MakeNestDescriptor (exp, IntentInOut, new_var);
/* line 188 "HomeTemps.puma" */
   AlignToHome (new_var, home_vard);
/* line 190 "HomeTemps.puma" */
   SetExpType (exp, new_var);
  }
   return;

;
}

static void FindHomeTempVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home_vard, register int intent, pvar new_var)
# else
(var, home_vard, intent, new_var)
 register tTree var;
 pvar home_vard;
 register int intent;
 pvar new_var;
# endif
{
/* line 203 "HomeTemps.puma" */
 {
  rbool found;
  {
/* line 205 "HomeTemps.puma" */
   if (! ((home_vard -> topology_rank == 0))) goto yyL1;
  {
/* line 209 "HomeTemps.puma" */
   GetVarDescriptor (var, & found, new_var);
/* line 210 "HomeTemps.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 212 "HomeTemps.puma" */
 new_var->topology_rank = 0;
    new_var->topology_obj  = GetDefaultTopology (0);

    if (!found)
       error_protocol ("no descriptor for replicated variable");
  
  }
  }
  }
   return;
 }
yyL1:;

/* line 220 "HomeTemps.puma" */
 {
  rbool found;
  {
/* line 222 "HomeTemps.puma" */
   if (! ((home_vard -> topology_rank == - 1))) goto yyL2;
  {
/* line 226 "HomeTemps.puma" */
   GetVarDescriptor (var, & found, new_var);
/* line 227 "HomeTemps.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 229 "HomeTemps.puma" */
   printf ("new var descriptor on HOST home : \n");
/* line 230 "HomeTemps.puma" */
   PrintVarDescriptor (new_var);
/* line 232 "HomeTemps.puma" */
 new_var->topology_rank = -1;
    new_var->topology_obj  = GetDefaultTopology (-1);
  
  }
  }
  }
   return;
 }
yyL2:;

/* line 237 "HomeTemps.puma" */
  {
/* line 239 "HomeTemps.puma" */
   if (! ((TreeRank (var) == 0))) goto yyL3;
  {
/* line 241 "HomeTemps.puma" */
   MakeNestDescriptor (var, intent, new_var);
/* line 243 "HomeTemps.puma" */
   AlignToHome (new_var, home_vard);
  }
  }
   return;
yyL3:;

/* line 246 "HomeTemps.puma" */
  {
/* line 248 "HomeTemps.puma" */
   if (! ((TreeRank (var) == 0))) goto yyL4;
  {
/* line 250 "HomeTemps.puma" */
 *new_var = *home_vard; 
/* line 252 "HomeTemps.puma" */
   ReplicateForHome (new_var);
  }
  }
   return;
yyL4:;

/* line 255 "HomeTemps.puma" */
  {
/* line 257 "HomeTemps.puma" */
 *new_var = *home_vard; 
  }
   return;

;
}

static void ReplicateForHome
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 268 "HomeTemps.puma" */
  {
/* line 270 "HomeTemps.puma" */
 int idim;

    for (idim=0; idim<vard->formal_rank; idim++)

       { int is_range;
          tTree lb, ub;


         lb = vard->actual_shape[idim][0];
         ub = vard->actual_shape[idim][1];

         if (lb != ub) is_range = 1;
           else if (TreeRank (lb) == 0) is_range = 1;
           else is_range = 0;

         if (is_range)

           { 

           }
 
       }
  
  }
   return;

;
}

static void MakeNestDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int intent, pvar vard)
# else
(var, intent, vard)
 register tTree var;
 register int intent;
 pvar vard;
# endif
{
/* line 316 "HomeTemps.puma" */
 {
  int dim;
  {
/* line 320 "HomeTemps.puma" */
   MakeReplicatedDescriptor (vard);
/* line 322 "HomeTemps.puma" */
/* line 322 "HomeTemps.puma" */
   dim = GetParNestingDepth ();
   while (dim >= 1) {
/* line 324 "HomeTemps.puma" */
   AddNewDimension (var, intent, vard, GetParNestACF (dim));
/* line 322 "HomeTemps.puma" */
   dim --;
   }
/* line 328 "HomeTemps.puma" */

#ifdef DEBUG
     printf ("MakeNestDescriptor of ");
     FileUnparse (stdout, var);
     printf (" intent = %d, is : \n", intent);
     PrintVarDescriptor (vard);
#endif
   
  }
   return;
 }

;
}

static void AddNewDimension
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int intent, pvar vard, register tTree loop)
# else
(var, intent, vard, loop)
 register tTree var;
 register int intent;
 pvar vard;
 register tTree loop;
# endif
{
/* line 340 "HomeTemps.puma" */
  {
/* line 342 "HomeTemps.puma" */
   if (! ((! IsCountLoop (loop)))) goto yyL1;
  }
   return;
yyL1:;

/* line 345 "HomeTemps.puma" */
  {
/* line 347 "HomeTemps.puma" */
   if (! ((intent == IntentIn))) goto yyL2;
  {
/* line 349 "HomeTemps.puma" */

#ifdef DEBUG
     printf ("read access "); FileUnparse (stdout, var);
     printf (" is for loop "); FileUnparse (stdout, GetLoopId (loop));
     if (LoopInvariantAddressing (var, loop))
        printf (" invariant addressing\n");
      else
        printf (" not invariant addressing\n");
#endif
   
/* line 360 "HomeTemps.puma" */
   if (! ((LoopInvariantAddressing (var, loop)))) goto yyL2;
  }
  }
   return;
yyL2:;

/* line 363 "HomeTemps.puma" */
  {
/* line 367 "HomeTemps.puma" */
   AddDescriptorDimension (vard, mVAR_EXP (GetLoopId (loop)), GetLoopSlice (loop), kSERIAL_DIM);
  }
   return;

;
}

static void AlignToHome
# if defined __STDC__ | defined __cplusplus
(pvar new_var, pvar home_var)
# else
(new_var, home_var)
 pvar new_var;
 pvar home_var;
# endif
{
/* line 383 "HomeTemps.puma" */
  {
/* line 385 "HomeTemps.puma" */
 int i;

#ifdef DEBUG
      printf ("align to home of new var descriptor\n");
      printf ("var descriptor is : \n");
      PrintVarDescriptor (new_var);
      printf ("home descriptor is : \n");
      PrintVarDescriptor (home_var);
#endif

      new_var->topology_obj  = home_var->topology_obj;
      new_var->topology_rank = home_var->topology_rank;
      new_var->template_obj  = home_var->template_obj;
      new_var->template_rank = home_var->template_rank;

      

      for (i=0; i<new_var->topology_rank; i++)

        { tTree on_val;

          new_var->on_index_dim[i] = 0; 
          new_var->on_temp_dim[i]  = home_var->on_temp_dim[i];
          new_var->on_kind[i]      = home_var->on_kind[i];
          new_var->on_size[i]      = home_var->on_size[i];

          on_val                   = home_var->on_val[i];
          if (on_val == NoTree)
             new_var->on_val[i]    = NoTree;  
            else if (TreeRank (on_val) == 0)
             
             new_var->on_val[i]    = NoTree;  
            else
             new_var->on_val[i]    = NoTree;  

          new_var->on_range[i][0]  = home_var->on_range[i][0];
          new_var->on_range[i][1]  = home_var->on_range[i][1];
        }

      

      for (i=0; i<new_var->formal_rank; i++)

      { int home_dim, home_mult, home_add;

        GetSourceAlignment (new_var->actual_shape[i][0], home_var,
                            &home_dim, &home_mult, &home_add);

#ifdef DEBUG
        printf ("index dim %d aligned to home, dim %d, mult = %d, add = %d\n",
                 i+1, home_dim, home_mult, home_add);
#endif

        if (home_dim > 0)

        { int kind;
          tTree size;
          int top_dim, temp_dim;
          int add, mult;

          kind     = home_var->distribution_kind [home_dim-1];
          size     = home_var->distribution_size [home_dim-1];
          top_dim  = home_var->topology_dim [home_dim-1];
          temp_dim = home_var->template_dim [home_dim-1];
          mult     = home_var->align_mult   [home_dim-1];
          add      = home_var->align_add    [home_dim-1];

          new_var->distribution_kind[i] = kind;
          new_var->distribution_size[i] = size;
          new_var->topology_dim     [i] = top_dim;
          new_var->template_dim     [i] = temp_dim;

          

          new_var->align_mult       [i] = home_mult * mult;
          new_var->align_add        [i] = mult * home_add + add;
 
          new_var->formal_shape [i][0] = home_var->formal_shape[home_dim-1][0];
          new_var->formal_shape [i][0] = home_var->formal_shape[home_dim-1][0];

          if (top_dim > 0)

           { new_var->on_index_dim [top_dim-1]    = i + 1;
             new_var->on_temp_dim  [top_dim-1]    = temp_dim;
             new_var->on_kind      [top_dim-1]    = kind;
             new_var->on_size      [top_dim-1]    = size;
             new_var->on_val       [top_dim-1]    = NoTree;
             new_var->on_range     [top_dim-1][0] = new_var->formal_shape[i][0];
             new_var->on_range     [top_dim-1][1] = new_var->formal_shape[i][1];
           }

        }  

      }

#ifdef DEBUG
    printf ("new var descriptor is : \n");
    PrintVarDescriptor (new_var);
#endif

    
  }
   return;

;
}

static void GetSourceAlignment
# if defined __STDC__ | defined __cplusplus
(register tTree index, pvar home_var, register int * yyP3, register int * yyP2, register int * yyP1)
# else
(index, home_var, yyP3, yyP2, yyP1)
 register tTree index;
 pvar home_var;
 register int * yyP3;
 register int * yyP2;
 register int * yyP1;
# endif
{
/* line 494 "HomeTemps.puma" */
 {
  int home_dim;
  int home_mult;
  int home_add;
  int i;
  {
/* line 502 "HomeTemps.puma" */
 home_dim = 0;
 
     for (i=0; i<home_var->formal_rank; i++)

       { rbool  found;
         int   mult, add;
         tTree var;
 
         ResolveExpression (home_var->actual_shape[i][0],
                            &found, &mult, &add, &var);

         if (found && mult)

           { if (TreeVarName (var) == TreeVarName (index))

              { home_dim = i+1;
                home_mult = mult;
                home_add  = add;
              }

           }  

       }  

   
  }
   * yyP3 = home_dim;
   * yyP2 = home_mult;
   * yyP1 = home_add;
   return;
 }

;
}

void BeginHomeTemps ARGS ((void))
{
}

void CloseHomeTemps ARGS ((void))
{
}
