# include "HomeDescriptor.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 51 "HomeDescriptor.puma" */


#undef DEBUG

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "DefTable.h"

# include "Expressions.h"        /* ResolveExpression */
# include "Nesting.h"            /* GetOuterLoop, ... */
# include "ParNest.h"            /* GetOuterLoop, ... */
# include "Extraction.h"
# include "MoveDescriptor.h"
# include "Loops.h"
# include "Rank.h"
# include "Distributions.h"
# include "TreeOps.h"
# include "Descriptor.h"
# include "Unparse.h"

# define MODULE "HomeDescriptor"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyHomeDescriptor.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* HomeDescriptor_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module HomeDescriptor, routine %s failed\n",
  yyFunction);
 HomeDescriptor_Exit ();
}

void MakeNoDescriptor ARGS ((pvar vard));
void MakeReplicatedDescriptor ARGS ((pvar vard));
void MakeHostDescriptor ARGS ((pvar vard));
void MakeClauseDescriptor ARGS ((tTree home_clause, pvar vard));
void MakeParLoopNestDescriptor ARGS ((pvar vard));
static void AddParallelDimension ARGS ((pvar vard, tTree loop));
rbool IsNoDescriptor ARGS ((pvar vard));
rbool IsReplicatedDescriptor ARGS ((pvar vard));
rbool IsHostDescriptor ARGS ((pvar vard));
rbool IsProcDescriptor ARGS ((pvar vard));
rbool IsFictiveParDescriptor ARGS ((pvar vard));
rbool NoReplicationDescriptor ARGS ((pvar vard));
rbool IsFullLoopDescriptor ARGS ((pvar vard));
rbool IsParallelLoopDescriptor ARGS ((pvar home, tTree loop));
rbool IsParallelHomeDescriptor ARGS ((pvar d1));
static rbool DescriptorLinearDependency ARGS ((pvar d, tTree loop));
static rbool IsLinearDependent ARGS ((tTree exp, tTree id));
static rbool ResolveIsVariable ARGS ((tTree var));
rbool IsLoopInvariantDescriptor ARGS ((pvar vd, tTree loop));
static rbool AnyDependency ARGS ((tTree id, tTree exp));
void UnionHomeDescriptor ARGS ((pvar vard1, pvar vard2));
static void UnionTopDims ARGS ((pvar vard1, pvar vard2, int top_dim));
void MakeSerialDescriptor ARGS ((pvar home, rbool * yyP1));
rbool IsSerialDescriptor ARGS ((pvar home));

void MakeNoDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 88 "HomeDescriptor.puma" */
  {
/* line 90 "HomeDescriptor.puma" */
 vard->formal_rank    = -1;
     vard->actual_rank    = 0;
     vard->var_tree       = NoTree;
     vard->var_obj        = NoObject;
     vard->reach_info     = NoTree;
     vard->shared         = 0;
     vard->template_rank  = 0;
     vard->template_obj   = NoObject;
     vard->topology_obj   = NoObject;
     vard->topology_rank  = 0;
     vard->type_kind      = kDUMMY_TYPE;
     vard->type_size      = 0;
     vard->expanded       = rfalse;
   
  }
   return;

;
}

void MakeReplicatedDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 116 "HomeDescriptor.puma" */
  {
/* line 118 "HomeDescriptor.puma" */
 vard->formal_rank    = 0;
     vard->actual_rank    = 0;
     vard->var_tree       = NoTree;
     vard->var_obj        = NoObject;
     vard->shared         = 0;
     vard->topology_obj   = GetDefaultTopology (0);
     vard->topology_rank  = 0;
     vard->template_rank  = 0;
     vard->template_obj   = NoObject;
     vard->reach_info     = NoTree;
     vard->type_kind      = kDUMMY_TYPE;
     vard->type_size      = 0;
     vard->expanded       = rfalse;
   
  }
   return;

;
}

void MakeHostDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 144 "HomeDescriptor.puma" */
  {
/* line 146 "HomeDescriptor.puma" */
 vard->formal_rank    = 0;
     vard->actual_rank    = 0;
     vard->shared         = 0;
     vard->topology_obj   = GetDefaultTopology (-1);
     vard->topology_rank  = -1;
     vard->template_rank  = 0;
     vard->template_obj   = NoObject;
     vard->var_tree       = NoTree;
     vard->var_obj        = NoObject;
     vard->reach_info     = NoTree;
     vard->type_kind      = kDUMMY_TYPE;
     vard->type_size      = 0;
     vard->expanded       = rfalse;
   
  }
   return;

;
}

void MakeClauseDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree home_clause, pvar vard)
# else
(home_clause, vard)
 register tTree home_clause;
 pvar vard;
# endif
{
  if (home_clause->Kind == kON_VAR_CLAUSE) {
  if (home_clause->ON_VAR_CLAUSE.ON_VAR->Kind == kDUMMY_VAR) {
/* line 175 "HomeDescriptor.puma" */
  {
/* line 177 "HomeDescriptor.puma" */
   MakeReplicatedDescriptor (vard);
  }
   return;

  }
/* line 180 "HomeDescriptor.puma" */
  {
/* line 182 "HomeDescriptor.puma" */
   SetVarDescriptor (home_clause->ON_VAR_CLAUSE.ON_VAR, vard);
  }
   return;

  }
  if (home_clause->Kind == kON_PROC_CLAUSE) {
/* line 185 "HomeDescriptor.puma" */
  {
/* line 187 "HomeDescriptor.puma" */
   SetProcDescriptor (home_clause->ON_PROC_CLAUSE.ON_PROC, vard);
  }
   return;

  }
  if (home_clause->Kind == kON_HOST_CLAUSE) {
/* line 190 "HomeDescriptor.puma" */
  {
/* line 192 "HomeDescriptor.puma" */
   MakeHostDescriptor (vard);
  }
   return;

  }
  if (home_clause->Kind == kON_ALL_CLAUSE) {
/* line 195 "HomeDescriptor.puma" */
  {
/* line 197 "HomeDescriptor.puma" */
   MakeReplicatedDescriptor (vard);
  }
   return;

  }
/* line 200 "HomeDescriptor.puma" */
  {
/* line 202 "HomeDescriptor.puma" */
   failure_protocol (MODULE, "MakeClauseDescriptor", home_clause);
  }
   return;

;
}

void MakeParLoopNestDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 225 "HomeDescriptor.puma" */
  {
/* line 227 "HomeDescriptor.puma" */
   if (! ((OuterLoops () <= 0))) goto yyL1;
  {
/* line 229 "HomeDescriptor.puma" */
   MakeNoDescriptor (vard);
  }
  }
   return;
yyL1:;

/* line 232 "HomeDescriptor.puma" */
  {
/* line 234 "HomeDescriptor.puma" */
 int i;

     MakeReplicatedDescriptor (vard);

     for (i=1; i<=GetParNestingDepth (); i++)

       AddParallelDimension (vard, GetParNestACF (i));

   
  }
   return;

;
}

static void AddParallelDimension
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tTree loop)
# else
(vard, loop)
 pvar vard;
 register tTree loop;
# endif
{
/* line 247 "HomeDescriptor.puma" */
  {
/* line 249 "HomeDescriptor.puma" */
   if (! ((IsParallelLoop (loop)))) goto yyL1;
  {
/* line 250 "HomeDescriptor.puma" */
   if (! ((IsExtractableRange (GetLoopSlice (loop))))) goto yyL1;
  {
/* line 252 "HomeDescriptor.puma" */
   AddDescriptorDimension (vard, GetLoopId (loop), GetLoopSlice (loop), kBLOCK_DIM);
  }
  }
  }
   return;
yyL1:;

;
}

rbool IsNoDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 270 "HomeDescriptor.puma" */
  {
/* line 271 "HomeDescriptor.puma" */
   if (! ((vard -> formal_rank == - 1))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

rbool IsReplicatedDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 276 "HomeDescriptor.puma" */
  {
/* line 278 "HomeDescriptor.puma" */
   if (! ((SameTopologyObject (vard -> topology_obj, GetDefaultTopology (0))))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

rbool IsHostDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 283 "HomeDescriptor.puma" */
  {
/* line 284 "HomeDescriptor.puma" */
   if (! ((vard -> formal_rank == 0))) goto yyL1;
  {
/* line 285 "HomeDescriptor.puma" */
   if (! ((SameTopologyObject (vard -> topology_obj, GetDefaultTopology (- 1))))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  return rfalse;
}

rbool IsProcDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 290 "HomeDescriptor.puma" */
  {
/* line 291 "HomeDescriptor.puma" */
   if (! ((vard -> topology_obj == vard -> template_obj))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

rbool IsFictiveParDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 296 "HomeDescriptor.puma" */
  {
/* line 298 "HomeDescriptor.puma" */
   if (! ((vard -> template_obj == NoObject))) goto yyL1;
  {
/* line 299 "HomeDescriptor.puma" */
   if (! ((vard -> formal_rank > 0))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  return rfalse;
}

rbool NoReplicationDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 312 "HomeDescriptor.puma" */
 {
  int target_model;
  {
/* line 314 "HomeDescriptor.puma" */
   if (! ((IsReplicatedDescriptor (vard)))) goto yyL1;
  {
/* line 318 "HomeDescriptor.puma" */
   target_model = GetCurrentModel ();
/* line 320 "HomeDescriptor.puma" */
   if (! (((target_model == HPF_SERIAL) || (target_model == HPF_LOCAL)))) goto yyL1;
  }
  }
   return rtrue;
 }
yyL1:;

/* line 323 "HomeDescriptor.puma" */
  {
/* line 325 "HomeDescriptor.puma" */
   if (! ((IsReplicatedDescriptor (vard)))) goto yyL2;
  {
/* line 326 "HomeDescriptor.puma" */
   return rfalse;
  }
  }
yyL2:;

/* line 329 "HomeDescriptor.puma" */
  {
/* line 330 "HomeDescriptor.puma" */
   if (! ((IsHostDescriptor (vard)))) goto yyL3;
  }
   return rtrue;
yyL3:;

/* line 333 "HomeDescriptor.puma" */
  {
/* line 334 "HomeDescriptor.puma" */
   if (! ((vard -> topology_obj == NoObject))) goto yyL4;
  }
   return rtrue;
yyL4:;

/* line 337 "HomeDescriptor.puma" */
 {
  rbool no_replication;
  {
/* line 341 "HomeDescriptor.puma" */
 int  i;

     no_replication = rtrue;

     for (i=0; i < vard->topology_rank; i++)

       if (vard->on_val[i] == NoTree) no_replication = rfalse;

   
/* line 351 "HomeDescriptor.puma" */
   if (! ((no_replication))) goto yyL5;
  }
   return rtrue;
 }
yyL5:;

  return rfalse;
}

rbool IsFullLoopDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 359 "HomeDescriptor.puma" */
 {
  rbool okay;
  int dim;
  {
/* line 361 "HomeDescriptor.puma" */
   if (! ((vard -> var_tree == NoTree))) goto yyL1;
  {
/* line 362 "HomeDescriptor.puma" */
   if (! ((vard -> template_obj == NoObject))) goto yyL1;
  {
/* line 367 "HomeDescriptor.puma" */
 okay = rtrue;

     for (dim = 1; dim <= vard->formal_rank; dim++)

        { if (vard->actual_shape[dim-1][0] != vard->formal_shape[dim-1][0])
             okay = rfalse;
          if (vard->actual_shape[dim-1][1] != vard->formal_shape[dim-1][1])
             okay = rfalse;
          if (vard->actual_shape[dim-1][2] != NoTree)
             okay = rfalse;

        } 
   
/* line 381 "HomeDescriptor.puma" */
   if (! ((okay))) goto yyL1;
  }
  }
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

rbool IsParallelLoopDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar home, register tTree loop)
# else
(home, loop)
 pvar home;
 register tTree loop;
# endif
{
/* line 401 "HomeDescriptor.puma" */
  {
/* line 403 "HomeDescriptor.puma" */
   if (! ((DescriptorLinearDependency (home, loop)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

rbool IsParallelHomeDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar d1)
# else
(d1)
 pvar d1;
# endif
{
/* line 408 "HomeDescriptor.puma" */
 {
  rbool okay;
  int i;
  {
/* line 413 "HomeDescriptor.puma" */
 

#ifdef DEBUG
     printf ("check whether is home descriptor : \n");
     PrintVarDescriptor (d1);
#endif

     okay = rtrue;
     for (i=1; i <= OuterLoops(); i++)
       okay = okay && DescriptorLinearDependency (d1, GetOuterLoop(i));

   
/* line 426 "HomeDescriptor.puma" */
   if (! ((okay))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static rbool DescriptorLinearDependency
# if defined __STDC__ | defined __cplusplus
(pvar d, register tTree loop)
# else
(d, loop)
 pvar d;
 register tTree loop;
# endif
{
/* line 431 "HomeDescriptor.puma" */
  {
/* line 433 "HomeDescriptor.puma" */
   if (! ((! IsParallelLoop (loop)))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 436 "HomeDescriptor.puma" */
 {
  rbool okay;
  int i;
  tTree id;
  tTree index;
  {
/* line 443 "HomeDescriptor.puma" */
 okay = rfalse;
     id   = GetLoopId (loop);

     for (i=0; i<d->formal_rank; i++)

       { index = d->actual_shape[i][0];
         okay = okay || (IsLinearDependent (index, id));
#ifdef DEBUG
         FileUnparse (stdout, index);
         printf (" is linear dependent (okay = %d) for ", okay);
         FileUnparse (stdout, id); printf ("\n");
#endif
       }
   
/* line 457 "HomeDescriptor.puma" */
   if (! ((okay))) goto yyL2;
  }
   return rtrue;
 }
yyL2:;

  return rfalse;
}

static rbool IsLinearDependent
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree id)
# else
(exp, id)
 register tTree exp;
 register tTree id;
# endif
{
/* line 471 "HomeDescriptor.puma" */
  {
/* line 473 "HomeDescriptor.puma" */
   if (! ((exp == NoTree))) goto yyL1;
  {
/* line 475 "HomeDescriptor.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (exp->Kind == kREC_COMP) {
/* line 480 "HomeDescriptor.puma" */
  {
/* line 482 "HomeDescriptor.puma" */
   return rfalse;
  }

  }
/* line 485 "HomeDescriptor.puma" */
 {
  tTree var;
  int stride;
  int base;
  rbool found;
  {
/* line 492 "HomeDescriptor.puma" */
   ResolveExpression (exp, & found, & stride, & base, & var);
/* line 493 "HomeDescriptor.puma" */
   if (! ((found))) goto yyL3;
  {
/* line 494 "HomeDescriptor.puma" */
   if (! ((stride != 0))) goto yyL3;
  {
/* line 496 "HomeDescriptor.puma" */
   if (! ((ResolveIsVariable (var)))) goto yyL3;
  {
/* line 498 "HomeDescriptor.puma" */
   if (! ((TreeVarName (var) == TreeVarName (id)))) goto yyL3;
  }
  }
  }
  }
   return rtrue;
 }
yyL3:;

  return rfalse;
}

static rbool ResolveIsVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (Tree_IsType (var, kBT_VAR)) {
/* line 503 "HomeDescriptor.puma" */
   return rtrue;

  }
  if (var->Kind == kVAR_EXP) {
/* line 506 "HomeDescriptor.puma" */
   return rtrue;

  }
  if (var->Kind == kFUNC_CALL_EXP) {
/* line 509 "HomeDescriptor.puma" */
  {
/* line 510 "HomeDescriptor.puma" */
   return rfalse;
  }

  }
  return rfalse;
}

rbool IsLoopInvariantDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vd, register tTree loop)
# else
(vd, loop)
 pvar vd;
 register tTree loop;
# endif
{
/* line 532 "HomeDescriptor.puma" */
  {
/* line 534 "HomeDescriptor.puma" */
   if (! ((! IsCountLoop (loop)))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 537 "HomeDescriptor.puma" */
 {
  rbool okay;
  int i;
  tTree id;
  tTree index;
  {
/* line 544 "HomeDescriptor.puma" */
 okay = rtrue;

     id   = GetLoopId (loop);

     for (i=0; i < vd->formal_rank; i++)

       { index = vd->actual_shape[i][0];

         okay = okay && (!AnyDependency (id, index));
       }

   
/* line 557 "HomeDescriptor.puma" */
   if (! ((okay))) goto yyL2;
  }
   return rtrue;
 }
yyL2:;

  return rfalse;
}

static rbool AnyDependency
# if defined __STDC__ | defined __cplusplus
(register tTree id, register tTree exp)
# else
(id, exp)
 register tTree id;
 register tTree exp;
# endif
{
/* line 562 "HomeDescriptor.puma" */
  {
/* line 564 "HomeDescriptor.puma" */
   if (! ((exp == NoTree))) goto yyL1;
  {
/* line 566 "HomeDescriptor.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (exp->Kind == kREC_COMP) {
/* line 569 "HomeDescriptor.puma" */
  {
/* line 571 "HomeDescriptor.puma" */
   return rfalse;
  }

  }
/* line 574 "HomeDescriptor.puma" */
  {
/* line 576 "HomeDescriptor.puma" */
   if (! ((IsVarInExp (TreeVarName (id), exp)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  return rfalse;
}

void UnionHomeDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2)
# else
(vard1, vard2)
 pvar vard1;
 pvar vard2;
# endif
{
/* line 593 "HomeDescriptor.puma" */
  {
/* line 595 "HomeDescriptor.puma" */
   if (! ((VDIsSubSet (vard2, vard1)))) goto yyL1;
  }
   return;
yyL1:;

/* line 598 "HomeDescriptor.puma" */
  {
/* line 600 "HomeDescriptor.puma" */
   if (! ((VDIsSubSet (vard1, vard2)))) goto yyL2;
  {
/* line 602 "HomeDescriptor.puma" */
 *vard1 = *vard2; 
  }
  }
   return;
yyL2:;

/* line 613 "HomeDescriptor.puma" */
 {
  int top_dim;
  {
/* line 617 "HomeDescriptor.puma" */

#ifdef DEBUG
     printf ("Union of two homes\n");
     PrintVarDescriptor (vard1);
     PrintVarDescriptor (vard2);
#endif
   
/* line 625 "HomeDescriptor.puma" */
   if (! ((SameDescriptorTopology (vard1, vard2)))) goto yyL3;
  {
/* line 627 "HomeDescriptor.puma" */
   MakeTemplateDescriptor (vard1);
/* line 628 "HomeDescriptor.puma" */
   MakeTemplateDescriptor (vard2);
/* line 630 "HomeDescriptor.puma" */
 for (top_dim = 1; top_dim <= VarRank (vard1->topology_obj); top_dim ++)

        UnionTopDims (vard1, vard2, top_dim);

     vard1->var_tree = NoTree;

#ifdef DEBUG
     printf ("result of union is :\n");
     PrintVarDescriptor (vard1);
#endif

   
  }
  }
   return;
 }
yyL3:;

/* line 644 "HomeDescriptor.puma" */
  {
/* line 646 "HomeDescriptor.puma" */
   MakeReplicatedDescriptor (vard1);
  }
   return;

;
}

static void UnionTopDims
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2, register int top_dim)
# else
(vard1, vard2, top_dim)
 pvar vard1;
 pvar vard2;
 register int top_dim;
# endif
{
/* line 658 "HomeDescriptor.puma" */
 {
  int idim1;
  int idim2;
  {
/* line 663 "HomeDescriptor.puma" */
 idim1 = vard1->on_index_dim [top_dim-1];
     idim2 = vard2->on_index_dim [top_dim-1];

     

     if (idim1 == 0)

        { 

        }

       else if (idim2 == 0)

        { 

          ReplicateDescriptorDimension (vard1, idim1);

        }

       else

        { rbool found;
          int  diff;

          

          VDIsTopDimAligned (vard1, vard2, top_dim, &found, &diff);

          if (!found || (diff != 0))

             

             ReplicateDescriptorDimension (vard1, idim1);

         }
   
  }
   return;
 }

;
}

void MakeSerialDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar home, register rbool * yyP1)
# else
(home, yyP1)
 pvar home;
 register rbool * yyP1;
# endif
{
/* line 709 "HomeDescriptor.puma" */
  {
/* line 711 "HomeDescriptor.puma" */
   if (! ((IsHostDescriptor (home)))) goto yyL1;
  }
   * yyP1 = rtrue;
   return;
yyL1:;

/* line 714 "HomeDescriptor.puma" */
  {
/* line 716 "HomeDescriptor.puma" */
   if (! ((IsReplicatedDescriptor (home)))) goto yyL2;
  {
/* line 717 "HomeDescriptor.puma" */
   MakeHostDescriptor (home);
  }
  }
   * yyP1 = rtrue;
   return;
yyL2:;

/* line 720 "HomeDescriptor.puma" */
  {
/* line 722 "HomeDescriptor.puma" */
   if (! ((IsNoDescriptor (home)))) goto yyL3;
  {
/* line 723 "HomeDescriptor.puma" */
   MakeHostDescriptor (home);
  }
  }
   * yyP1 = rtrue;
   return;
yyL3:;

/* line 726 "HomeDescriptor.puma" */
  {
/* line 728 "HomeDescriptor.puma" */
   if (! ((home -> topology_obj == GetDefaultTopology (0)))) goto yyL4;
  {
/* line 729 "HomeDescriptor.puma" */
   MakeHostDescriptor (home);
  }
  }
   * yyP1 = rtrue;
   return;
yyL4:;

/* line 732 "HomeDescriptor.puma" */
 {
  rbool okay;
  {
/* line 736 "HomeDescriptor.puma" */
 int i;

     okay = rtrue;
     for (i=0; i<home->topology_rank; i++)

        { tTree val = home->on_val[i];

          if (val == NoTree)
             okay = rfalse;                  

           else if (TreeRank (home->on_val[i]) > 0)
             okay = rfalse;
        }
   
/* line 750 "HomeDescriptor.puma" */
   if (! ((okay))) goto yyL5;
  }
   * yyP1 = rtrue;
   return;
 }
yyL5:;

/* line 753 "HomeDescriptor.puma" */
  {
/* line 755 "HomeDescriptor.puma" */
   printf ("could not serialize : \n");
/* line 756 "HomeDescriptor.puma" */
   PrintVarDescriptor (home);
/* line 757 "HomeDescriptor.puma" */
   MakeTemplateDescriptor (home);
/* line 758 "HomeDescriptor.puma" */
   printf ("template : \n");
/* line 759 "HomeDescriptor.puma" */
   PrintVarDescriptor (home);
  }
   * yyP1 = rfalse;
   return;

;
}

rbool IsSerialDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar home)
# else
(home)
 pvar home;
# endif
{
/* line 776 "HomeDescriptor.puma" */
  {
/* line 778 "HomeDescriptor.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 781 "HomeDescriptor.puma" */
  {
/* line 783 "HomeDescriptor.puma" */
   if (! ((IsHostDescriptor (home)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 786 "HomeDescriptor.puma" */
  {
/* line 788 "HomeDescriptor.puma" */
   if (! ((IsNoDescriptor (home)))) goto yyL3;
  {
/* line 789 "HomeDescriptor.puma" */
   return rfalse;
  }
  }
yyL3:;

/* line 792 "HomeDescriptor.puma" */
  {
/* line 794 "HomeDescriptor.puma" */
   if (! ((home -> topology_obj == NoObject))) goto yyL4;
  {
/* line 795 "HomeDescriptor.puma" */
   if (! ((home -> template_inherited == 1))) goto yyL4;
  {
/* line 797 "HomeDescriptor.puma" */
   return rfalse;
  }
  }
  }
yyL4:;

/* line 800 "HomeDescriptor.puma" */
 {
  rbool okay;
  {
/* line 802 "HomeDescriptor.puma" */
   if (! ((home -> topology_obj != GetDefaultTopology (0)))) goto yyL5;
  {
/* line 806 "HomeDescriptor.puma" */
 int i;

     okay = rtrue;

     for (i=0; i<home->topology_rank; i++)

        { tTree val = home->on_val[i];

          if (val == NoTree)
             okay = rfalse;                  

           else if (TreeRank (home->on_val[i]) > 0)
             okay = rfalse;
        }
   
/* line 821 "HomeDescriptor.puma" */
   if (! ((okay))) goto yyL5;
  }
  }
   return rtrue;
 }
yyL5:;

  return rfalse;
}

void BeginHomeDescriptor ARGS ((void))
{
}

void CloseHomeDescriptor ARGS ((void))
{
}
