# include "GlobalComm.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 28 "GlobalComm.puma" */


# undef DEBUG

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "DefTable.h"
# include "Transform.h"

# include "VarDescriptor.h"
# include "HomeDescriptor.h"
# include "Distributions.h"
# include "Descriptor.h"

# include "IndShadow.h"   /* IsIndShadowVariable              */
# include "VectorMove.h"  /* MakeVectorVar                    */

# include "Ownership.h"   /* BetterOnSelection                */
# include "VarComm.h"     /* IsLocalVarRead, IsLocalVarWrite  */
# include "FArguments.h"  /* IsOnlyReadParam                  */

# include "Extraction.h"
# include "Nesting.h"
# include "ParNest.h"

# define MODULE "GlobalComm"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyGlobalComm.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* GlobalComm_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module GlobalComm, routine %s failed\n",
  yyFunction);
 GlobalComm_Exit ();
}

tTree GlobalCommunication ARGS ((tTree stmt));
static tTree ExtractGlobalComm ARGS ((tTree stmt, pvar home));
static tTree ExtractParamComm ARGS ((int line, tTree params, pvar home));
static tTree ExtractWriteVarComm ARGS ((int line, tTree var, pvar home));
static void ApplyHomeChange ARGS ((tTree stmts, pvar inner_home, pvar outer_home));
static tTree MakeBroadcast ARGS ((int line, tTree bc_vars));
static tTree ParameterBroadcast ARGS ((tTree p));
static tTree ControlSpecBroadcast ARGS ((tTree p));
static tTree ReadSpecBroadcast ARGS ((tTree p));
static tTree NameListVars ARGS ((tTree names));
static void VectorizeGlobalComm ARGS ((tTree stmts, pvar home, tTree id, tTree slice));
static void VectorizeVarList ARGS ((tTree vars, tTree id, tTree slice, rbool * yyP1));
static void SummarizeGlobalComm ARGS ((tTree stmts, pvar home, tTree loop));

tTree GlobalCommunication
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_HOME) {
/* line 72 "GlobalComm.puma" */
 {
  var_descriptor outer_home;
  {
/* line 76 "GlobalComm.puma" */
   MakeReplicatedDescriptor (& outer_home);
  }
   return ExtractGlobalComm (stmt, & outer_home);
 }

  }
/* line 81 "GlobalComm.puma" */
  {
/* line 83 "GlobalComm.puma" */
   failure_protocol (MODULE, "GlobalCommunication", stmt);
  }
   return NoTree;

}

static tTree ExtractGlobalComm
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar home)
# else
(stmt, home)
 register tTree stmt;
 pvar home;
# endif
{

  switch (stmt->Kind) {
  case kACF_HOME:
  if (stmt->ACF_HOME.HOME_VAR->Kind == kON_HOST_CLAUSE) {
/* line 102 "GlobalComm.puma" */
 {
  var_descriptor on_home;
  tTree global_comm;
  {
/* line 106 "GlobalComm.puma" */
   MakeHostDescriptor (& on_home);
/* line 110 "GlobalComm.puma" */
   IncParNesting (stmt);
/* line 112 "GlobalComm.puma" */
   global_comm = ExtractGlobalComm (stmt->ACF_HOME.HOME_BODY, & on_home);
/* line 114 "GlobalComm.puma" */
   DecParNesting (stmt);
/* line 118 "GlobalComm.puma" */
   ApplyHomeChange (global_comm, & on_home, home);
  }
   return global_comm;
 }

  }
  if (stmt->ACF_HOME.HOME_VAR->Kind == kON_PROC_CLAUSE) {
/* line 129 "GlobalComm.puma" */
 {
  var_descriptor on_home;
  tTree global_comm;
  {
/* line 133 "GlobalComm.puma" */
   SetProcDescriptor (stmt->ACF_HOME.HOME_VAR->ON_PROC_CLAUSE.ON_PROC, & on_home);
/* line 137 "GlobalComm.puma" */
   IncParNesting (stmt);
/* line 139 "GlobalComm.puma" */
   global_comm = ExtractGlobalComm (stmt->ACF_HOME.HOME_BODY, & on_home);
/* line 141 "GlobalComm.puma" */
   DecParNesting (stmt);
/* line 145 "GlobalComm.puma" */
   ApplyHomeChange (global_comm, & on_home, home);
  }
   return global_comm;
 }

  }
  if (stmt->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
/* line 156 "GlobalComm.puma" */
 {
  var_descriptor on_home;
  tTree global_comm;
  {
/* line 160 "GlobalComm.puma" */
   SetVarDescriptor (stmt->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & on_home);
/* line 164 "GlobalComm.puma" */
   IncParNesting (stmt);
/* line 166 "GlobalComm.puma" */
   global_comm = ExtractGlobalComm (stmt->ACF_HOME.HOME_BODY, & on_home);
/* line 168 "GlobalComm.puma" */
   DecParNesting (stmt);
/* line 172 "GlobalComm.puma" */
   ApplyHomeChange (global_comm, & on_home, home);
  }
   return global_comm;
 }

  }
  break;
  case kACF_LIST:
/* line 183 "GlobalComm.puma" */
   return (CombineACF (ExtractGlobalComm (stmt->ACF_LIST.Elem, home), ExtractGlobalComm (stmt->ACF_LIST.Next, home)));

  case kACF_EMPTY:
/* line 189 "GlobalComm.puma" */
   return NoTree;

  case kACF_DUMMY:
/* line 194 "GlobalComm.puma" */
   return NoTree;

  case kACF_IF:
/* line 199 "GlobalComm.puma" */
   return (CombineACF (ExtractGlobalComm (stmt->ACF_IF.THEN_PART, home), ExtractGlobalComm (stmt->ACF_IF.ELSE_PART, home)));

  case kACF_WHILE:
/* line 211 "GlobalComm.puma" */
 {
  tTree communication;
  {
/* line 215 "GlobalComm.puma" */
   communication = ExtractGlobalComm (stmt->ACF_WHILE.WHILE_BODY, home);
/* line 217 "GlobalComm.puma" */
 if (communication != NoTree)

         { set_protocol_stmt (stmt);
           error_protocol (
               "cannot extract global communication from DO WHILE loop");
           tree_protocol ("global communication : ", communication);
         }
    
  }
   return NoTree;
 }

  case kACF_DO:
  if (stmt->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
/* line 238 "GlobalComm.puma" */
 {
  var_descriptor body_home;
  tTree communication;
  {
/* line 242 "GlobalComm.puma" */
   SetVarDescriptor (stmt->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var, & body_home);
/* line 246 "GlobalComm.puma" */
   communication = ExtractGlobalComm (stmt->ACF_DO.DO_BODY, & body_home);
/* line 248 "GlobalComm.puma" */
   VectorizeGlobalComm (communication, & body_home, stmt->ACF_DO.DO_ID, stmt->ACF_DO.DO_RANGE);
  }
   return communication;
 }

  }
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 259 "GlobalComm.puma" */
 {
  tTree communication;
  {
/* line 263 "GlobalComm.puma" */
   communication = ExtractGlobalComm (stmt->ACF_DO.DO_BODY, home);
/* line 265 "GlobalComm.puma" */
   SummarizeGlobalComm (communication, home, stmt);
  }
   return communication;
 }

  }
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kPARDO_INFO) {
/* line 270 "GlobalComm.puma" */
 {
  tTree communication;
  {
/* line 274 "GlobalComm.puma" */
   communication = ExtractGlobalComm (stmt->ACF_DO.DO_BODY, home);
/* line 276 "GlobalComm.puma" */
   SummarizeGlobalComm (communication, home, stmt);
  }
   return communication;
 }

  }
  break;
  case kACF_TASK_REGION:
/* line 287 "GlobalComm.puma" */
 {
  tTree comm_stmts;
  {
/* line 291 "GlobalComm.puma" */
   IncParNesting (stmt);
/* line 293 "GlobalComm.puma" */
   comm_stmts = ExtractGlobalComm (stmt->ACF_TASK_REGION.TASK_BODY, home);
/* line 295 "GlobalComm.puma" */
   DecParNesting (stmt);
  }
   return comm_stmts;
 }

  case kACF_NEW:
/* line 306 "GlobalComm.puma" */
 {
  tTree comm_stmts;
  {
/* line 310 "GlobalComm.puma" */
   IncParNesting (stmt);
/* line 312 "GlobalComm.puma" */
   comm_stmts = ExtractGlobalComm (stmt->ACF_NEW.NEW_BODY, home);
/* line 314 "GlobalComm.puma" */
   DecParNesting (stmt);
  }
   return comm_stmts;
 }

  case kACF_REDUCTION:
/* line 329 "GlobalComm.puma" */
 {
  tTree comm_stmts;
  {
/* line 334 "GlobalComm.puma" */
   IncParNesting (stmt);
/* line 336 "GlobalComm.puma" */
   comm_stmts = ExtractGlobalComm (stmt->ACF_REDUCTION.REDUCTION_BODY, home);
/* line 338 "GlobalComm.puma" */
   DecParNesting (stmt);
  }
   return CombineACF (comm_stmts, ExtractWriteVarComm (stmt->ACF_REDUCTION.Line, stmt->ACF_REDUCTION.REDUCTION_VAR, home));
 }

  case kACF_RESIDENT:
/* line 349 "GlobalComm.puma" */
 {
  tTree comm_stmts;
  {
/* line 353 "GlobalComm.puma" */
   IncParNesting (stmt);
/* line 355 "GlobalComm.puma" */
   comm_stmts = ExtractGlobalComm (stmt->ACF_RESIDENT.RESIDENT_BODY, home);
/* line 357 "GlobalComm.puma" */
   DecParNesting (stmt);
  }
   return comm_stmts;
 }

  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 368 "GlobalComm.puma" */
   return ExtractWriteVarComm (stmt->ACF_BASIC.Line, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, home);

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCTION_STMT) {
/* line 375 "GlobalComm.puma" */
   return ExtractWriteVarComm (stmt->ACF_BASIC.Line, stmt->ACF_BASIC.BASIC_STMT->REDUCTION_STMT.ELEMS, home);

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 387 "GlobalComm.puma" */
   return ExtractParamComm (stmt->ACF_BASIC.Line, stmt->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, home);

  }
/* line 403 "GlobalComm.puma" */
  {
/* line 405 "GlobalComm.puma" */
   if (stmt->ACF_BASIC.BASIC_STMT->Kind != kIO_STMT) goto yyL19;
/* line 407 "GlobalComm.puma" */
   if (! ((stmt->ACF_BASIC.BASIC_STMT->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("INQUIRE")))) goto yyL19;
  }
   return MakeBroadcast (stmt->ACF_BASIC.Line, ControlSpecBroadcast (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS));
yyL19:;

/* line 412 "GlobalComm.puma" */
  {
/* line 414 "GlobalComm.puma" */
   if (stmt->ACF_BASIC.BASIC_STMT->Kind != kIO_STMT) goto yyL20;
/* line 416 "GlobalComm.puma" */
   if (! ((stmt->ACF_BASIC.BASIC_STMT->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("OPEN")))) goto yyL20;
  }
   return MakeBroadcast (stmt->ACF_BASIC.Line, ControlSpecBroadcast (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS));
yyL20:;

/* line 427 "GlobalComm.puma" */
  {
/* line 429 "GlobalComm.puma" */
   if (stmt->ACF_BASIC.BASIC_STMT->Kind != kIO_STMT) goto yyL21;
/* line 431 "GlobalComm.puma" */
   if (! ((stmt->ACF_BASIC.BASIC_STMT->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("READ")))) goto yyL21;
  }
   return MakeBroadcast (stmt->ACF_BASIC.Line, CombineBTV (ReadSpecBroadcast (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS), ParameterBroadcast (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS)));
yyL21:;

  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
/* line 443 "GlobalComm.puma" */
   return NoTree;

  }
/* line 454 "GlobalComm.puma" */
   return NoTree;

  }

/* line 459 "GlobalComm.puma" */
  {
/* line 461 "GlobalComm.puma" */
   failure_protocol (MODULE, "ExtractGlobalComm", stmt);
  }
   return NoTree;

}

static tTree ExtractParamComm
# if defined __STDC__ | defined __cplusplus
(register int line, register tTree params, pvar home)
# else
(line, params, home)
 register int line;
 register tTree params;
 pvar home;
# endif
{
  if (params->Kind == kBTP_LIST) {
/* line 473 "GlobalComm.puma" */
   return CombineACF (ExtractParamComm (line, params->BTP_LIST.Elem, home), ExtractParamComm (line, params->BTP_LIST.Next, home));

  }
  if (params->Kind == kBTP_EMPTY) {
/* line 479 "GlobalComm.puma" */
   return NoTree;

  }
  if (params->Kind == kVAR_PARAM) {
  if (params->VAR_PARAM.V->Kind == kADDR) {
/* line 484 "GlobalComm.puma" */
   return NoTree;

  }
/* line 489 "GlobalComm.puma" */
  {
/* line 491 "GlobalComm.puma" */
   if (! ((params->VAR_PARAM.intent == IntentIn))) goto yyL4;
  }
   return NoTree;
yyL4:;

/* line 496 "GlobalComm.puma" */
   return ExtractWriteVarComm (line, params->VAR_PARAM.V, home);

  }
/* line 501 "GlobalComm.puma" */
   return NoTree;

}

static tTree ExtractWriteVarComm
# if defined __STDC__ | defined __cplusplus
(register int line, register tTree var, pvar home)
# else
(line, var, home)
 register int line;
 register tTree var;
 pvar home;
# endif
{
  if (var->Kind == kBTV_LIST) {
/* line 516 "GlobalComm.puma" */
   return CombineACF (ExtractWriteVarComm (line, var->BTV_LIST.Elem, home), ExtractWriteVarComm (line, var->BTV_LIST.Next, home));

  }
  if (var->Kind == kBTV_EMPTY) {
/* line 522 "GlobalComm.puma" */
   return NoTree;

  }
/* line 533 "GlobalComm.puma" */
  {
/* line 535 "GlobalComm.puma" */
   tree_protocol ("broadcast variable is : ", var);
/* line 536 "GlobalComm.puma" */
   tree_protocol ("broadcast home is : ", PrintableDescriptorVar (home));
/* line 538 "GlobalComm.puma" */
   goto yyL3;
  }
yyL3:;

/* line 541 "GlobalComm.puma" */
  {
/* line 543 "GlobalComm.puma" */
   if (! ((IsReplicatedDescriptor (home)))) goto yyL4;
  {
/* line 545 "GlobalComm.puma" */
   tree_protocol ("no broadcast, replicated home : ", var);
  }
  }
   return NoTree;
yyL4:;

  if (var->Kind == kREMOTE_VAR) {
/* line 556 "GlobalComm.puma" */
   return NoTree;

  }
/* line 567 "GlobalComm.puma" */
  {
/* line 569 "GlobalComm.puma" */
   if (! ((IsLocalVarWrite (var, home)))) goto yyL6;
  {
/* line 571 "GlobalComm.puma" */
   tree_protocol ("no broadcast, local write is : ", var);
  }
  }
   return NoTree;
yyL6:;

/* line 576 "GlobalComm.puma" */
  {
/* line 578 "GlobalComm.puma" */
   if (! ((IsIndShadowVariable (var, home)))) goto yyL7;
  {
/* line 580 "GlobalComm.puma" */
   tree_protocol ("no broadcast, ind shadow is : ", var);
  }
  }
   return NoTree;
yyL7:;

/* line 585 "GlobalComm.puma" */
 {
  var_descriptor vard;
  {
/* line 589 "GlobalComm.puma" */
   SetVarDescriptor (var, & vard);
/* line 590 "GlobalComm.puma" */
   if (! ((NoReplicationDescriptor (& vard)))) goto yyL8;
  {
/* line 592 "GlobalComm.puma" */
   tree_protocol ("no broadcast, single incarnation: ", var);
  }
  }
   return NoTree;
 }
yyL8:;

/* line 604 "GlobalComm.puma" */
 {
  tTree new_stmt;
  {
/* line 606 "GlobalComm.puma" */
   if (! ((IsLocalVarRead (var, home)))) goto yyL9;
  {
/* line 608 "GlobalComm.puma" */

#ifdef DEBUG
     printf ("broadcast needed for : ");
     FileUnparse (stdout, var);
     printf (" on home ");
     FileUnparse (stdout, PrintableDescriptorVar (home));
     printf ("\n");
#endif 
   
/* line 620 "GlobalComm.puma" */
   new_stmt = mBTV_LIST (CopyTree (var), mBTV_EMPTY ());
/* line 625 "GlobalComm.puma" */
   new_stmt = mACF_BASIC (mBROADCAST_STMT (new_stmt, NoTree, mON_EMPTY ()));
/* line 627 "GlobalComm.puma" */
   LineACFNode (new_stmt, line);
  }
  }
   return new_stmt;
 }
yyL9:;

/* line 632 "GlobalComm.puma" */
  {
/* line 634 "GlobalComm.puma" */
   error_protocol ("broadcast on non-local variables");
/* line 635 "GlobalComm.puma" */
   tree_protocol ("illegal variable is : ", var);
/* line 636 "GlobalComm.puma" */
   tree_protocol ("broadcast home is : ", PrintableDescriptorVar (home));
  }
   return NoTree;

}

static void ApplyHomeChange
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, pvar inner_home, pvar outer_home)
# else
(stmts, inner_home, outer_home)
 register tTree stmts;
 pvar inner_home;
 pvar outer_home;
# endif
{
 yyRecursion:
/* line 651 "GlobalComm.puma" */
  {
/* line 653 "GlobalComm.puma" */
   if (! ((stmts == NoTree))) goto yyL1;
  {
/* line 655 "GlobalComm.puma" */

#ifdef DEBUG
    printf ("call of ApllyHomeChange\n");
    printf ("   inner home : ");
    FileUnparse (stdout, PrintableDescriptorVar (inner_home));
    printf ("\n");
    printf ("   outer home : ");
    FileUnparse (stdout, PrintableDescriptorVar (outer_home));
    printf ("\n");
#endif
  
  }
  }
   return;
yyL1:;

  if (stmts->Kind == kACF_LIST) {
/* line 668 "GlobalComm.puma" */
  {
/* line 670 "GlobalComm.puma" */
   ApplyHomeChange (stmts->ACF_LIST.Next, inner_home, outer_home);
/* line 671 "GlobalComm.puma" */
   stmts = stmts->ACF_LIST.Elem;
   goto yyRecursion;
  }

  }
  if (stmts->Kind == kACF_EMPTY) {
/* line 674 "GlobalComm.puma" */
   return;

  }
  if (stmts->Kind == kACF_BASIC) {
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kBROADCAST_STMT) {
/* line 677 "GlobalComm.puma" */
  {
/* line 679 "GlobalComm.puma" */
   BetterOnSelection (stmts->ACF_BASIC.BASIC_STMT, inner_home, outer_home);
  }
   return;

  }
  }
;
}

static tTree MakeBroadcast
# if defined __STDC__ | defined __cplusplus
(register int line, register tTree bc_vars)
# else
(line, bc_vars)
 register int line;
 register tTree bc_vars;
# endif
{
/* line 692 "GlobalComm.puma" */
 {
  tTree new_stmt;
  {
/* line 696 "GlobalComm.puma" */
   new_stmt = mBROADCAST_STMT (CompleteBTVs (bc_vars), NoTree, mON_EMPTY ());
/* line 697 "GlobalComm.puma" */
   new_stmt = mACF_BASIC (new_stmt);
/* line 699 "GlobalComm.puma" */
   LineACFNode (new_stmt, line);
  }
   return new_stmt;
 }

}

static tTree ParameterBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree p)
# else
(p)
 register tTree p;
# endif
{
  if (p->Kind == kBTP_LIST) {
/* line 715 "GlobalComm.puma" */
   return CombineBTV (ParameterBroadcast (p->BTP_LIST.Elem), ParameterBroadcast (p->BTP_LIST.Next));

  }
  if (p->Kind == kBTP_EMPTY) {
/* line 721 "GlobalComm.puma" */
   return NoTree;

  }
  if (p->Kind == kVAR_PARAM) {
/* line 726 "GlobalComm.puma" */
  {
/* line 728 "GlobalComm.puma" */
   if (! ((IsOnlyReadParam (p)))) goto yyL3;
  }
   return NoTree;
yyL3:;

/* line 733 "GlobalComm.puma" */
  {
/* line 735 "GlobalComm.puma" */
   if (! ((TreeWriteDistribution (p->VAR_PARAM.V) == 2))) goto yyL4;
  }
   return NoTree;
yyL4:;

/* line 739 "GlobalComm.puma" */
  {
/* line 741 "GlobalComm.puma" */
   if (! ((TreeWriteDistribution (p->VAR_PARAM.V) == 0))) goto yyL5;
  }
   return CopyTree (p->VAR_PARAM.V);
yyL5:;

/* line 745 "GlobalComm.puma" */
   return NoTree;

  }
  if (p->Kind == kNO_PARAM) {
/* line 750 "GlobalComm.puma" */
   return NoTree;

  }
  if (p->Kind == kFUNC_PARAM) {
/* line 754 "GlobalComm.puma" */
   return NoTree;

  }
  if (p->Kind == kPROC_PARAM) {
/* line 758 "GlobalComm.puma" */
   return NoTree;

  }
/* line 762 "GlobalComm.puma" */
  {
/* line 763 "GlobalComm.puma" */
   failure_protocol (MODULE, "ParameterBroadcast", p);
  }
   return NoTree;

}

static tTree ControlSpecBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree p)
# else
(p)
 register tTree p;
# endif
{
  if (p->Kind == kBTP_LIST) {
/* line 777 "GlobalComm.puma" */
   return CombineBTV (ControlSpecBroadcast (p->BTP_LIST.Elem), ControlSpecBroadcast (p->BTP_LIST.Next));

  }
  if (p->Kind == kBTP_EMPTY) {
/* line 782 "GlobalComm.puma" */
   return NoTree;

  }
  if (p->Kind == kNAMED_PARAM) {
/* line 786 "GlobalComm.puma" */
  {
/* line 787 "GlobalComm.puma" */
   if (! ((p->NAMED_PARAM.Name == MakeIdent ("EXISTS", 6)))) goto yyL3;
  }
   return ParameterBroadcast (p->NAMED_PARAM.VAL);
yyL3:;

/* line 791 "GlobalComm.puma" */
  {
/* line 792 "GlobalComm.puma" */
   if (! ((p->NAMED_PARAM.Name == MakeIdent ("IOSTAT", 6)))) goto yyL4;
  }
   return ParameterBroadcast (p->NAMED_PARAM.VAL);
yyL4:;

/* line 796 "GlobalComm.puma" */
   return NoTree;

  }
  if (p->Kind == kVAR_PARAM) {
/* line 800 "GlobalComm.puma" */
   return NoTree;

  }
/* line 804 "GlobalComm.puma" */
  {
/* line 805 "GlobalComm.puma" */
   failure_protocol (MODULE, "ControlSpecBroadcast", p);
  }
   return NoTree;

}

static tTree ReadSpecBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree p)
# else
(p)
 register tTree p;
# endif
{
 yyRecursion:
  if (p->Kind == kBTP_LIST) {
/* line 821 "GlobalComm.puma" */
   return CombineBTV (ReadSpecBroadcast (p->BTP_LIST.Elem), ReadSpecBroadcast (p->BTP_LIST.Next));

  }
  if (p->Kind == kBTP_EMPTY) {
/* line 826 "GlobalComm.puma" */
   return NoTree;

  }
  if (p->Kind == kNAMED_PARAM) {
/* line 830 "GlobalComm.puma" */
  {
/* line 831 "GlobalComm.puma" */
   if (! ((p->NAMED_PARAM.Name == MakeIdent ("IOSTAT", 6)))) goto yyL3;
  }
   return ParameterBroadcast (p->NAMED_PARAM.VAL);
yyL3:;

/* line 835 "GlobalComm.puma" */
   p = p->NAMED_PARAM.VAL;
   goto yyRecursion;

  }
  if (p->Kind == kVAR_PARAM) {
/* line 839 "GlobalComm.puma" */
  {
/* line 840 "GlobalComm.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL5;
  }
   return NoTree;
yyL5:;

  if (p->VAR_PARAM.V->Kind == kUSED_VAR) {
  if (p->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kNameListObject) {
  if (p->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object->NameListObject.decl->Kind == kNAMELIST_DECL) {
/* line 844 "GlobalComm.puma" */
   return NameListVars (p->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object->NameListObject.decl->NAMELIST_DECL.IDS);

  }
  }
  }
/* line 852 "GlobalComm.puma" */
   return NoTree;

  }
/* line 856 "GlobalComm.puma" */
  {
/* line 857 "GlobalComm.puma" */
   failure_protocol (MODULE, "ReadSpecBroadcast", p);
  }
   return NoTree;

}

static tTree NameListVars
# if defined __STDC__ | defined __cplusplus
(register tTree names)
# else
(names)
 register tTree names;
# endif
{
  if (names->Kind == kDECL_LIST) {
/* line 869 "GlobalComm.puma" */
   return CombineBTV (NameListVars (names->DECL_LIST.Elem), NameListVars (names->DECL_LIST.Next));

  }
  if (names->Kind == kDECL_EMPTY) {
/* line 874 "GlobalComm.puma" */
   return NoTree;

  }
  if (names->Kind == kVAR_DECL) {
/* line 878 "GlobalComm.puma" */
  {
/* line 880 "GlobalComm.puma" */
   if (! ((VarDistribution (GetLocalObject (names->VAR_DECL.Ident)) == - 1))) goto yyL3;
  }
   return NoTree;
yyL3:;

/* line 884 "GlobalComm.puma" */
 {
  tTree newvar;
  tDefinitions Obj;
  {
/* line 889 "GlobalComm.puma" */
   Obj = GetLocalObject (names->VAR_DECL.Ident);
/* line 891 "GlobalComm.puma" */
   if (! ((VarDistribution (Obj) == 0))) goto yyL4;
  {
/* line 893 "GlobalComm.puma" */
 newvar = mVAR_OBJ (names->VAR_DECL.Line, names->VAR_DECL.Ident);
      newvar->VAR_OBJ.Object = Obj;
      newvar = mUSED_VAR (newvar);
    
  }
  }
   return newvar;
 }
yyL4:;

/* line 901 "GlobalComm.puma" */
  {
/* line 903 "GlobalComm.puma" */
   if (! ((VarDistribution (GetLocalObject (names->VAR_DECL.Ident)) == 1))) goto yyL5;
  {
/* line 905 "GlobalComm.puma" */
   error_protocol ("distributed variable in namelist");
/* line 906 "GlobalComm.puma" */
   tree_protocol ("illegal variable is ", names);
  }
  }
   return NoTree;
yyL5:;

  }
/* line 910 "GlobalComm.puma" */
  {
/* line 911 "GlobalComm.puma" */
   failure_protocol (MODULE, "NameListVars", names);
  }
   return NoTree;

}

static void VectorizeGlobalComm
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, pvar home, register tTree id, register tTree slice)
# else
(stmts, home, id, slice)
 register tTree stmts;
 pvar home;
 register tTree id;
 register tTree slice;
# endif
{
 yyRecursion:
/* line 931 "GlobalComm.puma" */
  {
/* line 933 "GlobalComm.puma" */
   if (! ((stmts == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (stmts->Kind == kACF_LIST) {
/* line 936 "GlobalComm.puma" */
  {
/* line 938 "GlobalComm.puma" */
   set_protocol_stmt (stmts->ACF_LIST.Elem);
/* line 939 "GlobalComm.puma" */
   VectorizeGlobalComm (stmts->ACF_LIST.Elem, home, id, slice);
/* line 940 "GlobalComm.puma" */
   stmts = stmts->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  if (stmts->Kind == kACF_EMPTY) {
/* line 943 "GlobalComm.puma" */
   return;

  }
  if (stmts->Kind == kACF_BASIC) {
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kBROADCAST_STMT) {
/* line 946 "GlobalComm.puma" */
 {
  rbool yyV1;
  {
/* line 948 "GlobalComm.puma" */
   tree_protocol ("vectorize bc : ", stmts->ACF_BASIC.BASIC_STMT);
/* line 949 "GlobalComm.puma" */
   tree_protocol ("id           : ", id);
/* line 950 "GlobalComm.puma" */
   tree_protocol ("slice        : ", slice);
/* line 951 "GlobalComm.puma" */
   tree_protocol ("home         : ", PrintableDescriptorVar (home));
/* line 953 "GlobalComm.puma" */
   VectorizeVarList (stmts->ACF_BASIC.BASIC_STMT->BROADCAST_STMT.ELEMS, id, slice, & yyV1);
/* line 955 "GlobalComm.puma" */
 if (yyV1 != 1)

        { 

          OnIdUpdate (stmts->ACF_BASIC.BASIC_STMT, home, id);
        }
   
  }
   return;
 }

  }
  }
/* line 964 "GlobalComm.puma" */
  {
/* line 966 "GlobalComm.puma" */
   failure_protocol (MODULE, "VectorizeGlobalComm", stmts);
  }
   return;

;
}

static void VectorizeVarList
# if defined __STDC__ | defined __cplusplus
(register tTree vars, register tTree id, register tTree slice, register rbool * yyP1)
# else
(vars, id, slice, yyP1)
 register tTree vars;
 register tTree id;
 register tTree slice;
 register rbool * yyP1;
# endif
{
  if (vars->Kind == kBTV_EMPTY) {
/* line 977 "GlobalComm.puma" */
   * yyP1 = 0;
   return;

  }
  if (vars->Kind == kBTV_LIST) {
/* line 980 "GlobalComm.puma" */
 {
  int done;
  rbool yyV1;
  {
/* line 984 "GlobalComm.puma" */
   MakeVectorVar (vars->BTV_LIST.Elem, id, slice, & done);
/* line 991 "GlobalComm.puma" */
 if (done == -1)

         { error_protocol ("could not vectorize global communication");
           tree_protocol  ("illegal variable : ", vars->BTV_LIST.Elem);
           tree_protocol  ("loop id :          ", id);
         }
    
/* line 999 "GlobalComm.puma" */
   VectorizeVarList (vars->BTV_LIST.Next, id, slice, & yyV1);
  }
   * yyP1 = done;
   return;
 }

  }
/* line 1002 "GlobalComm.puma" */
  {
/* line 1004 "GlobalComm.puma" */
   failure_protocol (MODULE, "VectorizeVarList", vars);
  }
   * yyP1 = 0;
   return;

;
}

static void SummarizeGlobalComm
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, pvar home, register tTree loop)
# else
(stmts, home, loop)
 register tTree stmts;
 pvar home;
 register tTree loop;
# endif
{
 yyRecursion:
/* line 1016 "GlobalComm.puma" */
  {
/* line 1018 "GlobalComm.puma" */
   if (! ((stmts == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (stmts->Kind == kACF_LIST) {
/* line 1021 "GlobalComm.puma" */
  {
/* line 1023 "GlobalComm.puma" */
   set_protocol_stmt (stmts->ACF_LIST.Elem);
/* line 1025 "GlobalComm.puma" */
   SummarizeGlobalComm (stmts->ACF_LIST.Elem, home, loop);
/* line 1026 "GlobalComm.puma" */
   stmts = stmts->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  if (stmts->Kind == kACF_EMPTY) {
/* line 1029 "GlobalComm.puma" */
   return;

  }
  if (stmts->Kind == kACF_BASIC) {
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kBROADCAST_STMT) {
/* line 1032 "GlobalComm.puma" */
  {
/* line 1034 "GlobalComm.puma" */
   error_protocol ("cannot summarize global broadcast in serial loop");
/* line 1035 "GlobalComm.puma" */
   tree_protocol ("serial loop : \n", loop);
  }
   return;

  }
  }
/* line 1038 "GlobalComm.puma" */
  {
/* line 1040 "GlobalComm.puma" */
   failure_protocol (MODULE, "SummarizeGlobalComm", stmts);
  }
   return;

;
}

void BeginGlobalComm ARGS ((void))
{
}

void CloseGlobalComm ARGS ((void))
{
}
