# include "Fusion.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 28 "Fusion.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Transform.h"     /* CombineACF */

# include "ReplaceExp.h"    /* RenameLoopId */

# include "StmtDeps.h"      /* FusionDependence */
# include "Expressions.h"

# define  MODULE  "Fusion"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyFusion.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Fusion_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Fusion, routine %s failed\n",
  yyFunction);
 Fusion_Exit ();
}

rbool CanBeFused ARGS ((tTree stmt1, tTree stmt2));
static rbool SameOnTopology ARGS ((tTree topology1, tTree topology2));
static rbool SameSpecs ARGS ((tTree speclist1, tTree speclist2));
static rbool SameDepInfo ARGS ((tTree info1, tTree info2));
static rbool SameHomeInfo ARGS ((tTree info1, tTree info2));
tTree Fusion ARGS ((tTree stmt1, tTree stmt2));

rbool CanBeFused
# if defined __STDC__ | defined __cplusplus
(register tTree stmt1, register tTree stmt2)
# else
(stmt1, stmt2)
 register tTree stmt1;
 register tTree stmt2;
# endif
{
  if (stmt1->Kind == kACF_ON) {
  if (stmt2->Kind == kACF_ON) {
/* line 55 "Fusion.puma" */
 {
  Predicate p;
  {
/* line 58 "Fusion.puma" */
   if (! ((stmt2->ACF_ON.Label == 0))) goto yyL1;
  {
/* line 60 "Fusion.puma" */
   if (! ((SameOnTopology (stmt1->ACF_ON.ON_HOME, stmt2->ACF_ON.ON_HOME)))) goto yyL1;
  {
/* line 61 "Fusion.puma" */
   if (! ((SameSpecs (stmt1->ACF_ON.ON_SPECS, stmt2->ACF_ON.ON_SPECS)))) goto yyL1;
  {
/* line 65 "Fusion.puma" */
   FusionDependence (stmt1, stmt2, & p);
/* line 67 "Fusion.puma" */
   if (! ((PIsFalse (& p)))) goto yyL1;
  }
  }
  }
  }
   return rtrue;
 }
yyL1:;

  }
  }
  if (stmt1->Kind == kACF_DO) {
  if (stmt2->Kind == kACF_DO) {
/* line 70 "Fusion.puma" */
 {
  Predicate p;
  {
/* line 73 "Fusion.puma" */
   if (! ((stmt2->ACF_DO.Label == 0))) goto yyL2;
  {
/* line 77 "Fusion.puma" */
   if (! ((SameDepInfo (stmt1->ACF_DO.DO_DEP_INFO, stmt2->ACF_DO.DO_DEP_INFO)))) goto yyL2;
  {
/* line 78 "Fusion.puma" */
   if (! ((SameHomeInfo (stmt1->ACF_DO.DO_HOME_INFO, stmt2->ACF_DO.DO_HOME_INFO)))) goto yyL2;
  {
/* line 79 "Fusion.puma" */
   if (! ((EqualExpression (stmt1->ACF_DO.DO_RANGE, stmt2->ACF_DO.DO_RANGE)))) goto yyL2;
  {
/* line 83 "Fusion.puma" */
   FusionDependence (stmt1, stmt2, & p);
/* line 85 "Fusion.puma" */
   if (! ((PIsFalse (& p)))) goto yyL2;
  }
  }
  }
  }
  }
   return rtrue;
 }
yyL2:;

  }
  }
  if (stmt1->Kind == kACF_BARRIER) {
  if (stmt2->Kind == kACF_BARRIER) {
/* line 88 "Fusion.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static rbool SameOnTopology
# if defined __STDC__ | defined __cplusplus
(register tTree topology1, register tTree topology2)
# else
(topology1, topology2)
 register tTree topology1;
 register tTree topology2;
# endif
{
  if (topology1->Kind == kON_ALL) {
  if (topology2->Kind == kON_ALL) {
/* line 99 "Fusion.puma" */
   return rtrue;

  }
  }
  if (topology1->Kind == kON_HOST) {
  if (topology2->Kind == kON_HOST) {
/* line 102 "Fusion.puma" */
   return rtrue;

  }
  }
  if (topology1->Kind == kON_VAR) {
  if (topology2->Kind == kON_VAR) {
/* line 105 "Fusion.puma" */
  {
/* line 107 "Fusion.puma" */
   if (! ((topology1->ON_VAR.topid == topology2->ON_VAR.topid))) goto yyL3;
  {
/* line 108 "Fusion.puma" */
   if (! ((topology1->ON_VAR.tempid == topology2->ON_VAR.tempid))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  }
  }
  return rfalse;
}

static rbool SameSpecs
# if defined __STDC__ | defined __cplusplus
(register tTree speclist1, register tTree speclist2)
# else
(speclist1, speclist2)
 register tTree speclist1;
 register tTree speclist2;
# endif
{
  if (speclist1->Kind == kON_EMPTY) {
  if (speclist2->Kind == kON_EMPTY) {
/* line 121 "Fusion.puma" */
   return rtrue;

  }
  }
  if (speclist1->Kind == kON_LIST) {
  if (speclist2->Kind == kON_LIST) {
/* line 124 "Fusion.puma" */
  {
/* line 126 "Fusion.puma" */
   if (! ((SameSpecs (speclist1->ON_LIST.Elem, speclist2->ON_LIST.Elem)))) goto yyL2;
  {
/* line 127 "Fusion.puma" */
   if (! ((SameSpecs (speclist1->ON_LIST.Next, speclist2->ON_LIST.Next)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  }
  if (speclist1->Kind == kON_SPEC) {
  if (speclist2->Kind == kON_SPEC) {
/* line 130 "Fusion.puma" */
  {
/* line 133 "Fusion.puma" */
   if (! ((speclist1->ON_SPEC.top_dim == speclist2->ON_SPEC.top_dim))) goto yyL3;
  {
/* line 134 "Fusion.puma" */
   if (! ((EqualExpression (speclist1->ON_SPEC.ON_VAL, speclist2->ON_SPEC.ON_VAL)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  }
  }
  return rfalse;
}

static rbool SameDepInfo
# if defined __STDC__ | defined __cplusplus
(register tTree info1, register tTree info2)
# else
(info1, info2)
 register tTree info1;
 register tTree info2;
# endif
{
  if (info1->Kind == kSERIAL_INFO) {
  if (info2->Kind == kSERIAL_INFO) {
/* line 139 "Fusion.puma" */
   return rtrue;

  }
  }
  if (info1->Kind == kINDEP_INFO) {
  if (info2->Kind == kINDEP_INFO) {
/* line 142 "Fusion.puma" */
  {
/* line 144 "Fusion.puma" */
   if (! ((info1->INDEP_INFO.selection == info2->INDEP_INFO.selection))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  return rfalse;
}

static rbool SameHomeInfo
# if defined __STDC__ | defined __cplusplus
(register tTree info1, register tTree info2)
# else
(info1, info2)
 register tTree info1;
 register tTree info2;
# endif
{
  if (info1->Kind == kNO_HOME_INFO) {
  if (info2->Kind == kNO_HOME_INFO) {
/* line 157 "Fusion.puma" */
   return rtrue;

  }
  }
  if (info1->Kind == kCOMM_INFO) {
  if (info2->Kind == kCOMM_INFO) {
/* line 162 "Fusion.puma" */
   return rtrue;

  }
  }
  if (info1->Kind == kON_INFO) {
  if (info2->Kind == kON_INFO) {
/* line 165 "Fusion.puma" */
  {
/* line 168 "Fusion.puma" */
   if (! ((info1->ON_INFO.on_id == info2->ON_INFO.on_id))) goto yyL3;
  {
/* line 169 "Fusion.puma" */
   if (! ((info1->ON_INFO.on_dim == info2->ON_INFO.on_dim))) goto yyL3;
  {
/* line 173 "Fusion.puma" */
   if (! ((info1->ON_INFO.base == info2->ON_INFO.base))) goto yyL3;
  {
/* line 174 "Fusion.puma" */
   if (! ((info1->ON_INFO.stride == info2->ON_INFO.stride))) goto yyL3;
  }
  }
  }
  }
   return rtrue;
yyL3:;

  }
  }
  return rfalse;
}

tTree Fusion
# if defined __STDC__ | defined __cplusplus
(register tTree stmt1, register tTree stmt2)
# else
(stmt1, stmt2)
 register tTree stmt1;
 register tTree stmt2;
# endif
{
  if (stmt1->Kind == kACF_ON) {
  if (stmt2->Kind == kACF_ON) {
/* line 200 "Fusion.puma" */
  {
/* line 202 "Fusion.puma" */
 stmt1->ACF_ON.ON_BODY = CombineACF (stmt1->ACF_ON.ON_BODY, stmt2->ACF_ON.ON_BODY); 
  }
   return stmt1;

  }
  }
  if (stmt1->Kind == kACF_DO) {
  if (stmt2->Kind == kACF_DO) {
/* line 207 "Fusion.puma" */
  {
/* line 210 "Fusion.puma" */
   RenameLoopId (stmt2->ACF_DO.DO_BODY, stmt2->ACF_DO.DO_ID, stmt1->ACF_DO.DO_ID);
/* line 212 "Fusion.puma" */
 stmt1->ACF_DO.DO_BODY = CombineACF (stmt1->ACF_DO.DO_BODY, stmt2->ACF_DO.DO_BODY); 
  }
   return stmt1;

  }
  }
  if (stmt1->Kind == kACF_BARRIER) {
  if (stmt2->Kind == kACF_BARRIER) {
/* line 217 "Fusion.puma" */
   return stmt1;

  }
  }
 yyAbort ("Fusion");
 { tTree yyDummy; return yyDummy; }
}

void BeginFusion ARGS ((void))
{
}

void CloseFusion ARGS ((void))
{
}
