# include "FindHome.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 42 "FindHome.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "ParNest.h"        /* IsNewVariable   */
# include "Descriptor.h"     
# include "Objects.h"         /* IsGlobalVar    */
# include "HomeDescriptor.h"
# include "MoveControl.h"
# include "Accepted.h"
# include "Rank.h"
# include "Distributions.h"
# include "ArrayData.h"
# include "Nesting.h"

# define MODULE "FindHome"

# undef DEBUG



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyFindHome.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* FindHome_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module FindHome, routine %s failed\n",
  yyFunction);
 FindHome_Exit ();
}

void GetHomeDescriptor ARGS ((tTree t, pvar good_home));
void FindHome ARGS ((tTree t, pvar min_home, pvar good_home));
static void FindParamHome ARGS ((tTree t, pvar min_home, pvar good_home));
static void FindParamListHome ARGS ((tTree t, pvar min_home, pvar good_home));
static void FindExpHome ARGS ((tTree exp, pvar min_home, pvar good_home));
static void FindVarHome ARGS ((tTree var, pvar min_home, pvar good_home));
static void FindReadVarHome ARGS ((tTree var, pvar min_home, pvar good_home));
static void FindWriteVarHome ARGS ((tTree var, pvar min_home, pvar good_home));
static void FindDescriptorHome ARGS ((tTree t, pvar min_home, pvar good_home));
static void ChooseHome ARGS ((pvar home1, pvar home2));
static void ChooseBestHome ARGS ((pvar home1, pvar home2));
static void UnionHome ARGS ((pvar home1, pvar home2));
static void ExpandHomes ARGS ((pvar min_home, pvar good_home, tTree id));
static void PrintHomes ARGS ((tTree t, pvar min_home, pvar good_home));
void FindSerialHome ARGS ((tTree stmt, pvar home, rbool * yyP1));

void GetHomeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar good_home)
# else
(t, good_home)
 register tTree t;
 pvar good_home;
# endif
{
/* line 79 "FindHome.puma" */
 {
  var_descriptor min_home;
  {
/* line 83 "FindHome.puma" */
   FindHome (t, & min_home, good_home);
/* line 85 "FindHome.puma" */

#ifdef DEBUG
     printf ("GetHomeDescriptor of this tree is : \n");
     FileUnparse (stdout, t);
     PrintVarDescriptor (good_home);
#endif
   
  }
   return;
 }

;
}

void FindHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar min_home, pvar good_home)
# else
(t, min_home, good_home)
 register tTree t;
 pvar min_home;
 pvar good_home;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kACF_LIST:
/* line 109 "FindHome.puma" */
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
/* line 114 "FindHome.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 116 "FindHome.puma" */
   FindHome (t->ACF_LIST.Elem, min_home, good_home);
/* line 117 "FindHome.puma" */
   FindHome (t->ACF_LIST.Next, & min_home1, & good_home1);
/* line 119 "FindHome.puma" */
   UnionHome (min_home, & min_home1);
/* line 120 "FindHome.puma" */
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  case kACF_EMPTY:
/* line 123 "FindHome.puma" */
  {
/* line 125 "FindHome.puma" */
   MakeNoDescriptor (min_home);
/* line 126 "FindHome.puma" */
   MakeNoDescriptor (good_home);
  }
   return;

  case kACF_FORALL:
/* line 129 "FindHome.puma" */
  {
/* line 131 "FindHome.puma" */
 t->Kind = kACF_DO; 
/* line 133 "FindHome.puma" */
   goto yyRecursion;
  }

  case kACF_DO:
/* line 136 "FindHome.puma" */
  {
/* line 138 "FindHome.puma" */
   IncParNesting (t);
/* line 140 "FindHome.puma" */
   FindHome (t->ACF_DO.DO_BODY, min_home, good_home);
/* line 142 "FindHome.puma" */
   set_protocol_stmt (t);
/* line 144 "FindHome.puma" */
   ExpandHomes (min_home, good_home, t->ACF_DO.DO_ID);
/* line 146 "FindHome.puma" */
   DecParNesting (t);
  }
   return;

  case kACF_IF:
/* line 149 "FindHome.puma" */
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
/* line 154 "FindHome.puma" */
   IncParNesting (t);
/* line 156 "FindHome.puma" */
   FindHome (t->ACF_IF.THEN_PART, min_home, good_home);
/* line 157 "FindHome.puma" */
   FindHome (t->ACF_IF.ELSE_PART, & min_home1, & good_home1);
/* line 159 "FindHome.puma" */
   DecParNesting (t);
/* line 161 "FindHome.puma" */
   UnionHome (min_home, & min_home1);
/* line 162 "FindHome.puma" */
   ChooseHome (good_home, & good_home1);
/* line 164 "FindHome.puma" */
   FindExpHome (t->ACF_IF.IF_EXP, & min_home1, & good_home1);
/* line 166 "FindHome.puma" */
   UnionHome (min_home, & min_home1);
/* line 167 "FindHome.puma" */
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  case kACF_WHERE:
/* line 170 "FindHome.puma" */
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
/* line 175 "FindHome.puma" */
   FindHome (t->ACF_WHERE.TRUE_PART, min_home, good_home);
/* line 176 "FindHome.puma" */
   FindHome (t->ACF_WHERE.FALSE_PART, & min_home1, & good_home1);
/* line 178 "FindHome.puma" */
   UnionHome (min_home, & min_home1);
/* line 179 "FindHome.puma" */
   ChooseHome (good_home, & good_home1);
/* line 181 "FindHome.puma" */
   FindExpHome (t->ACF_WHERE.WHERE_EXP, & min_home1, & good_home1);
/* line 183 "FindHome.puma" */
   UnionHome (min_home, & min_home1);
/* line 184 "FindHome.puma" */
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  case kACF_WHILE:
/* line 187 "FindHome.puma" */
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
/* line 192 "FindHome.puma" */
   FindHome (t->ACF_WHILE.WHILE_BODY, min_home, good_home);
/* line 193 "FindHome.puma" */
   FindExpHome (t->ACF_WHILE.WHILE_EXP, & min_home1, & good_home1);
/* line 195 "FindHome.puma" */
   UnionHome (min_home, & min_home1);
/* line 196 "FindHome.puma" */
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  case kACF_NEW:
/* line 199 "FindHome.puma" */
  {
/* line 201 "FindHome.puma" */
   IncParNesting (t);
/* line 202 "FindHome.puma" */
   FindHome (t->ACF_NEW.NEW_BODY, min_home, good_home);
/* line 203 "FindHome.puma" */
   DecParNesting (t);
  }
   return;

  case kACF_RESIDENT:
/* line 206 "FindHome.puma" */
  {
/* line 208 "FindHome.puma" */
   IncParNesting (t);
/* line 209 "FindHome.puma" */
   FindHome (t->ACF_RESIDENT.RESIDENT_BODY, min_home, good_home);
/* line 210 "FindHome.puma" */
   DecParNesting (t);
  }
   return;

  case kACF_TASK_REGION:
/* line 213 "FindHome.puma" */
  {
/* line 215 "FindHome.puma" */
   IncParNesting (t);
/* line 216 "FindHome.puma" */
   FindHome (t->ACF_TASK_REGION.TASK_BODY, min_home, good_home);
/* line 217 "FindHome.puma" */
   DecParNesting (t);
  }
   return;

  case kACF_REDUCTION:
/* line 220 "FindHome.puma" */
  {
/* line 222 "FindHome.puma" */
   IncParNesting (t);
/* line 223 "FindHome.puma" */
   FindHome (t->ACF_REDUCTION.REDUCTION_BODY, min_home, good_home);
/* line 224 "FindHome.puma" */
   DecParNesting (t);
  }
   return;

  case kACF_HOME:
  if (t->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
/* line 233 "FindHome.puma" */
  {
/* line 235 "FindHome.puma" */
   IncParNesting (t);
/* line 237 "FindHome.puma" */
   FindHome (t->ACF_HOME.HOME_BODY, min_home, good_home);
/* line 239 "FindHome.puma" */
   DecParNesting (t);
/* line 243 "FindHome.puma" */
   SetVarDescriptor (t->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, good_home);
  }
   return;

  }
  break;
  case kACF_DUMMY:
/* line 250 "FindHome.puma" */
  {
/* line 252 "FindHome.puma" */
   MakeNoDescriptor (min_home);
/* line 253 "FindHome.puma" */
   MakeNoDescriptor (good_home);
  }
   return;

  case kACF_BASIC:
/* line 256 "FindHome.puma" */
  {
/* line 258 "FindHome.puma" */
   SetActualData (t);
/* line 260 "FindHome.puma" */
   t = t->ACF_BASIC.BASIC_STMT;
   goto yyRecursion;
  }

  case kREDUCE_STMT:
  if (t->REDUCE_STMT.RED_PARAMS->Kind == kBTP_LIST) {
  if (t->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 269 "FindHome.puma" */
  {
/* line 271 "FindHome.puma" */
   FindParamHome (t->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, min_home, good_home);
/* line 276 "FindHome.puma" */
 if (IsNoDescriptor (good_home))
      MakeParLoopNestDescriptor (good_home);

#ifdef DEBUG
    PrintHomes (t, min_home, good_home);
#endif 

  
  }
   return;

  }
  }
  break;
  case kASSIGN_STMT:
/* line 288 "FindHome.puma" */
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
/* line 295 "FindHome.puma" */
   FindWriteVarHome (t->ASSIGN_STMT.ASSIGN_VAR, min_home, good_home);
/* line 296 "FindHome.puma" */
   FindExpHome (t->ASSIGN_STMT.ASSIGN_EXP, & min_home1, & good_home1);
/* line 298 "FindHome.puma" */
   UnionHome (min_home, & min_home1);
/* line 299 "FindHome.puma" */
   ChooseHome (good_home, & good_home1);
/* line 301 "FindHome.puma" */

#ifdef DEBUG
    PrintHomes (t, min_home, good_home);
#endif
  
  }
   return;
 }

  case kIO_STMT:
/* line 310 "FindHome.puma" */
  {
/* line 314 "FindHome.puma" */
   MakeHostDescriptor (good_home);
/* line 315 "FindHome.puma" */
   MakeNoDescriptor (min_home);
  }
   return;

  case kCALL_STMT:
/* line 320 "FindHome.puma" */
  {
/* line 322 "FindHome.puma" */
   if (! ((IsPureCall (t)))) goto yyL18;
  {
/* line 324 "FindHome.puma" */
   FindParamListHome (t->CALL_STMT.CALL_PARAMS, min_home, good_home);
/* line 326 "FindHome.puma" */

#ifdef DEBUG
    PrintHomes (t, min_home, good_home);
#endif 
  
  }
  }
   return;
yyL18:;

/* line 333 "FindHome.puma" */
 {
  rbool yyV1;
  {
/* line 335 "FindHome.puma" */
   if (! ((IsSerialCall (t)))) goto yyL19;
  {
/* line 337 "FindHome.puma" */
   stmt_protocol ("check for serial home");
/* line 339 "FindHome.puma" */
   FindSerialHome (t->CALL_STMT.CALL_PARAMS, min_home, & yyV1);
/* line 340 "FindHome.puma" */
   if (! ((yyV1))) goto yyL19;
  {
/* line 342 "FindHome.puma" */
   tree_protocol ("serial home found : ", PrintableDescriptorVar (min_home));
/* line 344 "FindHome.puma" */
 *good_home = *min_home; 
  }
  }
  }
   return;
 }
yyL19:;

/* line 347 "FindHome.puma" */
  {
/* line 349 "FindHome.puma" */
   if (! ((IsSerialCall (t)))) goto yyL20;
  {
/* line 351 "FindHome.puma" */
   MakeHostDescriptor (min_home);
/* line 352 "FindHome.puma" */
   MakeHostDescriptor (good_home);
  }
  }
   return;
yyL20:;

/* line 355 "FindHome.puma" */
 {
  tTree home_clause;
  {
/* line 357 "FindHome.puma" */
   if (! ((HasUserHome ()))) goto yyL21;
  {
/* line 361 "FindHome.puma" */
   home_clause = GetUserHome ();
/* line 363 "FindHome.puma" */
   MakeClauseDescriptor (home_clause, min_home);
/* line 364 "FindHome.puma" */
   MakeClauseDescriptor (home_clause, good_home);
  }
  }
   return;
 }
yyL21:;

/* line 367 "FindHome.puma" */
  {
/* line 369 "FindHome.puma" */
   if (! ((UserIndependent ()))) goto yyL22;
  {
/* line 371 "FindHome.puma" */
   FindParamListHome (t->CALL_STMT.CALL_PARAMS, min_home, good_home);
  }
  }
   return;
yyL22:;

/* line 376 "FindHome.puma" */
  {
/* line 378 "FindHome.puma" */
   MakeReplicatedDescriptor (min_home);
/* line 379 "FindHome.puma" */
   MakeReplicatedDescriptor (good_home);
  }
   return;

  case kALLOCATE_STMT:
/* line 385 "FindHome.puma" */
  {
/* line 387 "FindHome.puma" */
   FindDescriptorHome (t->ALLOCATE_STMT.PARAMS, min_home, good_home);
  }
   return;

  case kDEALLOCATE_STMT:
/* line 390 "FindHome.puma" */
  {
/* line 392 "FindHome.puma" */
   FindDescriptorHome (t->DEALLOCATE_STMT.PARAMS, min_home, good_home);
  }
   return;

  case kCREATE_DSP_STMT:
/* line 395 "FindHome.puma" */
  {
/* line 397 "FindHome.puma" */
   FindDescriptorHome (t->CREATE_DSP_STMT.VAR, min_home, good_home);
  }
   return;

  case kFREE_DSP_STMT:
/* line 400 "FindHome.puma" */
  {
/* line 402 "FindHome.puma" */
   FindDescriptorHome (t->FREE_DSP_STMT.VAR, min_home, good_home);
  }
   return;

  }

/* line 405 "FindHome.puma" */
  {
/* line 407 "FindHome.puma" */
   stmt_protocol ("executed by ALL");
/* line 409 "FindHome.puma" */
   MakeReplicatedDescriptor (good_home);
/* line 410 "FindHome.puma" */
   MakeReplicatedDescriptor (min_home);
  }
   return;

;
}

static void FindParamHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar min_home, pvar good_home)
# else
(t, min_home, good_home)
 register tTree t;
 pvar min_home;
 pvar good_home;
# endif
{
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kADDR) {
/* line 421 "FindHome.puma" */
  {
/* line 423 "FindHome.puma" */
   FindExpHome (t->VAR_PARAM.V->ADDR.E, min_home, good_home);
  }
   return;

  }
/* line 426 "FindHome.puma" */
  {
/* line 428 "FindHome.puma" */
   if (! (((t->VAR_PARAM.intent == IntentOut) || (t->VAR_PARAM.intent == IntentInOut)))) goto yyL2;
  {
/* line 429 "FindHome.puma" */
   FindWriteVarHome (t->VAR_PARAM.V, min_home, good_home);
  }
  }
   return;
yyL2:;

/* line 432 "FindHome.puma" */
  {
/* line 434 "FindHome.puma" */
   FindReadVarHome (t->VAR_PARAM.V, min_home, good_home);
  }
   return;

  }
/* line 439 "FindHome.puma" */
  {
/* line 441 "FindHome.puma" */
   MakeNoDescriptor (min_home);
/* line 442 "FindHome.puma" */
   MakeNoDescriptor (good_home);
  }
   return;

;
}

static void FindParamListHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar min_home, pvar good_home)
# else
(t, min_home, good_home)
 register tTree t;
 pvar min_home;
 pvar good_home;
# endif
{
  if (t->Kind == kBTP_LIST) {
/* line 453 "FindHome.puma" */
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
/* line 458 "FindHome.puma" */
   FindParamHome (t->BTP_LIST.Elem, min_home, good_home);
/* line 459 "FindHome.puma" */
   FindParamListHome (t->BTP_LIST.Next, & min_home1, & good_home1);
/* line 461 "FindHome.puma" */
   UnionHome (min_home, & min_home1);
/* line 462 "FindHome.puma" */
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  }
/* line 465 "FindHome.puma" */
  {
/* line 467 "FindHome.puma" */
   MakeNoDescriptor (min_home);
/* line 468 "FindHome.puma" */
   MakeNoDescriptor (good_home);
  }
   return;

;
}

static void FindExpHome
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar min_home, pvar good_home)
# else
(exp, min_home, good_home)
 register tTree exp;
 pvar min_home;
 pvar good_home;
# endif
{
 yyRecursion:
  if (exp->Kind == kBTE_LIST) {
/* line 479 "FindHome.puma" */
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
/* line 484 "FindHome.puma" */
   FindExpHome (exp->BTE_LIST.Elem, min_home, good_home);
/* line 485 "FindHome.puma" */
   FindExpHome (exp->BTE_LIST.Next, & min_home1, & good_home1);
/* line 487 "FindHome.puma" */
   UnionHome (min_home, & min_home1);
/* line 488 "FindHome.puma" */
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  }
  if (exp->Kind == kOP_EXP) {
/* line 491 "FindHome.puma" */
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
/* line 496 "FindHome.puma" */
   FindExpHome (exp->OP_EXP.OPND1, min_home, good_home);
/* line 497 "FindHome.puma" */
   FindExpHome (exp->OP_EXP.OPND2, & min_home1, & good_home1);
/* line 499 "FindHome.puma" */
   UnionHome (min_home, & min_home1);
/* line 500 "FindHome.puma" */
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  }
  if (exp->Kind == kOP1_EXP) {
/* line 503 "FindHome.puma" */
  {
/* line 505 "FindHome.puma" */
   exp = exp->OP1_EXP.OPND;
   goto yyRecursion;
  }

  }
  if (exp->Kind == kVAR_EXP) {
/* line 508 "FindHome.puma" */
  {
/* line 510 "FindHome.puma" */
   FindReadVarHome (exp->VAR_EXP.V, min_home, good_home);
  }
   return;

  }
  if (exp->Kind == kFUNC_CALL_EXP) {
/* line 513 "FindHome.puma" */
  {
/* line 515 "FindHome.puma" */
   if (! ((IsPureCall (exp)))) goto yyL5;
  {
/* line 517 "FindHome.puma" */
   FindParamListHome (exp->FUNC_CALL_EXP.FUNC_PARAMS, min_home, good_home);
  }
  }
   return;
yyL5:;

/* line 520 "FindHome.puma" */
  {
/* line 522 "FindHome.puma" */
   if (! ((IsSerialCall (exp)))) goto yyL6;
  {
/* line 524 "FindHome.puma" */
   FindParamListHome (exp->FUNC_CALL_EXP.FUNC_PARAMS, min_home, good_home);
/* line 526 "FindHome.puma" */
   MakeNoDescriptor (min_home);
  }
  }
   return;
yyL6:;

/* line 531 "FindHome.puma" */
  {
/* line 533 "FindHome.puma" */
   tree_protocol ("function call requires replicated execution : ", exp);
/* line 535 "FindHome.puma" */
   MakeReplicatedDescriptor (min_home);
/* line 536 "FindHome.puma" */
   MakeReplicatedDescriptor (good_home);
  }
   return;

  }
/* line 539 "FindHome.puma" */
  {
/* line 541 "FindHome.puma" */
   MakeNoDescriptor (min_home);
/* line 542 "FindHome.puma" */
   MakeNoDescriptor (good_home);
  }
   return;

;
}

static void FindVarHome
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar min_home, pvar good_home)
# else
(var, min_home, good_home)
 register tTree var;
 pvar min_home;
 pvar good_home;
# endif
{
/* line 565 "FindHome.puma" */
  {
/* line 567 "FindHome.puma" */
   if (! ((GetCurrentModel () == HPF_TASK))) goto yyL1;
  {
/* line 569 "FindHome.puma" */
   if (! ((IsGlobalVar (var, GetCurrentUnitObject ())))) goto yyL1;
  {
/* line 571 "FindHome.puma" */
   MakeNoDescriptor (min_home);
/* line 572 "FindHome.puma" */
   MakeParLoopNestDescriptor (good_home);
  }
  }
  }
   return;
yyL1:;

/* line 575 "FindHome.puma" */
  {
/* line 577 "FindHome.puma" */
   if (! ((IsDescriptorVar (var)))) goto yyL2;
  {
/* line 579 "FindHome.puma" */
   SetVarDescriptor (var, good_home);
/* line 580 "FindHome.puma" */
   MakeNoDescriptor (min_home);
  }
  }
   return;
yyL2:;

  if (var->Kind == kINDEXED_VAR) {
/* line 583 "FindHome.puma" */
  {
/* line 587 "FindHome.puma" */
   FindExpHome (var->INDEXED_VAR.IND_EXPS, min_home, good_home);
  }
   return;

  }
/* line 590 "FindHome.puma" */
  {
/* line 592 "FindHome.puma" */
   MakeNoDescriptor (min_home);
/* line 593 "FindHome.puma" */
   MakeNoDescriptor (good_home);
  }
   return;

;
}

static void FindReadVarHome
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar min_home, pvar good_home)
# else
(var, min_home, good_home)
 register tTree var;
 pvar min_home;
 pvar good_home;
# endif
{
/* line 615 "FindHome.puma" */
  {
/* line 617 "FindHome.puma" */
   if (! ((IsNewVariable (var)))) goto yyL1;
  {
/* line 619 "FindHome.puma" */
   MakeNoDescriptor (min_home);
/* line 620 "FindHome.puma" */
   MakeNoDescriptor (good_home);
  }
  }
   return;
yyL1:;

/* line 623 "FindHome.puma" */
  {
/* line 625 "FindHome.puma" */
   FindVarHome (var, min_home, good_home);
/* line 627 "FindHome.puma" */
   if (! ((IsParallelHomeDescriptor (good_home)))) goto yyL2;
  }
   return;
yyL2:;

/* line 630 "FindHome.puma" */
  {
/* line 632 "FindHome.puma" */
   FindVarHome (var, min_home, good_home);
/* line 634 "FindHome.puma" */
   if (! ((! IsNoDescriptor (good_home)))) goto yyL3;
  {
/* line 635 "FindHome.puma" */
   if (! ((TreeWriteDistribution (var) == 1))) goto yyL3;
  {
/* line 636 "FindHome.puma" */
   MakeNoDescriptor (min_home);
  }
  }
  }
   return;
yyL3:;

/* line 639 "FindHome.puma" */
  {
/* line 641 "FindHome.puma" */
   MakeParLoopNestDescriptor (good_home);
/* line 642 "FindHome.puma" */
   MakeNoDescriptor (min_home);
  }
   return;

;
}

static void FindWriteVarHome
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar min_home, pvar good_home)
# else
(var, min_home, good_home)
 register tTree var;
 pvar min_home;
 pvar good_home;
# endif
{
/* line 661 "FindHome.puma" */
  {
/* line 663 "FindHome.puma" */
   if (! ((IsNewVariable (var)))) goto yyL1;
  {
/* line 665 "FindHome.puma" */
   MakeNoDescriptor (min_home);
/* line 666 "FindHome.puma" */
   MakeNoDescriptor (good_home);
  }
  }
   return;
yyL1:;

  if (var->Kind == kUSED_VAR) {
/* line 669 "FindHome.puma" */
  {
/* line 673 "FindHome.puma" */
   if (! ((TreeRank (var->USED_VAR.VARNAME) == 0))) goto yyL2;
  {
/* line 674 "FindHome.puma" */
   if (! ((TreeWriteDistribution (var->USED_VAR.VARNAME) == 0))) goto yyL2;
  {
/* line 676 "FindHome.puma" */
 if (IsParallelMasked ())

        { MakeNoDescriptor (min_home);
          MakeReplicatedDescriptor (good_home);
        }
   
      else

        { MakeNoDescriptor (min_home);
          MakeNoDescriptor (good_home);
        }
   
  }
  }
  }
   return;
yyL2:;

  }
/* line 690 "FindHome.puma" */
  {
/* line 692 "FindHome.puma" */
   FindVarHome (var, min_home, good_home);
/* line 694 "FindHome.puma" */
   if (! ((IsParallelHomeDescriptor (good_home)))) goto yyL3;
  }
   return;
yyL3:;

/* line 697 "FindHome.puma" */
  {
/* line 699 "FindHome.puma" */
   MakeNoDescriptor (min_home);
/* line 700 "FindHome.puma" */
   MakeReplicatedDescriptor (good_home);
  }
   return;

;
}

static void FindDescriptorHome
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar min_home, pvar good_home)
# else
(t, min_home, good_home)
 register tTree t;
 pvar min_home;
 pvar good_home;
# endif
{
 yyRecursion:
  if (t->Kind == kVAR_PARAM) {
/* line 716 "FindHome.puma" */
  {
/* line 718 "FindHome.puma" */
   t = t->VAR_PARAM.V;
   goto yyRecursion;
  }

  }
  if (t->Kind == kINDEXED_VAR) {
/* line 721 "FindHome.puma" */
  {
/* line 723 "FindHome.puma" */
   t = t->INDEXED_VAR.IND_VAR;
   goto yyRecursion;
  }

  }
  if (t->Kind == kSELECTED_VAR) {
/* line 726 "FindHome.puma" */
  {
/* line 728 "FindHome.puma" */
   MakeReplicatedDescriptor (min_home);
/* line 729 "FindHome.puma" */
   MakeReplicatedDescriptor (good_home);
  }
   return;

  }
  if (t->Kind == kUSED_VAR) {
/* line 732 "FindHome.puma" */
  {
/* line 734 "FindHome.puma" */
   if (! ((IsNewVariable (t)))) goto yyL4;
  {
/* line 736 "FindHome.puma" */
   MakeNoDescriptor (min_home);
/* line 737 "FindHome.puma" */
   MakeNoDescriptor (good_home);
  }
  }
   return;
yyL4:;

/* line 740 "FindHome.puma" */
  {
/* line 742 "FindHome.puma" */
   stmt_protocol ("ALLOCATE/DEALLOCATE replicated (not NEW)");
/* line 743 "FindHome.puma" */
   tree_protocol ("due to this variable : ", t);
/* line 745 "FindHome.puma" */
   MakeReplicatedDescriptor (min_home);
/* line 746 "FindHome.puma" */
   MakeReplicatedDescriptor (good_home);
  }
   return;

  }
  if (t->Kind == kBTP_LIST) {
/* line 749 "FindHome.puma" */
 {
  var_descriptor min_home1;
  var_descriptor good_home1;
  {
/* line 754 "FindHome.puma" */
   FindDescriptorHome (t->BTP_LIST.Elem, min_home, good_home);
/* line 755 "FindHome.puma" */
   FindDescriptorHome (t->BTP_LIST.Next, & min_home1, & good_home1);
/* line 757 "FindHome.puma" */
   UnionHome (min_home, & min_home1);
/* line 758 "FindHome.puma" */
   ChooseHome (good_home, & good_home1);
  }
   return;
 }

  }
  if (t->Kind == kBTP_EMPTY) {
/* line 761 "FindHome.puma" */
  {
/* line 763 "FindHome.puma" */
   MakeNoDescriptor (min_home);
/* line 764 "FindHome.puma" */
   MakeNoDescriptor (good_home);
  }
   return;

  }
/* line 767 "FindHome.puma" */
  {
/* line 769 "FindHome.puma" */
   tree_error_protocol ("unknown structure for ALLOCATE/..", t);
/* line 771 "FindHome.puma" */
   MakeReplicatedDescriptor (min_home);
/* line 772 "FindHome.puma" */
   MakeReplicatedDescriptor (good_home);
  }
   return;

;
}

static void ChooseHome
# if defined __STDC__ | defined __cplusplus
(pvar home1, pvar home2)
# else
(home1, home2)
 pvar home1;
 pvar home2;
# endif
{
/* line 791 "FindHome.puma" */
  {
/* line 793 "FindHome.puma" */

#ifdef DEBUG
     printf ("CHOOSE of ");
     FileUnparse (stdout, PrintableDescriptorVar (home1));
     printf (" and "); 
     FileUnparse (stdout, PrintableDescriptorVar (home2));
     printf (" = ");
#endif
     ChooseBestHome (home1, home2);
#ifdef DEBUG
     FileUnparse (stdout, PrintableDescriptorVar (home1));
     printf ("\n");
#endif 
   
  }
   return;

;
}

static void ChooseBestHome
# if defined __STDC__ | defined __cplusplus
(pvar home1, pvar home2)
# else
(home1, home2)
 pvar home1;
 pvar home2;
# endif
{
/* line 817 "FindHome.puma" */
  {
/* line 819 "FindHome.puma" */
   if (! ((IsNoDescriptor (home1)))) goto yyL1;
  {
/* line 820 "FindHome.puma" */
 *home1 = *home2; 
  }
  }
   return;
yyL1:;

/* line 823 "FindHome.puma" */
  {
/* line 825 "FindHome.puma" */
   if (! ((IsNoDescriptor (home2)))) goto yyL2;
  }
   return;
yyL2:;

/* line 836 "FindHome.puma" */
  {
/* line 838 "FindHome.puma" */
   if (! ((home1 -> var_tree != NoTree))) goto yyL3;
  {
/* line 839 "FindHome.puma" */
   if (! ((home2 -> var_tree == NoTree))) goto yyL3;
  }
  }
   return;
yyL3:;

/* line 842 "FindHome.puma" */
  {
/* line 844 "FindHome.puma" */
   if (! ((home1 -> var_tree == NoTree))) goto yyL4;
  {
/* line 845 "FindHome.puma" */
   if (! ((home2 -> var_tree != NoTree))) goto yyL4;
  {
/* line 847 "FindHome.puma" */
 *home1 = *home2; 
  }
  }
  }
   return;
yyL4:;

/* line 865 "FindHome.puma" */
  {
/* line 867 "FindHome.puma" */
   if (! ((IsParallelHomeDescriptor (home1)))) goto yyL5;
  {
/* line 868 "FindHome.puma" */
   if (! ((! IsParallelHomeDescriptor (home2)))) goto yyL5;
  }
  }
   return;
yyL5:;

/* line 871 "FindHome.puma" */
  {
/* line 873 "FindHome.puma" */
   if (! ((! IsParallelHomeDescriptor (home1)))) goto yyL6;
  {
/* line 874 "FindHome.puma" */
   if (! ((IsParallelHomeDescriptor (home2)))) goto yyL6;
  {
/* line 876 "FindHome.puma" */
 *home1 = *home2; 
  }
  }
  }
   return;
yyL6:;

/* line 885 "FindHome.puma" */
  {
/* line 887 "FindHome.puma" */
   if (! ((home1 -> topology_rank > 0))) goto yyL7;
  {
/* line 888 "FindHome.puma" */
   if (! ((home2 -> topology_rank == 0))) goto yyL7;
  }
  }
   return;
yyL7:;

/* line 891 "FindHome.puma" */
  {
/* line 893 "FindHome.puma" */
   if (! ((home1 -> topology_rank == 0))) goto yyL8;
  {
/* line 894 "FindHome.puma" */
   if (! ((home2 -> topology_rank > 0))) goto yyL8;
  {
/* line 896 "FindHome.puma" */
 *home1 = *home2; 
  }
  }
  }
   return;
yyL8:;

/* line 899 "FindHome.puma" */
   return;

;
}

static void UnionHome
# if defined __STDC__ | defined __cplusplus
(pvar home1, pvar home2)
# else
(home1, home2)
 pvar home1;
 pvar home2;
# endif
{
/* line 919 "FindHome.puma" */
  {
/* line 921 "FindHome.puma" */

#ifdef DEBUG
     printf ("UNION of ");
     FileUnparse (stdout, PrintableDescriptorVar (home1));
     printf (" and "); 
     FileUnparse (stdout, PrintableDescriptorVar (home2));
     printf (" = ");
#endif
     UnionHomeDescriptor (home1, home2);
#ifdef DEBUG
     FileUnparse (stdout, PrintableDescriptorVar (home1));
     printf ("\n");
#endif 
   
  }
   return;

;
}

static void ExpandHomes
# if defined __STDC__ | defined __cplusplus
(pvar min_home, pvar good_home, register tTree id)
# else
(min_home, good_home, id)
 pvar min_home;
 pvar good_home;
 register tTree id;
# endif
{
/* line 945 "FindHome.puma" */
 {
  rbool okay;
  {
/* line 949 "FindHome.puma" */

#ifdef DEBUG
     printf ("EXPAND of min_home ");
     FileUnparse (stdout, PrintableDescriptorVar (min_home));
     printf (" = ");
#endif

     ExpandDescriptor (min_home, id, &okay);

#ifdef DEBUG
     FileUnparse (stdout, PrintableDescriptorVar (min_home));
     printf ("\n");
#endif 

     if (!okay)

       { stmt_protocol ("minimal home of loop body not expanded");
         tree_protocol ("minimal home of loop body is : ", 
                         MakeDescriptorVar (min_home));
         MakeReplicatedDescriptor (min_home);
       }

#ifdef DEBUG
     printf ("EXPAND of good_home ");
     FileUnparse (stdout, PrintableDescriptorVar (good_home));
     printf (" = ");
#endif

     ExpandDescriptor (good_home, id, &okay);

#ifdef DEBUG
     FileUnparse (stdout, PrintableDescriptorVar (good_home));
     printf ("\n");
#endif 

     if (!okay)

       { stmt_protocol ("good home of loop body not expanded");
         tree_protocol ("good home of loop body is : ", 
                         MakeDescriptorVar (good_home));
         MakeReplicatedDescriptor (good_home);
       }
   
  }
   return;
 }

;
}

static void PrintHomes
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar min_home, pvar good_home)
# else
(t, min_home, good_home)
 register tTree t;
 pvar min_home;
 pvar good_home;
# endif
{
/* line 1002 "FindHome.puma" */
  {
/* line 1004 "FindHome.puma" */
 
#ifdef DEBUG
      printf ("HOME of ");
      FileUnparse (stdout, t);
      printf (" is min = ");
      FileUnparse (stdout, PrintableDescriptorVar (min_home));
      printf (" and good = ");
      FileUnparse (stdout, PrintableDescriptorVar (good_home));
      printf ("\n");
#endif 
   
  }
   return;

;
}

void FindSerialHome
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar home, register rbool * yyP1)
# else
(stmt, home, yyP1)
 register tTree stmt;
 pvar home;
 register rbool * yyP1;
# endif
{
  if (stmt->Kind == kCALL_STMT) {
/* line 1027 "FindHome.puma" */
 {
  rbool yyV1;
  {
/* line 1029 "FindHome.puma" */
   FindSerialHome (stmt->CALL_STMT.CALL_PARAMS, home, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  if (stmt->Kind == kASSIGN_STMT) {
  if (stmt->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 1032 "FindHome.puma" */
 {
  var_descriptor min_home;
  {
/* line 1036 "FindHome.puma" */
   FindVarHome (stmt->ASSIGN_STMT.ASSIGN_VAR, & min_home, home);
/* line 1038 "FindHome.puma" */
   if (! ((IsNoDescriptor (& min_home)))) goto yyL2;
  {
/* line 1039 "FindHome.puma" */
   if (! ((IsSerialDescriptor (home)))) goto yyL2;
  {
/* line 1040 "FindHome.puma" */
   if (! ((! CountCommunication (home, stmt->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL2;
  {
/* line 1041 "FindHome.puma" */
   if (! ((! CountCommunication (home, stmt->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL2;
  }
  }
  }
  }
   * yyP1 = rtrue;
   return;
 }
yyL2:;

  }
  }
  if (stmt->Kind == kBTP_LIST) {
/* line 1044 "FindHome.puma" */
 {
  var_descriptor min_home;
  {
/* line 1048 "FindHome.puma" */
   FindParamListHome (stmt, & min_home, home);
/* line 1050 "FindHome.puma" */
   if (! ((IsNoDescriptor (& min_home)))) goto yyL3;
  {
/* line 1051 "FindHome.puma" */
   if (! ((IsSerialDescriptor (home)))) goto yyL3;
  {
/* line 1052 "FindHome.puma" */
   if (! ((! CountCommunication (home, stmt)))) goto yyL3;
  }
  }
  }
   * yyP1 = rtrue;
   return;
 }
yyL3:;

  }
/* line 1055 "FindHome.puma" */
   * yyP1 = rfalse;
   return;

;
}

void BeginFindHome ARGS ((void))
{
}

void CloseFindHome ARGS ((void))
{
}
