# include "FinalCode.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 27 "FinalCode.puma" */


# include <stdio.h>
# include <string.h>

# include "protocol.h"
# include "Idents.h"

# include "Objects.h"
# include "TreeOps.h"
# include "Transform.h"
# include "Expressions.h"
# include "Dalib.h" 
# include "Types.h"         /* TreeType */
# include "Nesting.h"
# include "Traverse.h"
# include "Reductions.h"    /* GetGlobalOp, GetReductionZero */

# include "SMParallel.h"    /* AutoScope                     */
# include "Intrinsics.h"    /* IntrFuncScan                  */

# include "CodeGeneral.h"

/*********************************************************************
*                                                                    *
*  Note : NewHelpVars of Module 'Dalib' is also used                 *
*                                                                    *
*********************************************************************/

static tTree NewInitStatements;

# define MODULE "FinalCode"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyFinalCode.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* FinalCode_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module FinalCode, routine %s failed\n",
  yyFunction);
 FinalCode_Exit ();
}

void FinalCode ARGS ((tTree t));
static void FinalBodyCode ARGS ((tTree body));
static rbool StopCode ARGS ((tTree t));
static tTree ChangeCode ARGS ((tTree t));
static tTree TranslateRankExp ARGS ((int kind));
static tTree TranslateBoundExp ARGS ((tTree t));
static tIdent GetBoundId ARGS ((int kind, int local));
static tTree TranslateSizeExp ARGS ((tTree var, int size));
static void AddIndex1 ARGS ((tTree var));
static void GenTraceStatements ARGS ((tTree body, tIdent subroutine_name));
static void MakeFinalIntrFuncCall ARGS ((tTree func_call));
static rbool IsKindIntrinsic ARGS ((tIdent name));
static void RemoveKindParam ARGS ((tTree params));
static void RemoveIndexBackParam ARGS ((tTree params));
static rbool IsFalseParam ARGS ((tTree t));
static void MakeFullParam ARGS ((tTree param));
static rbool IsDalibRoutine ARGS ((tIdent name));
static tIdent MakeDalibRoutine ARGS ((tIdent name));
static tTree MakeDalibExitStmt ARGS ((void));
static void SetInitStmt ARGS ((tTree body));
static tTree NotPresentArgument ARGS ((void));
static tTree NotPresentString ARGS ((void));
static void MakeFinalIntrSubCall ARGS ((tTree call));
static tIdent MakeTypedDalibRoutine ARGS ((tIdent name, tTree params));
static void GenModuleInit ARGS ((tTree body, tIdent module_name));
static tIdent MakeInitRoutineName ARGS ((tIdent module_name));
static tIdent MakeInitVarName ARGS ((tIdent module_name));
static tTree MakeModuleInitCall ARGS ((tIdent module_name));
static tTree AttributeComponents ARGS ((tTree components));
static rbool ShouldBeCombined ARGS ((tTree d1, tTree d2));
static tTree CombineAttributes ARGS ((tTree d1, tTree d2));

void FinalCode
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 70 "FinalCode.puma" */
  {
/* line 72 "FinalCode.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  case kUNIT_LIST:
/* line 75 "FinalCode.puma" */
  {
/* line 77 "FinalCode.puma" */
   FinalCode (t->UNIT_LIST.Elem);
/* line 78 "FinalCode.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kUNIT_EMPTY:
/* line 81 "FinalCode.puma" */
   return;

  case kPROGRAM_DECL:
/* line 84 "FinalCode.puma" */
  {
/* line 86 "FinalCode.puma" */
   NestOpenUnit (t);
/* line 87 "FinalCode.puma" */
   GenTraceStatements (t->PROGRAM_DECL.PROGRAM_BODY, t->PROGRAM_DECL.Ident);
/* line 88 "FinalCode.puma" */
   FinalBodyCode (t->PROGRAM_DECL.PROGRAM_BODY);
/* line 89 "FinalCode.puma" */
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
/* line 92 "FinalCode.puma" */
  {
/* line 95 "FinalCode.puma" */
   NestOpenUnit (t);
/* line 97 "FinalCode.puma" */
   GenTraceStatements (t->PROC_DECL.PROC_BODY, t->PROC_DECL.Ident);
/* line 99 "FinalCode.puma" */
   FinalBodyCode (t->PROC_DECL.PROC_BODY);
/* line 101 "FinalCode.puma" */
 t->PROC_DECL.IsPure = rfalse;        
      t->PROC_DECL.HPFExtrinsic  = DefaultId();  
    
/* line 105 "FinalCode.puma" */
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
/* line 108 "FinalCode.puma" */
  {
/* line 112 "FinalCode.puma" */
   NestOpenUnit (t);
/* line 114 "FinalCode.puma" */
   GenTraceStatements (t->FUNC_DECL.FUNC_BODY, t->FUNC_DECL.Ident);
/* line 116 "FinalCode.puma" */
   FinalBodyCode (t->FUNC_DECL.FUNC_BODY);
/* line 118 "FinalCode.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
/* line 121 "FinalCode.puma" */
  {
/* line 123 "FinalCode.puma" */
   NestOpenUnit (t);
/* line 125 "FinalCode.puma" */
   FinalBodyCode (t->MODULE_DECL.MODULE_BODY);
/* line 127 "FinalCode.puma" */
   GenModuleInit (t->MODULE_DECL.MODULE_BODY, t->MODULE_DECL.Ident);
/* line 129 "FinalCode.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 132 "FinalCode.puma" */
  {
/* line 134 "FinalCode.puma" */
   NestOpenUnit (t);
/* line 136 "FinalCode.puma" */
   FinalBodyCode (t->BLOCK_DATA_DECL.DATA_BODY);
/* line 138 "FinalCode.puma" */
   NestCloseUnit (t);
  }
   return;

  }

/* line 141 "FinalCode.puma" */
  {
/* line 142 "FinalCode.puma" */
   failure_protocol (MODULE, "FinalCode", t);
  }
   return;

;
}

static void FinalBodyCode
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
/* line 153 "FinalCode.puma" */
  {
/* line 156 "FinalCode.puma" */
   NewHelpVars = mDECL_EMPTY ();
/* line 157 "FinalCode.puma" */
   NewInitStatements = NoTree;
/* line 159 "FinalCode.puma" */
 body->BODY_NODE.DECLS     = ReplaceAST (body->BODY_NODE.DECLS, StopCode, ChangeCode); 
      body->BODY_NODE.NEW_DECLS = ReplaceAST (body->BODY_NODE.NEW_DECLS, StopCode, ChangeCode);
      body->BODY_NODE.STATS     = ReplaceAST (body->BODY_NODE.STATS, StopCode, ChangeCode);

      

      body->BODY_NODE.STATS = CombineACF (NewInitStatements, body->BODY_NODE.STATS);

      

      if (IsMainUnit (GetCurrentUnit ()))
  
          SetInitStmt (body);

      body->BODY_NODE.NEW_DECLS = AppendDECLS (body->BODY_NODE.NEW_DECLS, NewHelpVars);

    
/* line 177 "FinalCode.puma" */
   FinalCode (body->BODY_NODE.INTERNALS);
  }
   return;

  }
/* line 180 "FinalCode.puma" */
  {
/* line 181 "FinalCode.puma" */
   failure_protocol (MODULE, "FinalBodyCode", body);
  }
   return;

;
}

static rbool StopCode
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 186 "FinalCode.puma" */
  {
/* line 187 "FinalCode.puma" */
   return rfalse;
  }

}

static tTree ChangeCode
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kUSE_DECL:
/* line 200 "FinalCode.puma" */
  {
/* line 202 "FinalCode.puma" */
   if (! ((t->USE_DECL.use == IsIdent ("HPF_LIBRARY")))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 207 "FinalCode.puma" */
  {
/* line 209 "FinalCode.puma" */
   if (! ((t->USE_DECL.use == IsIdent ("HPF_LOCAL_LIBRARY")))) goto yyL2;
  }
   return NoTree;
yyL2:;

/* line 214 "FinalCode.puma" */
  {
/* line 216 "FinalCode.puma" */
   if (! ((t->USE_DECL.use == IsIdent ("HPF_TASK_LIBRARY")))) goto yyL3;
  }
   return NoTree;
yyL3:;

/* line 221 "FinalCode.puma" */
  {
/* line 223 "FinalCode.puma" */
   NewInitStatements = CombineACF (MakeModuleInitCall (t->USE_DECL.use), NewInitStatements);
  }
   return t;

  case kONLY_USE_DECL:
/* line 229 "FinalCode.puma" */
  {
/* line 231 "FinalCode.puma" */
   NewInitStatements = CombineACF (MakeModuleInitCall (t->ONLY_USE_DECL.use), NewInitStatements);
  }
   return t;

  case kVAR_DECL:
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
/* line 237 "FinalCode.puma" */
   return t;

  }
  break;
  case kTEMPLATE_DECL:
/* line 242 "FinalCode.puma" */
   return t;

  case kTYPE_DECL:
  if (t->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
/* line 247 "FinalCode.puma" */
  {
/* line 249 "FinalCode.puma" */
 t->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS = AttributeComponents (t->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS); 
  }
   return t;

  }
  break;
  case kBOUND_EXP:
/* line 254 "FinalCode.puma" */
   return TranslateBoundExp (t);

  case kRANK_EXP:
/* line 259 "FinalCode.puma" */
   return TranslateRankExp (t->RANK_EXP.kind);

  case kSIZE_EXP:
/* line 264 "FinalCode.puma" */
   return TranslateSizeExp (t->SIZE_EXP.VAR, t->SIZE_EXP.ass_size);

  case kCALL_STMT:
/* line 269 "FinalCode.puma" */
  {
/* line 271 "FinalCode.puma" */
   if (! ((IsIntrCall (t)))) goto yyL12;
  {
/* line 273 "FinalCode.puma" */
   MakeFinalIntrSubCall (t);
  }
  }
   return t;
yyL12:;

  break;
  case kFUNC_CALL_EXP:
/* line 278 "FinalCode.puma" */
  {
/* line 280 "FinalCode.puma" */
   if (! ((IsIntrCall (t)))) goto yyL13;
  {
/* line 282 "FinalCode.puma" */
   MakeFinalIntrFuncCall (t);
  }
  }
   return t;
yyL13:;

  break;
  case kNO_PARAM:
/* line 287 "FinalCode.puma" */
  {
/* line 289 "FinalCode.puma" */
   if (! ((t->NO_PARAM.type == kSTRING_TYPE))) goto yyL14;
  }
   return NotPresentString ();
yyL14:;

/* line 294 "FinalCode.puma" */
   return NotPresentArgument ();

  case kACF_PARALLEL:
/* line 299 "FinalCode.puma" */
  {
/* line 301 "FinalCode.puma" */
   AutoScope (t);
  }
   return FinalSM (t);

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kSTOP_STMT) {
/* line 306 "FinalCode.puma" */
   return CombineACF (MakeDalibExitStmt (), CombineACF (t, NoTree));

  }
  break;
  }

/* line 311 "FinalCode.puma" */
   return t;

}

static tTree TranslateRankExp
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
/* line 326 "FinalCode.puma" */
 {
  tTree call;
  tIdent name;
  {
/* line 331 "FinalCode.puma" */
 if (kind == 0)
       name = MakeDalibId ("processors_rank");
     else
       name = MakeDalibId ("active_procs_rank");
    DefineNewHelpFn (name);
    call = mFUNC_CALL_EXP (mPROC_OBJ (name), mBTP_EMPTY ());
  
  }
   return call;
 }

}

static tTree TranslateBoundExp
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBOUND_EXP) {
/* line 350 "FinalCode.puma" */
 {
  tTree call;
  tIdent name;
  {
/* line 355 "FinalCode.puma" */
 call = mBTP_LIST (ExpToVarParam (MakeConstant(t->BOUND_EXP.dim)), mBTP_EMPTY ());
     call = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (t->BOUND_EXP.VAR, "_DSP")), call);
     name = GetBoundId (t->BOUND_EXP.kind, t->BOUND_EXP.local);
     DefineNewHelpFn (name);
     call = mFUNC_CALL_EXP (mPROC_OBJ (name), call);
   
  }
   return call;
 }

  }
/* line 364 "FinalCode.puma" */
  {
/* line 365 "FinalCode.puma" */
   failure_protocol (MODULE, "TranslateBoundExp", t);
  }
   return NoTree;

}

static tIdent GetBoundId
# if defined __STDC__ | defined __cplusplus
(register int kind, register int local)
# else
(kind, local)
 register int kind;
 register int local;
# endif
{
/* line 381 "FinalCode.puma" */
  {
/* line 383 "FinalCode.puma" */
   if (! ((kind == 0))) goto yyL1;
  {
/* line 384 "FinalCode.puma" */
   if (! ((local == 0))) goto yyL1;
  }
  }
   return MakeDalibId ("lbound");
yyL1:;

/* line 389 "FinalCode.puma" */
  {
/* line 391 "FinalCode.puma" */
   if (! ((kind == 0))) goto yyL2;
  {
/* line 392 "FinalCode.puma" */
   if (! ((local == 1))) goto yyL2;
  }
  }
   return MakeDalibId ("local_lbound");
yyL2:;

/* line 397 "FinalCode.puma" */
  {
/* line 399 "FinalCode.puma" */
   if (! ((kind == 0))) goto yyL3;
  {
/* line 400 "FinalCode.puma" */
   if (! ((local == 2))) goto yyL3;
  }
  }
   return MakeDalibId ("global_lbound");
yyL3:;

/* line 405 "FinalCode.puma" */
  {
/* line 407 "FinalCode.puma" */
   if (! ((kind == 1))) goto yyL4;
  {
/* line 408 "FinalCode.puma" */
   if (! ((local == 0))) goto yyL4;
  }
  }
   return MakeDalibId ("ubound");
yyL4:;

/* line 412 "FinalCode.puma" */
  {
/* line 414 "FinalCode.puma" */
   if (! ((kind == 1))) goto yyL5;
  {
/* line 415 "FinalCode.puma" */
   if (! ((local == 1))) goto yyL5;
  }
  }
   return MakeDalibId ("local_ubound");
yyL5:;

/* line 420 "FinalCode.puma" */
  {
/* line 422 "FinalCode.puma" */
   if (! ((kind == 1))) goto yyL6;
  {
/* line 423 "FinalCode.puma" */
   if (! ((local == 2))) goto yyL6;
  }
  }
   return MakeDalibId ("global_ubound");
yyL6:;

/* line 428 "FinalCode.puma" */
  {
/* line 430 "FinalCode.puma" */
   failure_protocol (MODULE, "GetBoundId", NoTree);
  }
   return MakeDalibId ("unknown");

}

static tTree TranslateSizeExp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int size)
# else
(var, size)
 register tTree var;
 register int size;
# endif
{
/* line 443 "FinalCode.puma" */
 {
  tTree call;
  tIdent name;
  tTree var1;
  {
/* line 449 "FinalCode.puma" */
 call = mBTP_LIST (ExpToVarParam (MakeConstant(size)), mBTP_EMPTY ());
     var1 = CopyTree (var);
     AddIndex1 (var1);
     call = mBTP_LIST (mVAR_PARAM (var1), call);
     call = mBTP_LIST (mVAR_PARAM (var), call);
     name = MakeDalibId ("size");
     DefineNewHelpFn (name);
     call = mFUNC_CALL_EXP (mPROC_OBJ (name), call);
   
  }
   return call;
 }

}

static void AddIndex1
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kINDEXED_VAR) {
/* line 469 "FinalCode.puma" */
  {
/* line 471 "FinalCode.puma" */
   var = var->INDEXED_VAR.IND_EXPS;
   goto yyRecursion;
  }

  }
  if (var->Kind == kBTE_LIST) {
/* line 474 "FinalCode.puma" */
  {
/* line 476 "FinalCode.puma" */
 var->BTE_LIST.Elem = AddConstant (var->BTE_LIST.Elem, 1); 
  }
   return;

  }
/* line 479 "FinalCode.puma" */
  {
/* line 481 "FinalCode.puma" */
   failure_protocol (MODULE, "AddIndex1", var);
  }
   return;

;
}

static void GenTraceStatements
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tIdent subroutine_name)
# else
(body, subroutine_name)
 register tTree body;
 register tIdent subroutine_name;
# endif
{
/* line 498 "FinalCode.puma" */

char subroutine_string [256];
int  subroutine_length;
tStringRef ref;

  if (body->Kind == kBODY_NODE) {
/* line 504 "FinalCode.puma" */
 {
  tTree stmt;
  tTree params;
  {
/* line 510 "FinalCode.puma" */
 stmt = mPROC_OBJ (MakeDalibId ("start_subroutine"));
 
    GetString (subroutine_name, subroutine_string);
    subroutine_length = strlen (subroutine_string);
 
    ref = PutString (subroutine_string, subroutine_length);
 
    params = mBTP_EMPTY ();
    params = mBTP_LIST (ExpToVarParam (MakeConstant (subroutine_length)),
                        params);
    params = mBTP_LIST (ExpToVarParam (mCONST_EXP (mSTRING_CONSTANT (ref))),
                        params);
 
    stmt = mACF_BASIC (mCALL_STMT (stmt, params));
 
    body->BODY_NODE.STATS = mACF_LIST (stmt, body->BODY_NODE.STATS);
 
    stmt = mPROC_OBJ (MakeDalibId ("end_subroutine"));
    stmt = mACF_BASIC (mCALL_STMT (stmt, mBTP_EMPTY()));
    stmt = mACF_LIST (stmt, mACF_EMPTY());
 
    body->BODY_NODE.STATS = CombineACF (body->BODY_NODE.STATS, stmt);
 
  
  }
   return;
 }

  }
/* line 536 "FinalCode.puma" */
  {
/* line 537 "FinalCode.puma" */
   failure_protocol (MODULE, "GenTraceStatements", body);
  }
   return;

;
}

static void MakeFinalIntrFuncCall
# if defined __STDC__ | defined __cplusplus
(register tTree func_call)
# else
(func_call)
 register tTree func_call;
# endif
{
  if (func_call->Kind == kFUNC_CALL_EXP) {
/* line 551 "FinalCode.puma" */
  {
/* line 553 "FinalCode.puma" */
   if (! ((func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("NUMBER_OF_PROCESSORS")))) goto yyL1;
  {
/* line 555 "FinalCode.puma" */
 func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = MakeDalibId ("all_procs");
     DefineNewHelpFn (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
   
  }
  }
   return;
yyL1:;

/* line 560 "FinalCode.puma" */
  {
/* line 562 "FinalCode.puma" */
   if (! ((func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("ACTIVE_NUM_PROCS")))) goto yyL2;
  {
/* line 564 "FinalCode.puma" */
 func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = MakeDalibId ("active_procs");
     DefineNewHelpFn (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
   
  }
  }
   return;
yyL2:;

/* line 569 "FinalCode.puma" */
  {
/* line 571 "FinalCode.puma" */
   if (! ((func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("MY_PROCESSOR")))) goto yyL3;
  {
/* line 573 "FinalCode.puma" */
 func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = MakeDalibId ("my_processor");
     DefineNewHelpFn (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
   
  }
  }
   return;
yyL3:;

/* line 578 "FinalCode.puma" */
  {
/* line 580 "FinalCode.puma" */
   if (! ((IsKindIntrinsic (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL4;
  {
/* line 581 "FinalCode.puma" */
   RemoveKindParam (func_call->FUNC_CALL_EXP.FUNC_PARAMS);
  }
  }
   return;
yyL4:;

/* line 584 "FinalCode.puma" */
  {
/* line 586 "FinalCode.puma" */
   if (! ((func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("INDEX")))) goto yyL5;
  {
/* line 587 "FinalCode.puma" */
   RemoveIndexBackParam (func_call->FUNC_CALL_EXP.FUNC_PARAMS);
  }
  }
   return;
yyL5:;

/* line 590 "FinalCode.puma" */
  {
/* line 592 "FinalCode.puma" */
   if (! ((func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("PRESENT")))) goto yyL6;
  {
/* line 594 "FinalCode.puma" */
   MakeFullParam (func_call->FUNC_CALL_EXP.FUNC_PARAMS);
/* line 596 "FinalCode.puma" */
 func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = MakeDalibRoutine (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
     DefineNewHelpFn (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
    
  }
  }
   return;
yyL6:;

/* line 601 "FinalCode.puma" */
  {
/* line 603 "FinalCode.puma" */
   if (! ((IsDalibRoutine (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL7;
  {
/* line 605 "FinalCode.puma" */
 func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = MakeDalibRoutine (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
     DefineNewHelpFn (func_call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident);
    
  }
  }
   return;
yyL7:;

/* line 610 "FinalCode.puma" */
   return;

  }
/* line 613 "FinalCode.puma" */
  {
/* line 614 "FinalCode.puma" */
   failure_protocol (MODULE, "MakeFinalIntrFuncCall", func_call);
  }
   return;

;
}

static rbool IsKindIntrinsic
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, IsIdent ("AINT"))) {
/* line 627 "FinalCode.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("INT"))) {
/* line 628 "FinalCode.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("ANINT"))) {
/* line 629 "FinalCode.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("NINT"))) {
/* line 630 "FinalCode.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("CHAR"))) {
/* line 631 "FinalCode.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("CMPLX"))) {
/* line 632 "FinalCode.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("REAL"))) {
/* line 633 "FinalCode.puma" */
   return rtrue;

  }
  return rfalse;
}

static void RemoveKindParam
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 637 "FinalCode.puma" */
  {
/* line 639 "FinalCode.puma" */
 params->BTP_LIST.Next = params->BTP_LIST.Next->BTP_LIST.Next; 
  }
   return;

  }
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 642 "FinalCode.puma" */
  {
/* line 644 "FinalCode.puma" */
 params->BTP_LIST.Next->BTP_LIST.Next = params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next; 
  }
   return;

  }
  }
  }
  }
;
}

static void RemoveIndexBackParam
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 657 "FinalCode.puma" */
  {
/* line 659 "FinalCode.puma" */
   if (! ((IsFalseParam (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem)))) goto yyL1;
  {
/* line 660 "FinalCode.puma" */
 params->BTP_LIST.Next->BTP_LIST.Next = params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next; 
  }
  }
   return;
yyL1:;

  }
  }
  }
  }
;
}

static rbool IsFalseParam
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kADDR) {
  if (t->VAR_PARAM.V->ADDR.E->Kind == kCONST_EXP) {
  if (t->VAR_PARAM.V->ADDR.E->CONST_EXP.C->Kind == kBOOL_CONSTANT) {
  if (equalint (t->VAR_PARAM.V->ADDR.E->CONST_EXP.C->BOOL_CONSTANT.value, 0)) {
/* line 665 "FinalCode.puma" */
   return rtrue;

  }
  }
  }
  }
  }
  return rfalse;
}

static void MakeFullParam
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (param->BTP_LIST.Elem->VAR_PARAM.V->Kind == kINDEXED_VAR) {
/* line 676 "FinalCode.puma" */
  {
/* line 678 "FinalCode.puma" */
 param->BTP_LIST.Elem->VAR_PARAM.V = param->BTP_LIST.Elem->VAR_PARAM.V->INDEXED_VAR.IND_VAR; 
  }
   return;

  }
  }
  }
;
}

static rbool IsDalibRoutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, IsIdent ("PRESENT"))) {
/* line 694 "FinalCode.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("ALLOCATED"))) {
/* line 697 "FinalCode.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("SELECTED_INT_KIND"))) {
/* line 700 "FinalCode.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("SELECTED_REAL_KIND"))) {
/* line 703 "FinalCode.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("VERIFY"))) {
/* line 708 "FinalCode.puma" */
   return rtrue;

  }
/* line 711 "FinalCode.puma" */
  {
/* line 712 "FinalCode.puma" */
   if (! ((target_language == FORTRAN_90))) goto yyL6;
  {
/* line 713 "FinalCode.puma" */
   return rfalse;
  }
  }
yyL6:;

  if (equaltIdent (name, IsIdent ("CEILING"))) {
/* line 716 "FinalCode.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("FLOOR"))) {
/* line 719 "FinalCode.puma" */
   return rtrue;

  }
  if (equaltIdent (name, IsIdent ("LEN_TRIM"))) {
/* line 722 "FinalCode.puma" */
   return rtrue;

  }
  return rfalse;
}

static tIdent MakeDalibRoutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 738 "FinalCode.puma" */
 char new_name [100]; 
/* line 740 "FinalCode.puma" */
  {
/* line 744 "FinalCode.puma" */
   GetString (name, new_name);
  }
   return MakeDalibId (new_name);

}

static tTree MakeDalibExitStmt
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 764 "FinalCode.puma" */
 {
  tTree stmt;
  {
/* line 768 "FinalCode.puma" */
   stmt = mPROC_OBJ (MakeDalibId ("exit"));
/* line 769 "FinalCode.puma" */
   stmt = mACF_BASIC (mCALL_STMT (stmt, mBTP_EMPTY ()));
  }
   return stmt;
 }

}

static void SetInitStmt
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
/* line 776 "FinalCode.puma" */
 {
  tTree stmt;
  tTree param;
  {
/* line 782 "FinalCode.puma" */
 stmt  = mPROC_OBJ (MakeDalibId ("set_present"));
    param = mBTP_LIST (NotPresentString(), mBTP_EMPTY());
    param = mBTP_LIST (NotPresentArgument(), param);
    stmt  = mACF_BASIC (mCALL_STMT (stmt, param));
    body->BODY_NODE.STATS = mACF_LIST (stmt, body->BODY_NODE.STATS);

    stmt  = mPROC_OBJ (MakeDalibId ("init"));
    param = mBTP_EMPTY ();
    param = mBTP_LIST (ExpToVarParam (MakeConstant (default_addr_size)), 
                       param);
    param = mBTP_LIST (ExpToVarParam (MakeConstant (default_real_size)), 
                       param);
    param = mBTP_LIST (ExpToVarParam (MakeConstant (default_int_size)), 
                       param);
    stmt  = mACF_BASIC (mCALL_STMT (stmt, param));
    body->BODY_NODE.STATS = mACF_LIST (stmt, body->BODY_NODE.STATS);
 
    stmt = MakeDalibExitStmt ();
    stmt = mACF_LIST (stmt, mACF_EMPTY());
 
    body->BODY_NODE.STATS = CombineACF (body->BODY_NODE.STATS, stmt);
 
  
  }
   return;
 }

  }
/* line 807 "FinalCode.puma" */
  {
/* line 809 "FinalCode.puma" */
   failure_protocol (MODULE, "SetInitStmt", body);
  }
   return;

;
}

static tTree NotPresentArgument
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 825 "FinalCode.puma" */
 {
  tTree param;
  {
/* line 828 "FinalCode.puma" */
 DefineNewCommonVar (MakeDalibId ("data0"), MakeDalibId ("0"));
     param = mVAR_OBJ (0, MakeDalibId ("0"));
     param = mVAR_PARAM (mUSED_VAR (param));
   
  }
   return param;
 }

}

static tTree NotPresentString
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 838 "FinalCode.puma" */
 {
  tTree param;
  {
/* line 841 "FinalCode.puma" */
 DefineNewCommonVar (MakeDalibId ("data1"), MakeDalibId ("1"));
     param = mVAR_OBJ (0, MakeDalibId ("1"));
     param = mVAR_PARAM (mUSED_VAR (param));
   
  }
   return param;
 }

}

static void MakeFinalIntrSubCall
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
/* line 859 "FinalCode.puma" */

char string[50];
int  op, len, up;
tIdent func_id;

  if (call->Kind == kCALL_STMT) {
  if (call->CALL_STMT.CALL_PARAMS->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 865 "FinalCode.puma" */
 {
  tTree new_params;
  tTree new_param;
  {
/* line 867 "FinalCode.puma" */
   if (! ((IntrFuncScan (call->CALL_STMT.CALL_ID->PROC_OBJ.Ident)))) goto yyL1;
  {
/* line 872 "FinalCode.puma" */
 GetString (call->CALL_STMT.CALL_ID->PROC_OBJ.Ident, string);
      len = strlen (string);

      if (string[len-6] == 'P')
         up = 1;                         
        else
         up = 0;                         

      if (TreeListLength (call->CALL_STMT.CALL_PARAMS) == 12)
        { if (up)
             call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("dalib_prefix_array");
           else
             call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("dalib_suffix_array");
        }
       else if (TreeListLength (call->CALL_STMT.CALL_PARAMS) == 10)
        { if (up)
             call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("dalib_prefix_mask");
           else
             call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("dalib_suffix_mask");
        }
       else 
        { if (up)
             call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("dalib_prefix_copy");
           else
             call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("dalib_suffix_copy");
        }

      func_id = MakeIdent (string, len-7);    

      new_params = call->CALL_STMT.CALL_PARAMS;

      

      if (TreeListLength (call->CALL_STMT.CALL_PARAMS) > 8)

       { new_param  = GetReductionZero (TreeType (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem->VAR_PARAM.V), func_id);
         new_param  = ExpToVarParam (mCONST_EXP(new_param));
         new_params = mBTP_LIST (new_param, new_params);

         op = GetGlobalOp (TreeType (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem->VAR_PARAM.V), func_id);

         new_param  = ExpToVarParam (MakeConstant (op));
         new_params = mBTP_LIST (new_param, new_params);

         call->CALL_STMT.CALL_PARAMS    = new_params;
       }

    
/* line 921 "FinalCode.puma" */
   stmt_protocol ("translated HPF Library xxx_PREFIX/SUFFIX call");
  }
  }
   return;
 }
yyL1:;

/* line 924 "FinalCode.puma" */
 {
  int op;
  tTree type;
  {
/* line 926 "FinalCode.puma" */
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Ident == IsIdent ("MATMUL")))) goto yyL2;
  {
/* line 931 "FinalCode.puma" */
  

      type = TreeType (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem->VAR_PARAM.V);

      if (type->Kind != kBOOLEAN_TYPE)
          op = GetGlobalOp (TreeType (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem->VAR_PARAM.V), IsIdent ("SUM"));
        else
          op = GetGlobalOp (TreeType (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem->VAR_PARAM.V), IsIdent ("ANY"));

      call->CALL_STMT.CALL_PARAMS  = mBTP_LIST (ExpToVarParam (MakeConstant (op)), call->CALL_STMT.CALL_PARAMS);

      call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = MakeDalibRoutine (call->CALL_STMT.CALL_ID->PROC_OBJ.Ident);
    
  }
  }
   return;
 }
yyL2:;

  }
  }
/* line 946 "FinalCode.puma" */
  {
/* line 948 "FinalCode.puma" */
 call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = MakeTypedDalibRoutine (call->CALL_STMT.CALL_ID->PROC_OBJ.Ident, call->CALL_STMT.CALL_PARAMS); 
  }
   return;

  }
;
}

static tIdent MakeTypedDalibRoutine
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
/* line 960 "FinalCode.puma" */

char tstring[256];
tIdent typed_name;
type_rec t;

  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 966 "FinalCode.puma" */
  {
/* line 968 "FinalCode.puma" */
   if (! (((name == IsIdent ("GRADE_UP")) || (name == IsIdent ("GRADE_DOWN")) || (name == IsIdent ("SORT_DOWN")) || (name == IsIdent ("SORT_UP"))))) goto yyL1;
  {
/* line 974 "FinalCode.puma" */
 GetString (name, tstring);
     GetParamType (params->BTP_LIST.Next->BTP_LIST.Elem, &t);
     if (t.type_kind == kREAL_TYPE) strcat (tstring, "_R");
     if (t.type_kind == kCOMPLEX_TYPE) strcat (tstring, "_C");
     if (t.type_kind == kBOOLEAN_TYPE) strcat (tstring, "_L");
     if (t.type_kind == kINTEGER_TYPE) strcat (tstring, "_I");
     if (t.type_kind == kSTRING_TYPE) strcat (tstring, "_S");
     typed_name = IsIdent (tstring);
   
  }
  }
   return MakeDalibRoutine (typed_name);
yyL1:;

/* line 987 "FinalCode.puma" */
  {
/* line 989 "FinalCode.puma" */
   if (! (((name == IsIdent ("SORT_UP")) || (name == IsIdent ("SORT_DOWN"))))) goto yyL2;
  {
/* line 992 "FinalCode.puma" */
 GetString (name, tstring);
     GetParamType (params->BTP_LIST.Next->BTP_LIST.Elem, &t);
     if (t.type_kind == kREAL_TYPE) strcat (tstring, "_R");
     if (t.type_kind == kSTRING_TYPE) strcat (tstring, "_S");
     if (t.type_kind == kINTEGER_TYPE) strcat (tstring, "_I");
     typed_name = IsIdent (tstring);
   
  }
  }
   return MakeDalibRoutine (typed_name);
yyL2:;

  }
  }
/* line 1003 "FinalCode.puma" */
   return MakeDalibRoutine (name);

}

static void GenModuleInit
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tIdent module_name)
# else
(body, module_name)
 register tTree body;
 register tIdent module_name;
# endif
{
  if (body->Kind == kBODY_NODE) {
/* line 1018 "FinalCode.puma" */
 {
  tTree init_unit;
  tIdent init_name;
  tTree init_decls;
  tTree init_decl;
  tTree init_var;
  tTree init_exp;
  {
/* line 1028 "FinalCode.puma" */
 init_name  = MakeInitVarName (module_name);
      init_var   = mUSED_VAR (mVAR_OBJ (0, init_name));

      /******************************************************
      *   INTEGER*4 INIT_H1_<module_name>                   *
      *   DATA INIT_H1_M0 / 0 /                             *
      ******************************************************/

      init_decls = mDECL_EMPTY ();
      init_decl  = mDATA_DECL (DefaultId(), 0,
                               mBTV_LIST (CopyTree (init_var), mBTV_EMPTY()),
                               mBTE_LIST (MakeConstant (0), mBTE_EMPTY ()));
      init_decls = mDECL_LIST (init_decl, init_decls);
      init_decl  = mVAR_DECL (init_name, 0, 
                              MakeIntegerType (default_int_size));
      init_decls = mDECL_LIST (init_decl, init_decls);

      body->BODY_NODE.DECLS      = AppendDECLS (body->BODY_NODE.DECLS, init_decls);

      /******************************************************
      *  IF (INIT_H1_<module_name> .eq. 0) THEN             *
      *     INIT_H1_<module_name> = 1                       *
      *     <other initialization>                          *
      *  END IF                                             *
      ******************************************************/

      init_exp  = mOP_EXP (mOP_EQ(), mVAR_EXP (init_var), MakeConstant (0));

      init_unit = mASSIGN_STMT (CopyTree(init_var), MakeConstant (1));
      init_unit = mACF_LIST (mACF_BASIC (init_unit), body->BODY_NODE.STATS);
      init_unit = mACF_IF (init_exp, init_unit, mACF_EMPTY ());
      init_unit = mACF_LIST (init_unit, mACF_EMPTY());

      init_name = MakeInitRoutineName (module_name);

      

      init_unit = mBODY_NODE (body->BODY_NODE.NEW_DECLS, mDECL_EMPTY (),
                              init_unit, mUNIT_EMPTY ());
      init_unit = mPROC_DECL (init_name, 0, mDECL_EMPTY(), init_unit);
      body->BODY_NODE.INTERNALS = mUNIT_LIST (init_unit, body->BODY_NODE.INTERNALS);

      

      body->BODY_NODE.NEW_DECLS = mDECL_EMPTY ();
      body->BODY_NODE.STATS     = mACF_EMPTY ();

    
  }
   return;
 }

  }
;
}

static tIdent MakeInitRoutineName
# if defined __STDC__ | defined __cplusplus
(register tIdent module_name)
# else
(module_name)
 register tIdent module_name;
# endif
{
/* line 1086 "FinalCode.puma" */
 {
  tIdent init_name;
  {
/* line 1090 "FinalCode.puma" */
 char string [50], string1[60];

    GetString (module_name, string);
    sprintf (string1, "INIT_H0_%s", string);
    init_name = IsIdent (string1);
  
  }
   return init_name;
 }

}

static tIdent MakeInitVarName
# if defined __STDC__ | defined __cplusplus
(register tIdent module_name)
# else
(module_name)
 register tIdent module_name;
# endif
{
/* line 1108 "FinalCode.puma" */
 {
  tIdent init_name;
  {
/* line 1112 "FinalCode.puma" */
 char string [50], string1[60];

    GetString (module_name, string);
    sprintf (string1, "INIT_H1_%s", string);
    init_name = IsIdent (string1);
  
  }
   return init_name;
 }

}

static tTree MakeModuleInitCall
# if defined __STDC__ | defined __cplusplus
(register tIdent module_name)
# else
(module_name)
 register tIdent module_name;
# endif
{
/* line 1132 "FinalCode.puma" */
 {
  tTree init_call;
  tIdent init_name;
  {
/* line 1137 "FinalCode.puma" */
 init_name = MakeInitRoutineName (module_name);
     init_call = mPROC_OBJ (init_name);
     init_call = mCALL_STMT (init_call, mBTP_EMPTY());
     init_call = mACF_BASIC (init_call);
   
  }
   return init_call;
 }

}

static tTree AttributeComponents
# if defined __STDC__ | defined __cplusplus
(register tTree components)
# else
(components)
 register tTree components;
# endif
{
  if (components->Kind == kDECL_LIST) {
  if (components->DECL_LIST.Next->Kind == kDECL_LIST) {
/* line 1160 "FinalCode.puma" */
  {
/* line 1162 "FinalCode.puma" */
   if (! ((ShouldBeCombined (components->DECL_LIST.Elem, components->DECL_LIST.Next->DECL_LIST.Elem)))) goto yyL1;
  {
/* line 1164 "FinalCode.puma" */
 components->DECL_LIST.Next->DECL_LIST.Elem   = CombineAttributes (components->DECL_LIST.Elem, components->DECL_LIST.Next->DECL_LIST.Elem);
    components->DECL_LIST.Next->DECL_LIST.Next = AttributeComponents (components->DECL_LIST.Next->DECL_LIST.Next); 
  
  }
  }
   return components->DECL_LIST.Next;
yyL1:;

  }
/* line 1171 "FinalCode.puma" */
  {
/* line 1173 "FinalCode.puma" */
 components->DECL_LIST.Next = AttributeComponents (components->DECL_LIST.Next); 
  }
   return components;

  }
  if (components->Kind == kDECL_EMPTY) {
/* line 1178 "FinalCode.puma" */
   return components;

  }
/* line 1183 "FinalCode.puma" */
  {
/* line 1185 "FinalCode.puma" */
   failure_protocol (MODULE, "AttributeComponents", components);
  }
   return NoTree;

}

static rbool ShouldBeCombined
# if defined __STDC__ | defined __cplusplus
(register tTree d1, register tTree d2)
# else
(d1, d2)
 register tTree d1;
 register tTree d2;
# endif
{
  if (d1->Kind == kVAR_DECL) {
  if (d1->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
/* line 1195 "FinalCode.puma" */
  {
/* line 1197 "FinalCode.puma" */
   return rfalse;
  }

  }
  if (d2->Kind == kPOINTER_DECL) {
/* line 1200 "FinalCode.puma" */
  {
/* line 1202 "FinalCode.puma" */
   if (! ((d1->VAR_DECL.Ident == d2->POINTER_DECL.Ident))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  return rfalse;
}

static tTree CombineAttributes
# if defined __STDC__ | defined __cplusplus
(register tTree d1, register tTree d2)
# else
(d1, d2)
 register tTree d1;
 register tTree d2;
# endif
{
  if (d1->Kind == kVAR_DECL) {
/* line 1211 "FinalCode.puma" */
 {
  tTree attribute_decl;
  {
/* line 1215 "FinalCode.puma" */
 d1->Kind = kTYPESPEC_DECL;

    attribute_decl = mDECL_LIST (d1, mDECL_LIST (d2, mDECL_EMPTY ()));

    attribute_decl = mENTITY_DECL (d1->VAR_DECL.Ident, d1->VAR_DECL.Line, attribute_decl);

  
  }
   return attribute_decl;
 }

  }
/* line 1226 "FinalCode.puma" */
  {
/* line 1228 "FinalCode.puma" */
   failure_protocol (MODULE, "CombineAttributes", d1);
  }
   return NoTree;

}

void BeginFinalCode ARGS ((void))
{
}

void CloseFinalCode ARGS ((void))
{
}
