# include "Extraction.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 22 "Extraction.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Nesting.h"    /* IsParallelLoop,  ... */
# include "ParNest.h"
# include "TreeOps.h" 
# include "Dependences.h"
# include "Shapes.h"
# include "Loops.h"

# define MODULE "Extraction"

# undef DEBUG

static tTree LoopNest1 [MAX_FORALL];
static tTree LoopNest2 [MAX_FORALL];
static int Nest1;
static int Nest2;
static int CommonLoops;

static tTree extract_var;
static rbool  extract_read;
static rbool  extract_before;
static rbool  extract_loops;

       /*************************************************
       *                                                *
       *  Variables for describing problems             *
       *                                                *
       *************************************************/

static tTree problem_var;
static tTree problem_stmt;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyExtraction.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Extraction_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Extraction, routine %s failed\n",
  yyFunction);
 Extraction_Exit ();
}

rbool IsExtractableVar ARGS ((tTree var, rbool is_read, rbool before));
rbool IsExtractableRange ARGS ((tTree exp));
static rbool AreExtractableVarIndexes ARGS ((tTree var));
static rbool IsExtractableExp ARGS ((tTree exp));
static rbool IsExtractable ARGS ((tTree stmt));
static rbool IsNotLoopId ARGS ((tTree var, tTree id));
static rbool NoVarDependences ARGS ((tTree var1, rbool is_read1, tTree var2, rbool is_read2));
static rbool NoExpDependences ARGS ((tTree var, tTree exp));
static rbool NoParamDependences ARGS ((tTree var, tTree params));
static void SetCurrentNesting ARGS ((void));
static void IncNesting2 ARGS ((tTree loop));
static void DecNesting2 ARGS ((tTree loop));
static rbool IsLoop ARGS ((tTree loop));
static rbool NoLoopDependences ARGS ((tTree var1, rbool is_read1, tTree var2, rbool is_read2));
static tTree GetVariable ARGS ((tTree var));
static void MyDependences ARGS ((tTree v1, ptree loops1, int n1, tTree v2, ptree loops2, int n2, int CommonLoops, int ConstLoops, pPredVector p));
static void ExtractTestPredicate ARGS ((int CommonLoops, Predicate * yyP1));
static void LexicalOrder ARGS ((tTree v1, tTree v2, tTree stmt, int * yyP2));
static void LexOrder ARGS ((tTree v1, tTree v2, tTree stmt, rbool * yyP5, rbool * yyP4, int * yyP3));
static void Combine ARGS ((rbool found1a, rbool found2a, int kinda, rbool found1b, rbool found2b, int kindb, int new_kind, rbool * yyP8, rbool * yyP7, int * yyP6));
void ExtractVarFromLoop ARGS ((tTree var, tTree loop, tTree * yyP10, rbool * yyP9));
rbool IsParallelInvariant ARGS ((tTree exp));
static rbool IsInvariantExp ARGS ((tTree exp));
static rbool IsInvariant ARGS ((tTree stmt));

rbool IsExtractableVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, register rbool is_read, register rbool before)
# else
(var, is_read, before)
 register tTree var;
 register rbool is_read;
 register rbool before;
# endif
{
/* line 80 "Extraction.puma" */
  {
/* line 82 "Extraction.puma" */

#ifdef DEBUG
     printf ("IsExtracableVar (var=");
     FileUnparse (stdout, var);
     printf (",is_read=%d,before=%d), parallel nest = %d\n", 
               is_read, before, GetParNestingDepth());
#endif
   
/* line 91 "Extraction.puma" */
   goto yyL1;
  }
yyL1:;

/* line 94 "Extraction.puma" */
  {
/* line 96 "Extraction.puma" */
   if (! ((GetParNestingDepth () == 0))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 99 "Extraction.puma" */
  {
/* line 101 "Extraction.puma" */
   extract_var = var;
/* line 102 "Extraction.puma" */
   extract_read = is_read;
/* line 103 "Extraction.puma" */
   extract_before = before;
/* line 104 "Extraction.puma" */
   extract_loops = rtrue;
/* line 106 "Extraction.puma" */
   problem_var = NoTree;
/* line 107 "Extraction.puma" */
   problem_stmt = NoTree;
/* line 109 "Extraction.puma" */
   SetCurrentNesting ();
/* line 113 "Extraction.puma" */
   if (! ((IsExtractable (GetParNestACF (1))))) goto yyL3;
  {
/* line 115 "Extraction.puma" */
   if (! ((AreExtractableVarIndexes (var)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

/* line 118 "Extraction.puma" */
  {
/* line 120 "Extraction.puma" */
   if (! ((problem_var != NoTree))) goto yyL4;
  {
/* line 122 "Extraction.puma" */
   tree_protocol ("this variable : ", problem_var);
/* line 123 "Extraction.puma" */
   tree_protocol ("cannot be extracted due to :\n", problem_stmt);
/* line 125 "Extraction.puma" */
   return rfalse;
  }
  }
yyL4:;

  return rfalse;
}

rbool IsExtractableRange
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
/* line 144 "Extraction.puma" */
  {
/* line 146 "Extraction.puma" */
   extract_before = rtrue;
/* line 147 "Extraction.puma" */
   extract_loops = rfalse;
/* line 149 "Extraction.puma" */
   SetCurrentNesting ();
/* line 151 "Extraction.puma" */
   if (! ((IsExtractableExp (exp)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

static rbool AreExtractableVarIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 165 "Extraction.puma" */
  {
/* line 167 "Extraction.puma" */
   if (! ((AreExtractableVarIndexes (var->INDEXED_VAR.IND_VAR)))) goto yyL1;
  {
/* line 168 "Extraction.puma" */
   if (! ((AreExtractableVarIndexes (var->INDEXED_VAR.IND_EXPS)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  if (var->Kind == kUSED_VAR) {
/* line 171 "Extraction.puma" */
   return rtrue;

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 174 "Extraction.puma" */
  {
/* line 176 "Extraction.puma" */
   if (! ((AreExtractableVarIndexes (var->SELECTED_VAR.SELEC_VAR)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  if (var->Kind == kSUBSTRING_VAR) {
/* line 179 "Extraction.puma" */
  {
/* line 181 "Extraction.puma" */
   if (! ((IsExtractableExp (var->SUBSTRING_VAR.IND_EXP)))) goto yyL4;
  {
/* line 182 "Extraction.puma" */
   if (! ((AreExtractableVarIndexes (var->SUBSTRING_VAR.IND_VAR)))) goto yyL4;
  }
  }
   return rtrue;
yyL4:;

  }
  if (var->Kind == kBTE_LIST) {
/* line 185 "Extraction.puma" */
  {
/* line 187 "Extraction.puma" */
   if (! ((IsExtractableExp (var->BTE_LIST.Elem)))) goto yyL5;
  {
/* line 188 "Extraction.puma" */
   if (! ((AreExtractableVarIndexes (var->BTE_LIST.Next)))) goto yyL5;
  }
  }
   return rtrue;
yyL5:;

  }
  if (var->Kind == kBTE_EMPTY) {
/* line 191 "Extraction.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool IsExtractableExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kOP_EXP:
/* line 202 "Extraction.puma" */
  {
/* line 204 "Extraction.puma" */
   if (! ((IsExtractableExp (exp->OP_EXP.OPND1)))) goto yyL1;
  {
/* line 205 "Extraction.puma" */
   if (! ((IsExtractableExp (exp->OP_EXP.OPND2)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  break;
  case kSLICE_EXP:
/* line 208 "Extraction.puma" */
  {
/* line 210 "Extraction.puma" */
   if (! ((IsExtractableExp (exp->SLICE_EXP.FIRST)))) goto yyL2;
  {
/* line 211 "Extraction.puma" */
   if (! ((IsExtractableExp (exp->SLICE_EXP.STOP)))) goto yyL2;
  {
/* line 212 "Extraction.puma" */
   if (! ((IsExtractableExp (exp->SLICE_EXP.INC)))) goto yyL2;
  }
  }
  }
   return rtrue;
yyL2:;

  break;
  case kDUMMY_EXP:
/* line 215 "Extraction.puma" */
   return rtrue;

  case kCONST_EXP:
/* line 218 "Extraction.puma" */
   return rtrue;

  case kBOUND_EXP:
/* line 221 "Extraction.puma" */
   return rtrue;

  case kRANK_EXP:
/* line 224 "Extraction.puma" */
   return rtrue;

  case kOP1_EXP:
/* line 227 "Extraction.puma" */
  {
/* line 229 "Extraction.puma" */
   if (! ((IsExtractableExp (exp->OP1_EXP.OPND)))) goto yyL7;
  }
   return rtrue;
yyL7:;

  break;
  case kVAR_EXP:
  if (exp->VAR_EXP.V->Kind == kLOOP_VAR) {
/* line 232 "Extraction.puma" */
  {
/* line 234 "Extraction.puma" */
   if (! ((extract_loops))) goto yyL8;
  }
   return rtrue;
yyL8:;

  }
/* line 237 "Extraction.puma" */
  {
/* line 239 "Extraction.puma" */
   extract_var = exp->VAR_EXP.V;
/* line 240 "Extraction.puma" */
   extract_read = rtrue;
/* line 245 "Extraction.puma" */
   if (! ((IsExtractable (GetParNestACF (1))))) goto yyL9;
  {
/* line 249 "Extraction.puma" */
   if (! ((AreExtractableVarIndexes (exp->VAR_EXP.V)))) goto yyL9;
  }
  }
   return rtrue;
yyL9:;

  break;
  }

  return rfalse;
}

static rbool IsExtractable
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{

  switch (stmt->Kind) {
  case kACF_LIST:
/* line 270 "Extraction.puma" */
  {
/* line 272 "Extraction.puma" */
   if (! ((IsExtractable (stmt->ACF_LIST.Elem)))) goto yyL1;
  {
/* line 273 "Extraction.puma" */
   if (! ((IsExtractable (stmt->ACF_LIST.Next)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  break;
  case kACF_EMPTY:
/* line 276 "Extraction.puma" */
   return rtrue;

  case kACF_DUMMY:
/* line 279 "Extraction.puma" */
   return rtrue;

  case kACF_DO:
/* line 282 "Extraction.puma" */
  {
/* line 284 "Extraction.puma" */
   if (! ((IsNotLoopId (extract_var, stmt->ACF_DO.DO_ID)))) goto yyL4;
  {
/* line 285 "Extraction.puma" */
   IncNesting2 (stmt);
/* line 286 "Extraction.puma" */
   if (! ((IsExtractable (stmt->ACF_DO.DO_BODY)))) goto yyL4;
  {
/* line 287 "Extraction.puma" */
   DecNesting2 (stmt);
  }
  }
  }
   return rtrue;
yyL4:;

  break;
  case kACF_FORALL:
/* line 290 "Extraction.puma" */
  {
/* line 292 "Extraction.puma" */
   if (! ((IsNotLoopId (extract_var, stmt->ACF_FORALL.FORALL_ID)))) goto yyL5;
  {
/* line 293 "Extraction.puma" */
   IncNesting2 (stmt);
/* line 294 "Extraction.puma" */
   if (! ((IsExtractable (stmt->ACF_FORALL.FORALL_BODY)))) goto yyL5;
  {
/* line 295 "Extraction.puma" */
   DecNesting2 (stmt);
  }
  }
  }
   return rtrue;
yyL5:;

  break;
  case kACF_WHILE:
/* line 298 "Extraction.puma" */
  {
/* line 300 "Extraction.puma" */
   IncNesting2 (stmt);
/* line 301 "Extraction.puma" */
   if (! ((IsExtractable (stmt->ACF_WHILE.WHILE_BODY)))) goto yyL6;
  {
/* line 302 "Extraction.puma" */
   DecNesting2 (stmt);
  }
  }
   return rtrue;
yyL6:;

  break;
  case kACF_IF:
/* line 305 "Extraction.puma" */
  {
/* line 307 "Extraction.puma" */
   if (! ((IsExtractable (stmt->ACF_IF.THEN_PART)))) goto yyL7;
  {
/* line 308 "Extraction.puma" */
   if (! ((IsExtractable (stmt->ACF_IF.ELSE_PART)))) goto yyL7;
  }
  }
   return rtrue;
yyL7:;

  break;
  case kACF_HOME:
/* line 311 "Extraction.puma" */
  {
/* line 313 "Extraction.puma" */
   if (! ((IsExtractable (stmt->ACF_HOME.HOME_BODY)))) goto yyL8;
  }
   return rtrue;
yyL8:;

  break;
  case kACF_NEW:
/* line 316 "Extraction.puma" */
  {
/* line 318 "Extraction.puma" */
   if (! ((IsExtractable (stmt->ACF_NEW.NEW_BODY)))) goto yyL9;
  }
   return rtrue;
yyL9:;

  break;
  case kACF_RESIDENT:
/* line 321 "Extraction.puma" */
  {
/* line 323 "Extraction.puma" */
   if (! ((IsExtractable (stmt->ACF_RESIDENT.RESIDENT_BODY)))) goto yyL10;
  }
   return rtrue;
yyL10:;

  break;
  case kACF_REDUCTION:
/* line 326 "Extraction.puma" */
  {
/* line 328 "Extraction.puma" */
   if (! ((IsExtractable (stmt->ACF_REDUCTION.REDUCTION_BODY)))) goto yyL11;
  }
   return rtrue;
yyL11:;

  break;
  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 331 "Extraction.puma" */
  {
/* line 333 "Extraction.puma" */
   if (! ((NoVarDependences (extract_var, extract_read, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, rfalse)))) goto yyL12;
  {
/* line 334 "Extraction.puma" */
   if (! ((NoExpDependences (extract_var, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL12;
  }
  }
   return rtrue;
yyL12:;

/* line 337 "Extraction.puma" */
  {
/* line 339 "Extraction.puma" */
 if (problem_var == NoTree)

       { problem_var  = extract_var;
         problem_stmt = stmt;
       }
  
/* line 346 "Extraction.puma" */
   return rfalse;
  }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 349 "Extraction.puma" */
  {
/* line 351 "Extraction.puma" */
   if (! ((NoParamDependences (extract_var, stmt->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS)))) goto yyL14;
  }
   return rtrue;
yyL14:;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 354 "Extraction.puma" */
  {
/* line 356 "Extraction.puma" */
   if (! ((NoParamDependences (extract_var, stmt->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS)))) goto yyL15;
  }
   return rtrue;
yyL15:;

  }
/* line 359 "Extraction.puma" */
   return rtrue;

  }

/* line 364 "Extraction.puma" */
  {
/* line 366 "Extraction.puma" */
   if (! ((problem_var == NoTree))) goto yyL17;
  {
/* line 368 "Extraction.puma" */
   problem_var = extract_var;
/* line 369 "Extraction.puma" */
   problem_stmt = stmt;
/* line 371 "Extraction.puma" */
   return rfalse;
  }
  }
yyL17:;

  return rfalse;
}

static rbool IsNotLoopId
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree id)
# else
(var, id)
 register tTree var;
 register tTree id;
# endif
{
/* line 384 "Extraction.puma" */
  {
/* line 385 "Extraction.puma" */
   if (! ((extract_loops))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 388 "Extraction.puma" */
  {
/* line 389 "Extraction.puma" */
   if (! ((TreeVarName (id) != TreeVarName (var)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  return rfalse;
}

static rbool NoVarDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register rbool is_read1, register tTree var2, register rbool is_read2)
# else
(var1, is_read1, var2, is_read2)
 register tTree var1;
 register rbool is_read1;
 register tTree var2;
 register rbool is_read2;
# endif
{
/* line 401 "Extraction.puma" */
  {
/* line 403 "Extraction.puma" */
   if (! ((var1 == var2))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 406 "Extraction.puma" */
  {
/* line 408 "Extraction.puma" */
   if (! ((TreeVarName (var1) != TreeVarName (var2)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 411 "Extraction.puma" */
  {
/* line 413 "Extraction.puma" */

#ifdef DEBUG
      printf ("NoVarDependences (var1=");
      FileUnparse (stdout, var1);
      printf (",is_read1=%d,var2=", is_read1);
      FileUnparse (stdout, var2);
      printf (",is_read2=%d)\n", is_read2);
#endif
   
/* line 423 "Extraction.puma" */
   if (! ((NoLoopDependences (var1, is_read1, var2, is_read2)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  return rfalse;
}

static rbool NoExpDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kOP_EXP:
/* line 434 "Extraction.puma" */
  {
/* line 436 "Extraction.puma" */
   if (! ((NoExpDependences (var, exp->OP_EXP.OPND1)))) goto yyL1;
  {
/* line 437 "Extraction.puma" */
   if (! ((NoExpDependences (var, exp->OP_EXP.OPND2)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  break;
  case kSLICE_EXP:
/* line 440 "Extraction.puma" */
  {
/* line 442 "Extraction.puma" */
   if (! ((NoExpDependences (var, exp->SLICE_EXP.FIRST)))) goto yyL2;
  {
/* line 443 "Extraction.puma" */
   if (! ((NoExpDependences (var, exp->SLICE_EXP.STOP)))) goto yyL2;
  {
/* line 444 "Extraction.puma" */
   if (! ((NoExpDependences (var, exp->SLICE_EXP.INC)))) goto yyL2;
  }
  }
  }
   return rtrue;
yyL2:;

  break;
  case kDUMMY_EXP:
/* line 447 "Extraction.puma" */
   return rtrue;

  case kCONST_EXP:
/* line 450 "Extraction.puma" */
   return rtrue;

  case kOP1_EXP:
/* line 453 "Extraction.puma" */
  {
/* line 455 "Extraction.puma" */
   if (! ((NoExpDependences (var, exp->OP1_EXP.OPND)))) goto yyL5;
  }
   return rtrue;
yyL5:;

  break;
  case kVAR_EXP:
/* line 458 "Extraction.puma" */
  {
/* line 460 "Extraction.puma" */
   if (! ((NoVarDependences (var, extract_read, exp->VAR_EXP.V, rtrue)))) goto yyL6;
  }
   return rtrue;
yyL6:;

  break;
  case kFUNC_CALL_EXP:
/* line 463 "Extraction.puma" */
  {
/* line 465 "Extraction.puma" */
   if (! ((NoParamDependences (var, exp->FUNC_CALL_EXP.FUNC_PARAMS)))) goto yyL7;
  }
   return rtrue;
yyL7:;

  break;
  }

  return rfalse;
}

static rbool NoParamDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree params)
# else
(var, params)
 register tTree var;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
/* line 476 "Extraction.puma" */
  {
/* line 478 "Extraction.puma" */
   if (! ((NoParamDependences (var, params->BTP_LIST.Elem)))) goto yyL1;
  {
/* line 479 "Extraction.puma" */
   if (! ((NoParamDependences (var, params->BTP_LIST.Next)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  if (params->Kind == kBTP_EMPTY) {
/* line 482 "Extraction.puma" */
   return rtrue;

  }
  if (params->Kind == kNO_PARAM) {
/* line 485 "Extraction.puma" */
   return rtrue;

  }
  if (params->Kind == kVAR_PARAM) {
  if (params->VAR_PARAM.V->Kind == kADDR) {
/* line 488 "Extraction.puma" */
  {
/* line 490 "Extraction.puma" */
   if (! ((NoExpDependences (var, params->VAR_PARAM.V->ADDR.E)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
/* line 493 "Extraction.puma" */
  {
/* line 495 "Extraction.puma" */
   if (! ((params->VAR_PARAM.intent == IntentIn))) goto yyL5;
  {
/* line 497 "Extraction.puma" */
   if (! ((NoVarDependences (var, extract_read, params->VAR_PARAM.V, rtrue)))) goto yyL5;
  }
  }
   return rtrue;
yyL5:;

/* line 500 "Extraction.puma" */
  {
/* line 502 "Extraction.puma" */
   if (! ((NoVarDependences (var, extract_read, params->VAR_PARAM.V, rfalse)))) goto yyL6;
  }
   return rtrue;
yyL6:;

  }
  return rfalse;
}

static void SetCurrentNesting
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 515 "Extraction.puma" */
 {
  int depth;
  int i;
  {
/* line 520 "Extraction.puma" */
   depth = GetParNestingDepth ();
/* line 522 "Extraction.puma" */
 Nest1 = 0;
     for (i=1; i <= depth; i++)
       { tTree loop;
         loop = GetParNestACF (i);
         if (IsLoop (loop))
            LoopNest1 [Nest1++] = loop;
       }
     Nest2 = 0;
     CommonLoops = 0;
   
  }
   return;
 }

;
}

static void IncNesting2
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
/* line 536 "Extraction.puma" */
  {
/* line 538 "Extraction.puma" */
 LoopNest2 [Nest2++] = loop; 
  }
   return;

;
}

static void DecNesting2
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
/* line 543 "Extraction.puma" */
  {
/* line 545 "Extraction.puma" */
 Nest2--; 
  }
   return;

;
}

static rbool IsLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
/* line 550 "Extraction.puma" */
   return rtrue;

  }
  if (loop->Kind == kACF_FORALL) {
/* line 553 "Extraction.puma" */
   return rtrue;

  }
  if (loop->Kind == kACF_WHILE) {
/* line 556 "Extraction.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool NoLoopDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register rbool is_read1, register tTree var2, register rbool is_read2)
# else
(var1, is_read1, var2, is_read2)
 register tTree var1;
 register rbool is_read1;
 register tTree var2;
 register rbool is_read2;
# endif
{
/* line 568 "Extraction.puma" */
  {
/* line 570 "Extraction.puma" */
   if (! ((is_read1 && is_read2))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 573 "Extraction.puma" */
 {
  rbool no_deps;
  tTree v1;
  tTree v2;
  {
/* line 580 "Extraction.puma" */
 int i, dim;

     int order;

     PredVector pv;
     Predicate  P;

     v1 = GetVariable (var1);
     v2 = GetVariable (var2);

     LexicalOrder (v1, v2, GetParNestACF (1), &order);

     

     CommonLoops = 0;

     for (i=0; i<Nest1; i++)

        { if (i<Nest2)
             if (LoopNest1[i] == LoopNest2[i])
                CommonLoops ++;
        }

     no_deps = rtrue;

     ExtractTestPredicate (CommonLoops, &P);
     
     dim = P.p_dim;

     for (i=0; i<dim; i++)

        { 

          pv = P.p_arr[i];

          MyDependences (v1, LoopNest1, Nest1,
                         v2, LoopNest2, Nest2,
                         CommonLoops, 0, &pv);

          if (PVIsZero (&pv) || (CommonLoops == 0))

             { if (order == 1)   

                 { if (!extract_before) no_deps = rfalse; }

               if (order == -1)   

                 { if (extract_before) no_deps = rfalse; }

             }
          
           else if (!PVIsFalse (&pv)) 

             no_deps = rfalse;
        }

#ifdef DEBUG
     printf ("deps for ");
     FileUnparse (stdout, v1);
     printf (" and ");
     FileUnparse (stdout, v2);
     printf (" = %d (order = %d)\n", !no_deps, order);
#endif 

   
/* line 646 "Extraction.puma" */
   if (! ((no_deps))) goto yyL2;
  }
   return rtrue;
 }
yyL2:;

  return rfalse;
}

static tTree GetVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kREMOTE_VAR) {
/* line 651 "Extraction.puma" */
   return var->REMOTE_VAR.VAR;

  }
/* line 656 "Extraction.puma" */
   return var;

}

static void MyDependences
# if defined __STDC__ | defined __cplusplus
(register tTree v1, ptree loops1, register int n1, register tTree v2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, pPredVector p)
# else
(v1, loops1, n1, v2, loops2, n2, CommonLoops, ConstLoops, p)
 register tTree v1;
 ptree loops1;
 register int n1;
 register tTree v2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 pPredVector p;
# endif
{
  if (v1->Kind == kUSED_VAR) {
  if (v2->Kind == kUSED_VAR) {
/* line 672 "Extraction.puma" */
   return;

  }
  }
/* line 675 "Extraction.puma" */
  {
/* line 679 "Extraction.puma" */
   Dependences (v1, loops1, n1, v2, loops2, n2, CommonLoops, ConstLoops, loops1, 0, p);
  }
   return;

;
}

static void ExtractTestPredicate
# if defined __STDC__ | defined __cplusplus
(register int CommonLoops, Predicate * yyP1)
# else
(CommonLoops, yyP1)
 register int CommonLoops;
 Predicate * yyP1;
# endif
{
/* line 691 "Extraction.puma" */
 {
  Predicate P;
  {
/* line 695 "Extraction.puma" */
 int k, j;
     PredVector PV;
     char str[100];

     PMakeFalse (&P);

     for (k=0; k<=CommonLoops; k++)

       { 

         PVMakeForLoopNest (CommonLoops, CommonLoops, k, &PV);

         for (j=0; j < CommonLoops; j++)

            if (IsParallelLoop (LoopNest1[j]))
  
               PVAndComponent (&PV, j+1, 0, 0);

         POrVector (&P, &PV);

       }

#ifdef DEBUG
      strcpy (str, "");
      POut (str, &P);
      printf ("ExtractTestPredicate (n=%d): %s\n", CommonLoops, str); 
#endif 

   
  }
   * yyP1 = P;
   return;
 }

;
}

static void LexicalOrder
# if defined __STDC__ | defined __cplusplus
(register tTree v1, register tTree v2, register tTree stmt, register int * yyP2)
# else
(v1, v2, stmt, yyP2)
 register tTree v1;
 register tTree v2;
 register tTree stmt;
 register int * yyP2;
# endif
{
/* line 740 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 742 "Extraction.puma" */
   LexOrder (v1, v2, stmt, & yyV1, & yyV2, & yyV3);
/* line 744 "Extraction.puma" */
 if (!yyV1) 
       tree_error_protocol ("var1 not found for lexical order : ", v1);
     if (!yyV2) 
       tree_error_protocol ("var2 not found for lexical order : ", v2);
     if (!(yyV1 && yyV2))
       tree_protocol ("considered statement :\n", stmt);
   
  }
   * yyP2 = yyV3;
   return;
 }

;
}

static void LexOrder
# if defined __STDC__ | defined __cplusplus
(register tTree v1, register tTree v2, register tTree stmt, register rbool * yyP5, register rbool * yyP4, register int * yyP3)
# else
(v1, v2, stmt, yyP5, yyP4, yyP3)
 register tTree v1;
 register tTree v2;
 register tTree stmt;
 register rbool * yyP5;
 register rbool * yyP4;
 register int * yyP3;
# endif
{

  switch (stmt->Kind) {
  case kACF_LIST:
/* line 755 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  rbool yyV4;
  rbool yyV5;
  int yyV6;
  rbool yyV7;
  rbool yyV8;
  int yyV9;
  {
/* line 757 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_LIST.Elem, & yyV1, & yyV2, & yyV3);
/* line 758 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_LIST.Next, & yyV4, & yyV5, & yyV6);
/* line 760 "Extraction.puma" */
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 1, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  case kACF_DO:
/* line 764 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  rbool yyV4;
  rbool yyV5;
  int yyV6;
  rbool yyV7;
  rbool yyV8;
  int yyV9;
  {
/* line 766 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_DO.DO_RANGE, & yyV1, & yyV2, & yyV3);
/* line 767 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_DO.DO_BODY, & yyV4, & yyV5, & yyV6);
/* line 771 "Extraction.puma" */
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 1, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  case kACF_FORALL:
/* line 775 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  rbool yyV4;
  rbool yyV5;
  int yyV6;
  rbool yyV7;
  rbool yyV8;
  int yyV9;
  {
/* line 778 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_FORALL.FORALL_RANGE, & yyV1, & yyV2, & yyV3);
/* line 779 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_FORALL.FORALL_BODY, & yyV4, & yyV5, & yyV6);
/* line 783 "Extraction.puma" */
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 1, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  case kACF_HOME:
/* line 787 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 789 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_HOME.HOME_BODY, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kACF_RESIDENT:
/* line 792 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 794 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_RESIDENT.RESIDENT_BODY, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kACF_REDUCTION:
/* line 797 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 799 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_REDUCTION.REDUCTION_BODY, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kACF_NEW:
/* line 802 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 804 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_NEW.NEW_BODY, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kACF_WHILE:
/* line 807 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  rbool yyV4;
  rbool yyV5;
  int yyV6;
  rbool yyV7;
  rbool yyV8;
  int yyV9;
  {
/* line 809 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_WHILE.WHILE_EXP, & yyV1, & yyV2, & yyV3);
/* line 810 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_WHILE.WHILE_BODY, & yyV4, & yyV5, & yyV6);
/* line 814 "Extraction.puma" */
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 1, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  case kACF_IF:
/* line 818 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  rbool yyV4;
  rbool yyV5;
  int yyV6;
  rbool yyV7;
  rbool yyV8;
  int yyV9;
  rbool yyV10;
  rbool yyV11;
  int yyV12;
  rbool yyV13;
  rbool yyV14;
  int yyV15;
  {
/* line 821 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_IF.IF_EXP, & yyV1, & yyV2, & yyV3);
/* line 822 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_IF.THEN_PART, & yyV4, & yyV5, & yyV6);
/* line 823 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_IF.ELSE_PART, & yyV7, & yyV8, & yyV9);
/* line 827 "Extraction.puma" */
   Combine (yyV4, yyV5, yyV6, yyV7, yyV8, yyV9, 0, & yyV10, & yyV11, & yyV12);
/* line 832 "Extraction.puma" */
   Combine (yyV1, yyV2, yyV3, yyV10, yyV11, yyV12, 1, & yyV13, & yyV14, & yyV15);
  }
   * yyP5 = yyV13;
   * yyP4 = yyV14;
   * yyP3 = yyV15;
   return;
 }

  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 836 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  rbool yyV4;
  rbool yyV5;
  int yyV6;
  rbool yyV7;
  rbool yyV8;
  int yyV9;
  {
/* line 838 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, & yyV1, & yyV2, & yyV3);
/* line 839 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, & yyV4, & yyV5, & yyV6);
/* line 843 "Extraction.puma" */
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 1, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 847 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 849 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 852 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 854 "Extraction.puma" */
   LexOrder (v1, v2, stmt->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  }
  break;
  case kBTP_LIST:
/* line 857 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  rbool yyV4;
  rbool yyV5;
  int yyV6;
  rbool yyV7;
  rbool yyV8;
  int yyV9;
  {
/* line 859 "Extraction.puma" */
   LexOrder (v1, v2, stmt->BTP_LIST.Elem, & yyV1, & yyV2, & yyV3);
/* line 860 "Extraction.puma" */
   LexOrder (v1, v2, stmt->BTP_LIST.Next, & yyV4, & yyV5, & yyV6);
/* line 864 "Extraction.puma" */
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 0, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  case kVAR_PARAM:
  if (stmt->VAR_PARAM.V->Kind == kADDR) {
/* line 868 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 870 "Extraction.puma" */
   LexOrder (v1, v2, stmt->VAR_PARAM.V->ADDR.E, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  }
/* line 873 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 875 "Extraction.puma" */
   LexOrder (v1, v2, stmt->VAR_PARAM.V, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kOP_EXP:
/* line 878 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  rbool yyV4;
  rbool yyV5;
  int yyV6;
  rbool yyV7;
  rbool yyV8;
  int yyV9;
  {
/* line 880 "Extraction.puma" */
   LexOrder (v1, v2, stmt->OP_EXP.OPND1, & yyV1, & yyV2, & yyV3);
/* line 881 "Extraction.puma" */
   LexOrder (v1, v2, stmt->OP_EXP.OPND2, & yyV4, & yyV5, & yyV6);
/* line 885 "Extraction.puma" */
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 0, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  case kOP1_EXP:
/* line 889 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 891 "Extraction.puma" */
   LexOrder (v1, v2, stmt->OP1_EXP.OPND, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kFUNC_CALL_EXP:
/* line 894 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 896 "Extraction.puma" */
   LexOrder (v1, v2, stmt->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kSLICE_EXP:
/* line 899 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  rbool yyV4;
  rbool yyV5;
  int yyV6;
  rbool yyV7;
  rbool yyV8;
  int yyV9;
  rbool yyV10;
  rbool yyV11;
  int yyV12;
  rbool yyV13;
  rbool yyV14;
  int yyV15;
  {
/* line 901 "Extraction.puma" */
   LexOrder (v1, v2, stmt->SLICE_EXP.FIRST, & yyV1, & yyV2, & yyV3);
/* line 902 "Extraction.puma" */
   LexOrder (v1, v2, stmt->SLICE_EXP.STOP, & yyV4, & yyV5, & yyV6);
/* line 903 "Extraction.puma" */
   LexOrder (v1, v2, stmt->SLICE_EXP.INC, & yyV7, & yyV8, & yyV9);
/* line 907 "Extraction.puma" */
   Combine (yyV4, yyV5, yyV6, yyV7, yyV8, yyV9, 0, & yyV10, & yyV11, & yyV12);
/* line 912 "Extraction.puma" */
   Combine (yyV1, yyV2, yyV3, yyV10, yyV11, yyV12, 0, & yyV13, & yyV14, & yyV15);
  }
   * yyP5 = yyV13;
   * yyP4 = yyV14;
   * yyP3 = yyV15;
   return;
 }

  case kVAR_EXP:
/* line 916 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 918 "Extraction.puma" */
   LexOrder (v1, v2, stmt->VAR_EXP.V, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kREMOTE_VAR:
/* line 921 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  {
/* line 923 "Extraction.puma" */
   LexOrder (v1, v2, stmt->REMOTE_VAR.VAR, & yyV1, & yyV2, & yyV3);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   return;
 }

  case kUSED_VAR:
/* line 926 "Extraction.puma" */
   * yyP5 = (v1 == stmt);
   * yyP4 = (v2 == stmt);
   * yyP3 = 0;
   return;

  case kINDEXED_VAR:
/* line 929 "Extraction.puma" */
 {
  rbool found1a;
  rbool found2a;
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  rbool yyV4;
  rbool yyV5;
  int yyV6;
  {
/* line 934 "Extraction.puma" */
   found1a = (stmt == v1);
/* line 935 "Extraction.puma" */
   found2a = (stmt == v2);
/* line 937 "Extraction.puma" */
   LexOrder (v1, v2, stmt->INDEXED_VAR.IND_EXPS, & yyV1, & yyV2, & yyV3);
/* line 941 "Extraction.puma" */
   Combine (found1a, found2a, 0, yyV1, yyV2, yyV3, - 1, & yyV4, & yyV5, & yyV6);
  }
   * yyP5 = yyV4;
   * yyP4 = yyV5;
   * yyP3 = yyV6;
   return;
 }

  case kSELECTED_VAR:
/* line 945 "Extraction.puma" */
 {
  rbool found1a;
  rbool found2a;
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  rbool yyV4;
  rbool yyV5;
  int yyV6;
  {
/* line 950 "Extraction.puma" */
   found1a = (stmt == v1);
/* line 951 "Extraction.puma" */
   found2a = (stmt == v2);
/* line 953 "Extraction.puma" */
   LexOrder (v1, v2, stmt->SELECTED_VAR.SELEC_VAR, & yyV1, & yyV2, & yyV3);
/* line 957 "Extraction.puma" */
   Combine (found1a, found2a, 0, yyV1, yyV2, yyV3, - 1, & yyV4, & yyV5, & yyV6);
  }
   * yyP5 = yyV4;
   * yyP4 = yyV5;
   * yyP3 = yyV6;
   return;
 }

  case kBTE_LIST:
/* line 961 "Extraction.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  int yyV3;
  rbool yyV4;
  rbool yyV5;
  int yyV6;
  rbool yyV7;
  rbool yyV8;
  int yyV9;
  {
/* line 963 "Extraction.puma" */
   LexOrder (v1, v2, stmt->BTE_LIST.Elem, & yyV1, & yyV2, & yyV3);
/* line 964 "Extraction.puma" */
   LexOrder (v1, v2, stmt->BTE_LIST.Next, & yyV4, & yyV5, & yyV6);
/* line 968 "Extraction.puma" */
   Combine (yyV1, yyV2, yyV3, yyV4, yyV5, yyV6, 0, & yyV7, & yyV8, & yyV9);
  }
   * yyP5 = yyV7;
   * yyP4 = yyV8;
   * yyP3 = yyV9;
   return;
 }

  }

/* line 972 "Extraction.puma" */
   * yyP5 = rfalse;
   * yyP4 = rfalse;
   * yyP3 = 0;
   return;

;
}

static void Combine
# if defined __STDC__ | defined __cplusplus
(register rbool found1a, register rbool found2a, register int kinda, register rbool found1b, register rbool found2b, register int kindb, register int new_kind, register rbool * yyP8, register rbool * yyP7, register int * yyP6)
# else
(found1a, found2a, kinda, found1b, found2b, kindb, new_kind, yyP8, yyP7, yyP6)
 register rbool found1a;
 register rbool found2a;
 register int kinda;
 register rbool found1b;
 register rbool found2b;
 register int kindb;
 register int new_kind;
 register rbool * yyP8;
 register rbool * yyP7;
 register int * yyP6;
# endif
{
/* line 1002 "Extraction.puma" */
  {
/* line 1004 "Extraction.puma" */
   if (! ((found1a))) goto yyL1;
  {
/* line 1005 "Extraction.puma" */
   if (! ((found1b))) goto yyL1;
  {
/* line 1007 "Extraction.puma" */
   failure_protocol (MODULE, "Combine: v1 in two constructs", NoTree);
  }
  }
  }
   * yyP8 = rtrue;
   * yyP7 = found2a || found2b;
   * yyP6 = 0;
   return;
yyL1:;

/* line 1010 "Extraction.puma" */
  {
/* line 1012 "Extraction.puma" */
   if (! ((found2a))) goto yyL2;
  {
/* line 1013 "Extraction.puma" */
   if (! ((found2b))) goto yyL2;
  {
/* line 1015 "Extraction.puma" */
   failure_protocol (MODULE, "Combine: v2 in two constructs", NoTree);
  }
  }
  }
   * yyP8 = found1a || found1b;
   * yyP7 = rtrue;
   * yyP6 = 0;
   return;
yyL2:;

/* line 1020 "Extraction.puma" */
  {
/* line 1022 "Extraction.puma" */
   if (! ((found1a))) goto yyL3;
  {
/* line 1023 "Extraction.puma" */
   if (! ((found2a))) goto yyL3;
  }
  }
   * yyP8 = found1a;
   * yyP7 = found2a;
   * yyP6 = kinda;
   return;
yyL3:;

/* line 1028 "Extraction.puma" */
  {
/* line 1030 "Extraction.puma" */
   if (! ((found1b))) goto yyL4;
  {
/* line 1031 "Extraction.puma" */
   if (! ((found2b))) goto yyL4;
  }
  }
   * yyP8 = found1b;
   * yyP7 = found2b;
   * yyP6 = kindb;
   return;
yyL4:;

/* line 1036 "Extraction.puma" */
  {
/* line 1038 "Extraction.puma" */
   if (! ((found1a))) goto yyL5;
  {
/* line 1039 "Extraction.puma" */
   if (! ((found2b))) goto yyL5;
  }
  }
   * yyP8 = found1a;
   * yyP7 = found2b;
   * yyP6 = new_kind;
   return;
yyL5:;

/* line 1044 "Extraction.puma" */
  {
/* line 1046 "Extraction.puma" */
   if (! ((found2a))) goto yyL6;
  {
/* line 1047 "Extraction.puma" */
   if (! ((found1b))) goto yyL6;
  }
  }
   * yyP8 = found2a;
   * yyP7 = found1b;
   * yyP6 = - new_kind;
   return;
yyL6:;

/* line 1052 "Extraction.puma" */
   * yyP8 = found1a || found1b;
   * yyP7 = found2a || found2b;
   * yyP6 = 0;
   return;

;
}

void ExtractVarFromLoop
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree loop, register tTree * yyP10, register rbool * yyP9)
# else
(var, loop, yyP10, yyP9)
 register tTree var;
 register tTree loop;
 register tTree * yyP10;
 register rbool * yyP9;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 1068 "Extraction.puma" */
   * yyP10 = var;
   * yyP9 = rtrue;
   return;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 1071 "Extraction.puma" */
   * yyP10 = MakeFullShape (var->INDEXED_VAR.IND_VAR);
   * yyP9 = rfalse;
   return;

  }
/* line 1074 "Extraction.puma" */
  {
/* line 1076 "Extraction.puma" */
   error_protocol ("failure for var accesses within a loop");
/* line 1077 "Extraction.puma" */
   tree_protocol ("variable access : ", var);
  }
   * yyP10 = var;
   * yyP9 = rfalse;
   return;

;
}

rbool IsParallelInvariant
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
/* line 1091 "Extraction.puma" */
  {
/* line 1093 "Extraction.puma" */
   if (! ((GetParNestingDepth () == 0))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 1096 "Extraction.puma" */
  {
/* line 1098 "Extraction.puma" */
   SetCurrentNesting ();
/* line 1100 "Extraction.puma" */
   if (! ((IsInvariantExp (exp)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  return rfalse;
}

static rbool IsInvariantExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{

  switch (exp->Kind) {
  case kOP_EXP:
/* line 1105 "Extraction.puma" */
  {
/* line 1107 "Extraction.puma" */
   if (! ((IsInvariantExp (exp->OP_EXP.OPND1)))) goto yyL1;
  {
/* line 1108 "Extraction.puma" */
   if (! ((IsInvariantExp (exp->OP_EXP.OPND2)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  break;
  case kOP1_EXP:
/* line 1111 "Extraction.puma" */
  {
/* line 1113 "Extraction.puma" */
   if (! ((IsInvariantExp (exp->OP1_EXP.OPND)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  break;
  case kCONST_EXP:
/* line 1116 "Extraction.puma" */
   return rtrue;

  case kVAR_EXP:
/* line 1119 "Extraction.puma" */
  {
/* line 1121 "Extraction.puma" */
   extract_var = exp->VAR_EXP.V;
/* line 1123 "Extraction.puma" */
   if (! ((IsInvariant (GetParNestACF (1))))) goto yyL4;
  }
   return rtrue;
yyL4:;

  break;
  case kSLICE_EXP:
/* line 1126 "Extraction.puma" */
  {
/* line 1128 "Extraction.puma" */
   if (! ((IsInvariantExp (exp->SLICE_EXP.FIRST)))) goto yyL5;
  {
/* line 1129 "Extraction.puma" */
   if (! ((IsInvariantExp (exp->SLICE_EXP.STOP)))) goto yyL5;
  {
/* line 1130 "Extraction.puma" */
   if (! ((IsInvariantExp (exp->SLICE_EXP.INC)))) goto yyL5;
  }
  }
  }
   return rtrue;
yyL5:;

  break;
  case kDUMMY_EXP:
/* line 1133 "Extraction.puma" */
   return rtrue;

  case kFUNC_CALL_EXP:
/* line 1136 "Extraction.puma" */
   return rtrue;

  }

  return rfalse;
}

static rbool IsInvariant
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{

  switch (stmt->Kind) {
  case kACF_LIST:
/* line 1141 "Extraction.puma" */
  {
/* line 1143 "Extraction.puma" */
   if (! ((IsInvariant (stmt->ACF_LIST.Elem)))) goto yyL1;
  {
/* line 1144 "Extraction.puma" */
   if (! ((IsInvariant (stmt->ACF_LIST.Next)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  break;
  case kACF_EMPTY:
/* line 1147 "Extraction.puma" */
   return rtrue;

  case kACF_DO:
/* line 1150 "Extraction.puma" */
  {
/* line 1152 "Extraction.puma" */
   if (! ((TreeVarName (extract_var) != TreeVarName (stmt->ACF_DO.DO_ID)))) goto yyL3;
  {
/* line 1154 "Extraction.puma" */
   IncNesting2 (stmt);
/* line 1155 "Extraction.puma" */
   if (! ((IsInvariant (stmt->ACF_DO.DO_BODY)))) goto yyL3;
  {
/* line 1156 "Extraction.puma" */
   DecNesting2 (stmt);
  }
  }
  }
   return rtrue;
yyL3:;

  break;
  case kACF_FORALL:
/* line 1159 "Extraction.puma" */
  {
/* line 1161 "Extraction.puma" */
   if (! ((TreeVarName (extract_var) != TreeVarName (stmt->ACF_FORALL.FORALL_ID)))) goto yyL4;
  {
/* line 1163 "Extraction.puma" */
   IncNesting2 (stmt);
/* line 1164 "Extraction.puma" */
   if (! ((IsInvariant (stmt->ACF_FORALL.FORALL_BODY)))) goto yyL4;
  {
/* line 1165 "Extraction.puma" */
   DecNesting2 (stmt);
  }
  }
  }
   return rtrue;
yyL4:;

  break;
  case kACF_WHILE:
/* line 1168 "Extraction.puma" */
  {
/* line 1170 "Extraction.puma" */
   IncNesting2 (stmt);
/* line 1171 "Extraction.puma" */
   if (! ((IsInvariant (stmt->ACF_WHILE.WHILE_BODY)))) goto yyL5;
  {
/* line 1172 "Extraction.puma" */
   DecNesting2 (stmt);
  }
  }
   return rtrue;
yyL5:;

  break;
  case kACF_IF:
/* line 1175 "Extraction.puma" */
  {
/* line 1177 "Extraction.puma" */
   if (! ((IsInvariant (stmt->ACF_IF.THEN_PART)))) goto yyL6;
  {
/* line 1178 "Extraction.puma" */
   if (! ((IsInvariant (stmt->ACF_IF.ELSE_PART)))) goto yyL6;
  }
  }
   return rtrue;
yyL6:;

  break;
  case kACF_HOME:
/* line 1181 "Extraction.puma" */
  {
/* line 1183 "Extraction.puma" */
   if (! ((IsInvariant (stmt->ACF_HOME.HOME_BODY)))) goto yyL7;
  }
   return rtrue;
yyL7:;

  break;
  case kACF_NEW:
/* line 1186 "Extraction.puma" */
  {
/* line 1188 "Extraction.puma" */
   if (! ((IsInvariant (stmt->ACF_NEW.NEW_BODY)))) goto yyL8;
  }
   return rtrue;
yyL8:;

  break;
  case kACF_RESIDENT:
/* line 1191 "Extraction.puma" */
  {
/* line 1193 "Extraction.puma" */
   if (! ((IsInvariant (stmt->ACF_RESIDENT.RESIDENT_BODY)))) goto yyL9;
  }
   return rtrue;
yyL9:;

  break;
  case kACF_REDUCTION:
/* line 1196 "Extraction.puma" */
  {
/* line 1198 "Extraction.puma" */
   if (! ((IsInvariant (stmt->ACF_REDUCTION.REDUCTION_BODY)))) goto yyL10;
  }
   return rtrue;
yyL10:;

  break;
  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 1201 "Extraction.puma" */
  {
/* line 1203 "Extraction.puma" */
   if (! ((TreeVarName (extract_var) != TreeVarName (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL11;
  }
   return rtrue;
yyL11:;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 1206 "Extraction.puma" */
   return rtrue;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 1209 "Extraction.puma" */
   return rtrue;

  }
/* line 1212 "Extraction.puma" */
  {
/* line 1214 "Extraction.puma" */
   return rfalse;
  }

  }

  return rfalse;
}

void BeginExtraction ARGS ((void))
{
}

void CloseExtraction ARGS ((void))
{
}
