# include "ExtractComm.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 34 "ExtractComm.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Transform.h"

# include "CheckComm.h"     /* IsLocalAssignment, ... */
# include "TempExp.h"       /* MakeLocalParams        */
# include "HomeDescriptor.h"
# include "IndShadow.h"
# include "Loops.h"
# include "ParNest.h"
# include "NewStatements.h"
# include "VarComm.h"
# include "TempAssigns.h"   /* MakeTemporaryStmt      */
# include "HomeTemps.h"     /* MakeTemporaryStmt      */
# include "Expansion.h"     /* FullExpansion          */

# define MODULE "ExtractComm"

# undef DEBUG



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyExtractComm.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* ExtractComm_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ExtractComm, routine %s failed\n",
  yyFunction);
 ExtractComm_Exit ();
}

tTree ExtractCommunication ARGS ((tTree stmt));
static void ProtocolCommunication ARGS ((tTree stmt, tTree new_stmt, tTree pre_stmts, tTree post_stmts));
void ExtractCommunicationExp ARGS ((tTree exp, tTree * yyP3, tTree * yyP2, tTree * yyP1));
static void GetCommunicationStmts ARGS ((tTree stmt, pvar home, tTree * yyP6, tTree * yyP5, tTree * yyP4));
static void ExtractComm ARGS ((tTree s, pvar home, tTree * yyP9, tTree * yyP8, tTree * yyP7));
static void SolveReduction ARGS ((tTree reduce, pvar home, tTree * yyP12, tTree * yyP11, tTree * yyP10));
static void MakeLocalRedAssigns ARGS ((tTree fn, tTree params, pvar home, tTree * yyP15, tTree * yyP14, tTree * yyP13));
static void MakeReductionTemp ARGS ((tTree fn, tTree params, pvar home, tTree * yyP18, tTree * yyP17, tTree * yyP16));
static void MakeLocalReductionParams ARGS ((tTree f, tTree params, pvar home, tTree * yyP20, tTree * yyP19));
static tTree MakeResidentLoop ARGS ((tTree loop));
static tTree MakeReducedIF ARGS ((tTree t));
static tTree Clean ARGS ((tTree t));
static void SolveAssignment ARGS ((tTree s, pvar home, tTree * yyP23, tTree * yyP22, tTree * yyP21));
static void MakeTempRHS ARGS ((tTree assign, pvar home_var, tTree * yyP25, tTree * yyP24));
static void MakeTempLHS ARGS ((tTree assign, pvar home, tTree * yyP27, tTree * yyP26));
static void MyMakeLocalExp ARGS ((tTree exp, pvar home, tTree * yyP30, tTree * yyP29, tTree * yyP28));

tTree ExtractCommunication
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (Tree_IsType (stmt, kACF_NODE)) {
/* line 72 "ExtractComm.puma" */
 {
  var_descriptor home;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 76 "ExtractComm.puma" */
   MakeReplicatedDescriptor (& home);
/* line 78 "ExtractComm.puma" */
   GetCommunicationStmts (stmt, & home, & yyV1, & yyV2, & yyV3);
/* line 80 "ExtractComm.puma" */
   ProtocolCommunication (stmt, yyV1, yyV2, yyV3);
  }
   return ComposeNewACF (yyV2, yyV1, yyV3);
 }

  }
/* line 85 "ExtractComm.puma" */
  {
/* line 86 "ExtractComm.puma" */
   failure_protocol (MODULE, "ExtractCommunication", stmt);
  }
   return NoTree;

}

static void ProtocolCommunication
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree new_stmt, register tTree pre_stmts, register tTree post_stmts)
# else
(stmt, new_stmt, pre_stmts, post_stmts)
 register tTree stmt;
 register tTree new_stmt;
 register tTree pre_stmts;
 register tTree post_stmts;
# endif
{
/* line 103 "ExtractComm.puma" */
  {
/* line 105 "ExtractComm.puma" */
   if (! ((pre_stmts == NoTree))) goto yyL1;
  {
/* line 106 "ExtractComm.puma" */
   if (! ((post_stmts == NoTree))) goto yyL1;
  {
/* line 108 "ExtractComm.puma" */
   set_protocol_stmt (stmt);
/* line 110 "ExtractComm.puma" */
   stmt_protocol ("LOCAL: no communication generated");
  }
  }
  }
   return;
yyL1:;

/* line 113 "ExtractComm.puma" */
  {
/* line 115 "ExtractComm.puma" */
   set_protocol_stmt (stmt);
/* line 116 "ExtractComm.puma" */
   stmt_protocol ("communication extracted");
/* line 118 "ExtractComm.puma" */
 if (pre_stmts != NoTree)
         tree_protocol ("COMMUNICATION in : \n", pre_stmts);
      if (post_stmts != NoTree)
         tree_protocol ("COMMUNICATION out : \n", post_stmts);
    
  }
   return;

;
}

void ExtractCommunicationExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(exp, yyP3, yyP2, yyP1)
 register tTree exp;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (Tree_IsType (exp, kBT_EXP)) {
/* line 135 "ExtractComm.puma" */
 {
  var_descriptor home;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 139 "ExtractComm.puma" */
   MakeReplicatedDescriptor (& home);
/* line 141 "ExtractComm.puma" */
   MyMakeLocalExp (exp, & home, & yyV1, & yyV2, & yyV3);
  }
   * yyP3 = yyV1;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  }
;
}

static void GetCommunicationStmts
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar home, register tTree * yyP6, register tTree * yyP5, register tTree * yyP4)
# else
(stmt, home, yyP6, yyP5, yyP4)
 register tTree stmt;
 pvar home;
 register tTree * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 159 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 161 "ExtractComm.puma" */
   ExtractComm (stmt, home, & yyV1, & yyV2, & yyV3);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 164 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 166 "ExtractComm.puma" */
   ExtractComm (stmt, home, & yyV1, & yyV2, & yyV3);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
/* line 169 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 171 "ExtractComm.puma" */
   ExtractComm (stmt, home, & yyV1, & yyV2, & yyV3);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 174 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 176 "ExtractComm.puma" */
   ExtractComm (stmt, home, & yyV1, & yyV2, & yyV3);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCOMP_IF_STMT) {
/* line 179 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 182 "ExtractComm.puma" */
   MyMakeLocalExp (stmt->ACF_BASIC.BASIC_STMT->COMP_IF_STMT.IF_EXP, home, & yyV1, & yyV2, & yyV3);
/* line 184 "ExtractComm.puma" */
 stmt->ACF_BASIC.BASIC_STMT->COMP_IF_STMT.IF_EXP = yyV1; 
  }
   * yyP6 = stmt;
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

  }
  }
  if (stmt->Kind == kACF_FORALL) {
/* line 187 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 189 "ExtractComm.puma" */
   ExtractComm (stmt, home, & yyV1, & yyV2, & yyV3);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

  }
  if (stmt->Kind == kACF_HOME) {
/* line 192 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 194 "ExtractComm.puma" */
   ExtractComm (stmt, home, & yyV1, & yyV2, & yyV3);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

  }
  if (stmt->Kind == kACF_TASK_REGION) {
/* line 197 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 199 "ExtractComm.puma" */
   ExtractComm (stmt, home, & yyV1, & yyV2, & yyV3);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

  }
  if (stmt->Kind == kACF_DO) {
/* line 202 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 204 "ExtractComm.puma" */
   if (! ((IsParallelLoop (stmt)))) goto yyL9;
  {
/* line 206 "ExtractComm.puma" */
   ExtractComm (stmt, home, & yyV1, & yyV2, & yyV3);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }
yyL9:;

  }
/* line 211 "ExtractComm.puma" */
   * yyP6 = stmt;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;

;
}

static void ExtractComm
# if defined __STDC__ | defined __cplusplus
(register tTree s, pvar home, register tTree * yyP9, register tTree * yyP8, register tTree * yyP7)
# else
(s, home, yyP9, yyP8, yyP7)
 register tTree s;
 pvar home;
 register tTree * yyP9;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{

  switch (s->Kind) {
  case kACF_DO:
  if (s->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 235 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  var_descriptor new_home;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 240 "ExtractComm.puma" */
   MyMakeLocalExp (s->ACF_DO.DO_RANGE, home, & yyV1, & yyV2, & yyV3);
/* line 242 "ExtractComm.puma" */
 s->ACF_DO.DO_RANGE = yyV1; 
/* line 244 "ExtractComm.puma" */
   IncParNesting (s);
/* line 248 "ExtractComm.puma" */
   GetTheBodyHome (s, & new_home);
/* line 250 "ExtractComm.puma" */
   ExtractComm (s->ACF_DO.DO_BODY, & new_home, & yyV4, & yyV5, & yyV6);
/* line 252 "ExtractComm.puma" */
 s->ACF_DO.DO_BODY = yyV4; 
/* line 254 "ExtractComm.puma" */
   ExpandNewStatements (yyV5, s, s->ACF_DO.Line);
/* line 255 "ExtractComm.puma" */
   ExpandNewStatements (yyV6, s, s->ACF_DO.Line);
/* line 257 "ExtractComm.puma" */
   DecParNesting (s);
/* line 259 "ExtractComm.puma" */
   yyV5 = CombineACF (yyV2, yyV5);
/* line 260 "ExtractComm.puma" */
   yyV6 = CombineACF (yyV6, yyV3);
  }
   * yyP9 = MakeResidentLoop (s);
   * yyP8 = yyV5;
   * yyP7 = yyV6;
   return;
 }

  }
  if (s->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 485 "ExtractComm.puma" */
 {
  tTree new;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 488 "ExtractComm.puma" */
   IncParNesting (s);
/* line 492 "ExtractComm.puma" */
   ExtractComm (s->ACF_DO.DO_BODY, home, & yyV1, & yyV2, & yyV3);
/* line 494 "ExtractComm.puma" */
 s->ACF_DO.DO_BODY = yyV1; 
/* line 498 "ExtractComm.puma" */
   ExpandNewStatements (yyV2, s, s->ACF_DO.Line);
/* line 499 "ExtractComm.puma" */
   ExpandNewStatements (yyV3, s, s->ACF_DO.Line);
/* line 501 "ExtractComm.puma" */
   DecParNesting (s);
  }
   * yyP9 = s;
   * yyP8 = yyV2;
   * yyP7 = yyV3;
   return;
 }

  }
  break;
  case kACF_FORALL:
/* line 269 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  var_descriptor new_home;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 272 "ExtractComm.puma" */
   MyMakeLocalExp (s->ACF_FORALL.FORALL_RANGE, home, & yyV1, & yyV2, & yyV3);
/* line 274 "ExtractComm.puma" */
 s->ACF_FORALL.FORALL_RANGE = yyV1; 
/* line 276 "ExtractComm.puma" */
   IncParNesting (s);
/* line 280 "ExtractComm.puma" */
   GetTheBodyHome (s, & new_home);
/* line 282 "ExtractComm.puma" */
   ExtractComm (s->ACF_FORALL.FORALL_BODY, & new_home, & yyV4, & yyV5, & yyV6);
/* line 284 "ExtractComm.puma" */
 s->ACF_FORALL.FORALL_BODY = yyV4; 
/* line 286 "ExtractComm.puma" */
   ExpandNewStatements (yyV5, s, s->ACF_FORALL.Line);
/* line 287 "ExtractComm.puma" */
   ExpandNewStatements (yyV6, s, s->ACF_FORALL.Line);
/* line 289 "ExtractComm.puma" */
   DecParNesting (s);
/* line 291 "ExtractComm.puma" */
   yyV5 = CombineACF (yyV2, yyV5);
/* line 292 "ExtractComm.puma" */
   yyV6 = CombineACF (yyV6, yyV3);
  }
   * yyP9 = MakeResidentLoop (s);
   * yyP8 = yyV5;
   * yyP7 = yyV6;
   return;
 }

  case kACF_LIST:
/* line 295 "ExtractComm.puma" */
 {
  tTree newacf;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 301 "ExtractComm.puma" */
   set_protocol_stmt (s->ACF_LIST.Elem);
/* line 303 "ExtractComm.puma" */
   ExtractComm (s->ACF_LIST.Elem, home, & yyV1, & yyV2, & yyV3);
/* line 304 "ExtractComm.puma" */
   ExtractComm (s->ACF_LIST.Next, home, & yyV4, & yyV5, & yyV6);
/* line 306 "ExtractComm.puma" */
   newacf = ReplaceACF (s, yyV1, yyV4);
  }
   * yyP9 = newacf;
   * yyP8 = CombineACF (yyV2, yyV5);
   * yyP7 = CombineACF (yyV6, yyV3);
   return;
 }

  case kACF_EMPTY:
/* line 309 "ExtractComm.puma" */
   * yyP9 = s;
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

  case kACF_DUMMY:
/* line 312 "ExtractComm.puma" */
   * yyP9 = s;
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

  case kACF_HOME:
/* line 321 "ExtractComm.puma" */
 {
  var_descriptor new_home;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 325 "ExtractComm.puma" */
   GetTheBodyHome (s, & new_home);
/* line 327 "ExtractComm.puma" */
   IncParNesting (s);
/* line 329 "ExtractComm.puma" */
   ExtractComm (s->ACF_HOME.HOME_BODY, & new_home, & yyV1, & yyV2, & yyV3);
/* line 331 "ExtractComm.puma" */
   DecParNesting (s);
/* line 333 "ExtractComm.puma" */
 s->ACF_HOME.HOME_BODY = yyV1; 
  }
   * yyP9 = Clean (s);
   * yyP8 = yyV2;
   * yyP7 = yyV3;
   return;
 }

  case kACF_TASK_REGION:
/* line 342 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 344 "ExtractComm.puma" */
   IncParNesting (s);
/* line 346 "ExtractComm.puma" */
   ExtractComm (s->ACF_TASK_REGION.TASK_BODY, home, & yyV1, & yyV2, & yyV3);
/* line 348 "ExtractComm.puma" */
   DecParNesting (s);
/* line 350 "ExtractComm.puma" */
 s->ACF_TASK_REGION.TASK_BODY = yyV1; 
  }
   * yyP9 = s;
   * yyP8 = yyV2;
   * yyP7 = yyV3;
   return;
 }

  case kACF_RESIDENT:
/* line 359 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 361 "ExtractComm.puma" */
   IncParNesting (s);
/* line 363 "ExtractComm.puma" */
   ExtractComm (s->ACF_RESIDENT.RESIDENT_BODY, home, & yyV1, & yyV2, & yyV3);
/* line 365 "ExtractComm.puma" */
   DecParNesting (s);
/* line 367 "ExtractComm.puma" */
 s->ACF_RESIDENT.RESIDENT_BODY = yyV1; 
  }
   * yyP9 = s;
   * yyP8 = yyV2;
   * yyP7 = yyV3;
   return;
 }

  case kACF_NEW:
/* line 376 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 378 "ExtractComm.puma" */
   IncParNesting (s);
/* line 380 "ExtractComm.puma" */
   ExtractComm (s->ACF_NEW.NEW_BODY, home, & yyV1, & yyV2, & yyV3);
/* line 382 "ExtractComm.puma" */
   DecParNesting (s);
/* line 384 "ExtractComm.puma" */
 s->ACF_NEW.NEW_BODY = yyV1; 
  }
   * yyP9 = s;
   * yyP8 = yyV2;
   * yyP7 = yyV3;
   return;
 }

  case kACF_REDUCTION:
/* line 393 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 395 "ExtractComm.puma" */
   IncParNesting (s);
/* line 397 "ExtractComm.puma" */
   ExtractComm (s->ACF_REDUCTION.REDUCTION_BODY, home, & yyV1, & yyV2, & yyV3);
/* line 399 "ExtractComm.puma" */
   DecParNesting (s);
/* line 401 "ExtractComm.puma" */
 s->ACF_REDUCTION.REDUCTION_BODY = yyV1; 
  }
   * yyP9 = s;
   * yyP8 = yyV2;
   * yyP7 = yyV3;
   return;
 }

  case kACF_BASIC:

  switch (s->ACF_BASIC.BASIC_STMT->Kind) {
  case kREDUCE_STMT:
/* line 410 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 412 "ExtractComm.puma" */
   SolveReduction (s, home, & yyV1, & yyV2, & yyV3);
  }
   * yyP9 = yyV1;
   * yyP8 = yyV2;
   * yyP7 = yyV3;
   return;
 }

  case kCALL_STMT:
/* line 421 "ExtractComm.puma" */
 {
  tTree pre_stmts;
  tTree post_stmts;
  {
/* line 426 "ExtractComm.puma" */
   MakeLocalParams (s->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, home, & pre_stmts, & post_stmts);
  }
   * yyP9 = s;
   * yyP8 = pre_stmts;
   * yyP7 = post_stmts;
   return;
 }

  case kASSIGN_STMT:
  if (s->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 435 "ExtractComm.puma" */
 {
  tTree new_var;
  tTree pre_stmts1;
  tTree pre_stmts2;
  tTree post_stmts1;
  tTree post_stmts2;
  {
/* line 446 "ExtractComm.puma" */
   MakeLocalParams (s->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, home, & pre_stmts1, & post_stmts1);
/* line 448 "ExtractComm.puma" */
   MakeLocalVarParam (s->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, IntentOut, home, & new_var, & pre_stmts2, & post_stmts2);
/* line 451 "ExtractComm.puma" */
 s->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = new_var; 
  }
   * yyP9 = s;
   * yyP8 = CombineACF (pre_stmts1, pre_stmts2);
   * yyP7 = CombineACF (post_stmts2, post_stmts1);
   return;
 }

  }
/* line 460 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 462 "ExtractComm.puma" */
   SolveAssignment (s, home, & yyV1, & yyV2, & yyV3);
  }
   * yyP9 = yyV1;
   * yyP8 = yyV2;
   * yyP7 = yyV3;
   return;
 }

  case kGOTO_STMT:
/* line 470 "ExtractComm.puma" */
   * yyP9 = s;
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

  case kALLOCATE_STMT:
/* line 473 "ExtractComm.puma" */
   * yyP9 = s;
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

  case kDEALLOCATE_STMT:
/* line 476 "ExtractComm.puma" */
   * yyP9 = s;
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

  case kIO_STMT:
/* line 577 "ExtractComm.puma" */
 {
  tTree pre_stmts;
  tTree post_stmts;
  {
/* line 583 "ExtractComm.puma" */
   MakeLocalParams (s->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS, home, & pre_stmts, & post_stmts);
  }
   * yyP9 = s;
   * yyP8 = pre_stmts;
   * yyP7 = post_stmts;
   return;
 }

  }

  break;
  case kACF_WHILE:
/* line 510 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 513 "ExtractComm.puma" */
   IncParNesting (s);
/* line 515 "ExtractComm.puma" */
   MyMakeLocalExp (s->ACF_WHILE.WHILE_EXP, home, & yyV1, & yyV2, & yyV3);
/* line 517 "ExtractComm.puma" */
 s->ACF_WHILE.WHILE_EXP = yyV1; 
/* line 519 "ExtractComm.puma" */
   ExtractComm (s->ACF_WHILE.WHILE_BODY, home, & yyV4, & yyV5, & yyV6);
/* line 520 "ExtractComm.puma" */
   DecParNesting (s);
/* line 522 "ExtractComm.puma" */
 s->ACF_WHILE.WHILE_BODY = yyV4; 
  }
   * yyP9 = s;
   * yyP8 = CombineACF (yyV2, yyV5);
   * yyP7 = CombineACF (yyV6, yyV3);
   return;
 }

  case kACF_IF:
/* line 532 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  tTree yyV7;
  tTree yyV8;
  tTree yyV9;
  {
/* line 538 "ExtractComm.puma" */
   IncParNesting (s);
/* line 540 "ExtractComm.puma" */
   MyMakeLocalExp (s->ACF_IF.IF_EXP, home, & yyV1, & yyV2, & yyV3);
/* line 542 "ExtractComm.puma" */
 s->ACF_IF.IF_EXP = yyV1; 
/* line 544 "ExtractComm.puma" */
   ExtractComm (s->ACF_IF.THEN_PART, home, & yyV4, & yyV5, & yyV6);
/* line 545 "ExtractComm.puma" */
   ExtractComm (s->ACF_IF.ELSE_PART, home, & yyV7, & yyV8, & yyV9);
/* line 547 "ExtractComm.puma" */
 s->ACF_IF.THEN_PART = yyV4; s->ACF_IF.ELSE_PART = yyV7; 
/* line 551 "ExtractComm.puma" */
   DecParNesting (s);
/* line 560 "ExtractComm.puma" */
 if (yyV5 != NoTree)

     

        serious_warning_protocol ("unmasked communication in THEN part");

     if (yyV8 != NoTree)

     

        serious_warning_protocol ("unmasked communication in ELSE part");

   
  }
   * yyP9 = MakeReducedIF (s);
   * yyP8 = CombineACF (yyV2, CombineACF (yyV5, yyV8));
   * yyP7 = CombineACF (yyV9, CombineACF (yyV6, yyV3));
   return;
 }

  }

/* line 586 "ExtractComm.puma" */
  {
/* line 588 "ExtractComm.puma" */
   error_protocol ("this statement in parallel loop not supported");
  }
   * yyP9 = s;
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

;
}

static void SolveReduction
# if defined __STDC__ | defined __cplusplus
(register tTree reduce, pvar home, register tTree * yyP12, register tTree * yyP11, register tTree * yyP10)
# else
(reduce, home, yyP12, yyP11, yyP10)
 register tTree reduce;
 pvar home;
 register tTree * yyP12;
 register tTree * yyP11;
 register tTree * yyP10;
# endif
{
  if (reduce->Kind == kACF_BASIC) {
  if (reduce->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 603 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 608 "ExtractComm.puma" */
   MakeLocalRedAssigns (reduce->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_FUNC, reduce->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS, home, & yyV1, & yyV2, & yyV3);
/* line 610 "ExtractComm.puma" */
 if (yyV1 == NoTree)

       { 

         yyV1 = reduce;

       }

     else

       { 

         yyV3 = CombineACF (mACF_LIST (reduce, NoTree), yyV3); 

       }

   
  }
   * yyP12 = yyV1;
   * yyP11 = yyV2;
   * yyP10 = yyV3;
   return;
 }

  }
  }
/* line 629 "ExtractComm.puma" */
  {
/* line 631 "ExtractComm.puma" */
   failure_protocol (MODULE, "SolveReduction", reduce);
  }
   * yyP12 = reduce;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

;
}

static void MakeLocalRedAssigns
# if defined __STDC__ | defined __cplusplus
(register tTree fn, register tTree params, pvar home, register tTree * yyP15, register tTree * yyP14, register tTree * yyP13)
# else
(fn, params, home, yyP15, yyP14, yyP13)
 register tTree fn;
 register tTree params;
 pvar home;
 register tTree * yyP15;
 register tTree * yyP14;
 register tTree * yyP13;
# endif
{
  if (params->Kind == kBTP_EMPTY) {
/* line 643 "ExtractComm.puma" */
   * yyP15 = NoTree;
   * yyP14 = NoTree;
   * yyP13 = NoTree;
   return;

  }
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 646 "ExtractComm.puma" */
 {
  tTree pre_stmts;
  tTree post_stmts;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 655 "ExtractComm.puma" */
   MakeLocalParams (params->BTP_LIST.Next->BTP_LIST.Elem, home, & pre_stmts, & post_stmts);
/* line 659 "ExtractComm.puma" */
   MakeReductionTemp (fn, params, home, & yyV1, & yyV2, & yyV3);
/* line 663 "ExtractComm.puma" */
   MakeLocalRedAssigns (fn, params->BTP_LIST.Next->BTP_LIST.Next, home, & yyV4, & yyV5, & yyV6);
/* line 665 "ExtractComm.puma" */
   yyV1 = CombineACF (yyV1, yyV4);
/* line 666 "ExtractComm.puma" */
   pre_stmts = CombineACF (pre_stmts, CombineACF (yyV2, yyV5));
/* line 667 "ExtractComm.puma" */
   post_stmts = CombineACF (yyV6, CombineACF (yyV3, post_stmts));
  }
   * yyP15 = yyV1;
   * yyP14 = pre_stmts;
   * yyP13 = post_stmts;
   return;
 }

  }
  }
  }
/* line 670 "ExtractComm.puma" */
  {
/* line 672 "ExtractComm.puma" */
   failure_protocol (MODULE, "MakeLocalRedAssigns", params);
  }
   * yyP15 = NoTree;
   * yyP14 = NoTree;
   * yyP13 = NoTree;
   return;

;
}

static void MakeReductionTemp
# if defined __STDC__ | defined __cplusplus
(register tTree fn, register tTree params, pvar home, register tTree * yyP18, register tTree * yyP17, register tTree * yyP16)
# else
(fn, params, home, yyP18, yyP17, yyP16)
 register tTree fn;
 register tTree params;
 pvar home;
 register tTree * yyP18;
 register tTree * yyP17;
 register tTree * yyP16;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 688 "ExtractComm.puma" */
 {
  tTree pre;
  tTree post;
  {
/* line 694 "ExtractComm.puma" */
   if (! ((! IsLocalVarRead (params->BTP_LIST.Elem->VAR_PARAM.V, home)))) goto yyL1;
  {
/* line 695 "ExtractComm.puma" */
   if (! ((IsIndShadowVariable (params->BTP_LIST.Elem->VAR_PARAM.V, home)))) goto yyL1;
  {
/* line 697 "ExtractComm.puma" */
   MakeIndShadowReduce (params->BTP_LIST.Elem->VAR_PARAM.V, fn, & pre, & post);
  }
  }
  }
   * yyP18 = NoTree;
   * yyP17 = pre;
   * yyP16 = post;
   return;
 }
yyL1:;

/* line 700 "ExtractComm.puma" */
  {
/* line 703 "ExtractComm.puma" */
   if (! ((IsLocalVarGlobal (params->BTP_LIST.Elem->VAR_PARAM.V, home)))) goto yyL2;
  }
   * yyP18 = NoTree;
   * yyP17 = NoTree;
   * yyP16 = NoTree;
   return;
yyL2:;

/* line 706 "ExtractComm.puma" */
 {
  tTree assign;
  tTree allocate;
  tTree deallocate;
  tTree tmp_var;
  tTree pre_stmts;
  tTree post_stmts;
  var_descriptor red_tmp;
  {
/* line 721 "ExtractComm.puma" */
   FullHomeTemp (params->BTP_LIST.Next->BTP_LIST.Elem, home, & red_tmp);
/* line 722 "ExtractComm.puma" */
   FullExpansion (& red_tmp);
/* line 724 "ExtractComm.puma" */
   MakeTemporaryStmt (VarParamToExp (params->BTP_LIST.Next->BTP_LIST.Elem), & red_tmp, & allocate, & tmp_var, & assign, & deallocate);
/* line 727 "ExtractComm.puma" */
 params->BTP_LIST.Next->BTP_LIST.Elem = mVAR_PARAM (tmp_var); 
/* line 729 "ExtractComm.puma" */
   MakeFullLocalIndexes (params->BTP_LIST.Elem->VAR_PARAM.V, home, & pre_stmts, & post_stmts);
/* line 731 "ExtractComm.puma" */
   pre_stmts = CombineACF (allocate, pre_stmts);
/* line 732 "ExtractComm.puma" */
   post_stmts = CombineACF (post_stmts, deallocate);
  }
   * yyP18 = assign;
   * yyP17 = allocate;
   * yyP16 = deallocate;
   return;
 }

  }
  }
  }
;
}

static void MakeLocalReductionParams
# if defined __STDC__ | defined __cplusplus
(register tTree f, register tTree params, pvar home, register tTree * yyP20, register tTree * yyP19)
# else
(f, params, home, yyP20, yyP19)
 register tTree f;
 register tTree params;
 pvar home;
 register tTree * yyP20;
 register tTree * yyP19;
# endif
{
  if (params->Kind == kBTP_EMPTY) {
/* line 744 "ExtractComm.puma" */
   * yyP20 = NoTree;
   * yyP19 = NoTree;
   return;

  }
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 747 "ExtractComm.puma" */
 {
  tTree pre;
  tTree post;
  tTree pre1;
  tTree post1;
  tTree yyV1;
  tTree yyV2;
  {
/* line 750 "ExtractComm.puma" */
   if (! ((! IsLocalVarRead (params->BTP_LIST.Elem->VAR_PARAM.V, home)))) goto yyL2;
  {
/* line 751 "ExtractComm.puma" */
   if (! ((IsIndShadowVariable (params->BTP_LIST.Elem->VAR_PARAM.V, home)))) goto yyL2;
  {
/* line 759 "ExtractComm.puma" */
   MakeIndShadowReduce (params->BTP_LIST.Elem->VAR_PARAM.V, f, & pre, & post);
/* line 761 "ExtractComm.puma" */
   MakeLocalParams (params->BTP_LIST.Next->BTP_LIST.Elem, home, & pre1, & post1);
/* line 763 "ExtractComm.puma" */
   MakeLocalReductionParams (f, params->BTP_LIST.Next->BTP_LIST.Next, home, & yyV1, & yyV2);
/* line 765 "ExtractComm.puma" */
   pre = CombineACF (CombineACF (pre, pre1), yyV1);
/* line 766 "ExtractComm.puma" */
   post = CombineACF (CombineACF (yyV2, post1), post);
  }
  }
  }
   * yyP20 = pre;
   * yyP19 = post;
   return;
 }
yyL2:;

/* line 769 "ExtractComm.puma" */
 {
  tTree pre;
  tTree post;
  tTree yyV1;
  tTree yyV2;
  {
/* line 777 "ExtractComm.puma" */
   MakeLocalParams (params->BTP_LIST.Next->BTP_LIST.Elem, home, & pre, & post);
/* line 778 "ExtractComm.puma" */
   MakeLocalReductionParams (f, params->BTP_LIST.Next->BTP_LIST.Next, home, & yyV1, & yyV2);
/* line 780 "ExtractComm.puma" */
   pre = CombineACF (pre, yyV1);
/* line 781 "ExtractComm.puma" */
   post = CombineACF (yyV2, post);
  }
   * yyP20 = pre;
   * yyP19 = post;
   return;
 }

  }
  }
  }
/* line 784 "ExtractComm.puma" */
  {
/* line 786 "ExtractComm.puma" */
   failure_protocol (MODULE, "MakeLocalReductionParams", params);
  }
   * yyP20 = NoTree;
   * yyP19 = NoTree;
   return;

;
}

static tTree MakeResidentLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_BODY->Kind == kACF_EMPTY) {
/* line 799 "ExtractComm.puma" */
   return NoTree;

  }
  if (loop->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
/* line 804 "ExtractComm.puma" */
  {
/* line 806 "ExtractComm.puma" */
 loop->ACF_DO.DO_HOME_INFO->COMM_INFO.is_local = rtrue; 
  }
   return loop;

  }
  }
/* line 811 "ExtractComm.puma" */
  {
/* line 812 "ExtractComm.puma" */
   failure_protocol (MODULE, "MakeResidentLoop", loop);
  }
   return NoTree;

}

static tTree MakeReducedIF
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_IF) {
  if (t->ACF_IF.THEN_PART->Kind == kACF_EMPTY) {
  if (t->ACF_IF.ELSE_PART->Kind == kACF_EMPTY) {
/* line 824 "ExtractComm.puma" */
   return NoTree;

  }
  }
/* line 829 "ExtractComm.puma" */
   return t;

  }
/* line 834 "ExtractComm.puma" */
  {
/* line 836 "ExtractComm.puma" */
   failure_protocol (MODULE, "MakeReducedIF", t);
  }
   return t;

}

static tTree Clean
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_HOME) {
  if (t->ACF_HOME.HOME_BODY->Kind == kACF_EMPTY) {
/* line 851 "ExtractComm.puma" */
   return NoTree;

  }
  }
/* line 856 "ExtractComm.puma" */
   return t;

}

static void SolveAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree s, pvar home, register tTree * yyP23, register tTree * yyP22, register tTree * yyP21)
# else
(s, home, yyP23, yyP22, yyP21)
 register tTree s;
 pvar home;
 register tTree * yyP23;
 register tTree * yyP22;
 register tTree * yyP21;
# endif
{
  if (s->Kind == kACF_BASIC) {
  if (s->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 868 "ExtractComm.puma" */
  {
/* line 870 "ExtractComm.puma" */
   if (! ((IsNoDescriptor (home)))) goto yyL1;
  {
/* line 872 "ExtractComm.puma" */
   stmt_protocol ("assignment executed by all processors");
  }
  }
   * yyP23 = s;
   * yyP22 = NoTree;
   * yyP21 = NoTree;
   return;
yyL1:;

/* line 875 "ExtractComm.puma" */
  {
/* line 877 "ExtractComm.puma" */
   if (! ((IsLocalAssignment (s->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, s->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, home)))) goto yyL2;
  {
/* line 879 "ExtractComm.puma" */
   stmt_protocol ("assignment is local (no communication)");
  }
  }
   * yyP23 = s;
   * yyP22 = NoTree;
   * yyP21 = NoTree;
   return;
yyL2:;

/* line 884 "ExtractComm.puma" */
  {
/* line 887 "ExtractComm.puma" */
   if (! ((IsCopyInAssignment (s->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, s->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, home)))) goto yyL3;
  {
/* line 889 "ExtractComm.puma" */
   stmt_protocol ("stmt is copy in (becomes pre-fetch)");
  }
  }
   * yyP23 = NoTree;
   * yyP22 = mACF_LIST (s, NoTree);
   * yyP21 = NoTree;
   return;
yyL3:;

/* line 894 "ExtractComm.puma" */
  {
/* line 897 "ExtractComm.puma" */
   if (! ((IsCopyOutAssignment (s->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, s->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, home)))) goto yyL4;
  {
/* line 899 "ExtractComm.puma" */
   stmt_protocol ("stmt is copy out (becomes post-store)");
  }
  }
   * yyP23 = NoTree;
   * yyP22 = NoTree;
   * yyP21 = mACF_LIST (s, NoTree);
   return;
yyL4:;

/* line 902 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 907 "ExtractComm.puma" */
   MakeTempRHS (s, home, & yyV1, & yyV2);
/* line 908 "ExtractComm.puma" */
   MakeTempLHS (s, home, & yyV3, & yyV4);
/* line 910 "ExtractComm.puma" */
   set_protocol_stmt (s);
/* line 912 "ExtractComm.puma" */
 if (yyV1 == NoTree)
       { if (yyV3 == NoTree)
           stmt_protocol ("assignment is local (no comm)");
          else
           stmt_protocol ("assignment has lhs comm");
       }
      else
       { if (yyV3 == NoTree)
           stmt_protocol ("assignment has rhs comm");
          else
           stmt_protocol ("assignment has lhs/rhs comm");
       }
   
  }
   * yyP23 = s;
   * yyP22 = CombineACF (yyV1, yyV3);
   * yyP21 = CombineACF (yyV4, yyV2);
   return;
 }

  }
  }
;
}

static void MakeTempRHS
# if defined __STDC__ | defined __cplusplus
(register tTree assign, pvar home_var, register tTree * yyP25, register tTree * yyP24)
# else
(assign, home_var, yyP25, yyP24)
 register tTree assign;
 pvar home_var;
 register tTree * yyP25;
 register tTree * yyP24;
# endif
{
  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 937 "ExtractComm.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 939 "ExtractComm.puma" */
   MyMakeLocalExp (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, home_var, & yyV1, & yyV2, & yyV3);
/* line 941 "ExtractComm.puma" */
 assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP = yyV1; 
  }
   * yyP25 = yyV2;
   * yyP24 = yyV3;
   return;
 }

  }
  }
;
}

static void MakeTempLHS
# if defined __STDC__ | defined __cplusplus
(register tTree assign, pvar home, register tTree * yyP27, register tTree * yyP26)
# else
(assign, home, yyP27, yyP26)
 register tTree assign;
 pvar home;
 register tTree * yyP27;
 register tTree * yyP26;
# endif
{
  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 964 "ExtractComm.puma" */
 {
  tTree pre_stmts;
  tTree post_stmts;
  tTree tmp_var;
  {
/* line 970 "ExtractComm.puma" */
   MakeLocalVarAccess (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, home, IntentOut, & tmp_var, & pre_stmts, & post_stmts);
/* line 973 "ExtractComm.puma" */
 assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = tmp_var; 
  }
   * yyP27 = pre_stmts;
   * yyP26 = post_stmts;
   return;
 }

  }
  }
/* line 976 "ExtractComm.puma" */
  {
/* line 978 "ExtractComm.puma" */
   failure_protocol (MODULE, "MakeTempLHS", assign);
  }
   * yyP27 = NoTree;
   * yyP26 = NoTree;
   return;

;
}

static void MyMakeLocalExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar home, register tTree * yyP30, register tTree * yyP29, register tTree * yyP28)
# else
(exp, home, yyP30, yyP29, yyP28)
 register tTree exp;
 pvar home;
 register tTree * yyP30;
 register tTree * yyP29;
 register tTree * yyP28;
# endif
{
/* line 991 "ExtractComm.puma" */
 {
  tTree new_exp;
  tTree pre_stmts;
  tTree post_stmts;
  {
/* line 997 "ExtractComm.puma" */
 
#ifdef DEBUG
     printf ("localize "); FileUnparse (stdout, exp); printf (" for home = ");
     FileUnparse (stdout, PrintableDescriptorVar (home));
     printf ("\n"); 
#endif

     MakeLocalExp (exp, home, &new_exp, &pre_stmts, &post_stmts);

#ifdef DEBUG
     printf ("localized is "); FileUnparse (stdout, new_exp); printf ("\n"); 
#endif
   
  }
   * yyP30 = new_exp;
   * yyP29 = pre_stmts;
   * yyP28 = post_stmts;
   return;
 }

;
}

void BeginExtractComm ARGS ((void))
{
}

void CloseExtractComm ARGS ((void))
{
}
