# include "Expressions.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 48 "Expressions.puma" */


# include "Tree.h"
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"
# include "precision.h"

# define MODULE "Expressions"

# include "Types.h"            /* GetExpType for KIND  */
# include "Objects.h"
# include "Intrinsics.h"

       /*************************************************
       *                                                *
       *   power(base, n) returns base ** n             *
       *                                                *
       *************************************************/

int power (base, n)
int base, n;
{ int i, p;
  
  p = 1;
  for (i=1; i<=n; ++i)
     p = p * base;
  return p;
}



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyExpressions.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Expressions_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Expressions, routine %s failed\n",
  yyFunction);
 Expressions_Exit ();
}

void GetIntConstValue ARGS ((tTree exp, rbool * found, int * val));
static void GetOptParamValue ARGS ((tTree param, int dval, rbool * yyP2, int * yyP1));
void GetConstDifference ARGS ((tTree exp1, tTree exp2, rbool * found, int * val));
void ResolveExpression ARGS ((tTree exp, rbool * found, int * a, int * b, tTree * var));
static void MergeVars ARGS ((int a1, tTree v1, int a2, tTree v2, rbool * ok, tTree * var));
rbool EqualExpression ARGS ((tTree e1, tTree e2));
rbool EqualIndexes ARGS ((tTree indexes1, tTree indexes2));
static rbool EqualParameters ARGS ((tTree paramlist1, tTree paramlist2));
tTree MakeNotExp ARGS ((tTree e));
void SliceIncrement ARGS ((tTree exp, rbool * yyP4, int * yyP3));
tTree MakeSliceExp ARGS ((tTree start, tTree stop));
tTree MakeRangeExp ARGS ((tTree start, tTree stop, tTree inc));
tTree AddConstant ARGS ((tTree exp, int c));
tTree MakeConstant ARGS ((int n));
tTree MultConstant ARGS ((tTree exp, int c));
tTree DivConstant ARGS ((tTree exp, int c));
tTree MinusExpression ARGS ((tTree exp));
tTree InverseExpression ARGS ((tTree exp));
rbool IsStride1 ARGS ((tTree stride));
void GetExplicitShapeSize ARGS ((tTree shape, rbool * yyP6, int * yyP5));

void GetIntConstValue
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register rbool * found, register int * val)
# else
(exp, found, val)
 register tTree exp;
 register rbool * found;
 register int * val;
# endif
{

  switch (exp->Kind) {
  case kOP_EXP:
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
/* line 92 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  {
/* line 93 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
/* line 94 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
  }
   * found = yyV1 && yyV3;
   * val = yyV2 + yyV4;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
/* line 97 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  {
/* line 98 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
/* line 99 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
  }
   * found = yyV1 && yyV3;
   * val = yyV2 - yyV4;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
/* line 102 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  {
/* line 103 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
/* line 104 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
  }
   * found = yyV1 && yyV3;
   * val = yyV2 * yyV4;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_DIVIDE) {
/* line 107 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  {
/* line 108 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
/* line 109 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
/* line 110 "Expressions.puma" */
 if (yyV4 == 0) 
        { yyV3 = rfalse;
          yyV4   = 1;
        }
   
  }
   * found = yyV1 && yyV3;
   * val = yyV2 / yyV4;
   return;
 }

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_EXPO) {
/* line 117 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  {
/* line 118 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
/* line 119 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV3, & yyV4);
/* line 120 "Expressions.puma" */
 if (yyV4 < 0) yyV3 = rfalse; 
  }
   * found = yyV1 && yyV3;
   * val = power (yyV2, yyV4);
   return;
 }

  }
  break;
  case kOP1_EXP:
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
/* line 123 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 124 "Expressions.puma" */
   GetIntConstValue (exp->OP1_EXP.OPND, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = - yyV2;
   return;
 }

  }
  break;
  case kVAR_EXP:
/* line 127 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 128 "Expressions.puma" */
   GetIntConstValue (exp->VAR_EXP.V, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = yyV2;
   return;
 }

  case kUSED_VAR:
/* line 131 "Expressions.puma" */
  {
/* line 136 "Expressions.puma" */
   if (! ((exp->USED_VAR.VARNAME->VAR_OBJ.Object == NoObject))) goto yyL8;
  }
   * found = rfalse;
   * val = 0;
   return;
yyL8:;

  if (exp->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kVarObject) {
  if (exp->USED_VAR.VARNAME->VAR_OBJ.Object->VarObject.Kind->Kind == kVarParameter) {
/* line 139 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 142 "Expressions.puma" */
   GetIntConstValue (exp->USED_VAR.VARNAME->VAR_OBJ.Object->VarObject.Kind->VarParameter.Val, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = yyV2;
   return;
 }

  }
  }
  break;
  case kVAR_PARAM:
/* line 145 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 146 "Expressions.puma" */
   GetIntConstValue (exp->VAR_PARAM.V, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = yyV2;
   return;
 }

  case kADDR:
/* line 149 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 150 "Expressions.puma" */
   GetIntConstValue (exp->ADDR.E, & yyV1, & yyV2);
  }
   * found = yyV1;
   * val = yyV2;
   return;
 }

  case kCONST_EXP:
  if (exp->CONST_EXP.C->Kind == kINT_CONSTANT) {
/* line 153 "Expressions.puma" */
   * found = rtrue;
   * val = exp->CONST_EXP.C->INT_CONSTANT.value;
   return;

  }
  break;
  case kFUNC_CALL_EXP:
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 156 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  {
/* line 159 "Expressions.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL13;
  {
/* line 160 "Expressions.puma" */
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("SELECTED_REAL_KIND")))) goto yyL13;
  {
/* line 161 "Expressions.puma" */
   GetOptParamValue (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, 0, & yyV1, & yyV2);
/* line 162 "Expressions.puma" */
   GetOptParamValue (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, 0, & yyV3, & yyV4);
/* line 163 "Expressions.puma" */
   if (! ((yyV1 && yyV3))) goto yyL13;
  }
  }
  }
   * found = rtrue;
   * val = selected_real_kind (yyV2, yyV4);
   return;
 }
yyL13:;

  }
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 168 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 171 "Expressions.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL14;
  {
/* line 172 "Expressions.puma" */
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("SELECTED_REAL_KIND")))) goto yyL14;
  {
/* line 173 "Expressions.puma" */
   GetOptParamValue (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, 0, & yyV1, & yyV2);
/* line 174 "Expressions.puma" */
   if (! ((yyV1))) goto yyL14;
  }
  }
  }
   * found = rtrue;
   * val = selected_real_kind (yyV2, 0);
   return;
 }
yyL14:;

  }
/* line 177 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 180 "Expressions.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL15;
  {
/* line 181 "Expressions.puma" */
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("SELECTED_INT_KIND")))) goto yyL15;
  {
/* line 182 "Expressions.puma" */
   GetIntConstValue (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, & yyV1, & yyV2);
/* line 183 "Expressions.puma" */
   if (! ((yyV1))) goto yyL15;
  }
  }
  }
   * found = rtrue;
   * val = selected_int_kind (yyV2);
   return;
 }
yyL15:;

  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 192 "Expressions.puma" */
 {
  type_rec rtype;
  {
/* line 195 "Expressions.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL16;
  {
/* line 196 "Expressions.puma" */
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("KIND")))) goto yyL16;
  {
/* line 200 "Expressions.puma" */
   GetExpType (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, & rtype);
  }
  }
  }
   * found = rtrue;
   * val = rtype . type_size;
   return;
 }
yyL16:;

  }
  }
  break;
  }

/* line 203 "Expressions.puma" */
   * found = rfalse;
   * val = 0;
   return;

;
}

static void GetOptParamValue
# if defined __STDC__ | defined __cplusplus
(register tTree param, register int dval, register rbool * yyP2, register int * yyP1)
# else
(param, dval, yyP2, yyP1)
 register tTree param;
 register int dval;
 register rbool * yyP2;
 register int * yyP1;
# endif
{
  if (param->Kind == kNO_PARAM) {
/* line 208 "Expressions.puma" */
   * yyP2 = rtrue;
   * yyP1 = dval;
   return;

  }
  if (param->Kind == kVAR_PARAM) {
/* line 211 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 213 "Expressions.puma" */
   GetIntConstValue (param, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
/* line 216 "Expressions.puma" */
   * yyP2 = rfalse;
   * yyP1 = 0;
   return;

;
}

void GetConstDifference
# if defined __STDC__ | defined __cplusplus
(register tTree exp1, register tTree exp2, register rbool * found, register int * val)
# else
(exp1, exp2, found, val)
 register tTree exp1;
 register tTree exp2;
 register rbool * found;
 register int * val;
# endif
{
/* line 233 "Expressions.puma" */
  {
/* line 234 "Expressions.puma" */
   if (! (((exp1 == NoTree) || (exp2 == NoTree)))) goto yyL1;
  {
/* line 235 "Expressions.puma" */
   printf ("Illegal Call of GetConstDifference with NoTree\n");
/* line 236 "Expressions.puma" */
   kill_in_protocol ();
  }
  }
   * found = rfalse;
   * val = 0;
   return;
yyL1:;

/* line 239 "Expressions.puma" */
  {
/* line 241 "Expressions.puma" */
   if (! ( EqualExpression (exp1, exp2 )  == rtrue)) goto yyL2;
  }
   * found = rtrue;
   * val = 0;
   return;
yyL2:;

/* line 244 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  int yyV3;
  tTree yyV4;
  rbool yyV5;
  int yyV6;
  int yyV7;
  tTree yyV8;
  rbool yyV9;
  tTree yyV10;
  {
/* line 245 "Expressions.puma" */
   ResolveExpression (exp1, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 246 "Expressions.puma" */
   if (! ((yyV1))) goto yyL3;
  {
/* line 247 "Expressions.puma" */
   ResolveExpression (exp2, & yyV5, & yyV6, & yyV7, & yyV8);
/* line 248 "Expressions.puma" */
   if (! ((yyV5))) goto yyL3;
  {
/* line 249 "Expressions.puma" */
   MergeVars (yyV2, yyV4, yyV6, yyV8, & yyV9, & yyV10);
/* line 250 "Expressions.puma" */
   if (! ((yyV9 == rtrue))) goto yyL3;
  {
/* line 251 "Expressions.puma" */
   if (! ((yyV2 == yyV6))) goto yyL3;
  }
  }
  }
  }
   * found = rtrue;
   * val = yyV3 - yyV7;
   return;
 }
yyL3:;

  if (exp1->Kind == kSLICE_EXP) {
  if (exp2->Kind == kSLICE_EXP) {
/* line 254 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  {
/* line 256 "Expressions.puma" */
   GetConstDifference (exp1->SLICE_EXP.FIRST, exp2->SLICE_EXP.FIRST, & yyV1, & yyV2);
/* line 257 "Expressions.puma" */
   if (! ((yyV1 == rtrue))) goto yyL4;
  {
/* line 258 "Expressions.puma" */
   GetConstDifference (exp1->SLICE_EXP.STOP, exp2->SLICE_EXP.STOP, & yyV3, & yyV4);
/* line 259 "Expressions.puma" */
   if (! ((yyV3 == rtrue))) goto yyL4;
  {
/* line 260 "Expressions.puma" */
   if (! ((yyV2 == yyV4))) goto yyL4;
  {
/* line 261 "Expressions.puma" */
   if (! (EqualExpression (exp1->SLICE_EXP.INC, exp2->SLICE_EXP.INC))) goto yyL4;
  }
  }
  }
  }
   * found = rtrue;
   * val = yyV2;
   return;
 }
yyL4:;

  }
  }
/* line 264 "Expressions.puma" */
   * found = rfalse;
   * val = 0;
   return;

;
}

void ResolveExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register rbool * found, register int * a, register int * b, register tTree * var)
# else
(exp, found, a, b, var)
 register tTree exp;
 register rbool * found;
 register int * a;
 register int * b;
 register tTree * var;
# endif
{
/* line 289 "Expressions.puma" */
  {
/* line 290 "Expressions.puma" */
   if (! ((exp == NoTree))) goto yyL1;
  {
/* line 291 "Expressions.puma" */
   printf ("Call of ResolveExpression with NoTree\n");
/* line 292 "Expressions.puma" */
   kill_in_protocol ();
  }
  }
   * found = rfalse;
   * a = 0;
   * b = 0;
   * var = NoTree;
   return;
yyL1:;

/* line 295 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 296 "Expressions.puma" */
   GetIntConstValue (exp, & yyV1, & yyV2);
/* line 297 "Expressions.puma" */
   if (! ((yyV1))) goto yyL2;
  }
   * found = rtrue;
   * a = 0;
   * b = yyV2;
   * var = NoTree;
   return;
 }
yyL2:;

  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
/* line 300 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  int yyV3;
  tTree yyV4;
  rbool yyV5;
  int yyV6;
  int yyV7;
  tTree yyV8;
  rbool yyV9;
  tTree yyV10;
  {
/* line 301 "Expressions.puma" */
   ResolveExpression (exp->OP_EXP.OPND1, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 302 "Expressions.puma" */
   if (! ((yyV1))) goto yyL3;
  {
/* line 303 "Expressions.puma" */
   ResolveExpression (exp->OP_EXP.OPND2, & yyV5, & yyV6, & yyV7, & yyV8);
/* line 304 "Expressions.puma" */
   if (! ((yyV5))) goto yyL3;
  {
/* line 305 "Expressions.puma" */
   MergeVars (yyV2, yyV4, yyV6, yyV8, & yyV9, & yyV10);
/* line 306 "Expressions.puma" */
   if (! ((yyV9))) goto yyL3;
  }
  }
  }
   * found = rtrue;
   * a = yyV2 + yyV6;
   * b = yyV3 + yyV7;
   * var = yyV10;
   return;
 }
yyL3:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
/* line 309 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  int yyV3;
  tTree yyV4;
  rbool yyV5;
  int yyV6;
  int yyV7;
  tTree yyV8;
  rbool yyV9;
  tTree yyV10;
  {
/* line 310 "Expressions.puma" */
   ResolveExpression (exp->OP_EXP.OPND1, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 311 "Expressions.puma" */
   ResolveExpression (exp->OP_EXP.OPND2, & yyV5, & yyV6, & yyV7, & yyV8);
/* line 312 "Expressions.puma" */
   if (! ((yyV1 && yyV5))) goto yyL4;
  {
/* line 313 "Expressions.puma" */
   MergeVars (yyV2, yyV4, yyV6, yyV8, & yyV9, & yyV10);
/* line 314 "Expressions.puma" */
   if (! ((yyV9))) goto yyL4;
  }
  }
   * found = rtrue;
   * a = yyV2 - yyV6;
   * b = yyV3 - yyV7;
   * var = yyV10;
   return;
 }
yyL4:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
/* line 317 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  int yyV5;
  tTree yyV6;
  {
/* line 318 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
/* line 319 "Expressions.puma" */
   if (! ((yyV1))) goto yyL5;
  {
/* line 320 "Expressions.puma" */
   ResolveExpression (exp->OP_EXP.OPND2, & yyV3, & yyV4, & yyV5, & yyV6);
/* line 321 "Expressions.puma" */
   if (! ((yyV3))) goto yyL5;
  }
  }
   * found = rtrue;
   * a = yyV2 * yyV4;
   * b = yyV2 * yyV5;
   * var = yyV6;
   return;
 }
yyL5:;

/* line 324 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  int yyV5;
  tTree yyV6;
  {
/* line 325 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
/* line 326 "Expressions.puma" */
   if (! ((yyV1))) goto yyL6;
  {
/* line 327 "Expressions.puma" */
   ResolveExpression (exp->OP_EXP.OPND1, & yyV3, & yyV4, & yyV5, & yyV6);
/* line 328 "Expressions.puma" */
   if (! ((yyV3))) goto yyL6;
  }
  }
   * found = yyV3 && yyV1;
   * a = yyV2 * yyV4;
   * b = yyV2 * yyV5;
   * var = yyV6;
   return;
 }
yyL6:;

  }
  }
  if (exp->Kind == kOP1_EXP) {
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
/* line 331 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  int yyV3;
  tTree yyV4;
  {
/* line 332 "Expressions.puma" */
   ResolveExpression (exp->OP1_EXP.OPND, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 333 "Expressions.puma" */
   if (! ((yyV1))) goto yyL7;
  }
   * found = yyV1;
   * a = - yyV2;
   * b = - yyV3;
   * var = yyV4;
   return;
 }
yyL7:;

  }
  }

  switch (exp->Kind) {
  case kBOUND_EXP:
/* line 336 "Expressions.puma" */
   * found = rtrue;
   * a = 1;
   * b = 0;
   * var = exp;
   return;

  case kVAR_EXP:
/* line 339 "Expressions.puma" */
   * found = rtrue;
   * a = 1;
   * b = 0;
   * var = exp->VAR_EXP.V;
   return;

  case kVAR_PARAM:
/* line 342 "Expressions.puma" */
   * found = rtrue;
   * a = 1;
   * b = 0;
   * var = exp->VAR_PARAM.V;
   return;

  case kUSED_VAR:
/* line 345 "Expressions.puma" */
   * found = rtrue;
   * a = 1;
   * b = 0;
   * var = exp;
   return;

  case kINDEXED_VAR:
/* line 348 "Expressions.puma" */
   * found = rtrue;
   * a = 1;
   * b = 0;
   * var = exp;
   return;

  case kLOOP_VAR:
/* line 351 "Expressions.puma" */
   * found = rtrue;
   * a = 1;
   * b = 0;
   * var = exp;
   return;

  case kBT_EXP:
  case kDUMMY_EXP:
  case kCONST_EXP:
  case kOP_EXP:
  case kOP1_EXP:
  case kSLICE_EXP:
  case kFUNC_CALL_EXP:
  case kNAMED_EXP:
  case kDO_EXP:
  case kTYPE_EXP:
  case kARRAY_EXP:
  case kPERM_EXP:
  case kSIZE_EXP:
  case kRANK_EXP:
/* line 354 "Expressions.puma" */
   * found = rfalse;
   * a = 0;
   * b = 0;
   * var = NoTree;
   return;

  case kBT_PARAM:
  case kVALUE_PARAM:
  case kNAMED_PARAM:
  case kPROC_PARAM:
  case kFUNC_PARAM:
  case kFORMAT_PARAM:
  case kRETURN_PARAM:
  case kNO_PARAM:
/* line 357 "Expressions.puma" */
   * found = rfalse;
   * a = 0;
   * b = 0;
   * var = NoTree;
   return;

  case kBT_VAR:
  case kDUMMY_VAR:
  case kSUBSTRING_VAR:
  case kSELECTED_VAR:
  case kPERM_VAR:
  case kADDR:
  case kDO_VAR:
  case kREMOTE_VAR:
/* line 360 "Expressions.puma" */
   * found = rfalse;
   * a = 0;
   * b = 0;
   * var = NoTree;
   return;

  }

/* line 363 "Expressions.puma" */
  {
/* line 365 "Expressions.puma" */
   failure_protocol (MODULE, "ReplaceExp", exp);
  }
   * found = rfalse;
   * a = 0;
   * b = 0;
   * var = NoTree;
   return;

;
}

static void MergeVars
# if defined __STDC__ | defined __cplusplus
(register int a1, register tTree v1, register int a2, register tTree v2, register rbool * ok, register tTree * var)
# else
(a1, v1, a2, v2, ok, var)
 register int a1;
 register tTree v1;
 register int a2;
 register tTree v2;
 register rbool * ok;
 register tTree * var;
# endif
{
  if (equalint (a1, 0)) {
/* line 371 "Expressions.puma" */
   * ok = rtrue;
   * var = v2;
   return;

  }
  if (equalint (a2, 0)) {
/* line 374 "Expressions.puma" */
   * ok = rtrue;
   * var = v1;
   return;

  }
/* line 377 "Expressions.puma" */
  {
/* line 378 "Expressions.puma" */
   if (! ( EqualExpression (v1, v2)  == rtrue)) goto yyL3;
  }
   * ok = rtrue;
   * var = v1;
   return;
yyL3:;

/* line 381 "Expressions.puma" */
   * ok = rfalse;
   * var = NoTree;
   return;

;
}

rbool EqualExpression
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree e2)
# else
(e1, e2)
 register tTree e1;
 register tTree e2;
# endif
{
 yyRecursion:
/* line 393 "Expressions.puma" */
 {
  rbool found;
  int val1;
  int val2;
  {
/* line 399 "Expressions.puma" */
 GetIntConstValue (e1, &found, &val1); 
/* line 400 "Expressions.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 401 "Expressions.puma" */
 GetIntConstValue (e2, &found, &val2); 
/* line 402 "Expressions.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 403 "Expressions.puma" */
   if (! ((val1 == val2))) goto yyL1;
  }
  }
  }
   return rtrue;
 }
yyL1:;


  switch (e1->Kind) {
  case kSLICE_EXP:
  if (e2->Kind == kSLICE_EXP) {
/* line 406 "Expressions.puma" */
  {
/* line 408 "Expressions.puma" */
   if (! ((EqualExpression (e1->SLICE_EXP.FIRST, e2->SLICE_EXP.FIRST)))) goto yyL2;
  {
/* line 409 "Expressions.puma" */
   if (! ((EqualExpression (e1->SLICE_EXP.STOP, e2->SLICE_EXP.STOP)))) goto yyL2;
  {
/* line 410 "Expressions.puma" */
   if (! ((EqualExpression (e1->SLICE_EXP.INC, e2->SLICE_EXP.INC)))) goto yyL2;
  }
  }
  }
   return rtrue;
yyL2:;

  }
  break;
  case kDUMMY_EXP:
  if (e2->Kind == kDUMMY_EXP) {
/* line 413 "Expressions.puma" */
   return rtrue;

  }
  break;
  case kVAR_EXP:
  if (e2->Kind == kVAR_EXP) {
/* line 416 "Expressions.puma" */
  {
/* line 417 "Expressions.puma" */
   e1 = e1->VAR_EXP.V;
   e2 = e2->VAR_EXP.V;
   goto yyRecursion;
  }

  }
  break;
  case kSELECTED_VAR:
  if (e2->Kind == kSELECTED_VAR) {
/* line 420 "Expressions.puma" */
  {
/* line 423 "Expressions.puma" */
   if (! ((e1->SELECTED_VAR.SELECTOR->REC_COMP.Object == e2->SELECTED_VAR.SELECTOR->REC_COMP.Object))) goto yyL5;
  {
/* line 424 "Expressions.puma" */
   e1 = e1->SELECTED_VAR.SELEC_VAR;
   e2 = e2->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;
  }
  }
yyL5:;

  }
  break;
  case kINDEXED_VAR:
  if (e2->Kind == kINDEXED_VAR) {
/* line 429 "Expressions.puma" */
  {
/* line 431 "Expressions.puma" */
   if (! ((EqualExpression (e1->INDEXED_VAR.IND_VAR, e2->INDEXED_VAR.IND_VAR)))) goto yyL6;
  {
/* line 432 "Expressions.puma" */
   if (! ((EqualIndexes (e1->INDEXED_VAR.IND_EXPS, e2->INDEXED_VAR.IND_EXPS)))) goto yyL6;
  }
  }
   return rtrue;
yyL6:;

  }
  break;
  case kUSED_VAR:
  if (e2->Kind == kUSED_VAR) {
/* line 435 "Expressions.puma" */
  {
/* line 436 "Expressions.puma" */
   e1 = e1->USED_VAR.VARNAME;
   e2 = e2->USED_VAR.VARNAME;
   goto yyRecursion;
  }

  }
  break;
  case kLOOP_VAR:
  if (e2->Kind == kLOOP_VAR) {
/* line 439 "Expressions.puma" */
  {
/* line 440 "Expressions.puma" */
   e1 = e1->LOOP_VAR.LOOP_VARNAME;
   e2 = e2->LOOP_VAR.LOOP_VARNAME;
   goto yyRecursion;
  }

  }
  break;
  case kVAR_OBJ:
  if (e2->Kind == kVAR_OBJ) {
/* line 443 "Expressions.puma" */
  {
/* line 445 "Expressions.puma" */
   if (! ((e1->VAR_OBJ.Ident == e2->VAR_OBJ.Ident))) goto yyL9;
  }
   return rtrue;
yyL9:;

  }
  break;
  case kOP_EXP:
  if (e2->Kind == kOP_EXP) {
/* line 449 "Expressions.puma" */
  {
/* line 451 "Expressions.puma" */
   if (! (e1->OP_EXP.EXP_OP -> Kind == e2->OP_EXP.EXP_OP -> Kind)) goto yyL10;
  {
/* line 452 "Expressions.puma" */
   if (! (EqualExpression (e1->OP_EXP.OPND1, e2->OP_EXP.OPND1))) goto yyL10;
  {
/* line 453 "Expressions.puma" */
   e1 = e1->OP_EXP.OPND2;
   e2 = e2->OP_EXP.OPND2;
   goto yyRecursion;
  }
  }
  }
yyL10:;

  }
  break;
  case kOP1_EXP:
  if (e2->Kind == kOP1_EXP) {
/* line 456 "Expressions.puma" */
  {
/* line 458 "Expressions.puma" */
   if (! (e1->OP1_EXP.EXP_OP1 -> Kind == e2->OP1_EXP.EXP_OP1 -> Kind)) goto yyL11;
  {
/* line 459 "Expressions.puma" */
   e1 = e1->OP1_EXP.OPND;
   e2 = e2->OP1_EXP.OPND;
   goto yyRecursion;
  }
  }
yyL11:;

  }
  break;
  case kBOUND_EXP:
  if (e2->Kind == kBOUND_EXP) {
/* line 462 "Expressions.puma" */
  {
/* line 464 "Expressions.puma" */
   if (! ((e1->BOUND_EXP.dim == e2->BOUND_EXP.dim))) goto yyL12;
  {
/* line 465 "Expressions.puma" */
   if (! ((e1->BOUND_EXP.kind == e2->BOUND_EXP.kind))) goto yyL12;
  {
/* line 466 "Expressions.puma" */
   if (! ((e1->BOUND_EXP.local == e2->BOUND_EXP.local))) goto yyL12;
  {
/* line 467 "Expressions.puma" */
   if (! ((EqualExpression (e1->BOUND_EXP.VAR, e2->BOUND_EXP.VAR)))) goto yyL12;
  }
  }
  }
  }
   return rtrue;
yyL12:;

  }
  break;
  case kRANK_EXP:
  if (e2->Kind == kRANK_EXP) {
/* line 473 "Expressions.puma" */
  {
/* line 475 "Expressions.puma" */
   if (! ((e1->RANK_EXP.kind == e2->RANK_EXP.kind))) goto yyL13;
  }
   return rtrue;
yyL13:;

  }
  break;
  case kFUNC_CALL_EXP:
  if (e2->Kind == kFUNC_CALL_EXP) {
/* line 478 "Expressions.puma" */
  {
/* line 481 "Expressions.puma" */
   if (! ((IsPureCall (e1)))) goto yyL14;
  {
/* line 482 "Expressions.puma" */
   if (! ((IsPureCall (e2)))) goto yyL14;
  {
/* line 483 "Expressions.puma" */
   if (! ((e1->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object == e2->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object))) goto yyL14;
  {
/* line 484 "Expressions.puma" */
   if (! ((EqualParameters (e1->FUNC_CALL_EXP.FUNC_PARAMS, e2->FUNC_CALL_EXP.FUNC_PARAMS)))) goto yyL14;
  }
  }
  }
  }
   return rtrue;
yyL14:;

  }
  if (e1->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_EMPTY) {
  if (e2->Kind == kFUNC_CALL_EXP) {
  if (e2->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_EMPTY) {
/* line 487 "Expressions.puma" */
  {
/* line 490 "Expressions.puma" */
   if (! ((IsIntrCall (e1)))) goto yyL15;
  {
/* line 491 "Expressions.puma" */
   if (! ((IsIntrCall (e2)))) goto yyL15;
  {
/* line 492 "Expressions.puma" */
   if (! ((e1->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object == e2->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object))) goto yyL15;
  }
  }
  }
   return rtrue;
yyL15:;

  }
  }
  }
  if (e2->Kind == kFUNC_CALL_EXP) {
/* line 495 "Expressions.puma" */
  {
/* line 498 "Expressions.puma" */
   if (! ((IsIntrCall (e1)))) goto yyL16;
  {
/* line 499 "Expressions.puma" */
   if (! ((IsIntrCall (e2)))) goto yyL16;
  {
/* line 500 "Expressions.puma" */
   if (! ((e1->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object == e2->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object))) goto yyL16;
  {
/* line 501 "Expressions.puma" */
   if (! ((IntrFuncInquiry (e1->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL16;
  {
/* line 502 "Expressions.puma" */
   if (! ((EqualParameters (e1->FUNC_CALL_EXP.FUNC_PARAMS, e2->FUNC_CALL_EXP.FUNC_PARAMS)))) goto yyL16;
  }
  }
  }
  }
  }
   return rtrue;
yyL16:;

  }
  break;
  }

  return rfalse;
}

rbool EqualIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes1, register tTree indexes2)
# else
(indexes1, indexes2)
 register tTree indexes1;
 register tTree indexes2;
# endif
{
  if (indexes1->Kind == kBTE_LIST) {
  if (indexes2->Kind == kBTE_LIST) {
/* line 508 "Expressions.puma" */
  {
/* line 510 "Expressions.puma" */
   if (! ((EqualExpression (indexes1->BTE_LIST.Elem, indexes2->BTE_LIST.Elem)))) goto yyL1;
  {
/* line 511 "Expressions.puma" */
   if (! ((EqualIndexes (indexes1->BTE_LIST.Next, indexes2->BTE_LIST.Next)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  }
  if (indexes1->Kind == kBTE_EMPTY) {
  if (indexes2->Kind == kBTE_EMPTY) {
/* line 514 "Expressions.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static rbool EqualParameters
# if defined __STDC__ | defined __cplusplus
(register tTree paramlist1, register tTree paramlist2)
# else
(paramlist1, paramlist2)
 register tTree paramlist1;
 register tTree paramlist2;
# endif
{
  if (paramlist1->Kind == kBTP_LIST) {
  if (paramlist2->Kind == kBTP_LIST) {
/* line 520 "Expressions.puma" */
  {
/* line 522 "Expressions.puma" */
   if (! ((EqualParameters (paramlist1->BTP_LIST.Elem, paramlist2->BTP_LIST.Elem)))) goto yyL1;
  {
/* line 523 "Expressions.puma" */
   if (! ((EqualParameters (paramlist1->BTP_LIST.Next, paramlist2->BTP_LIST.Next)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  }
  if (paramlist1->Kind == kBTP_EMPTY) {
  if (paramlist2->Kind == kBTP_EMPTY) {
/* line 526 "Expressions.puma" */
   return rtrue;

  }
  }
  if (paramlist1->Kind == kNO_PARAM) {
  if (paramlist2->Kind == kNO_PARAM) {
/* line 529 "Expressions.puma" */
   return rtrue;

  }
  }
  if (paramlist1->Kind == kVAR_PARAM) {
  if (paramlist1->VAR_PARAM.V->Kind == kADDR) {
  if (paramlist2->Kind == kVAR_PARAM) {
  if (paramlist2->VAR_PARAM.V->Kind == kADDR) {
/* line 532 "Expressions.puma" */
  {
/* line 534 "Expressions.puma" */
   if (! ((EqualExpression (paramlist1->VAR_PARAM.V->ADDR.E, paramlist2->VAR_PARAM.V->ADDR.E)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  }
  }
  if (paramlist2->Kind == kVAR_PARAM) {
/* line 537 "Expressions.puma" */
  {
/* line 539 "Expressions.puma" */
   if (! ((EqualExpression (paramlist1->VAR_PARAM.V, paramlist2->VAR_PARAM.V)))) goto yyL5;
  }
   return rtrue;
yyL5:;

  }
  }
  return rfalse;
}

tTree MakeNotExp
# if defined __STDC__ | defined __cplusplus
(register tTree e)
# else
(e)
 register tTree e;
# endif
{
  if (e->Kind == kOP1_EXP) {
  if (e->OP1_EXP.EXP_OP1->Kind == kOP1_NOT) {
/* line 550 "Expressions.puma" */
   return e->OP1_EXP.OPND;

  }
  }
  if (e->Kind == kOP_EXP) {
  if (e->OP_EXP.EXP_OP->Kind == kOP_LT) {
/* line 554 "Expressions.puma" */
  {
/* line 555 "Expressions.puma" */
   e->OP_EXP.EXP_OP = mOP_GE ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_LE) {
/* line 559 "Expressions.puma" */
  {
/* line 560 "Expressions.puma" */
   e->OP_EXP.EXP_OP = mOP_GT ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_GT) {
/* line 564 "Expressions.puma" */
  {
/* line 565 "Expressions.puma" */
   e->OP_EXP.EXP_OP = mOP_LE ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_GE) {
/* line 569 "Expressions.puma" */
  {
/* line 570 "Expressions.puma" */
   e->OP_EXP.EXP_OP = mOP_LT ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_EQ) {
/* line 574 "Expressions.puma" */
  {
/* line 575 "Expressions.puma" */
   e->OP_EXP.EXP_OP = mOP_NE ();
  }
   return e;

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_NE) {
/* line 579 "Expressions.puma" */
  {
/* line 580 "Expressions.puma" */
   e->OP_EXP.EXP_OP = mOP_NE ();
  }
   return e;

  }
  }
/* line 584 "Expressions.puma" */
   return mOP1_EXP (mOP1_NOT (), e);

}

void SliceIncrement
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register rbool * yyP4, register int * yyP3)
# else
(exp, yyP4, yyP3)
 register tTree exp;
 register rbool * yyP4;
 register int * yyP3;
# endif
{
  if (exp->Kind == kSLICE_EXP) {
/* line 590 "Expressions.puma" */
 {
  rbool found;
  int val;
  {
/* line 594 "Expressions.puma" */
 if (exp->SLICE_EXP.INC == NoTree)
        { found = rtrue;
          val   = 1;
        }
       else if (exp->SLICE_EXP.INC->Kind == kDUMMY_EXP)
        { found = rtrue;
          val   = 1;
        }
       else
        GetIntConstValue (exp->SLICE_EXP.INC, &found, &val);
    
  }
   * yyP4 = found;
   * yyP3 = val;
   return;
 }

  }
/* line 607 "Expressions.puma" */
  {
/* line 609 "Expressions.puma" */
   failure_protocol (MODULE, "SliceIncrement", exp);
  }
   * yyP4 = rfalse;
   * yyP3 = 0;
   return;

;
}

tTree MakeSliceExp
# if defined __STDC__ | defined __cplusplus
(register tTree start, register tTree stop)
# else
(start, stop)
 register tTree start;
 register tTree stop;
# endif
{
/* line 622 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 623 "Expressions.puma" */
   GetIntConstValue (start, & yyV1, & yyV2);
/* line 624 "Expressions.puma" */
   if (! ((yyV1))) goto yyL1;
  }
   return AddConstant (stop, 1 - yyV2);
 }
yyL1:;

/* line 628 "Expressions.puma" */
   return AddConstant (mOP_EXP (mOP_MINUS (), stop, start), 1);

}

tTree MakeRangeExp
# if defined __STDC__ | defined __cplusplus
(register tTree start, register tTree stop, register tTree inc)
# else
(start, stop, inc)
 register tTree start;
 register tTree stop;
 register tTree inc;
# endif
{
/* line 645 "Expressions.puma" */
  {
/* line 646 "Expressions.puma" */
   if (! ((inc == NoTree))) goto yyL1;
  }
   return MakeSliceExp (start, stop);
yyL1:;

  if (inc->Kind == kDUMMY_EXP) {
/* line 650 "Expressions.puma" */
   return MakeSliceExp (start, stop);

  }
/* line 655 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  tTree new;
  {
/* line 657 "Expressions.puma" */
   GetIntConstValue (start, & yyV1, & yyV2);
/* line 658 "Expressions.puma" */
   GetIntConstValue (inc, & yyV3, & yyV4);
/* line 662 "Expressions.puma" */
 if (yyV1)
         new = AddConstant (stop, yyV2);
       else
         new = mOP_EXP (mOP_MINUS(), stop, start);
      if (yyV3)
         new = DivConstant (new, yyV4);
       else
         new = mOP_EXP (mOP_DIVIDE (), new, inc);
    
  }
   return AddConstant (new, 1);
 }

}

tTree AddConstant
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int c)
# else
(exp, c)
 register tTree exp;
 register int c;
# endif
{
 yyRecursion:
  if (equalint (c, 0)) {
/* line 686 "Expressions.puma" */
   return exp;

  }
/* line 690 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 691 "Expressions.puma" */
   GetIntConstValue (exp, & yyV1, & yyV2);
/* line 692 "Expressions.puma" */
   if (! (yyV1 == rtrue)) goto yyL2;
  }
   return MakeConstant (c + yyV2);
 }
yyL2:;

  if (exp->Kind == kSLICE_EXP) {
/* line 696 "Expressions.puma" */
  {
/* line 698 "Expressions.puma" */
   exp->SLICE_EXP.FIRST = AddConstant (exp->SLICE_EXP.FIRST, c);
/* line 699 "Expressions.puma" */
   exp->SLICE_EXP.STOP = AddConstant (exp->SLICE_EXP.STOP, c);
  }
   return exp;

  }
  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
/* line 709 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 710 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
/* line 711 "Expressions.puma" */
   if (! (yyV1 == rtrue)) goto yyL4;
  }
   exp = exp->OP_EXP.OPND2;
   c = c + yyV2;
   goto yyRecursion;
 }
yyL4:;

/* line 715 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 716 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
/* line 717 "Expressions.puma" */
   if (! (yyV1 == rtrue)) goto yyL5;
  }
   exp = exp->OP_EXP.OPND1;
   c = c + yyV2;
   goto yyRecursion;
 }
yyL5:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
/* line 721 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 722 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
/* line 723 "Expressions.puma" */
   if (! (yyV1 == rtrue)) goto yyL6;
  }
   exp = exp->OP_EXP.OPND1;
   c = c - yyV2;
   goto yyRecursion;
 }
yyL6:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_DIVIDE) {
/* line 729 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 730 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
/* line 731 "Expressions.puma" */
   if (! (yyV1 == rtrue)) goto yyL7;
  {
/* line 732 "Expressions.puma" */
 exp->OP_EXP.OPND1 = AddConstant (exp->OP_EXP.OPND1, c*yyV2); 
  }
  }
   return exp;
 }
yyL7:;

  }
  }
/* line 736 "Expressions.puma" */
  {
/* line 737 "Expressions.puma" */
   if (! ((c > 0))) goto yyL8;
  }
   return mOP_EXP (mOP_PLUS (), exp, mCONST_EXP (mINT_CONSTANT (c)));
yyL8:;

/* line 741 "Expressions.puma" */
  {
/* line 742 "Expressions.puma" */
   if (! (c < 0)) goto yyL9;
  }
   return mOP_EXP (mOP_MINUS (), exp, mCONST_EXP (mINT_CONSTANT (- c)));
yyL9:;

 yyAbort ("AddConstant");
 { tTree yyDummy; return yyDummy; }
}

tTree MakeConstant
# if defined __STDC__ | defined __cplusplus
(register int n)
# else
(n)
 register int n;
# endif
{
/* line 748 "Expressions.puma" */
  {
/* line 749 "Expressions.puma" */
   if (! ((n >= 0))) goto yyL1;
  }
   return mCONST_EXP (mINT_CONSTANT (n));
yyL1:;

/* line 753 "Expressions.puma" */
   return mOP1_EXP (mOP1_SIGN (), mCONST_EXP (mINT_CONSTANT (- n)));

}

tTree MultConstant
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int c)
# else
(exp, c)
 register tTree exp;
 register int c;
# endif
{
  if (equalint (c, 0)) {
/* line 764 "Expressions.puma" */
   return MakeConstant (0);

  }
  if (equalint (c, 1)) {
/* line 768 "Expressions.puma" */
   return exp;

  }
/* line 772 "Expressions.puma" */
  {
/* line 773 "Expressions.puma" */
   if (! ((c < 0))) goto yyL3;
  }
   return MinusExpression (MultConstant (exp, - c));
yyL3:;

/* line 777 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 778 "Expressions.puma" */
   GetIntConstValue (exp, & yyV1, & yyV2);
/* line 779 "Expressions.puma" */
   if (! ((yyV1))) goto yyL4;
  }
   return MakeConstant (c * yyV2);
 }
yyL4:;

  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
/* line 783 "Expressions.puma" */
  {
/* line 784 "Expressions.puma" */
 exp->OP_EXP.OPND1 = MultConstant (exp->OP_EXP.OPND1, c);
     exp->OP_EXP.OPND2 = MultConstant (exp->OP_EXP.OPND2, c);
   
  }
   return exp;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
/* line 790 "Expressions.puma" */
  {
/* line 791 "Expressions.puma" */
 exp->OP_EXP.OPND1 = MultConstant (exp->OP_EXP.OPND1, c);
     exp->OP_EXP.OPND2 = MultConstant (exp->OP_EXP.OPND2, c);
   
  }
   return exp;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
/* line 797 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 798 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
/* line 799 "Expressions.puma" */
   if (! ((yyV1))) goto yyL7;
  {
/* line 800 "Expressions.puma" */
 exp->OP_EXP.OPND1 = MakeConstant (c * yyV2); 
  }
  }
   return exp;
 }
yyL7:;

/* line 804 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 805 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
/* line 806 "Expressions.puma" */
   if (! ((yyV1))) goto yyL8;
  {
/* line 807 "Expressions.puma" */
 exp->OP_EXP.OPND2 = MakeConstant (c * yyV2); 
  }
  }
   return exp;
 }
yyL8:;

  }
  }
/* line 811 "Expressions.puma" */
   return mOP_EXP (mOP_TIMES (), exp, MakeConstant (c));

}

tTree DivConstant
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int c)
# else
(exp, c)
 register tTree exp;
 register int c;
# endif
{
  if (equalint (c, 0)) {
/* line 830 "Expressions.puma" */
   return MakeConstant (0);

  }
  if (equalint (c, 1)) {
/* line 834 "Expressions.puma" */
   return exp;

  }
/* line 838 "Expressions.puma" */
  {
/* line 839 "Expressions.puma" */
   if (! ((c < 0))) goto yyL3;
  }
   return MinusExpression (DivConstant (exp, - c));
yyL3:;

  if (exp->Kind == kCONST_EXP) {
  if (exp->CONST_EXP.C->Kind == kINT_CONSTANT) {
/* line 843 "Expressions.puma" */
  {
/* line 844 "Expressions.puma" */
   if (! ((exp->CONST_EXP.C->INT_CONSTANT.value % c == 0))) goto yyL4;
  {
/* line 845 "Expressions.puma" */
   exp->CONST_EXP.C->INT_CONSTANT.value = exp->CONST_EXP.C->INT_CONSTANT.value / c;
  }
  }
   return exp;
yyL4:;

  }
  }
  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
/* line 849 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 850 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
/* line 851 "Expressions.puma" */
   if (! ((yyV2 % c == 0))) goto yyL5;
  {
/* line 852 "Expressions.puma" */
 exp->OP_EXP.OPND1 = DivConstant (exp->OP_EXP.OPND1, c);
     exp->OP_EXP.OPND2 = MakeConstant (yyV2 / c);
   
  }
  }
   return exp;
 }
yyL5:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
/* line 858 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 859 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND1, & yyV1, & yyV2);
/* line 860 "Expressions.puma" */
   if (! ((yyV2 == c))) goto yyL6;
  }
   return exp->OP_EXP.OPND2;
 }
yyL6:;

/* line 864 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 865 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
/* line 866 "Expressions.puma" */
   if (! ((yyV2 % c == 0))) goto yyL7;
  {
/* line 867 "Expressions.puma" */
 exp->OP_EXP.OPND1 = DivConstant (exp->OP_EXP.OPND1, c); 
  }
  }
   return exp;
 }
yyL7:;

  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
/* line 871 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 872 "Expressions.puma" */
   GetIntConstValue (exp->OP_EXP.OPND2, & yyV1, & yyV2);
/* line 873 "Expressions.puma" */
   if (! ((yyV2 % c == 0))) goto yyL8;
  {
/* line 874 "Expressions.puma" */
 exp->OP_EXP.OPND1 = DivConstant (exp->OP_EXP.OPND1, c);
     exp->OP_EXP.OPND2 = MakeConstant (yyV2 / c);
   
  }
  }
   return exp;
 }
yyL8:;

  }
  }
/* line 880 "Expressions.puma" */
   return mOP_EXP (mOP_DIVIDE (), exp, MakeConstant (c));

}

tTree MinusExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
/* line 894 "Expressions.puma" */
 {
  tTree he;
  {
/* line 898 "Expressions.puma" */
 he = exp->OP_EXP.OPND1;
     exp->OP_EXP.OPND1 = exp->OP_EXP.OPND2;
     exp->OP_EXP.OPND2 = he;
   
  }
   return exp;
 }

  }
  }
  if (exp->Kind == kOP1_EXP) {
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
/* line 905 "Expressions.puma" */
   return exp->OP1_EXP.OPND;

  }
  }
/* line 909 "Expressions.puma" */
   return mOP1_EXP (mOP1_SIGN (), exp);

}

tTree InverseExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_DIVIDE) {
/* line 923 "Expressions.puma" */
 {
  tTree he;
  {
/* line 927 "Expressions.puma" */
 he = exp->OP_EXP.OPND1;
     exp->OP_EXP.OPND1 = exp->OP_EXP.OPND2;
     exp->OP_EXP.OPND2 = he;
   
  }
   return exp;
 }

  }
  }
/* line 934 "Expressions.puma" */
   return mOP_EXP (mOP_DIVIDE (), MakeConstant (1), exp);

}

rbool IsStride1
# if defined __STDC__ | defined __cplusplus
(register tTree stride)
# else
(stride)
 register tTree stride;
# endif
{
/* line 946 "Expressions.puma" */
  {
/* line 947 "Expressions.puma" */
   if (! ((stride == NoTree))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (stride->Kind == kDUMMY_EXP) {
/* line 950 "Expressions.puma" */
   return rtrue;

  }
/* line 953 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 955 "Expressions.puma" */
   GetIntConstValue (stride, & yyV1, & yyV2);
/* line 956 "Expressions.puma" */
   if (! ((yyV1))) goto yyL3;
  {
/* line 957 "Expressions.puma" */
   if (! ((yyV2 == 1))) goto yyL3;
  }
  }
   return rtrue;
 }
yyL3:;

  return rfalse;
}

void GetExplicitShapeSize
# if defined __STDC__ | defined __cplusplus
(register tTree shape, register rbool * yyP6, register int * yyP5)
# else
(shape, yyP6, yyP5)
 register tTree shape;
 register rbool * yyP6;
 register int * yyP5;
# endif
{
  if (shape->Kind == kEXPLICIT_SHAPE) {
/* line 973 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  {
/* line 978 "Expressions.puma" */
   GetIntConstValue (shape->EXPLICIT_SHAPE.LOWER, & yyV1, & yyV2);
/* line 979 "Expressions.puma" */
   GetIntConstValue (shape->EXPLICIT_SHAPE.UPPER, & yyV3, & yyV4);
  }
   * yyP6 = yyV1 && yyV3;
   * yyP5 = yyV4 - yyV2 + 1;
   return;
 }

  }
  if (shape->Kind == kSHAPE_LIST) {
/* line 982 "Expressions.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  {
/* line 984 "Expressions.puma" */
   GetExplicitShapeSize (shape->SHAPE_LIST.Elem, & yyV1, & yyV2);
/* line 985 "Expressions.puma" */
   GetExplicitShapeSize (shape->SHAPE_LIST.Next, & yyV3, & yyV4);
  }
   * yyP6 = yyV3 && yyV1;
   * yyP5 = yyV4 * yyV2;
   return;
 }

  }
  if (shape->Kind == kSHAPE_EMPTY) {
/* line 988 "Expressions.puma" */
   * yyP6 = rtrue;
   * yyP5 = 1;
   return;

  }
/* line 991 "Expressions.puma" */
  {
/* line 993 "Expressions.puma" */
   failure_protocol (MODULE, "GetShapeSize", shape);
  }
   * yyP6 = rfalse;
   * yyP5 = 0;
   return;

;
}

void BeginExpressions ARGS ((void))
{
}

void CloseExpressions ARGS ((void))
{
}
