# include "ExpNormal.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 89 "ExpNormal.puma" */


# include "Unparse.h"

# define MODULE "ExpNormal"
# undef DEBUG

/*********************************************************************
*                                                                    * 
*                                                                    * 
*                                                                    *
*********************************************************************/

void PrintNormRecord (routine, s, e, loops, n)
char routine[];
char s[];
ExpNormRecord e;
tTree loops[];
int n;

{  extern tTree MyGetLoopVar ();
   int i;

   printf ("%s: normalized exp %s in %d loops: %d", 
           routine, s, n, e.vals[0]);

   for (i=1; i<=n;i++)
     { printf (" + %d * ", e.vals[i]);
       FileUnparse (stdout, MyGetLoopVar (loops[i-1]));
     }
   printf ("\n");
}



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyExpNormal.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* ExpNormal_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ExpNormal, routine %s failed\n",
  yyFunction);
 ExpNormal_Exit ();
}

void ExpNormal ARGS ((tTree e, ptree loops, int n, rbool * yyP2, ExpNormRecord * yyP1));
static void ForIdBound ARGS ((tTree slice, rbool do_low, ptree loops, int m, rbool * yyP4, ExpNormRecord * yyP3));
static void GetStrideValue ARGS ((tTree stride, rbool * yyP6, int * yyP5));
static void ExpBound ARGS ((ExpNormRecord e, rbool is_low, ptree loops, int n, int ConstLoops, rbool * yyP8, ExpNormRecord * yyP7));
static rbool SetExpBound ARGS ((ExpNormRecord * e, rbool is_low, ptree loops, int n, int c));
static rbool Estimate ARGS ((ExpNormRecord * exp, rbool is_low, int k, ptree loops));
rbool ExpDifferent ARGS ((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int ConstLoops));
static rbool ExpSmaller ARGS ((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int ConstLoops));
void DiffUppBound ARGS ((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, rbool * yyP10, int * yyP9));
void DiffLowBound ARGS ((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, rbool * yyP12, int * yyP11));
static void DiffBound ARGS ((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, rbool do_low, int CommonLoops, int ConstLoops, rbool * yyP14, int * yyP13));
static int my_min ARGS ((int n1, int n2));
static tTree MyGetLoopSlice ARGS ((tTree loop));
static tTree MyGetLoopVar ARGS ((tTree loop));
static rbool IsLoopVar ARGS ((tIdent name, tTree loop));
static void MyGetIntConstValue ARGS ((tTree exp, rbool * yyP16, int * yyP15));
static void ExpNormConstant ARGS ((tTree e, int n, rbool * yyP18, ExpNormRecord * yyP17));
static void FindLoopPos ARGS ((tIdent name, ptree loops, int n, rbool * yyP20, int * yyP19));

void ExpNormal
# if defined __STDC__ | defined __cplusplus
(register tTree e, ptree loops, register int n, register rbool * yyP2, ExpNormRecord * yyP1)
# else
(e, loops, n, yyP2, yyP1)
 register tTree e;
 ptree loops;
 register int n;
 register rbool * yyP2;
 ExpNormRecord * yyP1;
# endif
{
/* line 141 "ExpNormal.puma" */

int i;

/* line 151 "ExpNormal.puma" */
 {
  rbool yyV1;
  ExpNormRecord yyV2;
  {
/* line 153 "ExpNormal.puma" */
   ExpNormConstant (e, n, & yyV1, & yyV2);
/* line 155 "ExpNormal.puma" */
   if (! ((yyV1))) goto yyL1;
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL1:;

  if (e->Kind == kOP_EXP) {
  if (e->OP_EXP.EXP_OP->Kind == kOP_PLUS) {
/* line 162 "ExpNormal.puma" */
 {
  rbool yyV1;
  ExpNormRecord yyV2;
  rbool yyV3;
  ExpNormRecord yyV4;
  {
/* line 164 "ExpNormal.puma" */
   ExpNormal (e->OP_EXP.OPND1, loops, n, & yyV1, & yyV2);
/* line 165 "ExpNormal.puma" */
   ExpNormal (e->OP_EXP.OPND2, loops, n, & yyV3, & yyV4);
/* line 167 "ExpNormal.puma" */
/* line 167 "ExpNormal.puma" */
   i = 0;
   while (i <= n) {
/* line 167 "ExpNormal.puma" */
   yyV2 . vals [i] += yyV4 . vals [i];
/* line 167 "ExpNormal.puma" */
   i ++;
   }
  }
   * yyP2 = yyV1 && yyV3;
   * yyP1 = yyV2;
   return;
 }

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
/* line 174 "ExpNormal.puma" */
 {
  rbool yyV1;
  ExpNormRecord yyV2;
  rbool yyV3;
  ExpNormRecord yyV4;
  {
/* line 176 "ExpNormal.puma" */
   ExpNormal (e->OP_EXP.OPND1, loops, n, & yyV1, & yyV2);
/* line 177 "ExpNormal.puma" */
   ExpNormal (e->OP_EXP.OPND2, loops, n, & yyV3, & yyV4);
/* line 179 "ExpNormal.puma" */
/* line 179 "ExpNormal.puma" */
   i = 0;
   while (i <= n) {
/* line 179 "ExpNormal.puma" */
   yyV2 . vals [i] -= yyV4 . vals [i];
/* line 179 "ExpNormal.puma" */
   i ++;
   }
  }
   * yyP2 = yyV1 && yyV3;
   * yyP1 = yyV2;
   return;
 }

  }
  if (e->OP_EXP.EXP_OP->Kind == kOP_TIMES) {
/* line 186 "ExpNormal.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  ExpNormRecord yyV4;
  {
/* line 188 "ExpNormal.puma" */
   MyGetIntConstValue (e->OP_EXP.OPND1, & yyV1, & yyV2);
/* line 189 "ExpNormal.puma" */
   ExpNormal (e->OP_EXP.OPND2, loops, n, & yyV3, & yyV4);
/* line 191 "ExpNormal.puma" */
   if (! ((yyV1))) goto yyL4;
  {
/* line 195 "ExpNormal.puma" */
/* line 195 "ExpNormal.puma" */
   i = 0;
   while (i <= n) {
/* line 195 "ExpNormal.puma" */
   yyV4 . vals [i] *= yyV2;
/* line 195 "ExpNormal.puma" */
   i ++;
   }
  }
  }
   * yyP2 = yyV1 && yyV3;
   * yyP1 = yyV4;
   return;
 }
yyL4:;

/* line 202 "ExpNormal.puma" */
 {
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  ExpNormRecord yyV4;
  {
/* line 204 "ExpNormal.puma" */
   MyGetIntConstValue (e->OP_EXP.OPND2, & yyV1, & yyV2);
/* line 205 "ExpNormal.puma" */
   ExpNormal (e->OP_EXP.OPND1, loops, n, & yyV3, & yyV4);
/* line 207 "ExpNormal.puma" */
   if (! ((yyV1))) goto yyL5;
  {
/* line 211 "ExpNormal.puma" */
/* line 211 "ExpNormal.puma" */
   i = 0;
   while (i <= n) {
/* line 211 "ExpNormal.puma" */
   yyV4 . vals [i] *= yyV2;
/* line 211 "ExpNormal.puma" */
   i ++;
   }
  }
  }
   * yyP2 = yyV3 && yyV1;
   * yyP1 = yyV4;
   return;
 }
yyL5:;

  }
  }
  if (e->Kind == kOP1_EXP) {
  if (e->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
/* line 218 "ExpNormal.puma" */
 {
  rbool yyV1;
  ExpNormRecord yyV2;
  {
/* line 220 "ExpNormal.puma" */
   ExpNormal (e->OP1_EXP.OPND, loops, n, & yyV1, & yyV2);
/* line 222 "ExpNormal.puma" */
/* line 222 "ExpNormal.puma" */
   i = 0;
   while (i <= n) {
/* line 222 "ExpNormal.puma" */
   yyV2 . vals [i] = - yyV2 . vals [i];
/* line 222 "ExpNormal.puma" */
   i ++;
   }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  }
  if (e->Kind == kVAR_EXP) {
  if (e->VAR_EXP.V->Kind == kLOOP_VAR) {
/* line 225 "ExpNormal.puma" */
 {
  ExpNormRecord val;
  rbool yyV1;
  int yyV2;
  {
/* line 229 "ExpNormal.puma" */
   FindLoopPos (e->VAR_EXP.V->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident, loops, n, & yyV1, & yyV2);
/* line 231 "ExpNormal.puma" */
/* line 231 "ExpNormal.puma" */
   i = 0;
   while (i <= n) {
/* line 231 "ExpNormal.puma" */
   val . vals [i] = 0;
/* line 231 "ExpNormal.puma" */
   i ++;
   }
/* line 233 "ExpNormal.puma" */
   if ((yyV1)) {
/* line 233 "ExpNormal.puma" */
   val . vals [yyV2] = 1;
   }
  }
   * yyP2 = yyV1;
   * yyP1 = val;
   return;
 }

  }
  if (e->VAR_EXP.V->Kind == kUSED_VAR) {
/* line 236 "ExpNormal.puma" */
 {
  ExpNormRecord val;
  rbool yyV1;
  int yyV2;
  {
/* line 240 "ExpNormal.puma" */
   FindLoopPos (e->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident, loops, n, & yyV1, & yyV2);
/* line 242 "ExpNormal.puma" */
/* line 242 "ExpNormal.puma" */
   i = 0;
   while (i <= n) {
/* line 242 "ExpNormal.puma" */
   val . vals [i] = 0;
/* line 242 "ExpNormal.puma" */
   i ++;
   }
/* line 244 "ExpNormal.puma" */
   if ((yyV1)) {
/* line 244 "ExpNormal.puma" */
   val . vals [yyV2] = 1;
   }
  }
   * yyP2 = yyV1;
   * yyP1 = val;
   return;
 }

  }
  }
  if (e->Kind == kSLICE_EXP) {
/* line 255 "ExpNormal.puma" */
 {
  ExpNormRecord val;
  {
/* line 259 "ExpNormal.puma" */
/* line 259 "ExpNormal.puma" */
   i = 0;
   while (i <= n) {
/* line 259 "ExpNormal.puma" */
   val . vals [i] = 0;
/* line 259 "ExpNormal.puma" */
   i ++;
   }
  }
   * yyP2 = rfalse;
   * yyP1 = val;
   return;
 }

  }
/* line 262 "ExpNormal.puma" */
 {
  ExpNormRecord val;
  {
/* line 266 "ExpNormal.puma" */
/* line 266 "ExpNormal.puma" */
   i = 0;
   while (i <= n) {
/* line 266 "ExpNormal.puma" */
   val . vals [i] = 0;
/* line 266 "ExpNormal.puma" */
   i ++;
   }
  }
   * yyP2 = rfalse;
   * yyP1 = val;
   return;
 }

;
}

static void ForIdBound
# if defined __STDC__ | defined __cplusplus
(register tTree slice, register rbool do_low, ptree loops, register int m, register rbool * yyP4, ExpNormRecord * yyP3)
# else
(slice, do_low, loops, m, yyP4, yyP3)
 register tTree slice;
 register rbool do_low;
 ptree loops;
 register int m;
 register rbool * yyP4;
 ExpNormRecord * yyP3;
# endif
{
/* line 288 "ExpNormal.puma" */
 {
  ExpNormRecord r;
  {
/* line 290 "ExpNormal.puma" */
   if (! ((slice == NoTree))) goto yyL1;
  {
/* line 294 "ExpNormal.puma" */

# ifdef DEBUG
     printf ("Bound for parameter does not exist\n");
# endif 
   
  }
  }
   * yyP4 = rfalse;
   * yyP3 = r;
   return;
 }
yyL1:;

  if (slice->Kind == kSLICE_EXP) {
/* line 301 "ExpNormal.puma" */
 {
  tTree bound;
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  ExpNormRecord yyV4;
  {
/* line 307 "ExpNormal.puma" */
   GetStrideValue (slice->SLICE_EXP.INC, & yyV1, & yyV2);
/* line 308 "ExpNormal.puma" */
   if (! ((yyV1))) goto yyL2;
  {
/* line 314 "ExpNormal.puma" */
   if ((do_low)) {
/* line 318 "ExpNormal.puma" */
   if ((yyV2 > 0)) {
/* line 318 "ExpNormal.puma" */
   bound = slice->SLICE_EXP.FIRST;
   } else {
/* line 318 "ExpNormal.puma" */
   bound = slice->SLICE_EXP.STOP;
   }
   } else
/* line 324 "ExpNormal.puma" */
   if ((yyV2 > 0)) {
/* line 324 "ExpNormal.puma" */
   bound = slice->SLICE_EXP.STOP;
   } else {
/* line 324 "ExpNormal.puma" */
   bound = slice->SLICE_EXP.FIRST;
   }
/* line 330 "ExpNormal.puma" */
   ExpNormal (bound, loops, m - 1, & yyV3, & yyV4);
/* line 332 "ExpNormal.puma" */

# ifdef DEBUG
     printf ("ForIdBound (do_low=%d) for loop variable %d found : ", do_low, m);
     FileUnparse (stdout, bound);
     printf (" (inc=%d)\n", yyV2);
     PrintNormRecord ("ForIdBound", "bound", yyV4, loops, m-1);
# endif 
   
  }
  }
   * yyP4 = yyV3;
   * yyP3 = yyV4;
   return;
 }
yyL2:;

  }
/* line 342 "ExpNormal.puma" */
 {
  ExpNormRecord r;
  {
/* line 346 "ExpNormal.puma" */

# ifdef DEBUG
     printf ("Bound for loop variable %d not found\n", m);
# endif 
   
  }
   * yyP4 = rfalse;
   * yyP3 = r;
   return;
 }

;
}

static void GetStrideValue
# if defined __STDC__ | defined __cplusplus
(register tTree stride, register rbool * yyP6, register int * yyP5)
# else
(stride, yyP6, yyP5)
 register tTree stride;
 register rbool * yyP6;
 register int * yyP5;
# endif
{
/* line 361 "ExpNormal.puma" */
  {
/* line 362 "ExpNormal.puma" */
   if (! ((IsStride1 (stride)))) goto yyL1;
  }
   * yyP6 = rtrue;
   * yyP5 = 1;
   return;
yyL1:;

/* line 365 "ExpNormal.puma" */
 {
  rbool found;
  int val;
  {
/* line 370 "ExpNormal.puma" */
   GetIntConstValue (stride, & found, & val);
  }
   * yyP6 = found;
   * yyP5 = val;
   return;
 }

;
}

static void ExpBound
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e, register rbool is_low, ptree loops, register int n, register int ConstLoops, register rbool * yyP8, ExpNormRecord * yyP7)
# else
(e, is_low, loops, n, ConstLoops, yyP8, yyP7)
 ExpNormRecord e;
 register rbool is_low;
 ptree loops;
 register int n;
 register int ConstLoops;
 register rbool * yyP8;
 ExpNormRecord * yyP7;
# endif
{
/* line 403 "ExpNormal.puma" */
 {
  rbool found;
  ExpNormRecord bound;
  int k;
  {
/* line 410 "ExpNormal.puma" */
   found = rtrue;
/* line 411 "ExpNormal.puma" */
   bound = e;
/* line 413 "ExpNormal.puma" */

# ifdef DEBUG
     printf ("ExpBound (do_low=%d), ConstLoops = %d\n", 
              is_low, ConstLoops);
     PrintNormRecord ("ExpBound", "e", e, loops, n);
# endif
   
/* line 421 "ExpNormal.puma" */
/* line 421 "ExpNormal.puma" */
   k = n;
   while (found && (k > ConstLoops)) {
/* line 423 "ExpNormal.puma" */
   found = Estimate (& bound, is_low, k, loops);
/* line 425 "ExpNormal.puma" */

# ifdef DEBUG
      printf ("ExpBound (do_low=%d), estimate for k=%d gave found = %d\n",
              is_low, k, found);
      if (found)
         PrintNormRecord ("ExpBound (estimated)", "bound", bound, loops, k-1);
# endif
   
/* line 421 "ExpNormal.puma" */
   k --;
   }
/* line 436 "ExpNormal.puma" */

# ifdef DEBUG
     if (found)
        { printf ("ExpBound (do_low=%d) found\n", is_low);
          PrintNormRecord ("ExpBound", "bound", bound, loops, ConstLoops);
        }
      else
         printf ("ExpBound (do_low=%d) not found", is_low);
# endif 
   
  }
   * yyP8 = found;
   * yyP7 = bound;
   return;
 }

;
}

static rbool SetExpBound
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord * e, register rbool is_low, ptree loops, register int n, register int c)
# else
(e, is_low, loops, n, c)
 ExpNormRecord * e;
 register rbool is_low;
 ptree loops;
 register int n;
 register int c;
# endif
{
/* line 460 "ExpNormal.puma" */
 {
  rbool yyV1;
  ExpNormRecord yyV2;
  int i;
  {
/* line 462 "ExpNormal.puma" */
   ExpBound ((* e), is_low, loops, n, c, & yyV1, & yyV2);
/* line 464 "ExpNormal.puma" */
   if (! ((yyV1))) goto yyL1;
  {
/* line 468 "ExpNormal.puma" */
/* line 468 "ExpNormal.puma" */
   i = 0;
   while (i <= c) {
/* line 468 "ExpNormal.puma" */
   (* e) . vals [i] = yyV2 . vals [i];
/* line 468 "ExpNormal.puma" */
   i ++;
   }
  }
  }
   return rtrue;
 }
yyL1:;

/* line 473 "ExpNormal.puma" */
   return rfalse;

}

static rbool Estimate
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord * exp, register rbool is_low, register int k, ptree loops)
# else
(exp, is_low, k, loops)
 ExpNormRecord * exp;
 register rbool is_low;
 register int k;
 ptree loops;
# endif
{
/* line 494 "ExpNormal.puma" */
  {
/* line 496 "ExpNormal.puma" */
   if (! (((* exp) . vals [k] == 0))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 501 "ExpNormal.puma" */
 {
  int a;
  int i;
  rbool do_low;
  rbool yyV1;
  ExpNormRecord yyV2;
  {
/* line 506 "ExpNormal.puma" */
   a = (* exp) . vals [k];
/* line 510 "ExpNormal.puma" */
   do_low = is_low;
/* line 514 "ExpNormal.puma" */
   if ((a < 0)) {
/* line 514 "ExpNormal.puma" */
   do_low = (! do_low);
   }
/* line 516 "ExpNormal.puma" */
   ForIdBound (MyGetLoopSlice (loops [k - 1]), do_low, loops, k, & yyV1, & yyV2);
/* line 518 "ExpNormal.puma" */
   if (! ((yyV1))) goto yyL2;
  {
/* line 520 "ExpNormal.puma" */
/* line 520 "ExpNormal.puma" */
   i = 0;
   while (i <= k - 1) {
/* line 520 "ExpNormal.puma" */
   (* exp) . vals [i] += a * yyV2 . vals [i];
/* line 520 "ExpNormal.puma" */
   i ++;
   }
/* line 522 "ExpNormal.puma" */

# ifdef DEBUG
     printf ("Estimate: got new bound (exp[k=%d] = %d), do_low = %d\n",
              k, a, do_low);
     PrintNormRecord ("Estimate", "exp", (* exp), loops, k-1);
# endif
   
  }
  }
   return rtrue;
 }
yyL2:;

/* line 533 "ExpNormal.puma" */
   return rfalse;

}

rbool ExpDifferent
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register int ConstLoops)
# else
(e1, loops1, n1, e2, loops2, n2, ConstLoops)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register int ConstLoops;
# endif
{
/* line 555 "ExpNormal.puma" */

int i;

/* line 559 "ExpNormal.puma" */
  {
/* line 561 "ExpNormal.puma" */

#ifdef DEBUG
     printf ("ExpDifferent: is different for %d const loops ?\n", ConstLoops);
     PrintNormRecord ("ExpDifferent", "e1", e1, loops1, n1);
     PrintNormRecord ("ExpDifferent", "e2", e2, loops2, n2);
#endif
   
/* line 569 "ExpNormal.puma" */
   if (! ((ExpSmaller (e1, loops1, n1, e2, loops2, n2, ConstLoops)))) goto yyL1;
  {
/* line 571 "ExpNormal.puma" */

#ifdef DEBUG
     printf ("ExpDifferent: proved e1 < e2\n");
#endif
   
  }
  }
   return rtrue;
yyL1:;

/* line 578 "ExpNormal.puma" */
  {
/* line 580 "ExpNormal.puma" */
   if (! ((ExpSmaller (e2, loops2, n2, e1, loops1, n1, ConstLoops)))) goto yyL2;
  {
/* line 582 "ExpNormal.puma" */

#ifdef DEBUG
     printf ("ExpDifferent: proved e2 < e1\n");
#endif
   
  }
  }
   return rtrue;
yyL2:;

  return rfalse;
}

static rbool ExpSmaller
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register int ConstLoops)
# else
(e1, loops1, n1, e2, loops2, n2, ConstLoops)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register int ConstLoops;
# endif
{
/* line 601 "ExpNormal.puma" */

int i;

/* line 605 "ExpNormal.puma" */
 {
  rbool yyV1;
  ExpNormRecord yyV2;
  rbool yyV3;
  ExpNormRecord yyV4;
  rbool yyV5;
  ExpNormRecord yyV6;
  {
/* line 609 "ExpNormal.puma" */
   ExpBound (e1, rfalse, loops1, n1, ConstLoops, & yyV1, & yyV2);
/* line 610 "ExpNormal.puma" */
   if (! ((yyV1))) goto yyL1;
  {
/* line 612 "ExpNormal.puma" */

#ifdef DEBUG
     printf ("ExpSmaller: upper bound for e1 found\n");
     PrintNormRecord ("ExpSmaller", "e1", e1, loops1, n1);
     PrintNormRecord ("ExpSmaller", "up", yyV2, loops1, ConstLoops);
#endif
   
/* line 622 "ExpNormal.puma" */
   ExpBound (e2, rtrue, loops2, n2, ConstLoops, & yyV3, & yyV4);
/* line 623 "ExpNormal.puma" */
   if (! ((yyV3))) goto yyL1;
  {
/* line 625 "ExpNormal.puma" */

#ifdef DEBUG
     printf ("ExpSmaller: lower bound for e2 found\n");
     PrintNormRecord ("ExpSmaller", "e2", e2, loops1, n2);
     PrintNormRecord ("ExpSmaller", "low", yyV2, loops1, ConstLoops);
#endif
   
/* line 637 "ExpNormal.puma" */
/* line 637 "ExpNormal.puma" */
   i = 0;
   while (i <= ConstLoops) {
/* line 637 "ExpNormal.puma" */
   yyV4 . vals [i] -= yyV2 . vals [i];
/* line 637 "ExpNormal.puma" */
   i ++;
   }
/* line 646 "ExpNormal.puma" */
   ExpBound (yyV4, rtrue, loops1, ConstLoops, 0, & yyV5, & yyV6);
/* line 648 "ExpNormal.puma" */
   if (! ((yyV5))) goto yyL1;
  {
/* line 650 "ExpNormal.puma" */

#ifdef DEBUG
     printf ("ExpSmaller: lower bound for low-up found\n");
     PrintNormRecord ("ExpSmaller", "low-up", yyV4, loops1, ConstLoops);
     PrintNormRecord ("ExpSmaller", "d", yyV6, loops1, 0);
#endif
   
/* line 658 "ExpNormal.puma" */
   if (! ( yyV6.vals[0]  > 0)) goto yyL1;
  }
  }
  }
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

void DiffUppBound
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, register rbool * yyP10, register int * yyP9)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, yyP10, yyP9)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 register rbool * yyP10;
 register int * yyP9;
# endif
{
/* line 689 "ExpNormal.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 693 "ExpNormal.puma" */
   DiffBound (e1, loops1, n1, e2, loops2, n2, rfalse, CommonLoops, ConstLoops, & yyV1, & yyV2);
  }
   * yyP10 = yyV1;
   * yyP9 = yyV2;
   return;
 }

;
}

void DiffLowBound
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, register rbool * yyP12, register int * yyP11)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, yyP12, yyP11)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 register rbool * yyP12;
 register int * yyP11;
# endif
{
/* line 703 "ExpNormal.puma" */
 {
  rbool yyV1;
  int yyV2;
  {
/* line 707 "ExpNormal.puma" */
   DiffBound (e1, loops1, n1, e2, loops2, n2, rtrue, CommonLoops, ConstLoops, & yyV1, & yyV2);
  }
   * yyP12 = yyV1;
   * yyP11 = yyV2;
   return;
 }

;
}

static void DiffBound
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register rbool do_low, register int CommonLoops, register int ConstLoops, register rbool * yyP14, register int * yyP13)
# else
(e1, loops1, n1, e2, loops2, n2, do_low, CommonLoops, ConstLoops, yyP14, yyP13)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register rbool do_low;
 register int CommonLoops;
 register int ConstLoops;
 register rbool * yyP14;
 register int * yyP13;
# endif
{
/* line 731 "ExpNormal.puma" */

int i;

/* line 735 "ExpNormal.puma" */
 {
  rbool valid;
  int val;
  int m;
  ExpNormRecord H1;
  ExpNormRecord H2;
  {
/* line 744 "ExpNormal.puma" */

#ifdef DEBUG
     printf ("DiffBound: called (do_low = %d), Common = %d, Const = %d\n",
              do_low, CommonLoops, ConstLoops);
     PrintNormRecord ("DiffBound", "e1", e1, loops1, n1);
     PrintNormRecord ("DiffBound", "e2", e2, loops2, n1);
#endif
   
/* line 755 "ExpNormal.puma" */
/* line 755 "ExpNormal.puma" */
   i = 0;
   while (i <= n1) {
/* line 755 "ExpNormal.puma" */
   H1 . vals [i] = - e1 . vals [i];
/* line 755 "ExpNormal.puma" */
   i ++;
   }
/* line 757 "ExpNormal.puma" */
   H2 = e2;
/* line 759 "ExpNormal.puma" */
   m = my_min (n1, n2);
/* line 761 "ExpNormal.puma" */
   valid = rtrue;
/* line 763 "ExpNormal.puma" */
   if ((n1 > m)) {
/* line 765 "ExpNormal.puma" */
   valid = SetExpBound (& H1, do_low, loops1, n1, m);
   }
/* line 769 "ExpNormal.puma" */
   if ((n2 > m)) {
/* line 771 "ExpNormal.puma" */
   valid = SetExpBound (& H2, do_low, loops2, n2, m);
   }
/* line 775 "ExpNormal.puma" */
   if (! ((valid))) goto yyL1;
  {
/* line 779 "ExpNormal.puma" */
/* line 779 "ExpNormal.puma" */
   i = CommonLoops + 1;
   while (i <= m) {
/* line 781 "ExpNormal.puma" */
   valid = (valid && (H1 . vals [i] + H2 . vals [i] == 0));
/* line 779 "ExpNormal.puma" */
   i ++;
   }
/* line 785 "ExpNormal.puma" */
   if (! ((valid))) goto yyL1;
  {
/* line 789 "ExpNormal.puma" */
/* line 789 "ExpNormal.puma" */
   i = 0;
   while (i <= CommonLoops) {
/* line 789 "ExpNormal.puma" */
   H1 . vals [i] += H2 . vals [i];
/* line 789 "ExpNormal.puma" */
   i ++;
   }
/* line 791 "ExpNormal.puma" */
   valid = SetExpBound (& H1, do_low, loops1, CommonLoops, 0);
/* line 793 "ExpNormal.puma" */
   if (! ((valid))) goto yyL1;
  {
/* line 797 "ExpNormal.puma" */
   val = H1 . vals [0];
  }
  }
  }
  }
   * yyP14 = rtrue;
   * yyP13 = val;
   return;
 }
yyL1:;

/* line 800 "ExpNormal.puma" */
   * yyP14 = rfalse;
   * yyP13 = 0;
   return;

;
}

static int my_min
# if defined __STDC__ | defined __cplusplus
(register int n1, register int n2)
# else
(n1, n2)
 register int n1;
 register int n2;
# endif
{
/* line 811 "ExpNormal.puma" */
  {
/* line 812 "ExpNormal.puma" */
   if (! ((n1 > n2))) goto yyL1;
  }
   return n2;
yyL1:;

/* line 816 "ExpNormal.puma" */
   return n1;

}

static tTree MyGetLoopSlice
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
/* line 828 "ExpNormal.puma" */
  {
/* line 830 "ExpNormal.puma" */
   if (! ((IsCountLoop (loop)))) goto yyL1;
  }
   return GetLoopSlice (loop);
yyL1:;

/* line 835 "ExpNormal.puma" */
   return NoTree;

}

static tTree MyGetLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
/* line 848 "ExpNormal.puma" */
  {
/* line 850 "ExpNormal.puma" */
   if (! ((IsCountLoop (loop)))) goto yyL1;
  }
   return GetLoopId (loop);
yyL1:;

/* line 855 "ExpNormal.puma" */
   return loop;

}

static rbool IsLoopVar
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree loop)
# else
(name, loop)
 register tIdent name;
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
/* line 870 "ExpNormal.puma" */
  {
/* line 872 "ExpNormal.puma" */
   if (! ((IsLoopVar (name, loop->ACF_DO.DO_ID)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (loop->Kind == kACF_FORALL) {
/* line 875 "ExpNormal.puma" */
  {
/* line 877 "ExpNormal.puma" */
   if (! ((IsLoopVar (name, loop->ACF_FORALL.FORALL_ID)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (loop->Kind == kUSED_VAR) {
/* line 880 "ExpNormal.puma" */
  {
/* line 882 "ExpNormal.puma" */
   if (! ((name == loop->USED_VAR.VARNAME->VAR_OBJ.Ident))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  if (loop->Kind == kLOOP_VAR) {
/* line 885 "ExpNormal.puma" */
  {
/* line 887 "ExpNormal.puma" */
   if (! ((name == loop->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Ident))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  return rfalse;
}

static void MyGetIntConstValue
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register rbool * yyP16, register int * yyP15)
# else
(exp, yyP16, yyP15)
 register tTree exp;
 register rbool * yyP16;
 register int * yyP15;
# endif
{
/* line 898 "ExpNormal.puma" */
 {
  rbool found;
  int val;
  {
/* line 903 "ExpNormal.puma" */
   GetIntConstValue (exp, & found, & val);
  }
   * yyP16 = found;
   * yyP15 = val;
   return;
 }

;
}

static void ExpNormConstant
# if defined __STDC__ | defined __cplusplus
(register tTree e, register int n, register rbool * yyP18, ExpNormRecord * yyP17)
# else
(e, n, yyP18, yyP17)
 register tTree e;
 register int n;
 register rbool * yyP18;
 ExpNormRecord * yyP17;
# endif
{
/* line 914 "ExpNormal.puma" */
 {
  ExpNormRecord val;
  int i;
  rbool yyV1;
  int yyV2;
  {
/* line 919 "ExpNormal.puma" */
   MyGetIntConstValue (e, & yyV1, & yyV2);
/* line 921 "ExpNormal.puma" */
/* line 921 "ExpNormal.puma" */
   i = 1;
   while (i <= n) {
/* line 921 "ExpNormal.puma" */
   val . vals [i] = 0;
/* line 921 "ExpNormal.puma" */
   i ++;
   }
/* line 923 "ExpNormal.puma" */
   val . vals [0] = yyV2;
  }
   * yyP18 = yyV1;
   * yyP17 = val;
   return;
 }

;
}

static void FindLoopPos
# if defined __STDC__ | defined __cplusplus
(register tIdent name, ptree loops, register int n, register rbool * yyP20, register int * yyP19)
# else
(name, loops, n, yyP20, yyP19)
 register tIdent name;
 ptree loops;
 register int n;
 register rbool * yyP20;
 register int * yyP19;
# endif
{
/* line 938 "ExpNormal.puma" */
 {
  rbool found;
  int pos;
  int i;
  {
/* line 944 "ExpNormal.puma" */
   found = rfalse;
/* line 945 "ExpNormal.puma" */
   pos = 0;
/* line 947 "ExpNormal.puma" */
/* line 947 "ExpNormal.puma" */
   i = 1;
   while (i <= n) {
/* line 948 "ExpNormal.puma" */
   if ((IsLoopVar (name, loops [i - 1]))) {
/* line 948 "ExpNormal.puma" */
   pos = i;
/* line 948 "ExpNormal.puma" */
   found = rtrue;
   }
/* line 947 "ExpNormal.puma" */
   i ++;
   }
  }
   * yyP20 = found;
   * yyP19 = pos;
   return;
 }

;
}

void BeginExpNormal ARGS ((void))
{
}

void CloseExpNormal ARGS ((void))
{
}
