# include "ExpDescriptor.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 39 "ExpDescriptor.puma" */


# undef DEBUG

# include <stdio.h>
# include "protocol.h"
# include "Idents.h"
# include "StringM.h"

# include "TreeOps.h"           /* TreeListGet, ... */
# include "Objects.h"           /* GetFuncVarObj    */
# include "Accepted.h"

# include "Distributions.h"     /* DimListLength, ... */
# include "Types.h"             /* GetExpType, ... */
# include "Expressions.h"       /* GetExpType, ... */
# include "Rank.h"
# include "Intrinsics.h"
# include "Reductions.h"

# include "UserFunctions.h"     /* ActualizeExpression */

# include "Nesting.h"           /* GetLoopId, ...      */
# include "Descriptor.h"        /* advanced operations for descriptors */
# include "HomeDescriptor.h"

# define MODULE "ExpDescriptor"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyExpDescriptor.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* ExpDescriptor_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ExpDescriptor, routine %s failed\n",
  yyFunction);
 ExpDescriptor_Exit ();
}

void GetVarDescriptor ARGS ((tTree var, rbool * yyP2, var_descriptor * yyP1));
static void IndexDescriptor ARGS ((tTree indexes, rbool * yyP4, var_descriptor * yyP3));
void SetExpType ARGS ((tTree exp, pvar vard));
void GetExpDescriptor ARGS ((tTree exp, rbool * yyP6, var_descriptor * yyP5));
static void GetIntrFuncDescriptor ARGS ((tTree f, tTree params, rbool * yyP8, var_descriptor * yyP7));
void GetParamDescriptor ARGS ((tTree param, rbool * yyP10, var_descriptor * yyP9));
static void GetParamListDescriptor ARGS ((tTree paramlist, rbool * yyP12, var_descriptor * yyP11));
static void GetMatMulDescriptor ARGS ((tTree array_a, tTree array_b, rbool * yyP14, var_descriptor * yyP13));
static void GetDimValue ARGS ((tTree params, int * yyP15));
static void SetAssumedShape ARGS ((pvar vard, tTree actual, rbool * yyP16));
void GetDummyVarDescriptor ARGS ((tTree actual, tDefinitions dummy, tTree call, rbool * yyP18, var_descriptor * yyP17));
static void GetUserFuncDescriptor ARGS ((tTree f, rbool * yyP20, var_descriptor * yyP19));
static void GetStmtFuncDescriptor ARGS ((tTree p, rbool * yyP22, var_descriptor * yyP21));
static rbool IsEnumExp ARGS ((tTree exp));
static void GetReshapeDescriptor ARGS ((tTree shape, tTree order, rbool * yyP24, var_descriptor * yyP23));

void GetVarDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, register rbool * yyP2, var_descriptor * yyP1)
# else
(var, yyP2, yyP1)
 register tTree var;
 register rbool * yyP2;
 var_descriptor * yyP1;
# endif
{
/* line 82 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 86 "ExpDescriptor.puma" */
   if (! ((IsDescriptorVar (var)))) goto yyL1;
  {
/* line 87 "ExpDescriptor.puma" */
   SetVarDescriptor (var, & vard);
  }
  }
   * yyP2 = rtrue;
   * yyP1 = vard;
   return;
 }
yyL1:;

  if (var->Kind == kINDEXED_VAR) {
/* line 90 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 92 "ExpDescriptor.puma" */
   IndexDescriptor (var->INDEXED_VAR.IND_EXPS, & yyV1, & yyV2);
/* line 93 "ExpDescriptor.puma" */
   if (! ((yyV1))) goto yyL2;
  {
/* line 94 "ExpDescriptor.puma" */
   SetExpType (var, & yyV2);
/* line 96 "ExpDescriptor.puma" */

#ifdef DEBUG
   printf ("got var descriptor via the indexes for ");
   FileUnparse (stdout, var); printf ("\n");
   PrintVarDescriptor (&yyV2);
#endif 
   
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL2:;

  }
/* line 105 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
  }
   * yyP2 = rfalse;
   * yyP1 = vard;
   return;
 }

;
}

static void IndexDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register rbool * yyP4, var_descriptor * yyP3)
# else
(indexes, yyP4, yyP3)
 register tTree indexes;
 register rbool * yyP4;
 var_descriptor * yyP3;
# endif
{
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 120 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 122 "ExpDescriptor.puma" */
   GetExpDescriptor (indexes->BTE_LIST.Elem, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  }
/* line 125 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  rbool yyV3;
  var_descriptor yyV4;
  {
/* line 127 "ExpDescriptor.puma" */
   GetExpDescriptor (indexes->BTE_LIST.Elem, & yyV1, & yyV2);
/* line 128 "ExpDescriptor.puma" */
   if (! ((yyV1))) goto yyL2;
  {
/* line 130 "ExpDescriptor.puma" */
   IndexDescriptor (indexes->BTE_LIST.Next, & yyV3, & yyV4);
/* line 131 "ExpDescriptor.puma" */
   if (! ((yyV3))) goto yyL2;
  {
/* line 133 "ExpDescriptor.puma" */
   ProductDescriptors (& yyV2, & yyV4);
  }
  }
  }
   * yyP4 = rtrue;
   * yyP3 = yyV2;
   return;
 }
yyL2:;

  }
/* line 136 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
  }
   * yyP4 = rfalse;
   * yyP3 = vard;
   return;
 }

;
}

void SetExpType
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard)
# else
(exp, vard)
 register tTree exp;
 pvar vard;
# endif
{
/* line 152 "ExpDescriptor.puma" */
 {
  type_rec t;
  {
/* line 156 "ExpDescriptor.puma" */
 GetExpType (exp, &t);
    vard->type_kind = t.type_kind;
    vard->type_size = t.type_size;
  
  }
   return;
 }

;
}

void GetExpDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register rbool * yyP6, var_descriptor * yyP5)
# else
(exp, yyP6, yyP5)
 register tTree exp;
 register rbool * yyP6;
 var_descriptor * yyP5;
# endif
{
  if (exp->Kind == kVAR_EXP) {
  if (exp->VAR_EXP.V->Kind == kLOOP_VAR) {
/* line 177 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 181 "ExpDescriptor.puma" */
   MakeLoopVarDescriptor (exp, & vard);
  }
   * yyP6 = rtrue;
   * yyP5 = vard;
   return;
 }

  }
/* line 184 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 186 "ExpDescriptor.puma" */
   GetVarDescriptor (exp->VAR_EXP.V, & yyV1, & yyV2);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }

  }
  if (exp->Kind == kSLICE_EXP) {
/* line 189 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 193 "ExpDescriptor.puma" */
   MakeSliceDescriptor (exp, & vard);
  }
   * yyP6 = rtrue;
   * yyP5 = vard;
   return;
 }

  }
  if (exp->Kind == kOP1_EXP) {
/* line 196 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 198 "ExpDescriptor.puma" */
   GetExpDescriptor (exp->OP1_EXP.OPND, & yyV1, & yyV2);
/* line 199 "ExpDescriptor.puma" */
   SetExpType (exp, & yyV2);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }

  }
  if (exp->Kind == kOP_EXP) {
/* line 202 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  rbool yyV3;
  var_descriptor yyV4;
  {
/* line 204 "ExpDescriptor.puma" */
   GetExpDescriptor (exp->OP_EXP.OPND1, & yyV1, & yyV2);
/* line 205 "ExpDescriptor.puma" */
   GetExpDescriptor (exp->OP_EXP.OPND2, & yyV3, & yyV4);
/* line 207 "ExpDescriptor.puma" */
 if (yyV1 && yyV3)
       CombineDescriptors (&yyV2, &yyV4);
   
/* line 211 "ExpDescriptor.puma" */
   SetExpType (exp, & yyV2);
  }
   * yyP6 = (yyV1 && yyV3);
   * yyP5 = yyV2;
   return;
 }

  }
/* line 214 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 216 "ExpDescriptor.puma" */
   if (! ((TreeRank (exp) == 0))) goto yyL6;
  {
/* line 222 "ExpDescriptor.puma" */
   MakeReplicatedDescriptor (& vard);
/* line 224 "ExpDescriptor.puma" */
   SetExpType (exp, & vard);
  }
  }
   * yyP6 = rtrue;
   * yyP5 = vard;
   return;
 }
yyL6:;

  if (exp->Kind == kFUNC_CALL_EXP) {
/* line 227 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 229 "ExpDescriptor.puma" */
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL7;
  {
/* line 231 "ExpDescriptor.puma" */
   GetIntrFuncDescriptor (exp->FUNC_CALL_EXP.FUNC_ID, exp->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2);
/* line 235 "ExpDescriptor.puma" */
   SetExpType (exp, & yyV2);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL7:;

/* line 238 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 244 "ExpDescriptor.puma" */
   if (! ((IsPureCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL8;
  }
   * yyP6 = rfalse;
   * yyP5 = vard;
   return;
 }
yyL8:;

/* line 247 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 249 "ExpDescriptor.puma" */
   if (! ((IsUserCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL9;
  {
/* line 251 "ExpDescriptor.puma" */
   GetUserFuncDescriptor (exp, & yyV1, & yyV2);
/* line 253 "ExpDescriptor.puma" */
 if (IsSerialCall (exp->FUNC_CALL_EXP.FUNC_ID))
        yyV2.topology_rank = -1;
   
/* line 257 "ExpDescriptor.puma" */
   SetExpType (exp, & yyV2);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL9:;

/* line 260 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 262 "ExpDescriptor.puma" */
   if (! ((IsStmtCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL10;
  {
/* line 264 "ExpDescriptor.puma" */
   GetStmtFuncDescriptor (exp->FUNC_CALL_EXP.FUNC_ID, & yyV1, & yyV2);
/* line 266 "ExpDescriptor.puma" */
   SetExpType (exp, & yyV2);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL10:;

  }
  if (exp->Kind == kARRAY_EXP) {
/* line 269 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 271 "ExpDescriptor.puma" */
   if (! ((IsEnumExp (exp->ARRAY_EXP.ELEMENTS)))) goto yyL11;
  {
/* line 273 "ExpDescriptor.puma" */
   GetExpDescriptor (mSLICE_EXP (MakeConstant (1), MakeConstant (TreeListLength (exp->ARRAY_EXP.ELEMENTS)), mDUMMY_EXP ()), & yyV1, & yyV2);
/* line 278 "ExpDescriptor.puma" */
   SetExpType (exp, & yyV2);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL11:;

  if (exp->ARRAY_EXP.ELEMENTS->Kind == kBTE_LIST) {
  if (exp->ARRAY_EXP.ELEMENTS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 281 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 283 "ExpDescriptor.puma" */
   GetExpDescriptor (exp->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem, & yyV1, & yyV2);
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }

  }
  }
  }
  if (exp->Kind == kDO_EXP) {
  if (exp->DO_EXP.BODY->Kind == kBTE_LIST) {
  if (exp->DO_EXP.BODY->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 286 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 288 "ExpDescriptor.puma" */
   if (! ((TreeRank (exp->DO_EXP.BODY->BTE_LIST.Elem) == 0))) goto yyL13;
  {
/* line 289 "ExpDescriptor.puma" */
   GetExpDescriptor (exp->DO_EXP.RANGE, & yyV1, & yyV2);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL13:;

/* line 292 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
  }
   * yyP6 = rfalse;
   * yyP5 = vard;
   return;
 }

  }
  }
  }
/* line 297 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
  }
   * yyP6 = rfalse;
   * yyP5 = vard;
   return;
 }

;
}

static void GetIntrFuncDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree f, register tTree params, register rbool * yyP8, var_descriptor * yyP7)
# else
(f, params, yyP8, yyP7)
 register tTree f;
 register tTree params;
 register rbool * yyP8;
 var_descriptor * yyP7;
# endif
{
  if (f->Kind == kPROC_OBJ) {
/* line 317 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 319 "ExpDescriptor.puma" */
   if (! ((IntrFuncElemental (f->PROC_OBJ.Ident)))) goto yyL1;
  {
/* line 320 "ExpDescriptor.puma" */
   GetParamListDescriptor (params, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL1:;

  if (params->Kind == kBTP_LIST) {
/* line 323 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 327 "ExpDescriptor.puma" */
   if (! (((f->PROC_OBJ.Ident == IsIdent ("SHAPE")) || (f->PROC_OBJ.Ident == IsIdent ("LOCAL_BLKCNT"))))) goto yyL2;
  {
/* line 330 "ExpDescriptor.puma" */
   MakeShapeDescriptor (MakeConstant (TreeRank (params->BTP_LIST.Elem)), & vard);
  }
  }
   * yyP8 = rtrue;
   * yyP7 = vard;
   return;
 }
yyL2:;

  }
/* line 333 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 337 "ExpDescriptor.puma" */
   if (! ((f->PROC_OBJ.Ident == IsIdent ("PROCESSORS_SHAPE")))) goto yyL3;
  {
/* line 339 "ExpDescriptor.puma" */
   MakeShapeDescriptor (mRANK_EXP (0), & vard);
  }
  }
   * yyP8 = rtrue;
   * yyP7 = vard;
   return;
 }
yyL3:;

/* line 342 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 346 "ExpDescriptor.puma" */
   if (! ((f->PROC_OBJ.Ident == IsIdent ("ACTIVE_PROCS_SHAPE")))) goto yyL4;
  {
/* line 348 "ExpDescriptor.puma" */
   MakeShapeDescriptor (mRANK_EXP (1), & vard);
  }
  }
   * yyP8 = rtrue;
   * yyP7 = vard;
   return;
 }
yyL4:;

  if (params->Kind == kBTP_LIST) {
/* line 351 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 353 "ExpDescriptor.puma" */
   if (! ((f->PROC_OBJ.Ident == IsIdent ("CSHIFT")))) goto yyL5;
  {
/* line 355 "ExpDescriptor.puma" */
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL5:;

/* line 358 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 360 "ExpDescriptor.puma" */
   if (! ((f->PROC_OBJ.Ident == IsIdent ("TRANSPOSE")))) goto yyL6;
  {
/* line 362 "ExpDescriptor.puma" */
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
/* line 364 "ExpDescriptor.puma" */
 if (yyV1) TransposeDescriptor (&yyV2); 
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL6:;

/* line 367 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 369 "ExpDescriptor.puma" */
   if (! ((f->PROC_OBJ.Ident == IsIdent ("EOSHIFT")))) goto yyL7;
  {
/* line 371 "ExpDescriptor.puma" */
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL7:;

  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 374 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 377 "ExpDescriptor.puma" */
   if (! ((f->PROC_OBJ.Ident == IsIdent ("MATMUL")))) goto yyL8;
  {
/* line 379 "ExpDescriptor.puma" */
   GetMatMulDescriptor (params->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL8:;

  }
/* line 382 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 384 "ExpDescriptor.puma" */
   if (! (((f->PROC_OBJ.Ident == IsIdent ("MINLOC", 6)) || (f->PROC_OBJ.Ident == IsIdent ("MAXLOC", 6))))) goto yyL9;
  {
/* line 389 "ExpDescriptor.puma" */
   MakeRepArray1Descriptor (& vard, TreeRank (params->BTP_LIST.Elem));
  }
  }
   * yyP8 = rtrue;
   * yyP7 = vard;
   return;
 }
yyL9:;

/* line 392 "ExpDescriptor.puma" */
 {
  int dimval;
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 394 "ExpDescriptor.puma" */
   if (! ((IntrFuncRed (f->PROC_OBJ.Ident)))) goto yyL10;
  {
/* line 398 "ExpDescriptor.puma" */
   dimval = GetReductionDim (params);
/* line 399 "ExpDescriptor.puma" */
   if (! ((dimval > 0))) goto yyL10;
  {
/* line 401 "ExpDescriptor.puma" */
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
/* line 402 "ExpDescriptor.puma" */
   if (! ((yyV1))) goto yyL10;
  {
/* line 404 "ExpDescriptor.puma" */
   RedVarDescriptor (& yyV2, dimval);
  }
  }
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL10:;

  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 407 "ExpDescriptor.puma" */
 {
  int dimval;
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 410 "ExpDescriptor.puma" */
   if (! ((f->PROC_OBJ.Ident == IsIdent ("SPREAD")))) goto yyL11;
  {
/* line 414 "ExpDescriptor.puma" */
   dimval = GetReductionDim (params);
/* line 415 "ExpDescriptor.puma" */
   if (! ((dimval > 0))) goto yyL11;
  {
/* line 417 "ExpDescriptor.puma" */
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
/* line 418 "ExpDescriptor.puma" */
   if (! ((yyV1))) goto yyL11;
  {
/* line 420 "ExpDescriptor.puma" */
   SpreadVarDescriptor (& yyV2, dimval, params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
  }
  }
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL11:;

  }
  }
/* line 423 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 425 "ExpDescriptor.puma" */
   if (! (((f->PROC_OBJ.Ident == IsIdent ("GRADE_UP")) || (f->PROC_OBJ.Ident == IsIdent ("GRADE_DOWN"))))) goto yyL12;
  {
/* line 428 "ExpDescriptor.puma" */
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL12:;

/* line 431 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 433 "ExpDescriptor.puma" */
   if (! (((f->PROC_OBJ.Ident == IsIdent ("SORT_UP")) || (f->PROC_OBJ.Ident == IsIdent ("SORT_DOWN"))))) goto yyL13;
  {
/* line 436 "ExpDescriptor.puma" */
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL13:;

  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 439 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 442 "ExpDescriptor.puma" */
   if (! ((f->PROC_OBJ.Ident == IsIdent ("RESHAPE")))) goto yyL14;
  {
/* line 444 "ExpDescriptor.puma" */
   GetReshapeDescriptor (params->BTP_LIST.Next->BTP_LIST.Elem, params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL14:;

  }
  }
/* line 447 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 449 "ExpDescriptor.puma" */
   if (! ((IntrFuncScatter (f->PROC_OBJ.Ident)))) goto yyL15;
  {
/* line 453 "ExpDescriptor.puma" */
   GetParamDescriptor (params->BTP_LIST.Next->BTP_LIST.Elem, & yyV1, & yyV2);
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL15:;

  }
/* line 456 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 458 "ExpDescriptor.puma" */
   if (! ((IntrFuncScan (f->PROC_OBJ.Ident)))) goto yyL16;
  {
/* line 462 "ExpDescriptor.puma" */
   GetParamDescriptor (params->BTP_LIST.Elem, & yyV1, & yyV2);
/* line 464 "ExpDescriptor.puma" */
 if (   (f->PROC_OBJ.Ident == IsIdent ("COUNT_PREFIX")) 
         || (f->PROC_OBJ.Ident == IsIdent ("COUNT_SUFFIX"))  )

      { yyV2.type_kind = kINTEGER_TYPE;
        yyV2.type_size = default_int_size; 
      }

   
  }
  }
   * yyP8 = yyV1;
   * yyP7 = yyV2;
   return;
 }
yyL16:;

  }
  }
/* line 474 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 477 "ExpDescriptor.puma" */
   tree_warning_protocol ("no descriptor for intrinsic call of ", f);
  }
   * yyP8 = rfalse;
   * yyP7 = vard;
   return;
 }

;
}

void GetParamDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree param, register rbool * yyP10, var_descriptor * yyP9)
# else
(param, yyP10, yyP9)
 register tTree param;
 register rbool * yyP10;
 var_descriptor * yyP9;
# endif
{
/* line 488 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 492 "ExpDescriptor.puma" */
   if (! ((param == NoTree))) goto yyL1;
  }
   * yyP10 = rfalse;
   * yyP9 = vard;
   return;
 }
yyL1:;

  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
/* line 495 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 497 "ExpDescriptor.puma" */
   GetExpDescriptor (param->VAR_PARAM.V->ADDR.E, & yyV1, & yyV2);
  }
   * yyP10 = yyV1;
   * yyP9 = yyV2;
   return;
 }

  }
/* line 500 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 502 "ExpDescriptor.puma" */
   GetVarDescriptor (param->VAR_PARAM.V, & yyV1, & yyV2);
  }
   * yyP10 = yyV1;
   * yyP9 = yyV2;
   return;
 }

  }
  if (param->Kind == kNO_PARAM) {
/* line 505 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 509 "ExpDescriptor.puma" */
   MakeNoDescriptor (& vard);
  }
   * yyP10 = rtrue;
   * yyP9 = vard;
   return;
 }

  }
/* line 512 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
  }
   * yyP10 = rfalse;
   * yyP9 = vard;
   return;
 }

;
}

static void GetParamListDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree paramlist, register rbool * yyP12, var_descriptor * yyP11)
# else
(paramlist, yyP12, yyP11)
 register tTree paramlist;
 register rbool * yyP12;
 var_descriptor * yyP11;
# endif
{
  if (paramlist->Kind == kBTP_LIST) {
/* line 525 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  rbool yyV3;
  var_descriptor yyV4;
  {
/* line 527 "ExpDescriptor.puma" */
   GetParamDescriptor (paramlist->BTP_LIST.Elem, & yyV1, & yyV2);
/* line 528 "ExpDescriptor.puma" */
   GetParamListDescriptor (paramlist->BTP_LIST.Next, & yyV3, & yyV4);
/* line 530 "ExpDescriptor.puma" */
 if (yyV1 && yyV3)
       CombineDescriptors (&yyV2, &yyV4);
   
  }
   * yyP12 = (yyV1 && yyV3);
   * yyP11 = yyV2;
   return;
 }

  }
  if (paramlist->Kind == kBTP_EMPTY) {
/* line 535 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 539 "ExpDescriptor.puma" */
   MakeNoDescriptor (& vard);
  }
   * yyP12 = rtrue;
   * yyP11 = vard;
   return;
 }

  }
/* line 542 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
  }
   * yyP12 = rfalse;
   * yyP11 = vard;
   return;
 }

;
}

static void GetMatMulDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree array_a, register tTree array_b, register rbool * yyP14, var_descriptor * yyP13)
# else
(array_a, array_b, yyP14, yyP13)
 register tTree array_a;
 register tTree array_b;
 register rbool * yyP14;
 var_descriptor * yyP13;
# endif
{
/* line 550 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 552 "ExpDescriptor.puma" */
   if (! ((TreeRank (array_b) == 1))) goto yyL1;
  {
/* line 556 "ExpDescriptor.puma" */
   GetParamDescriptor (array_a, & yyV1, & yyV2);
/* line 557 "ExpDescriptor.puma" */
   if (! ((yyV1))) goto yyL1;
  {
/* line 559 "ExpDescriptor.puma" */
   RedVarDescriptor (& yyV2, 2);
  }
  }
  }
   * yyP14 = rtrue;
   * yyP13 = yyV2;
   return;
 }
yyL1:;

/* line 562 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 564 "ExpDescriptor.puma" */
   if (! ((TreeRank (array_a) == 1))) goto yyL2;
  {
/* line 568 "ExpDescriptor.puma" */
   GetParamDescriptor (array_b, & yyV1, & yyV2);
/* line 569 "ExpDescriptor.puma" */
   if (! ((yyV1))) goto yyL2;
  {
/* line 571 "ExpDescriptor.puma" */
   RedVarDescriptor (& yyV2, 1);
  }
  }
  }
   * yyP14 = rtrue;
   * yyP13 = yyV2;
   return;
 }
yyL2:;

/* line 574 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  rbool yyV3;
  var_descriptor yyV4;
  {
/* line 576 "ExpDescriptor.puma" */
   if (! ((TreeRank (array_a) == 2))) goto yyL3;
  {
/* line 577 "ExpDescriptor.puma" */
   if (! ((TreeRank (array_b) == 2))) goto yyL3;
  {
/* line 578 "ExpDescriptor.puma" */
   GetParamDescriptor (array_a, & yyV1, & yyV2);
/* line 579 "ExpDescriptor.puma" */
   if (! ((yyV1))) goto yyL3;
  {
/* line 580 "ExpDescriptor.puma" */
   GetParamDescriptor (array_b, & yyV3, & yyV4);
/* line 581 "ExpDescriptor.puma" */
   if (! ((yyV3))) goto yyL3;
  {
/* line 583 "ExpDescriptor.puma" */

#ifdef DEBUG
   printf ("MatMul descriptor\n");
   printf ("array 1 : \n"); PrintVarDescriptor (&yyV2);
#endif
   RedVarDescriptor (&yyV2, 2);
#ifdef DEBUG
   printf ("array 1 reduced : \n"); PrintVarDescriptor (&yyV2);
   printf ("array 2 : \n"); PrintVarDescriptor (&yyV4);
#endif
   RedVarDescriptor (&yyV4, 1);
#ifdef DEBUG
   printf ("array 2 reduced  \n"); PrintVarDescriptor (&yyV4);
#endif
   ProductDescriptors (&yyV2, &yyV4);
#ifdef DEBUG
   printf ("d1 x d2 :  \n"); PrintVarDescriptor (&yyV2);
#endif
   
  }
  }
  }
  }
  }
   * yyP14 = rtrue;
   * yyP13 = yyV2;
   return;
 }
yyL3:;

/* line 604 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
  }
   * yyP14 = rfalse;
   * yyP13 = vard;
   return;
 }

;
}

static void GetDimValue
# if defined __STDC__ | defined __cplusplus
(register tTree params, register int * yyP15)
# else
(params, yyP15)
 register tTree params;
 register int * yyP15;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 619 "ExpDescriptor.puma" */
 {
  rbool found;
  int val;
  {
/* line 624 "ExpDescriptor.puma" */
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V, & found, & val);
/* line 625 "ExpDescriptor.puma" */
   if (! ((found))) goto yyL1;
  }
   * yyP15 = val;
   return;
 }
yyL1:;

  }
  }
  }
/* line 628 "ExpDescriptor.puma" */
   * yyP15 = - 1;
   return;

;
}

static void SetAssumedShape
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tTree actual, register rbool * yyP16)
# else
(vard, actual, yyP16)
 pvar vard;
 register tTree actual;
 register rbool * yyP16;
# endif
{
/* line 643 "ExpDescriptor.puma" */
 {
  rbool okay;
  int i;
  int rank;
  {
/* line 651 "ExpDescriptor.puma" */
 okay = rtrue;

     rank= vard->formal_rank;

     for (i=0; i<rank; i++)

      { if (vard->formal_shape [i][0] == NoTree) okay = rfalse;
        if (vard->formal_shape [i][1] == NoTree) okay = rfalse;
      }

   
/* line 663 "ExpDescriptor.puma" */
   if (! ((okay))) goto yyL1;
  }
   * yyP16 = rtrue;
   return;
 }
yyL1:;

/* line 666 "ExpDescriptor.puma" */
 {
  int i;
  int rank;
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 671 "ExpDescriptor.puma" */
   GetParamDescriptor (actual, & yyV1, & yyV2);
/* line 673 "ExpDescriptor.puma" */
   if (! ((yyV1))) goto yyL2;
  {
/* line 685 "ExpDescriptor.puma" */
   if (! ((yyV2 . actual_rank == vard -> formal_rank))) goto yyL2;
  {
/* line 687 "ExpDescriptor.puma" */
 rank= vard->formal_rank;

     for (i=0; i<rank; i++)

      { int act_pos;

        act_pos = GetFormalDim (&yyV2, i+1) - 1;

        

        if (!IsStride1 (yyV2.actual_shape[act_pos][2]))
           yyV1 = rfalse;

        if (vard->formal_shape [i][0] == NoTree)
           vard->formal_shape [i][0] = yyV2.actual_shape[act_pos][0];
        if (vard->formal_shape [i][1] == NoTree)
           vard->formal_shape [i][1] = yyV2.actual_shape[act_pos][1];
      }
   
/* line 707 "ExpDescriptor.puma" */
   if (! ((yyV1))) goto yyL2;
  }
  }
  }
   * yyP16 = rtrue;
   return;
 }
yyL2:;

/* line 710 "ExpDescriptor.puma" */
   * yyP16 = rfalse;
   return;

;
}

void GetDummyVarDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tDefinitions dummy, register tTree call, register rbool * yyP18, var_descriptor * yyP17)
# else
(actual, dummy, call, yyP18, yyP17)
 register tTree actual;
 register tDefinitions dummy;
 register tTree call;
 register rbool * yyP18;
 var_descriptor * yyP17;
# endif
{
/* line 728 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 732 "ExpDescriptor.puma" */
   if (! ((dummy == NoObject))) goto yyL1;
  {
/* line 734 "ExpDescriptor.puma" */
   error_protocol ("no dummy for actual argument");
/* line 735 "ExpDescriptor.puma" */
   tree_protocol ("actual argument : ", actual);
  }
  }
   * yyP18 = rfalse;
   * yyP17 = vard;
   return;
 }
yyL1:;

/* line 738 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  rbool found;
  {
/* line 745 "ExpDescriptor.puma" */
 int i;
    rbool done;
    tTree new;
 
    SetVarObjDescriptor (&vard, dummy, NoTree);  
 
    SetAssumedShape (&vard, actual, &done);

    found = done;

    if (!found)

       tree_protocol ("could not inherit shape: ", actual);

    
 
    for (i=0; i<vard.actual_rank; i++)
 
      { ActualizeExpression (vard.formal_shape[i][0], call, &done, &new);
        if (done) vard.formal_shape[i][0] = new;
        if (!done) 
          { found = rfalse;
            tree_protocol ("could not actualize : ", 
                            vard.formal_shape[i][0]);
          }
        ActualizeExpression (vard.formal_shape[i][1], call, &done, &new);
        if (done) vard.formal_shape[i][1] = new;
        if (!done) 
          { found = rfalse;
            tree_protocol ("could not actualize : ", vard.formal_shape[i][1]);
          }
        vard.actual_shape[i][0] = vard.formal_shape[i][0];
        vard.actual_shape[i][1] = vard.formal_shape[i][1];
        vard.actual_shape[i][2] = NoTree;
      };
 
    
 
    vard.template_obj = NoObject;
 
#ifdef DEBUG
    FileUnparse (stdout, actual);
    printf (" actual param gets the following descriptor\n");
    PrintVarDescriptor (&vard);
#endif
 
  
  }
   * yyP18 = found;
   * yyP17 = vard;
   return;
 }

;
}

static void GetUserFuncDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree f, register rbool * yyP20, var_descriptor * yyP19)
# else
(f, yyP20, yyP19)
 register tTree f;
 register rbool * yyP20;
 var_descriptor * yyP19;
# endif
{
  if (f->Kind == kFUNC_CALL_EXP) {
/* line 807 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 811 "ExpDescriptor.puma" */
   GetDummyVarDescriptor (NoTree, GetFuncVarObj (f->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object), f, & yyV1, & yyV2);
  }
   * yyP20 = yyV1;
   * yyP19 = yyV2;
   return;
 }

  }
/* line 814 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 818 "ExpDescriptor.puma" */
   failure_protocol (MODULE, "GetUserFuncDescriptor", f);
  }
   * yyP20 = rfalse;
   * yyP19 = vard;
   return;
 }

;
}

static void GetStmtFuncDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree p, register rbool * yyP22, var_descriptor * yyP21)
# else
(p, yyP22, yyP21)
 register tTree p;
 register rbool * yyP22;
 var_descriptor * yyP21;
# endif
{
  if (p->Kind == kPROC_OBJ) {
  if (p->PROC_OBJ.Object->Kind == kFuncObject) {
  if (p->PROC_OBJ.Object->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
/* line 831 "ExpDescriptor.puma" */
 {
  rbool yyV1;
  var_descriptor yyV2;
  {
/* line 834 "ExpDescriptor.puma" */
   GetExpDescriptor (p->PROC_OBJ.Object->FuncObject.decl->STMT_FUNC_DECL.FFUNC_BODY, & yyV1, & yyV2);
  }
   * yyP22 = yyV1;
   * yyP21 = yyV2;
   return;
 }

  }
  }
  }
;
}

static rbool IsEnumExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kARRAY_EXP) {
/* line 845 "ExpDescriptor.puma" */
  {
/* line 846 "ExpDescriptor.puma" */
   if (! ((IsEnumExp (exp->ARRAY_EXP.ELEMENTS)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (exp->Kind == kBTE_LIST) {
/* line 849 "ExpDescriptor.puma" */
  {
/* line 850 "ExpDescriptor.puma" */
   if (! ((TreeRank (exp->BTE_LIST.Elem) == 0))) goto yyL2;
  {
/* line 851 "ExpDescriptor.puma" */
   if (! ((IsEnumExp (exp->BTE_LIST.Next)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  if (exp->Kind == kBTE_EMPTY) {
/* line 854 "ExpDescriptor.puma" */
   return rtrue;

  }
  return rfalse;
}

static void GetReshapeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree shape, register tTree order, register rbool * yyP24, var_descriptor * yyP23)
# else
(shape, order, yyP24, yyP23)
 register tTree shape;
 register tTree order;
 register rbool * yyP24;
 var_descriptor * yyP23;
# endif
{
  if (shape->Kind == kVAR_PARAM) {
  if (shape->VAR_PARAM.V->Kind == kADDR) {
  if (order->Kind == kNO_PARAM) {
/* line 869 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 871 "ExpDescriptor.puma" */
   if (! ((IsEnumExp (shape->VAR_PARAM.V->ADDR.E)))) goto yyL1;
  {
/* line 875 "ExpDescriptor.puma" */
   MakeShapeDescriptor (shape->VAR_PARAM.V->ADDR.E, & vard);
  }
  }
   * yyP24 = rtrue;
   * yyP23 = vard;
   return;
 }
yyL1:;

  }
  }
  }
/* line 878 "ExpDescriptor.puma" */
 {
  var_descriptor vard;
  {
/* line 882 "ExpDescriptor.puma" */
   warning_protocol ("use RESHAPE (source, (/ n1, n2, .. /))");
  }
   * yyP24 = rfalse;
   * yyP23 = vard;
   return;
 }

;
}

void BeginExpDescriptor ARGS ((void))
{
}

void CloseExpDescriptor ARGS ((void))
{
}
