# include "Distributions.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 47 "Distributions.puma" */


# include "Idents.h"

# include "Expressions.h"    /* ResolveExpression, IsVarInExp */

# include "Objects.h"        /* GetFuncVarObj                 */
# include "Types.h"          /* ArrayFormals                  */
# include "TreeOps.h"        /* TreeListGet                   */
# include "Nesting.h"
# include "Intrinsics.h"
# include "Rank.h"

# include "protocol.h"

# define MODULE "Distributions"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyDistributions.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Distributions_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Distributions, routine %s failed\n",
  yyFunction);
 Distributions_Exit ();
}

static int CodeMapping ARGS ((tDefinitions d));
static int CodeSpecMapping ARGS ((tDefinitions d));
int VarDistribution ARGS ((tDefinitions v));
int TreeWriteDistribution ARGS ((tTree var));
static int DistributionWriteIndexed ARGS ((int write_dist, int read_dist));
static int DistributionWriteMerge ARGS ((int write1, int write2));
int TreeReadDistribution ARGS ((tTree exp));
static int DistributionReadMerge ARGS ((int dist1, int dist2));
static int DistributionReadVar ARGS ((int writedist));
tDefinitions GetTemplateObj ARGS ((tDefinitions v));
tDefinitions GetTopologyObj ARGS ((tDefinitions v));
static tDefinitions GetNodeTopology ARGS ((tDefinitions d));
tDefinitions DimListGet ARGS ((tDefinitions list, int pos));
int DimListLength ARGS ((tDefinitions d));
static int GetVarDim ARGS ((tTree indexes, int var_dimension));
rbool IsDistributedObj ARGS ((tDefinitions obj));
rbool IsAlignedObj ARGS ((tDefinitions obj));
rbool IsTranscriptiveObj ARGS ((tDefinitions obj));
static rbool CollapsedAlignment ARGS ((tDefinitions d, tDefinitions temp));
static rbool IsCollapsed ARGS ((tDefinitions template_list, tDefinitions target_list));
static rbool IsCollapsedDim ARGS ((tDefinitions template_dim, tDefinitions target_dim));
rbool SameTopologyObject ARGS ((tDefinitions t_obj1, tDefinitions t_obj2));
static rbool SameSubProcs ARGS ((tTree d1, tTree d2));
static rbool SameProcessors ARGS ((tTree d1, tTree d2));
static rbool SameTarget ARGS ((tTree t1, tTree t2));
rbool IsFullTopologyObj ARGS ((tDefinitions t));

static int CodeMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d)
# else
(d)
 register tDefinitions d;
# endif
{
/* line 81 "Distributions.puma" */
  {
/* line 83 "Distributions.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return 0;
yyL1:;

/* line 87 "Distributions.puma" */
  {
/* line 89 "Distributions.puma" */
   if (! ((GetCurrentModel () == HPF_LOCAL))) goto yyL2;
  }
   return 0;
yyL2:;

/* line 93 "Distributions.puma" */
  {
/* line 95 "Distributions.puma" */
   if (! ((d->Mapping.shared == 1))) goto yyL3;
  }
   return 2;
yyL3:;

/* line 100 "Distributions.puma" */
   return CodeSpecMapping (d->Mapping.spec);

}

static int CodeSpecMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d)
# else
(d)
 register tDefinitions d;
# endif
{
/* line 113 "Distributions.puma" */
  {
/* line 115 "Distributions.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return 0;
yyL1:;

/* line 119 "Distributions.puma" */
  {
/* line 121 "Distributions.puma" */
   if (! ((GetCurrentModel () == HPF_LOCAL))) goto yyL2;
  }
   return 0;
yyL2:;

  if (d->Kind == kMapReplicated) {
/* line 125 "Distributions.puma" */
   return 0;

  }
  if (d->Kind == kMapDist) {
/* line 130 "Distributions.puma" */
   return 1;

  }
  if (d->Kind == kMapInherited) {
/* line 135 "Distributions.puma" */
   return 1;

  }
  if (d->Kind == kMapAlign) {
/* line 142 "Distributions.puma" */
  {
/* line 144 "Distributions.puma" */
   if (! ((CollapsedAlignment (d->MapAlign.Alignment, d->MapAlign.Alignment->Alignment.template_obj)))) goto yyL6;
  }
   return 0;
yyL6:;

/* line 149 "Distributions.puma" */
   return 1;

  }
  if (d->Kind == kMapDefault) {
/* line 154 "Distributions.puma" */
  {
/* line 156 "Distributions.puma" */
   failure_protocol (MODULE, "CodeSpecMapping (default mapping)", NoTree);
  }
   return 0;

  }
  if (d->Kind == kMapDecl) {
/* line 160 "Distributions.puma" */
  {
/* line 163 "Distributions.puma" */
   failure_protocol (MODULE, "CodeSpecMapping (not evaluated mapping)", NoTree);
  }
   return 0;

  }
/* line 167 "Distributions.puma" */
  {
/* line 168 "Distributions.puma" */
   failure_protocol (MODULE, "CodeSpecMapping (no spec mapping)", NoTree);
  }
   return 0;

}

int VarDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
 yyRecursion:
/* line 182 "Distributions.puma" */
  {
/* line 183 "Distributions.puma" */
   if (! ((v == NoObject))) goto yyL1;
  }
   return 0;
yyL1:;

/* line 189 "Distributions.puma" */
  {
/* line 191 "Distributions.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  }
   return 0;
yyL2:;

/* line 195 "Distributions.puma" */
  {
/* line 197 "Distributions.puma" */
   if (! ((GetCurrentModel () == HPF_LOCAL))) goto yyL3;
  }
   return 0;
yyL3:;

  if (v->Kind == kVarObject) {
/* line 201 "Distributions.puma" */
   return CodeMapping (v->VarObject.Dist);

  }
  if (v->Kind == kTemplateObject) {
/* line 206 "Distributions.puma" */
   return CodeMapping (v->TemplateObject.Dist);

  }
  if (v->Kind == kRaggedObject) {
/* line 211 "Distributions.puma" */
   return CodeMapping (v->RaggedObject.Dist);

  }
  if (v->Kind == kProcObject) {
/* line 216 "Distributions.puma" */
   return 0;

  }
  if (v->Kind == kFuncObject) {
  if (v->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 220 "Distributions.puma" */
  {
/* line 221 "Distributions.puma" */
   if (! ((v->FuncObject.Kind == UserRoutine))) goto yyL8;
  }
   v = GetFuncVarObj (v);
   goto yyRecursion;
yyL8:;

  }
  if (v->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
/* line 225 "Distributions.puma" */
   return 0;

  }
  if (v->FuncObject.decl->Kind == kINTRINSIC_DECL) {
/* line 230 "Distributions.puma" */
   return 0;

  }
  }
  if (v->Kind == kBlockObject) {
/* line 235 "Distributions.puma" */
  {
/* line 237 "Distributions.puma" */
   obj_error_protocol ("VarDistribution for BlockObject", v);
/* line 238 "Distributions.puma" */
   kill_in_protocol ();
  }
   return 0;

  }
/* line 242 "Distributions.puma" */
  {
/* line 244 "Distributions.puma" */
   obj_error_protocol ("Illegal Object for VarDistribution", v);
/* line 245 "Distributions.puma" */
   failure_protocol (MODULE, "VarDistribution", v->Object.decl);
  }
   return 0;

}

int TreeWriteDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:

  switch (var->Kind) {
  case kVAR_OBJ:
/* line 265 "Distributions.puma" */
  {
/* line 267 "Distributions.puma" */
   if (! ((var->VAR_OBJ.Reaching == NoTree))) goto yyL1;
  }
   return VarDistribution (var->VAR_OBJ.Object);
yyL1:;

/* line 272 "Distributions.puma" */
  {
/* line 274 "Distributions.puma" */
   if (! ((VarDistribution (var->VAR_OBJ.Object) == 2))) goto yyL2;
  }
   return 2;
yyL2:;

  if (var->VAR_OBJ.Reaching->Kind == kREACHING_INFO) {
/* line 279 "Distributions.puma" */
   return CodeSpecMapping (var->VAR_OBJ.Reaching->REACHING_INFO.var_distribution);

  }
/* line 284 "Distributions.puma" */
   return VarDistribution (var->VAR_OBJ.Object);

  case kUSED_VAR:
/* line 289 "Distributions.puma" */
   var = var->USED_VAR.VARNAME;
   goto yyRecursion;

  case kLOOP_VAR:
/* line 294 "Distributions.puma" */
   return 0;

  case kINDEXED_VAR:
/* line 299 "Distributions.puma" */
   return DistributionWriteIndexed (TreeWriteDistribution (var->INDEXED_VAR.IND_VAR), TreeReadDistribution (var->INDEXED_VAR.IND_EXPS));

  case kSUBSTRING_VAR:
/* line 305 "Distributions.puma" */
   return DistributionWriteIndexed (TreeWriteDistribution (var->SUBSTRING_VAR.IND_VAR), TreeReadDistribution (var->SUBSTRING_VAR.IND_EXP));

  case kSELECTED_VAR:
/* line 311 "Distributions.puma" */
   var = var->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;

  case kPERM_VAR:
/* line 316 "Distributions.puma" */
   var = var->PERM_VAR.VAL;
   goto yyRecursion;

  case kDO_VAR:
/* line 321 "Distributions.puma" */
   return DistributionWriteIndexed (TreeWriteDistribution (var->DO_VAR.BODY), TreeReadDistribution (var->DO_VAR.RANGE));

  case kBTV_LIST:
  if (var->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 327 "Distributions.puma" */
   var = var->BTV_LIST.Elem;
   goto yyRecursion;

  }
/* line 332 "Distributions.puma" */
   return DistributionWriteMerge (TreeWriteDistribution (var->BTV_LIST.Elem), TreeWriteDistribution (var->BTV_LIST.Next));

  case kBTV_EMPTY:
/* line 338 "Distributions.puma" */
   return 0;

  case kADDR:
/* line 343 "Distributions.puma" */
   return TreeReadDistribution (var->ADDR.E);

  }

/* line 348 "Distributions.puma" */
  {
/* line 349 "Distributions.puma" */
   failure_protocol (MODULE, "TreeWriteDistribution", var);
  }
   return 0;

}

static int DistributionWriteIndexed
# if defined __STDC__ | defined __cplusplus
(register int write_dist, register int read_dist)
# else
(write_dist, read_dist)
 register int write_dist;
 register int read_dist;
# endif
{
/* line 361 "Distributions.puma" */
  {
/* line 363 "Distributions.puma" */
   if (! ((read_dist == 0))) goto yyL1;
  }
   return write_dist;
yyL1:;

/* line 367 "Distributions.puma" */
  {
/* line 369 "Distributions.puma" */
   if (! ((read_dist == - 1))) goto yyL2;
  {
/* line 370 "Distributions.puma" */
   if (! ((write_dist == - 1))) goto yyL2;
  }
  }
   return - 1;
yyL2:;

/* line 374 "Distributions.puma" */
   return - 2;

}

static int DistributionWriteMerge
# if defined __STDC__ | defined __cplusplus
(register int write1, register int write2)
# else
(write1, write2)
 register int write1;
 register int write2;
# endif
{
/* line 387 "Distributions.puma" */
  {
/* line 388 "Distributions.puma" */
   if (! ((write1 == write2))) goto yyL1;
  }
   return write1;
yyL1:;

/* line 392 "Distributions.puma" */
   return - 2;

}

int TreeReadDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
 yyRecursion:

  switch (exp->Kind) {
  case kBTE_LIST:
/* line 410 "Distributions.puma" */
   return DistributionReadMerge (TreeReadDistribution (exp->BTE_LIST.Elem), TreeReadDistribution (exp->BTE_LIST.Next));

  case kBTE_EMPTY:
/* line 416 "Distributions.puma" */
   return 0;

  case kARRAY_EXP:
/* line 420 "Distributions.puma" */
   exp = exp->ARRAY_EXP.ELEMENTS;
   goto yyRecursion;

  case kTYPE_EXP:
/* line 424 "Distributions.puma" */
   exp = exp->TYPE_EXP.ELEMENTS;
   goto yyRecursion;

  case kDUMMY_EXP:
/* line 428 "Distributions.puma" */
   return 0;

  case kCONST_EXP:
/* line 433 "Distributions.puma" */
   return 0;

  case kSLICE_EXP:
/* line 438 "Distributions.puma" */
   return DistributionReadMerge (TreeReadDistribution (exp->SLICE_EXP.FIRST), DistributionReadMerge (TreeReadDistribution (exp->SLICE_EXP.STOP), TreeReadDistribution (exp->SLICE_EXP.INC)));

  case kOP_EXP:
/* line 445 "Distributions.puma" */
   return DistributionReadMerge (TreeReadDistribution (exp->OP_EXP.OPND1), TreeReadDistribution (exp->OP_EXP.OPND2));

  case kOP1_EXP:
/* line 451 "Distributions.puma" */
   exp = exp->OP1_EXP.OPND;
   goto yyRecursion;

  case kVAR_EXP:
/* line 455 "Distributions.puma" */
   return DistributionReadVar (TreeWriteDistribution (exp->VAR_EXP.V));

  case kFUNC_CALL_EXP:
/* line 460 "Distributions.puma" */
  {
/* line 462 "Distributions.puma" */
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL11;
  {
/* line 463 "Distributions.puma" */
   if (! ((IntrFuncInquiry (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL11;
  }
  }
   return 0;
yyL11:;

/* line 467 "Distributions.puma" */
  {
/* line 469 "Distributions.puma" */
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL12;
  }
   exp = exp->FUNC_CALL_EXP.FUNC_PARAMS;
   goto yyRecursion;
yyL12:;

/* line 473 "Distributions.puma" */
  {
/* line 475 "Distributions.puma" */
   if (! ((IsStmtCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL13;
  }
   exp = exp->FUNC_CALL_EXP.FUNC_PARAMS;
   goto yyRecursion;
yyL13:;

/* line 479 "Distributions.puma" */
  {
/* line 481 "Distributions.puma" */
   if (! ((IsPureCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL14;
  }
   exp = exp->FUNC_CALL_EXP.FUNC_PARAMS;
   goto yyRecursion;
yyL14:;

/* line 485 "Distributions.puma" */
   return - 2;

  case kDO_EXP:
/* line 490 "Distributions.puma" */
   return DistributionReadMerge (TreeReadDistribution (exp->DO_EXP.RANGE), TreeReadDistribution (exp->DO_EXP.BODY));

  case kBOUND_EXP:
/* line 496 "Distributions.puma" */
   return 0;

  case kRANK_EXP:
/* line 500 "Distributions.puma" */
   return 0;

  case kBTP_LIST:
/* line 504 "Distributions.puma" */
   return DistributionReadMerge (TreeReadDistribution (exp->BTP_LIST.Elem), TreeReadDistribution (exp->BTP_LIST.Next));

  case kBTP_EMPTY:
/* line 510 "Distributions.puma" */
   return 0;

  case kVAR_PARAM:
  if (exp->VAR_PARAM.V->Kind == kADDR) {
/* line 514 "Distributions.puma" */
   exp = exp->VAR_PARAM.V->ADDR.E;
   goto yyRecursion;

  }
/* line 518 "Distributions.puma" */
   return DistributionReadVar (TreeWriteDistribution (exp->VAR_PARAM.V));

  case kNO_PARAM:
/* line 523 "Distributions.puma" */
   return 0;

  case kPROC_PARAM:
/* line 527 "Distributions.puma" */
   return 0;

  case kFUNC_PARAM:
/* line 531 "Distributions.puma" */
   return 0;

  }

/* line 535 "Distributions.puma" */
  {
/* line 536 "Distributions.puma" */
   failure_protocol (MODULE, "TreeReadDistribution", exp);
  }
   return 0;

}

static int DistributionReadMerge
# if defined __STDC__ | defined __cplusplus
(register int dist1, register int dist2)
# else
(dist1, dist2)
 register int dist1;
 register int dist2;
# endif
{
  if (equalint (dist2, 0)) {
/* line 548 "Distributions.puma" */
   return dist1;

  }
  if (equalint (dist1, 0)) {
/* line 552 "Distributions.puma" */
   return dist2;

  }
/* line 556 "Distributions.puma" */
  {
/* line 557 "Distributions.puma" */
   if (! ((dist1 == dist2))) goto yyL3;
  }
   return dist1;
yyL3:;

/* line 561 "Distributions.puma" */
   return - 2;

}

static int DistributionReadVar
# if defined __STDC__ | defined __cplusplus
(register int writedist)
# else
(writedist)
 register int writedist;
# endif
{
/* line 573 "Distributions.puma" */
  {
/* line 574 "Distributions.puma" */
   if (! ((writedist == 2))) goto yyL1;
  }
   return 0;
yyL1:;

/* line 578 "Distributions.puma" */
  {
/* line 579 "Distributions.puma" */
   if (! ((writedist == 1))) goto yyL2;
  }
   return - 2;
yyL2:;

/* line 583 "Distributions.puma" */
   return writedist;

}

tDefinitions GetTemplateObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Dist->Mapping.spec->Kind == kMapAlign) {
/* line 597 "Distributions.puma" */
   return v->VarObject.Dist->Mapping.spec->MapAlign.Alignment->Alignment.template_obj;

  }
  }
/* line 602 "Distributions.puma" */
   return v;

}

tDefinitions GetTopologyObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Dist->Mapping.spec->Kind == kMapDist) {
/* line 616 "Distributions.puma" */
   return GetNodeTopology (v->VarObject.Dist->Mapping.spec->MapDist.Distribution);

  }
  }
  if (v->Kind == kTemplateObject) {
  if (v->TemplateObject.Dist->Mapping.spec->Kind == kMapDist) {
/* line 621 "Distributions.puma" */
   return GetNodeTopology (v->TemplateObject.Dist->Mapping.spec->MapDist.Distribution);

  }
  }
  if (v->Kind == kRaggedObject) {
  if (v->RaggedObject.Dist->Mapping.spec->Kind == kMapDist) {
/* line 626 "Distributions.puma" */
   return GetNodeTopology (v->RaggedObject.Dist->Mapping.spec->MapDist.Distribution);

  }
  }
/* line 631 "Distributions.puma" */
   return NoObject;

}

static tDefinitions GetNodeTopology
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d)
# else
(d)
 register tDefinitions d;
# endif
{
/* line 638 "Distributions.puma" */
   return d->Distribution.top_obj;

}

tDefinitions DimListGet
# if defined __STDC__ | defined __cplusplus
(register tDefinitions list, register int pos)
# else
(list, pos)
 register tDefinitions list;
 register int pos;
# endif
{
 yyRecursion:
/* line 653 "Distributions.puma" */
  {
/* line 654 "Distributions.puma" */
   if (! ((pos <= 0))) goto yyL1;
  {
/* line 655 "Distributions.puma" */
   error_protocol ("DimListGet with pos < 0");
/* line 656 "Distributions.puma" */
   kill_in_protocol ();
  }
  }
   return NoObject;
yyL1:;

  if (list->Kind == kDIM_EMPTY) {
/* line 660 "Distributions.puma" */
  {
/* line 661 "Distributions.puma" */
   error_protocol ("DimListGet with empty list");
/* line 662 "Distributions.puma" */
   kill_in_protocol ();
  }
   return NoObject;

  }
  if (list->Kind == kDIM_LIST) {
  if (equalint (pos, 1)) {
/* line 666 "Distributions.puma" */
   return list->DIM_LIST.Elem;

  }
/* line 670 "Distributions.puma" */
   list = list->DIM_LIST.Next;
   pos = pos - 1;
   goto yyRecursion;

  }
 yyAbort ("DimListGet");
 { tDefinitions yyDummy; return yyDummy; }
}

int DimListLength
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d)
# else
(d)
 register tDefinitions d;
# endif
{
  if (d->Kind == kDIM_EMPTY) {
/* line 676 "Distributions.puma" */
   return 0;

  }
  if (d->Kind == kDIM_LIST) {
/* line 680 "Distributions.puma" */
   return 1 + DimListLength (d->DIM_LIST.Next);

  }
 yyAbort ("DimListLength");
 { int yyDummy; return yyDummy; }
}

static int GetVarDim
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int var_dimension)
# else
(indexes, var_dimension)
 register tTree indexes;
 register int var_dimension;
# endif
{
  if (indexes->Kind == kBTE_LIST) {
/* line 694 "Distributions.puma" */
  {
/* line 695 "Distributions.puma" */
   if (! ((TreeRank (indexes->BTE_LIST.Elem) == 0))) goto yyL1;
  }
   return GetVarDim (indexes->BTE_LIST.Next, var_dimension) + 1;
yyL1:;

/* line 699 "Distributions.puma" */
  {
/* line 700 "Distributions.puma" */
   if (! ((var_dimension == 1))) goto yyL2;
  }
   return 1;
yyL2:;

/* line 704 "Distributions.puma" */
   return GetVarDim (indexes->BTE_LIST.Next, var_dimension - 1) + 1;

  }
/* line 708 "Distributions.puma" */
  {
/* line 709 "Distributions.puma" */
   failure_protocol (MODULE, "GetVarDim", indexes);
  }
   return 0;

}

rbool IsDistributedObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kRaggedObject) {
  if (obj->RaggedObject.Dist->Mapping.spec->Kind == kMapDist) {
/* line 721 "Distributions.puma" */
   return rtrue;

  }
  }
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapDist) {
/* line 724 "Distributions.puma" */
   return rtrue;

  }
  }
  if (obj->Kind == kTemplateObject) {
  if (obj->TemplateObject.Dist->Mapping.spec->Kind == kMapDist) {
/* line 727 "Distributions.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

rbool IsAlignedObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapAlign) {
/* line 732 "Distributions.puma" */
   return rtrue;

  }
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapDecl) {
  if (obj->VarObject.Dist->Mapping.spec->MapDecl.decl->Kind == kALIGN_DECL) {
/* line 735 "Distributions.puma" */
   return rtrue;

  }
  }
  }
  return rfalse;
}

rbool IsTranscriptiveObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.range->Kind == kRangeSelection) {
/* line 740 "Distributions.puma" */
   return rtrue;

  }
  if (obj->VarObject.Dist->Mapping.range->Kind == kRangeDecl) {
/* line 743 "Distributions.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static rbool CollapsedAlignment
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, register tDefinitions temp)
# else
(d, temp)
 register tDefinitions d;
 register tDefinitions temp;
# endif
{
/* line 754 "Distributions.puma" */
  {
/* line 756 "Distributions.puma" */
   if (! ((VarDistribution (temp) == 0))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (temp->Kind == kTemplateObject) {
  if (temp->TemplateObject.Dist->Mapping.spec->Kind == kMapDist) {
/* line 759 "Distributions.puma" */
  {
/* line 762 "Distributions.puma" */
   if (! ((IsCollapsed (temp->TemplateObject.Dist->Mapping.spec->MapDist.Distribution->Distribution.ArrayList, d->Alignment.TargetList)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  if (temp->Kind == kVarObject) {
  if (temp->VarObject.Dist->Mapping.spec->Kind == kMapDist) {
/* line 765 "Distributions.puma" */
  {
/* line 768 "Distributions.puma" */
   if (! ((IsCollapsed (temp->VarObject.Dist->Mapping.spec->MapDist.Distribution->Distribution.ArrayList, d->Alignment.TargetList)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  }
  return rfalse;
}

static rbool IsCollapsed
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template_list, register tDefinitions target_list)
# else
(template_list, target_list)
 register tDefinitions template_list;
 register tDefinitions target_list;
# endif
{
  if (template_list->Kind == kDIM_LIST) {
  if (target_list->Kind == kDIM_LIST) {
/* line 773 "Distributions.puma" */
  {
/* line 775 "Distributions.puma" */
   if (! ((IsCollapsedDim (template_list->DIM_LIST.Elem, target_list->DIM_LIST.Elem)))) goto yyL1;
  {
/* line 776 "Distributions.puma" */
   if (! ((IsCollapsed (template_list->DIM_LIST.Next, target_list->DIM_LIST.Next)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  }
  if (template_list->Kind == kDIM_EMPTY) {
  if (target_list->Kind == kDIM_EMPTY) {
/* line 779 "Distributions.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static rbool IsCollapsedDim
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template_dim, register tDefinitions target_dim)
# else
(template_dim, target_dim)
 register tDefinitions template_dim;
 register tDefinitions target_dim;
# endif
{
  if (template_dim->Kind == kSerialDimension) {
/* line 785 "Distributions.puma" */
   return rtrue;

  }
  if (target_dim->Kind == kReplicatedDimension) {
/* line 788 "Distributions.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool SameTopologyObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t_obj1, register tDefinitions t_obj2)
# else
(t_obj1, t_obj2)
 register tDefinitions t_obj1;
 register tDefinitions t_obj2;
# endif
{
/* line 800 "Distributions.puma" */
  {
/* line 802 "Distributions.puma" */
   if (! ((t_obj1 == NoObject))) goto yyL1;
  {
/* line 803 "Distributions.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 806 "Distributions.puma" */
  {
/* line 808 "Distributions.puma" */
   if (! ((t_obj2 == NoObject))) goto yyL2;
  {
/* line 809 "Distributions.puma" */
   return rfalse;
  }
  }
yyL2:;

/* line 812 "Distributions.puma" */
  {
/* line 814 "Distributions.puma" */
   if (! ((t_obj1 == t_obj2))) goto yyL3;
  }
   return rtrue;
yyL3:;

/* line 817 "Distributions.puma" */
  {
/* line 820 "Distributions.puma" */
   if (! ((t_obj1->TopologyObject.rank == t_obj2->TopologyObject.rank))) goto yyL4;
  {
/* line 821 "Distributions.puma" */
   if (! ((t_obj1->TopologyObject.Ident == DefaultId ()))) goto yyL4;
  {
/* line 822 "Distributions.puma" */
   if (! ((t_obj2->TopologyObject.Ident == DefaultId ()))) goto yyL4;
  }
  }
  }
   return rtrue;
yyL4:;

/* line 825 "Distributions.puma" */
  {
/* line 828 "Distributions.puma" */
   if (! ((t_obj1->TopologyObject.Ident != DefaultId ()))) goto yyL5;
  {
/* line 829 "Distributions.puma" */
   if (! ((t_obj2->TopologyObject.Ident != DefaultId ()))) goto yyL5;
  {
/* line 830 "Distributions.puma" */
   if (! ((t_obj1->TopologyObject.rank == t_obj2->TopologyObject.rank))) goto yyL5;
  {
/* line 832 "Distributions.puma" */
   if (! ((SameProcessors (t_obj1->TopologyObject.decl, t_obj2->TopologyObject.decl) || SameSubProcs (t_obj1->TopologyObject.decl, t_obj2->TopologyObject.decl)))) goto yyL5;
  {
/* line 833 "Distributions.puma" */
   if (! ((SameTarget (t_obj1->TopologyObject.target, t_obj2->TopologyObject.target)))) goto yyL5;
  }
  }
  }
  }
  }
   return rtrue;
yyL5:;

  return rfalse;
}

static rbool SameSubProcs
# if defined __STDC__ | defined __cplusplus
(register tTree d1, register tTree d2)
# else
(d1, d2)
 register tTree d1;
 register tTree d2;
# endif
{
  if (d1->Kind == kSUB_PROCS_DECL) {
  if (d2->Kind == kSUB_PROCS_DECL) {
/* line 846 "Distributions.puma" */
  {
/* line 849 "Distributions.puma" */
   if (! ((d1->SUB_PROCS_DECL.TOP->TOP_OBJ.Object == d2->SUB_PROCS_DECL.TOP->TOP_OBJ.Object))) goto yyL1;
  {
/* line 850 "Distributions.puma" */
   if (! ((EqualIndexes (d1->SUB_PROCS_DECL.DIMENSIONS, d2->SUB_PROCS_DECL.DIMENSIONS)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

static rbool SameProcessors
# if defined __STDC__ | defined __cplusplus
(register tTree d1, register tTree d2)
# else
(d1, d2)
 register tTree d1;
 register tTree d2;
# endif
{
  if (d1->Kind == kPROCESSORS_DECL) {
  if (d2->Kind == kPROCESSORS_DECL) {
/* line 855 "Distributions.puma" */
  {
/* line 857 "Distributions.puma" */
   if (! ((SameProcessors (d1->PROCESSORS_DECL.DIMENSIONS, d2->PROCESSORS_DECL.DIMENSIONS)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  if (d1->Kind == kSHAPE_LIST) {
  if (d2->Kind == kSHAPE_LIST) {
/* line 860 "Distributions.puma" */
  {
/* line 862 "Distributions.puma" */
   if (! ((SameProcessors (d1->SHAPE_LIST.Elem, d2->SHAPE_LIST.Elem)))) goto yyL2;
  {
/* line 863 "Distributions.puma" */
   if (! ((SameProcessors (d1->SHAPE_LIST.Next, d2->SHAPE_LIST.Next)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  }
  if (d1->Kind == kSHAPE_EMPTY) {
  if (d2->Kind == kSHAPE_EMPTY) {
/* line 866 "Distributions.puma" */
   return rtrue;

  }
  }
  if (d1->Kind == kEXPLICIT_SHAPE) {
  if (d2->Kind == kEXPLICIT_SHAPE) {
/* line 869 "Distributions.puma" */
 {
  rbool found;
  int val1;
  int val2;
  {
/* line 876 "Distributions.puma" */
   GetConstDifference (d1->EXPLICIT_SHAPE.LOWER, d2->EXPLICIT_SHAPE.LOWER, & found, & val1);
/* line 877 "Distributions.puma" */
   if (! ((found))) goto yyL4;
  {
/* line 878 "Distributions.puma" */
   GetConstDifference (d1->EXPLICIT_SHAPE.UPPER, d2->EXPLICIT_SHAPE.UPPER, & found, & val2);
/* line 879 "Distributions.puma" */
   if (! ((found))) goto yyL4;
  {
/* line 880 "Distributions.puma" */
   if (! ((val1 == val2))) goto yyL4;
  }
  }
  }
   return rtrue;
 }
yyL4:;

  }
  }
  return rfalse;
}

static rbool SameTarget
# if defined __STDC__ | defined __cplusplus
(register tTree t1, register tTree t2)
# else
(t1, t2)
 register tTree t1;
 register tTree t2;
# endif
{
/* line 894 "Distributions.puma" */
  {
/* line 896 "Distributions.puma" */
   if (! ((t1 == NoTree))) goto yyL1;
  {
/* line 897 "Distributions.puma" */
   if (! ((t2 == NoTree))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 900 "Distributions.puma" */
 {
  rbool found;
  int val;
  {
/* line 902 "Distributions.puma" */
   if (! ((t1 == NoTree))) goto yyL2;
  {
/* line 907 "Distributions.puma" */
   GetIntConstValue (t2, & found, & val);
/* line 908 "Distributions.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 909 "Distributions.puma" */
   if (! ((val == 1))) goto yyL2;
  }
  }
  }
   return rtrue;
 }
yyL2:;

/* line 912 "Distributions.puma" */
 {
  rbool found;
  int val;
  {
/* line 914 "Distributions.puma" */
   if (! ((t2 == NoTree))) goto yyL3;
  {
/* line 919 "Distributions.puma" */
   GetIntConstValue (t1, & found, & val);
/* line 920 "Distributions.puma" */
   if (! ((found))) goto yyL3;
  {
/* line 921 "Distributions.puma" */
   if (! ((val == 1))) goto yyL3;
  }
  }
  }
   return rtrue;
 }
yyL3:;

/* line 924 "Distributions.puma" */
  {
/* line 926 "Distributions.puma" */
   if (! ((t1 != NoTree))) goto yyL4;
  {
/* line 927 "Distributions.puma" */
   if (! ((t2 != NoTree))) goto yyL4;
  {
/* line 929 "Distributions.puma" */
   if (! ((EqualExpression (t1, t2)))) goto yyL4;
  }
  }
  }
   return rtrue;
yyL4:;

  return rfalse;
}

rbool IsFullTopologyObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
/* line 940 "Distributions.puma" */
  {
/* line 941 "Distributions.puma" */
   if (! ((t == NoObject))) goto yyL1;
  {
/* line 942 "Distributions.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 945 "Distributions.puma" */
  {
/* line 947 "Distributions.puma" */
   if (! ((t->TopologyObject.Ident == DefaultId ()))) goto yyL2;
  {
/* line 948 "Distributions.puma" */
   if (! ((t->TopologyObject.rank >= 0))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  return rfalse;
}

void BeginDistributions ARGS ((void))
{
}

void CloseDistributions ARGS ((void))
{
}
