# include "Descriptor.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 56 "Descriptor.puma" */


#undef DEBUG

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "DefTable.h"

# include "Nesting.h"      /* GetOuterLooops, .. */
# include "Expressions.h"  /* MakeConstant, .. */

# include "Transform.h"    /* VarParamToExp, .. */
# include "Distributions.h"
# include "TreeOps.h"
# include "Unparse.h"

# include "HomeDescriptor.h" 
# include "VarDescriptor.h"
# include "Loops.h"
# include "Rank.h"
# include "MoveDescriptor.h" 

# define MODULE "Descriptor"

    /******************************************************
    *  Help Functions for Switching of Index Data         *
    ******************************************************/

static void switch_tree (t1, t2)
tTree *t1, *t2;
{ tTree h;
  h = *t1; *t1 = *t2; *t2 = h;
} /* switch_tree */

static void switch_int (t1, t2)
int *t1, *t2;
{ int h;
  h = *t1; *t1 = *t2; *t2 = h;
} /* switch_int */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyDescriptor.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Descriptor_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Descriptor, routine %s failed\n",
  yyFunction);
 Descriptor_Exit ();
}

rbool IsTemplateDescriptor ARGS ((pvar vard));
void MakeTemplateDescriptor ARGS ((pvar vard));
static void ExpandDescriptorDimension ARGS ((pvar vard, int dim));
void ReplicateDescriptorDimension ARGS ((pvar vard, int dim));
void IntersectDescriptor ARGS ((pvar vard1, pvar vard2));
static void IntersectTopDims ARGS ((pvar vard1, pvar vard2, int top_dim));
void AddDescriptorDimension ARGS ((pvar vard, tTree actual, tTree formal, int kind));
static void SetFormalShape ARGS ((pvar vard, int dim, tTree formal));
static void GetFormalSize ARGS ((tTree formal, tTree * yyP3, tTree * yyP2, tTree * yyP1));
static void SetActualShape ARGS ((pvar vard, int dim, tTree actual));
void MakeSliceDescriptor ARGS ((tTree exp, pvar vard));
void MakeShapeDescriptor ARGS ((tTree exp, pvar vard));
static void MakeListShapeDescriptor ARGS ((tTree exp, pvar vard));
void MakeLoopVarDescriptor ARGS ((tTree exp, pvar vard));
static void CorrectTemplateDescriptor ARGS ((pvar vard));
void ProductDescriptors ARGS ((pvar d1, pvar d2));
void CombineDescriptors ARGS ((pvar d1, pvar d2));
void ExpandDescriptor ARGS ((pvar d, tTree loopid, rbool * yyP4));
int FindDescriptorDim ARGS ((pvar d, tTree loopid));
static rbool ActualIsDependent ARGS ((pvar d, int dim, tTree loopid));
void RedVarDescriptor ARGS ((pvar vard, int dim));
void RemDimDescriptor ARGS ((pvar vard, int index_dim));
void MakeRepArray1Descriptor ARGS ((pvar vard, int size));
static void MakeNewSerialDim ARGS ((pvar vard, int dim, tTree exp));
static void MoveIndexData ARGS ((pvar vard, int old_dim, int new_dim));
static void SwitchIndexData ARGS ((pvar vard, int index_dim1, int index_dim2));
void TransposeDescriptor ARGS ((pvar vard));
static void SwitchDimDescriptor ARGS ((pvar vard, int idim1, int idim2));
void SpreadVarDescriptor ARGS ((pvar vard, int dim, tTree ncopies));
rbool SameDescriptorTopology ARGS ((pvar vard1, pvar vard2));
tTree PrintableDescriptorVar ARGS ((pvar vard));

rbool IsTemplateDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 103 "Descriptor.puma" */
  {
/* line 104 "Descriptor.puma" */
   if (! ((vard -> type_kind == kDUMMY_TYPE))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

void MakeTemplateDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 123 "Descriptor.puma" */
  {
/* line 125 "Descriptor.puma" */
 int pdim;
     rbool new;

     new = rfalse;

     for (pdim = 0; pdim < vard->topology_rank; pdim++)

      { int idim, tdim, rank;

        idim = vard->on_index_dim [pdim];
        tdim = vard->on_temp_dim [pdim];
   
        if (idim == 0)  

          { if (vard->on_val[pdim] != NoTree)

             { 

               rank = vard->formal_rank;

               vard->formal_shape[rank][0] = vard->on_range[pdim][0];
               vard->formal_shape[rank][1] = vard->on_range[pdim][1];

               vard->alloc_shape[rank][0] = vard->on_range[pdim][0];
               vard->alloc_shape[rank][1] = vard->on_range[pdim][1];

               SetActualShape (vard, rank, vard->on_val[pdim]);

               vard->distribution_kind [rank] = vard->on_kind[pdim];
               vard->distribution_size [rank] = vard->on_size[pdim];
               vard->template_dim [rank] = tdim;
               vard->topology_dim [rank] = tdim;
               vard->align_add  [rank] = 0;
               vard->align_mult [rank] = 1;

               

               vard->on_index_dim [pdim] = rank + 1;
               new = rtrue;

               vard->formal_rank = rank + 1;
             }
          }
      }
     if (new)
        vard->var_tree = NoTree; 
   
  }
   return;

;
}

static void ExpandDescriptorDimension
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int dim)
# else
(vard, dim)
 pvar vard;
 register int dim;
# endif
{
/* line 185 "Descriptor.puma" */
  {
/* line 187 "Descriptor.puma" */
   if (! ((dim < 1))) goto yyL1;
  }
   return;
yyL1:;

/* line 190 "Descriptor.puma" */
  {
/* line 192 "Descriptor.puma" */
 tTree lb, ub;
     int   pdim;

     lb = vard->actual_shape[dim-1][0];
     ub = vard->actual_shape[dim-1][1];

     

     if ((lb == ub) && (TreeRank (lb) == 0))
        vard->actual_rank++;

     vard->actual_shape[dim-1][0] = vard->formal_shape[dim-1][0];
     vard->actual_shape[dim-1][1] = vard->formal_shape[dim-1][1];
     vard->actual_shape[dim-1][2] = NoTree;

     pdim = vard->topology_dim[dim-1];

     if (pdim > 0)
        { vard->on_val [pdim-1] = NoTree; };

     vard->var_tree = NoTree;   

   
  }
   return;

;
}

void ReplicateDescriptorDimension
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int dim)
# else
(vard, dim)
 pvar vard;
 register int dim;
# endif
{
/* line 230 "Descriptor.puma" */
  {
/* line 232 "Descriptor.puma" */
   if (! ((dim < 1))) goto yyL1;
  }
   return;
yyL1:;

/* line 235 "Descriptor.puma" */
  {
/* line 237 "Descriptor.puma" */
 tTree lb, ub;
     int   pdim;

     lb = vard->actual_shape[dim-1][0];
     ub = vard->actual_shape[dim-1][1];

     

     if ((lb == ub) && (TreeRank (lb) == 0))
        vard->actual_rank++;

     

     vard->actual_shape[dim-1][0] = vard->formal_shape[dim-1][0];
     vard->actual_shape[dim-1][1] = vard->formal_shape[dim-1][1];
     vard->actual_shape[dim-1][2] = NoTree;

     pdim = vard->topology_dim[dim-1];

     if (pdim > 0)

        { vard->on_val [pdim-1] = NoTree; };

     vard->var_tree = NoTree;   

   
  }
   return;

;
}

void IntersectDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2)
# else
(vard1, vard2)
 pvar vard1;
 pvar vard2;
# endif
{
/* line 279 "Descriptor.puma" */
  {
/* line 281 "Descriptor.puma" */

#ifdef DEBUG
   printf ("Intersection of two descriptors : ");
   FileUnparse (stdout, PrintableDescriptorVar (vard1));
   PrintVarDescriptor (vard1);
   printf (" and ");
   FileUnparse (stdout, PrintableDescriptorVar (vard2));
   printf ("\n");
   PrintVarDescriptor (vard2);
#endif 
   
/* line 293 "Descriptor.puma" */
   if (! ((VDIsSubSet (vard1, vard2)))) goto yyL1;
  }
   return;
yyL1:;

/* line 296 "Descriptor.puma" */
  {
/* line 298 "Descriptor.puma" */
   if (! ((VDIsSubSet (vard2, vard1)))) goto yyL2;
  {
/* line 300 "Descriptor.puma" */
 *vard1 = *vard2; 
  }
  }
   return;
yyL2:;

/* line 309 "Descriptor.puma" */
 {
  int top_dim;
  {
/* line 313 "Descriptor.puma" */
   if (! ((SameDescriptorTopology (vard1, vard2)))) goto yyL3;
  {
/* line 315 "Descriptor.puma" */
   MakeTemplateDescriptor (vard1);
/* line 316 "Descriptor.puma" */
   MakeTemplateDescriptor (vard2);
/* line 318 "Descriptor.puma" */
 for (top_dim = 1; top_dim <= VarRank (vard1->topology_obj); top_dim ++)

        IntersectTopDims (vard1, vard2, top_dim);

     vard1->var_tree = NoTree;

#ifdef DEBUG
     printf ("result of intersection is :");
     FileUnparse (stdout, PrintableDescriptorVar (vard1));
     printf ("\n");
     PrintVarDescriptor (vard1);
#endif

   
  }
  }
   return;
 }
yyL3:;

/* line 334 "Descriptor.puma" */
  {
/* line 336 "Descriptor.puma" */
   MakeNoDescriptor (vard1);
  }
   return;

;
}

static void IntersectTopDims
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2, register int top_dim)
# else
(vard1, vard2, top_dim)
 pvar vard1;
 pvar vard2;
 register int top_dim;
# endif
{
/* line 347 "Descriptor.puma" */
  {
/* line 349 "Descriptor.puma" */
   if (! ((IsNoDescriptor (vard1)))) goto yyL1;
  }
   return;
yyL1:;

/* line 352 "Descriptor.puma" */
 {
  int idim1;
  int idim2;
  {
/* line 357 "Descriptor.puma" */
 idim1 = vard1->on_index_dim [top_dim-1] - 1;
     idim2 = vard2->on_index_dim [top_dim-1] - 1;

     

     if (VDIsSubTopDim (vard1, vard2, top_dim))

        { 

          

        }

      else if (VDIsSubTopDim (vard2, vard1, top_dim))

        { 

          

          if (idim1 >= 0)

            { vard1->formal_shape[idim1][0] = vard2->formal_shape[idim2][0];
              vard1->formal_shape[idim1][1] = vard2->formal_shape[idim2][1];

              vard1->alloc_shape[idim1][0] = vard2->alloc_shape[idim2][0];
              vard1->alloc_shape[idim1][1] = vard2->alloc_shape[idim2][1];

              vard1->actual_shape[idim1][0] = vard2->actual_shape[idim2][0];
              vard1->actual_shape[idim1][1] = vard2->actual_shape[idim2][1];
              vard1->actual_shape[idim1][2] = vard2->actual_shape[idim2][2];

              vard1->distribution_kind[idim1] = vard2->distribution_kind[idim2];
              vard1->distribution_size[idim1] = vard2->distribution_size[idim2];

              vard1->template_dim [idim1] = vard2->template_dim [idim2];
              vard1->align_mult [idim1] = vard2->align_mult [idim2];
              vard1->align_add [idim1] = vard2->align_add [idim2];

              vard1->topology_dim[idim1] = vard2->topology_dim[idim2];

              vard1->on_index_dim [top_dim-1] = vard2->on_index_dim [top_dim-1];

            }

          vard1->on_temp_dim [top_dim-1] = vard2->on_temp_dim [top_dim-1];
          vard1->on_kind [top_dim-1] = vard2->on_kind [top_dim-1];
          vard1->on_size [top_dim-1] = vard2->on_size [top_dim-1];
          vard1->on_val [top_dim-1] = vard2->on_val [top_dim-1];
          vard1->on_range [top_dim-1][0] = vard2->on_range [top_dim-1][0];
          vard1->on_range [top_dim-1][1] = vard2->on_range [top_dim-1][1];

        }

      else

        MakeNoDescriptor (vard1);

   
  }
   return;
 }

;
}

void AddDescriptorDimension
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tTree actual, register tTree formal, register int kind)
# else
(vard, actual, formal, kind)
 pvar vard;
 register tTree actual;
 register tTree formal;
 register int kind;
# endif
{
  if (formal->Kind == kSLICE_EXP) {
/* line 427 "Descriptor.puma" */
 {
  int idim;
  int tdim;
  int pdim;
  {
/* line 433 "Descriptor.puma" */
 idim = vard->formal_rank;   
     tdim = vard->template_rank;
     pdim = VarRank (vard->topology_obj);
 
     SetFormalShape (vard, idim, formal);
     SetActualShape (vard, idim, actual);

     vard->template_rank += 1;
     vard->template_obj = NoObject;
 
     vard->distribution_kind [idim] = kind;
     vard->distribution_size [idim] = 0;   
     vard->topology_dim[idim] = 0;
     vard->template_dim[idim] = tdim+1;
     vard->align_mult  [idim] = 1;
     vard->align_add   [idim] = 0;
 
     
 
     if (kind != kSERIAL_DIM)

       { vard->topology_dim[idim] = pdim + 1;
         vard->topology_rank += 1;

         if (vard->topology_rank > MAX_DIMENSIONS)

            { printf ("too many distributed dimensions, max = %d\n",
                       MAX_DIMENSIONS);
              failure_protocol (MODULE, "AddDescriptorDimension", NoTree);
            }

         vard->topology_obj  = GetDefaultTopology (vard->topology_rank);
         vard->on_index_dim[pdim] = idim + 1;
         vard->on_temp_dim [pdim] = idim + 1;
         vard->on_kind [pdim]     = kind;
         vard->on_val [pdim]      = actual;
         vard->on_range [pdim][0] = vard->formal_shape[idim][0];
         vard->on_range [pdim][1] = vard->formal_shape[idim][1];
       }

     vard->var_tree   = NoTree;   
     vard->reach_info = NoTree;   

   
  }
   return;
 }

  }
/* line 480 "Descriptor.puma" */
  {
/* line 482 "Descriptor.puma" */
   failure_protocol (MODULE, "AddDescriptorDimension", formal);
  }
   return;

;
}

static void SetFormalShape
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int dim, register tTree formal)
# else
(vard, dim, formal)
 pvar vard;
 register int dim;
 register tTree formal;
# endif
{
/* line 487 "Descriptor.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 489 "Descriptor.puma" */
   GetFormalSize (formal, & yyV1, & yyV2, & yyV3);
/* line 491 "Descriptor.puma" */
 vard->formal_rank ++;
      vard->formal_shape[dim][0] = yyV1;
      vard->formal_shape[dim][1] = yyV2;
      vard->alloc_shape[dim][0] = yyV1;
      vard->alloc_shape[dim][1] = yyV2;
    
  }
   return;
 }

;
}

static void GetFormalSize
# if defined __STDC__ | defined __cplusplus
(register tTree formal, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(formal, yyP3, yyP2, yyP1)
 register tTree formal;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (formal->Kind == kSLICE_EXP) {
/* line 501 "Descriptor.puma" */
   * yyP3 = formal->SLICE_EXP.FIRST;
   * yyP2 = formal->SLICE_EXP.STOP;
   * yyP1 = formal->SLICE_EXP.INC;
   return;

  }
  if (Tree_IsType (formal, kSHAPE_SPEC)) {
/* line 504 "Descriptor.puma" */
  {
/* line 506 "Descriptor.puma" */
   failure_protocol (MODULE, "GetFormalSize", formal);
  }
   * yyP3 = NoTree;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  }
;
}

static void SetActualShape
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int dim, register tTree actual)
# else
(vard, dim, actual)
 pvar vard;
 register int dim;
 register tTree actual;
# endif
{
  if (actual->Kind == kSLICE_EXP) {
/* line 511 "Descriptor.puma" */
  {
/* line 513 "Descriptor.puma" */
 vard->actual_rank ++;
      vard->actual_shape[dim][0] = actual->SLICE_EXP.FIRST;
      vard->actual_shape[dim][1] = actual->SLICE_EXP.STOP;
      vard->actual_shape[dim][2] = actual->SLICE_EXP.INC;
    
  }
   return;

  }
/* line 520 "Descriptor.puma" */
  {
/* line 522 "Descriptor.puma" */
 if (TreeRank (actual) == 1)
         vard->actual_rank ++;
      vard->actual_shape[dim][0] = actual;
      vard->actual_shape[dim][1] = actual;
      vard->actual_shape[dim][2] = NoTree;
    
  }
   return;

;
}

void MakeSliceDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard)
# else
(exp, vard)
 register tTree exp;
 pvar vard;
# endif
{
  if (exp->Kind == kSLICE_EXP) {
/* line 540 "Descriptor.puma" */
  {
/* line 542 "Descriptor.puma" */
   MakeReplicatedDescriptor (vard);
/* line 544 "Descriptor.puma" */

#ifdef DEBUG
     printf ("MakeSliceDescriptor (before) : \n");
     PrintVarDescriptor (vard);
#endif
   
/* line 551 "Descriptor.puma" */
 if (ddefault_kind == DDEFAULT_REPLICATED)
       AddDescriptorDimension (vard, exp, exp, kSERIAL_DIM);
      else
       AddDescriptorDimension (vard, exp, exp, kBLOCK_DIM);
   
/* line 557 "Descriptor.puma" */

#ifdef DEBUG
     printf ("MakeSliceDescriptor (after) : \n");
     PrintVarDescriptor (vard);
#endif
   
  }
   return;

  }
/* line 565 "Descriptor.puma" */
  {
/* line 566 "Descriptor.puma" */
   failure_protocol (MODULE, "MakeSliceDescriptor", exp);
  }
   return;

;
}

void MakeShapeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard)
# else
(exp, vard)
 register tTree exp;
 pvar vard;
# endif
{
  if (exp->Kind == kARRAY_EXP) {
/* line 580 "Descriptor.puma" */
  {
/* line 582 "Descriptor.puma" */
   MakeListShapeDescriptor (exp, vard);
  }
   return;

  }
/* line 585 "Descriptor.puma" */
 {
  tTree slice;
  {
/* line 589 "Descriptor.puma" */
   MakeReplicatedDescriptor (vard);
/* line 591 "Descriptor.puma" */
   slice = mSLICE_EXP (MakeConstant (1), exp, mDUMMY_EXP ());
/* line 593 "Descriptor.puma" */
   AddDescriptorDimension (vard, slice, slice, kSERIAL_DIM);
  }
   return;
 }

;
}

static void MakeListShapeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard)
# else
(exp, vard)
 register tTree exp;
 pvar vard;
# endif
{
 yyRecursion:
  if (exp->Kind == kARRAY_EXP) {
/* line 598 "Descriptor.puma" */
  {
/* line 600 "Descriptor.puma" */
   MakeReplicatedDescriptor (vard);
/* line 601 "Descriptor.puma" */
   exp = exp->ARRAY_EXP.ELEMENTS;
   goto yyRecursion;
  }

  }
  if (exp->Kind == kBTE_LIST) {
/* line 604 "Descriptor.puma" */
 {
  tTree slice;
  {
/* line 608 "Descriptor.puma" */
   slice = mSLICE_EXP (MakeConstant (1), exp->BTE_LIST.Elem, mDUMMY_EXP ());
/* line 610 "Descriptor.puma" */
   AddDescriptorDimension (vard, slice, slice, kSERIAL_DIM);
/* line 611 "Descriptor.puma" */
   exp = exp->BTE_LIST.Next;
   goto yyRecursion;
  }
 }

  }
  if (exp->Kind == kBTE_EMPTY) {
/* line 614 "Descriptor.puma" */
   return;

  }
;
}

void MakeLoopVarDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard)
# else
(exp, vard)
 register tTree exp;
 pvar vard;
# endif
{
  if (exp->Kind == kVAR_EXP) {
  if (exp->VAR_EXP.V->Kind == kLOOP_VAR) {
/* line 627 "Descriptor.puma" */
 {
  int i;
  {
/* line 629 "Descriptor.puma" */
   SetVarDescriptor (exp->VAR_EXP.V, vard);
/* line 633 "Descriptor.puma" */
 
 
     for (i=1; i<= OuterLoops(); i++)
 
       { tTree loop;
         int   kind;

         loop = GetOuterLoop (i);

         if (IsParallelLoop (loop))
            kind = kSERIAL_DIM;
           else 
            kind = kBLOCK_DIM;
 
         if (EqualExpression (exp->VAR_EXP.V, GetLoopId (loop)))
 
           AddDescriptorDimension (vard, exp, GetLoopSlice (loop), kind);
 
       } 

     vard->var_tree = NoTree;

   
  }
   return;
 }

  }
  }
/* line 658 "Descriptor.puma" */
  {
/* line 660 "Descriptor.puma" */
   failure_protocol (MODULE, "MakeLoopVarDescriptor", exp);
  }
   return;

;
}

static void CorrectTemplateDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 671 "Descriptor.puma" */
  {
/* line 673 "Descriptor.puma" */
 int topology_rank;
    int template_rank;
    int idim, kind;
    tTree size;

    

    template_rank = vard->formal_rank;

    vard->template_rank = template_rank;
    vard->template_obj  = NoObject;

    

    topology_rank = 0;

    for (idim = template_rank-1; idim >= 0; idim--)

       { kind = vard->distribution_kind[idim];
         if (kind != kSERIAL_DIM)
            { if (topology_rank < MAX_TORUS_RANK)
                 topology_rank++;
               else
                 kind = kSERIAL_DIM;
            }
         vard->distribution_kind[idim] = kind;
       } 

    topology_rank = 0;

    for (idim = 0; idim < template_rank; idim++)

       { vard->template_dim[idim] = idim+1;
         vard->formal_shape[idim][0] = vard->alloc_shape[idim][0];
         vard->formal_shape[idim][1] = vard->alloc_shape[idim][1];
         kind = vard->distribution_kind[idim];
         size = vard->distribution_size[idim];

         if (kind == kSERIAL_DIM)

            vard->topology_dim[idim] = 0;

          else if (topology_rank < MAX_TORUS_RANK)

            { int pdim = topology_rank++;
              vard->topology_dim[idim] = pdim + 1;
              vard->on_index_dim[pdim] = idim + 1;
              vard->on_temp_dim [pdim] = idim + 1;
              vard->on_kind [pdim]     = kind;
              vard->on_size [pdim]     = size;
              vard->on_val [pdim]      = NoTree;
              vard->on_range [pdim][0] = vard->formal_shape[idim][0];
              vard->on_range [pdim][1] = vard->formal_shape[idim][1];
            }

          else

            { printf ("too many distributed dimensions, max = %d\n",
                       MAX_TORUS_RANK);
              failure_protocol (MODULE, "CorrectTemplateDescriptor", NoTree);
            }

       } 

    vard->topology_rank = topology_rank;
    vard->topology_obj  = GetDefaultTopology (topology_rank);

  
  }
   return;

;
}

void ProductDescriptors
# if defined __STDC__ | defined __cplusplus
(pvar d1, pvar d2)
# else
(d1, d2)
 pvar d1;
 pvar d2;
# endif
{
/* line 756 "Descriptor.puma" */
  {
/* line 758 "Descriptor.puma" */
   if (! ((d2 -> formal_rank <= 0))) goto yyL1;
  }
   return;
yyL1:;

/* line 761 "Descriptor.puma" */
  {
/* line 763 "Descriptor.puma" */
   if (! ((d1 -> formal_rank <= 0))) goto yyL2;
  {
/* line 764 "Descriptor.puma" */
 *d1 = *d2; 
  }
  }
   return;
yyL2:;

/* line 767 "Descriptor.puma" */
  {
/* line 769 "Descriptor.puma" */
 int i, rank1, rank2;

#ifdef DEBUG
     printf ("product of two descriptors : \n");
     PrintVarDescriptor (d1);
     PrintVarDescriptor (d2);
#endif

     rank1 = d1->formal_rank;
     rank2 = d2->formal_rank;

     d1->formal_rank += d2->formal_rank;

     for (i=0; i<rank2; i++)
       { d1->formal_shape[rank1+i][0] = d2->formal_shape[i][0];
         d1->formal_shape[rank1+i][1] = d2->formal_shape[i][1];
         d1->alloc_shape[rank1+i][0]  = d2->alloc_shape[i][0];
         d1->alloc_shape[rank1+i][1]  = d2->alloc_shape[i][1];
         d1->actual_shape[rank1+i][0] = d2->actual_shape[i][0];
         d1->actual_shape[rank1+i][1] = d2->actual_shape[i][1];
         d1->actual_shape[rank1+i][2] = d2->actual_shape[i][2];
         d1->distribution_kind[rank1+i] = d2->distribution_kind[i];
         d1->distribution_size[rank1+i] = d2->distribution_size[i];
         d1->align_mult[rank1+i]        = d2->align_mult[i];
         d1->align_add[rank1+i]         = d2->align_add[i];
       }

     d1->actual_rank += d2->actual_rank;
     d1->formal_rank = rank1 + rank2;

     CorrectTemplateDescriptor (d1);

     d1->type_kind  = kDUMMY_TYPE;      

     d1->var_tree   = NoTree;           
     d1->var_obj    = NoObject;
     d1->reach_info = NoTree;           

#ifdef DEBUG
     printf ("-> result : \n");
     PrintVarDescriptor (d1);
#endif

   
  }
   return;

;
}

void CombineDescriptors
# if defined __STDC__ | defined __cplusplus
(pvar d1, pvar d2)
# else
(d1, d2)
 pvar d1;
 pvar d2;
# endif
{
/* line 836 "Descriptor.puma" */
  {
/* line 838 "Descriptor.puma" */
   if (! ((d1 -> actual_rank > 0))) goto yyL1;
  {
/* line 839 "Descriptor.puma" */
   if (! ((d2 -> actual_rank == 0))) goto yyL1;
  }
  }
   return;
yyL1:;

/* line 842 "Descriptor.puma" */
  {
/* line 844 "Descriptor.puma" */
   if (! ((d1 -> actual_rank == 0))) goto yyL2;
  {
/* line 845 "Descriptor.puma" */
   if (! ((d2 -> actual_rank > 0))) goto yyL2;
  {
/* line 847 "Descriptor.puma" */
 *d1 = *d2; 
  }
  }
  }
   return;
yyL2:;

/* line 850 "Descriptor.puma" */
  {
/* line 852 "Descriptor.puma" */
   if (! ((d2 -> var_tree == NoTree))) goto yyL3;
  }
   return;
yyL3:;

/* line 855 "Descriptor.puma" */
  {
/* line 857 "Descriptor.puma" */
   if (! ((d1 -> var_tree == NoTree))) goto yyL4;
  {
/* line 859 "Descriptor.puma" */
 *d1 = *d2; 
  }
  }
   return;
yyL4:;

/* line 862 "Descriptor.puma" */
  {
/* line 864 "Descriptor.puma" */
   if (! ((d2 -> topology_rank == 0))) goto yyL5;
  }
   return;
yyL5:;

/* line 867 "Descriptor.puma" */
  {
/* line 869 "Descriptor.puma" */
   if (! ((d1 -> topology_rank == 0))) goto yyL6;
  {
/* line 871 "Descriptor.puma" */
 *d1 = *d2; 
  }
  }
   return;
yyL6:;

;
}

void ExpandDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar d, register tTree loopid, register rbool * yyP4)
# else
(d, loopid, yyP4)
 pvar d;
 register tTree loopid;
 register rbool * yyP4;
# endif
{
/* line 891 "Descriptor.puma" */
  {
/* line 893 "Descriptor.puma" */
   if (! ((IsNoDescriptor (d)))) goto yyL1;
  }
   * yyP4 = rtrue;
   return;
yyL1:;

/* line 896 "Descriptor.puma" */
  {
/* line 898 "Descriptor.puma" */
   if (! ((IsReplicatedDescriptor (d)))) goto yyL2;
  }
   * yyP4 = rtrue;
   return;
yyL2:;

/* line 901 "Descriptor.puma" */
  {
/* line 905 "Descriptor.puma" */
   if (! ((IsHostDescriptor (d)))) goto yyL3;
  }
   * yyP4 = rtrue;
   return;
yyL3:;

/* line 908 "Descriptor.puma" */
 {
  rbool okay;
  {
/* line 912 "Descriptor.puma" */
 int i, rank;

     okay = rtrue;

#ifdef DEBUG
     printf ("expand the descriptor for ");
     FileUnparse (stdout, loopid); printf ("\n");
     PrintVarDescriptor (d);
#endif 

     rank = d->formal_rank;

     for (i=1; i<=rank; i++)

       if (ActualIsDependent (d, i, loopid))

         { ExpandDescriptorDimension (d, i);

           if (ActualIsDependent (d, i, loopid))    
              okay = rfalse;

         } 

#ifdef DEBUG
     printf ("result of expansion : (okay = %d) ", okay);
     PrintVarDescriptor (d);
#endif 

   
  }
   * yyP4 = okay;
   return;
 }

;
}

int FindDescriptorDim
# if defined __STDC__ | defined __cplusplus
(pvar d, register tTree loopid)
# else
(d, loopid)
 pvar d;
 register tTree loopid;
# endif
{
/* line 945 "Descriptor.puma" */
 {
  int dim;
  {
/* line 949 "Descriptor.puma" */
 int idim, rank;

     dim = 0;                     
     rank = d->formal_rank;

     for (idim=1; idim<=rank; idim++)

        { if (ActualIsDependent (d, idim, loopid))
             
              dim = idim;
        }

   
  }
   return dim;
 }

}

static rbool ActualIsDependent
# if defined __STDC__ | defined __cplusplus
(pvar d, register int dim, register tTree loopid)
# else
(d, dim, loopid)
 pvar d;
 register int dim;
 register tTree loopid;
# endif
{
/* line 968 "Descriptor.puma" */
  {
/* line 970 "Descriptor.puma" */
   if (! ((d -> actual_shape [dim - 1] [0] == NoTree))) goto yyL1;
  {
/* line 972 "Descriptor.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 975 "Descriptor.puma" */
  {
/* line 977 "Descriptor.puma" */
   if (! ((IsSelector (d->actual_shape[dim-1][0])))) goto yyL2;
  {
/* line 979 "Descriptor.puma" */
   return rfalse;
  }
  }
yyL2:;

/* line 982 "Descriptor.puma" */
 {
  rbool is;
  {
/* line 986 "Descriptor.puma" */
 tTree lb, ub, inc;
     tIdent name;

     name = TreeVarName (loopid);

     lb  = d->actual_shape[dim-1][0];
     ub  = d->actual_shape[dim-1][1];
     inc = d->actual_shape[dim-1][2];

     is =  IsVarInExp (name, lb) || IsVarInExp (name, ub);

     if (!IsStride1 (inc))

        is = is || IsVarInExp (name, inc);
 
   
/* line 1003 "Descriptor.puma" */
   if (! ((is))) goto yyL3;
  }
   return rtrue;
 }
yyL3:;

  return rfalse;
}

void RedVarDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int dim)
# else
(vard, dim)
 pvar vard;
 register int dim;
# endif
{
/* line 1017 "Descriptor.puma" */
 {
  int index_dim;
  {
/* line 1021 "Descriptor.puma" */
 

     index_dim = GetFormalDim (vard, dim);

#ifdef DEBUG
     printf ("make RedVarDescriptor, dim = %d, index_dim = %d\n",
              dim, index_dim);
     PrintVarDescriptor (vard);
#endif

     RemDimDescriptor (vard, index_dim);

   
  }
   return;
 }

;
}

void RemDimDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int index_dim)
# else
(vard, index_dim)
 pvar vard;
 register int index_dim;
# endif
{
/* line 1038 "Descriptor.puma" */
 {
  int i;
  int rank;
  tTree index_lb;
  tTree index_ub;
  int act_rank;
  {
/* line 1046 "Descriptor.puma" */
 
 
#ifdef DEBUG
     printf ("RemDimDescriptor, index_dim = %d\n", index_dim);
#endif

     index_lb = vard->actual_shape[index_dim-1][0];
     index_ub = vard->actual_shape[index_dim-1][1];

     if (index_lb != index_ub)
        act_rank = 1;
      else if (TreeRank(index_lb) == 1)
        act_rank = 1;
      else
        act_rank = 0;

     rank      = vard->formal_rank;
 
     

     for (i=index_dim+1; i <= rank; i++)
 
        MoveIndexData (vard, i, i-1);  
 
      rank = vard->topology_rank;
 
      for (i=0; i < rank; i++)
 
        { if (vard->on_index_dim[i] > index_dim)
 
             vard->on_index_dim[i] -= 1;
 
           else if (vard->on_index_dim[i] == index_dim)
 
             { vard->on_index_dim[i] = 0;             
               vard->on_val[i] = NoTree;
             }
        }
 
      vard->formal_rank -= 1;
      vard->actual_rank -= act_rank;

      vard->var_tree = NoTree;  
      vard->var_obj  = NoObject;
   
  }
   return;
 }

;
}

void MakeRepArray1Descriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int size)
# else
(vard, size)
 pvar vard;
 register int size;
# endif
{
/* line 1104 "Descriptor.puma" */
  {
/* line 1106 "Descriptor.puma" */
   MakeReplicatedDescriptor (vard);
/* line 1107 "Descriptor.puma" */
   MakeNewSerialDim (vard, 1, MakeConstant (size));
  }
   return;

;
}

static void MakeNewSerialDim
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int dim, register tTree exp)
# else
(vard, dim, exp)
 pvar vard;
 register int dim;
 register tTree exp;
# endif
{
/* line 1112 "Descriptor.puma" */
  {
/* line 1114 "Descriptor.puma" */
  int i, rank;

      

      rank = vard->formal_rank;

#ifdef DEBUG
      printf ("MakeNewSerialDim, dim = %d, rank = %d\n", dim, rank);
      PrintVarDescriptor (vard);
#endif

     

      for (i=rank; i >= dim; i--)         
          MoveIndexData (vard, i, i+1);   

      vard->actual_shape[dim-1][0] = MakeConstant (1);
      vard->actual_shape[dim-1][1] = exp;
      vard->actual_shape[dim-1][2] = NoTree;

      vard->formal_shape[dim-1][0] = vard->actual_shape[dim-1][0];
      vard->formal_shape[dim-1][1] = vard->actual_shape[dim-1][1];

      vard->alloc_shape[dim-1][0] = vard->formal_shape[dim-1][0];
      vard->alloc_shape[dim-1][1] = vard->formal_shape[dim-1][1];

      vard->shadow[dim-1][0] = 0;
      vard->shadow[dim-1][1] = 0;
 
      vard->distribution_kind[dim-1] = kSERIAL_DIM;
      vard->distribution_size[dim-1] = 0;
      vard->align_mult[dim-1] = 1;
      vard->align_add[dim-1] = 1;
      vard->template_dim[dim-1] = 0;

      vard->formal_rank += 1;
      vard->actual_rank += 1;

      vard->var_tree = NoTree;     

      

      rank = vard->topology_rank;

      for (i=0; i < rank; i++)
        if (vard->on_index_dim[i] >= dim)
             vard->on_index_dim[i] += 1;

#ifdef DEBUG
      printf ("MakeNewSerialDim, new descriptor = \n");
      PrintVarDescriptor (vard);
#endif

   
  }
   return;

;
}

static void MoveIndexData
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int old_dim, register int new_dim)
# else
(vard, old_dim, new_dim)
 pvar vard;
 register int old_dim;
 register int new_dim;
# endif
{
/* line 1175 "Descriptor.puma" */
 {
  int new;
  int old;
  {
/* line 1180 "Descriptor.puma" */
 old = old_dim - 1; new = new_dim - 1;

    vard->formal_shape[new][0] = vard->formal_shape[old][0];
    vard->formal_shape[new][1] = vard->formal_shape[old][1];

    vard->actual_shape[new][0] = vard->actual_shape[old][0];
    vard->actual_shape[new][1] = vard->actual_shape[old][1];
    vard->actual_shape[new][2] = vard->actual_shape[old][2];

    vard->alloc_shape [new][0] = vard->alloc_shape [old][0];
    vard->alloc_shape [new][1] = vard->alloc_shape [old][1];

    vard->shadow     [new][0] = vard->shadow     [old][0];
    vard->shadow     [new][1] = vard->shadow     [old][1];

    vard->distribution_kind[new] = vard->distribution_kind[old];
    vard->distribution_size[new] = vard->distribution_size[old];

    vard->template_dim[new] = vard->template_dim[old];
    vard->align_mult  [new] = vard->align_mult  [old];
    vard->align_add   [new] = vard->align_add   [old];
    vard->topology_dim[new] = vard->topology_dim[old];

  
  }
   return;
 }

;
}

static void SwitchIndexData
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int index_dim1, register int index_dim2)
# else
(vard, index_dim1, index_dim2)
 pvar vard;
 register int index_dim1;
 register int index_dim2;
# endif
{
/* line 1208 "Descriptor.puma" */
  {
/* line 1210 "Descriptor.puma" */
 int dim1, dim2;

    dim1 = index_dim1 - 1; dim2 = index_dim2 - 1;

    switch_tree (vard->formal_shape[dim1]+0, vard->formal_shape[dim2]+0);
    switch_tree (vard->formal_shape[dim1]+1, vard->formal_shape[dim2]+1);

    switch_tree (vard->actual_shape[dim1]+0, vard->actual_shape[dim2]+0);
    switch_tree (vard->actual_shape[dim1]+1, vard->actual_shape[dim2]+1);

    switch_tree (vard->alloc_shape[dim1]+0, vard->alloc_shape[dim2]+0);
    switch_tree (vard->alloc_shape[dim1]+1, vard->alloc_shape[dim2]+1);
    switch_tree (vard->alloc_shape[dim1]+2, vard->alloc_shape[dim2]+2);

    switch_int (vard->shadow[dim1]+0, vard->shadow[dim2]+0);
    switch_int (vard->shadow[dim1]+1, vard->shadow[dim2]+1);

    switch_int (vard->distribution_kind+dim1, vard->distribution_kind+dim2);
    switch_int (vard->distribution_size+dim1, vard->distribution_size+dim2);
    switch_int (vard->template_dim+dim1, vard->template_dim+dim2);
    switch_int (vard->align_mult  +dim1, vard->align_mult  +dim2);
    switch_int (vard->align_add   +dim1, vard->align_add   +dim2);
    switch_int (vard->topology_dim+dim1, vard->topology_dim+dim2);

  
  }
   return;

;
}

void TransposeDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 1247 "Descriptor.puma" */
 {
  int index_dim1;
  int index_dim2;
  {
/* line 1252 "Descriptor.puma" */
 if (vard->actual_rank != 2)
        failure_protocol (MODULE, "TransposeDescriptor", vard->var_tree);
   
/* line 1257 "Descriptor.puma" */
 index_dim1 = GetFormalDim (vard, 1);
     index_dim2 = GetFormalDim (vard, 2);
     SwitchDimDescriptor (vard, index_dim1, index_dim2);
   
  }
   return;
 }

;
}

static void SwitchDimDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int idim1, register int idim2)
# else
(vard, idim1, idim2)
 pvar vard;
 register int idim1;
 register int idim2;
# endif
{
/* line 1265 "Descriptor.puma" */
  {
/* line 1267 "Descriptor.puma" */
 int i, rank;

     SwitchIndexData (vard, idim1, idim2);

     

     rank = vard->topology_rank;

     for (i=0; i < rank; i++)

      { if (vard->on_index_dim[i] == idim1)

          vard->on_index_dim[i] = idim2;

        if (vard->on_index_dim[i] == idim2)

          vard->on_index_dim[i] = idim1;

      } 

   
  }
   return;

;
}

void SpreadVarDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int dim, register tTree ncopies)
# else
(vard, dim, ncopies)
 pvar vard;
 register int dim;
 register tTree ncopies;
# endif
{
/* line 1304 "Descriptor.puma" */
 {
  int i;
  int rank;
  int index_dim;
  {
/* line 1310 "Descriptor.puma" */
 

     rank  = vard->actual_rank;

     

     if (dim <= rank)
        index_dim = GetFormalDim (vard, dim);
       else
        index_dim = vard->formal_rank + 1;

      

      MakeNewSerialDim (vard, index_dim, VarParamToExp (ncopies));

   
  }
   return;
 }

;
}

rbool SameDescriptorTopology
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2)
# else
(vard1, vard2)
 pvar vard1;
 pvar vard2;
# endif
{
/* line 1342 "Descriptor.puma" */
  {
/* line 1344 "Descriptor.puma" */
   if (! ((IsNoDescriptor (vard1) || IsNoDescriptor (vard2)))) goto yyL1;
  {
/* line 1345 "Descriptor.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 1348 "Descriptor.puma" */
  {
/* line 1350 "Descriptor.puma" */
   if (! ((SameTopologyObject (vard1 -> topology_obj, vard2 -> topology_obj)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 1353 "Descriptor.puma" */
  {
/* line 1355 "Descriptor.puma" */
   if (! ((vard1 -> template_obj != NoObject))) goto yyL3;
  {
/* line 1356 "Descriptor.puma" */
   if (! ((vard1 -> template_obj == vard2 -> template_obj))) goto yyL3;
  {
/* line 1358 "Descriptor.puma" */

#ifdef DEBUG
      printf ("descriptors use same template (but not same topology)\n");
      PrintVarDescriptor (vard1);
      PrintVarDescriptor (vard2);
#endif
    
  }
  }
  }
   return rtrue;
yyL3:;

  return rfalse;
}

tTree PrintableDescriptorVar
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 1375 "Descriptor.puma" */
  {
/* line 1377 "Descriptor.puma" */
   if (! ((IsNoDescriptor (vard)))) goto yyL1;
  }
   return mUSED_VAR (mVAR_OBJ (0, MakeIdent ("$FREE", 5)));
yyL1:;

/* line 1382 "Descriptor.puma" */
  {
/* line 1384 "Descriptor.puma" */
   if (! ((IsReplicatedDescriptor (vard)))) goto yyL2;
  {
/* line 1385 "Descriptor.puma" */
   if (! ((vard -> formal_rank == 0))) goto yyL2;
  }
  }
   return mUSED_VAR (mVAR_OBJ (0, MakeIdent ("$ALL", 4)));
yyL2:;

/* line 1390 "Descriptor.puma" */
  {
/* line 1392 "Descriptor.puma" */
   if (! ((IsHostDescriptor (vard)))) goto yyL3;
  }
   return mUSED_VAR (mVAR_OBJ (0, MakeIdent ("$HOST", 5)));
yyL3:;

/* line 1397 "Descriptor.puma" */
   return MakeDescriptorVar (vard);

}

void BeginDescriptor ARGS ((void))
{
}

void CloseDescriptor ARGS ((void))
{
}
