# include "Dependences.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 63 "Dependences.puma" */


# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Unparse.h"       /* FileUnparse, only DEBUG mode */

# include "Invariant.h"     /* is var in _exp */
# include "Rank.h"
# include "TreeOps.h"
# include "Expressions.h"

# define MODULE "Dependences"

# undef DEBUG



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyDependences.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Dependences_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Dependences, routine %s failed\n",
  yyFunction);
 Dependences_Exit ();
}

void Dependences ARGS ((tTree e1, ptree loops1, int n1, tTree e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, ptree params, int np, pPredVector p));
static void GetCommonVarStructure ARGS ((tTree v1, tTree v2, tTree * yyP2, tTree * yyP1));
static void Dependences1 ARGS ((tTree e1, ptree loops1, int n1, tTree e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, pPredVector p));
static void IndexCompare ARGS ((tTree e1, ptree loops1, int n1, tTree e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, pPredVector p));
static void Index1Compare ARGS ((tTree index1, ptree loops1, int n1, tTree index2, ptree loops2, int n2, int CommonLoops, int ConstLoops, pPredVector p));
static void GetExpNormalization ARGS ((tTree e, ptree loops, int n, rbool * yyP4, ExpNormRecord * yyP3));
static void CheckDifferentIndex ARGS ((tTree e1, ptree loops1, int n1, tTree e2, ptree loops2, int n2, pPredVector p));
static rbool LoopIndependentExpression ARGS ((tTree exp, ptree loops, int n));
static rbool LoopVariant ARGS ((tTree exp, tTree loop));
static void CheckDifferentModulo ARGS ((tTree e1, tTree e2, pPredVector p));
static void FindMultiplicator ARGS ((tTree e, rbool * yyP7, int * yyP6, int * yyP5));
static void BuildModulo ARGS ((int a, int c, int * yyP8));
static void GCD ARGS ((int x1, int x2, int * yyP9));
static void CheckEqualIndex ARGS ((tTree e1, ptree loops1, int n1, tTree e2, ptree loops2, int n2, int ConstLoops, pPredVector p));
static void GetLoopPos ARGS ((tTree v, ptree loops, int n, rbool * yyP11, int * yyP10));
static void ExpCompare ARGS ((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, pPredVector p));
static void DeltaCheck ARGS ((ExpNormRecord e, ptree loops, int n, rbool flow, int low, rbool fup, int up, int ConstLoops, pPredVector p));
static void MakeDelta ARGS ((ExpNormRecord e, ptree loops, int n, int ConstLoops, pPredVector p, rbool * yyP15, int * yyP14, int * yyP13, int * yyP12));
static void MakeNewPred ARGS ((int delta, int pos, int val, rbool flow, int low, rbool fup, int up, pPredVector p));
static tTree MyGetLoopVar ARGS ((tTree loop));

void Dependences
# if defined __STDC__ | defined __cplusplus
(register tTree e1, ptree loops1, register int n1, register tTree e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, ptree params, register int np, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, params, np, p)
 register tTree e1;
 ptree loops1;
 register int n1;
 register tTree e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 ptree params;
 register int np;
 pPredVector p;
# endif
{
/* line 113 "Dependences.puma" */

char PVString [100];
int  i;

/* line 118 "Dependences.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 120 "Dependences.puma" */
   GetCommonVarStructure (e1, e2, & yyV1, & yyV2);
/* line 122 "Dependences.puma" */
 

# ifdef DEBUG
   printf ("Call of Dependences (common loops = %d, const = %d, params = %d)\n",
            CommonLoops, ConstLoops, np);
   printf ("e1 = "); FileUnparse (stdout, e1); printf (" in %d loops\n", n1);
   printf ("e2 = "); FileUnparse (stdout, e2); printf (" in %d loops\n", n2);
   printf ("v1 = "); FileUnparse (stdout, yyV1); 
   printf (", v2 = "); FileUnparse (stdout, yyV2); printf ("\n");

   if (np > 0)
    { printf ("Parameters : ", np);
      for (i=0; i<np; i++) { FileUnparse (stdout, params[i]); printf (" "); }
      printf ("\n");
    }
   strcpy (PVString,""); PVOut (PVString, p);
   printf ("Dependences : Predicate = %s\n", PVString);
# endif 

   if (np == 0)

      Dependences1 (yyV1, loops1, n1, yyV2, loops2, n2,
                    CommonLoops, ConstLoops, p);

    else 

      { tTree hloops1 [100];
        tTree hloops2 [100];

        int i;

        for (i=0; i<np; i++) { hloops1 [i] = params[i];
                               hloops2 [i] = params[i];
                             }

        for (i=0; i<n1; i++) hloops1 [np+i] = loops1[i];
        for (i=0; i<n2; i++) hloops2 [np+i] = loops2[i];

        Dependences1 (yyV1, loops1, n1, yyV2, loops2, n2,
                      CommonLoops, ConstLoops, p);

      }

#ifdef DEBUG
     strcpy (PVString,""); PVOut (PVString, p);
     printf ("Dependences : ResultPredicate = %s\n", PVString);
#endif 
  
  }
   return;
 }

;
}

static void GetCommonVarStructure
# if defined __STDC__ | defined __cplusplus
(register tTree v1, register tTree v2, register tTree * yyP2, register tTree * yyP1)
# else
(v1, v2, yyP2, yyP1)
 register tTree v1;
 register tTree v2;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (v1->Kind == kVAR_OBJ) {
  if (v2->Kind == kVAR_OBJ) {
/* line 179 "Dependences.puma" */
   * yyP2 = v1;
   * yyP1 = v2;
   return;

  }
  }
  if (v1->Kind == kUSED_VAR) {
  if (v2->Kind == kUSED_VAR) {
/* line 181 "Dependences.puma" */
   * yyP2 = v1;
   * yyP1 = v2;
   return;

  }
  if (v2->Kind == kLOOP_VAR) {
/* line 185 "Dependences.puma" */
   * yyP2 = v1->USED_VAR.VARNAME;
   * yyP1 = v2->LOOP_VAR.LOOP_VARNAME;
   return;

  }
  }
  if (v1->Kind == kLOOP_VAR) {
  if (v2->Kind == kLOOP_VAR) {
/* line 183 "Dependences.puma" */
   * yyP2 = v1;
   * yyP1 = v2;
   return;

  }
  if (v2->Kind == kUSED_VAR) {
/* line 187 "Dependences.puma" */
   * yyP2 = v1->LOOP_VAR.LOOP_VARNAME;
   * yyP1 = v2->USED_VAR.VARNAME;
   return;

  }
  }
  if (v1->Kind == kINDEXED_VAR) {
  if (v2->Kind == kINDEXED_VAR) {
/* line 189 "Dependences.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 191 "Dependences.puma" */
   GetCommonVarStructure (v1->INDEXED_VAR.IND_VAR, v2->INDEXED_VAR.IND_VAR, & yyV1, & yyV2);
/* line 193 "Dependences.puma" */
   if (! ((v1->INDEXED_VAR.IND_VAR == yyV1))) goto yyL6;
  {
/* line 194 "Dependences.puma" */
   if (! ((v2->INDEXED_VAR.IND_VAR == yyV2))) goto yyL6;
  }
  }
   * yyP2 = v1;
   * yyP1 = v2;
   return;
 }
yyL6:;

  }
/* line 213 "Dependences.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 215 "Dependences.puma" */
   GetCommonVarStructure (v1->INDEXED_VAR.IND_VAR, v2, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (v1->Kind == kSELECTED_VAR) {
  if (v2->Kind == kSELECTED_VAR) {
/* line 197 "Dependences.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 199 "Dependences.puma" */
   GetCommonVarStructure (v1->SELECTED_VAR.SELEC_VAR, v2->SELECTED_VAR.SELEC_VAR, & yyV1, & yyV2);
/* line 201 "Dependences.puma" */
   if (! ((v1->SELECTED_VAR.SELEC_VAR == yyV1))) goto yyL7;
  {
/* line 202 "Dependences.puma" */
   if (! ((v2->SELECTED_VAR.SELEC_VAR == yyV2))) goto yyL7;
  }
  }
   * yyP2 = v1;
   * yyP1 = v2;
   return;
 }
yyL7:;

  }
  }
  if (v1->Kind == kSUBSTRING_VAR) {
  if (v2->Kind == kSUBSTRING_VAR) {
/* line 205 "Dependences.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 207 "Dependences.puma" */
   GetCommonVarStructure (v1->SUBSTRING_VAR.IND_VAR, v2->SUBSTRING_VAR.IND_VAR, & yyV1, & yyV2);
/* line 209 "Dependences.puma" */
   if (! ((v1->SUBSTRING_VAR.IND_VAR == yyV1))) goto yyL8;
  {
/* line 210 "Dependences.puma" */
   if (! ((v2->SUBSTRING_VAR.IND_VAR == yyV2))) goto yyL8;
  }
  }
   * yyP2 = v1;
   * yyP1 = v2;
   return;
 }
yyL8:;

  }
  }
  if (v2->Kind == kINDEXED_VAR) {
/* line 218 "Dependences.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 220 "Dependences.puma" */
   GetCommonVarStructure (v1, v2->INDEXED_VAR.IND_VAR, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (v1->Kind == kSELECTED_VAR) {
/* line 223 "Dependences.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 225 "Dependences.puma" */
   GetCommonVarStructure (v1->SELECTED_VAR.SELEC_VAR, v2, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (v2->Kind == kSELECTED_VAR) {
/* line 228 "Dependences.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 230 "Dependences.puma" */
   GetCommonVarStructure (v1, v2->SELECTED_VAR.SELEC_VAR, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (v1->Kind == kSUBSTRING_VAR) {
/* line 233 "Dependences.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 235 "Dependences.puma" */
   GetCommonVarStructure (v1->SUBSTRING_VAR.IND_VAR, v2, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (v2->Kind == kSUBSTRING_VAR) {
/* line 238 "Dependences.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 240 "Dependences.puma" */
   GetCommonVarStructure (v1, v2->SUBSTRING_VAR.IND_VAR, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
/* line 243 "Dependences.puma" */
  {
/* line 245 "Dependences.puma" */
   failure2_protocol (MODULE, "GetCommonVarStrcture", v1, v2);
  }
   * yyP2 = v1;
   * yyP1 = v2;
   return;

;
}

static void Dependences1
# if defined __STDC__ | defined __cplusplus
(register tTree e1, ptree loops1, register int n1, register tTree e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, p)
 register tTree e1;
 ptree loops1;
 register int n1;
 register tTree e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 pPredVector p;
# endif
{
/* line 262 "Dependences.puma" */

char PVString [100];
int  i;

 yyRecursion:
  if (e1->Kind == kVAR_OBJ) {
  if (e2->Kind == kVAR_OBJ) {
/* line 267 "Dependences.puma" */
  {
/* line 270 "Dependences.puma" */
   if ((e1->VAR_OBJ.Ident != e2->VAR_OBJ.Ident)) {
/* line 272 "Dependences.puma" */
   PVSetFalse (p);
   }
  }
   return;

  }
  }
  if (e1->Kind == kUSED_VAR) {
  if (e2->Kind == kUSED_VAR) {
/* line 277 "Dependences.puma" */
  {
/* line 280 "Dependences.puma" */
   e1 = e1->USED_VAR.VARNAME;
   e2 = e2->USED_VAR.VARNAME;
   goto yyRecursion;
  }

  }
  }
  if (e1->Kind == kLOOP_VAR) {
  if (e2->Kind == kLOOP_VAR) {
/* line 284 "Dependences.puma" */
  {
/* line 287 "Dependences.puma" */
   e1 = e1->LOOP_VAR.LOOP_VARNAME;
   e2 = e2->LOOP_VAR.LOOP_VARNAME;
   goto yyRecursion;
  }

  }
  }
  if (e1->Kind == kSELECTED_VAR) {
  if (e2->Kind == kSELECTED_VAR) {
/* line 291 "Dependences.puma" */
  {
/* line 295 "Dependences.puma" */
   if ((e1->SELECTED_VAR.SELECTOR->REC_COMP.Object == e2->SELECTED_VAR.SELECTOR->REC_COMP.Object)) {
/* line 297 "Dependences.puma" */
   Dependences1 (e1->SELECTED_VAR.SELEC_VAR, loops1, n1, e2->SELECTED_VAR.SELEC_VAR, loops2, n2, CommonLoops, ConstLoops, p);
   } else {
/* line 302 "Dependences.puma" */
   PVSetFalse (p);
   }
  }
   return;

  }
  }
  if (e1->Kind == kINDEXED_VAR) {
  if (e2->Kind == kINDEXED_VAR) {
/* line 307 "Dependences.puma" */
  {
/* line 311 "Dependences.puma" */
   Dependences1 (e1->INDEXED_VAR.IND_VAR, loops1, n1, e2->INDEXED_VAR.IND_VAR, loops2, n2, CommonLoops, ConstLoops, p);
/* line 314 "Dependences.puma" */
   if ((! PVIsFalse (p))) {
/* line 316 "Dependences.puma" */
   IndexCompare (e1->INDEXED_VAR.IND_EXPS, loops1, n1, e2->INDEXED_VAR.IND_EXPS, loops2, n2, CommonLoops, ConstLoops, p);
   }
  }
   return;

  }
  }
  if (e1->Kind == kSUBSTRING_VAR) {
  if (e2->Kind == kSUBSTRING_VAR) {
/* line 322 "Dependences.puma" */
  {
/* line 326 "Dependences.puma" */
   Dependences1 (e1->SUBSTRING_VAR.IND_VAR, loops1, n1, e2->SUBSTRING_VAR.IND_VAR, loops2, n2, CommonLoops, ConstLoops, p);
/* line 329 "Dependences.puma" */
   if ((! PVIsFalse (p))) {
/* line 331 "Dependences.puma" */
   Index1Compare (e1->SUBSTRING_VAR.IND_EXP, loops1, n1, e2->SUBSTRING_VAR.IND_EXP, loops2, n2, CommonLoops, ConstLoops, p);
   }
  }
   return;

  }
  }
/* line 337 "Dependences.puma" */
  {
/* line 339 "Dependences.puma" */
   failure2_protocol (MODULE, "Dependences1", e1, e2);
  }
   return;

;
}

static void IndexCompare
# if defined __STDC__ | defined __cplusplus
(register tTree e1, ptree loops1, register int n1, register tTree e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, p)
 register tTree e1;
 ptree loops1;
 register int n1;
 register tTree e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 pPredVector p;
# endif
{
/* line 360 "Dependences.puma" */

char PVString[100];

  if (e1->Kind == kBTE_LIST) {
  if (e2->Kind == kBTE_LIST) {
/* line 364 "Dependences.puma" */
  {
/* line 369 "Dependences.puma" */
   IndexCompare (e1->BTE_LIST.Next, loops1, n1, e2->BTE_LIST.Next, loops2, n2, CommonLoops, ConstLoops, p);
/* line 372 "Dependences.puma" */
   if (! ((! PVIsFalse (p)))) goto yyL1;
  {
/* line 374 "Dependences.puma" */
   Index1Compare (e1->BTE_LIST.Elem, loops1, n1, e2->BTE_LIST.Elem, loops2, n2, CommonLoops, ConstLoops, p);
  }
  }
   return;
yyL1:;

/* line 378 "Dependences.puma" */
   return;

  }
  }
  if (e1->Kind == kBTE_EMPTY) {
  if (e2->Kind == kBTE_EMPTY) {
/* line 384 "Dependences.puma" */
   return;

  }
  }
/* line 388 "Dependences.puma" */
  {
/* line 390 "Dependences.puma" */
   failure2_protocol (MODULE, "IndexCompare", e1, e2);
  }
   return;

;
}

static void Index1Compare
# if defined __STDC__ | defined __cplusplus
(register tTree index1, ptree loops1, register int n1, register tTree index2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, pPredVector p)
# else
(index1, loops1, n1, index2, loops2, n2, CommonLoops, ConstLoops, p)
 register tTree index1;
 ptree loops1;
 register int n1;
 register tTree index2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 pPredVector p;
# endif
{
/* line 411 "Dependences.puma" */

char PVString[100];

/* line 415 "Dependences.puma" */
 {
  rbool yyV1;
  ExpNormRecord yyV2;
  rbool yyV3;
  ExpNormRecord yyV4;
  {
/* line 417 "Dependences.puma" */

#ifdef DEBUG 
     printf ("compare indexes ");
     FileUnparse (stdout, index1);
     printf (" and ");
     FileUnparse (stdout, index2);
     printf ("\n");
#endif
    
/* line 429 "Dependences.puma" */
   CheckDifferentIndex (index1, loops1, n1, index2, loops2, n2, p);
/* line 430 "Dependences.puma" */
   if (! ((! PVIsFalse (p)))) goto yyL1;
  {
/* line 432 "Dependences.puma" */
   CheckDifferentModulo (index1, index2, p);
/* line 433 "Dependences.puma" */
   if (! ((! PVIsFalse (p)))) goto yyL1;
  {
/* line 435 "Dependences.puma" */
   CheckEqualIndex (index1, loops1, n1, index2, loops2, n2, ConstLoops, p);
/* line 438 "Dependences.puma" */
   if (! ((! PVIsFalse (p)))) goto yyL1;
  {
/* line 442 "Dependences.puma" */
   GetExpNormalization (index1, loops1, n1, & yyV1, & yyV2);
/* line 443 "Dependences.puma" */
   if (! ((yyV1))) goto yyL1;
  {
/* line 445 "Dependences.puma" */
   GetExpNormalization (index2, loops2, n2, & yyV3, & yyV4);
/* line 446 "Dependences.puma" */
   if (! ((yyV3))) goto yyL1;
  {
/* line 450 "Dependences.puma" */
   ExpCompare (yyV2, loops1, n1, yyV4, loops2, n2, CommonLoops, ConstLoops, p);
  }
  }
  }
  }
  }
  }
   return;
 }
yyL1:;

;
}

static void GetExpNormalization
# if defined __STDC__ | defined __cplusplus
(register tTree e, ptree loops, register int n, register rbool * yyP4, ExpNormRecord * yyP3)
# else
(e, loops, n, yyP4, yyP3)
 register tTree e;
 ptree loops;
 register int n;
 register rbool * yyP4;
 ExpNormRecord * yyP3;
# endif
{
/* line 465 "Dependences.puma" */
 {
  rbool found;
  ExpNormRecord en;
  {
/* line 470 "Dependences.puma" */
   ExpNormal (e, loops, n, & found, & en);
  }
   * yyP4 = found;
   * yyP3 = en;
   return;
 }

;
}

static void CheckDifferentIndex
# if defined __STDC__ | defined __cplusplus
(register tTree e1, ptree loops1, register int n1, register tTree e2, ptree loops2, register int n2, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, p)
 register tTree e1;
 ptree loops1;
 register int n1;
 register tTree e2;
 ptree loops2;
 register int n2;
 pPredVector p;
# endif
{
/* line 486 "Dependences.puma" */
 {
  rbool found;
  int val;
  {
/* line 490 "Dependences.puma" */
   if (! ((TreeRank (e1) == 0))) goto yyL1;
  {
/* line 491 "Dependences.puma" */
   if (! ((TreeRank (e2) == 0))) goto yyL1;
  {
/* line 493 "Dependences.puma" */
   if (! ((LoopIndependentExpression (e1, loops1, n1)))) goto yyL1;
  {
/* line 494 "Dependences.puma" */
   if (! ((LoopIndependentExpression (e2, loops2, n2)))) goto yyL1;
  {
/* line 499 "Dependences.puma" */
   GetConstDifference (e1, e2, & found, & val);
/* line 500 "Dependences.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 501 "Dependences.puma" */
   if (! ((val != 0))) goto yyL1;
  {
/* line 503 "Dependences.puma" */

#ifdef DEBUG
   printf ("index expression have constant difference : %d\n", val);
#endif 
  
/* line 509 "Dependences.puma" */
   PVSetFalse (p);
  }
  }
  }
  }
  }
  }
  }
   return;
 }
yyL1:;

;
}

static rbool LoopIndependentExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp, ptree loops, register int n)
# else
(exp, loops, n)
 register tTree exp;
 ptree loops;
 register int n;
# endif
{
/* line 522 "Dependences.puma" */
 {
  rbool ok;
  int i;
  {
/* line 527 "Dependences.puma" */
 ok = rtrue;
    for (i= 0; i<n; i++)
        if (LoopVariant (exp, loops[i]))
           ok = rfalse;
  
/* line 532 "Dependences.puma" */
   if (! ((ok))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static rbool LoopVariant
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree loop)
# else
(exp, loop)
 register tTree exp;
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_FORALL) {
/* line 537 "Dependences.puma" */
  {
/* line 539 "Dependences.puma" */
   if (! ((IsVarInExp (TreeVarName (loop->ACF_FORALL.FORALL_ID), exp)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (loop->Kind == kACF_DO) {
/* line 542 "Dependences.puma" */
  {
/* line 544 "Dependences.puma" */
   if (! ((IsVarInExp (TreeVarName (loop->ACF_DO.DO_ID), exp)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

static void CheckDifferentModulo
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree e2, pPredVector p)
# else
(e1, e2, p)
 register tTree e1;
 register tTree e2;
 pPredVector p;
# endif
{
/* line 557 "Dependences.puma" */
 {
  rbool yyV1;
  int yyV2;
  int yyV3;
  rbool yyV4;
  int yyV5;
  int yyV6;
  int yyV7;
  int yyV8;
  int yyV9;
  {
/* line 559 "Dependences.puma" */
   FindMultiplicator (e1, & yyV1, & yyV2, & yyV3);
/* line 560 "Dependences.puma" */
   if (! ((yyV1))) goto yyL1;
  {
/* line 561 "Dependences.puma" */
   FindMultiplicator (e2, & yyV4, & yyV5, & yyV6);
/* line 562 "Dependences.puma" */
   if (! ((yyV4))) goto yyL1;
  {
/* line 564 "Dependences.puma" */
 
#ifdef DEBUG
  printf ("compare modulo : e1 = %d * X + %d, e2 = %d * Y + %d\n",
           yyV2, yyV3, yyV5, yyV6);
#endif 
  
/* line 571 "Dependences.puma" */
   GCD (yyV2, yyV5, & yyV7);
/* line 573 "Dependences.puma" */
   BuildModulo (yyV3, yyV7, & yyV8);
/* line 574 "Dependences.puma" */
   BuildModulo (yyV6, yyV7, & yyV9);
/* line 576 "Dependences.puma" */
 
#ifdef DEBUG
  printf ("compare modulo %d, n1 = %d, n2 = %d\n", yyV7, yyV8, yyV9);
#endif 
  
/* line 582 "Dependences.puma" */
   if (! ((yyV8 != yyV9))) goto yyL1;
  {
/* line 584 "Dependences.puma" */
   PVSetFalse (p);
  }
  }
  }
  }
   return;
 }
yyL1:;

;
}

static void FindMultiplicator
# if defined __STDC__ | defined __cplusplus
(register tTree e, register rbool * yyP7, register int * yyP6, register int * yyP5)
# else
(e, yyP7, yyP6, yyP5)
 register tTree e;
 register rbool * yyP7;
 register int * yyP6;
 register int * yyP5;
# endif
{
/* line 597 "Dependences.puma" */
 {
  rbool found;
  int mult;
  int add;
  tTree var;
  int yyV1;
  {
/* line 604 "Dependences.puma" */
   ResolveExpression (e, & found, & mult, & add, & var);
/* line 605 "Dependences.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 609 "Dependences.puma" */
   BuildModulo (add, mult, & yyV1);
  }
  }
   * yyP7 = rtrue;
   * yyP6 = mult;
   * yyP5 = yyV1;
   return;
 }
yyL1:;

  if (e->Kind == kSLICE_EXP) {
/* line 612 "Dependences.puma" */
 {
  int a;
  int b;
  int c;
  tTree var;
  rbool found;
  int yyV1;
  {
/* line 618 "Dependences.puma" */
   GetLoopIncrement (e, & found, & c);
/* line 619 "Dependences.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 621 "Dependences.puma" */
   ResolveExpression (e->SLICE_EXP.FIRST, & found, & a, & b, & var);
/* line 622 "Dependences.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 624 "Dependences.puma" */
   if (! ((a % c == 0))) goto yyL2;
  {
/* line 625 "Dependences.puma" */
   BuildModulo (b, c, & yyV1);
  }
  }
  }
  }
   * yyP7 = rtrue;
   * yyP6 = c;
   * yyP5 = yyV1;
   return;
 }
yyL2:;

  }
/* line 631 "Dependences.puma" */
   * yyP7 = rfalse;
   * yyP6 = 0;
   * yyP5 = 0;
   return;

;
}

static void BuildModulo
# if defined __STDC__ | defined __cplusplus
(register int a, register int c, register int * yyP8)
# else
(a, c, yyP8)
 register int a;
 register int c;
 register int * yyP8;
# endif
{
/* line 642 "Dependences.puma" */
  {
/* line 643 "Dependences.puma" */
   if (! ((c == 0))) goto yyL1;
  }
   * yyP8 = a;
   return;
yyL1:;

/* line 646 "Dependences.puma" */
 {
  int yyV1;
  {
/* line 647 "Dependences.puma" */
   if (! ((c < 0))) goto yyL2;
  {
/* line 648 "Dependences.puma" */
   BuildModulo (- a, - c, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL2:;

/* line 651 "Dependences.puma" */
  {
/* line 652 "Dependences.puma" */
   if (! ((a >= 0))) goto yyL3;
  }
   * yyP8 = a % c;
   return;
yyL3:;

/* line 655 "Dependences.puma" */
  {
/* line 656 "Dependences.puma" */
   if (! ((a < 0))) goto yyL4;
  }
   * yyP8 = c + a % c;
   return;
yyL4:;

;
}

static void GCD
# if defined __STDC__ | defined __cplusplus
(register int x1, register int x2, register int * yyP9)
# else
(x1, x2, yyP9)
 register int x1;
 register int x2;
 register int * yyP9;
# endif
{
/* line 667 "Dependences.puma" */
 {
  int yyV1;
  {
/* line 669 "Dependences.puma" */
   if (! ((x1 < 0))) goto yyL1;
  {
/* line 670 "Dependences.puma" */
   GCD (- x1, x2, & yyV1);
  }
  }
   * yyP9 = yyV1;
   return;
 }
yyL1:;

/* line 673 "Dependences.puma" */
 {
  int yyV1;
  {
/* line 675 "Dependences.puma" */
   if (! ((x2 < 0))) goto yyL2;
  {
/* line 676 "Dependences.puma" */
   GCD (x1, - x2, & yyV1);
  }
  }
   * yyP9 = yyV1;
   return;
 }
yyL2:;

/* line 679 "Dependences.puma" */
  {
/* line 680 "Dependences.puma" */
   if (! ((x2 == 0))) goto yyL3;
  }
   * yyP9 = x1;
   return;
yyL3:;

/* line 683 "Dependences.puma" */
  {
/* line 684 "Dependences.puma" */
   if (! ((x1 == 0))) goto yyL4;
  }
   * yyP9 = x2;
   return;
yyL4:;

/* line 687 "Dependences.puma" */
  {
/* line 688 "Dependences.puma" */
   if (! ((x1 == x2))) goto yyL5;
  }
   * yyP9 = x1;
   return;
yyL5:;

/* line 691 "Dependences.puma" */
 {
  int yyV1;
  {
/* line 692 "Dependences.puma" */
   if (! ((x1 > x2))) goto yyL6;
  {
/* line 693 "Dependences.puma" */
   GCD (x1 % x2, x2, & yyV1);
  }
  }
   * yyP9 = yyV1;
   return;
 }
yyL6:;

/* line 696 "Dependences.puma" */
 {
  int yyV1;
  {
/* line 697 "Dependences.puma" */
   GCD (x1, x2 % x1, & yyV1);
  }
   * yyP9 = yyV1;
   return;
 }

;
}

static void CheckEqualIndex
# if defined __STDC__ | defined __cplusplus
(register tTree e1, ptree loops1, register int n1, register tTree e2, ptree loops2, register int n2, register int ConstLoops, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, ConstLoops, p)
 register tTree e1;
 ptree loops1;
 register int n1;
 register tTree e2;
 ptree loops2;
 register int n2;
 register int ConstLoops;
 pPredVector p;
# endif
{
/* line 715 "Dependences.puma" */
 {
  rbool found;
  int a1;
  int a2;
  int b1;
  int b2;
  tTree var1;
  tTree var2;
  rbool yyV1;
  int yyV2;
  rbool yyV3;
  int yyV4;
  {
/* line 727 "Dependences.puma" */
   ResolveExpression (e1, & found, & a1, & b1, & var1);
/* line 728 "Dependences.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 729 "Dependences.puma" */
   ResolveExpression (e2, & found, & a2, & b2, & var2);
/* line 730 "Dependences.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 732 "Dependences.puma" */
   if (! ((a1 == a2))) goto yyL1;
  {
/* line 733 "Dependences.puma" */
   if (! ((a1 != 0))) goto yyL1;
  {
/* line 734 "Dependences.puma" */
   if (! ((b1 == b2))) goto yyL1;
  {
/* line 736 "Dependences.puma" */
   GetLoopPos (var1, loops1, n1, & yyV1, & yyV2);
/* line 737 "Dependences.puma" */
   if (! ((yyV1))) goto yyL1;
  {
/* line 738 "Dependences.puma" */
   GetLoopPos (var2, loops2, n2, & yyV3, & yyV4);
/* line 739 "Dependences.puma" */
   if (! ((yyV3))) goto yyL1;
  {
/* line 740 "Dependences.puma" */
   if (! ((yyV2 == yyV4))) goto yyL1;
  {
/* line 742 "Dependences.puma" */
   if (! ((yyV2 > ConstLoops))) goto yyL1;
  {
/* line 746 "Dependences.puma" */
   PVAndComponent (p, yyV2 - ConstLoops, 0, 0);
/* line 748 "Dependences.puma" */

#ifdef DEBUG
    printf ("equal index from outer loop %d\n", yyV2);
#endif
  
  }
  }
  }
  }
  }
  }
  }
  }
  }
  }
   return;
 }
yyL1:;

;
}

static void GetLoopPos
# if defined __STDC__ | defined __cplusplus
(register tTree v, ptree loops, register int n, register rbool * yyP11, register int * yyP10)
# else
(v, loops, n, yyP11, yyP10)
 register tTree v;
 ptree loops;
 register int n;
 register rbool * yyP11;
 register int * yyP10;
# endif
{
/* line 767 "Dependences.puma" */
 {
  int pos;
  int i;
  {
/* line 769 "Dependences.puma" */
   if (! ((n == 0))) goto yyL1;
  {
/* line 773 "Dependences.puma" */
   pos = 0;
/* line 775 "Dependences.puma" */
/* line 775 "Dependences.puma" */
   i = 0;
   while (i < n) {
/* line 777 "Dependences.puma" */
   if ((EqualExpression (v, MyGetLoopVar (loops [i])))) {
/* line 779 "Dependences.puma" */
   pos = i + 1;
   }
/* line 775 "Dependences.puma" */
   i ++;
   }
/* line 783 "Dependences.puma" */
   if (! ((pos > 0))) goto yyL1;
  }
  }
   * yyP11 = rtrue;
   * yyP10 = pos;
   return;
 }
yyL1:;

/* line 786 "Dependences.puma" */
   * yyP11 = rfalse;
   * yyP10 = 0;
   return;

;
}

static void ExpCompare
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e1, ptree loops1, register int n1, ExpNormRecord e2, ptree loops2, register int n2, register int CommonLoops, register int ConstLoops, pPredVector p)
# else
(e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops, p)
 ExpNormRecord e1;
 ptree loops1;
 register int n1;
 ExpNormRecord e2;
 ptree loops2;
 register int n2;
 register int CommonLoops;
 register int ConstLoops;
 pPredVector p;
# endif
{
/* line 804 "Dependences.puma" */

char PVString[100];

/* line 822 "Dependences.puma" */
 {
  int low;
  int up;
  rbool flow;
  rbool fup;
  {
/* line 829 "Dependences.puma" */
 
# ifdef DEBUG
     printf ("Call of ExpCompare (loops n1 = %d, n2 = %d, common = %d, const = %d)\n",
              n1, n2, CommonLoops, ConstLoops);
     PrintNormRecord ("ExpCompare", "e1", e1, loops1, n1);
     PrintNormRecord ("ExpCompare", "e2", e2, loops2, n2);
     strcpy (PVString,""); PVOut (PVString, p);
     printf ("Predicate = %s\n", PVString);
# endif 

     if (ExpDifferent (e1, loops1, n1, e2, loops2, n2, ConstLoops))
       {  
          PVSetFalse (p);
# ifdef DEBUG
          printf ("ExpCompare: FALSE, both expressions are different\n");
          strcpy (PVString,""); PVOut (PVString, p);
          printf ("Result Predicate = %s\n", PVString);
# endif 
          return;
       }

# ifdef DEBUG
     printf ("Expressions are not absolute different, consider e1 - e2\n");
# endif 

     DiffLowBound (e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops,
                   &flow, &low);

     

     DiffUppBound (e1, loops1, n1, e2, loops2, n2, CommonLoops, ConstLoops,
                   &fup, &up);

     

# ifdef DEBUG
     if (flow)
        printf ("Difference has lower bound : %d\n", low);
      else
        printf ("Difference has no lower bound\n");
     if (fup)
        printf ("Difference has upper bound : %d\n", up);
      else
        printf ("Difference has no upper bound\n");
# endif 

     if ((!flow) || (!fup))
        PVSetNotExact (p);
      else if (low != up)
        PVSetNotExact (p);

     DeltaCheck (e1, loops1, n1, flow, low, fup, up, ConstLoops, p);

     if (!PVIsFalse (p))

       DeltaCheck (e2, loops2, n2, flow, low, fup, up, ConstLoops, p);

# ifdef DEBUG
     strcpy (PVString,""); PVOut (PVString, p);
     printf ("ExpCompare: Final Result Predicate = %s\n", PVString);
# endif 
   
  }
   return;
 }

;
}

static void DeltaCheck
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e, ptree loops, register int n, register rbool flow, register int low, register rbool fup, register int up, register int ConstLoops, pPredVector p)
# else
(e, loops, n, flow, low, fup, up, ConstLoops, p)
 ExpNormRecord e;
 ptree loops;
 register int n;
 register rbool flow;
 register int low;
 register rbool fup;
 register int up;
 register int ConstLoops;
 pPredVector p;
# endif
{
/* line 914 "Dependences.puma" */

char PVString [100];

/* line 918 "Dependences.puma" */
 {
  rbool yyV1;
  int yyV2;
  int yyV3;
  int yyV4;
  {
/* line 920 "Dependences.puma" */

# ifdef DEBUG
   strcpy (PVString,""); PVOut (PVString, p);
   printf ("Call of DeltaCheck, p = %s\n", PVString);
   PrintNormRecord ("DeltaCheck", "e", e, loops, n);
# endif
   
/* line 928 "Dependences.puma" */
   MakeDelta (e, loops, n, ConstLoops, p, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 930 "Dependences.puma" */
   if (! ((yyV1))) goto yyL1;
  {
/* line 932 "Dependences.puma" */

# ifdef DEBUG
     printf ("Delta Check okay, delta = %d, pos = %d, val = %d\n",
              yyV2, yyV3, yyV4);
# endif 
   
/* line 939 "Dependences.puma" */
   MakeNewPred (yyV2, yyV3, yyV4, flow, low, fup, up, p);
/* line 941 "Dependences.puma" */


# ifdef DEBUG
   strcpy (PVString,""); PVOut (PVString, p);
   printf ("Result of DeltaCheck, p = %s\n", PVString);
# endif
   
  }
  }
   return;
 }
yyL1:;

;
}

static void MakeDelta
# if defined __STDC__ | defined __cplusplus
(ExpNormRecord e, ptree loops, register int n, register int ConstLoops, pPredVector p, register rbool * yyP15, register int * yyP14, register int * yyP13, register int * yyP12)
# else
(e, loops, n, ConstLoops, p, yyP15, yyP14, yyP13, yyP12)
 ExpNormRecord e;
 ptree loops;
 register int n;
 register int ConstLoops;
 pPredVector p;
 register rbool * yyP15;
 register int * yyP14;
 register int * yyP13;
 register int * yyP12;
# endif
{
/* line 960 "Dependences.puma" */
 {
  rbool okay;
  int delta;
  int pos;
  int val;
  {
/* line 967 "Dependences.puma" */
 int i, ndim, pdim;
     rbool found;
     int  eval, incval;
     int  p_low, p_up;

     ndim = PVGetDimension (p);

     

     okay  = rtrue;
     delta = 0;
     pos   = 0;     

     for (i=1; i<=n; i++)

       { eval = e.vals[i];

         pdim = i - ConstLoops;  

         if ((eval != 0) && (pdim >= 1) && (pdim <= ndim))

          { 

           PVGetComponent (p, pdim, &p_low, &p_up);

           if ((p_low != 0) || (p_up != 0))

             { 

               GetLoopIncrement (loops[i-1], &found, &incval);

               if ((!found) && (eval != 0))
                  okay = rfalse;   

               eval *= incval;
             }

           if (p_low == p_up)

             {  

                delta += p_low * eval;
             }

           else
             { if (pos == 0)
                  { pos = pdim; val = eval; }
                else
                  okay = rfalse; 
             }
         }
     } 

   
  }
   * yyP15 = okay;
   * yyP14 = delta;
   * yyP13 = pos;
   * yyP12 = val;
   return;
 }

;
}

static void MakeNewPred
# if defined __STDC__ | defined __cplusplus
(register int delta, register int pos, register int val, register rbool flow, register int low, register rbool fup, register int up, pPredVector p)
# else
(delta, pos, val, flow, low, fup, up, p)
 register int delta;
 register int pos;
 register int val;
 register rbool flow;
 register int low;
 register rbool fup;
 register int up;
 pPredVector p;
# endif
{
/* line 1035 "Dependences.puma" */
  {
/* line 1037 "Dependences.puma" */
   if (! ((pos == 0))) goto yyL1;
  {
/* line 1039 "Dependences.puma" */
 
     if (fup)
        { if (delta + up < 0) PVSetFalse (p); }
     
     if (flow)
        { if (delta + low > 0) PVSetFalse (p); }
   
  }
  }
   return;
yyL1:;

/* line 1048 "Dependences.puma" */
 {
  int p_low;
  int p_up;
  {
/* line 1053 "Dependences.puma" */
   if (! ((val > 0))) goto yyL2;
  {
/* line 1057 "Dependences.puma" */
 if (fup)
         p_low = (- up - delta) / val;
       else
         p_low = -MaxInt;

      if (flow)
         p_up  = (- low - delta) / val;
        else
         p_up  = MaxInt;

      PVAndComponent (p, pos, p_low, p_up);
      if (p_low != p_up) PVSetNotExact (p);
    
  }
  }
   return;
 }
yyL2:;

/* line 1072 "Dependences.puma" */
 {
  int p_low;
  int p_up;
  {
/* line 1077 "Dependences.puma" */
   if (! ((val < 0))) goto yyL3;
  {
/* line 1081 "Dependences.puma" */
 if (fup)
         p_up = (- up - delta) / val;
       else
         p_up = MaxInt;

      if (flow)
         p_low  = (- low - delta) / val;
        else
         p_low  = -MaxInt;

      PVAndComponent (p, pos, p_low, p_up);
      if (p_low != p_up) PVSetNotExact (p);
    
  }
  }
   return;
 }
yyL3:;

;
}

static tTree MyGetLoopVar
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
/* line 1106 "Dependences.puma" */
  {
/* line 1108 "Dependences.puma" */
   if (! ((IsCountLoop (loop)))) goto yyL1;
  }
   return GetLoopId (loop);
yyL1:;

/* line 1113 "Dependences.puma" */
   return loop;

}

void BeginDependences ARGS ((void))
{
}

void CloseDependences ARGS ((void))
{
}
