# include "Dalib.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 32 "Dalib.puma" */


# include <stdio.h>
# include <string.h>

# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "Expressions.h"   /* MakeSliceExp */
# include "Types.h"         /* ArrayFormals */
# include "Transform.h"     /* ExpToVarParam */

# include "CodeGeneral.h"  

# define  MODULE "Dalib"

tTree NewHelpVars;         /* exported to CodeGeneral */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyDalib.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Dalib_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Dalib, routine %s failed\n",
  yyFunction);
 Dalib_Exit ();
}

tIdent MakeDalibId ARGS ((char * name));
tIdent MakeDalibCId ARGS ((char * name, rbool is_char));
tIdent MakeDalibId1 ARGS ((char * name, int n));
tTree DalibGlobalToLocal ARGS ((tIdent id, int dim, tTree exp));

tIdent MakeDalibId
# if defined __STDC__ | defined __cplusplus
(char * name)
# else
(name)
 char * name;
# endif
{
/* line 62 "Dalib.puma" */

char s [100];

/* line 66 "Dalib.puma" */
  {
/* line 68 "Dalib.puma" */
 sprintf (s, "DALIB_%s", name); 
  }
   return MakeIdent (s, strlen (s));

}

tIdent MakeDalibCId
# if defined __STDC__ | defined __cplusplus
(char * name, register rbool is_char)
# else
(name, is_char)
 char * name;
 register rbool is_char;
# endif
{
/* line 75 "Dalib.puma" */

char s [100];

/* line 79 "Dalib.puma" */
  {
/* line 81 "Dalib.puma" */
   if (! ((is_char))) goto yyL1;
  {
/* line 83 "Dalib.puma" */
 sprintf (s, "DALIB_c%s", name); 
  }
  }
   return MakeIdent (s, strlen (s));
yyL1:;

/* line 88 "Dalib.puma" */
  {
/* line 90 "Dalib.puma" */
 sprintf (s, "DALIB_%s", name); 
  }
   return MakeIdent (s, strlen (s));

}

tIdent MakeDalibId1
# if defined __STDC__ | defined __cplusplus
(char * name, register int n)
# else
(name, n)
 char * name;
 register int n;
# endif
{
/* line 103 "Dalib.puma" */

char s [100];

/* line 107 "Dalib.puma" */
  {
/* line 108 "Dalib.puma" */
 sprintf (s, "DALIB_%s%d", name, n);
  
  }
   return MakeIdent (s, strlen (s));

}

tTree DalibGlobalToLocal
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register int dim, register tTree exp)
# else
(id, dim, exp)
 register tIdent id;
 register int dim;
 register tTree exp;
# endif
{
/* line 121 "Dalib.puma" */
 {
  tTree paramlist;
  tTree call;
  {
/* line 126 "Dalib.puma" */
 paramlist = mBTP_EMPTY ();
    paramlist = mBTP_LIST (ExpToVarParam (exp), paramlist);
    paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (dim)), paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (id, "_DSP")),
                           paramlist);

    call = mPROC_OBJ (MakeDalibId ("addr"));
    DefineNewHelpFn (MakeDalibId ("addr"));
    call = mFUNC_CALL_EXP (call, paramlist);
  
  }
   return call;
 }

}

void BeginDalib ARGS ((void))
{
}

void CloseDalib ARGS ((void))
{
}
