# include "ControlFlow.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 21 "ControlFlow.puma" */


# undef DEBUG

# define MODULE "ControlFlow"

# include "Idents.h"
# include "StringM.h"

# include "protocol.h"
# include "labels.h"

# include "Types.h"
# include "Transform.h"     /* ReplaceACF */
# include "Nesting.h"
# include "Traverse.h"      /* FullTraverseAST */

# include "Expressions.h"   /* MakeConstant                 */
# include "Temporary.h"     /* TemporaryInit, TemporaryDone */

/*********************************************************************
*                                                                    * 
*  Global Data for Control Flow Analysis                             * 
*                                                                    * 
*********************************************************************/

int NoReturns;

/* global data for labels in IO statements */

static int end_label;
static int err_label;
static int eor_label;

static tTree io_stat;

static rbool is_label;

static rbool assigned_gotos;   /* true if goto ziel, jump to all */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyControlFlow.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* ControlFlow_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ControlFlow, routine %s failed\n",
  yyFunction);
 ControlFlow_Exit ();
}

void ControlFlow ARGS ((tTree t));
static rbool StopCheckUpLabel ARGS ((tTree t));
static void CheckUpLabel ARGS ((tTree t));
static tTree RemoveLastReturn ARGS ((tTree t));
static tTree AppendEndLabel ARGS ((tTree t, int label));
static tTree ContinueStmt ARGS ((int label));
static void ReplaceReturn ARGS ((tTree t, int gotolabel));
static rbool StopNormalizeCF ARGS ((tTree t));
static tTree NormalizeCF ARGS ((tTree t));
static void CheckUnusedLabel ARGS ((tTree t));
static void CheckDefinedLabel ARGS ((int label));
static void GetCaseDefault ARGS ((tTree t, tTree * yyP2, tTree * yyP1));
static tTree TranslateCase ARGS ((tTree t, tTree def_stmts));
static tTree MakeIf ARGS ((tTree s, tTree exp, tTree else_part, int label, int line));
static tTree TransCaseExp ARGS ((tTree exp, tTree selector));
static tTree TranslateLoop ARGS ((tTree t));
static tTree MakeWhileLoop ARGS ((tTree t));
static void FindExitOrCycle ARGS ((tTree t, tIdent name, int level, rbool * yyP4, rbool * yyP3));
static void ReplaceExitCycle ARGS ((tTree t, tIdent name, int level, int exit_label, int cycle_label));
static tTree TranslateIOStmt ARGS ((tTree t));
static void AnalyseIOSpecs ARGS ((tTree specs));
static int GetLabel ARGS ((tTree t));
static void GetIOStat ARGS ((tTree t));
static tTree UpdateIOSpecs ARGS ((tTree specs));
static rbool IsLabelSpec ARGS ((tTree spec));
static tTree MakeJumpStmt ARGS ((tTree op, int value, int label));

void ControlFlow
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 71 "ControlFlow.puma" */
  {
/* line 73 "ControlFlow.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  case kUNIT_EMPTY:
/* line 78 "ControlFlow.puma" */
   return;

  case kUNIT_LIST:
/* line 81 "ControlFlow.puma" */
  {
/* line 82 "ControlFlow.puma" */
   ControlFlow (t->UNIT_LIST.Elem);
/* line 83 "ControlFlow.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kPROGRAM_DECL:
/* line 92 "ControlFlow.puma" */
  {
/* line 94 "ControlFlow.puma" */
   NestOpenUnit (t);
/* line 95 "ControlFlow.puma" */
   ControlFlow (t->PROGRAM_DECL.PROGRAM_BODY);
/* line 96 "ControlFlow.puma" */
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
/* line 99 "ControlFlow.puma" */
  {
/* line 101 "ControlFlow.puma" */
   NestOpenUnit (t);
/* line 102 "ControlFlow.puma" */
   ControlFlow (t->PROC_DECL.PROC_BODY);
/* line 103 "ControlFlow.puma" */
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
/* line 106 "ControlFlow.puma" */
  {
/* line 108 "ControlFlow.puma" */
   NestOpenUnit (t);
/* line 109 "ControlFlow.puma" */
   ControlFlow (t->FUNC_DECL.FUNC_BODY);
/* line 110 "ControlFlow.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
/* line 113 "ControlFlow.puma" */
  {
/* line 115 "ControlFlow.puma" */
   NestOpenUnit (t);
/* line 116 "ControlFlow.puma" */
   ControlFlow (t->MODULE_DECL.MODULE_BODY);
/* line 117 "ControlFlow.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 120 "ControlFlow.puma" */
  {
/* line 122 "ControlFlow.puma" */
   NestOpenUnit (t);
/* line 123 "ControlFlow.puma" */
   ControlFlow (t->BLOCK_DATA_DECL.DATA_BODY);
/* line 124 "ControlFlow.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
/* line 137 "ControlFlow.puma" */
 {
  int NewLabel;
  {
/* line 139 "ControlFlow.puma" */
   assigned_gotos = rfalse;
/* line 141 "ControlFlow.puma" */
   InitLabels ();
/* line 143 "ControlFlow.puma" */
   TemporaryInit (t);
/* line 147 "ControlFlow.puma" */
   NoReturns = 0;
/* line 151 "ControlFlow.puma" */
   TraverseAST (t->BODY_NODE.DECLS, StopCheckUpLabel, CheckUpLabel);
/* line 152 "ControlFlow.puma" */
   TraverseAST (t->BODY_NODE.STATS, StopCheckUpLabel, CheckUpLabel);
/* line 156 "ControlFlow.puma" */
   if ((NoReturns > 0)) {
/* line 156 "ControlFlow.puma" */
 t->BODY_NODE.STATS = RemoveLastReturn (t->BODY_NODE.STATS); 
   }
/* line 160 "ControlFlow.puma" */
   if ((NoReturns > 0)) {
/* line 164 "ControlFlow.puma" */
   NewLabel = GetNewLabel ();
/* line 165 "ControlFlow.puma" */
 t->BODY_NODE.STATS = AppendEndLabel (t->BODY_NODE.STATS, NewLabel); 
/* line 166 "ControlFlow.puma" */
   ReplaceReturn (t->BODY_NODE.STATS, NewLabel);
   }
/* line 172 "ControlFlow.puma" */
   if ((NoReturns > 0)) {
/* line 173 "ControlFlow.puma" */
   simple_error_protocol ("not all returns removed");
   }
/* line 176 "ControlFlow.puma" */
   t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopNormalizeCF, NormalizeCF);
/* line 178 "ControlFlow.puma" */
   TemporaryDone (t);
/* line 180 "ControlFlow.puma" */
   t = t->BODY_NODE.INTERNALS;
   goto yyRecursion;
  }
 }

  }

;
}

static rbool StopCheckUpLabel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFORMAT_DECL) {
/* line 196 "ControlFlow.puma" */
  {
/* line 196 "ControlFlow.puma" */
   return rfalse;
  }

  }
  if (Tree_IsType (t, kDECL_NODE)) {
/* line 198 "ControlFlow.puma" */
   return rtrue;

  }
  return rfalse;
}

static void CheckUpLabel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kFORMAT_DECL:
/* line 202 "ControlFlow.puma" */
  {
/* line 204 "ControlFlow.puma" */
   if (! ((t->FORMAT_DECL.label > 0))) goto yyL1;
  {
/* line 206 "ControlFlow.puma" */
   LabelDefine (t->FORMAT_DECL.label);
  }
  }
   return;
yyL1:;

  break;
  case kACF_NODE:
  case kACF_DUMMY:
  case kACF_BASIC:
  case kACF_IF:
  case kACF_WHERE:
  case kACF_CASE:
  case kACF_WHILE:
  case kACF_REPEAT:
  case kACF_LOOP:
  case kACF_DO:
  case kACF_FORALL:
  case kACF_FLOW_GRAPH:
  case kACF_ENTRY:
  case kACF_HOME:
  case kACF_RESIDENT:
  case kACF_NEW:
  case kACF_REDUCTION:
  case kACF_TASK_REGION:
  case kACF_PARALLEL:
  case kACF_CRITICAL:
  case kACF_ON:
  case kACF_RM_READ:
  case kACF_RM_WRITE:
  case kACF_MOVE:
  case kACF_BARRIER:
  case kACF_UPDATE:
/* line 209 "ControlFlow.puma" */
  {
/* line 211 "ControlFlow.puma" */
   if (! ((t->ACF_NODE.Label > 0))) goto yyL2;
  {
/* line 213 "ControlFlow.puma" */

#ifdef DEBUG
     printf ("label %d defined in line %d\n", t->ACF_NODE.Label, t->ACF_NODE.Line);
#endif 
   
/* line 219 "ControlFlow.puma" */
   LabelDefine (t->ACF_NODE.Label);
  }
  }
   return;
yyL2:;

  break;
  case kRETURN_STMT:
  if (t->RETURN_STMT.RETURN_EXP->Kind == kDUMMY_EXP) {
/* line 222 "ControlFlow.puma" */
  {
/* line 224 "ControlFlow.puma" */
   NoReturns = NoReturns + 1;
  }
   return;

  }
/* line 227 "ControlFlow.puma" */
  {
/* line 229 "ControlFlow.puma" */
   error_protocol ("alternative return not supported\n");
  }
   return;

  case kASS_GOTO_STMT:
  if (t->ASS_GOTO_STMT.LABELS->Kind == kLABEL_EMPTY) {
/* line 234 "ControlFlow.puma" */
  {
/* line 236 "ControlFlow.puma" */
   assigned_gotos = rtrue;
  }
   return;

  }
  break;
  case kGOTO_STMT:
/* line 239 "ControlFlow.puma" */
  {
/* line 241 "ControlFlow.puma" */
   LabelUse (t->GOTO_STMT.GOTO_LABEL);
  }
   return;

  case kRETURN_PARAM:
/* line 244 "ControlFlow.puma" */
  {
/* line 246 "ControlFlow.puma" */
   LabelUse (t->RETURN_PARAM.label);
  }
   return;

  case kLABEL_ASSIGN_STMT:
/* line 249 "ControlFlow.puma" */
  {
/* line 251 "ControlFlow.puma" */
   LabelUse (t->LABEL_ASSIGN_STMT.assign_label);
  }
   return;

  case kLABEL_LIST:
/* line 254 "ControlFlow.puma" */
  {
/* line 256 "ControlFlow.puma" */
   LabelUse (t->LABEL_LIST.Elem);
  }
   return;

  case kCOMP_IF_STMT:
/* line 259 "ControlFlow.puma" */
  {
/* line 263 "ControlFlow.puma" */
   LabelUse (t->COMP_IF_STMT.IF_LT_LABEL);
/* line 264 "ControlFlow.puma" */
   LabelUse (t->COMP_IF_STMT.IF_EQ_LABEL);
/* line 265 "ControlFlow.puma" */
   LabelUse (t->COMP_IF_STMT.IF_GT_LABEL);
  }
   return;

  }

;
}

static tTree RemoveLastReturn
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_LIST) {
  if (t->ACF_LIST.Elem->Kind == kACF_BASIC) {
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind == kRETURN_STMT) {
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->RETURN_STMT.RETURN_EXP->Kind == kDUMMY_EXP) {
  if (t->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 279 "ControlFlow.puma" */
  {
/* line 282 "ControlFlow.puma" */
   NoReturns = NoReturns - 1;
/* line 284 "ControlFlow.puma" */

#ifdef DEBUG
      printf ("remove last return in line %d\n", t->ACF_LIST.Elem->ACF_BASIC.Line);
#endif
   
  }
   return ReplaceACF (t, NoTree, t->ACF_LIST.Next);

  }
  }
  }
  }
/* line 295 "ControlFlow.puma" */
  {
/* line 297 "ControlFlow.puma" */
 t->ACF_LIST.Next = RemoveLastReturn (t->ACF_LIST.Next); 
  }
   return t;

  }
  if (t->Kind == kACF_EMPTY) {
/* line 302 "ControlFlow.puma" */
   return t;

  }
 yyAbort ("RemoveLastReturn");
 { tTree yyDummy; return yyDummy; }
}

static tTree AppendEndLabel
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int label)
# else
(t, label)
 register tTree t;
 register int label;
# endif
{
  if (t->Kind == kACF_EMPTY) {
/* line 319 "ControlFlow.puma" */
   return mACF_LIST (ContinueStmt (label), t);

  }
  if (t->Kind == kACF_LIST) {
/* line 324 "ControlFlow.puma" */
  {
/* line 326 "ControlFlow.puma" */
 t->ACF_LIST.Next = AppendEndLabel (t->ACF_LIST.Next, label); 
  }
   return t;

  }
 yyAbort ("AppendEndLabel");
 { tTree yyDummy; return yyDummy; }
}

static tTree ContinueStmt
# if defined __STDC__ | defined __cplusplus
(register int label)
# else
(label)
 register int label;
# endif
{
/* line 338 "ControlFlow.puma" */
 {
  tTree stmt;
  {
/* line 340 "ControlFlow.puma" */
   stmt = mACF_DUMMY ();
/* line 342 "ControlFlow.puma" */
   LabelACFNode (stmt, label);
/* line 343 "ControlFlow.puma" */
   LabelDefine (label);
  }
   return stmt;
 }

}

static void ReplaceReturn
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int gotolabel)
# else
(t, gotolabel)
 register tTree t;
 register int gotolabel;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kACF_LIST:
/* line 360 "ControlFlow.puma" */
  {
/* line 362 "ControlFlow.puma" */
   ReplaceReturn (t->ACF_LIST.Elem, gotolabel);
/* line 363 "ControlFlow.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kACF_EMPTY:
/* line 366 "ControlFlow.puma" */
   return;

  case kACF_DUMMY:
/* line 369 "ControlFlow.puma" */
   return;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kRETURN_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->RETURN_STMT.RETURN_EXP->Kind == kDUMMY_EXP) {
/* line 372 "ControlFlow.puma" */
  {
/* line 374 "ControlFlow.puma" */
   t->ACF_BASIC.BASIC_STMT = mGOTO_STMT (gotolabel);
/* line 376 "ControlFlow.puma" */
   LabelUse (gotolabel);
/* line 377 "ControlFlow.puma" */
   NoReturns = NoReturns - 1;
  }
   return;

  }
/* line 380 "ControlFlow.puma" */
   return;

  }
/* line 385 "ControlFlow.puma" */
   return;

  case kACF_IF:
/* line 388 "ControlFlow.puma" */
  {
/* line 390 "ControlFlow.puma" */
   ReplaceReturn (t->ACF_IF.THEN_PART, gotolabel);
/* line 391 "ControlFlow.puma" */
   t = t->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  case kACF_WHERE:
/* line 394 "ControlFlow.puma" */
  {
/* line 395 "ControlFlow.puma" */
   ReplaceReturn (t->ACF_WHERE.TRUE_PART, gotolabel);
/* line 396 "ControlFlow.puma" */
   t = t->ACF_WHERE.FALSE_PART;
   goto yyRecursion;
  }

  case kACF_CASE:
/* line 399 "ControlFlow.puma" */
  {
/* line 400 "ControlFlow.puma" */
   t = t->ACF_CASE.CASE_ALTS;
   goto yyRecursion;
  }

  case kSELECTED_ACF_LIST:
/* line 403 "ControlFlow.puma" */
  {
/* line 404 "ControlFlow.puma" */
   ReplaceReturn (t->SELECTED_ACF_LIST.Elem, gotolabel);
/* line 405 "ControlFlow.puma" */
   t = t->SELECTED_ACF_LIST.Next;
   goto yyRecursion;
  }

  case kSELECTED_ACF_EMPTY:
/* line 408 "ControlFlow.puma" */
   return;

  case kSELECTED_ACF_NODE:
/* line 411 "ControlFlow.puma" */
  {
/* line 412 "ControlFlow.puma" */
   t = t->SELECTED_ACF_NODE.SELECT_ACFS;
   goto yyRecursion;
  }

  case kACF_LOOP:
/* line 415 "ControlFlow.puma" */
  {
/* line 416 "ControlFlow.puma" */
   t = t->ACF_LOOP.LOOP_BODY;
   goto yyRecursion;
  }

  case kACF_WHILE:
/* line 419 "ControlFlow.puma" */
  {
/* line 420 "ControlFlow.puma" */
   t = t->ACF_WHILE.WHILE_BODY;
   goto yyRecursion;
  }

  case kACF_FORALL:
/* line 423 "ControlFlow.puma" */
  {
/* line 425 "ControlFlow.puma" */
   t = t->ACF_FORALL.FORALL_BODY;
   goto yyRecursion;
  }

  case kACF_DO:
/* line 428 "ControlFlow.puma" */
  {
/* line 430 "ControlFlow.puma" */
   t = t->ACF_DO.DO_BODY;
   goto yyRecursion;
  }

  case kACF_HOME:
/* line 433 "ControlFlow.puma" */
  {
/* line 435 "ControlFlow.puma" */
   t = t->ACF_HOME.HOME_BODY;
   goto yyRecursion;
  }

  case kACF_NEW:
/* line 438 "ControlFlow.puma" */
  {
/* line 440 "ControlFlow.puma" */
   t = t->ACF_NEW.NEW_BODY;
   goto yyRecursion;
  }

  case kACF_RESIDENT:
/* line 443 "ControlFlow.puma" */
  {
/* line 445 "ControlFlow.puma" */
   t = t->ACF_RESIDENT.RESIDENT_BODY;
   goto yyRecursion;
  }

  case kACF_REDUCTION:
/* line 448 "ControlFlow.puma" */
  {
/* line 450 "ControlFlow.puma" */
   t = t->ACF_REDUCTION.REDUCTION_BODY;
   goto yyRecursion;
  }

  case kACF_ENTRY:
/* line 453 "ControlFlow.puma" */
   return;

  }

/* line 456 "ControlFlow.puma" */
  {
/* line 457 "ControlFlow.puma" */
   failure_protocol (MODULE, "ReplaceReturn", t);
  }
   return;

;
}

static rbool StopNormalizeCF
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 475 "ControlFlow.puma" */
  {
/* line 475 "ControlFlow.puma" */
   return rfalse;
  }

}

static tTree NormalizeCF
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (Tree_IsType (t, kACF_NODE)) {
/* line 479 "ControlFlow.puma" */
  {
/* line 481 "ControlFlow.puma" */
   if (! ((t->ACF_NODE.Label > 0))) goto yyL1;
  {
/* line 483 "ControlFlow.puma" */
   CheckUnusedLabel (t);
/* line 485 "ControlFlow.puma" */
   goto yyL1;
  }
  }
yyL1:;

  }

  switch (t->Kind) {
  case kACF_DUMMY:
/* line 492 "ControlFlow.puma" */
  {
/* line 494 "ControlFlow.puma" */
   if (! ((t->ACF_DUMMY.Label == 0))) goto yyL2;
  }
   return NoTree;
yyL2:;

  break;
  case kACF_LOOP:
/* line 499 "ControlFlow.puma" */
   return TranslateLoop (t);

  case kACF_WHILE:
/* line 506 "ControlFlow.puma" */
   return TranslateLoop (t);

  case kACF_DO:
/* line 511 "ControlFlow.puma" */
   return TranslateLoop (t);

  case kACF_CASE:
/* line 516 "ControlFlow.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree newacf;
  {
/* line 518 "ControlFlow.puma" */
   stmt_protocol ("Translation of CASE : ");
/* line 520 "ControlFlow.puma" */
   GetCaseDefault (t->ACF_CASE.CASE_ALTS, & yyV1, & yyV2);
/* line 522 "ControlFlow.puma" */
 t->ACF_CASE.CASE_ALTS = yyV1; 
/* line 526 "ControlFlow.puma" */
   newacf = TranslateCase (t, yyV2);
/* line 527 "ControlFlow.puma" */
   tree_protocol ("New IF cascace:\n", newacf);
  }
   return newacf;
 }

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
/* line 532 "ControlFlow.puma" */
   return TranslateIOStmt (t);

  }
  break;
  case kGOTO_STMT:
/* line 537 "ControlFlow.puma" */
  {
/* line 539 "ControlFlow.puma" */
   CheckDefinedLabel (t->GOTO_STMT.GOTO_LABEL);
  }
   return t;

  case kRETURN_PARAM:
/* line 543 "ControlFlow.puma" */
  {
/* line 545 "ControlFlow.puma" */
   CheckDefinedLabel (t->RETURN_PARAM.label);
  }
   return t;

  case kLABEL_ASSIGN_STMT:
/* line 549 "ControlFlow.puma" */
  {
/* line 551 "ControlFlow.puma" */
   CheckDefinedLabel (t->LABEL_ASSIGN_STMT.assign_label);
  }
   return t;

  case kLABEL_LIST:
/* line 555 "ControlFlow.puma" */
  {
/* line 557 "ControlFlow.puma" */
   CheckDefinedLabel (t->LABEL_LIST.Elem);
  }
   return t;

  }

/* line 561 "ControlFlow.puma" */
   return t;

}

static void CheckUnusedLabel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (Tree_IsType (t, kACF_NODE)) {
/* line 577 "ControlFlow.puma" */
 {
  int pos;
  int dummy;
  int used;
  int defined;
  {
/* line 579 "ControlFlow.puma" */
   if (! ((t->ACF_NODE.Label > 0))) goto yyL1;
  {
/* line 583 "ControlFlow.puma" */
   pos = GetLabelPos (t->ACF_NODE.Label);
/* line 584 "ControlFlow.puma" */
   GetLabelInfo (pos, & dummy, & used, & defined);
/* line 586 "ControlFlow.puma" */
   if ((used == 0)) {
/* line 588 "ControlFlow.puma" */
 char msg [100];

        sprintf (msg, "unused label %d removed", t->ACF_NODE.Label);

        info_protocol (msg);

        t->ACF_NODE.Label = 0;
      
   }
  }
  }
   return;
 }
yyL1:;

  }
;
}

static void CheckDefinedLabel
# if defined __STDC__ | defined __cplusplus
(register int label)
# else
(label)
 register int label;
# endif
{
/* line 610 "ControlFlow.puma" */
 {
  int pos;
  int dummy;
  int used;
  int defined;
  {
/* line 614 "ControlFlow.puma" */
   pos = GetLabelPos (label);
/* line 615 "ControlFlow.puma" */
   GetLabelInfo (pos, & dummy, & used, & defined);
/* line 617 "ControlFlow.puma" */
   if ((defined == 0)) {
/* line 619 "ControlFlow.puma" */
 char msg [100];

        sprintf (msg, "missing statement number %d", label);

        error_protocol (msg);

      
   }
  }
   return;
 }

;
}

static void GetCaseDefault
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP2, register tTree * yyP1)
# else
(t, yyP2, yyP1)
 register tTree t;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (t->Kind == kSELECTED_ACF_EMPTY) {
/* line 649 "ControlFlow.puma" */
   * yyP2 = t;
   * yyP1 = NoTree;
   return;

  }
  if (t->Kind == kSELECTED_ACF_LIST) {
  if (t->SELECTED_ACF_LIST.Elem->SELECTED_ACF_NODE.SELECT_LIST->Kind == kBTE_EMPTY) {
/* line 652 "ControlFlow.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 654 "ControlFlow.puma" */
   GetCaseDefault (t->SELECTED_ACF_LIST.Next, & yyV1, & yyV2);
/* line 656 "ControlFlow.puma" */
 if (yyV2 != NoTree)
        error_protocol ("more than one CASE DEFAULT in CASE statement");
   
  }
   * yyP2 = t->SELECTED_ACF_LIST.Next;
   * yyP1 = t->SELECTED_ACF_LIST.Elem->SELECTED_ACF_NODE.SELECT_ACFS;
   return;
 }

  }
/* line 661 "ControlFlow.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 663 "ControlFlow.puma" */
   GetCaseDefault (t->SELECTED_ACF_LIST.Next, & yyV1, & yyV2);
/* line 665 "ControlFlow.puma" */
 t->SELECTED_ACF_LIST.Next = yyV1; 
  }
   * yyP2 = t;
   * yyP1 = yyV2;
   return;
 }

  }
/* line 668 "ControlFlow.puma" */
  {
/* line 670 "ControlFlow.puma" */
   failure_protocol (MODULE, "GetCaseDefault", t);
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static tTree TranslateCase
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree def_stmts)
# else
(t, def_stmts)
 register tTree t;
 register tTree def_stmts;
# endif
{
 yyRecursion:
/* line 695 "ControlFlow.puma" */
  {
/* line 696 "ControlFlow.puma" */
   if (! ((def_stmts == NoTree))) goto yyL1;
  }
   def_stmts = mACF_EMPTY ();
   goto yyRecursion;
yyL1:;

  if (t->Kind == kACF_CASE) {
  if (t->ACF_CASE.CASE_ALTS->Kind == kSELECTED_ACF_EMPTY) {
/* line 700 "ControlFlow.puma" */
   return mACF_IF (mCONST_EXP (mBOOL_CONSTANT (1)), def_stmts, mACF_EMPTY ());

  }
  if (t->ACF_CASE.CASE_ALTS->Kind == kSELECTED_ACF_LIST) {
  if (t->ACF_CASE.CASE_ALTS->SELECTED_ACF_LIST.Next->Kind == kSELECTED_ACF_EMPTY) {
/* line 706 "ControlFlow.puma" */
   return MakeIf (t->ACF_CASE.CASE_ALTS->SELECTED_ACF_LIST.Elem, t->ACF_CASE.CASE_EXP, def_stmts, t->ACF_CASE.Label, t->ACF_CASE.Line);

  }
/* line 712 "ControlFlow.puma" */
 {
  tTree tail;
  tTree first;
  {
/* line 717 "ControlFlow.puma" */
 first = t->ACF_CASE.CASE_ALTS->SELECTED_ACF_LIST.Elem;   
      t->ACF_CASE.CASE_ALTS  = t->ACF_CASE.CASE_ALTS->SELECTED_ACF_LIST.Next;
      tail  = TranslateCase (t, def_stmts);
      tail  = mACF_LIST (tail, mACF_EMPTY ());   
      first = MakeIf (first, CopyTree (t->ACF_CASE.CASE_EXP), tail, t->ACF_CASE.Label, t->ACF_CASE.Line);
    
  }
   return first;
 }

  }
  }
/* line 727 "ControlFlow.puma" */
  {
/* line 728 "ControlFlow.puma" */
   failure_protocol ("ControlFlow", "TranslateCase", t);
  }
   return t;

}

static tTree MakeIf
# if defined __STDC__ | defined __cplusplus
(register tTree s, register tTree exp, register tTree else_part, register int label, register int line)
# else
(s, exp, else_part, label, line)
 register tTree s;
 register tTree exp;
 register tTree else_part;
 register int label;
 register int line;
# endif
{
  if (s->Kind == kSELECTED_ACF_NODE) {
/* line 741 "ControlFlow.puma" */
 {
  tTree if_stmt;
  {
/* line 745 "ControlFlow.puma" */
   if_stmt = mACF_IF (TransCaseExp (exp, s->SELECTED_ACF_NODE.SELECT_LIST), s->SELECTED_ACF_NODE.SELECT_ACFS, else_part);
/* line 747 "ControlFlow.puma" */
   LabelACFNode (if_stmt, label);
/* line 748 "ControlFlow.puma" */
   LineACFNode (if_stmt, line);
  }
   return if_stmt;
 }

  }
 yyAbort ("MakeIf");
 { tTree yyDummy; return yyDummy; }
}

static tTree TransCaseExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree selector)
# else
(exp, selector)
 register tTree exp;
 register tTree selector;
# endif
{
 yyRecursion:
  if (selector->Kind == kBTE_EMPTY) {
/* line 761 "ControlFlow.puma" */
   return mCONST_EXP (mBOOL_CONSTANT (1));

  }
  if (selector->Kind == kBTE_LIST) {
  if (selector->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 765 "ControlFlow.puma" */
   selector = selector->BTE_LIST.Elem;
   goto yyRecursion;

  }
/* line 769 "ControlFlow.puma" */
   return mOP_EXP (mOP_OR (), TransCaseExp (CopyTree (exp), selector->BTE_LIST.Elem), TransCaseExp (exp, selector->BTE_LIST.Next));

  }
  if (selector->Kind == kSLICE_EXP) {
  if (selector->SLICE_EXP.FIRST->Kind == kDUMMY_EXP) {
/* line 774 "ControlFlow.puma" */
   return mOP_EXP (mOP_LE (), exp, selector->SLICE_EXP.STOP);

  }
  if (selector->SLICE_EXP.STOP->Kind == kDUMMY_EXP) {
/* line 778 "ControlFlow.puma" */
   return mOP_EXP (mOP_LE (), selector->SLICE_EXP.FIRST, exp);

  }
/* line 782 "ControlFlow.puma" */
   return mOP_EXP (mOP_AND (), mOP_EXP (mOP_LE (), selector->SLICE_EXP.FIRST, CopyTree (exp)), mOP_EXP (mOP_LE (), exp, selector->SLICE_EXP.STOP));

  }
/* line 787 "ControlFlow.puma" */
   return mOP_EXP (mOP_EQ (), exp, selector);

}

static tTree TranslateLoop
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_LOOP) {
/* line 811 "ControlFlow.puma" */
 {
  tIdent id;
  tTree newloop;
  int exit_label;
  int cycle_label;
  rbool yyV1;
  rbool yyV2;
  {
/* line 819 "ControlFlow.puma" */
   set_protocol_stmt (t);
/* line 820 "ControlFlow.puma" */
   stmt_protocol ("translate LOOP statement");
/* line 822 "ControlFlow.puma" */
 if (t->ACF_LOOP.Label >= 0) 
         id = DefaultId();
       else
         { id = -t->ACF_LOOP.Label;
           t->ACF_LOOP.Label = 0;    
         }
 
    
/* line 831 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_LOOP.LOOP_BODY, id, 0, & yyV1, & yyV2);
/* line 835 "ControlFlow.puma" */
 if (yyV2)
         { cycle_label = GetNewLabel ();
           t->ACF_LOOP.LOOP_BODY = AppendEndLabel (t->ACF_LOOP.LOOP_BODY, cycle_label);
         }

      newloop = MakeWhileLoop (t);
      if (yyV1)
         { exit_label = GetNewLabel ();
           newloop = mACF_LIST (newloop, 
                       mACF_LIST (ContinueStmt (exit_label), NoTree));
         }

      if (yyV1 || yyV2)
         ReplaceExitCycle (t->ACF_LOOP.LOOP_BODY, id, 0, exit_label, cycle_label);
    
/* line 851 "ControlFlow.puma" */
   tree_protocol ("new WHILE loop : \n", newloop);
  }
   return newloop;
 }

  }
  if (t->Kind == kACF_DO) {
/* line 856 "ControlFlow.puma" */
 {
  tIdent id;
  tTree newloop;
  int exit_label;
  int cycle_label;
  rbool yyV1;
  rbool yyV2;
  {
/* line 864 "ControlFlow.puma" */
 if (t->ACF_DO.Label >= 0) 
         id = DefaultId();
       else
         { id = -t->ACF_DO.Label;
           t->ACF_DO.Label = 0;    
         }
      newloop = t;
    
/* line 873 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_DO.DO_BODY, id, 0, & yyV1, & yyV2);
/* line 875 "ControlFlow.puma" */
 if (yyV2)
         { cycle_label = GetNewLabel ();
           t->ACF_DO.DO_BODY = AppendEndLabel (t->ACF_DO.DO_BODY, cycle_label);
         }

      if (yyV1)
         { exit_label = GetNewLabel ();
           newloop = mACF_LIST (newloop, 
                       mACF_LIST (ContinueStmt (exit_label), NoTree));
         }

      if (yyV1 || yyV2)
         ReplaceExitCycle (t->ACF_DO.DO_BODY, id, 0, exit_label, cycle_label);
    
  }
   return newloop;
 }

  }
  if (t->Kind == kACF_WHILE) {
/* line 893 "ControlFlow.puma" */
 {
  tIdent id;
  tTree newloop;
  int exit_label;
  int cycle_label;
  rbool yyV1;
  rbool yyV2;
  {
/* line 901 "ControlFlow.puma" */
 if (t->ACF_WHILE.Label >= 0) 
         id = DefaultId();
       else
         { id = -t->ACF_WHILE.Label;
           t->ACF_WHILE.Label = 0;    
         }
      newloop = t;
    
/* line 910 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_WHILE.WHILE_BODY, id, 0, & yyV1, & yyV2);
/* line 912 "ControlFlow.puma" */
 if (yyV2)
         { cycle_label = GetNewLabel ();
           t->ACF_WHILE.WHILE_BODY = AppendEndLabel (t->ACF_WHILE.WHILE_BODY, cycle_label);
         }

      if (yyV1)
         { exit_label = GetNewLabel ();
           newloop = mACF_LIST (newloop, 
                       mACF_LIST (ContinueStmt (exit_label), NoTree));
         }

      if (yyV1 || yyV2)
         ReplaceExitCycle (t->ACF_WHILE.WHILE_BODY, id, 0, exit_label, cycle_label);
    
  }
   return newloop;
 }

  }
/* line 931 "ControlFlow.puma" */
  {
/* line 932 "ControlFlow.puma" */
   failure_protocol (MODULE, "TranslateLoop", t);
  }
   return NoTree;

}

static tTree MakeWhileLoop
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_LOOP) {
/* line 946 "ControlFlow.puma" */
 {
  tTree while_stmt;
  {
/* line 950 "ControlFlow.puma" */
   while_stmt = mCONST_EXP (mBOOL_CONSTANT (1));
/* line 951 "ControlFlow.puma" */
   while_stmt = mACF_WHILE (while_stmt, t->ACF_LOOP.LOOP_BODY);
/* line 953 "ControlFlow.puma" */
   LabelACFNode (while_stmt, t->ACF_LOOP.Label);
/* line 954 "ControlFlow.puma" */
   LineACFNode (while_stmt, t->ACF_LOOP.Line);
  }
   return while_stmt;
 }

  }
/* line 959 "ControlFlow.puma" */
  {
/* line 960 "ControlFlow.puma" */
   failure_protocol (MODULE, "MakeWhileLoop", t);
  }
   return t;

}

static void FindExitOrCycle
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tIdent name, register int level, register rbool * yyP4, register rbool * yyP3)
# else
(t, name, level, yyP4, yyP3)
 register tTree t;
 register tIdent name;
 register int level;
 register rbool * yyP4;
 register rbool * yyP3;
# endif
{

  switch (t->Kind) {
  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kEXIT_STMT) {
/* line 972 "ControlFlow.puma" */
  {
/* line 973 "ControlFlow.puma" */
   if (! ((t->ACF_BASIC.BASIC_STMT->EXIT_STMT.loopid == DefaultId ()))) goto yyL1;
  {
/* line 974 "ControlFlow.puma" */
   if (! ((level == 0))) goto yyL1;
  }
  }
   * yyP4 = rtrue;
   * yyP3 = rfalse;
   return;
yyL1:;

/* line 977 "ControlFlow.puma" */
  {
/* line 978 "ControlFlow.puma" */
   if (! ((t->ACF_BASIC.BASIC_STMT->EXIT_STMT.loopid == DefaultId ()))) goto yyL2;
  }
   * yyP4 = rfalse;
   * yyP3 = rfalse;
   return;
yyL2:;

/* line 981 "ControlFlow.puma" */
  {
/* line 982 "ControlFlow.puma" */
   if (! ((t->ACF_BASIC.BASIC_STMT->EXIT_STMT.loopid == name))) goto yyL3;
  }
   * yyP4 = rtrue;
   * yyP3 = rfalse;
   return;
yyL3:;

/* line 985 "ControlFlow.puma" */
   * yyP4 = rfalse;
   * yyP3 = rfalse;
   return;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCYCLE_STMT) {
/* line 988 "ControlFlow.puma" */
  {
/* line 989 "ControlFlow.puma" */
   if (! ((t->ACF_BASIC.BASIC_STMT->CYCLE_STMT.loopid == DefaultId ()))) goto yyL5;
  {
/* line 990 "ControlFlow.puma" */
   if (! ((level == 0))) goto yyL5;
  }
  }
   * yyP4 = rfalse;
   * yyP3 = rtrue;
   return;
yyL5:;

/* line 993 "ControlFlow.puma" */
  {
/* line 994 "ControlFlow.puma" */
   if (! ((t->ACF_BASIC.BASIC_STMT->CYCLE_STMT.loopid == DefaultId ()))) goto yyL6;
  }
   * yyP4 = rfalse;
   * yyP3 = rfalse;
   return;
yyL6:;

/* line 997 "ControlFlow.puma" */
  {
/* line 998 "ControlFlow.puma" */
   if (! ((t->ACF_BASIC.BASIC_STMT->CYCLE_STMT.loopid == name))) goto yyL7;
  }
   * yyP4 = rfalse;
   * yyP3 = rtrue;
   return;
yyL7:;

  }
  break;
  case kACF_LIST:
/* line 1001 "ControlFlow.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  rbool yyV3;
  rbool yyV4;
  {
/* line 1002 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_LIST.Elem, name, level, & yyV1, & yyV2);
/* line 1003 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_LIST.Next, name, level, & yyV3, & yyV4);
  }
   * yyP4 = (yyV1 || yyV3);
   * yyP3 = (yyV2 || yyV4);
   return;
 }

  case kACF_IF:
/* line 1006 "ControlFlow.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  rbool yyV3;
  rbool yyV4;
  {
/* line 1007 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_IF.THEN_PART, name, level, & yyV1, & yyV2);
/* line 1008 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_IF.ELSE_PART, name, level, & yyV3, & yyV4);
  }
   * yyP4 = (yyV1 || yyV3);
   * yyP3 = (yyV2 || yyV4);
   return;
 }

  case kACF_DO:
/* line 1011 "ControlFlow.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  {
/* line 1013 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_DO.DO_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  case kACF_HOME:
/* line 1016 "ControlFlow.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  {
/* line 1017 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_HOME.HOME_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  case kACF_NEW:
/* line 1020 "ControlFlow.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  {
/* line 1021 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_NEW.NEW_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  case kACF_RESIDENT:
/* line 1024 "ControlFlow.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  {
/* line 1025 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_RESIDENT.RESIDENT_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  case kACF_REDUCTION:
/* line 1028 "ControlFlow.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  {
/* line 1030 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_REDUCTION.REDUCTION_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  case kACF_WHILE:
/* line 1033 "ControlFlow.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  {
/* line 1034 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_WHILE.WHILE_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  case kACF_LOOP:
/* line 1037 "ControlFlow.puma" */
 {
  rbool yyV1;
  rbool yyV2;
  {
/* line 1038 "ControlFlow.puma" */
   FindExitOrCycle (t->ACF_LOOP.LOOP_BODY, name, level + 1, & yyV1, & yyV2);
  }
   * yyP4 = yyV1;
   * yyP3 = yyV2;
   return;
 }

  }

/* line 1043 "ControlFlow.puma" */
   * yyP4 = rfalse;
   * yyP3 = rfalse;
   return;

;
}

static void ReplaceExitCycle
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tIdent name, register int level, register int exit_label, register int cycle_label)
# else
(t, name, level, exit_label, cycle_label)
 register tTree t;
 register tIdent name;
 register int level;
 register int exit_label;
 register int cycle_label;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kEXIT_STMT) {
/* line 1055 "ControlFlow.puma" */
  {
/* line 1056 "ControlFlow.puma" */
   if (! ((t->ACF_BASIC.BASIC_STMT->EXIT_STMT.loopid == DefaultId ()))) goto yyL1;
  {
/* line 1057 "ControlFlow.puma" */
   if (! ((level == 0))) goto yyL1;
  {
/* line 1058 "ControlFlow.puma" */
 t->ACF_BASIC.BASIC_STMT = mGOTO_STMT (exit_label); 
/* line 1059 "ControlFlow.puma" */
   LabelUse (exit_label);
  }
  }
  }
   return;
yyL1:;

/* line 1062 "ControlFlow.puma" */
  {
/* line 1063 "ControlFlow.puma" */
   if (! ((t->ACF_BASIC.BASIC_STMT->EXIT_STMT.loopid == DefaultId ()))) goto yyL2;
  }
   return;
yyL2:;

/* line 1066 "ControlFlow.puma" */
  {
/* line 1067 "ControlFlow.puma" */
   if (! ((t->ACF_BASIC.BASIC_STMT->EXIT_STMT.loopid == name))) goto yyL3;
  {
/* line 1068 "ControlFlow.puma" */
 t->ACF_BASIC.BASIC_STMT = mGOTO_STMT (exit_label); 
/* line 1069 "ControlFlow.puma" */
   LabelUse (exit_label);
  }
  }
   return;
yyL3:;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCYCLE_STMT) {
/* line 1072 "ControlFlow.puma" */
  {
/* line 1073 "ControlFlow.puma" */
   if (! ((t->ACF_BASIC.BASIC_STMT->CYCLE_STMT.loopid == DefaultId ()))) goto yyL4;
  {
/* line 1074 "ControlFlow.puma" */
   if (! ((level == 0))) goto yyL4;
  {
/* line 1075 "ControlFlow.puma" */
 t->ACF_BASIC.BASIC_STMT = mGOTO_STMT (cycle_label); 
/* line 1076 "ControlFlow.puma" */
   LabelUse (cycle_label);
  }
  }
  }
   return;
yyL4:;

/* line 1079 "ControlFlow.puma" */
  {
/* line 1080 "ControlFlow.puma" */
   if (! ((t->ACF_BASIC.BASIC_STMT->CYCLE_STMT.loopid == DefaultId ()))) goto yyL5;
  }
   return;
yyL5:;

/* line 1083 "ControlFlow.puma" */
  {
/* line 1084 "ControlFlow.puma" */
   if (! ((t->ACF_BASIC.BASIC_STMT->CYCLE_STMT.loopid == name))) goto yyL6;
  {
/* line 1085 "ControlFlow.puma" */
 t->ACF_BASIC.BASIC_STMT = mGOTO_STMT (cycle_label); 
/* line 1086 "ControlFlow.puma" */
   LabelUse (cycle_label);
  }
  }
   return;
yyL6:;

  }
  break;
  case kACF_LIST:
/* line 1089 "ControlFlow.puma" */
  {
/* line 1090 "ControlFlow.puma" */
   ReplaceExitCycle (t->ACF_LIST.Elem, name, level, exit_label, cycle_label);
/* line 1091 "ControlFlow.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kACF_IF:
/* line 1094 "ControlFlow.puma" */
  {
/* line 1095 "ControlFlow.puma" */
   ReplaceExitCycle (t->ACF_IF.THEN_PART, name, level, exit_label, cycle_label);
/* line 1096 "ControlFlow.puma" */
   t = t->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  case kACF_DO:
/* line 1099 "ControlFlow.puma" */
  {
/* line 1101 "ControlFlow.puma" */
   t = t->ACF_DO.DO_BODY;
   level = level + 1;
   goto yyRecursion;
  }

  case kACF_HOME:
/* line 1104 "ControlFlow.puma" */
  {
/* line 1106 "ControlFlow.puma" */
   t = t->ACF_HOME.HOME_BODY;
   level = level + 1;
   goto yyRecursion;
  }

  case kACF_NEW:
/* line 1109 "ControlFlow.puma" */
  {
/* line 1110 "ControlFlow.puma" */
   t = t->ACF_NEW.NEW_BODY;
   level = level + 1;
   goto yyRecursion;
  }

  case kACF_RESIDENT:
/* line 1113 "ControlFlow.puma" */
  {
/* line 1114 "ControlFlow.puma" */
   t = t->ACF_RESIDENT.RESIDENT_BODY;
   level = level + 1;
   goto yyRecursion;
  }

  case kACF_REDUCTION:
/* line 1117 "ControlFlow.puma" */
  {
/* line 1119 "ControlFlow.puma" */
   t = t->ACF_REDUCTION.REDUCTION_BODY;
   level = level + 1;
   goto yyRecursion;
  }

  case kACF_WHILE:
/* line 1122 "ControlFlow.puma" */
  {
/* line 1123 "ControlFlow.puma" */
   t = t->ACF_WHILE.WHILE_BODY;
   level = level + 1;
   goto yyRecursion;
  }

  case kACF_LOOP:
/* line 1126 "ControlFlow.puma" */
  {
/* line 1127 "ControlFlow.puma" */
   t = t->ACF_LOOP.LOOP_BODY;
   level = level + 1;
   goto yyRecursion;
  }

  }

/* line 1132 "ControlFlow.puma" */
   return;

;
}

static tTree TranslateIOStmt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
/* line 1143 "ControlFlow.puma" */
 {
  tTree new;
  tTree goto_stmt;
  {
/* line 1145 "ControlFlow.puma" */
   end_label = 0;
/* line 1146 "ControlFlow.puma" */
   err_label = 0;
/* line 1147 "ControlFlow.puma" */
   eor_label = 0;
/* line 1149 "ControlFlow.puma" */
   io_stat = NoTree;
/* line 1150 "ControlFlow.puma" */
   is_label = rfalse;
/* line 1152 "ControlFlow.puma" */
   AnalyseIOSpecs (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS);
/* line 1157 "ControlFlow.puma" */
 new = t;

     if (is_label) stmt_protocol ("remove implicit gotos of IO stmt");

     

     if (is_label)  t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS = UpdateIOSpecs (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS);
       
     if (end_label != 0)

        {  

           goto_stmt = MakeJumpStmt (mOP_EQ(), IOSTAT_END_OF_FILE, end_label);

           new = CombineACF (new, goto_stmt);
        }

     if (eor_label != 0)

        {  

           goto_stmt = MakeJumpStmt (mOP_EQ(), IOSTAT_END_OF_RECORD, eor_label);

           new = CombineACF (new, goto_stmt);
        }

     if (err_label != 0)

        {  

           goto_stmt = MakeJumpStmt (mOP_GT(), 0, err_label);

           new = CombineACF (new, goto_stmt);
        }

     if (is_label)
        tree_protocol ("new io statement :\n", new);

   
  }
   return new;
 }

  }
  }
/* line 1199 "ControlFlow.puma" */
  {
/* line 1200 "ControlFlow.puma" */
   failure_protocol (MODULE, "TranslateIOStmt", t);
  }
   return NoTree;

}

static void AnalyseIOSpecs
# if defined __STDC__ | defined __cplusplus
(register tTree specs)
# else
(specs)
 register tTree specs;
# endif
{
 yyRecursion:
  if (specs->Kind == kBTP_LIST) {
/* line 1212 "ControlFlow.puma" */
  {
/* line 1213 "ControlFlow.puma" */
   AnalyseIOSpecs (specs->BTP_LIST.Elem);
/* line 1214 "ControlFlow.puma" */
   specs = specs->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  if (specs->Kind == kBTP_EMPTY) {
/* line 1217 "ControlFlow.puma" */
   return;

  }
  if (specs->Kind == kNAMED_PARAM) {
/* line 1220 "ControlFlow.puma" */
  {
/* line 1221 "ControlFlow.puma" */
   if (! ((specs->NAMED_PARAM.Name == MakeIdent ("ERR", 3)))) goto yyL3;
  {
/* line 1222 "ControlFlow.puma" */
   err_label = GetLabel (specs->NAMED_PARAM.VAL);
/* line 1223 "ControlFlow.puma" */
   is_label = rtrue;
  }
  }
   return;
yyL3:;

/* line 1226 "ControlFlow.puma" */
  {
/* line 1227 "ControlFlow.puma" */
   if (! ((specs->NAMED_PARAM.Name == MakeIdent ("END", 3)))) goto yyL4;
  {
/* line 1228 "ControlFlow.puma" */
   end_label = GetLabel (specs->NAMED_PARAM.VAL);
/* line 1229 "ControlFlow.puma" */
   is_label = rtrue;
  }
  }
   return;
yyL4:;

/* line 1232 "ControlFlow.puma" */
  {
/* line 1233 "ControlFlow.puma" */
   if (! ((specs->NAMED_PARAM.Name == MakeIdent ("EOR", 3)))) goto yyL5;
  {
/* line 1234 "ControlFlow.puma" */
   eor_label = GetLabel (specs->NAMED_PARAM.VAL);
/* line 1235 "ControlFlow.puma" */
   is_label = rtrue;
  }
  }
   return;
yyL5:;

/* line 1238 "ControlFlow.puma" */
  {
/* line 1239 "ControlFlow.puma" */
   if (! ((specs->NAMED_PARAM.Name == MakeIdent ("IOSTAT", 6)))) goto yyL6;
  {
/* line 1240 "ControlFlow.puma" */
   GetIOStat (specs->NAMED_PARAM.VAL);
  }
  }
   return;
yyL6:;

  }
;
}

static int GetLabel
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kADDR) {
/* line 1251 "ControlFlow.puma" */
   t = t->VAR_PARAM.V->ADDR.E;
   goto yyRecursion;

  }
  }
  if (t->Kind == kVALUE_PARAM) {
/* line 1255 "ControlFlow.puma" */
   t = t->VALUE_PARAM.E;
   goto yyRecursion;

  }
  if (t->Kind == kCONST_EXP) {
  if (t->CONST_EXP.C->Kind == kINT_CONSTANT) {
/* line 1259 "ControlFlow.puma" */
   return t->CONST_EXP.C->INT_CONSTANT.value;

  }
  }
/* line 1263 "ControlFlow.puma" */
  {
/* line 1264 "ControlFlow.puma" */
   error_protocol ("illegal label in IO statement");
/* line 1265 "ControlFlow.puma" */
   tree_protocol ("label is : ", t);
  }
   return 0;

}

static void GetIOStat
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kUSED_VAR) {
/* line 1277 "ControlFlow.puma" */
  {
/* line 1278 "ControlFlow.puma" */
   io_stat = t->VAR_PARAM.V;
  }
   return;

  }
  }
  if (t->Kind == kVALUE_PARAM) {
  if (t->VALUE_PARAM.E->Kind == kVAR_EXP) {
  if (t->VALUE_PARAM.E->VAR_EXP.V->Kind == kUSED_VAR) {
/* line 1281 "ControlFlow.puma" */
  {
/* line 1282 "ControlFlow.puma" */
   io_stat = t->VALUE_PARAM.E->VAR_EXP.V;
  }
   return;

  }
  }
  }
/* line 1285 "ControlFlow.puma" */
  {
/* line 1286 "ControlFlow.puma" */
   error_protocol ("illegal IOSTAT in IO statement");
/* line 1287 "ControlFlow.puma" */
   tree_protocol ("IOSTAT var is : ", t);
  }
   return;

;
}

static tTree UpdateIOSpecs
# if defined __STDC__ | defined __cplusplus
(register tTree specs)
# else
(specs)
 register tTree specs;
# endif
{
 yyRecursion:
  if (specs->Kind == kBTP_LIST) {
/* line 1298 "ControlFlow.puma" */
  {
/* line 1299 "ControlFlow.puma" */
   if (! ((IsLabelSpec (specs->BTP_LIST.Elem)))) goto yyL1;
  }
   specs = specs->BTP_LIST.Next;
   goto yyRecursion;
yyL1:;

/* line 1303 "ControlFlow.puma" */
  {
/* line 1304 "ControlFlow.puma" */
 specs->BTP_LIST.Next = UpdateIOSpecs (specs->BTP_LIST.Next); 
  }
   return specs;

  }
  if (specs->Kind == kBTP_EMPTY) {
/* line 1308 "ControlFlow.puma" */
  {
/* line 1310 "ControlFlow.puma" */
   if (! ((io_stat == NoTree))) goto yyL3;
  {
/* line 1312 "ControlFlow.puma" */
   io_stat = GetScalarTemporary (MakeIntegerType (default_int_size));
  }
  }
   return mBTP_LIST (mNAMED_PARAM (MakeIdent ("IOSTAT", 6), mVAR_PARAM (CopyTree (io_stat))), specs);
yyL3:;

/* line 1318 "ControlFlow.puma" */
   return specs;

  }
/* line 1322 "ControlFlow.puma" */
  {
/* line 1323 "ControlFlow.puma" */
   failure_protocol (MODULE, "UpdateIOSpecs", specs);
  }
   return NoTree;

}

static rbool IsLabelSpec
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
  if (spec->Kind == kNAMED_PARAM) {
/* line 1329 "ControlFlow.puma" */
  {
/* line 1330 "ControlFlow.puma" */
   if (! ((spec->NAMED_PARAM.Name == MakeIdent ("ERR", 3)))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 1333 "ControlFlow.puma" */
  {
/* line 1334 "ControlFlow.puma" */
   if (! ((spec->NAMED_PARAM.Name == MakeIdent ("END", 3)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 1337 "ControlFlow.puma" */
  {
/* line 1338 "ControlFlow.puma" */
   if (! ((spec->NAMED_PARAM.Name == MakeIdent ("EOR", 3)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

static tTree MakeJumpStmt
# if defined __STDC__ | defined __cplusplus
(register tTree op, register int value, register int label)
# else
(op, value, label)
 register tTree op;
 register int value;
 register int label;
# endif
{
/* line 1351 "ControlFlow.puma" */
  {
/* line 1352 "ControlFlow.puma" */
   if (! ((label == 0))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 1356 "ControlFlow.puma" */
 {
  tTree stmt;
  tTree condition;
  {
/* line 1361 "ControlFlow.puma" */
   stmt = mACF_BASIC (mGOTO_STMT (label));
/* line 1363 "ControlFlow.puma" */
   LabelUse (label);
/* line 1365 "ControlFlow.puma" */
   stmt = mACF_LIST (stmt, mACF_EMPTY ());
/* line 1367 "ControlFlow.puma" */
   condition = mOP_EXP (op, mVAR_EXP (CopyTree (io_stat)), MakeConstant (value));
/* line 1370 "ControlFlow.puma" */
   stmt = mACF_IF (condition, stmt, mACF_EMPTY ());
  }
   return stmt;
 }

}

void BeginControlFlow ARGS ((void))
{
}

void CloseControlFlow ARGS ((void))
{
}
