# include "Common.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 67 "Common.puma" */


# define  MODULE "Common"

# include "Idents.h"
# include "StringM.h"
# include "Objects.h"
# include "Types.h"
# include "protocol.h"
# include "DefTable.h"
# include "TreeOps.h" 
# include "Distributions.h"
# include "Expressions.h"
# include "Shapes.h"

# define NO_ERROR    0
# define SEQ_ERROR   1

static int error;          /* indicates an error            */
static int seq_diff;       /* difference in sequential size */

static int overlap_error;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCommon.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Common_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Common, routine %s failed\n",
  yyFunction);
 Common_Exit ();
}

void CheckCommonBlock ARGS ((tTree t, rbool is_main));
void CheckCommonDescriptors ARGS ((tTree t, CompareRoutine p));
static void CompareGlobalLocal ARGS ((tDefinitions t, tTree common, rbool is_main));
static int CommonEntries ARGS ((tTree cd));
static int GetCommonSize ARGS ((tTree t));
static int GetTypeSize ARGS ((tTree t));
static int GetIndexSize ARGS ((tTree t));
static void MatchCommonBlocks ARGS ((tDefinitions t, tTree common, CompareRoutine p));
static void MatchForDescriptors ARGS ((tTree global, tTree local, tDefinitions scope, int diff, CompareRoutine p));
void CheckActualDescriptors ARGS ((tTree t, CompareRoutine p));
static tTree RealActuals ARGS ((tTree actuals, tDefinitions routine));
static int GetObjSize ARGS ((tDefinitions obj));
static rbool IsSequential ARGS ((tDefinitions obj));
void PrintCommonBlock ARGS ((tTree decl, int dist_flag));
static void PrintCommonData ARGS ((tTree decl, tDefinitions scope, int dist_flag));
void PrintCall ARGS ((tTree call));
static void PrintParameters ARGS ((tTree actuals, tTree dummies, tDefinitions dscope));
static void PrintParam ARGS ((tTree actual, tDefinitions dummy));
static void MatchParameterList ARGS ((tTree actuals, tTree dummies, tDefinitions dscope, CompareRoutine cp));
static void MatchSingleParameter ARGS ((tTree actual, tDefinitions dummy, CompareRoutine p));
static void GetFullVarObject ARGS ((tTree param, rbool * yyP2, tDefinitions * yyP1));

void CheckCommonBlock
# if defined __STDC__ | defined __cplusplus
(register tTree t, register rbool is_main)
# else
(t, is_main)
 register tTree t;
 register rbool is_main;
# endif
{
  if (t->Kind == kCOMMON_DECL) {
/* line 103 "Common.puma" */
 {
  tDefinitions global;
  {
/* line 107 "Common.puma" */
   global = GetDeclEntry (t->COMMON_DECL.Ident, GetCommonEntries ());
/* line 109 "Common.puma" */
   CompareGlobalLocal (global, t, is_main);
  }
   return;
 }

  }
/* line 112 "Common.puma" */
  {
/* line 113 "Common.puma" */
   failure_protocol (MODULE, "CheckCommonBlock", t);
  }
   return;

;
}

void CheckCommonDescriptors
# if defined __STDC__ | defined __cplusplus
(register tTree t, CompareRoutine p)
# else
(t, p)
 register tTree t;
 CompareRoutine p;
# endif
{
  if (t->Kind == kCOMMON_DECL) {
/* line 127 "Common.puma" */
 {
  tDefinitions global;
  {
/* line 131 "Common.puma" */
   global = GetDeclEntry (t->COMMON_DECL.Ident, GetCommonEntries ());
/* line 133 "Common.puma" */
   MatchCommonBlocks (global, t, p);
  }
   return;
 }

  }
/* line 136 "Common.puma" */
  {
/* line 137 "Common.puma" */
   failure_protocol (MODULE, "CheckCommonDescriptors", t);
  }
   return;

;
}

static void CompareGlobalLocal
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t, register tTree common, register rbool is_main)
# else
(t, common, is_main)
 register tDefinitions t;
 register tTree common;
 register rbool is_main;
# endif
{
/* line 148 "Common.puma" */

char msg[150];

/* line 152 "Common.puma" */
  {
/* line 156 "Common.puma" */
   if (! ((t == NoObject))) goto yyL1;
  {
/* line 157 "Common.puma" */
   tree_error_protocol ("No Object for Common", common);
  }
  }
   return;
yyL1:;

  if (t->Kind == kCommonObject) {
/* line 160 "Common.puma" */
  {
/* line 163 "Common.puma" */
   if (! ((t->CommonObject.decl == common))) goto yyL2;
  {
/* line 166 "Common.puma" */
 

     t->CommonObject.size     = GetCommonSize     (common);
     t->CommonObject.distributed_vars = 0;
     t->CommonObject.main     = is_main;

   
  }
  }
   return;
yyL2:;

/* line 175 "Common.puma" */
 {
  int size;
  {
/* line 178 "Common.puma" */
   if (! ((t->CommonObject.decl != common))) goto yyL3;
  {
/* line 184 "Common.puma" */
 t->CommonObject.main = t->CommonObject.main || is_main;

         

     size = GetCommonSize (common);

     if (size != t->CommonObject.size)

       { set_protocol_stmt (common);

         serious_warning_protocol
              ("incompatible lengths for common block data");

         PrintCommonBlock (common, 0);

         sprintf (msg,"acutal has size %d , reference has size %d", 
                       size, t->CommonObject.size);
         print_protocol (msg);
       }
 
     if (CommonEntries (common) != CommonEntries (t->CommonObject.decl))
 
       { simple_warning_protocol
              ("different number of entries for common block data");
         PrintCommonBlock (common, 0);
         sprintf (msg,"acutal has %d entries, reference has %d entries", 
                       CommonEntries (common), CommonEntries (t->CommonObject.decl));
         print_protocol (msg);
       }
 
   
  }
  }
   return;
 }
yyL3:;

  }
/* line 217 "Common.puma" */
  {
/* line 219 "Common.puma" */
   failure_protocol (MODULE, "CheckGlobalLocal", common);
  }
   return;

;
}

static int CommonEntries
# if defined __STDC__ | defined __cplusplus
(register tTree cd)
# else
(cd)
 register tTree cd;
# endif
{
  if (cd->Kind == kCOMMON_DECL) {
/* line 230 "Common.puma" */
   return TreeListLength (cd->COMMON_DECL.IDS);

  }
 yyAbort ("CommonEntries");
 { int yyDummy; return yyDummy; }
}

static int GetCommonSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kCOMMON_DECL) {
/* line 247 "Common.puma" */
   t = t->COMMON_DECL.IDS;
   goto yyRecursion;

  }
  if (t->Kind == kDECL_LIST) {
/* line 251 "Common.puma" */
   return GetCommonSize (t->DECL_LIST.Elem) + GetCommonSize (t->DECL_LIST.Next);

  }
  if (t->Kind == kDECL_EMPTY) {
/* line 255 "Common.puma" */
   return 0;

  }
  if (t->Kind == kVAR_DECL) {
/* line 259 "Common.puma" */
 {
  tDefinitions Obj;
  {
/* line 264 "Common.puma" */
   Obj = GetLocalObject (t->VAR_DECL.Ident);
  }
   return GetTypeSize (Obj->VarObject.decl);
 }

  }
/* line 269 "Common.puma" */
  {
/* line 270 "Common.puma" */
   failure_protocol (MODULE, "GetCommonSize", t);
  }
   return 0;

}

static int GetTypeSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kVAR_DECL) {
/* line 280 "Common.puma" */
   t = t->VAR_DECL.VAL;
   goto yyRecursion;

  }
  if (t->Kind == kARRAY_TYPE) {
/* line 284 "Common.puma" */
   return GetIndexSize (t->ARRAY_TYPE.ARRAY_INDEX_TYPES) * TreeSize (t->ARRAY_TYPE.ARRAY_COMP_TYPE);

  }
/* line 288 "Common.puma" */
   return TreeSize (t);

}

static int GetIndexSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kSHAPE_LIST) {
  if (t->SHAPE_LIST.Next->Kind == kSHAPE_EMPTY) {
/* line 298 "Common.puma" */
   t = t->SHAPE_LIST.Elem;
   goto yyRecursion;

  }
/* line 302 "Common.puma" */
   return GetIndexSize (t->SHAPE_LIST.Elem) * GetIndexSize (t->SHAPE_LIST.Next);

  }
  if (t->Kind == kEXPLICIT_SHAPE) {
/* line 306 "Common.puma" */
 {
  int lval;
  int hval;
  int size;
  rbool found;
  {
/* line 313 "Common.puma" */
   GetIntConstValue (t->EXPLICIT_SHAPE.LOWER, & found, & lval);
/* line 314 "Common.puma" */
   if (! (found)) goto yyL3;
  {
/* line 315 "Common.puma" */
   GetIntConstValue (t->EXPLICIT_SHAPE.UPPER, & found, & hval);
/* line 316 "Common.puma" */
   if (! (found)) goto yyL3;
  {
/* line 317 "Common.puma" */
   size = hval - lval + 1;
  }
  }
  }
   return size;
 }
yyL3:;

  }
  if (Tree_IsType (t, kSHAPE_SPEC)) {
/* line 321 "Common.puma" */
   return 0;

  }
/* line 325 "Common.puma" */
  {
/* line 326 "Common.puma" */
   failure_protocol (MODULE, "GetIndexSize", t);
  }
   return 0;

}

static void MatchCommonBlocks
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t, register tTree common, CompareRoutine p)
# else
(t, common, p)
 register tDefinitions t;
 register tTree common;
 CompareRoutine p;
# endif
{
/* line 338 "Common.puma" */

char msg[150];

/* line 342 "Common.puma" */
  {
/* line 346 "Common.puma" */
   if (! ((t == NoObject))) goto yyL1;
  {
/* line 347 "Common.puma" */
   tree_error_protocol ("No Object for Common", common);
  }
  }
   return;
yyL1:;

  if (t->Kind == kCommonObject) {
/* line 350 "Common.puma" */
  {
/* line 352 "Common.puma" */
   if (! ((t->CommonObject.decl == common))) goto yyL2;
  }
   return;
yyL2:;

/* line 355 "Common.puma" */
  {
/* line 358 "Common.puma" */
   error = NO_ERROR;
/* line 360 "Common.puma" */
   MatchForDescriptors (t->CommonObject.decl, common, t->CommonObject.CommonElements, 0, p);
/* line 362 "Common.puma" */
 if (error == SEQ_ERROR)

      { simple_error_protocol ("COMMON BLOCK mismatch of sequential data");
        PrintCommonBlock (common, 1);  
        sprintf (msg, "difference for sequential data : %d", seq_diff);
        print_protocol (msg);
      }
   
  }
   return;

  }
/* line 372 "Common.puma" */
  {
/* line 373 "Common.puma" */
   failure_protocol (MODULE, "MatchCommonBlocks", common);
  }
   return;

;
}

static void MatchForDescriptors
# if defined __STDC__ | defined __cplusplus
(register tTree global, register tTree local, register tDefinitions scope, register int diff, CompareRoutine p)
# else
(global, local, scope, diff, p)
 register tTree global;
 register tTree local;
 register tDefinitions scope;
 register int diff;
 CompareRoutine p;
# endif
{
 yyRecursion:
  if (global->Kind == kCOMMON_DECL) {
  if (local->Kind == kCOMMON_DECL) {
/* line 389 "Common.puma" */
  {
/* line 391 "Common.puma" */
   global = global->COMMON_DECL.IDS;
   local = local->COMMON_DECL.IDS;
   goto yyRecursion;
  }

  }
  }
  if (global->Kind == kDECL_LIST) {
/* line 394 "Common.puma" */
 {
  tDefinitions global_obj;
  {
/* line 398 "Common.puma" */
   global_obj = GetDeclEntry (global->DECL_LIST.Elem->DECL_NODE.Ident, scope);
/* line 400 "Common.puma" */
   if (! ((IsSequential (global_obj)))) goto yyL2;
  {
/* line 402 "Common.puma" */
   global = global->DECL_LIST.Next;
   diff = diff - GetObjSize (global_obj);
   goto yyRecursion;
  }
  }
 }
yyL2:;

  }
  if (local->Kind == kDECL_LIST) {
/* line 406 "Common.puma" */
 {
  tDefinitions local_obj;
  {
/* line 410 "Common.puma" */
   local_obj = GetLocalObject (local->DECL_LIST.Elem->DECL_NODE.Ident);
/* line 412 "Common.puma" */
   if (! ((IsSequential (local_obj)))) goto yyL3;
  {
/* line 414 "Common.puma" */
   local = local->DECL_LIST.Next;
   diff = diff + GetObjSize (local_obj);
   goto yyRecursion;
  }
  }
 }
yyL3:;

  }
  if (global->Kind == kDECL_LIST) {
  if (local->Kind == kDECL_LIST) {
/* line 418 "Common.puma" */
  {
/* line 421 "Common.puma" */
   if (! ((diff == 0))) goto yyL4;
  {
/* line 425 "Common.puma" */
   p (GetLocalObject (local->DECL_LIST.Elem->DECL_NODE.Ident), GetDeclEntry (global->DECL_LIST.Elem->DECL_NODE.Ident, scope));
/* line 427 "Common.puma" */
   global = global->DECL_LIST.Next;
   local = local->DECL_LIST.Next;
   goto yyRecursion;
  }
  }
yyL4:;

  }
  }
  if (global->Kind == kDECL_EMPTY) {
  if (local->Kind == kDECL_EMPTY) {
/* line 430 "Common.puma" */
   return;

  }
  }
/* line 436 "Common.puma" */
  {
/* line 442 "Common.puma" */
   error = SEQ_ERROR;
/* line 443 "Common.puma" */
   seq_diff = diff;
  }
   return;

;
}

void CheckActualDescriptors
# if defined __STDC__ | defined __cplusplus
(register tTree t, CompareRoutine p)
# else
(t, p)
 register tTree t;
 CompareRoutine p;
# endif
{
  if (t->Kind == kCALL_STMT) {
/* line 456 "Common.puma" */
 {
  tTree Dummies;
  tDefinitions DummyScope;
  tDefinitions RefObject;
  {
/* line 464 "Common.puma" */
   RefObject = GetReferenceObject (t->CALL_STMT.CALL_ID->PROC_OBJ.Object);
/* line 466 "Common.puma" */
   if (! ((RefObject != NoObject))) goto yyL1;
  {
/* line 470 "Common.puma" */
   GetDummies (RefObject, & Dummies, & DummyScope);
/* line 472 "Common.puma" */
   error = NO_ERROR;
/* line 474 "Common.puma" */
 if ((Dummies == NoTree) || (DummyScope == NoDefinitions))
         { stmt_protocol ("illegal reference");
           obj_protocol ("call      object: ", t->CALL_STMT.CALL_ID->PROC_OBJ.Object);
           obj_protocol ("reference object: ", RefObject);
         }
       else
         MatchParameterList (RealActuals (t->CALL_STMT.CALL_PARAMS, RefObject),
                             Dummies, DummyScope, p);
    
/* line 484 "Common.puma" */
 if (error != NO_ERROR)
         { simple_error_protocol ("MISMATCH of ACTUALS/DUMMIES");
           PrintCall (t);
         }
    
  }
  }
   return;
 }
yyL1:;

/* line 491 "Common.puma" */
   return;

  }
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 496 "Common.puma" */
 {
  tTree Dummies;
  tDefinitions DummyScope;
  tDefinitions RefObject;
  {
/* line 504 "Common.puma" */
   RefObject = GetReferenceObject (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object);
/* line 506 "Common.puma" */
   if (! ((RefObject != NoObject))) goto yyL3;
  {
/* line 508 "Common.puma" */
   GetDummies (RefObject, & Dummies, & DummyScope);
/* line 510 "Common.puma" */
   error = NO_ERROR;
/* line 512 "Common.puma" */
 if ((Dummies == NoTree) || (DummyScope == NoDefinitions))

         { stmt_protocol ("illegal reference");
           obj_protocol ("call      object: ", t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object);
           obj_protocol ("reference object: ", RefObject);
         }

       else
         MatchParameterList (t->FUNC_CALL_EXP.FUNC_PARAMS, Dummies, DummyScope, p);
    
/* line 523 "Common.puma" */
 if (error != NO_ERROR)
         { simple_error_protocol ("MISMATCH of ACTUALS/DUMMIES");
           PrintCall (t);
         }
    
  }
  }
   return;
 }
yyL3:;

/* line 530 "Common.puma" */
   return;

  }
/* line 533 "Common.puma" */
  {
/* line 534 "Common.puma" */
   failure_protocol (MODULE, "CheckActualDescriptors", t);
  }
   return;

;
}

static tTree RealActuals
# if defined __STDC__ | defined __cplusplus
(register tTree actuals, register tDefinitions routine)
# else
(actuals, routine)
 register tTree actuals;
 register tDefinitions routine;
# endif
{
  if (actuals->Kind == kBTP_LIST) {
  if (routine->Kind == kFuncObject) {
/* line 548 "Common.puma" */
   return actuals->BTP_LIST.Next;

  }
  }
  if (routine->Kind == kFuncObject) {
/* line 553 "Common.puma" */
  {
/* line 555 "Common.puma" */
   error_protocol ("call of a function without arguments");
  }
   return actuals;

  }
/* line 560 "Common.puma" */
   return actuals;

}

static int GetObjSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 578 "Common.puma" */
  {
/* line 579 "Common.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 580 "Common.puma" */
   failure_protocol (MODULE, "GetObjSize", NoTree);
  }
  }
   return 0;
yyL1:;

/* line 584 "Common.puma" */
   return GetTypeSize (obj->Object.decl);

}

static rbool IsSequential
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 590 "Common.puma" */
  {
/* line 591 "Common.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 592 "Common.puma" */
   failure_protocol (MODULE, "IsSequential", NoTree);
  }
  }
   return rtrue;
yyL1:;

/* line 595 "Common.puma" */
  {
/* line 596 "Common.puma" */
   if (! ((VarDistribution (obj) == 0))) goto yyL2;
  }
   return rtrue;
yyL2:;

  return rfalse;
}

void PrintCommonBlock
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register int dist_flag)
# else
(decl, dist_flag)
 register tTree decl;
 register int dist_flag;
# endif
{
  if (decl->Kind == kCOMMON_DECL) {
/* line 611 "Common.puma" */
 {
  tDefinitions global;
  {
/* line 615 "Common.puma" */
   global = GetDeclEntry (decl->COMMON_DECL.Ident, GetCommonEntries ());
/* line 617 "Common.puma" */
   tree_protocol ("actual common block    :\n", decl);
/* line 619 "Common.puma" */
   PrintCommonData (decl, GetCurrentScope (), dist_flag);
/* line 621 "Common.puma" */
   tree_protocol ("reference common block :\n", global->CommonObject.decl);
/* line 623 "Common.puma" */
   PrintCommonData (global->CommonObject.decl, global->CommonObject.CommonElements, dist_flag);
  }
   return;
 }

  }
/* line 626 "Common.puma" */
  {
/* line 628 "Common.puma" */
   failure_protocol (MODULE, "PrintCommonBlock", decl);
  }
   return;

;
}

static void PrintCommonData
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tDefinitions scope, register int dist_flag)
# else
(decl, scope, dist_flag)
 register tTree decl;
 register tDefinitions scope;
 register int dist_flag;
# endif
{
/* line 633 "Common.puma" */

char msg[150], string[100];

 yyRecursion:
  if (decl->Kind == kCOMMON_DECL) {
/* line 637 "Common.puma" */
  {
/* line 639 "Common.puma" */
   PrintCommonData (decl->COMMON_DECL.IDS, scope, dist_flag);
/* line 640 "Common.puma" */
   print_protocol ("");
  }
   return;

  }
  if (decl->Kind == kDECL_LIST) {
/* line 643 "Common.puma" */
 {
  tDefinitions obj;
  int size;
  int is_dist;
  {
/* line 649 "Common.puma" */
   obj = GetDeclEntry (decl->DECL_LIST.Elem->DECL_NODE.Ident, scope);
/* line 650 "Common.puma" */
   size = GetObjSize (obj);
/* line 652 "Common.puma" */
 GetString (decl->DECL_LIST.Elem->DECL_NODE.Ident, string);
  
     is_dist = 0;     

     if (dist_flag) 
        if (!IsSequential(obj)) is_dist = 1;

     if (is_dist)
        sprintf (msg, "         %s : %d bytes", string, size);
      else
        sprintf (msg, "         %s : %d bytes, mapped", string, size);

     print_protocol (msg);
   
/* line 667 "Common.puma" */
   decl = decl->DECL_LIST.Next;
   goto yyRecursion;
  }
 }

  }
  if (decl->Kind == kDECL_EMPTY) {
/* line 670 "Common.puma" */
   return;

  }
/* line 673 "Common.puma" */
  {
/* line 675 "Common.puma" */
   failure_protocol (MODULE, "PrintCommonData", decl);
  }
   return;

;
}

void PrintCall
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kCALL_STMT) {
/* line 688 "Common.puma" */
 {
  tTree Dummies;
  tDefinitions DummyScope;
  {
/* line 690 "Common.puma" */
   tree_protocol ("subroutine call is : ", call);
/* line 695 "Common.puma" */
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Object == GetDeclEntry (call->CALL_STMT.CALL_ID->PROC_OBJ.Ident, GetUnitEntries ())))) goto yyL1;
  {
/* line 697 "Common.puma" */
   GetDummies (call->CALL_STMT.CALL_ID->PROC_OBJ.Object, & Dummies, & DummyScope);
/* line 699 "Common.puma" */
   PrintParameters (call->CALL_STMT.CALL_PARAMS, Dummies, DummyScope);
  }
  }
   return;
 }
yyL1:;

/* line 702 "Common.puma" */
  {
/* line 704 "Common.puma" */
   tree_protocol ("subroutine call is : ", call);
/* line 705 "Common.puma" */
   print_protocol ("no dummies are available");
  }
   return;

  }
  if (call->Kind == kFUNC_CALL_EXP) {
/* line 708 "Common.puma" */
 {
  tTree Dummies;
  tDefinitions DummyScope;
  {
/* line 710 "Common.puma" */
   tree_protocol ("function call is : ", call);
/* line 715 "Common.puma" */
   if (! ((call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object == GetDeclEntry (call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, GetUnitEntries ())))) goto yyL3;
  {
/* line 717 "Common.puma" */
   GetDummies (call->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object, & Dummies, & DummyScope);
/* line 719 "Common.puma" */
   PrintParameters (call->FUNC_CALL_EXP.FUNC_PARAMS, Dummies, DummyScope);
  }
  }
   return;
 }
yyL3:;

/* line 722 "Common.puma" */
  {
/* line 724 "Common.puma" */
   tree_protocol ("function call is : ", call);
/* line 725 "Common.puma" */
   print_protocol ("no dummies are available");
  }
   return;

  }
/* line 728 "Common.puma" */
  {
/* line 729 "Common.puma" */
   failure_protocol (MODULE, "PrintCall", call);
  }
   return;

;
}

static void PrintParameters
# if defined __STDC__ | defined __cplusplus
(register tTree actuals, register tTree dummies, register tDefinitions dscope)
# else
(actuals, dummies, dscope)
 register tTree actuals;
 register tTree dummies;
 register tDefinitions dscope;
# endif
{
 yyRecursion:
  if (actuals->Kind == kBTP_LIST) {
  if (dummies->Kind == kDECL_LIST) {
  if (dummies->DECL_LIST.Elem->Kind == kVAR_PARAM_DECL) {
/* line 735 "Common.puma" */
  {
/* line 738 "Common.puma" */
   PrintParam (actuals->BTP_LIST.Elem, GetDeclEntry (dummies->DECL_LIST.Elem->VAR_PARAM_DECL.Ident, dscope));
/* line 739 "Common.puma" */
   actuals = actuals->BTP_LIST.Next;
   dummies = dummies->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  if (dummies->Kind == kDECL_EMPTY) {
/* line 748 "Common.puma" */
  {
/* line 750 "Common.puma" */
   PrintParam (actuals->BTP_LIST.Elem, NoObject);
/* line 751 "Common.puma" */
   actuals = actuals->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  if (actuals->Kind == kBTP_EMPTY) {
  if (dummies->Kind == kDECL_LIST) {
  if (dummies->DECL_LIST.Elem->Kind == kVAR_PARAM_DECL) {
/* line 742 "Common.puma" */
  {
/* line 744 "Common.puma" */
   PrintParam (NoTree, GetDeclEntry (dummies->DECL_LIST.Elem->VAR_PARAM_DECL.Ident, dscope));
/* line 745 "Common.puma" */
   dummies = dummies->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  if (dummies->Kind == kDECL_EMPTY) {
/* line 754 "Common.puma" */
   return;

  }
  }
/* line 757 "Common.puma" */
  {
/* line 758 "Common.puma" */
   failure2_protocol (MODULE, "PrintParameters", actuals, dummies);
  }
   return;

;
}

static void PrintParam
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tDefinitions dummy)
# else
(actual, dummy)
 register tTree actual;
 register tDefinitions dummy;
# endif
{
/* line 763 "Common.puma" */
  {
/* line 765 "Common.puma" */
   if (! ((dummy == NoObject))) goto yyL1;
  {
/* line 767 "Common.puma" */
   tree_protocol ("  actual : ", actual);
/* line 768 "Common.puma" */
   print_protocol ("  dummy  : --");
/* line 769 "Common.puma" */
   print_protocol ("");
  }
  }
   return;
yyL1:;

/* line 772 "Common.puma" */
  {
/* line 773 "Common.puma" */
   tree_protocol ("  actual : ", actual);
/* line 774 "Common.puma" */
   tree_protocol ("  dummy  : ", dummy->Object.decl);
  }
   return;

;
}

static void MatchParameterList
# if defined __STDC__ | defined __cplusplus
(register tTree actuals, register tTree dummies, register tDefinitions dscope, CompareRoutine cp)
# else
(actuals, dummies, dscope, cp)
 register tTree actuals;
 register tTree dummies;
 register tDefinitions dscope;
 CompareRoutine cp;
# endif
{
 yyRecursion:
/* line 788 "Common.puma" */
  {
/* line 790 "Common.puma" */
   if (! ((TreeListLength (actuals) != TreeListLength (dummies)))) goto yyL1;
  {
/* line 792 "Common.puma" */
   error_protocol ("mismatch of actual parameters with their dummies");
/* line 793 "Common.puma" */
   tree_protocol ("actuals : ", actuals);
/* line 794 "Common.puma" */
   tree_protocol ("dummies : ", dummies);
  }
  }
   return;
yyL1:;

  if (actuals->Kind == kBTP_LIST) {
  if (dummies->Kind == kDECL_LIST) {
  if (dummies->DECL_LIST.Elem->Kind == kVAR_PARAM_DECL) {
/* line 797 "Common.puma" */
  {
/* line 800 "Common.puma" */
   MatchSingleParameter (actuals->BTP_LIST.Elem, GetDeclEntry (dummies->DECL_LIST.Elem->VAR_PARAM_DECL.Ident, dscope), cp);
/* line 801 "Common.puma" */
   actuals = actuals->BTP_LIST.Next;
   dummies = dummies->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  }
  if (actuals->Kind == kBTP_EMPTY) {
  if (dummies->Kind == kDECL_EMPTY) {
/* line 804 "Common.puma" */
   return;

  }
  }
/* line 808 "Common.puma" */
  {
/* line 812 "Common.puma" */
   failure2_protocol (MODULE, "MatchParameterList", actuals, dummies);
  }
   return;

;
}

static void MatchSingleParameter
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tDefinitions dummy, CompareRoutine p)
# else
(actual, dummy, p)
 register tTree actual;
 register tDefinitions dummy;
 CompareRoutine p;
# endif
{
  if (actual->Kind == kNO_PARAM) {
/* line 827 "Common.puma" */
   return;

  }
/* line 830 "Common.puma" */
  {
/* line 832 "Common.puma" */
   if (! ((dummy == NoObject))) goto yyL2;
  {
/* line 834 "Common.puma" */
 error_protocol ("dummy not found");
      tree_protocol ("acual argument is : ", actual);
    
  }
  }
   return;
yyL2:;

  if (actual->Kind == kVAR_PARAM) {
/* line 839 "Common.puma" */
 {
  rbool yyV1;
  tDefinitions yyV2;
  {
/* line 841 "Common.puma" */
   GetFullVarObject (actual->VAR_PARAM.V, & yyV1, & yyV2);
/* line 842 "Common.puma" */
   if (! ((yyV1))) goto yyL3;
  {
/* line 844 "Common.puma" */
   p (yyV2, dummy);
  }
  }
   return;
 }
yyL3:;

  }
/* line 847 "Common.puma" */
  {
/* line 849 "Common.puma" */
   tree_protocol ("not applied for this actual argument : ", actual);
  }
   return;

;
}

static void GetFullVarObject
# if defined __STDC__ | defined __cplusplus
(register tTree param, register rbool * yyP2, register tDefinitions * yyP1)
# else
(param, yyP2, yyP1)
 register tTree param;
 register rbool * yyP2;
 register tDefinitions * yyP1;
# endif
{
  if (param->Kind == kVAR_PARAM) {
/* line 860 "Common.puma" */
 {
  rbool yyV1;
  tDefinitions yyV2;
  {
/* line 862 "Common.puma" */
   GetFullVarObject (param->VAR_PARAM.V, & yyV1, & yyV2);
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
  if (param->Kind == kUSED_VAR) {
/* line 865 "Common.puma" */
   * yyP2 = rtrue;
   * yyP1 = param->USED_VAR.VARNAME->VAR_OBJ.Object;
   return;

  }
  if (param->Kind == kINDEXED_VAR) {
/* line 868 "Common.puma" */
 {
  rbool yyV1;
  tDefinitions yyV2;
  {
/* line 870 "Common.puma" */
   if (! ((IsWholeVar (param)))) goto yyL3;
  {
/* line 872 "Common.puma" */
   GetFullVarObject (param->INDEXED_VAR.IND_VAR, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL3:;

  }
/* line 875 "Common.puma" */
   * yyP2 = rfalse;
   * yyP1 = NoObject;
   return;

;
}

void BeginCommon ARGS ((void))
{
}

void CloseCommon ARGS ((void))
{
}
