# include "CodeVars.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 58 "CodeVars.puma" */

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Objects.h"
# include "Rank.h"             /* VarSize, VarRank, ...         */
# include "Transform.h"         /* CombineACF, ....              */
# include "TreeOps.h"
# include "Dalib.h"             /* MakeVarDecl, ...              */
# include "TriDenT.h"         
# include "DefTable.h"         
# include "FArguments.h"         

# include "Expressions.h"       /* AddConstant, MakeConstant     */

# include "Distributions.h"     /* DimListLength      */

# include "Nesting.h"
# include "CodeMapping.h"       /* DalibArrayCreate          */
# include "CodeGeneral.h"       /* DalibArrayCreate          */
# include "CodeDescriptors.h"   /* DalibSectionTranslation   */
# include "BuildTree.h"         /* ConcatDecls               */
# include "RegShadow.h"         /* AddShadowWidth            */
# include "ArrayDescriptor.h"   /* IsStaticObj, ...          */

tTree NewDefines;                /* stmts for a_low, a_high, a_os */

# define MODULE "CodeVars"

# define maddr_type MakeIntegerType (default_addr_size)



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCodeVars.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* CodeVars_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeVars, routine %s failed\n",
  yyFunction);
 CodeVars_Exit ();
}

tTree CodeProcDecl ARGS ((tDefinitions t));
static tTree MakeDSPDecl ARGS ((tTree var));
tTree CodeTemplateDecl ARGS ((tTree temp, tDefinitions obj));
tTree CodeRaggedDecl ARGS ((tTree decl, tDefinitions obj));
tTree CodeVarDecl ARGS ((tTree var, tDefinitions obj));
static void AddShadowSizes ARGS ((tTree indexes, tTree shadow_specs));
tTree MakeCommonVarDsp ARGS ((tTree common_ids));
tTree CodeCreateDsp ARGS ((tTree var, tTree indexes, int kind));
tTree CodeInheritDsp ARGS ((tTree var, tTree indexes, int kind, int safe));
tTree CodeFreeDsp ARGS ((tTree var, int kind));
static tTree CreateDescriptor ARGS ((tTree var, tDefinitions obj, tTree indexes, int kind));
static tTree InheritDescriptor ARGS ((tTree var, tDefinitions obj, tTree indexes, int kind));
static tTree FreeDescriptor ARGS ((tTree var, tDefinitions obj, int kind));
tTree AdaptAllocate ARGS ((tTree t));
static tTree AdaptAllocate1 ARGS ((tTree v, int dist));
tTree AdaptDeallocate ARGS ((tTree t));
static tTree AdaptDeallocate1 ARGS ((tTree v));
static tTree DefineDistribution ARGS ((tTree var, tDefinitions obj, int alloc_kind));
static rbool IsAvailable ARGS ((tDefinitions obj));
static tTree DescriptorAllocate ARGS ((tTree var, tTree indexes, tDefinitions obj));
static tTree MakeAllocateStmt ARGS ((tTree var));
static tTree MakeDeallocateStmt ARGS ((tTree var));
tTree CodeRedistribute ARGS ((tTree distributee, tDefinitions dist));
tTree CodeRealign ARGS ((tTree alignee, tDefinitions dist));
static void ResetObjDistribution ARGS ((tDefinitions obj, tDefinitions n, tDefinitions * yyP1));
tTree CodeDirtyStmt ARGS ((tTree dirty_vars));
tTree CodePtrAssign ARGS ((tTree ptr_var, tTree exp));
static tTree MakeArrayAccess ARGS ((tTree var));

tTree CodeProcDecl
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kTopologyObject) {
/* line 108 "CodeVars.puma" */
  {
/* line 110 "CodeVars.puma" */
   if (! ((t->TopologyObject.Ident == DefaultId ()))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 114 "CodeVars.puma" */
  {
/* line 118 "CodeVars.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  }
   return NoTree;
yyL2:;

  if (t->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
/* line 122 "CodeVars.puma" */
 {
  tTree dsp;
  tTree topid;
  {
/* line 128 "CodeVars.puma" */
   dsp = MakeDSPDecl (t->TopologyObject.decl);
/* line 129 "CodeVars.puma" */
   topid = MakeVarDeclA (t->TopologyObject.Ident, "_TOPID", MakeIntegerType (default_int_size));
  }
   return mDECL_LIST (dsp, mDECL_LIST (topid, NoTree));
 }

  }
  }
/* line 134 "CodeVars.puma" */
  {
/* line 136 "CodeVars.puma" */
   obj_error_protocol ("Illegal Object in CodeProcDecl", t);
  }
   return NoTree;

}

static tTree MakeDSPDecl
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kVAR_DECL) {
/* line 174 "CodeVars.puma" */
   return MakeVarDeclA (var->VAR_DECL.Ident, "_DSP", maddr_type);

  }
  if (var->Kind == kRAGGED_DECL) {
/* line 179 "CodeVars.puma" */
   return MakeVarDeclA (var->RAGGED_DECL.Ident, "_DSP", maddr_type);

  }
  if (var->Kind == kPROCESSORS_DECL) {
/* line 184 "CodeVars.puma" */
   return MakeVarDeclA (var->PROCESSORS_DECL.Ident, "_DSP", maddr_type);

  }
/* line 189 "CodeVars.puma" */
  {
/* line 190 "CodeVars.puma" */
   failure_protocol (MODULE, "MakeDSPDecl", var);
  }
   return NoTree;

}

tTree CodeTemplateDecl
# if defined __STDC__ | defined __cplusplus
(register tTree temp, register tDefinitions obj)
# else
(temp, obj)
 register tTree temp;
 register tDefinitions obj;
# endif
{
/* line 202 "CodeVars.puma" */
  {
/* line 204 "CodeVars.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 209 "CodeVars.puma" */
  {
/* line 211 "CodeVars.puma" */
   if (! ((VarDistribution (obj) == 0))) goto yyL2;
  }
   return NoTree;
yyL2:;

/* line 217 "CodeVars.puma" */
   return DistributionDecls (obj);

}

tTree CodeRaggedDecl
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tDefinitions obj)
# else
(decl, obj)
 register tTree decl;
 register tDefinitions obj;
# endif
{
/* line 230 "CodeVars.puma" */
   return MakeDSPDecl (decl);

}

tTree CodeVarDecl
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions obj)
# else
(var, obj)
 register tTree var;
 register tDefinitions obj;
# endif
{
  if (var->Kind == kVAR_DECL) {
  if (obj->Kind == kVarObject) {
/* line 252 "CodeVars.puma" */
  {
/* line 254 "CodeVars.puma" */
 if (IsStaticObj (obj))
   
        AddShadowSizes (var->VAR_DECL.VAL, GetVarShadow (obj));
   
  }
   return CombineDECL (var, DistributionDecls (obj));

  }
  }
/* line 262 "CodeVars.puma" */
  {
/* line 264 "CodeVars.puma" */
   failure_protocol (MODULE, "CodeVarDecl", var);
  }
   return var;

}

static void AddShadowSizes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register tTree shadow_specs)
# else
(indexes, shadow_specs)
 register tTree indexes;
 register tTree shadow_specs;
# endif
{
 yyRecursion:
  if (indexes->Kind == kARRAY_TYPE) {
/* line 281 "CodeVars.puma" */
  {
/* line 283 "CodeVars.puma" */
   indexes = indexes->ARRAY_TYPE.ARRAY_INDEX_TYPES;
   goto yyRecursion;
  }

  }
/* line 286 "CodeVars.puma" */
  {
/* line 288 "CodeVars.puma" */
   if (! ((shadow_specs == NoTree))) goto yyL2;
  }
   return;
yyL2:;

  if (indexes->Kind == kSHAPE_EMPTY) {
  if (shadow_specs->Kind == kSHADOW_EMPTY) {
/* line 291 "CodeVars.puma" */
   return;

  }
  }
  if (indexes->Kind == kSHAPE_LIST) {
  if (indexes->SHAPE_LIST.Elem->Kind == kEXPLICIT_SHAPE) {
  if (shadow_specs->Kind == kSHADOW_LIST) {
/* line 294 "CodeVars.puma" */
  {
/* line 297 "CodeVars.puma" */
   AddShadowWidth (indexes->SHAPE_LIST.Elem, shadow_specs->SHADOW_LIST.Elem);
/* line 298 "CodeVars.puma" */
   indexes = indexes->SHAPE_LIST.Next;
   shadow_specs = shadow_specs->SHADOW_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  if (shadow_specs->Kind == kSHADOW_LIST) {
/* line 301 "CodeVars.puma" */
  {
/* line 303 "CodeVars.puma" */
   indexes = indexes->SHAPE_LIST.Next;
   shadow_specs = shadow_specs->SHADOW_LIST.Next;
   goto yyRecursion;
  }

  }
  }
/* line 306 "CodeVars.puma" */
  {
/* line 308 "CodeVars.puma" */
   failure2_protocol (MODULE, "AddShadowSizes", indexes, shadow_specs);
  }
   return;

;
}

tTree MakeCommonVarDsp
# if defined __STDC__ | defined __cplusplus
(register tTree common_ids)
# else
(common_ids)
 register tTree common_ids;
# endif
{
  if (common_ids->Kind == kDECL_EMPTY) {
/* line 332 "CodeVars.puma" */
   return NoTree;

  }
  if (common_ids->Kind == kDECL_LIST) {
  if (common_ids->DECL_LIST.Elem->Kind == kVAR_DECL) {
/* line 337 "CodeVars.puma" */
 {
  tTree new;
  int kind;
  tTree var_dsp;
  {
/* line 342 "CodeVars.puma" */
   kind = GetDspKind (GetLocalObject (common_ids->DECL_LIST.Elem->VAR_DECL.Ident));
/* line 344 "CodeVars.puma" */
   new = MakeCommonVarDsp (common_ids->DECL_LIST.Next);
/* line 346 "CodeVars.puma" */
   if ((kind != kNO_DSP)) {
/* line 350 "CodeVars.puma" */
   var_dsp = MakeVarDeclA (common_ids->DECL_LIST.Elem->VAR_DECL.Ident, DSP_SUFFIX, mDUMMY_TYPE ());
/* line 352 "CodeVars.puma" */
   if ((new == NoTree)) {
/* line 352 "CodeVars.puma" */
   new = mDECL_EMPTY ();
   }
/* line 354 "CodeVars.puma" */
   new = mDECL_LIST (var_dsp, new);
   }
  }
   return new;
 }

  }
  }
/* line 361 "CodeVars.puma" */
  {
/* line 363 "CodeVars.puma" */
   failure_protocol (MODULE, "MakeCommonVarDsp", common_ids);
  }
   return NoTree;

}

tTree CodeCreateDsp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree indexes, register int kind)
# else
(var, indexes, kind)
 register tTree var;
 register tTree indexes;
 register int kind;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 378 "CodeVars.puma" */
   return CreateDescriptor (var, var->USED_VAR.VARNAME->VAR_OBJ.Object, indexes, kind);

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 383 "CodeVars.puma" */
   return CreateDescriptor (var, var->SELECTED_VAR.SELECTOR->REC_COMP.Object, indexes, kind);

  }
/* line 388 "CodeVars.puma" */
  {
/* line 390 "CodeVars.puma" */
   failure_protocol (MODULE, "CodeCreateDsp", var);
  }
   return NoTree;

}

tTree CodeInheritDsp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree indexes, register int kind, register int safe)
# else
(var, indexes, kind, safe)
 register tTree var;
 register tTree indexes;
 register int kind;
 register int safe;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 397 "CodeVars.puma" */
   return InheritDescriptor (var, var->USED_VAR.VARNAME->VAR_OBJ.Object, indexes, kind);

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 402 "CodeVars.puma" */
   return InheritDescriptor (var, var->SELECTED_VAR.SELECTOR->REC_COMP.Object, indexes, kind);

  }
/* line 407 "CodeVars.puma" */
  {
/* line 409 "CodeVars.puma" */
   failure_protocol (MODULE, "CodeInheritDsp", var);
  }
   return NoTree;

}

tTree CodeFreeDsp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 415 "CodeVars.puma" */
   return FreeDescriptor (var, var->USED_VAR.VARNAME->VAR_OBJ.Object, kind);

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 420 "CodeVars.puma" */
   return FreeDescriptor (var, var->SELECTED_VAR.SELECTOR->REC_COMP.Object, kind);

  }
/* line 425 "CodeVars.puma" */
  {
/* line 427 "CodeVars.puma" */
   failure_protocol (MODULE, "CodeFreeDsp", var);
  }
   return NoTree;

}

static tTree CreateDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions obj, register tTree indexes, register int kind)
# else
(var, obj, indexes, kind)
 register tTree var;
 register tDefinitions obj;
 register tTree indexes;
 register int kind;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 447 "CodeVars.puma" */
 {
  tTree defines;
  {
/* line 449 "CodeVars.puma" */
   if (! ((IsRaggedVarObject (obj)))) goto yyL1;
  {
/* line 453 "CodeVars.puma" */
 

     defines = CombineACF (TriDenTArrayMakeDsp (var, kind), NoTree);

   
  }
  }
   return defines;
 }
yyL1:;

/* line 462 "CodeVars.puma" */
 {
  tTree defines;
  tTree save;
  {
/* line 467 "CodeVars.puma" */
 

     defines = CombineACF (DalibArrayMakeDsp (var, kind), NoTree);

     if (kind == kATTACH_DSP)

        defines = CombineACF (DalibSaveCommonDsp (var, kind), defines);

     

     defines = CombineACF (defines, DefineDistribution (var, obj, kind));

     defines = CombineACF (defines, DalibArrayTrace (var));

     if (kind != kALLOCATE_DSP)

        defines = CombineACF (defines, 
                              DalibArrayDefine (var, indexes, kind));

     defines = CombineACF (defines, DalibArrayOverlap (var, kind));

     defines = CombineACF (defines, DalibCopyIn (var, kind));

     if (kind != kALLOCATE_DSP)

        defines = CombineACF (defines, MakeArrayAccess (var));

   
  }
   return defines;
 }

  }
  if (obj->Kind == kTemplateObject) {
/* line 499 "CodeVars.puma" */
  {
/* line 501 "CodeVars.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL3;
  }
   return NoTree;
yyL3:;

/* line 513 "CodeVars.puma" */
 {
  tTree defines;
  {
/* line 517 "CodeVars.puma" */
 

     defines = CombineACF (DalibArrayMakeDsp (var, kind), NoTree);

     

     defines = CombineACF (defines, DefineDistribution (var, obj, kind));

     defines = CombineACF (defines, 
                           DalibArrayDefine (var, indexes, kind));
   
  }
   return defines;
 }

  }
  if (obj->Kind == kTopologyObject) {
/* line 506 "CodeVars.puma" */
  {
/* line 508 "CodeVars.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL4;
  }
   return NoTree;
yyL4:;

/* line 533 "CodeVars.puma" */
 {
  tTree defines;
  {
/* line 537 "CodeVars.puma" */
 

     defines = CombineACF (DalibArrayMakeDsp (var, kind), NoTree);

     

     defines = CombineACF (defines, 
                           DalibArrayDefine (var, indexes, kind));

     defines = CombineACF (defines, DalibTopCreate (var));
   
  }
   return defines;
 }

  }
  if (obj->Kind == kRaggedObject) {
/* line 553 "CodeVars.puma" */
 {
  tTree defines;
  {
/* line 557 "CodeVars.puma" */
 

     defines = CombineACF (TriDenTMakeDsp (var, kind), NoTree);

     defines = CombineACF (defines, DefineDistribution (var, obj, kind));

   
  }
   return defines;
 }

  }
 yyAbort ("CreateDescriptor");
 { tTree yyDummy; return yyDummy; }
}

static tTree InheritDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions obj, register tTree indexes, register int kind)
# else
(var, obj, indexes, kind)
 register tTree var;
 register tDefinitions obj;
 register tTree indexes;
 register int kind;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 577 "CodeVars.puma" */
 {
  tTree defines;
  {
/* line 581 "CodeVars.puma" */
 

     defines = CombineACF (DalibCopyDsp (var, kind), NoTree);

     if (kind != kALLOCATE_DSP)

        defines = CombineACF (defines, MakeArrayAccess (var));
   
  }
   return defines;
 }

  }
 yyAbort ("InheritDescriptor");
 { tTree yyDummy; return yyDummy; }
}

static tTree FreeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions obj, register int kind)
# else
(var, obj, kind)
 register tTree var;
 register tDefinitions obj;
 register int kind;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 603 "CodeVars.puma" */
   return CombineACF (DalibArrayFree (var, kind), CombineACF (DalibCopyOut (var, kind), NoTree));

  }
  if (obj->Kind == kTemplateObject) {
/* line 611 "CodeVars.puma" */
  {
/* line 613 "CodeVars.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL2;
  }
   return NoTree;
yyL2:;

/* line 625 "CodeVars.puma" */
   return CombineACF (DalibArrayFree (var, kind), NoTree);

  }
  if (obj->Kind == kTopologyObject) {
/* line 618 "CodeVars.puma" */
  {
/* line 620 "CodeVars.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL3;
  }
   return NoTree;
yyL3:;

/* line 630 "CodeVars.puma" */
   return CombineACF (DalibArrayFree (var, kind), NoTree);

  }
  if (obj->Kind == kRaggedObject) {
/* line 635 "CodeVars.puma" */
   return CombineACF (TriDenTFree (var, kind), NoTree);

  }
 yyAbort ("FreeDescriptor");
 { tTree yyDummy; return yyDummy; }
}

tTree AdaptAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 650 "CodeVars.puma" */
   return CombineACF (AdaptAllocate1 (t->BTP_LIST.Elem->VAR_PARAM.V, TreeWriteDistribution (t->BTP_LIST.Elem->VAR_PARAM.V)), AdaptAllocate (t->BTP_LIST.Next));

  }
  }
  if (t->Kind == kBTP_EMPTY) {
/* line 656 "CodeVars.puma" */
   return NoTree;

  }
/* line 660 "CodeVars.puma" */
  {
/* line 661 "CodeVars.puma" */
   failure_protocol (MODULE, "AdaptAllocate", t);
  }
   return NoTree;

}

static tTree AdaptAllocate1
# if defined __STDC__ | defined __cplusplus
(register tTree v, register int dist)
# else
(v, dist)
 register tTree v;
 register int dist;
# endif
{
  if (v->Kind == kINDEXED_VAR) {
  if (v->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 667 "CodeVars.puma" */
   return DescriptorAllocate (v->INDEXED_VAR.IND_VAR, v->INDEXED_VAR.IND_EXPS, v->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object);

  }
  if (v->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
/* line 672 "CodeVars.puma" */
   return DescriptorAllocate (v->INDEXED_VAR.IND_VAR, v->INDEXED_VAR.IND_EXPS, v->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELECTOR->REC_COMP.Object);

  }
  }
  if (v->Kind == kUSED_VAR) {
/* line 679 "CodeVars.puma" */
  {
/* line 681 "CodeVars.puma" */
   if (! ((IsRaggedVarObject (v->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL3;
  }
   return DescriptorAllocate (v, NoTree, v->USED_VAR.VARNAME->VAR_OBJ.Object);
yyL3:;

/* line 686 "CodeVars.puma" */
  {
/* line 688 "CodeVars.puma" */
   if (! ((IsTreeObject (v->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL4;
  }
   return DescriptorAllocate (v, NoTree, v->USED_VAR.VARNAME->VAR_OBJ.Object);
yyL4:;

/* line 693 "CodeVars.puma" */
   return MakeAllocateStmt (v);

  }
/* line 700 "CodeVars.puma" */
  {
/* line 702 "CodeVars.puma" */
   failure_protocol (MODULE, "AdaptAllocate1", v);
  }
   return NoTree;

}

tTree AdaptDeallocate
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 716 "CodeVars.puma" */
   return CombineACF (AdaptDeallocate1 (t->BTP_LIST.Elem->VAR_PARAM.V), AdaptDeallocate (t->BTP_LIST.Next));

  }
  }
  if (t->Kind == kBTP_EMPTY) {
/* line 721 "CodeVars.puma" */
   return NoTree;

  }
/* line 725 "CodeVars.puma" */
  {
/* line 726 "CodeVars.puma" */
   failure_protocol (MODULE, "AdaptDeallocate", t);
  }
   return NoTree;

}

static tTree AdaptDeallocate1
# if defined __STDC__ | defined __cplusplus
(register tTree v)
# else
(v)
 register tTree v;
# endif
{
  if (v->Kind == kUSED_VAR) {
  if (v->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kTemplateObject) {
/* line 734 "CodeVars.puma" */
  {
/* line 736 "CodeVars.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return NoTree;
yyL1:;

  }
/* line 741 "CodeVars.puma" */
  {
/* line 743 "CodeVars.puma" */
   if (! ((IsTreeObject (v->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL2;
  }
   return NoTree;
yyL2:;

/* line 748 "CodeVars.puma" */
   return CombineACF (MakeDeallocateStmt (v), NoTree);

  }
  if (v->Kind == kSELECTED_VAR) {
/* line 753 "CodeVars.puma" */
   return CombineACF (MakeDeallocateStmt (v), NoTree);

  }
/* line 760 "CodeVars.puma" */
  {
/* line 761 "CodeVars.puma" */
   failure_protocol (MODULE, "AdaptDeallocate1", v);
  }
   return NoTree;

}

static tTree DefineDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions obj, register int alloc_kind)
# else
(var, obj, alloc_kind)
 register tTree var;
 register tDefinitions obj;
 register int alloc_kind;
# endif
{
/* line 789 "CodeVars.puma" */
  {
/* line 791 "CodeVars.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 795 "CodeVars.puma" */
  {
/* line 797 "CodeVars.puma" */
   if (! ((GetCurrentModel () == HPF_LOCAL))) goto yyL2;
  }
   return NoTree;
yyL2:;

  if (obj->Kind == kRaggedObject) {
/* line 813 "CodeVars.puma" */
  {
/* line 815 "CodeVars.puma" */
   if (! ((IsDistributedObj (obj)))) goto yyL3;
  }
   return TriDenTDistribute (var, alloc_kind);
yyL3:;

  }
  if (obj->Kind == kVarObject) {
/* line 820 "CodeVars.puma" */
  {
/* line 822 "CodeVars.puma" */
   if (! ((IsDistributedObj (obj)))) goto yyL4;
  }
   return CombineACF (DalibArrayDistribute (var, alloc_kind), DalibArrayShared (var, alloc_kind));
yyL4:;

/* line 835 "CodeVars.puma" */
  {
/* line 837 "CodeVars.puma" */
   if (! ((IsAlignedObj (obj)))) goto yyL6;
  }
   return CombineACF (DalibAlignSource (var, alloc_kind), CombineACF (DalibAlignTarget (var, alloc_kind), DalibArrayShared (var, alloc_kind)));
yyL6:;

/* line 844 "CodeVars.puma" */
  {
/* line 846 "CodeVars.puma" */
   if (! ((IsTranscriptiveObj (obj)))) goto yyL7;
  }
   return NoTree;
yyL7:;

  }
  if (obj->Kind == kTemplateObject) {
/* line 828 "CodeVars.puma" */
  {
/* line 830 "CodeVars.puma" */
   if (! ((IsDistributedObj (obj)))) goto yyL5;
  }
   return CombineACF (DalibArrayDistribute (var, alloc_kind), NoTree);
yyL5:;

  }
/* line 851 "CodeVars.puma" */
   return NoTree;

}

static rbool IsAvailable
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 866 "CodeVars.puma" */
  {
/* line 867 "CodeVars.puma" */
   if (! ((VarDistribution (obj) == 0))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 870 "CodeVars.puma" */
  {
/* line 871 "CodeVars.puma" */
   if (! ((IsDistributedObj (obj)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 874 "CodeVars.puma" */
  {
/* line 875 "CodeVars.puma" */
   if (! ((IsAlignedObj (obj)))) goto yyL3;
  }
   return rtrue;
yyL3:;

/* line 878 "CodeVars.puma" */
  {
/* line 879 "CodeVars.puma" */
   if (! ((IsTranscriptiveObj (obj)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  return rfalse;
}

static tTree DescriptorAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree indexes, register tDefinitions obj)
# else
(var, indexes, obj)
 register tTree var;
 register tTree indexes;
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 898 "CodeVars.puma" */
 {
  tTree defines;
  {
/* line 902 "CodeVars.puma" */
 

     defines = CombineACF (NoTree, 
                           DalibArrayDefine (var, indexes, kALLOCATE_DSP));

     

     defines = CombineACF (defines, MakeAllocateStmt (var));

     

     defines = CombineACF (defines, MakeArrayAccess (var));

   
  }
   return defines;
 }

  }
  if (obj->Kind == kRaggedObject) {
/* line 920 "CodeVars.puma" */
  {
/* line 922 "CodeVars.puma" */
   if (! ((indexes == NoTree))) goto yyL2;
  }
   return TriDenTAllocate (var, kALLOCATE_DSP);
yyL2:;

/* line 927 "CodeVars.puma" */
   return TriDenTSetSize (var, indexes, kALLOCATE_DSP);

  }
/* line 932 "CodeVars.puma" */
  {
/* line 934 "CodeVars.puma" */
   failure_protocol (MODULE, "DescriptorAllocate", var);
  }
   return NoTree;

}

static tTree MakeAllocateStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 948 "CodeVars.puma" */
 {
  tTree stmt;
  {
/* line 952 "CodeVars.puma" */
   stmt = mBTP_LIST (mVAR_PARAM (var), mBTP_EMPTY ());
/* line 953 "CodeVars.puma" */
   stmt = mALLOCATE_STMT (stmt, mDUMMY_VAR ());
/* line 954 "CodeVars.puma" */
   stmt = mACF_BASIC (stmt);
  }
   return stmt;
 }

}

static tTree MakeDeallocateStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 961 "CodeVars.puma" */
 {
  tTree stmt;
  {
/* line 965 "CodeVars.puma" */
   stmt = mBTP_LIST (mVAR_PARAM (var), mBTP_EMPTY ());
/* line 966 "CodeVars.puma" */
   stmt = mDEALLOCATE_STMT (stmt, mDUMMY_VAR ());
/* line 967 "CodeVars.puma" */
   stmt = mACF_BASIC (stmt);
  }
   return stmt;
 }

}

tTree CodeRedistribute
# if defined __STDC__ | defined __cplusplus
(register tTree distributee, register tDefinitions dist)
# else
(distributee, dist)
 register tTree distributee;
 register tDefinitions dist;
# endif
{
  if (distributee->Kind == kBTV_LIST) {
/* line 980 "CodeVars.puma" */
   return CombineACF (CodeRedistribute (distributee->BTV_LIST.Elem, dist), CodeRedistribute (distributee->BTV_LIST.Next, dist));

  }
  if (distributee->Kind == kBTV_EMPTY) {
/* line 986 "CodeVars.puma" */
   return NoTree;

  }
  if (distributee->Kind == kUSED_VAR) {
/* line 991 "CodeVars.puma" */
 {
  tTree defines;
  tDefinitions yyV1;
  tDefinitions yyV2;
  {
/* line 997 "CodeVars.puma" */
   ResetObjDistribution (distributee->USED_VAR.VARNAME->VAR_OBJ.Object, dist, & yyV1);
/* line 999 "CodeVars.puma" */
 
 
     defines = CombineACF (DalibArrayCreateCopy (distributee), NoTree);
 
     defines = CombineACF (defines,
                           DefineDistribution (distributee, distributee->USED_VAR.VARNAME->VAR_OBJ.Object, kALLOCATE_DSP));

     defines = CombineACF (defines,
                           DalibArrayRedistribute (distributee));

     if (IsAvailable (distributee->USED_VAR.VARNAME->VAR_OBJ.Object))
 
       defines = CombineACF (defines, MakeArrayAccess (distributee));
 
   
/* line 1015 "CodeVars.puma" */
   ResetObjDistribution (distributee->USED_VAR.VARNAME->VAR_OBJ.Object, yyV1, & yyV2);
  }
   return defines;
 }

  }
  if (distributee->Kind == kSELECTED_VAR) {
/* line 1020 "CodeVars.puma" */
  {
/* line 1022 "CodeVars.puma" */
   error_protocol ("redistribution of components not supported");
  }
   return NoTree;

  }
/* line 1027 "CodeVars.puma" */
  {
/* line 1029 "CodeVars.puma" */
   failure_protocol (MODULE, "CodeRedistribute", distributee);
  }
   return NoTree;

}

tTree CodeRealign
# if defined __STDC__ | defined __cplusplus
(register tTree alignee, register tDefinitions dist)
# else
(alignee, dist)
 register tTree alignee;
 register tDefinitions dist;
# endif
{
  if (alignee->Kind == kBTV_LIST) {
/* line 1041 "CodeVars.puma" */
   return CombineACF (CodeRealign (alignee->BTV_LIST.Elem, dist), CodeRealign (alignee->BTV_LIST.Next, dist));

  }
  if (alignee->Kind == kBTV_EMPTY) {
/* line 1047 "CodeVars.puma" */
   return NoTree;

  }
  if (alignee->Kind == kUSED_VAR) {
/* line 1057 "CodeVars.puma" */
 {
  tTree defines;
  tDefinitions yyV1;
  tDefinitions yyV2;
  {
/* line 1064 "CodeVars.puma" */
   ResetObjDistribution (alignee->USED_VAR.VARNAME->VAR_OBJ.Object, dist, & yyV1);
/* line 1066 "CodeVars.puma" */
 
 
     defines = CombineACF (DalibArrayCreateCopy (alignee), NoTree);
 
     defines = CombineACF (defines,
                           DefineDistribution (alignee, alignee->USED_VAR.VARNAME->VAR_OBJ.Object, kALLOCATE_DSP));
 
     defines = CombineACF (defines,
                           DalibArrayRedistribute (alignee));

     if (IsAvailable (alignee->USED_VAR.VARNAME->VAR_OBJ.Object))
 
       defines = CombineACF (defines, MakeArrayAccess (alignee));
   
/* line 1081 "CodeVars.puma" */
   ResetObjDistribution (alignee->USED_VAR.VARNAME->VAR_OBJ.Object, yyV1, & yyV2);
  }
   return defines;
 }

  }
  if (alignee->Kind == kINDEXED_VAR) {
  if (alignee->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
/* line 1086 "CodeVars.puma" */
  {
/* line 1088 "CodeVars.puma" */
   error_protocol ("realign of components not supported");
  }
   return NoTree;

  }
  }
/* line 1093 "CodeVars.puma" */
  {
/* line 1094 "CodeVars.puma" */
   failure_protocol (MODULE, "CodeRealign", alignee);
  }
   return NoTree;

}

static void ResetObjDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions n, register tDefinitions * yyP1)
# else
(obj, n, yyP1)
 register tDefinitions obj;
 register tDefinitions n;
 register tDefinitions * yyP1;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 1106 "CodeVars.puma" */
 {
  tDefinitions old_map;
  {
/* line 1110 "CodeVars.puma" */
   old_map = obj->VarObject.Dist->Mapping.spec;
/* line 1112 "CodeVars.puma" */
   obj->VarObject.Dist->Mapping.spec = n;
  }
   * yyP1 = old_map;
   return;
 }

  }
  if (obj->Kind == kTemplateObject) {
/* line 1115 "CodeVars.puma" */
 {
  tDefinitions old_map;
  {
/* line 1119 "CodeVars.puma" */
   old_map = obj->TemplateObject.Dist->Mapping.spec;
/* line 1121 "CodeVars.puma" */
   obj->TemplateObject.Dist->Mapping.spec = n;
  }
   * yyP1 = old_map;
   return;
 }

  }
/* line 1124 "CodeVars.puma" */
  {
/* line 1126 "CodeVars.puma" */
   failure_protocol (MODULE, "ResetObjDistribution", obj->Object.decl);
  }
   * yyP1 = NoDefinitions;
   return;

;
}

tTree CodeDirtyStmt
# if defined __STDC__ | defined __cplusplus
(register tTree dirty_vars)
# else
(dirty_vars)
 register tTree dirty_vars;
# endif
{
  if (dirty_vars->Kind == kBTV_EMPTY) {
/* line 1141 "CodeVars.puma" */
   return NoTree;

  }
  if (dirty_vars->Kind == kBTV_LIST) {
/* line 1146 "CodeVars.puma" */
   return CombineACF (CodeDirtyStmt (dirty_vars->BTV_LIST.Elem), CodeDirtyStmt (dirty_vars->BTV_LIST.Next));

  }
  if (dirty_vars->Kind == kUSED_VAR) {
/* line 1152 "CodeVars.puma" */
 {
  tTree call;
  tTree params;
  {
/* line 1157 "CodeVars.puma" */
 params = mVAR_PARAM (MakeVarSuffixA (dirty_vars, DSP_SUFFIX));
     params = mBTP_LIST (params, mBTP_EMPTY ());
     call   = mPROC_OBJ (MakeDalibId ("array_set_dirty"));
     call   = mACF_BASIC (mCALL_STMT (call, params));
   
  }
   return call;
 }

  }
/* line 1166 "CodeVars.puma" */
  {
/* line 1168 "CodeVars.puma" */
   failure_protocol (MODULE, "CodeDirtyStmt", dirty_vars);
  }
   return NoTree;

}

tTree CodePtrAssign
# if defined __STDC__ | defined __cplusplus
(register tTree ptr_var, register tTree exp)
# else
(ptr_var, exp)
 register tTree ptr_var;
 register tTree exp;
# endif
{
  if (exp->Kind == kVAR_EXP) {
/* line 1195 "CodeVars.puma" */
 {
  tTree params;
  tTree param;
  tTree call1;
  tTree call2;
  tTree pre;
  tTree post;
  tTree dsp;
  {
/* line 1208 "CodeVars.puma" */
   DalibSectionTranslation (1, exp->VAR_EXP.V, & pre, & dsp, & post);
/* line 1210 "CodeVars.puma" */
 params = mBTP_EMPTY ();
     params = mBTP_LIST (dsp, params);
     param  = mVAR_PARAM (MakeVarSuffixA (ptr_var, DSP_SUFFIX));
     params = mBTP_LIST (param, params);
     call1  = mPROC_OBJ (MakeDalibId ("ptr_define"));
     call1  = mACF_BASIC (mCALL_STMT (call1, params));
     call1  = CombineACF (pre, CombineACF (call1, post));
     call2  = DalibArrayAllocate (ptr_var, kLOCAL_DSP);
   
  }
   return CombineACF (call1, CombineACF (call2, NoTree));
 }

  }
/* line 1223 "CodeVars.puma" */
  {
/* line 1225 "CodeVars.puma" */
   failure2_protocol (MODULE, "CodePtrAssign", ptr_var, exp);
  }
   return NoTree;

}

static tTree MakeArrayAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 1241 "CodeVars.puma" */
   return mACF_BASIC (mACCESS_STMT (CopyTree (var)));

}

void BeginCodeVars ARGS ((void))
{
}

void CloseCodeVars ARGS ((void))
{
}
