# include "CodeOn.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 33 "CodeOn.puma" */

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Objects.h"
# include "TreeOps.h"
# include "Types.h"
# include "Transform.h"        /* CombineACF, ReplaceACF  */
# include "Dalib.h"            
# include "TriDenT.h"          
# include "Expressions.h"      /* MakeConstant */
# include "Distributions.h"      /* MakeConstant */

# include "VarDescriptor.h"    /* var_descriptor */
# include "CodeGeneral.h"  /* DalibPid */
# include "CodeMapping.h"  /* MakeSubTopCreate */
# include "CodeDescriptors.h"  /* DalibPid */
# include "Selection.h"     /* */

# define MODULE "CodeOn"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCodeOn.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* CodeOn_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeOn, routine %s failed\n",
  yyFunction);
 CodeOn_Exit ();
}

rbool NeedsNoContext ARGS ((tTree stmt));
tTree ApplyOnSpecs ARGS ((tTree body, tTree top, tTree specs));
static tTree ApplyOnSpecList ARGS ((tTree body, tTree top, tTree specs));
static tTree MakeTopMask ARGS ((tTree topology));
static tTree MakeTopDimMask ARGS ((tTree topology, tTree spec));
static tTree MakeIsLocal ARGS ((tDefinitions on_id, int on_dim, tTree val));
static void TemplateDimInfo ARGS ((tDefinitions template, int temp_dim, int * yyP2, tTree * yyP1));
static tTree GetLocalRange ARGS ((tTree actual_range, int kind, int base, int stride, tDefinitions template_id, int template_dim));
static void GetTempSliceVars ARGS ((tDefinitions template, int temp_dim, tTree * yyP4, tTree * yyP3));
static void GetTempRangeVars ARGS ((tDefinitions template, int temp_dim, tTree * yyP7, tTree * yyP6, tTree * yyP5));
static tTree MakeLocalRangeStmt ARGS ((tDefinitions template, int temp_dim, int base, int stride, tTree range));
static tTree MakeLocalSliceStmt ARGS ((tDefinitions template, int template_dim, tTree range));
static rbool IsBlockDistribution ARGS ((int kind));
static rbool IsMappedDistribution ARGS ((int kind, tTree size));
static rbool IsOne ARGS ((tTree size));
tTree InitTaskRegion ARGS ((tTree task_body));
tTree StartTasking ARGS ((void));
tTree StopTasking ARGS ((void));
tTree ApplyOnInfo ARGS ((tTree t, rbool push_flag));
static tTree PushContext ARGS ((tDefinitions on_id, int on_dim));
static tTree PopContext ARGS ((tDefinitions on_id, int on_dim));
tTree CodeONPushContext ARGS ((tTree top, tTree specs));
tTree CodeONPopContext ARGS ((tTree top, tTree specs));
static tTree MakePushParams ARGS ((tTree specs));
static tTree MakePushHomeCall ARGS ((tIdent id, tTree spec_params));
static tTree MakePopHomeCall ARGS ((void));

rbool NeedsNoContext
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{

  switch (stmt->Kind) {
  case kACF_LIST:
/* line 70 "CodeOn.puma" */
  {
/* line 72 "CodeOn.puma" */
   if (! ((NeedsNoContext (stmt->ACF_LIST.Elem)))) goto yyL1;
  {
/* line 73 "CodeOn.puma" */
   if (! ((NeedsNoContext (stmt->ACF_LIST.Next)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  break;
  case kACF_EMPTY:
/* line 76 "CodeOn.puma" */
   return rtrue;

  case kACF_DUMMY:
/* line 79 "CodeOn.puma" */
   return rtrue;

  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 82 "CodeOn.puma" */
  {
/* line 84 "CodeOn.puma" */
   return rfalse;
  }

  }
/* line 87 "CodeOn.puma" */
   return rtrue;

  case kACF_DO:
/* line 90 "CodeOn.puma" */
  {
/* line 92 "CodeOn.puma" */
   if (! ((NeedsNoContext (stmt->ACF_DO.DO_BODY)))) goto yyL6;
  }
   return rtrue;
yyL6:;

  break;
  case kACF_IF:
/* line 95 "CodeOn.puma" */
  {
/* line 97 "CodeOn.puma" */
   if (! ((NeedsNoContext (stmt->ACF_IF.THEN_PART)))) goto yyL7;
  {
/* line 98 "CodeOn.puma" */
   if (! ((NeedsNoContext (stmt->ACF_IF.ELSE_PART)))) goto yyL7;
  }
  }
   return rtrue;
yyL7:;

  break;
  case kACF_ON:
/* line 101 "CodeOn.puma" */
  {
/* line 103 "CodeOn.puma" */
   if (! ((NeedsNoContext (stmt->ACF_ON.ON_BODY)))) goto yyL8;
  }
   return rtrue;
yyL8:;

  break;
  case kACF_PARALLEL:
/* line 106 "CodeOn.puma" */
  {
/* line 108 "CodeOn.puma" */
   if (! ((NeedsNoContext (stmt->ACF_PARALLEL.PARALLEL_BODY)))) goto yyL9;
  }
   return rtrue;
yyL9:;

  break;
  case kACF_CRITICAL:
/* line 111 "CodeOn.puma" */
  {
/* line 113 "CodeOn.puma" */
   if (! ((NeedsNoContext (stmt->ACF_CRITICAL.CRITICAL_BODY)))) goto yyL10;
  }
   return rtrue;
yyL10:;

  break;
  }

  return rfalse;
}

tTree ApplyOnSpecs
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree top, register tTree specs)
# else
(body, top, specs)
 register tTree body;
 register tTree top;
 register tTree specs;
# endif
{
  if (top->Kind == kON_ALL) {
/* line 124 "CodeOn.puma" */
   return body;

  }
  if (top->Kind == kON_HOST) {
/* line 129 "CodeOn.puma" */
 {
  tTree new_acf;
  {
/* line 133 "CodeOn.puma" */
 new_acf = mOP_EXP (mOP_EQ(), DalibPid(), MakeConstant (1));
      new_acf = mACF_IF (new_acf, MakeStmtList (body), mACF_EMPTY());
    
  }
   return new_acf;
 }

  }
  if (top->Kind == kON_VAR) {
  if (specs->Kind == kON_EMPTY) {
/* line 140 "CodeOn.puma" */
  {
/* line 142 "CodeOn.puma" */
   if (! ((IsFullTopologyObj (top->ON_VAR.topid)))) goto yyL3;
  }
   return body;
yyL3:;

/* line 147 "CodeOn.puma" */
 {
  tTree new_acf;
  {
/* line 151 "CodeOn.puma" */
 new_acf = MakeTopMask (top);
      new_acf = mACF_IF (new_acf, MakeStmtList (body), mACF_EMPTY());
    
  }
   return new_acf;
 }

  }
  if (specs->Kind == kON_LIST) {
/* line 158 "CodeOn.puma" */
   return ApplyOnSpecList (body, top, specs);

  }
  }
  if (top->Kind == kON_PROCS) {
/* line 163 "CodeOn.puma" */
 {
  tTree new_acf;
  tTree sub_top;
  {
/* line 168 "CodeOn.puma" */
 new_acf = MakeTopMask (top);
      new_acf = mACF_IF (new_acf, MakeStmtList (body), mACF_EMPTY());
 
      sub_top = MakeSubProcStmt (top->ON_PROCS.topid);

      if (sub_top != NoTree)

        new_acf = CombineACF (sub_top, CombineACF (new_acf, NoTree));

    
  }
   return new_acf;
 }

  }
/* line 182 "CodeOn.puma" */
  {
/* line 184 "CodeOn.puma" */
   failure2_protocol (MODULE, "ApplyOnSpecs", top, specs);
  }
   return body;

}

static tTree ApplyOnSpecList
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree top, register tTree specs)
# else
(body, top, specs)
 register tTree body;
 register tTree top;
 register tTree specs;
# endif
{
 yyRecursion:
  if (specs->Kind == kON_EMPTY) {
/* line 197 "CodeOn.puma" */
   return body;

  }
  if (specs->Kind == kON_LIST) {
/* line 202 "CodeOn.puma" */
   body = ApplyOnSpecList (body, top, specs->ON_LIST.Next);
   specs = specs->ON_LIST.Elem;
   goto yyRecursion;

  }
  if (specs->Kind == kON_SPEC) {
/* line 207 "CodeOn.puma" */
 {
  tTree new_stmt;
  {
/* line 211 "CodeOn.puma" */
 new_stmt = mACF_IF (MakeTopDimMask (top, specs), body, mACF_EMPTY ());
     new_stmt = mACF_LIST (new_stmt, mACF_EMPTY ());
   
  }
   return new_stmt;
 }

  }
/* line 218 "CodeOn.puma" */
  {
/* line 220 "CodeOn.puma" */
   failure_protocol (MODULE, "ApplyOnSpecs", specs);
  }
   return body;

}

static tTree MakeTopMask
# if defined __STDC__ | defined __cplusplus
(register tTree topology)
# else
(topology)
 register tTree topology;
# endif
{
  if (topology->Kind == kON_VAR) {
  if (Definitions_IsType (topology->ON_VAR.arrayid, kObject)) {
/* line 232 "CodeOn.puma" */
 {
  tTree paramlist;
  tTree call;
  {
/* line 237 "CodeOn.puma" */
 paramlist = mBTP_EMPTY ();
    paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (0)), paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (topology->ON_VAR.arrayid->Object.Ident, "_DSP")),
                           paramlist);
  
    call = mPROC_OBJ (MakeDalibId ("is_local"));
    DefineNewHelpFn (MakeDalibId ("is_local"));
    call = mFUNC_CALL_EXP (call, paramlist);
  
  }
   return call;
 }

  }
  }
  if (topology->Kind == kON_PROCS) {
  if (topology->ON_PROCS.topid->Kind == kTopologyObject) {
/* line 250 "CodeOn.puma" */
 {
  tTree paramlist;
  tTree call;
  {
/* line 255 "CodeOn.puma" */
 paramlist = mBTP_EMPTY ();
    paramlist = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (topology->ON_PROCS.topid->TopologyObject.Ident, "_TOPID")),
                           paramlist);
 
    call = mPROC_OBJ (MakeDalibId ("is_in_procs"));
    DefineNewHelpFn (MakeDalibId ("is_in_procs"));
    call = mFUNC_CALL_EXP (call, paramlist);
  
  }
   return call;
 }

  }
  }
/* line 267 "CodeOn.puma" */
  {
/* line 269 "CodeOn.puma" */
   failure_protocol (MODULE, "MakeTopMask", topology);
  }
   return NoTree;

}

static tTree MakeTopDimMask
# if defined __STDC__ | defined __cplusplus
(register tTree topology, register tTree spec)
# else
(topology, spec)
 register tTree topology;
 register tTree spec;
# endif
{
  if (topology->Kind == kON_VAR) {
/* line 284 "CodeOn.puma" */
  {
/* line 286 "CodeOn.puma" */
   if (! ((IsRaggedVarObject (topology->ON_VAR.arrayid)))) goto yyL1;
  }
   return TriDenTIsLocal (topology->ON_VAR.arrayid, spec->ON_SPEC.array_dim, spec->ON_SPEC.ON_VAL);
yyL1:;

/* line 291 "CodeOn.puma" */
   return MakeIsLocal (topology->ON_VAR.arrayid, spec->ON_SPEC.array_dim, spec->ON_SPEC.ON_VAL);

  }
/* line 296 "CodeOn.puma" */
  {
/* line 298 "CodeOn.puma" */
   failure2_protocol (MODULE, "MakeTopDimMask", topology, spec);
  }
   return NoTree;

}

static tTree MakeIsLocal
# if defined __STDC__ | defined __cplusplus
(register tDefinitions on_id, register int on_dim, register tTree val)
# else
(on_id, on_dim, val)
 register tDefinitions on_id;
 register int on_dim;
 register tTree val;
# endif
{
/* line 304 "CodeOn.puma" */
 {
  tTree paramlist;
  tTree call;
  {
/* line 309 "CodeOn.puma" */
 paramlist = mBTP_EMPTY ();
     paramlist = mBTP_LIST (ExpToVarParam (CopyTree(val)), paramlist);
     paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (on_dim)),
                            paramlist);
     paramlist = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (on_id->Object.Ident, "_DSP")),
                            paramlist);
     call = mPROC_OBJ (MakeDalibId ("is_local"));
     DefineNewHelpFn (MakeDalibId ("is_local"));
     call = mFUNC_CALL_EXP (call, paramlist);
  
  }
   return call;
 }

}

static void TemplateDimInfo
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template, register int temp_dim, register int * yyP2, register tTree * yyP1)
# else
(template, temp_dim, yyP2, yyP1)
 register tDefinitions template;
 register int temp_dim;
 register int * yyP2;
 register tTree * yyP1;
# endif
{
/* line 334 "CodeOn.puma" */
 {
  int kind;
  tTree size;
  var_descriptor vard;
  {
/* line 340 "CodeOn.puma" */
   SetVarObjDescriptor (& vard, template, NoTree);
/* line 342 "CodeOn.puma" */
 kind = vard.distribution_kind [temp_dim - 1]; 
     size = vard.distribution_size [temp_dim - 1];
   
  }
   * yyP2 = kind;
   * yyP1 = size;
   return;
 }

;
}

static tTree GetLocalRange
# if defined __STDC__ | defined __cplusplus
(register tTree actual_range, register int kind, register int base, register int stride, register tDefinitions template_id, register int template_dim)
# else
(actual_range, kind, base, stride, template_id, template_dim)
 register tTree actual_range;
 register int kind;
 register int base;
 register int stride;
 register tDefinitions template_id;
 register int template_dim;
# endif
{
  if (actual_range->Kind == kSLICE_EXP) {
/* line 367 "CodeOn.puma" */
 {
  tTree stmt;
  tTree yyV1;
  tTree yyV2;
  {
/* line 371 "CodeOn.puma" */
   if (! ((base == 0))) goto yyL1;
  {
/* line 372 "CodeOn.puma" */
   if (! ((stride == 1))) goto yyL1;
  {
/* line 373 "CodeOn.puma" */
   if (! ((IsStride1 (actual_range->SLICE_EXP.INC)))) goto yyL1;
  {
/* line 375 "CodeOn.puma" */
   if (! ((IsBlockDistribution (kind)))) goto yyL1;
  {
/* line 377 "CodeOn.puma" */
   stmt = MakeLocalSliceStmt (template_id, template_dim, actual_range);
/* line 379 "CodeOn.puma" */
   GetTempSliceVars (template_id, template_dim, & yyV1, & yyV2);
/* line 381 "CodeOn.puma" */
   actual_range->SLICE_EXP.FIRST = mVAR_EXP (yyV1);
/* line 382 "CodeOn.puma" */
   actual_range->SLICE_EXP.STOP = mVAR_EXP (yyV2);
  }
  }
  }
  }
  }
   return stmt;
 }
yyL1:;

/* line 391 "CodeOn.puma" */
 {
  tTree stmt;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 395 "CodeOn.puma" */
   stmt = MakeLocalRangeStmt (template_id, template_dim, base, stride, actual_range);
/* line 398 "CodeOn.puma" */
   GetTempRangeVars (template_id, template_dim, & yyV1, & yyV2, & yyV3);
/* line 400 "CodeOn.puma" */
   actual_range->SLICE_EXP.FIRST = mVAR_EXP (yyV1);
/* line 401 "CodeOn.puma" */
   actual_range->SLICE_EXP.STOP = mVAR_EXP (yyV2);
/* line 403 "CodeOn.puma" */
 if (!IsBlockDistribution (kind))  
        actual_range->SLICE_EXP.INC = mVAR_EXP (yyV3);
   
  }
   return stmt;
 }

  }
/* line 410 "CodeOn.puma" */
  {
/* line 412 "CodeOn.puma" */
   failure_protocol (MODULE, "GetLocalRange", actual_range);
  }
   return NoTree;

}

static void GetTempSliceVars
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template, register int temp_dim, register tTree * yyP4, register tTree * yyP3)
# else
(template, temp_dim, yyP4, yyP3)
 register tDefinitions template;
 register int temp_dim;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{
/* line 424 "CodeOn.puma" */
 {
  tTree low;
  tTree high;
  {
/* line 429 "CodeOn.puma" */
   low = MakeUsedVarAn (template->Object.Ident, "_START", temp_dim);
/* line 430 "CodeOn.puma" */
   DefineNewIntVar (TreeVarName (low));
/* line 432 "CodeOn.puma" */
   high = MakeUsedVarAn (template->Object.Ident, "_STOP", temp_dim);
/* line 433 "CodeOn.puma" */
   DefineNewIntVar (TreeVarName (high));
  }
   * yyP4 = low;
   * yyP3 = high;
   return;
 }

;
}

static void GetTempRangeVars
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template, register int temp_dim, register tTree * yyP7, register tTree * yyP6, register tTree * yyP5)
# else
(template, temp_dim, yyP7, yyP6, yyP5)
 register tDefinitions template;
 register int temp_dim;
 register tTree * yyP7;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
/* line 439 "CodeOn.puma" */
 {
  tTree low;
  tTree high;
  tTree inc;
  {
/* line 445 "CodeOn.puma" */
   low = MakeUsedVarAn (template->Object.Ident, "_START", temp_dim);
/* line 446 "CodeOn.puma" */
   DefineNewIntVar (TreeVarName (low));
/* line 448 "CodeOn.puma" */
   high = MakeUsedVarAn (template->Object.Ident, "_STOP", temp_dim);
/* line 449 "CodeOn.puma" */
   DefineNewIntVar (TreeVarName (high));
/* line 451 "CodeOn.puma" */
   inc = MakeUsedVarAn (template->Object.Ident, "_INC", temp_dim);
/* line 452 "CodeOn.puma" */
   DefineNewIntVar (TreeVarName (inc));
  }
   * yyP7 = low;
   * yyP6 = high;
   * yyP5 = inc;
   return;
 }

;
}

static tTree MakeLocalRangeStmt
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template, register int temp_dim, register int base, register int stride, register tTree range)
# else
(template, temp_dim, base, stride, range)
 register tDefinitions template;
 register int temp_dim;
 register int base;
 register int stride;
 register tTree range;
# endif
{
  if (range->Kind == kSLICE_EXP) {
/* line 484 "CodeOn.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree paramlist;
  tIdent id;
  {
/* line 487 "CodeOn.puma" */
   GetTempRangeVars (template, temp_dim, & yyV1, & yyV2, & yyV3);
/* line 492 "CodeOn.puma" */
 paramlist = mBTP_EMPTY ();

    paramlist = mBTP_LIST (mVAR_PARAM (yyV3), paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (yyV2), paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (yyV1), paramlist);

    if (IsStride1 (range->SLICE_EXP.INC))   
       paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (1)), paramlist);
     else  
       paramlist = mBTP_LIST (ExpToVarParam (range->SLICE_EXP.INC), paramlist);
    paramlist = mBTP_LIST (ExpToVarParam (range->SLICE_EXP.STOP    ), paramlist);
    paramlist = mBTP_LIST (ExpToVarParam (range->SLICE_EXP.FIRST    ), paramlist);
    if ((base == 0) && (stride == 1))
        id = MakeDalibId ("array_lrange");
      else
        { id = MakeDalibId ("array_mrange");
          paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (base)),
                        mBTP_LIST (ExpToVarParam (MakeConstant (stride)),
                         paramlist));
        }
    paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (temp_dim)), paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (template->Object.Ident, "_DSP")),
                           paramlist);
  
  }
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (id), paramlist));
 }

  }
/* line 519 "CodeOn.puma" */
  {
/* line 520 "CodeOn.puma" */
   failure_protocol (MODULE, "MakeLocalRangeStmt", range);
  }
   return NoTree;

}

static tTree MakeLocalSliceStmt
# if defined __STDC__ | defined __cplusplus
(register tDefinitions template, register int template_dim, register tTree range)
# else
(template, template_dim, range)
 register tDefinitions template;
 register int template_dim;
 register tTree range;
# endif
{
  if (range->Kind == kSLICE_EXP) {
/* line 544 "CodeOn.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree paramlist;
  tTree call;
  {
/* line 547 "CodeOn.puma" */
   GetTempSliceVars (template, template_dim, & yyV1, & yyV2);
/* line 552 "CodeOn.puma" */
 paramlist = mBTP_EMPTY ();
    paramlist = mBTP_LIST (mVAR_PARAM (yyV2), paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (yyV1), paramlist);
    paramlist = mBTP_LIST (ExpToVarParam (range->SLICE_EXP.STOP    ), paramlist);
    paramlist = mBTP_LIST (ExpToVarParam (range->SLICE_EXP.FIRST    ), paramlist);
    paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (template_dim)),
                           paramlist);
    paramlist = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (template->Object.Ident, "_DSP")),
                           paramlist);
    call = mPROC_OBJ (MakeDalibId ("array_lslice"));
    call = mACF_BASIC (mCALL_STMT (call, paramlist));
  
  }
   return call;
 }

  }
/* line 567 "CodeOn.puma" */
  {
/* line 569 "CodeOn.puma" */
   failure_protocol (MODULE, "MakeLocalSliceStmt", range);
  }
   return NoTree;

}

static rbool IsBlockDistribution
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
/* line 575 "CodeOn.puma" */
  {
/* line 576 "CodeOn.puma" */
   if (! ((kind == kBLOCK_DIM))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 579 "CodeOn.puma" */
  {
/* line 580 "CodeOn.puma" */
   if (! ((kind == kGEN_BLOCK_DIM))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 583 "CodeOn.puma" */
  {
/* line 584 "CodeOn.puma" */
   if (! ((kind == kANY_BLOCK_DIM))) goto yyL3;
  }
   return rtrue;
yyL3:;

/* line 587 "CodeOn.puma" */
  {
/* line 588 "CodeOn.puma" */
   if (! ((kind == kANY_GEN_BLOCK_DIM))) goto yyL4;
  }
   return rtrue;
yyL4:;

  return rfalse;
}

static rbool IsMappedDistribution
# if defined __STDC__ | defined __cplusplus
(register int kind, register tTree size)
# else
(kind, size)
 register int kind;
 register tTree size;
# endif
{
/* line 593 "CodeOn.puma" */
  {
/* line 595 "CodeOn.puma" */
   if (! ((IsBlockDistribution (kind)))) goto yyL1;
  {
/* line 596 "CodeOn.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 599 "CodeOn.puma" */
  {
/* line 601 "CodeOn.puma" */
   if (! ((kind == kCYCLIC_DIM))) goto yyL2;
  {
/* line 602 "CodeOn.puma" */
   if (! ((IsOne (size)))) goto yyL2;
  {
/* line 603 "CodeOn.puma" */
   return rfalse;
  }
  }
  }
yyL2:;

/* line 606 "CodeOn.puma" */
   return rtrue;

}

static rbool IsOne
# if defined __STDC__ | defined __cplusplus
(register tTree size)
# else
(size)
 register tTree size;
# endif
{
/* line 611 "CodeOn.puma" */
  {
/* line 613 "CodeOn.puma" */
   if (! ((size == NoTree))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 616 "CodeOn.puma" */
 {
  rbool found;
  int val;
  {
/* line 621 "CodeOn.puma" */
   GetIntConstValue (size, & found, & val);
/* line 622 "CodeOn.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 623 "CodeOn.puma" */
   if (! ((val == 1))) goto yyL2;
  }
  }
   return rtrue;
 }
yyL2:;

  return rfalse;
}

tTree InitTaskRegion
# if defined __STDC__ | defined __cplusplus
(register tTree task_body)
# else
(task_body)
 register tTree task_body;
# endif
{
  if (task_body->Kind == kACF_LIST) {
/* line 634 "CodeOn.puma" */
   return CombineACF (InitTaskRegion (task_body->ACF_LIST.Elem), InitTaskRegion (task_body->ACF_LIST.Next));

  }
  if (task_body->Kind == kACF_EMPTY) {
/* line 639 "CodeOn.puma" */
   return NoTree;

  }
  if (task_body->Kind == kACF_ON) {
  if (task_body->ACF_ON.ON_HOME->Kind == kON_VAR) {
  if (Definitions_IsType (task_body->ACF_ON.ON_HOME->ON_VAR.arrayid, kObject)) {
/* line 644 "CodeOn.puma" */
 {
  tTree stmt;
  tTree params;
  {
/* line 650 "CodeOn.puma" */
 params = mBTP_EMPTY ();

     params = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (task_body->ACF_ON.ON_HOME->ON_VAR.arrayid->Object.Ident, DSP_SUFFIX)),
                         params);

     stmt = mPROC_OBJ (MakeDalibId ("set_task_home"));
     stmt = mCALL_STMT (stmt, params);
     stmt = mACF_BASIC (stmt);
   
  }
   return stmt;
 }

  }
  }
  if (task_body->ACF_ON.ON_HOME->Kind == kON_PROCS) {
  if (Definitions_IsType (task_body->ACF_ON.ON_HOME->ON_PROCS.topid, kObject)) {
/* line 663 "CodeOn.puma" */
 {
  tTree create;
  tTree stmt;
  tTree params;
  {
/* line 670 "CodeOn.puma" */
 create = MakeSubProcStmt (task_body->ACF_ON.ON_HOME->ON_PROCS.topid);

     params = mBTP_EMPTY ();

     params = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (task_body->ACF_ON.ON_HOME->ON_PROCS.topid->Object.Ident, "_TOPID")),
                         params);

     stmt = mPROC_OBJ (MakeDalibId ("set_task_procs"));
     stmt = mCALL_STMT (stmt, params);
     stmt = mACF_BASIC (stmt);
     stmt = mACF_LIST (stmt, NoTree);
   
  }
   return CombineACF (create, stmt);
 }

  }
  }
  }
  if (task_body->Kind == kACF_DO) {
/* line 686 "CodeOn.puma" */
 {
  tTree stmt;
  {
/* line 690 "CodeOn.puma" */
   stmt = CompleteACFs (InitTaskRegion (task_body->ACF_DO.DO_BODY));
/* line 692 "CodeOn.puma" */
   stmt = mACF_DO (CopyTree (task_body->ACF_DO.DO_ID), CopyTree (task_body->ACF_DO.DO_RANGE), stmt, CopyTree (task_body->ACF_DO.DO_DEP_INFO), CopyTree (task_body->ACF_DO.DO_HOME_INFO));
  }
   return mACF_LIST (stmt, NoTree);
 }

  }
/* line 698 "CodeOn.puma" */
  {
/* line 699 "CodeOn.puma" */
   failure_protocol (MODULE, "InitTaskRegion", task_body);
  }
   return NoTree;

}

tTree StartTasking
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 705 "CodeOn.puma" */
 {
  tTree stmt;
  tTree params;
  {
/* line 709 "CodeOn.puma" */
 params = mBTP_EMPTY ();

     stmt = mPROC_OBJ (MakeDalibId ("start_tasking"));
     stmt = mCALL_STMT (stmt, params);
     stmt = mACF_BASIC (stmt);
   
  }
   return stmt;
 }

}

tTree StopTasking
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 721 "CodeOn.puma" */
 {
  tTree stmt;
  tTree params;
  {
/* line 725 "CodeOn.puma" */
 params = mBTP_EMPTY ();

     stmt = mPROC_OBJ (MakeDalibId ("stop_tasking"));
     stmt = mCALL_STMT (stmt, params);
     stmt = mACF_BASIC (stmt);
   
  }
   return stmt;
 }

}

tTree ApplyOnInfo
# if defined __STDC__ | defined __cplusplus
(register tTree t, register rbool push_flag)
# else
(t, push_flag)
 register tTree t;
 register rbool push_flag;
# endif
{
  if (t->Kind == kACF_DO) {
  if (t->ACF_DO.DO_HOME_INFO->Kind == kON_INFO) {
/* line 766 "CodeOn.puma" */
 {
  tTree new_body;
  tTree val;
  {
/* line 779 "CodeOn.puma" */
   if (! ((IsMappedDistribution (t->ACF_DO.DO_HOME_INFO->ON_INFO.kind, t->ACF_DO.DO_HOME_INFO->ON_INFO.size)))) goto yyL1;
  {
/* line 784 "CodeOn.puma" */
 val = mVAR_EXP (CopyTree (t->ACF_DO.DO_ID));
     val = MultConstant (val, t->ACF_DO.DO_HOME_INFO->ON_INFO.stride);
     val = AddConstant (val, t->ACF_DO.DO_HOME_INFO->ON_INFO.base);

     new_body = mACF_IF (MakeIsLocal (t->ACF_DO.DO_HOME_INFO->ON_INFO.on_id, t->ACF_DO.DO_HOME_INFO->ON_INFO.on_dim, val), t->ACF_DO.DO_BODY, mACF_EMPTY ());

     t->ACF_DO.DO_BODY = MakeStmtList (new_body);
     t->ACF_DO.DO_HOME_INFO = mNO_HOME_INFO ();
   
/* line 794 "CodeOn.puma" */
   CodeParallelLoop (t);
  }
  }
   return t;
 }
yyL1:;

/* line 798 "CodeOn.puma" */
 {
  tTree range_stmt;
  tTree new_stmts;
  {
/* line 806 "CodeOn.puma" */
 range_stmt = GetLocalRange (t->ACF_DO.DO_RANGE, t->ACF_DO.DO_HOME_INFO->ON_INFO.kind, t->ACF_DO.DO_HOME_INFO->ON_INFO.base, t->ACF_DO.DO_HOME_INFO->ON_INFO.stride, t->ACF_DO.DO_HOME_INFO->ON_INFO.on_id, t->ACF_DO.DO_HOME_INFO->ON_INFO.on_dim);

     new_stmts = t;

     if (push_flag)

       new_stmts = ComposeNewACF (PushContext (t->ACF_DO.DO_HOME_INFO->ON_INFO.on_id, t->ACF_DO.DO_HOME_INFO->ON_INFO.on_dim), new_stmts,
                                  PopContext (t->ACF_DO.DO_HOME_INFO->ON_INFO.on_id, t->ACF_DO.DO_HOME_INFO->ON_INFO.on_dim));

     if (range_stmt != NoTree)

        new_stmts = CombineACF (range_stmt, new_stmts);

     t->ACF_DO.DO_HOME_INFO = mNO_HOME_INFO ();

     CodeParallelLoop (t);

   
  }
   return new_stmts;
 }

  }
  }
/* line 828 "CodeOn.puma" */
  {
/* line 830 "CodeOn.puma" */
   failure_protocol (MODULE, "ApplyOnInfo", t);
  }
   return NoTree;

}

static tTree PushContext
# if defined __STDC__ | defined __cplusplus
(register tDefinitions on_id, register int on_dim)
# else
(on_id, on_dim)
 register tDefinitions on_id;
 register int on_dim;
# endif
{
/* line 843 "CodeOn.puma" */
 {
  tTree params;
  {
/* line 847 "CodeOn.puma" */
 params = mBTP_EMPTY ();
     params = mBTP_LIST (ExpToVarParam (MakeConstant (on_dim)), params);
   
  }
   return MakePushHomeCall (on_id->Object.Ident, params);
 }

}

static tTree PopContext
# if defined __STDC__ | defined __cplusplus
(register tDefinitions on_id, register int on_dim)
# else
(on_id, on_dim)
 register tDefinitions on_id;
 register int on_dim;
# endif
{
/* line 856 "CodeOn.puma" */
   return MakePopHomeCall ();

}

tTree CodeONPushContext
# if defined __STDC__ | defined __cplusplus
(register tTree top, register tTree specs)
# else
(top, specs)
 register tTree top;
 register tTree specs;
# endif
{
  if (top->Kind == kON_VAR) {
  if (Definitions_IsType (top->ON_VAR.arrayid, kObject)) {
/* line 869 "CodeOn.puma" */
   return MakePushHomeCall (top->ON_VAR.arrayid->Object.Ident, MakePushParams (specs));

  }
  }
  if (top->Kind == kON_PROCS) {
  if (Definitions_IsType (top->ON_PROCS.topid, kObject)) {
/* line 874 "CodeOn.puma" */
 {
  tTree stmt;
  tTree params;
  {
/* line 879 "CodeOn.puma" */
 params = mBTP_EMPTY ();

      params = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (top->ON_PROCS.topid->Object.Ident, "_TOPID")),
                          params);

      stmt = mPROC_OBJ (MakeDalibId ("push_procs_context"));
      stmt = mCALL_STMT (stmt, params);
      stmt = mACF_BASIC (stmt);
    
  }
   return stmt;
 }

  }
  }
  if (top->Kind == kON_HOST) {
/* line 892 "CodeOn.puma" */
 {
  tTree stmt;
  tTree params;
  {
/* line 897 "CodeOn.puma" */
 params = mBTP_EMPTY ();

      stmt = mPROC_OBJ (MakeDalibId ("push_host_context"));
      stmt = mCALL_STMT (stmt, params);
      stmt = mACF_BASIC (stmt);
    
  }
   return stmt;
 }

  }
/* line 907 "CodeOn.puma" */
  {
/* line 909 "CodeOn.puma" */
   failure_protocol (MODULE, "CodeOnContext", top);
  }
   return NoTree;

}

tTree CodeONPopContext
# if defined __STDC__ | defined __cplusplus
(register tTree top, register tTree specs)
# else
(top, specs)
 register tTree top;
 register tTree specs;
# endif
{
  if (top->Kind == kON_VAR) {
/* line 915 "CodeOn.puma" */
   return MakePopHomeCall ();

  }
  if (top->Kind == kON_PROCS) {
/* line 920 "CodeOn.puma" */
 {
  tTree stmt;
  tTree params;
  {
/* line 925 "CodeOn.puma" */
 params = mBTP_EMPTY ();

      stmt = mCALL_STMT (mPROC_OBJ (MakeDalibId ("pop_procs_context")), params);
      stmt = mACF_BASIC (stmt);
    
  }
   return stmt;
 }

  }
  if (top->Kind == kON_HOST) {
/* line 934 "CodeOn.puma" */
 {
  tTree stmt;
  tTree params;
  {
/* line 939 "CodeOn.puma" */
 params = mBTP_EMPTY ();

      stmt = mCALL_STMT (mPROC_OBJ (MakeDalibId ("pop_host_context")), params);
      stmt = mACF_BASIC (stmt);
    
  }
   return stmt;
 }

  }
/* line 948 "CodeOn.puma" */
  {
/* line 950 "CodeOn.puma" */
   failure_protocol (MODULE, "CodeOnContext", top);
  }
   return NoTree;

}

static tTree MakePushParams
# if defined __STDC__ | defined __cplusplus
(register tTree specs)
# else
(specs)
 register tTree specs;
# endif
{
  if (specs->Kind == kON_EMPTY) {
/* line 962 "CodeOn.puma" */
   return mBTP_EMPTY ();

  }
  if (specs->Kind == kON_LIST) {
/* line 967 "CodeOn.puma" */
   return mBTP_LIST (MakePushParams (specs->ON_LIST.Elem), MakePushParams (specs->ON_LIST.Next));

  }
  if (specs->Kind == kON_SPEC) {
/* line 973 "CodeOn.puma" */
   return ExpToVarParam (MakeConstant (specs->ON_SPEC.array_dim));

  }
/* line 978 "CodeOn.puma" */
  {
/* line 979 "CodeOn.puma" */
   failure_protocol (MODULE, "MakePushParams", specs);
  }
   return NoTree;

}

static tTree MakePushHomeCall
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree spec_params)
# else
(id, spec_params)
 register tIdent id;
 register tTree spec_params;
# endif
{
/* line 991 "CodeOn.puma" */
 {
  int len;
  tTree params;
  tTree stmt;
  {
/* line 997 "CodeOn.puma" */
 len    = TreeListLength (spec_params);

      params = mBTP_LIST (ExpToVarParam (MakeConstant (len)), spec_params);
      params = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (id, DSP_SUFFIX)),
                          params);

      stmt = mPROC_OBJ (MakeDalibId ("push_home_context"));
      stmt = mCALL_STMT (stmt, params);
      stmt = mACF_BASIC (stmt);
    
  }
   return stmt;
 }

}

static tTree MakePopHomeCall
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 1013 "CodeOn.puma" */
 {
  tTree stmt;
  tTree params;
  {
/* line 1018 "CodeOn.puma" */
 params = mBTP_EMPTY ();

     stmt = mCALL_STMT (mPROC_OBJ (MakeDalibId ("pop_home_context")), params);
     stmt = mACF_BASIC (stmt);
   
  }
   return stmt;
 }

}

void BeginCodeOn ARGS ((void))
{
}

void CloseCodeOn ARGS ((void))
{
}
