# include "CodeMovement.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 23 "CodeMovement.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"
# include "protocol.h"
# include "permutations.h"

# include "Types.h"
# include "Transform.h"      /* ExpToVarParam */
# include "Expressions.h"    /* MakeConstant  */
# include "MoveControl.h" 
# include "Dalib.h"

# include "CodeDescriptors.h"  /* DalibSectionTranslation */

# define MODULE "CodeMovement"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCodeMovement.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* CodeMovement_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeMovement, routine %s failed\n",
  yyFunction);
 CodeMovement_Exit ();
}

tTree CodeMovement ARGS ((tTree t));
static tTree MakeStructuredMovement ARGS ((tTree target, tTree source, tTree mask));
static tTree MakeCallStmt ARGS ((tIdent id, tTree params));
static void MakeDescriptor ARGS ((tTree var, int nr, tTree * yyP3, tTree * yyP2, tTree * yyP1));
static void MakeDescriptor2 ARGS ((tTree var1, tTree var2, tTree * yyP6, tTree * yyP5, tTree * yyP4));
static void MakeDescriptor3 ARGS ((tTree var1, tTree var2, tTree var3, tTree * yyP9, tTree * yyP8, tTree * yyP7));
static tTree MakePermuteParams ARGS ((Permutation perm));

tTree CodeMovement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_MOVE) {
  if (t->ACF_MOVE.MOVE_STMT->Kind == kMOVE_STMT) {
/* line 51 "CodeMovement.puma" */
   return MakeStructuredMovement (t->ACF_MOVE.MOVE_STMT->MOVE_STMT.TARGET, t->ACF_MOVE.MOVE_STMT->MOVE_STMT.SOURCE, t->ACF_MOVE.MOVE_STMT->MOVE_STMT.MASK);

  }
  }
/* line 56 "CodeMovement.puma" */
  {
/* line 57 "CodeMovement.puma" */
   failure_protocol (MODULE, "CodeMovement", t);
  }
   return NoTree;

}

static tTree MakeStructuredMovement
# if defined __STDC__ | defined __cplusplus
(register tTree target, register tTree source, register tTree mask)
# else
(target, source, mask)
 register tTree target;
 register tTree source;
 register tTree mask;
# endif
{
  if (source->Kind == kPERM_VAR) {
  if (mask->Kind == kNO_PARAM) {
/* line 75 "CodeMovement.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree call;
  {
/* line 77 "CodeMovement.puma" */
   MakeDescriptor2 (target, source->PERM_VAR.VAL, & yyV1, & yyV2, & yyV3);
/* line 81 "CodeMovement.puma" */
   call = MakeCallStmt (MakeDalibId ("assign_permute"), CombineBTP (yyV1, MakePermuteParams (source->PERM_VAR.perm)));
  }
   return CombineACF (yyV2, CombineACF (call, yyV3));
 }

  }
  }
  if (mask->Kind == kNO_PARAM) {
/* line 87 "CodeMovement.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree call;
  {
/* line 89 "CodeMovement.puma" */
   MakeDescriptor2 (target, source, & yyV1, & yyV2, & yyV3);
/* line 93 "CodeMovement.puma" */
   call = MakeCallStmt (MakeDalibId ("assign"), CompleteBTPs (yyV1));
  }
   return CombineACF (yyV2, CombineACF (call, yyV3));
 }

  }
  if (source->Kind == kPERM_VAR) {
/* line 98 "CodeMovement.puma" */
  {
/* line 100 "CodeMovement.puma" */
   error_protocol ("could not translate structured movement");
  }
   return NoTree;

  }
  if (mask->Kind == kVAR_PARAM) {
/* line 105 "CodeMovement.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree call;
  {
/* line 107 "CodeMovement.puma" */
   if (! ((CountMovements (target, mask) == 0))) goto yyL4;
  {
/* line 109 "CodeMovement.puma" */
   MakeDescriptor3 (target, source, mask->VAR_PARAM.V, & yyV1, & yyV2, & yyV3);
/* line 113 "CodeMovement.puma" */
   call = MakeCallStmt (MakeDalibId ("massign_rhs"), CompleteBTPs (yyV1));
  }
  }
   return CombineACF (yyV2, CombineACF (call, yyV3));
 }
yyL4:;

/* line 118 "CodeMovement.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree call;
  {
/* line 120 "CodeMovement.puma" */
   MakeDescriptor3 (target, source, mask->VAR_PARAM.V, & yyV1, & yyV2, & yyV3);
/* line 124 "CodeMovement.puma" */
   call = MakeCallStmt (MakeDalibId ("massign_lhs"), CompleteBTPs (yyV1));
  }
   return CombineACF (yyV2, CombineACF (call, yyV3));
 }

  }
 yyAbort ("MakeStructuredMovement");
 { tTree yyDummy; return yyDummy; }
}

static tTree MakeCallStmt
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree params)
# else
(id, params)
 register tIdent id;
 register tTree params;
# endif
{
/* line 131 "CodeMovement.puma" */
 {
  tTree call;
  {
/* line 135 "CodeMovement.puma" */
   call = mPROC_OBJ (id);
/* line 136 "CodeMovement.puma" */
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
   return call;
 }

}

static void MakeDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int nr, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(var, nr, yyP3, yyP2, yyP1)
 register tTree var;
 register int nr;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
/* line 149 "CodeMovement.puma" */
 {
  tTree param;
  tTree pre_stmt;
  tTree post_stmt;
  {
/* line 155 "CodeMovement.puma" */
   DalibSectionTranslation (nr, var, & pre_stmt, & param, & post_stmt);
  }
   * yyP3 = param;
   * yyP2 = pre_stmt;
   * yyP1 = post_stmt;
   return;
 }

;
}

static void MakeDescriptor2
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register tTree var2, register tTree * yyP6, register tTree * yyP5, register tTree * yyP4)
# else
(var1, var2, yyP6, yyP5, yyP4)
 register tTree var1;
 register tTree var2;
 register tTree * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
/* line 160 "CodeMovement.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 164 "CodeMovement.puma" */
   MakeDescriptor (var1, 1, & yyV1, & yyV2, & yyV3);
/* line 165 "CodeMovement.puma" */
   MakeDescriptor (var2, 2, & yyV4, & yyV5, & yyV6);
  }
   * yyP6 = mBTP_LIST (yyV1, mBTP_LIST (yyV4, NoTree));
   * yyP5 = CombineACF (yyV2, yyV5);
   * yyP4 = CombineACF (yyV6, yyV3);
   return;
 }

;
}

static void MakeDescriptor3
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register tTree var2, register tTree var3, register tTree * yyP9, register tTree * yyP8, register tTree * yyP7)
# else
(var1, var2, var3, yyP9, yyP8, yyP7)
 register tTree var1;
 register tTree var2;
 register tTree var3;
 register tTree * yyP9;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
/* line 171 "CodeMovement.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 175 "CodeMovement.puma" */
   MakeDescriptor2 (var1, var2, & yyV1, & yyV2, & yyV3);
/* line 176 "CodeMovement.puma" */
   MakeDescriptor (var3, 3, & yyV4, & yyV5, & yyV6);
  }
   * yyP9 = CombineBTP (yyV1, mBTP_LIST (yyV4, NoTree));
   * yyP8 = CombineACF (yyV2, yyV5);
   * yyP7 = CombineACF (yyV6, yyV3);
   return;
 }

;
}

static tTree MakePermuteParams
# if defined __STDC__ | defined __cplusplus
(Permutation perm)
# else
(perm)
 Permutation perm;
# endif
{
/* line 187 "CodeMovement.puma" */
 {
  int i;
  tTree params;
  tTree param;
  {
/* line 192 "CodeMovement.puma" */
 params = mBTP_EMPTY();
     for (i = perm.n; i > 0; i--)
       { param = ExpToVarParam (MakeConstant (perm.pa[i-1]));
         params = mBTP_LIST (param, params);
       }
   
  }
   return params;
 }

}

void BeginCodeMovement ARGS ((void))
{
}

void CloseCodeMovement ARGS ((void))
{
}
