# include "CodeMapping.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 53 "CodeMapping.puma" */


# define  MODULE      "CodeMapping"

# include <stdio.h>
# include <string.h>

# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "DefTable.h"

# include "CodeGeneral.h"
# include "Types.h"           /* ArrayFormals */
# include "Objects.h"         /* */
# include "TreeOps.h"         /* TreeVarName */
# include "Rank.h"         /* TreeVarName */
# include "Transform.h"       /* ExpToVarParam */
# include "Dalib.h"           /* MakeDalibId, MakeUsedVarA */
# include "TriDenT.h"         /* MakeDalibId, MakeUsedVarA */
# include "Expressions.h"     /* MakeConstant */
# include "Shapes.h"          /* MakeFullShape */
# include "Distributions.h"   /* MakeFullShape */
# include "ArrayDescriptor.h" /* GetDspKind, GetDspDynKind  */
# include "Nesting.h"
# include "RegShadow.h"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCodeMapping.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* CodeMapping_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeMapping, routine %s failed\n",
  yyFunction);
 CodeMapping_Exit ();
}

tTree DalibArrayMakeDsp ARGS ((tTree var, int kind));
tTree DalibArrayDefine ARGS ((tTree var, tTree dim_list, int kind));
tTree DalibArrayCreateCopy ARGS ((tTree var));
tTree DalibArrayOverlap ARGS ((tTree var, int kind));
static int CodeFullShadow ARGS ((tTree shadow_specs));
tTree DalibArrayFree ARGS ((tTree var, int kind));
tTree DalibArrayDistribute ARGS ((tTree var, int kind));
tTree DalibArrayShared ARGS ((tTree var, int kind));
tTree DalibAlignSource ARGS ((tTree var, int kind));
tTree DalibAlignTarget ARGS ((tTree var, int kind));
static tTree MakeSourceParams ARGS ((tDefinitions ilist));
static tTree MakeTargetParams ARGS ((tDefinitions plist));
tTree DalibArrayTrace ARGS ((tTree var));
static tTree MakeDspAssign ARGS ((tTree var, String lhs_suffix, String rhs_suffix));
tTree DalibCopyDsp ARGS ((tTree var, int kind));
tTree DalibSaveCommonDsp ARGS ((tTree var, int kind));
tTree DalibCopyIn ARGS ((tTree var, int kind));
tTree DalibCopyOut ARGS ((tTree var, int kind));
tTree DalibArrayRedistribute ARGS ((tTree var));
tTree DalibArrayAllocate ARGS ((tTree var, int kind));
tTree DalibTopCreate ARGS ((tTree var));
tTree MakeSubProcStmt ARGS ((tDefinitions obj));
tTree DistributionDecls ARGS ((tDefinitions obj));
static tTree MakeDescriptorDecls ARGS ((tDefinitions obj));
static rbool NoCopyInCopyOut ARGS ((tDefinitions obj, int kind));
static void GetVarObject ARGS ((tTree var, tDefinitions * yyP1));
static void GetSizeOfObject ARGS ((tTree var, tDefinitions obj, tTree * yyP2));
static void GetTopologyInfo ARGS ((tDefinitions obj, tIdent * yyP4, tTree * yyP3));
static void GetObjSharedInfo ARGS ((tDefinitions obj, int * yyP5));
static void GetObjDistributionData ARGS ((tDefinitions obj, tDefinitions * yyP8, tDefinitions * yyP7, tDefinitions * yyP6));
static void GetCopyInfo ARGS ((tDefinitions obj, int * yyP10, int * yyP9));
static tTree MakeIdStringParam ARGS ((tIdent id));

tTree DalibArrayMakeDsp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 100 "CodeMapping.puma" */
  {
/* line 102 "CodeMapping.puma" */
   if (! ((safety == 0))) goto yyL1;
  {
/* line 103 "CodeMapping.puma" */
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
  }
   return NoTree;
yyL1:;

/* line 108 "CodeMapping.puma" */
  {
/* line 110 "CodeMapping.puma" */
   if (! ((safety == 0))) goto yyL2;
  {
/* line 111 "CodeMapping.puma" */
   if (! ((kind == kASSUMED_DSP))) goto yyL2;
  }
  }
   return NoTree;
yyL2:;

/* line 116 "CodeMapping.puma" */
  {
/* line 118 "CodeMapping.puma" */
   if (! ((kind == kLOCAL_DSP))) goto yyL3;
  }
   return NoTree;
yyL3:;

/* line 122 "CodeMapping.puma" */
 {
  tTree param;
  tTree params;
  tTree call;
  tIdent cname;
  int dsp_kind;
  int dynamic;
  tDefinitions yyV1;
  tTree yyV2;
  {
/* line 131 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 132 "CodeMapping.puma" */
   GetSizeOfObject (var, yyV1, & yyV2);
/* line 134 "CodeMapping.puma" */
   params = mBTP_EMPTY ();
/* line 136 "CodeMapping.puma" */
   param = MakeIdStringParam (yyV1->Object.Ident);
/* line 137 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 139 "CodeMapping.puma" */
   dynamic = 0;
/* line 141 "CodeMapping.puma" */
   if ((IsHPFDynamic (yyV1))) {
/* line 141 "CodeMapping.puma" */
   dynamic = 1;
   }
/* line 143 "CodeMapping.puma" */
   param = ExpToVarParam (MakeConstant (dynamic));
/* line 144 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 146 "CodeMapping.puma" */
   dsp_kind = GetDspDynKind (yyV1);
/* line 148 "CodeMapping.puma" */
   param = ExpToVarParam (MakeConstant (dsp_kind));
/* line 149 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 151 "CodeMapping.puma" */
   param = ExpToVarParam (yyV2);
/* line 152 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 154 "CodeMapping.puma" */
   param = ExpToVarParam (MakeConstant (VarRank (yyV1)));
/* line 155 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 157 "CodeMapping.puma" */
   cname = MakeDalibId ("array_make_dsp");
/* line 159 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 160 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 162 "CodeMapping.puma" */
   call = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
   return call;
 }

}

tTree DalibArrayDefine
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree dim_list, register int kind)
# else
(var, dim_list, kind)
 register tTree var;
 register tTree dim_list;
 register int kind;
# endif
{
/* line 184 "CodeMapping.puma" */
  {
/* line 186 "CodeMapping.puma" */
   if (! ((safety == 0))) goto yyL1;
  {
/* line 187 "CodeMapping.puma" */
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
  }
   return NoTree;
yyL1:;

/* line 192 "CodeMapping.puma" */
  {
/* line 194 "CodeMapping.puma" */
   if (! ((safety == 0))) goto yyL2;
  {
/* line 195 "CodeMapping.puma" */
   if (! ((kind == kASSUMED_DSP))) goto yyL2;
  }
  }
   return NoTree;
yyL2:;

/* line 200 "CodeMapping.puma" */
  {
/* line 202 "CodeMapping.puma" */
   if (! ((kind == kLOCAL_DSP))) goto yyL3;
  }
   return NoTree;
yyL3:;

/* line 207 "CodeMapping.puma" */
 {
  tTree param;
  tTree params;
  tTree call;
  tIdent cname;
  {
/* line 209 "CodeMapping.puma" */
   if (! ((kind == kASSUMED_DSP))) goto yyL4;
  {
/* line 216 "CodeMapping.puma" */
   params = MakeExtensionParams (dim_list);
/* line 218 "CodeMapping.puma" */
   cname = MakeDalibId ("array_get_define");
/* line 220 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DUMMY_SUFFIX));
/* line 221 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 222 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 223 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 225 "CodeMapping.puma" */
   call = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
  }
   return call;
 }
yyL4:;

/* line 229 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  {
/* line 231 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 233 "CodeMapping.puma" */
   if (! ((IsRaggedVarObject (yyV1)))) goto yyL5;
  }
   return TriDenTArrayDefine (var, dim_list, kind);
 }
yyL5:;

/* line 238 "CodeMapping.puma" */
 {
  tTree param;
  tTree params;
  tTree call;
  tIdent cname;
  {
/* line 245 "CodeMapping.puma" */
   params = MakeExtensionParams (dim_list);
/* line 247 "CodeMapping.puma" */
   cname = MakeDalibId ("array_define");
/* line 249 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 250 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 252 "CodeMapping.puma" */
   call = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
   return call;
 }

}

tTree DalibArrayCreateCopy
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 266 "CodeMapping.puma" */
 {
  tTree param;
  tTree paramlist;
  tIdent cname;
  {
/* line 272 "CodeMapping.puma" */
   paramlist = mBTP_EMPTY ();
/* line 273 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 274 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 275 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DYNAMIC_SUFFIX));
/* line 276 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 278 "CodeMapping.puma" */
   cname = MakeDalibId ("array_create_copy");
  }
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), paramlist));
 }

}

tTree DalibArrayOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 298 "CodeMapping.puma" */
  {
/* line 300 "CodeMapping.puma" */
   if (! ((safety == 0))) goto yyL1;
  {
/* line 301 "CodeMapping.puma" */
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
  }
   return NoTree;
yyL1:;

/* line 306 "CodeMapping.puma" */
  {
/* line 308 "CodeMapping.puma" */
   if (! ((safety == 0))) goto yyL2;
  {
/* line 309 "CodeMapping.puma" */
   if (! ((kind == kASSUMED_DSP))) goto yyL2;
  }
  }
   return NoTree;
yyL2:;

/* line 314 "CodeMapping.puma" */
 {
  tTree shadow_specs;
  int is_full_shadow;
  tDefinitions yyV1;
  tTree params;
  tIdent cname;
  {
/* line 319 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 321 "CodeMapping.puma" */
   shadow_specs = GetVarShadow (yyV1);
/* line 323 "CodeMapping.puma" */
   if (! ((! IsZeroShadow (shadow_specs)))) goto yyL3;
  {
/* line 328 "CodeMapping.puma" */
   params = MakeShadowParams (shadow_specs);
/* line 330 "CodeMapping.puma" */
   cname = MakeDalibId ("array_shadow");
/* line 332 "CodeMapping.puma" */
   is_full_shadow = CodeFullShadow (shadow_specs);
/* line 334 "CodeMapping.puma" */
   params = mBTP_LIST (ExpToVarParam (MakeConstant (is_full_shadow)), params);
/* line 337 "CodeMapping.puma" */
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX)), params);
  }
  }
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
 }
yyL3:;

/* line 343 "CodeMapping.puma" */
   return NoTree;

}

static int CodeFullShadow
# if defined __STDC__ | defined __cplusplus
(register tTree shadow_specs)
# else
(shadow_specs)
 register tTree shadow_specs;
# endif
{
 yyRecursion:
  if (shadow_specs->Kind == kSHADOW_LIST) {
/* line 355 "CodeMapping.puma" */
   return 1;

  }
  if (shadow_specs->Kind == kSHADOW_EMPTY) {
/* line 365 "CodeMapping.puma" */
   return 0;

  }
/* line 370 "CodeMapping.puma" */
  {
/* line 372 "CodeMapping.puma" */
   failure_protocol (MODULE, "CodeFullShadow", shadow_specs);
  }
   return 0;

}

tTree DalibArrayFree
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 388 "CodeMapping.puma" */
  {
/* line 390 "CodeMapping.puma" */
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 394 "CodeMapping.puma" */
  {
/* line 396 "CodeMapping.puma" */
   if (! ((kind == kATTACH_DSP))) goto yyL2;
  }
   return NoTree;
yyL2:;

/* line 400 "CodeMapping.puma" */
  {
/* line 402 "CodeMapping.puma" */
   if (! ((kind == kLOCAL_DSP))) goto yyL3;
  }
   return NoTree;
yyL3:;

/* line 406 "CodeMapping.puma" */
  {
/* line 408 "CodeMapping.puma" */
   if (! ((kind == kASSUMED_DSP))) goto yyL4;
  }
   return NoTree;
yyL4:;

/* line 412 "CodeMapping.puma" */
 {
  tTree params;
  tTree call;
  tDefinitions yyV1;
  {
/* line 420 "CodeMapping.puma" */
   params = mBTP_EMPTY ();
/* line 422 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 424 "CodeMapping.puma" */
 if (!IsTemplate(yyV1) && !IsTopology(yyV1))

        params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, "")),
                            params);
    
/* line 430 "CodeMapping.puma" */
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX)), params);
/* line 433 "CodeMapping.puma" */
 call  = mPROC_OBJ (MakeDalibId ("array_free")); 
/* line 435 "CodeMapping.puma" */
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
   return call;
 }

}

tTree DalibArrayDistribute
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 454 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  {
/* line 456 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 458 "CodeMapping.puma" */
   if (! ((NoCopyInCopyOut (yyV1, kind)))) goto yyL1;
  }
   return NoTree;
 }
yyL1:;

/* line 463 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  tDefinitions yyV2;
  tDefinitions yyV3;
  tDefinitions yyV4;
  tTree params;
  tIdent cname;
  tTree d_stmt;
  tTree s_stmt;
  {
/* line 465 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 467 "CodeMapping.puma" */
   GetObjDistributionData (yyV1, & yyV2, & yyV3, & yyV4);
/* line 469 "CodeMapping.puma" */
   if (! ((yyV1 == yyV2))) goto yyL2;
  {
/* line 476 "CodeMapping.puma" */
   params = MakeDistributeParams (yyV4);
/* line 477 "CodeMapping.puma" */
   params = mBTP_LIST (MakeTopologyParam (GetTopologyObj (yyV2)), params);
/* line 479 "CodeMapping.puma" */
   cname = MakeDalibId ("distribute");
/* line 481 "CodeMapping.puma" */
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX)), params);
/* line 484 "CodeMapping.puma" */
   d_stmt = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
/* line 485 "CodeMapping.puma" */
   d_stmt = mACF_LIST (d_stmt, NoTree);
/* line 487 "CodeMapping.puma" */
   s_stmt = MakeSubProcStmt (GetTopologyObj (yyV2));
  }
  }
   return CombineACF (s_stmt, d_stmt);
 }
yyL2:;

/* line 492 "CodeMapping.puma" */
   return NoTree;

}

tTree DalibArrayShared
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 510 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  int yyV2;
  {
/* line 512 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 514 "CodeMapping.puma" */
   GetObjSharedInfo (yyV1, & yyV2);
/* line 516 "CodeMapping.puma" */
   if (! (((yyV2 == kDEFAULT_SHARED) || (yyV2 == kNOT_SHARED)))) goto yyL1;
  }
   return NoTree;
 }
yyL1:;

/* line 521 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  int yyV2;
  tTree params;
  tIdent cname;
  {
/* line 523 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 525 "CodeMapping.puma" */
   GetObjSharedInfo (yyV1, & yyV2);
/* line 530 "CodeMapping.puma" */
   params = mBTP_EMPTY ();
/* line 532 "CodeMapping.puma" */
 if (yyV2 == kGLOBAL_SHARED) 

         cname = MakeDalibId ("array_shared");

       else 

        { cname = MakeDalibId ("array_rma");
          params = mBTP_LIST (ExpToVarParam (MakeConstant (yyV2)),
                              params);
        }
    
/* line 544 "CodeMapping.puma" */
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX)), params);
  }
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
 }

}

tTree DalibAlignSource
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 565 "CodeMapping.puma" */
  {
/* line 567 "CodeMapping.puma" */
   if (! ((safety == 0))) goto yyL1;
  {
/* line 568 "CodeMapping.puma" */
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
  }
   return NoTree;
yyL1:;

/* line 573 "CodeMapping.puma" */
  {
/* line 575 "CodeMapping.puma" */
   if (! ((safety == 0))) goto yyL2;
  {
/* line 576 "CodeMapping.puma" */
   if (! ((kind == kASSUMED_DSP))) goto yyL2;
  }
  }
   return NoTree;
yyL2:;

/* line 581 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  tDefinitions yyV2;
  tDefinitions yyV3;
  tDefinitions yyV4;
  tTree param;
  tTree params;
  tIdent cname;
  {
/* line 583 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 585 "CodeMapping.puma" */
   GetObjDistributionData (yyV1, & yyV2, & yyV3, & yyV4);
/* line 587 "CodeMapping.puma" */
   if (! ((yyV1 != yyV2))) goto yyL3;
  {
/* line 593 "CodeMapping.puma" */
   params = MakeSourceParams (yyV4);
/* line 594 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeUsedVarA (yyV2->Object.Ident, DSP_SUFFIX));
/* line 595 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 597 "CodeMapping.puma" */
   cname = MakeDalibId ("align_source");
/* line 599 "CodeMapping.puma" */
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX)), params);
  }
  }
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
 }
yyL3:;

/* line 605 "CodeMapping.puma" */
  {
/* line 606 "CodeMapping.puma" */
   failure_protocol (MODULE, "DalibAlignSource", NoTree);
  }
   return NoTree;

}

tTree DalibAlignTarget
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 618 "CodeMapping.puma" */
  {
/* line 620 "CodeMapping.puma" */
   if (! ((safety == 0))) goto yyL1;
  {
/* line 621 "CodeMapping.puma" */
   if (! ((kind == kDUMMY_DSP))) goto yyL1;
  }
  }
   return NoTree;
yyL1:;

/* line 626 "CodeMapping.puma" */
  {
/* line 628 "CodeMapping.puma" */
   if (! ((safety == 0))) goto yyL2;
  {
/* line 629 "CodeMapping.puma" */
   if (! ((kind == kASSUMED_DSP))) goto yyL2;
  }
  }
   return NoTree;
yyL2:;

/* line 634 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  tDefinitions yyV2;
  tDefinitions yyV3;
  tDefinitions yyV4;
  tTree param;
  tTree params;
  tIdent cname;
  {
/* line 636 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 638 "CodeMapping.puma" */
   GetObjDistributionData (yyV1, & yyV2, & yyV3, & yyV4);
/* line 640 "CodeMapping.puma" */
   if (! ((yyV1 != yyV2))) goto yyL3;
  {
/* line 646 "CodeMapping.puma" */
   params = MakeTargetParams (yyV3);
/* line 647 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeUsedVarA (yyV2->Object.Ident, DSP_SUFFIX));
/* line 648 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 650 "CodeMapping.puma" */
   cname = MakeDalibId ("align_target");
/* line 652 "CodeMapping.puma" */
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX)), params);
  }
  }
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
 }
yyL3:;

/* line 658 "CodeMapping.puma" */
  {
/* line 659 "CodeMapping.puma" */
   failure_protocol (MODULE, "DalibAlignTarget", NoTree);
  }
   return NoTree;

}

static tTree MakeSourceParams
# if defined __STDC__ | defined __cplusplus
(register tDefinitions ilist)
# else
(ilist)
 register tDefinitions ilist;
# endif
{
  if (ilist->Kind == kDIM_EMPTY) {
/* line 665 "CodeMapping.puma" */
   return mBTP_EMPTY ();

  }
  if (ilist->Kind == kDIM_LIST) {
  if (ilist->DIM_LIST.Elem->Kind == kAlignedDimension) {
/* line 669 "CodeMapping.puma" */
   return mBTP_LIST (ExpToVarParam (MakeConstant (kALIGNED_DIM)), mBTP_LIST (ExpToVarParam (MakeConstant (ilist->DIM_LIST.Elem->AlignedDimension.template_dim)), mBTP_LIST (ExpToVarParam (ilist->DIM_LIST.Elem->AlignedDimension.add), mBTP_LIST (ExpToVarParam (ilist->DIM_LIST.Elem->AlignedDimension.mult), MakeSourceParams (ilist->DIM_LIST.Next)))));

  }
  if (ilist->DIM_LIST.Elem->Kind == kSerialDimension) {
/* line 679 "CodeMapping.puma" */
   return mBTP_LIST (ExpToVarParam (MakeConstant (kSERIAL_DIM)), mBTP_LIST (ExpToVarParam (MakeConstant (ilist->DIM_LIST.Elem->SerialDimension.dimension)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (1)), MakeSourceParams (ilist->DIM_LIST.Next)))));

  }
  }
 yyAbort ("MakeSourceParams");
 { tTree yyDummy; return yyDummy; }
}

static tTree MakeTargetParams
# if defined __STDC__ | defined __cplusplus
(register tDefinitions plist)
# else
(plist)
 register tDefinitions plist;
# endif
{
  if (plist->Kind == kDIM_EMPTY) {
/* line 689 "CodeMapping.puma" */
   return mBTP_EMPTY ();

  }
  if (plist->Kind == kDIM_LIST) {
  if (plist->DIM_LIST.Elem->Kind == kAlignedDimension) {
/* line 693 "CodeMapping.puma" */
   return mBTP_LIST (ExpToVarParam (MakeConstant (kSOURCE_DIM)), mBTP_LIST (ExpToVarParam (MakeConstant (plist->DIM_LIST.Elem->AlignedDimension.dimension)), MakeTargetParams (plist->DIM_LIST.Next)));

  }
  if (plist->DIM_LIST.Elem->Kind == kReplicatedDimension) {
/* line 700 "CodeMapping.puma" */
   return mBTP_LIST (ExpToVarParam (MakeConstant (kREPLICATED_DIM)), mBTP_LIST (ExpToVarParam (MakeConstant (plist->DIM_LIST.Elem->ReplicatedDimension.dimension)), MakeTargetParams (plist->DIM_LIST.Next)));

  }
  if (plist->DIM_LIST.Elem->Kind == kEmbeddedDimension) {
/* line 707 "CodeMapping.puma" */
   return mBTP_LIST (ExpToVarParam (MakeConstant (kEMBEDDED_DIM)), mBTP_LIST (ExpToVarParam (CopyTree (plist->DIM_LIST.Elem->EmbeddedDimension.val)), MakeTargetParams (plist->DIM_LIST.Next)));

  }
  }
/* line 714 "CodeMapping.puma" */
  {
/* line 716 "CodeMapping.puma" */
   failure_protocol (MODULE, "MakeTargetParams (unknown dim)", NoTree);
  }
   return NoTree;

}

tTree DalibArrayTrace
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 728 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  tTree param;
  tTree params;
  tTree call;
  tIdent cname;
  {
/* line 730 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 732 "CodeMapping.puma" */
   if (! ((IsVarTraced (yyV1)))) goto yyL1;
  {
/* line 739 "CodeMapping.puma" */
   params = mBTP_EMPTY ();
/* line 741 "CodeMapping.puma" */
   cname = MakeDalibId ("array_trace");
/* line 743 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 744 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 746 "CodeMapping.puma" */
   call = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
  }
   return call;
 }
yyL1:;

/* line 750 "CodeMapping.puma" */
   return NoTree;

}

static tTree MakeDspAssign
# if defined __STDC__ | defined __cplusplus
(register tTree var, String lhs_suffix, String rhs_suffix)
# else
(var, lhs_suffix, rhs_suffix)
 register tTree var;
 String lhs_suffix;
 String rhs_suffix;
# endif
{
/* line 764 "CodeMapping.puma" */
 {
  tTree lhs;
  tTree rhs;
  {
/* line 769 "CodeMapping.puma" */
   lhs = MakeVarSuffixA (var, lhs_suffix);
/* line 770 "CodeMapping.puma" */
   rhs = mVAR_EXP (MakeVarSuffixA (var, rhs_suffix));
  }
   return mACF_BASIC (mASSIGN_STMT (lhs, rhs));
 }

}

tTree DalibCopyDsp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 783 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  {
/* line 785 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 786 "CodeMapping.puma" */
   if (! ((IsVarDummy (yyV1)))) goto yyL1;
  }
   return MakeDspAssign (var, DSP_SUFFIX, DUMMY_SUFFIX);
 }
yyL1:;

/* line 791 "CodeMapping.puma" */
   return NoTree;

}

tTree DalibSaveCommonDsp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 807 "CodeMapping.puma" */
  {
/* line 809 "CodeMapping.puma" */
   if (! ((kind == kATTACH_DSP))) goto yyL1;
  }
   return MakeDspAssign (var, COMMON_SUFFIX, DSP_SUFFIX);
yyL1:;

/* line 814 "CodeMapping.puma" */
   return NoTree;

}

tTree DalibCopyIn
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 828 "CodeMapping.puma" */

tTree param, paramlist;

  if (var->Kind == kSELECTED_VAR) {
/* line 832 "CodeMapping.puma" */
   return NoTree;

  }
/* line 837 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  tTree lhs;
  tTree rhs;
  int yyV2;
  int yyV3;
  {
/* line 839 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 841 "CodeMapping.puma" */
   if (! ((IsVarDummy (yyV1)))) goto yyL2;
  {
/* line 843 "CodeMapping.puma" */
   if (! ((NoCopyInCopyOut (yyV1, kind)))) goto yyL2;
  {
/* line 848 "CodeMapping.puma" */
   GetCopyInfo (yyV1, & yyV2, & yyV3);
/* line 850 "CodeMapping.puma" */
 if (IsVarDummy (yyV1))
         rhs =  mVAR_EXP (MakeVarSuffixA (var, DUMMY_SUFFIX));
       else
         rhs =  mVAR_EXP (MakeVarSuffixA (var, COMMON_SUFFIX));

      lhs = MakeVarSuffixA (var, DSP_SUFFIX);
    
  }
  }
  }
   return mACF_BASIC (mASSIGN_STMT (lhs, rhs));
 }
yyL2:;

/* line 861 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  {
/* line 863 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 865 "CodeMapping.puma" */
   if (! ((IsVarLocal (yyV1)))) goto yyL3;
  {
/* line 866 "CodeMapping.puma" */
   if (! ((kind == kFIXED_DSP))) goto yyL3;
  }
  }
   return NoTree;
 }
yyL3:;

/* line 871 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  int yyV2;
  int yyV3;
  rbool is_char;
  {
/* line 873 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 875 "CodeMapping.puma" */
   if (! ((IsVarDummy (yyV1)))) goto yyL4;
  {
/* line 877 "CodeMapping.puma" */
   GetCopyInfo (yyV1, & yyV2, & yyV3);
/* line 881 "CodeMapping.puma" */
   is_char = IsStringType (GetBaseType (GetObjectType (yyV1)));
/* line 883 "CodeMapping.puma" */
   paramlist = mBTP_EMPTY ();
/* line 884 "CodeMapping.puma" */
   param = ExpToVarParam (MakeConstant (yyV2));
/* line 885 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 886 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, ""));
/* line 887 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 888 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DUMMY_SUFFIX));
/* line 889 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 890 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 891 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
  }
  }
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (MakeDalibCId ("copy_in", is_char)), paramlist));
 }
yyL4:;

/* line 898 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  {
/* line 900 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 902 "CodeMapping.puma" */
   if (! ((IsVarCommon (yyV1)))) goto yyL5;
  {
/* line 903 "CodeMapping.puma" */
   if (! ((kind == kATTACH_DSP))) goto yyL5;
  {
/* line 905 "CodeMapping.puma" */
   paramlist = mBTP_EMPTY ();
/* line 911 "CodeMapping.puma" */
   param = MakeIdStringParam (GetCommonBlockId (yyV1));
/* line 912 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 913 "CodeMapping.puma" */
   param = ExpToVarParam (MakeConstant (safety));
/* line 914 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 915 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, COMMON_SUFFIX));
/* line 916 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 917 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 918 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
  }
  }
  }
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (MakeDalibId ("attach_in")), paramlist));
 }
yyL5:;

/* line 926 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  tTree lhs;
  tTree rhs;
  {
/* line 928 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 930 "CodeMapping.puma" */
   if (! ((IsVarCommon (yyV1)))) goto yyL6;
  {
/* line 931 "CodeMapping.puma" */
   if (! ((kind != kNO_DSP))) goto yyL6;
  {
/* line 936 "CodeMapping.puma" */
   lhs = MakeVarSuffixA (var, COMMON_SUFFIX);
/* line 937 "CodeMapping.puma" */
   rhs = mVAR_EXP (MakeVarSuffixA (var, DSP_SUFFIX));
  }
  }
  }
   return mACF_BASIC (mASSIGN_STMT (lhs, rhs));
 }
yyL6:;

/* line 942 "CodeMapping.puma" */
   return NoTree;

}

tTree DalibCopyOut
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 949 "CodeMapping.puma" */

tTree param, paramlist;

  if (var->Kind == kSELECTED_VAR) {
/* line 953 "CodeMapping.puma" */
   return NoTree;

  }
/* line 958 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  {
/* line 960 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 962 "CodeMapping.puma" */
   if (! ((NoCopyInCopyOut (yyV1, kind)))) goto yyL2;
  }
   return NoTree;
 }
yyL2:;

/* line 967 "CodeMapping.puma" */
  {
/* line 968 "CodeMapping.puma" */
   if (! ((kind == kFIXED_DSP))) goto yyL3;
  }
   return NoTree;
yyL3:;

/* line 972 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  int yyV2;
  int yyV3;
  {
/* line 974 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 976 "CodeMapping.puma" */
   if (! ((IsVarDummy (yyV1)))) goto yyL4;
  {
/* line 978 "CodeMapping.puma" */
   GetCopyInfo (yyV1, & yyV2, & yyV3);
/* line 980 "CodeMapping.puma" */
   paramlist = mBTP_EMPTY ();
/* line 981 "CodeMapping.puma" */
   param = ExpToVarParam (MakeConstant (yyV3));
/* line 982 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 983 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DUMMY_SUFFIX));
/* line 984 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 985 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 986 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
  }
  }
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (MakeDalibId ("copy_out")), paramlist));
 }
yyL4:;

/* line 992 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  {
/* line 994 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 996 "CodeMapping.puma" */
   if (! ((IsVarCommon (yyV1)))) goto yyL5;
  {
/* line 997 "CodeMapping.puma" */
   if (! ((kind == kATTACH_DSP))) goto yyL5;
  }
  }
   return NoTree;
 }
yyL5:;

/* line 1002 "CodeMapping.puma" */
   return NoTree;

}

tTree DalibArrayRedistribute
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 1015 "CodeMapping.puma" */
 {
  tTree param;
  tTree paramlist;
  tIdent cname;
  {
/* line 1021 "CodeMapping.puma" */
   paramlist = mBTP_EMPTY ();
/* line 1022 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, ""));
/* line 1023 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 1024 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DYNAMIC_SUFFIX));
/* line 1025 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 1026 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 1027 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 1029 "CodeMapping.puma" */
   cname = MakeDalibId ("redistribute");
  }
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), paramlist));
 }

}

tTree DalibArrayAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 1042 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  {
/* line 1044 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 1046 "CodeMapping.puma" */
   if (! ((IsTreeObject (yyV1)))) goto yyL1;
  }
   return TriDenTAllocate (var, kind);
 }
yyL1:;

/* line 1051 "CodeMapping.puma" */
 {
  tDefinitions yyV1;
  {
/* line 1053 "CodeMapping.puma" */
   if (! ((kind == kATTACH_DSP))) goto yyL2;
  {
/* line 1055 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 1057 "CodeMapping.puma" */
   if (! ((IsStaticObj (yyV1)))) goto yyL2;
  }
  }
   return NoTree;
 }
yyL2:;

/* line 1062 "CodeMapping.puma" */
 {
  tTree paramlist;
  tTree param;
  tTree call;
  int rank;
  int i;
  tDefinitions yyV1;
  rbool is_char;
  {
/* line 1070 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 1072 "CodeMapping.puma" */
   rank = VarRank (yyV1);
/* line 1074 "CodeMapping.puma" */
 if (IsRaggedVarObject (yyV1)) rank = 1; 
/* line 1076 "CodeMapping.puma" */
   paramlist = mBTP_EMPTY ();
/* line 1078 "CodeMapping.puma" */
 if (kind != kFIXED_DSP)

       { for (i=rank; i>=1; i--)
            { param = mVAR_PARAM (MakeVarSuffixAn (var, "_DIM", i));
              paramlist = mBTP_LIST (param, paramlist);
            }
         param     = mVAR_PARAM (MakeVarSuffixA (var, "_ZERO"));
         paramlist = mBTP_LIST (param, paramlist);
       }
    
/* line 1089 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, ""));
/* line 1090 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 1091 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 1092 "CodeMapping.puma" */
   paramlist = mBTP_LIST (param, paramlist);
/* line 1096 "CodeMapping.puma" */
 is_char = IsStringType (GetBaseType (GetObjectType (yyV1)));

      if (kind == kALLOCATE_DSP)
         call = mPROC_OBJ (MakeDalibCId ("array_allocate", is_char));
       else if (kind == kATTACH_DSP)
         call = mPROC_OBJ (MakeDalibCId ("array_access", is_char));
       else if (kind == kDUMMY_DSP)
         call = mPROC_OBJ (MakeDalibCId ("array_access", is_char));
       else if (kind == kASSUMED_DSP)
         call = mPROC_OBJ (MakeDalibCId ("array_access", is_char));
       else if (kind == kLOCAL_DSP)
         call = mPROC_OBJ (MakeDalibCId ("array_access", is_char));
       else if (kind == kFIXED_DSP)
         call = mPROC_OBJ (MakeDalibCId ("array_setdata", is_char));
       else if (kind == kTEMPLATE_DSP)
         { call = mPROC_OBJ (MakeDalibCId ("array_access", is_char));
           error_protocol ("cannot access/allocate templates");
         }
       else
        { call = mPROC_OBJ (MakeDalibCId ("dummy", is_char));
          error_protocol ("access/allocate: illegal kind");
        }

    
/* line 1121 "CodeMapping.puma" */
   call = mACF_BASIC (mCALL_STMT (call, paramlist));
  }
   return call;
 }

}

tTree DalibTopCreate
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 1136 "CodeMapping.puma" */
 {
  tTree param;
  tTree paramlist;
  tTree call;
  tDefinitions yyV1;
  tIdent yyV2;
  tTree yyV3;
  {
/* line 1142 "CodeMapping.puma" */
   GetVarObject (var, & yyV1);
/* line 1143 "CodeMapping.puma" */
   GetTopologyInfo (yyV1, & yyV2, & yyV3);
/* line 1145 "CodeMapping.puma" */
 paramlist = mBTP_EMPTY ();

    if (yyV3 == NoTree)
       param = ExpToVarParam (MakeConstant (1));
     else
       param = ExpToVarParam (yyV3);
    paramlist = mBTP_LIST (param, paramlist);

    param = mVAR_PARAM (MakeUsedVarA (yyV2, "_DSP"));
    paramlist = mBTP_LIST (param, paramlist);

    param = mVAR_PARAM (MakeUsedVarA (yyV2, "_TOPID"));
    paramlist = mBTP_LIST (param, paramlist);

    call = mPROC_OBJ (MakeDalibId ("top_create"));
    call = mACF_BASIC (mCALL_STMT (call, paramlist));
    call = mACF_LIST (call, NoTree);
  
  }
   return call;
 }

}

tTree MakeSubProcStmt
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 1182 "CodeMapping.puma" */
  {
/* line 1184 "CodeMapping.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  }
   return NoTree;
yyL1:;

  if (obj->Kind == kTopologyObject) {
/* line 1188 "CodeMapping.puma" */
  {
/* line 1190 "CodeMapping.puma" */
   if (! ((obj->TopologyObject.Ident == DefaultId ()))) goto yyL2;
  }
   return NoTree;
yyL2:;

  if (obj->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
/* line 1194 "CodeMapping.puma" */
   return NoTree;

  }
  if (obj->TopologyObject.decl->Kind == kSUB_PROCS_DECL) {
/* line 1199 "CodeMapping.puma" */
 {
  tTree call;
  tTree params;
  tTree param;
  {
/* line 1203 "CodeMapping.puma" */
   if (! ((! obj->TopologyObject.defined))) goto yyL4;
  {
/* line 1209 "CodeMapping.puma" */
   params = MakeSectionParams (obj->TopologyObject.decl->SUB_PROCS_DECL.DIMENSIONS);
/* line 1210 "CodeMapping.puma" */
   param = mVAR_PARAM (MakeUsedVarA (obj->TopologyObject.decl->SUB_PROCS_DECL.TOP->TOP_OBJ.Ident, "_DSP"));
/* line 1211 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 1212 "CodeMapping.puma" */
   param = MakeUsedVarA (obj->TopologyObject.decl->SUB_PROCS_DECL.Ident, "_TOPID");
/* line 1213 "CodeMapping.puma" */
   DefineNewIntVar (TreeVarName (param));
/* line 1214 "CodeMapping.puma" */
   param = mVAR_PARAM (param);
/* line 1215 "CodeMapping.puma" */
   params = mBTP_LIST (param, params);
/* line 1216 "CodeMapping.puma" */
   call = mPROC_OBJ (MakeDalibId ("subtop_create"));
/* line 1217 "CodeMapping.puma" */
   call = mACF_BASIC (mCALL_STMT (call, params));
/* line 1219 "CodeMapping.puma" */
   obj->TopologyObject.defined = 1;
  }
  }
   return mACF_LIST (call, NoTree);
 }
yyL4:;

  }
  }
/* line 1224 "CodeMapping.puma" */
   return NoTree;

}

tTree DistributionDecls
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 1239 "CodeMapping.puma" */
  {
/* line 1241 "CodeMapping.puma" */
   if (! ((GetDspKind (obj) == kNO_DSP))) goto yyL1;
  }
   return NoTree;
yyL1:;

/* line 1246 "CodeMapping.puma" */
   return MakeDescriptorDecls (obj);

}

static tTree MakeDescriptorDecls
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 1259 "CodeMapping.puma" */
 {
  tTree descriptor;
  tTree vtype;
  {
/* line 1264 "CodeMapping.puma" */
   vtype = MakeIntegerType (default_addr_size);
/* line 1266 "CodeMapping.puma" */
   descriptor = mDECL_LIST (MakeVarDeclA (obj->Object.Ident, DSP_SUFFIX, vtype), NoTree);
/* line 1269 "CodeMapping.puma" */
 if (IsVarCommon (obj))
       descriptor = mDECL_LIST (MakeVarDeclA (obj->Object.Ident, COMMON_SUFFIX, vtype), 
                                descriptor);
   
/* line 1274 "CodeMapping.puma" */
 if (IsHPFDynamic (obj))
       descriptor = mDECL_LIST (MakeVarDeclA (obj->Object.Ident, DYNAMIC_SUFFIX, vtype), 
                                descriptor);
   
  }
   return descriptor;
 }

}

static rbool NoCopyInCopyOut
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int kind)
# else
(obj, kind)
 register tDefinitions obj;
 register int kind;
# endif
{
/* line 1290 "CodeMapping.puma" */
  {
/* line 1292 "CodeMapping.puma" */
   if (! ((GetCurrentModel () == HPF_LOCAL))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 1295 "CodeMapping.puma" */
  {
/* line 1297 "CodeMapping.puma" */
   if (! ((safety == 0))) goto yyL2;
  {
/* line 1298 "CodeMapping.puma" */
   if (! ((kind == kDUMMY_DSP))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

/* line 1301 "CodeMapping.puma" */
  {
/* line 1303 "CodeMapping.puma" */
   if (! ((safety == 0))) goto yyL3;
  {
/* line 1304 "CodeMapping.puma" */
   if (! ((kind == kASSUMED_DSP))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapInherited) {
/* line 1307 "CodeMapping.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static void GetVarObject
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions * yyP1)
# else
(var, yyP1)
 register tTree var;
 register tDefinitions * yyP1;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 1327 "CodeMapping.puma" */
   * yyP1 = var->USED_VAR.VARNAME->VAR_OBJ.Object;
   return;

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 1330 "CodeMapping.puma" */
   * yyP1 = var->SELECTED_VAR.SELECTOR->REC_COMP.Object;
   return;

  }
/* line 1333 "CodeMapping.puma" */
  {
/* line 1335 "CodeMapping.puma" */
   failure_protocol (MODULE, "GetVarObject", var);
  }
   * yyP1 = NoObject;
   return;

;
}

static void GetSizeOfObject
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions obj, register tTree * yyP2)
# else
(var, obj, yyP2)
 register tTree var;
 register tDefinitions obj;
 register tTree * yyP2;
# endif
{
/* line 1346 "CodeMapping.puma" */
  {
/* line 1348 "CodeMapping.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 1349 "CodeMapping.puma" */
   failure_protocol (MODULE, "GetSizeOfObject", NoTree);
  }
  }
   * yyP2 = NoTree;
   return;
yyL1:;

  if (obj->Kind == kTemplateObject) {
/* line 1352 "CodeMapping.puma" */
   * yyP2 = MakeConstant (0);
   return;

  }
  if (obj->Kind == kTopologyObject) {
/* line 1355 "CodeMapping.puma" */
   * yyP2 = MakeConstant (0);
   return;

  }
  if (obj->Kind == kVarObject) {
/* line 1358 "CodeMapping.puma" */
 {
  tTree base_type;
  {
/* line 1362 "CodeMapping.puma" */
   base_type = GetBaseType (GetObjectType (obj));
/* line 1364 "CodeMapping.puma" */
   if (! ((IsDerivedType (base_type)))) goto yyL4;
  }
   * yyP2 = mSIZE_EXP (CopyTree (var), TargetTypeSize (base_type));
   return;
 }
yyL4:;

/* line 1367 "CodeMapping.puma" */
 {
  int size;
  {
/* line 1371 "CodeMapping.puma" */
   size = TreeSize (GetBaseType (GetObjectType (obj)));
/* line 1373 "CodeMapping.puma" */
 if (size <= 0)
       { error_protocol ("could not fixe size of variable");
         tree_protocol ("Type = ", GetBaseType (GetObjectType (obj)));
       }
   
  }
   * yyP2 = MakeConstant (size);
   return;
 }

  }
/* line 1380 "CodeMapping.puma" */
  {
/* line 1382 "CodeMapping.puma" */
   failure_protocol (MODULE, "GetSizeOfObject", obj->Object.decl);
  }
   * yyP2 = NoTree;
   return;

;
}

static void GetTopologyInfo
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tIdent * yyP4, register tTree * yyP3)
# else
(obj, yyP4, yyP3)
 register tDefinitions obj;
 register tIdent * yyP4;
 register tTree * yyP3;
# endif
{
  if (obj->Kind == kTopologyObject) {
/* line 1393 "CodeMapping.puma" */
   * yyP4 = obj->TopologyObject.Ident;
   * yyP3 = obj->TopologyObject.target;
   return;

  }
/* line 1396 "CodeMapping.puma" */
  {
/* line 1398 "CodeMapping.puma" */
   failure_protocol (MODULE, "GetTopologyInfo", obj->Object.decl);
  }
   * yyP4 = DefaultId ();
   * yyP3 = NoTree;
   return;

;
}

static void GetObjSharedInfo
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int * yyP5)
# else
(obj, yyP5)
 register tDefinitions obj;
 register int * yyP5;
# endif
{
/* line 1408 "CodeMapping.puma" */
  {
/* line 1410 "CodeMapping.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 1411 "CodeMapping.puma" */
   failure_protocol (MODULE, "GetObjSharedInfo", NoTree);
  }
  }
   * yyP5 = 0;
   return;
yyL1:;

  if (obj->Kind == kTemplateObject) {
/* line 1414 "CodeMapping.puma" */
   * yyP5 = obj->TemplateObject.Dist->Mapping.shared;
   return;

  }
  if (obj->Kind == kVarObject) {
/* line 1417 "CodeMapping.puma" */
   * yyP5 = obj->VarObject.Dist->Mapping.shared;
   return;

  }
/* line 1422 "CodeMapping.puma" */
  {
/* line 1424 "CodeMapping.puma" */
   failure_protocol (MODULE, "GetObjSharedInfo", obj->Object.decl);
  }
   * yyP5 = 0;
   return;

;
}

static void GetObjDistributionData
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions * yyP8, register tDefinitions * yyP7, register tDefinitions * yyP6)
# else
(obj, yyP8, yyP7, yyP6)
 register tDefinitions obj;
 register tDefinitions * yyP8;
 register tDefinitions * yyP7;
 register tDefinitions * yyP6;
# endif
{
  if (obj->Kind == kTemplateObject) {
  if (obj->TemplateObject.Dist->Mapping.spec->Kind == kMapDist) {
/* line 1436 "CodeMapping.puma" */
   * yyP8 = obj;
   * yyP7 = obj->TemplateObject.Dist->Mapping.spec->MapDist.Distribution->Distribution.ArrayList;
   * yyP6 = obj->TemplateObject.Dist->Mapping.spec->MapDist.Distribution->Distribution.ArrayList;
   return;

  }
  }
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapDist) {
/* line 1441 "CodeMapping.puma" */
   * yyP8 = obj;
   * yyP7 = obj->VarObject.Dist->Mapping.spec->MapDist.Distribution->Distribution.ArrayList;
   * yyP6 = obj->VarObject.Dist->Mapping.spec->MapDist.Distribution->Distribution.ArrayList;
   return;

  }
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapAlign) {
/* line 1446 "CodeMapping.puma" */
   * yyP8 = obj->VarObject.Dist->Mapping.spec->MapAlign.Alignment->Alignment.template_obj;
   * yyP7 = obj->VarObject.Dist->Mapping.spec->MapAlign.Alignment->Alignment.TargetList;
   * yyP6 = obj->VarObject.Dist->Mapping.spec->MapAlign.Alignment->Alignment.SourceList;
   return;

  }
  }
/* line 1452 "CodeMapping.puma" */
  {
/* line 1454 "CodeMapping.puma" */
   obj_error_protocol ("no distribution for this object", obj);
/* line 1455 "CodeMapping.puma" */
   failure_protocol (MODULE, "GetObjDistributionData", obj->Object.decl);
  }
   * yyP8 = NoObject;
   * yyP7 = NoObject;
   * yyP6 = NoObject;
   return;

;
}

static void GetCopyInfo
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int * yyP10, register int * yyP9)
# else
(obj, yyP10, yyP9)
 register tDefinitions obj;
 register int * yyP10;
 register int * yyP9;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 1466 "CodeMapping.puma" */
  {
/* line 1468 "CodeMapping.puma" */
   if (! ((obj->VarObject.Kind->VarDummy.Intent == IntentIn))) goto yyL1;
  }
   * yyP10 = 1;
   * yyP9 = 0;
   return;
yyL1:;

/* line 1471 "CodeMapping.puma" */
  {
/* line 1473 "CodeMapping.puma" */
   if (! ((obj->VarObject.Kind->VarDummy.Intent == IntentOut))) goto yyL2;
  }
   * yyP10 = 0;
   * yyP9 = 1;
   return;
yyL2:;

  }
/* line 1476 "CodeMapping.puma" */
   * yyP10 = 1;
   * yyP9 = 1;
   return;

  }
;
}

static tTree MakeIdStringParam
# if defined __STDC__ | defined __cplusplus
(register tIdent id)
# else
(id)
 register tIdent id;
# endif
{
/* line 1487 "CodeMapping.puma" */

char id_string [MAX_ID_LENGTH];
int  id_length;

/* line 1492 "CodeMapping.puma" */
 {
  tStringRef ref;
  {
/* line 1496 "CodeMapping.puma" */
   GetString (id, id_string);
/* line 1498 "CodeMapping.puma" */
   ref = PutString (id_string, strlen (id_string));
  }
   return ExpToVarParam (mCONST_EXP (mSTRING_CONSTANT (ref)));
 }

}

void BeginCodeMapping ARGS ((void))
{
}

void CloseCodeMapping ARGS ((void))
{
}
