# include "CodeGlobal.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 23 "CodeGlobal.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Types.h"
# include "TreeOps.h"
# include "Rank.h"
# include "Transform.h"        /* CombineACF, ReplaceACF  */
# include "Dalib.h"            /* MakeUsedVarA, ... */
# include "CodeDescriptors.h"  /* DalibHostUpdate, ... */
# include "Shapes.h"           /* MakeFullShape, ... */
# include "Expressions.h"      /* MakeConstant */
# include "Reductions.h"       /* GlobalReductionStmt  */
# include "Distributions.h"
# include "VarDescriptor.h"
# include "ExpDescriptor.h"
# include "CodeOn.h"           /* ApplyOnSpecs         */
# include "CodeGeneral.h"      /* MakeTopologyParam      */

# define MODULE "CodeGlobal"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCodeGlobal.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* CodeGlobal_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeGlobal, routine %s failed\n",
  yyFunction);
 CodeGlobal_Exit ();
}

tTree CodeReduction ARGS ((tTree stmt));
static rbool IsFullGlobalReduction ARGS ((tTree on_top, tTree on_specs));
static void SplitOnSpecifications ARGS ((tTree on_list, tTree * yyP2, tTree * yyP1));
static tTree FullDimReductions ARGS ((tTree f, tTree p, tTree top, tTree spec));
static tTree MakeTopDimReduction ARGS ((tTree topology, int dim, tTree f, tTree vars));
static tTree MakeArrayDimReduction ARGS ((tDefinitions array_obj, int dim, tTree f, tTree vars));
static tTree MakeFullGlobalReduction ARGS ((tTree f, tTree red_vars));
static tTree GlobalLocExchange ARGS ((tTree params));
tTree CodeBroadcast ARGS ((tTree stmt));
static tTree MakeHostBroadcasts ARGS ((tTree var));
static tTree MakeNodeBroadcasts ARGS ((tTree var, tTree top, tTree specs));
static tTree MakeNodeDimBroadcasts ARGS ((tTree var, tTree top, tTree specs));
static rbool IsVarSelection ARGS ((tTree var, tTree on_val));
static tTree Overlapping ARGS ((tTree t));
static tTree TakeWholeVar ARGS ((tTree v));
static tTree MakeReductionStmt ARGS ((tTree top, int dim, tTree var, tTree f));
static tTree MakeArrayReductionStmt ARGS ((tDefinitions obj, int dim, tTree var, tTree f));
static tTree MakeLocReductionStmt ARGS ((tTree var, tTree f));
static void MyDalibSectionTranslation ARGS ((tTree var, tTree * yyP5, tTree * yyP4, tTree * yyP3));
static tTree MakeLocOpParam ARGS ((tTree var, tIdent funcname));
static tTree MakeOpParam ARGS ((tTree var, tIdent funcname));

tTree CodeReduction
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kREDUCTION_STMT) {
/* line 71 "CodeGlobal.puma" */
  {
/* line 73 "CodeGlobal.puma" */
   if (! ((IsFullGlobalReduction (stmt->REDUCTION_STMT.RED_TOP, stmt->REDUCTION_STMT.RED_SPEC)))) goto yyL1;
  {
/* line 75 "CodeGlobal.puma" */
   stmt_protocol ("global reduction along all processors");
  }
  }
   return MakeFullGlobalReduction (stmt->REDUCTION_STMT.REDFUNC, stmt->REDUCTION_STMT.ELEMS);
yyL1:;

  if (stmt->REDUCTION_STMT.RED_TOP->Kind == kON_VAR) {
/* line 80 "CodeGlobal.puma" */
 {
  tTree red_stmts;
  {
/* line 84 "CodeGlobal.puma" */
   stmt_protocol ("global reduction along processors array dimensions");
/* line 86 "CodeGlobal.puma" */
   red_stmts = FullDimReductions (stmt->REDUCTION_STMT.REDFUNC, stmt->REDUCTION_STMT.ELEMS, stmt->REDUCTION_STMT.RED_TOP, stmt->REDUCTION_STMT.RED_SPEC);
/* line 88 "CodeGlobal.puma" */
   tree_protocol ("generated code :\n", red_stmts);
  }
   return red_stmts;
 }

  }
  }
/* line 93 "CodeGlobal.puma" */
  {
/* line 95 "CodeGlobal.puma" */
   failure_protocol (MODULE, "CodeReduction", stmt);
  }
   return NoTree;

}

static rbool IsFullGlobalReduction
# if defined __STDC__ | defined __cplusplus
(register tTree on_top, register tTree on_specs)
# else
(on_top, on_specs)
 register tTree on_top;
 register tTree on_specs;
# endif
{
  if (on_top->Kind == kON_ALL) {
/* line 108 "CodeGlobal.puma" */
   return rtrue;

  }
  if (on_top->Kind == kON_VAR) {
/* line 111 "CodeGlobal.puma" */
  {
/* line 113 "CodeGlobal.puma" */
   if (! ((IsFullTopologyObj (on_top->ON_VAR.topid)))) goto yyL2;
  {
/* line 114 "CodeGlobal.puma" */
   if (! ((TreeListLength (on_specs) == VarRank (on_top->ON_VAR.topid)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

static void SplitOnSpecifications
# if defined __STDC__ | defined __cplusplus
(register tTree on_list, register tTree * yyP2, register tTree * yyP1)
# else
(on_list, yyP2, yyP1)
 register tTree on_list;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (on_list->Kind == kON_EMPTY) {
/* line 125 "CodeGlobal.puma" */
   * yyP2 = on_list;
   * yyP1 = on_list;
   return;

  }
  if (on_list->Kind == kON_LIST) {
  if (on_list->ON_LIST.Elem->ON_SPEC.ON_VAL->Kind == kSLICE_EXP) {
/* line 137 "CodeGlobal.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 139 "CodeGlobal.puma" */
   SplitOnSpecifications (on_list->ON_LIST.Next, & yyV1, & yyV2);
/* line 140 "CodeGlobal.puma" */
 on_list->ON_LIST.Next = yyV2; 
  }
   * yyP2 = yyV1;
   * yyP1 = on_list;
   return;
 }

  }
/* line 143 "CodeGlobal.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 145 "CodeGlobal.puma" */
   SplitOnSpecifications (on_list->ON_LIST.Next, & yyV1, & yyV2);
/* line 146 "CodeGlobal.puma" */
 on_list->ON_LIST.Next = yyV1; 
  }
   * yyP2 = on_list;
   * yyP1 = yyV2;
   return;
 }

  }
;
}

static tTree FullDimReductions
# if defined __STDC__ | defined __cplusplus
(register tTree f, register tTree p, register tTree top, register tTree spec)
# else
(f, p, top, spec)
 register tTree f;
 register tTree p;
 register tTree top;
 register tTree spec;
# endif
{
  if (spec->Kind == kON_LIST) {
/* line 157 "CodeGlobal.puma" */
   return CombineACF (FullDimReductions (f, p, top, spec->ON_LIST.Elem), FullDimReductions (f, p, top, spec->ON_LIST.Next));

  }
  if (spec->Kind == kON_EMPTY) {
/* line 163 "CodeGlobal.puma" */
   return NoTree;

  }
  if (top->Kind == kON_VAR) {
  if (spec->Kind == kON_SPEC) {
/* line 170 "CodeGlobal.puma" */
  {
/* line 172 "CodeGlobal.puma" */
   if (! ((top->ON_VAR.topid == NoObject))) goto yyL3;
  }
   return MakeArrayDimReduction (top->ON_VAR.tempid, spec->ON_SPEC.temp_dim, f, p);
yyL3:;

/* line 177 "CodeGlobal.puma" */
   return MakeTopDimReduction (MakeTopologyParam (top->ON_VAR.topid), spec->ON_SPEC.top_dim, f, p);

  }
  }
/* line 182 "CodeGlobal.puma" */
  {
/* line 184 "CodeGlobal.puma" */
   failure_protocol (MODULE, "FullDimReductions", spec);
  }
   return NoTree;

}

static tTree MakeTopDimReduction
# if defined __STDC__ | defined __cplusplus
(register tTree topology, register int dim, register tTree f, register tTree vars)
# else
(topology, dim, f, vars)
 register tTree topology;
 register int dim;
 register tTree f;
 register tTree vars;
# endif
{
  if (vars->Kind == kBTV_LIST) {
  if (vars->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 198 "CodeGlobal.puma" */
   return MakeReductionStmt (topology, dim, vars->BTV_LIST.Elem, f);

  }
/* line 203 "CodeGlobal.puma" */
   return MakeLocReductionStmt (f, vars->BTV_LIST.Elem);

  }
/* line 208 "CodeGlobal.puma" */
   return MakeFullGlobalReduction (f, vars);

}

static tTree MakeArrayDimReduction
# if defined __STDC__ | defined __cplusplus
(register tDefinitions array_obj, register int dim, register tTree f, register tTree vars)
# else
(array_obj, dim, f, vars)
 register tDefinitions array_obj;
 register int dim;
 register tTree f;
 register tTree vars;
# endif
{
  if (vars->Kind == kBTV_LIST) {
  if (vars->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 222 "CodeGlobal.puma" */
   return MakeArrayReductionStmt (array_obj, dim, vars->BTV_LIST.Elem, f);

  }
  }
 yyAbort ("MakeArrayDimReduction");
 { tTree yyDummy; return yyDummy; }
}

static tTree MakeFullGlobalReduction
# if defined __STDC__ | defined __cplusplus
(register tTree f, register tTree red_vars)
# else
(f, red_vars)
 register tTree f;
 register tTree red_vars;
# endif
{
  if (red_vars->Kind == kBTV_LIST) {
  if (red_vars->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 237 "CodeGlobal.puma" */
   return MakeReductionStmt (NoTree, 1, red_vars->BTV_LIST.Elem, f);

  }
/* line 242 "CodeGlobal.puma" */
   return CombineACF (MakeLocReductionStmt (red_vars->BTV_LIST.Elem, f), GlobalLocExchange (red_vars->BTV_LIST.Next));

  }
 yyAbort ("MakeFullGlobalReduction");
 { tTree yyDummy; return yyDummy; }
}

static tTree GlobalLocExchange
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTV_EMPTY) {
/* line 267 "CodeGlobal.puma" */
   return NoTree;

  }
  if (params->Kind == kBTV_LIST) {
/* line 271 "CodeGlobal.puma" */
   return CombineACF (DalibLocExchange (params->BTV_LIST.Elem), GlobalLocExchange (params->BTV_LIST.Next));

  }
/* line 277 "CodeGlobal.puma" */
  {
/* line 278 "CodeGlobal.puma" */
   failure_protocol (MODULE, "GlobalLocExchange", params);
  }
   return NoTree;

}

tTree CodeBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kBROADCAST_STMT) {
  if (stmt->BROADCAST_STMT.OWNER_TOP->Kind == kON_HOST) {
  if (stmt->BROADCAST_STMT.OWNER_SPEC->Kind == kON_EMPTY) {
/* line 311 "CodeGlobal.puma" */
 {
  tTree new;
  {
/* line 314 "CodeGlobal.puma" */
   stmt_protocol ("following statement is broadcast from host/io-process");
/* line 315 "CodeGlobal.puma" */
   new = MakeHostBroadcasts (stmt->BROADCAST_STMT.ELEMS);
/* line 316 "CodeGlobal.puma" */
   tree_protocol ("generated code :\n", new);
  }
   return new;
 }

  }
  }
  if (stmt->BROADCAST_STMT.OWNER_TOP->Kind == kON_ALL) {
  if (stmt->BROADCAST_STMT.OWNER_SPEC->Kind == kON_EMPTY) {
/* line 320 "CodeGlobal.puma" */
  {
/* line 321 "CodeGlobal.puma" */
   error_protocol ("broadcast from all nodes makes no sense");
  }
   return NoTree;

  }
  }
/* line 325 "CodeGlobal.puma" */
 {
  tTree new;
  tTree yyV1;
  tTree yyV2;
  {
/* line 327 "CodeGlobal.puma" */
   stmt_protocol ("following statement is broadcast from node processes");
/* line 329 "CodeGlobal.puma" */
   SplitOnSpecifications (stmt->BROADCAST_STMT.OWNER_SPEC, & yyV1, & yyV2);
/* line 331 "CodeGlobal.puma" */
   new = MakeNodeBroadcasts (stmt->BROADCAST_STMT.ELEMS, stmt->BROADCAST_STMT.OWNER_TOP, yyV1);
/* line 332 "CodeGlobal.puma" */
   tree_protocol ("generated code :\n", new);
  }
   return new;
 }

  }
/* line 336 "CodeGlobal.puma" */
  {
/* line 337 "CodeGlobal.puma" */
   failure_protocol (MODULE, "CodeBroadcast", stmt);
  }
   return NoTree;

}

static tTree MakeHostBroadcasts
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kBTV_LIST) {
/* line 359 "CodeGlobal.puma" */
   return CombineACF (MakeHostBroadcasts (var->BTV_LIST.Elem), MakeHostBroadcasts (var->BTV_LIST.Next));

  }
  if (var->Kind == kBTV_EMPTY) {
/* line 365 "CodeGlobal.puma" */
   return NoTree;

  }
/* line 370 "CodeGlobal.puma" */
  {
/* line 372 "CodeGlobal.puma" */
   if (! ((TreeWriteDistribution (var) == - 1))) goto yyL3;
  }
   return NoTree;
yyL3:;

/* line 376 "CodeGlobal.puma" */
 {
  tTree bc_var;
  tTree from;
  {
/* line 381 "CodeGlobal.puma" */
 bc_var = Overlapping (var);

     from = MakeConstant (1);  
   
  }
   return DalibBroadcast (bc_var, from);
 }

}

static tTree MakeNodeBroadcasts
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree top, register tTree specs)
# else
(var, top, specs)
 register tTree var;
 register tTree top;
 register tTree specs;
# endif
{
  if (var->Kind == kBTV_LIST) {
/* line 406 "CodeGlobal.puma" */
   return CombineACF (MakeNodeBroadcasts (var->BTV_LIST.Elem, top, specs), MakeNodeBroadcasts (var->BTV_LIST.Next, top, specs));

  }
  if (var->Kind == kBTV_EMPTY) {
/* line 411 "CodeGlobal.puma" */
   return NoTree;

  }
/* line 415 "CodeGlobal.puma" */
  {
/* line 417 "CodeGlobal.puma" */
   if (! ((TreeWriteDistribution (var) != 0))) goto yyL3;
  }
   return MakeNodeDimBroadcasts (var, top, specs);
yyL3:;

  if (top->Kind == kON_VAR) {
/* line 421 "CodeGlobal.puma" */
 {
  tTree new;
  tTree update;
  {
/* line 423 "CodeGlobal.puma" */
   if (! ((IsFullTopologyObj (top->ON_VAR.topid)))) goto yyL4;
  {
/* line 428 "CodeGlobal.puma" */
  

     new = MakeNodeDimBroadcasts (var, top, specs);

     

  
  }
  }
   return new;
 }
yyL4:;

  }
/* line 438 "CodeGlobal.puma" */
  {
/* line 440 "CodeGlobal.puma" */
   if (! ((TreeWriteDistribution (var) == 0))) goto yyL5;
  }
   return mACF_LIST (DalibFindOwner (top, specs), mACF_LIST (DalibNodeGet (var), NoTree));
yyL5:;

 yyAbort ("MakeNodeBroadcasts");
 { tTree yyDummy; return yyDummy; }
}

static tTree MakeNodeDimBroadcasts
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree top, register tTree specs)
# else
(var, top, specs)
 register tTree var;
 register tTree top;
 register tTree specs;
# endif
{
  if (specs->Kind == kON_LIST) {
/* line 463 "CodeGlobal.puma" */
   return CombineACF (MakeNodeDimBroadcasts (var, top, specs->ON_LIST.Elem), MakeNodeDimBroadcasts (var, top, specs->ON_LIST.Next));

  }
  if (specs->Kind == kON_EMPTY) {
/* line 468 "CodeGlobal.puma" */
   return NoTree;

  }
  if (specs->Kind == kON_SPEC) {
/* line 472 "CodeGlobal.puma" */
  {
/* line 473 "CodeGlobal.puma" */
   if (! ((IsVarSelection (var, specs)))) goto yyL3;
  }
   return NoTree;
yyL3:;

/* line 477 "CodeGlobal.puma" */
   return DalibDimBroadcast (CopyTree (var), top, specs);

  }
/* line 484 "CodeGlobal.puma" */
  {
/* line 485 "CodeGlobal.puma" */
   error_protocol ("illegal broadcast within processor topology");
  }
   return NoTree;

}

static rbool IsVarSelection
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree on_val)
# else
(var, on_val)
 register tTree var;
 register tTree on_val;
# endif
{
  if (on_val->Kind == kON_SPEC) {
/* line 500 "CodeGlobal.puma" */
 {
  var_descriptor owner;
  tTree val1;
  rbool found;
  {
/* line 506 "CodeGlobal.puma" */
   if (! ((TreeWriteDistribution (var) == 1))) goto yyL1;
  {
/* line 507 "CodeGlobal.puma" */
 GetVarDescriptor (var, &found, &owner);
     if (!found)
        tree_error_protocol
           ("IsVarSelection, no descriptor for this var : ", var);
     val1 = owner.on_val[on_val->ON_SPEC.top_dim-1];
     found = (val1 != NoTree);
     if (found)
       { found = EqualExpression (on_val->ON_SPEC.ON_VAL, val1);
         if (!found)
            error_protocol ("illegal broadcast (something went wrong)");
       }
   
/* line 519 "CodeGlobal.puma" */
   if (! ((found))) goto yyL1;
  }
  }
   return rtrue;
 }
yyL1:;

  }
  return rfalse;
}

static tTree Overlapping
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kDO_VAR) {
  if (t->DO_VAR.BODY->Kind == kBTV_LIST) {
  if (t->DO_VAR.BODY->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 532 "CodeGlobal.puma" */
   return TakeWholeVar (t->DO_VAR.BODY->BTV_LIST.Elem);

  }
/* line 539 "CodeGlobal.puma" */
  {
/* line 541 "CodeGlobal.puma" */
   error_protocol ("Broadcast: Too many variables in the variable list");
  }
   return TakeWholeVar (t->DO_VAR.BODY->BTV_LIST.Elem);

  }
  }
  if (t->Kind == kSELECTED_VAR) {
/* line 545 "CodeGlobal.puma" */
  {
/* line 547 "CodeGlobal.puma" */
 t->SELECTED_VAR.SELEC_VAR = Overlapping (t->SELECTED_VAR.SELEC_VAR); 
  }
   return t;

  }
  if (t->Kind == kINDEXED_VAR) {
/* line 552 "CodeGlobal.puma" */
  {
/* line 554 "CodeGlobal.puma" */
   if (! ((IsContiguousSection (t)))) goto yyL4;
  }
   return t;
yyL4:;

/* line 561 "CodeGlobal.puma" */
   return t->INDEXED_VAR.IND_VAR;

  }
  if (t->Kind == kUSED_VAR) {
/* line 568 "CodeGlobal.puma" */
   return t;

  }
  if (t->Kind == kLOOP_VAR) {
/* line 573 "CodeGlobal.puma" */
   return t;

  }
/* line 578 "CodeGlobal.puma" */
  {
/* line 580 "CodeGlobal.puma" */
   failure_protocol (MODULE, "Overlapping", t);
  }
   return t;

}

static tTree TakeWholeVar
# if defined __STDC__ | defined __cplusplus
(register tTree v)
# else
(v)
 register tTree v;
# endif
{
 yyRecursion:
  if (v->Kind == kINDEXED_VAR) {
/* line 592 "CodeGlobal.puma" */
   return v->INDEXED_VAR.IND_VAR;

  }
  if (v->Kind == kUSED_VAR) {
/* line 596 "CodeGlobal.puma" */
   return v;

  }
  if (v->Kind == kDO_VAR) {
  if (v->DO_VAR.BODY->Kind == kBTV_LIST) {
  if (v->DO_VAR.BODY->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 600 "CodeGlobal.puma" */
   v = v->DO_VAR.BODY->BTV_LIST.Elem;
   goto yyRecursion;

  }
/* line 607 "CodeGlobal.puma" */
  {
/* line 609 "CodeGlobal.puma" */
   error_protocol ("Broadcast: Too many variables in the variable list");
  }
   v = v->DO_VAR.BODY->BTV_LIST.Elem;
   goto yyRecursion;

  }
  }
/* line 613 "CodeGlobal.puma" */
  {
/* line 614 "CodeGlobal.puma" */
   failure_protocol (MODULE, "TakeWholeVar", v);
  }
   return v;

}

static tTree MakeReductionStmt
# if defined __STDC__ | defined __cplusplus
(register tTree top, register int dim, register tTree var, register tTree f)
# else
(top, dim, var, f)
 register tTree top;
 register int dim;
 register tTree var;
 register tTree f;
# endif
{
  if (f->Kind == kPROC_OBJ) {
/* line 640 "CodeGlobal.puma" */
 {
  tTree t;
  {
/* line 642 "CodeGlobal.puma" */
   if (! ((TreeRank (var) == 0))) goto yyL1;
  {
/* line 646 "CodeGlobal.puma" */
 t = MakeOpParam (var, f->PROC_OBJ.Ident);
     t = mBTP_LIST (mVAR_PARAM (CopyTree(var)), mBTP_LIST (t, mBTP_EMPTY()));

     if (top == NoTree)
 
      { 
        t = mBTP_LIST (ExpToVarParam (MakeConstant(1)), t);
        t = mBTP_LIST (ExpToVarParam (MakeConstant(1)), t);
      }

     else

      { t = mBTP_LIST (ExpToVarParam (MakeConstant(dim)), t);
        t = mBTP_LIST (top, t);
      }

     t = mCALL_STMT (mPROC_OBJ (MakeDalibId ("top_reduction")), t);
     t = mACF_BASIC (t);

   
  }
  }
   return t;
 }
yyL1:;

/* line 670 "CodeGlobal.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree t;
  {
/* line 672 "CodeGlobal.puma" */
   MyDalibSectionTranslation (var, & yyV1, & yyV2, & yyV3);
/* line 676 "CodeGlobal.puma" */
 t = MakeOpParam (var, f->PROC_OBJ.Ident);
     t = mBTP_LIST (yyV2, mBTP_LIST (t, mBTP_EMPTY()));
 
     if (top == NoTree)
 
      { 
        t = mBTP_LIST (ExpToVarParam (MakeConstant(1)), t);
        t = mBTP_LIST (ExpToVarParam (MakeConstant(1)), t);
      }
     else
      { t = mBTP_LIST (ExpToVarParam (MakeConstant(dim)), t);
        t = mBTP_LIST (top, t);
      }
     t = mCALL_STMT (mPROC_OBJ (MakeDalibId ("top_section_reduction")), t);
     t = mACF_BASIC (t);
   
  }
   return ComposeNewACF (yyV1, t, yyV3);
 }

  }
/* line 696 "CodeGlobal.puma" */
  {
/* line 697 "CodeGlobal.puma" */
   failure_protocol (MODULE, "MakeReductionStmt", f);
  }
   return NoTree;

}

static tTree MakeArrayReductionStmt
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int dim, register tTree var, register tTree f)
# else
(obj, dim, var, f)
 register tDefinitions obj;
 register int dim;
 register tTree var;
 register tTree f;
# endif
{
  if (f->Kind == kPROC_OBJ) {
/* line 714 "CodeGlobal.puma" */
 {
  tTree t;
  {
/* line 716 "CodeGlobal.puma" */
   if (! ((TreeRank (var) == 0))) goto yyL1;
  {
/* line 720 "CodeGlobal.puma" */
 t = MakeOpParam (var, f->PROC_OBJ.Ident);
     t = mBTP_LIST (mVAR_PARAM (CopyTree(var)), mBTP_LIST (t, mBTP_EMPTY()));

     t = mBTP_LIST (ExpToVarParam (MakeConstant(dim)), t);
     t = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (obj->Object.Ident, "_DSP")), t);

     t = mCALL_STMT (mPROC_OBJ (MakeDalibId ("array_dim_reduction")), t);
     t = mACF_BASIC (t);

   
  }
  }
   return t;
 }
yyL1:;

  }
/* line 734 "CodeGlobal.puma" */
  {
/* line 735 "CodeGlobal.puma" */
   failure_protocol (MODULE, "MakeArrayReductionStmt", f);
  }
   return NoTree;

}

static tTree MakeLocReductionStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree f)
# else
(var, f)
 register tTree var;
 register tTree f;
# endif
{
  if (f->Kind == kPROC_OBJ) {
/* line 751 "CodeGlobal.puma" */
 {
  tTree t;
  {
/* line 753 "CodeGlobal.puma" */
   if (! ((TreeRank (var) == 0))) goto yyL1;
  {
/* line 757 "CodeGlobal.puma" */
 t = MakeLocOpParam (var, f->PROC_OBJ.Ident);
     t = mBTP_LIST (mVAR_PARAM (CopyTree(var)), mBTP_LIST (t, mBTP_EMPTY()));
     t = mCALL_STMT (mPROC_OBJ (MakeDalibId ("pos_reduction")), t);
     t = mACF_BASIC (t);
   
  }
  }
   return t;
 }
yyL1:;

  }
/* line 766 "CodeGlobal.puma" */
  {
/* line 768 "CodeGlobal.puma" */
   error_protocol ("loc reductions not allowed for sections");
/* line 769 "CodeGlobal.puma" */
   tree_protocol ("no reduction for this var : ", var);
  }
   return NoTree;

}

static void MyDalibSectionTranslation
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree * yyP5, register tTree * yyP4, register tTree * yyP3)
# else
(var, yyP5, yyP4, yyP3)
 register tTree var;
 register tTree * yyP5;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{
/* line 787 "CodeGlobal.puma" */
 {
  tTree pre_stmts;
  tTree post_stmts;
  tTree descriptor;
  {
/* line 793 "CodeGlobal.puma" */
   DalibSectionTranslation (1, var, & pre_stmts, & descriptor, & post_stmts);
  }
   * yyP5 = pre_stmts;
   * yyP4 = descriptor;
   * yyP3 = post_stmts;
   return;
 }

;
}

static tTree MakeLocOpParam
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent funcname)
# else
(var, funcname)
 register tTree var;
 register tIdent funcname;
# endif
{
/* line 804 "CodeGlobal.puma" */
 {
  int op;
  {
/* line 808 "CodeGlobal.puma" */
   op = GetGlobalOp (TreeType (var), funcname);
/* line 810 "CodeGlobal.puma" */
 if ((op < 1) || (op > 6))
      { error_protocol ("illegal loc reduction (type, function)");
        tree_protocol ("var  : ", var);
        tree_protocol ("type : ", TreeType (var));
      }
   
  }
   return ExpToVarParam (MakeConstant (op));
 }

}

static tTree MakeOpParam
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tIdent funcname)
# else
(var, funcname)
 register tTree var;
 register tIdent funcname;
# endif
{
/* line 822 "CodeGlobal.puma" */
 {
  int op;
  {
/* line 826 "CodeGlobal.puma" */
   op = GetGlobalOp (TreeType (var), funcname);
/* line 828 "CodeGlobal.puma" */
 if (op == -1)  
      { error_protocol ("illegal reduction (type, function)");
        tree_protocol ("var  : ", var);
        tree_protocol ("type : ", TreeType (var));
      }
   
  }
   return ExpToVarParam (MakeConstant (op));
 }

}

void BeginCodeGlobal ARGS ((void))
{
}

void CloseCodeGlobal ARGS ((void))
{
}
