# include "CodeGeneration.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 31 "CodeGeneration.puma" */

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"
# include "Types.h"

# include "DefTable.h"

# include "protocol.h"

# include "Objects.h"

# include "Transform.h"       /* Replace*, Make*                        */
# include "Dalib.h"           /* MakeDalibId, ...                       */

# include "ArrayData.h"       /* SetActualOverlap                       */
# include "CodeVars.h"        /* all exported functions */
# include "CodeDescriptors.h" /* all exported functions */
# include "CodeMapping.h"     /* all exported functions */
# include "CodeMovement.h"
# include "Selection.h"
# include "CodeGlobal.h"      /* CodeReduction, CodeBroadcast         */
# include "Expressions.h"
# include "Scatter.h"         /* CodeScatterStmt */
# include "CodeCalling.h"     /* CodeCalling, UpdateLocalCall */
# include "CodeOn.h"          /* ApplyOnSpecs                  */
# include "CodeGeneral.h"
# include "Nesting.h"
# include "Distributions.h"
# include "Intrinsics.h"
# include "Rank.h"

# define MODULE "CodeGeneration"

static int section_counter;

static int is_task_region   = 0;  /* within TASK_REGION > 0 */

tIdent MakeDalibRoutine (name)

tIdent name;

{ /* replace name with corresponding dalib id */

  char new_name[100];
 
  GetString (name, new_name);
 
  return MakeDalibId (new_name);

} /* MakeDalibRoutine */
 


# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCodeGeneration.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* CodeGeneration_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeGeneration, routine %s failed\n",
  yyFunction);
 CodeGeneration_Exit ();
}

void NodeAdapt ARGS ((tTree t));
static tTree UnitsAdapt ARGS ((tTree t));
static void CodeBody ARGS ((tTree body, rbool stats_flag));
static tTree TransformDECL ARGS ((tTree t));
static tTree CodeACFNodes ARGS ((tTree t));
static void CodeDummyList ARGS ((tTree t));
static void TranslateFormals ARGS ((tTree dummies, tTree * yyP2, tTree * yyP1));
static void InsertDecls ARGS ((tTree body, tTree dummy_decls));
static tTree CodeInterface ARGS ((tTree t));
static tTree CodeInterfaceRoutines ARGS ((tTree items));
static tTree MergeDecls ARGS ((tTree item, tTree tail));
static tTree CodeInterfaceRoutine ARGS ((tTree item));

void NodeAdapt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCOMP_UNIT) {
/* line 93 "CodeGeneration.puma" */
  {
/* line 95 "CodeGeneration.puma" */
 t->COMP_UNIT.COMP_ELEMENTS = UnitsAdapt (t->COMP_UNIT.COMP_ELEMENTS); 
  }
   return;

  }
;
}

static tTree UnitsAdapt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kUNIT_LIST:
/* line 106 "CodeGeneration.puma" */
 {
  tTree new_decl;
  {
/* line 110 "CodeGeneration.puma" */
 new_decl = UnitsAdapt (t->UNIT_LIST.Elem);
     t->UNIT_LIST.Next     = UnitsAdapt (t->UNIT_LIST.Next);
     new_decl = ReplaceUNIT (t, new_decl, t->UNIT_LIST.Next);
   
  }
   return new_decl;
 }

  case kUNIT_EMPTY:
/* line 118 "CodeGeneration.puma" */
   return t;

  case kPROGRAM_DECL:
/* line 123 "CodeGeneration.puma" */
  {
/* line 125 "CodeGeneration.puma" */
   NestOpenUnit (t);
/* line 126 "CodeGeneration.puma" */
   CodeBody (t->PROGRAM_DECL.PROGRAM_BODY, rtrue);
/* line 127 "CodeGeneration.puma" */
   NestCloseUnit (t);
  }
   return t;

  case kPROC_DECL:
/* line 131 "CodeGeneration.puma" */
  {
/* line 133 "CodeGeneration.puma" */
   NestOpenUnit (t);
/* line 134 "CodeGeneration.puma" */
   CodeBody (t->PROC_DECL.PROC_BODY, rtrue);
/* line 135 "CodeGeneration.puma" */
   CodeDummyList (t);
/* line 136 "CodeGeneration.puma" */
   NestCloseUnit (t);
  }
   return t;

  case kFUNC_DECL:
/* line 140 "CodeGeneration.puma" */
  {
/* line 142 "CodeGeneration.puma" */
   error_protocol ("no longer any functions");
  }
   return NoTree;

  case kMODULE_DECL:
/* line 146 "CodeGeneration.puma" */
  {
/* line 148 "CodeGeneration.puma" */
   NestOpenUnit (t);
/* line 149 "CodeGeneration.puma" */
   CodeBody (t->MODULE_DECL.MODULE_BODY, rtrue);
/* line 150 "CodeGeneration.puma" */
   NestCloseUnit (t);
  }
   return t;

  case kBLOCK_DATA_DECL:
/* line 154 "CodeGeneration.puma" */
  {
/* line 156 "CodeGeneration.puma" */
   NestOpenUnit (t);
/* line 157 "CodeGeneration.puma" */
   CodeBody (t->BLOCK_DATA_DECL.DATA_BODY, rfalse);
/* line 158 "CodeGeneration.puma" */
   NestCloseUnit (t);
  }
   return t;

  }

/* line 162 "CodeGeneration.puma" */
  {
/* line 163 "CodeGeneration.puma" */
   failure_protocol (MODULE, "UnitsAdapt", t);
  }
   return NoTree;

}

static void CodeBody
# if defined __STDC__ | defined __cplusplus
(register tTree body, register rbool stats_flag)
# else
(body, stats_flag)
 register tTree body;
 register rbool stats_flag;
# endif
{
  if (body->Kind == kBODY_NODE) {
/* line 177 "CodeGeneration.puma" */
  {
/* line 180 "CodeGeneration.puma" */
 NewDefines  = NoTree;              
     NewHelpVars = mDECL_EMPTY();       
     if (stats_flag) body->BODY_NODE.STATS = CodeACFNodes (body->BODY_NODE.STATS);
     body->BODY_NODE.DECLS = TransformDECL (body->BODY_NODE.DECLS);
     body->BODY_NODE.NEW_DECLS = TransformDECL (body->BODY_NODE.NEW_DECLS);
     body->BODY_NODE.STATS = CombineACF (NewDefines, body->BODY_NODE.STATS);
     
     body->BODY_NODE.NEW_DECLS = AppendDECLS (body->BODY_NODE.NEW_DECLS, NewHelpVars);
   
/* line 190 "CodeGeneration.puma" */
   if (! (UnitsAdapt (body->BODY_NODE.INTERNALS))) goto yyL1;
  }
   return;
yyL1:;

  }
/* line 193 "CodeGeneration.puma" */
  {
/* line 195 "CodeGeneration.puma" */
   failure_protocol (MODULE, "CodeBody", body);
  }
   return;

;
}

static tTree TransformDECL
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kDECL_LIST:
/* line 206 "CodeGeneration.puma" */
 {
  tTree new_decl;
  {
/* line 210 "CodeGeneration.puma" */
 new_decl = TransformDECL (t->DECL_LIST.Elem);
       t->DECL_LIST.Next     = TransformDECL (t->DECL_LIST.Next);
       new_decl = ReplaceDECL (t, new_decl, t->DECL_LIST.Next);
     
  }
   return new_decl;
 }

  case kDECL_EMPTY:
/* line 218 "CodeGeneration.puma" */
   return t;

  case kVAR_DECL:
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
/* line 222 "CodeGeneration.puma" */
   return CodeVarDecl (t, GetLocalObject (t->VAR_DECL.Ident));

  }
/* line 227 "CodeGeneration.puma" */
  {
/* line 231 "CodeGeneration.puma" */
   if (! ((IsFuncObj (GetLocalObject (t->VAR_DECL.Ident))))) goto yyL4;
  {
/* line 232 "CodeGeneration.puma" */
   if (! ((IsStmtFunction (GetLocalObject (t->VAR_DECL.Ident))))) goto yyL4;
  }
  }
   return t;
yyL4:;

/* line 237 "CodeGeneration.puma" */
  {
/* line 241 "CodeGeneration.puma" */
   if (! ((IsFuncObj (GetLocalObject (t->VAR_DECL.Ident))))) goto yyL5;
  }
   return NoTree;
yyL5:;

/* line 245 "CodeGeneration.puma" */
 {
  tDefinitions Obj;
  {
/* line 248 "CodeGeneration.puma" */
   Obj = GetLocalObject (t->VAR_DECL.Ident);
  }
   return t;
 }

  case kTYPE_DECL:
  if (t->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
/* line 252 "CodeGeneration.puma" */
  {
/* line 256 "CodeGeneration.puma" */
   NestOpenType (t->TYPE_DECL.VAL);
/* line 258 "CodeGeneration.puma" */
 t->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS = TransformDECL (t->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS); 
/* line 260 "CodeGeneration.puma" */
   NestCloseType (t->TYPE_DECL.VAL);
  }
   return t;

  }
  break;
  case kPARAMETER_DECL:
/* line 265 "CodeGeneration.puma" */
   return t;

  case kEXTERNAL_DECL:
/* line 270 "CodeGeneration.puma" */
   return t;

  case kINTRINSIC_DECL:
/* line 275 "CodeGeneration.puma" */
  {
/* line 277 "CodeGeneration.puma" */
   if (! ((IntrFuncRed (t->INTRINSIC_DECL.Ident)))) goto yyL10;
  }
   return NoTree;
yyL10:;

/* line 282 "CodeGeneration.puma" */
  {
/* line 284 "CodeGeneration.puma" */
   if (! ((t->INTRINSIC_DECL.Ident == IsIdent ("TRANSPOSE")))) goto yyL11;
  }
   return NoTree;
yyL11:;

/* line 289 "CodeGeneration.puma" */
   return t;

  case kIMPLICIT_DECL:
/* line 294 "CodeGeneration.puma" */
   return t;

  case kCOMMON_DECL:
/* line 300 "CodeGeneration.puma" */
 {
  tTree common_dsp_decls;
  tTree new_common;
  tIdent common_id;
  {
/* line 306 "CodeGeneration.puma" */
   new_common = t;
/* line 308 "CodeGeneration.puma" */
   common_dsp_decls = MakeCommonVarDsp (t->COMMON_DECL.IDS);
/* line 310 "CodeGeneration.puma" */
   if ((common_dsp_decls != NoTree)) {
/* line 312 "CodeGeneration.puma" */
   if ((t->COMMON_DECL.Ident == DefaultId ())) {
/* line 313 "CodeGeneration.puma" */
   common_id = IsIdent ("BLANK_DSP");
   } else {
/* line 314 "CodeGeneration.puma" */
   common_id = MakeNewId (t->COMMON_DECL.Ident, "_DSP");
   }
/* line 317 "CodeGeneration.puma" */
   common_dsp_decls = mCOMMON_DECL (common_id, t->COMMON_DECL.Line, common_dsp_decls);
/* line 319 "CodeGeneration.puma" */
   new_common = mDECL_LIST (new_common, mDECL_LIST (common_dsp_decls, NoTree));
   }
  }
   return new_common;
 }

  case kNAMELIST_DECL:
/* line 327 "CodeGeneration.puma" */
   return t;

  case kDATA_DECL:
/* line 331 "CodeGeneration.puma" */
   return t;

  case kSAVE_DECL:
/* line 335 "CodeGeneration.puma" */
   return t;

  case kSEQUENCE_DECL:
/* line 339 "CodeGeneration.puma" */
   return NoTree;

  case kHPF_SEQUENCE_DECL:
/* line 343 "CodeGeneration.puma" */
   return NoTree;

  case kNOSEQUENCE_DECL:
/* line 347 "CodeGeneration.puma" */
   return NoTree;

  case kEQV_DECL:
/* line 351 "CodeGeneration.puma" */
   return t;

  case kTEMPLATE_DECL:
/* line 355 "CodeGeneration.puma" */
   return CodeTemplateDecl (t, GetLocalObject (t->TEMPLATE_DECL.Ident));

  case kRAGGED_DECL:
/* line 360 "CodeGeneration.puma" */
   return CodeRaggedDecl (t, GetLocalObject (t->RAGGED_DECL.Ident));

  case kPROCESSORS_DECL:
/* line 365 "CodeGeneration.puma" */
   return CodeProcDecl (GetLocalObject (t->PROCESSORS_DECL.Ident));

  case kALIGN_DECL:
/* line 370 "CodeGeneration.puma" */
   return NoTree;

  case kDISTRIBUTE_DECL:
/* line 375 "CodeGeneration.puma" */
   return NoTree;

  case kRANGE_DECL:
/* line 380 "CodeGeneration.puma" */
   return NoTree;

  case kSHARED_DECL:
/* line 385 "CodeGeneration.puma" */
   return NoTree;

  case kSHADOW_DECL:
/* line 392 "CodeGeneration.puma" */
   return NoTree;

  case kINHERIT_DECL:
/* line 397 "CodeGeneration.puma" */
   return NoTree;

  case kDYNAMIC_DECL:
/* line 402 "CodeGeneration.puma" */
   return NoTree;

  case kTRACE_DECL:
/* line 407 "CodeGeneration.puma" */
   return NoTree;

  case kNODSP_DECL:
/* line 412 "CodeGeneration.puma" */
   return NoTree;

  case kSELECT_DECL:
/* line 417 "CodeGeneration.puma" */
   return NoTree;

  case kTREE_DECL:
/* line 422 "CodeGeneration.puma" */
   return NoTree;

  case kALLOCATABLE_DECL:
/* line 427 "CodeGeneration.puma" */
   return NoTree;

  case kPOINTER_DECL:
/* line 432 "CodeGeneration.puma" */
  {
/* line 436 "CodeGeneration.puma" */
   if (! ((VarRank (GetLocalObject (t->POINTER_DECL.Ident)) > 0))) goto yyL37;
  }
   return NoTree;
yyL37:;

/* line 441 "CodeGeneration.puma" */
   return t;

  case kTARGET_DECL:
/* line 446 "CodeGeneration.puma" */
   return t;

  case kINTENT_DECL:
/* line 451 "CodeGeneration.puma" */
   return NoTree;

  case kOPTIONAL_DECL:
/* line 456 "CodeGeneration.puma" */
   return NoTree;

  case kLAYOUT_DECL:
/* line 461 "CodeGeneration.puma" */
   return NoTree;

  case kPASS_BY_DECL:
/* line 466 "CodeGeneration.puma" */
   return NoTree;

  case kMAP_TO_DECL:
/* line 470 "CodeGeneration.puma" */
   return NoTree;

  case kINTERFACE_DECL:
/* line 474 "CodeGeneration.puma" */
   return CodeInterface (t);

  case kSTMT_FUNC_DECL:
/* line 479 "CodeGeneration.puma" */
   return t;

  case kUSE_DECL:
/* line 484 "CodeGeneration.puma" */
   return t;

  case kONLY_USE_DECL:
/* line 488 "CodeGeneration.puma" */
   return t;

  case kPUBLIC_DECL:
/* line 492 "CodeGeneration.puma" */
   return t;

  case kPRIVATE_DECL:
/* line 496 "CodeGeneration.puma" */
   return t;

  case kFORMAT_DECL:
/* line 500 "CodeGeneration.puma" */
   return t;

  }

/* line 504 "CodeGeneration.puma" */
  {
/* line 505 "CodeGeneration.puma" */
   failure_protocol (MODULE, "TransformDECL", t);
  }
   return t;

}

static tTree CodeACFNodes
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kACF_LIST:
/* line 517 "CodeGeneration.puma" */
 {
  tTree newacf;
  {
/* line 521 "CodeGeneration.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 523 "CodeGeneration.puma" */
 newacf = CodeACFNodes (t->ACF_LIST.Elem);            
     t->ACF_LIST.Next   = CodeACFNodes (t->ACF_LIST.Next);            
   
/* line 527 "CodeGeneration.puma" */
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
   return newacf;
 }

  case kACF_EMPTY:
/* line 532 "CodeGeneration.puma" */
   return t;

  case kACF_WHILE:
/* line 541 "CodeGeneration.puma" */
  {
/* line 543 "CodeGeneration.puma" */
 t->ACF_WHILE.WHILE_BODY = CodeACFNodes (t->ACF_WHILE.WHILE_BODY);
     UpdateLocalCalls (t->ACF_WHILE.WHILE_EXP);
   
  }
   return t;

  case kACF_DO:
  if (t->ACF_DO.DO_HOME_INFO->Kind == kON_INFO) {
/* line 553 "CodeGeneration.puma" */
 {
  tTree new;
  rbool push_home;
  {
/* line 558 "CodeGeneration.puma" */
 push_home = (!NeedsNoContext (t->ACF_DO.DO_BODY));

     t->ACF_DO.DO_BODY = CodeACFNodes (t->ACF_DO.DO_BODY);
     UpdateLocalCalls (t->ACF_DO.DO_RANGE);

     new = ApplyOnInfo (t, push_home);

   
  }
   return new;
 }

  }
/* line 574 "CodeGeneration.puma" */
  {
/* line 576 "CodeGeneration.puma" */
 t->ACF_DO.DO_BODY = CodeACFNodes (t->ACF_DO.DO_BODY);
     UpdateLocalCalls (t->ACF_DO.DO_RANGE);
     CodeParallelLoop (t);
   
  }
   return t;

  case kACF_IF:
/* line 588 "CodeGeneration.puma" */
  {
/* line 590 "CodeGeneration.puma" */
 t->ACF_IF.THEN_PART = CodeACFNodes (t->ACF_IF.THEN_PART);
     t->ACF_IF.ELSE_PART = CodeACFNodes (t->ACF_IF.ELSE_PART);
     UpdateLocalCalls (t->ACF_IF.IF_EXP);
   
  }
   return t;

  case kACF_WHERE:
/* line 602 "CodeGeneration.puma" */
  {
/* line 604 "CodeGeneration.puma" */
   error_protocol ("WHERE should already be a local operation");
  }
   return NoTree;

  case kACF_TASK_REGION:
/* line 612 "CodeGeneration.puma" */
 {
  tTree init;
  tTree final;
  tTree new;
  {
/* line 618 "CodeGeneration.puma" */
 is_task_region++;
     init = NoTree;
     if (t->ACF_TASK_REGION.task_flag) init = CombineACF (StartTasking (), InitTaskRegion (t->ACF_TASK_REGION.TASK_BODY));
     new= CodeACFNodes (t->ACF_TASK_REGION.TASK_BODY);
     final = NoTree;
     if (t->ACF_TASK_REGION.task_flag) final = StopTasking ();
     is_task_region--;
     new = CombineACF (init, CombineACF (new, final));
   
  }
   return new;
 }

  case kACF_ON:
/* line 641 "CodeGeneration.puma" */
 {
  tTree new;
  {
/* line 645 "CodeGeneration.puma" */
 if (!NeedsNoContext (t->ACF_ON.ON_BODY))

       { new = CodeACFNodes (t->ACF_ON.ON_BODY);
         new = AppendBody (new, CodeONPopContext (t->ACF_ON.ON_HOME, t->ACF_ON.ON_SPECS));
         new = CombineACF (CodeONPushContext (t->ACF_ON.ON_HOME, t->ACF_ON.ON_SPECS), new);
       }

      else

         new = CodeACFNodes (t->ACF_ON.ON_BODY);

     set_protocol_stmt (t);   

     new = ApplyOnSpecs (new, t->ACF_ON.ON_HOME, t->ACF_ON.ON_SPECS);
   
  }
   return new;
 }

  case kACF_CRITICAL:
/* line 668 "CodeGeneration.puma" */
  {
/* line 670 "CodeGeneration.puma" */
 t->ACF_CRITICAL.CRITICAL_BODY = CodeACFNodes (t->ACF_CRITICAL.CRITICAL_BODY); 
  }
   return t;

  case kACF_PARALLEL:
/* line 679 "CodeGeneration.puma" */
  {
/* line 681 "CodeGeneration.puma" */
 t->ACF_PARALLEL.PARALLEL_BODY = CodeACFNodes (t->ACF_PARALLEL.PARALLEL_BODY); 
  }
   return t;

  case kACF_BASIC:

  switch (t->ACF_BASIC.BASIC_STMT->Kind) {
  case kCALL_STMT:
/* line 690 "CodeGeneration.puma" */
   return CodeCalling (t);

  case kSCATTER_STMT:
/* line 699 "CodeGeneration.puma" */
 {
  tTree new;
  {
/* line 703 "CodeGeneration.puma" */
 stmt_protocol ("translate SCATTER");
      new = CodeScatterStmt (t->ACF_BASIC.BASIC_STMT);
      tree_protocol ("generated code : \n", new);
    
  }
   return new;
 }

  case kIO_STMT:
/* line 792 "CodeGeneration.puma" */
   return t;

  case kCREATE_DSP_STMT:
/* line 801 "CodeGeneration.puma" */
 {
  tTree new;
  {
/* line 805 "CodeGeneration.puma" */
   stmt_protocol ("translate of CREATE DSP");
/* line 807 "CodeGeneration.puma" */
   new = CodeCreateDsp (t->ACF_BASIC.BASIC_STMT->CREATE_DSP_STMT.VAR, t->ACF_BASIC.BASIC_STMT->CREATE_DSP_STMT.SHAPE, t->ACF_BASIC.BASIC_STMT->CREATE_DSP_STMT.flag);
/* line 809 "CodeGeneration.puma" */
 if (new != NoTree)
        tree_protocol ("new CREATE DSP statements :\n", new);
   
  }
   return new;
 }

  case kINHERIT_DSP_STMT:
/* line 820 "CodeGeneration.puma" */
 {
  tTree new;
  {
/* line 824 "CodeGeneration.puma" */
   stmt_protocol ("translate of INHERIT DSP");
/* line 826 "CodeGeneration.puma" */
   new = CodeInheritDsp (t->ACF_BASIC.BASIC_STMT->INHERIT_DSP_STMT.VAR, t->ACF_BASIC.BASIC_STMT->INHERIT_DSP_STMT.SHAPE, t->ACF_BASIC.BASIC_STMT->INHERIT_DSP_STMT.flag, t->ACF_BASIC.BASIC_STMT->INHERIT_DSP_STMT.safety);
/* line 828 "CodeGeneration.puma" */
   tree_protocol ("new INHERIT DSP statements :\n", new);
  }
   return new;
 }

  case kFREE_DSP_STMT:
/* line 837 "CodeGeneration.puma" */
   return CodeFreeDsp (t->ACF_BASIC.BASIC_STMT->FREE_DSP_STMT.VAR, t->ACF_BASIC.BASIC_STMT->FREE_DSP_STMT.flag);

  case kALLOCATE_STMT:
/* line 846 "CodeGeneration.puma" */
 {
  tTree new;
  {
/* line 850 "CodeGeneration.puma" */
   stmt_protocol ("translate of ALLOCATE");
/* line 852 "CodeGeneration.puma" */
   new = AdaptAllocate (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS);
/* line 854 "CodeGeneration.puma" */
   tree_protocol ("new ALLOCATE statements :\n", new);
  }
   return new;
 }

  case kDEALLOCATE_STMT:
/* line 859 "CodeGeneration.puma" */
   return AdaptDeallocate (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS);

  case kREALIGN_STMT:
/* line 864 "CodeGeneration.puma" */
  {
/* line 866 "CodeGeneration.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL25;
  }
   return NoTree;
yyL25:;

/* line 870 "CodeGeneration.puma" */
   return CodeRealign (t->ACF_BASIC.BASIC_STMT->REALIGN_STMT.ALIGNEE, t->ACF_BASIC.BASIC_STMT->REALIGN_STMT.distribution);

  case kREDISTRIBUTE_STMT:
/* line 876 "CodeGeneration.puma" */
  {
/* line 878 "CodeGeneration.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL27;
  }
   return NoTree;
yyL27:;

/* line 882 "CodeGeneration.puma" */
   return CodeRedistribute (t->ACF_BASIC.BASIC_STMT->REDISTRIBUTE_STMT.DISTRIBUTEE, t->ACF_BASIC.BASIC_STMT->REDISTRIBUTE_STMT.distribution);

  case kREG_SHADOW_GET:
/* line 888 "CodeGeneration.puma" */
   return DalibArrayOverlapUpdate (t->ACF_BASIC.BASIC_STMT->REG_SHADOW_GET.SHADOW_VAR, t->ACF_BASIC.BASIC_STMT->REG_SHADOW_GET.SHADOW_SIZE);

  }

/* line 893 "CodeGeneration.puma" */
  {
/* line 895 "CodeGeneration.puma" */
   if (! ((IsIndShadowStmt (t->ACF_BASIC.BASIC_STMT)))) goto yyL30;
  {
/* line 897 "CodeGeneration.puma" */
   stmt_protocol ("coding indirect shadow stmt");
/* line 899 "CodeGeneration.puma" */
 t->ACF_BASIC.BASIC_STMT = CodeIndShadow (t->ACF_BASIC.BASIC_STMT); 
/* line 901 "CodeGeneration.puma" */
   stmt_protocol ("indirect shadow call");
/* line 903 "CodeGeneration.puma" */
 PrintParamVals (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS); 
  }
  }
   return CodeCallArguments (t);
yyL30:;


  switch (t->ACF_BASIC.BASIC_STMT->Kind) {
  case kREDUCTION_STMT:
/* line 908 "CodeGeneration.puma" */
   return CodeReduction (t->ACF_BASIC.BASIC_STMT);

  case kBROADCAST_STMT:
/* line 913 "CodeGeneration.puma" */
   return CodeBroadcast (t->ACF_BASIC.BASIC_STMT);

  case kDIRTY_STMT:
/* line 918 "CodeGeneration.puma" */
   return CodeDirtyStmt (t->ACF_BASIC.BASIC_STMT->DIRTY_STMT.ELEMS);

  case kGOTO_STMT:
/* line 923 "CodeGeneration.puma" */
   return t;

  case kCOMP_IF_STMT:
/* line 927 "CodeGeneration.puma" */
   return t;

  case kASSIGN_STMT:
/* line 937 "CodeGeneration.puma" */
  {
/* line 941 "CodeGeneration.puma" */
   UpdateLocalCalls (t);
  }
   return t;

  case kPTR_ASSIGN_STMT:
/* line 946 "CodeGeneration.puma" */
  {
/* line 948 "CodeGeneration.puma" */
   if (! ((TreeRank (t->ACF_BASIC.BASIC_STMT->PTR_ASSIGN_STMT.ASSIGN_VAR) > 0))) goto yyL37;
  }
   return CodePtrAssign (t->ACF_BASIC.BASIC_STMT->PTR_ASSIGN_STMT.ASSIGN_VAR, t->ACF_BASIC.BASIC_STMT->PTR_ASSIGN_STMT.ASSIGN_EXP);
yyL37:;

  break;
  }

/* line 953 "CodeGeneration.puma" */
   return t;

  case kACF_RM_READ:
/* line 714 "CodeGeneration.puma" */
 {
  tTree stmt;
  tTree params;
  {
/* line 719 "CodeGeneration.puma" */
 params = MakeRemoteParams (t->ACF_RM_READ.REMOTE_VAR);
     params = mBTP_LIST (mVAR_PARAM (t->ACF_RM_READ.LOCAL_VAR), params);

     stmt = mPROC_OBJ (MakeDalibId ("rma_read"));
     stmt = mACF_BASIC (mCALL_STMT (stmt, params));
   
  }
   return stmt;
 }

  case kACF_RM_WRITE:
/* line 733 "CodeGeneration.puma" */
 {
  tTree stmt;
  tTree params;
  {
/* line 738 "CodeGeneration.puma" */
 params = MakeRemoteParams (t->ACF_RM_WRITE.REMOTE_VAR);
     params = mBTP_LIST (ExpToVarParam (t->ACF_RM_WRITE.LOCAL_DATA), params);

     if (t->ACF_RM_WRITE.op != 0) 
        params = mBTP_LIST (ExpToVarParam (MakeConstant (t->ACF_RM_WRITE.op)), params);

     if (t->ACF_RM_WRITE.op == 0)
        stmt = mPROC_OBJ (MakeDalibId ("rma_write"));
      else
        stmt = mPROC_OBJ (MakeDalibId ("rma_update"));

     stmt = mACF_BASIC (mCALL_STMT (stmt, params));
   
  }
   return stmt;
 }

  case kACF_BARRIER:
/* line 759 "CodeGeneration.puma" */
 {
  tTree stmt;
  {
/* line 763 "CodeGeneration.puma" */
 stmt = mPROC_OBJ (MakeDalibId ("barrier"));
     stmt = mACF_BASIC (mCALL_STMT (stmt, mBTP_EMPTY()));
   
  }
   return stmt;
 }

  case kACF_MOVE:
  if (t->ACF_MOVE.MOVE_STMT->Kind == kASSIGN_STMT) {
/* line 774 "CodeGeneration.puma" */
   return CodeMovement (t);

  }
  if (t->ACF_MOVE.MOVE_STMT->Kind == kMOVE_STMT) {
/* line 783 "CodeGeneration.puma" */
   return CodeMovement (t);

  }
  break;
  case kACF_DUMMY:
/* line 958 "CodeGeneration.puma" */
   return t;

  }

/* line 963 "CodeGeneration.puma" */
  {
/* line 965 "CodeGeneration.puma" */
   failure_protocol (MODULE, "CodeACFNodes", t);
  }
   return NoTree;

}

static void CodeDummyList
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROC_DECL) {
/* line 980 "CodeGeneration.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 982 "CodeGeneration.puma" */
   TranslateFormals (t->PROC_DECL.FORMALS, & yyV1, & yyV2);
/* line 984 "CodeGeneration.puma" */
 t->PROC_DECL.FORMALS = AppendDECLS (t->PROC_DECL.FORMALS, yyV1); 
/* line 986 "CodeGeneration.puma" */
   InsertDecls (t->PROC_DECL.PROC_BODY, yyV2);
  }
   return;
 }

  }
  if (t->Kind == kFUNC_DECL) {
/* line 989 "CodeGeneration.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 991 "CodeGeneration.puma" */
   TranslateFormals (t->FUNC_DECL.FORMALS, & yyV1, & yyV2);
/* line 993 "CodeGeneration.puma" */
 t->FUNC_DECL.FORMALS = AppendDECLS (t->FUNC_DECL.FORMALS, yyV1); 
/* line 995 "CodeGeneration.puma" */
   InsertDecls (t->FUNC_DECL.FUNC_BODY, yyV2);
  }
   return;
 }

  }
;
}

static void TranslateFormals
# if defined __STDC__ | defined __cplusplus
(register tTree dummies, register tTree * yyP2, register tTree * yyP1)
# else
(dummies, yyP2, yyP1)
 register tTree dummies;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (dummies->Kind == kDECL_LIST) {
/* line 1000 "CodeGeneration.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 1003 "CodeGeneration.puma" */
   TranslateFormals (dummies->DECL_LIST.Elem, & yyV1, & yyV2);
/* line 1004 "CodeGeneration.puma" */
   TranslateFormals (dummies->DECL_LIST.Next, & yyV3, & yyV4);
  }
   * yyP2 = mDECL_LIST (yyV1, yyV3);
   * yyP1 = mDECL_LIST (yyV2, yyV4);
   return;
 }

  }
  if (dummies->Kind == kDECL_EMPTY) {
/* line 1007 "CodeGeneration.puma" */
   * yyP2 = dummies;
   * yyP1 = mDECL_EMPTY ();
   return;

  }
  if (dummies->Kind == kVAR_PARAM_DECL) {
/* line 1010 "CodeGeneration.puma" */
 {
  tTree descr_dummy;
  tTree descr_decl;
  tTree vtype;
  {
/* line 1016 "CodeGeneration.puma" */
 descr_dummy = MakeVarParamDeclA (dummies->VAR_PARAM_DECL.Ident, DUMMY_SUFFIX);
      vtype       = MakeIntegerType (default_addr_size);
      descr_decl  = MakeVarDeclA (dummies->VAR_PARAM_DECL.Ident, DUMMY_SUFFIX, vtype);
    
  }
   * yyP2 = descr_dummy;
   * yyP1 = descr_decl;
   return;
 }

  }
/* line 1022 "CodeGeneration.puma" */
  {
/* line 1024 "CodeGeneration.puma" */
   failure_protocol (MODULE, "TranslateFormals", dummies);
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static void InsertDecls
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree dummy_decls)
# else
(body, dummy_decls)
 register tTree body;
 register tTree dummy_decls;
# endif
{
  if (body->Kind == kBODY_NODE) {
/* line 1029 "CodeGeneration.puma" */
  {
/* line 1031 "CodeGeneration.puma" */
 body->BODY_NODE.DECLS = AppendDECLS (body->BODY_NODE.DECLS, dummy_decls); 
  }
   return;

  }
/* line 1034 "CodeGeneration.puma" */
  {
/* line 1035 "CodeGeneration.puma" */
   failure_protocol (MODULE, "InsertDecls", body);
  }
   return;

;
}

static tTree CodeInterface
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kINTERFACE_DECL) {
/* line 1056 "CodeGeneration.puma" */
   return CodeInterfaceRoutines (t->INTERFACE_DECL.ITEMS);

  }
/* line 1061 "CodeGeneration.puma" */
  {
/* line 1062 "CodeGeneration.puma" */
   failure_protocol (MODULE, "CodeInterface", t);
  }
   return NoTree;

}

static tTree CodeInterfaceRoutines
# if defined __STDC__ | defined __cplusplus
(register tTree items)
# else
(items)
 register tTree items;
# endif
{
  if (items->Kind == kUNIT_LIST) {
/* line 1074 "CodeGeneration.puma" */
   return MergeDecls (CodeInterfaceRoutine (items->UNIT_LIST.Elem), CodeInterfaceRoutines (items->UNIT_LIST.Next));

  }
  if (items->Kind == kUNIT_EMPTY) {
/* line 1080 "CodeGeneration.puma" */
   return NoTree;

  }
/* line 1085 "CodeGeneration.puma" */
  {
/* line 1086 "CodeGeneration.puma" */
   failure_protocol (MODULE, "CodeInterfaceRoutines", items);
  }
   return NoTree;

}

static tTree MergeDecls
# if defined __STDC__ | defined __cplusplus
(register tTree item, register tTree tail)
# else
(item, tail)
 register tTree item;
 register tTree tail;
# endif
{
/* line 1092 "CodeGeneration.puma" */
  {
/* line 1094 "CodeGeneration.puma" */
   if (! ((item == NoTree))) goto yyL1;
  }
   return tail;
yyL1:;

/* line 1098 "CodeGeneration.puma" */
   return mDECL_LIST (item, tail);

}

static tTree CodeInterfaceRoutine
# if defined __STDC__ | defined __cplusplus
(register tTree item)
# else
(item)
 register tTree item;
# endif
{
  if (item->Kind == kPROC_DECL) {
/* line 1111 "CodeGeneration.puma" */
   return mEXTERNAL_DECL (item->PROC_DECL.Ident, item->PROC_DECL.Line);

  }
  if (item->Kind == kFUNC_DECL) {
/* line 1116 "CodeGeneration.puma" */
  {
/* line 1118 "CodeGeneration.puma" */
   if (! ((IsF77Unit (item)))) goto yyL2;
  }
   return mVAR_DECL (item->FUNC_DECL.Ident, item->FUNC_DECL.Line, GetObjectType (GetLocalObject (item->FUNC_DECL.Ident)));
yyL2:;

  }
/* line 1125 "CodeGeneration.puma" */
   return NoTree;

}

void BeginCodeGeneration ARGS ((void))
{
}

void CloseCodeGeneration ARGS ((void))
{
}
