# include "CodeGeneral.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 51 "CodeGeneral.puma" */


# define  MODULE      "CodeGeneral"

# include <stdio.h>
# include "protocol.h"
# include "Idents.h"
# include "StringM.h"
# include "Types.h"
# include "TreeOps.h"    /* TreeVarName */

# include "DefTable.h"

# include "Expressions.h"
# include "Transform.h"
# include "Shapes.h"
# include "Rank.h"
# include "Dalib.h"      /* MakeDalibId  */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCodeGeneral.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* CodeGeneral_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeGeneral, routine %s failed\n",
  yyFunction);
 CodeGeneral_Exit ();
}

tTree FirstArrayElement ARGS ((tTree t));
tTree MakeSizeExp ARGS ((tTree t));
static tTree MakeElemsExp ARGS ((tTree t));
static tTree MakeIndexSizeExp ARGS ((tTree t));
static tTree MyMult ARGS ((tTree exp1, tTree exp2));
tTree MakeRemoteParams ARGS ((tTree var));
tTree MakeDistributeParams ARGS ((tDefinitions ilist));
tTree MakeTopologyParam ARGS ((tDefinitions top_obj));
tTree MakeTreeSizeParam ARGS ((tTree t));
void DefineNewIntVar ARGS ((tIdent name));
void DefineNewCommonVar ARGS ((tIdent cname, tIdent vname));
void DefineNewAddrVar ARGS ((tIdent name));
static rbool IsAlreadyNewHelpVar ARGS ((tIdent name, tTree decls));
void DefineNewHelpFn ARGS ((tIdent name));
static rbool IsAlreadyNewHelpFn ARGS ((tIdent name, tTree decls));
tTree MakeExtensionParams ARGS ((tTree t));
tTree MakeSectionParams ARGS ((tTree indexes));
static tTree MakeIncParameter ARGS ((tTree inc));

tTree FirstArrayElement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
/* line 82 "CodeGeneral.puma" */
   return t;

  }
  if (t->Kind == kINDEXED_VAR) {
/* line 87 "CodeGeneral.puma" */
   return mINDEXED_VAR (t->INDEXED_VAR.IND_VAR, FirstArrayElement (t->INDEXED_VAR.IND_EXPS));

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 92 "CodeGeneral.puma" */
   return mBTE_LIST (t->BTE_LIST.Elem->SLICE_EXP.FIRST, FirstArrayElement (t->BTE_LIST.Next));

  }
/* line 97 "CodeGeneral.puma" */
   return mBTE_LIST (t->BTE_LIST.Elem, FirstArrayElement (t->BTE_LIST.Next));

  }
  if (t->Kind == kBTE_EMPTY) {
/* line 102 "CodeGeneral.puma" */
   return t;

  }
/* line 107 "CodeGeneral.puma" */
  {
/* line 109 "CodeGeneral.puma" */
   failure_protocol ("Dalib", "FirstArrayElement", t);
  }
   return NoTree;

}

tTree MakeSizeExp
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 129 "CodeGeneral.puma" */
   return MyMult (MakeIndexSizeExp (t), MakeConstant (TreeSize (t)));

}

static tTree MakeElemsExp
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 137 "CodeGeneral.puma" */
 {
  tTree index_exp;
  {
/* line 141 "CodeGeneral.puma" */
   index_exp = MakeIndexSizeExp (t);
/* line 143 "CodeGeneral.puma" */
   if (! ((index_exp != NoTree))) goto yyL1;
  }
   return index_exp;
 }
yyL1:;

/* line 148 "CodeGeneral.puma" */
   return MakeConstant (1);

}

static tTree MakeIndexSizeExp
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kINDEXED_VAR) {
/* line 163 "CodeGeneral.puma" */
   return MyMult (MakeIndexSizeExp (t->INDEXED_VAR.IND_VAR), MakeIndexSizeExp (t->INDEXED_VAR.IND_EXPS));

  }
  if (t->Kind == kSELECTED_VAR) {
/* line 168 "CodeGeneral.puma" */
   t = t->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;

  }
  if (t->Kind == kUSED_VAR) {
/* line 173 "CodeGeneral.puma" */
   return NoTree;

  }
  if (t->Kind == kLOOP_VAR) {
/* line 178 "CodeGeneral.puma" */
   return NoTree;

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 183 "CodeGeneral.puma" */
   return MyMult (MakeSliceExp (t->BTE_LIST.Elem->SLICE_EXP.FIRST, t->BTE_LIST.Elem->SLICE_EXP.STOP), MakeIndexSizeExp (t->BTE_LIST.Next));

  }
/* line 190 "CodeGeneral.puma" */
  {
/* line 192 "CodeGeneral.puma" */
   if (! ((TreeRank (t->BTE_LIST.Elem) == 0))) goto yyL6;
  }
   t = t->BTE_LIST.Next;
   goto yyRecursion;
yyL6:;

  }
  if (t->Kind == kBTE_EMPTY) {
/* line 197 "CodeGeneral.puma" */
   return NoTree;

  }
/* line 202 "CodeGeneral.puma" */
  {
/* line 204 "CodeGeneral.puma" */
   failure_protocol ("Dalib", "MakeIndexSizeExp", t);
  }
   return NoTree;

}

static tTree MyMult
# if defined __STDC__ | defined __cplusplus
(register tTree exp1, register tTree exp2)
# else
(exp1, exp2)
 register tTree exp1;
 register tTree exp2;
# endif
{
/* line 210 "CodeGeneral.puma" */
  {
/* line 212 "CodeGeneral.puma" */
   if (! ((exp1 == NoTree))) goto yyL1;
  }
   return exp2;
yyL1:;

/* line 217 "CodeGeneral.puma" */
  {
/* line 219 "CodeGeneral.puma" */
   if (! ((exp2 == NoTree))) goto yyL2;
  }
   return exp1;
yyL2:;

/* line 224 "CodeGeneral.puma" */
   return mOP_EXP (mOP_TIMES (), exp1, exp2);

}

tTree MakeRemoteParams
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 236 "CodeGeneral.puma" */
 {
  tTree dsp;
  {
/* line 240 "CodeGeneral.puma" */
   dsp = mVAR_PARAM (MakeUsedVarA (TreeVarName (var->INDEXED_VAR.IND_VAR), "_DSP"));
  }
   return mBTP_LIST (dsp, MakeRemoteParams (var->INDEXED_VAR.IND_EXPS));
 }

  }
  if (var->Kind == kBTE_LIST) {
/* line 245 "CodeGeneral.puma" */
   return mBTP_LIST (ExpToVarParam (var->BTE_LIST.Elem), MakeRemoteParams (var->BTE_LIST.Next));

  }
  if (var->Kind == kBTE_EMPTY) {
/* line 250 "CodeGeneral.puma" */
   return mBTP_EMPTY ();

  }
 yyAbort ("MakeRemoteParams");
 { tTree yyDummy; return yyDummy; }
}

tTree MakeDistributeParams
# if defined __STDC__ | defined __cplusplus
(register tDefinitions ilist)
# else
(ilist)
 register tDefinitions ilist;
# endif
{
  if (ilist->Kind == kDIM_EMPTY) {
/* line 263 "CodeGeneral.puma" */
   return mBTP_EMPTY ();

  }
  if (ilist->Kind == kDIM_LIST) {
/* line 268 "CodeGeneral.puma" */
   return CombineBTP (MakeDistributeParams (ilist->DIM_LIST.Elem), MakeDistributeParams (ilist->DIM_LIST.Next));

  }
  if (ilist->Kind == kDistributedDimension) {
/* line 274 "CodeGeneral.puma" */
 {
  tTree len_array;
  tTree map_array;
  {
/* line 276 "CodeGeneral.puma" */
   if (! ((ilist->DistributedDimension.kind == kARBITRARY_DIM))) goto yyL3;
  {
/* line 281 "CodeGeneral.puma" */
 len_array = CopyTree (ilist->DistributedDimension.len);
     len_array = FirstArrayElement (MakeFullShape (len_array));
     
     map_array = CopyTree (ilist->DistributedDimension.map);
     map_array = FirstArrayElement (MakeFullShape (map_array));
   
  }
  }
   return mBTP_LIST (ExpToVarParam (MakeConstant (ilist->DistributedDimension.kind)), mBTP_LIST (ExpToVarParam (CopyTree (ilist->DistributedDimension.size)), mBTP_LIST (mVAR_PARAM (len_array), mBTP_LIST (mVAR_PARAM (map_array), NoTree))));
 }
yyL3:;

/* line 294 "CodeGeneral.puma" */
 {
  tTree size_array;
  {
/* line 296 "CodeGeneral.puma" */
   if (! (((ilist->DistributedDimension.kind == kGEN_BLOCK_DIM) || (ilist->DistributedDimension.kind == kINDIRECT_DIM)))) goto yyL4;
  {
/* line 303 "CodeGeneral.puma" */
 size_array = CopyTree (ilist->DistributedDimension.size);
     size_array = FirstArrayElement (MakeFullShape (size_array));
   
  }
  }
   return mBTP_LIST (ExpToVarParam (MakeConstant (ilist->DistributedDimension.kind)), mBTP_LIST (mVAR_PARAM (size_array), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), NoTree))));
 }
yyL4:;

/* line 313 "CodeGeneral.puma" */
  {
/* line 315 "CodeGeneral.puma" */
   if (! ((ilist->DistributedDimension.size == NoTree))) goto yyL5;
  }
   return mBTP_LIST (ExpToVarParam (MakeConstant (ilist->DistributedDimension.kind)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), NoTree))));
yyL5:;

/* line 323 "CodeGeneral.puma" */
   return mBTP_LIST (ExpToVarParam (MakeConstant (ilist->DistributedDimension.kind)), mBTP_LIST (ExpToVarParam (CopyTree (ilist->DistributedDimension.size)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), NoTree))));

  }
  if (ilist->Kind == kSerialDimension) {
/* line 331 "CodeGeneral.puma" */
   return mBTP_LIST (ExpToVarParam (MakeConstant (kSERIAL_DIM)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), NoTree))));

  }
/* line 339 "CodeGeneral.puma" */
  {
/* line 341 "CodeGeneral.puma" */
   failure_protocol (MODULE, "MakeDistributeParams", NoTree);
  }
   return NoTree;

}

tTree MakeTopologyParam
# if defined __STDC__ | defined __cplusplus
(register tDefinitions top_obj)
# else
(top_obj)
 register tDefinitions top_obj;
# endif
{
/* line 356 "CodeGeneral.puma" */
  {
/* line 358 "CodeGeneral.puma" */
   if (! ((top_obj == NoObject))) goto yyL1;
  }
   return ExpToVarParam (MakeConstant (kANY_TOPOLOGY));
yyL1:;

  if (top_obj->Kind == kTopologyObject) {
/* line 363 "CodeGeneral.puma" */
  {
/* line 365 "CodeGeneral.puma" */
   if (! ((top_obj->TopologyObject.Ident == DefaultId ()))) goto yyL2;
  }
   return ExpToVarParam (MakeConstant (top_obj->TopologyObject.rank));
yyL2:;

/* line 369 "CodeGeneral.puma" */
   return mVAR_PARAM (MakeUsedVarA (top_obj->TopologyObject.Ident, "_TOPID"));

  }
/* line 374 "CodeGeneral.puma" */
  {
/* line 376 "CodeGeneral.puma" */
   failure_protocol (MODULE, "MakeTopologyParam", top_obj->Object.decl);
  }
   return NoTree;

}

tTree MakeTreeSizeParam
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kINDEXED_VAR) {
/* line 388 "CodeGeneral.puma" */
   t = t->INDEXED_VAR.IND_VAR;
   goto yyRecursion;

  }
  if (t->Kind == kUSED_VAR) {
/* line 392 "CodeGeneral.puma" */
   return ExpToVarParam (MakeConstant (TreeSize (t)));

  }
/* line 396 "CodeGeneral.puma" */
  {
/* line 397 "CodeGeneral.puma" */
   failure_protocol ("Dalib", "MakeTreeSizeParam", t);
  }
   return NoTree;

}

void DefineNewIntVar
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 409 "CodeGeneral.puma" */
  {
/* line 410 "CodeGeneral.puma" */
   if (! ((IsAlreadyNewHelpVar (name, NewHelpVars)))) goto yyL1;
  }
   return;
yyL1:;

/* line 413 "CodeGeneral.puma" */
 {
  tTree var;
  {
/* line 416 "CodeGeneral.puma" */
 var = mVAR_DECL (name, 0, MakeIntegerType (default_int_size));
    NewHelpVars = mDECL_LIST (var, NewHelpVars);
  
  }
   return;
 }

;
}

void DefineNewCommonVar
# if defined __STDC__ | defined __cplusplus
(register tIdent cname, register tIdent vname)
# else
(cname, vname)
 register tIdent cname;
 register tIdent vname;
# endif
{
/* line 433 "CodeGeneral.puma" */
  {
/* line 435 "CodeGeneral.puma" */
   if (! ((IsAlreadyNewHelpVar (vname, NewHelpVars)))) goto yyL1;
  }
   return;
yyL1:;

/* line 438 "CodeGeneral.puma" */
 {
  tTree var;
  tTree type;
  tTree common;
  {
/* line 444 "CodeGeneral.puma" */
 if (vname == MakeDalibId ("1"))
      type = MakeStringType (2);
     else if (vname == MakeDalibId ("0"))
      type = MakeIntegerType (default_addr_size);
     else
      type = MakeIntegerType (default_int_size);
    var = mVAR_DECL (vname, 0, type);
    common = mVAR_DECL (vname, 0, mDUMMY_TYPE ());
    common = mDECL_LIST (common, mDECL_EMPTY ());
    common = mCOMMON_DECL (cname, 0, common);
    NewHelpVars = mDECL_LIST (common, NewHelpVars);
    NewHelpVars = mDECL_LIST (var, NewHelpVars);
  
  }
   return;
 }

;
}

void DefineNewAddrVar
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 461 "CodeGeneral.puma" */
  {
/* line 462 "CodeGeneral.puma" */
   if (! ((IsAlreadyNewHelpVar (name, NewHelpVars)))) goto yyL1;
  }
   return;
yyL1:;

/* line 465 "CodeGeneral.puma" */
 {
  tTree var;
  {
/* line 468 "CodeGeneral.puma" */
 var = mVAR_DECL (name, 0, MakeIntegerType (default_addr_size));
    NewHelpVars = mDECL_LIST (var, NewHelpVars);
  
  }
   return;
 }

;
}

static rbool IsAlreadyNewHelpVar
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree decls)
# else
(name, decls)
 register tIdent name;
 register tTree decls;
# endif
{
  if (decls->Kind == kDECL_LIST) {
  if (decls->DECL_LIST.Elem->Kind == kVAR_DECL) {
/* line 475 "CodeGeneral.puma" */
  {
/* line 476 "CodeGeneral.puma" */
   if (! ((name == decls->DECL_LIST.Elem->VAR_DECL.Ident))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
/* line 479 "CodeGeneral.puma" */
  {
/* line 480 "CodeGeneral.puma" */
   if (! ((IsAlreadyNewHelpVar (name, decls->DECL_LIST.Next)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

void DefineNewHelpFn
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 491 "CodeGeneral.puma" */
  {
/* line 492 "CodeGeneral.puma" */
   if (! ((IsAlreadyNewHelpFn (name, NewHelpVars)))) goto yyL1;
  }
   return;
yyL1:;

/* line 495 "CodeGeneral.puma" */
 {
  tTree type;
  tTree var;
  {
/* line 500 "CodeGeneral.puma" */
 if (name == MakeDalibId("PRESENT"))
        type = MakeLogicalType (default_int_size);
     else if (name == MakeDalibId("ALLOCATED"))
        type = MakeLogicalType (default_int_size);
     else if (name == MakeDalibId("is_local"))
        type = MakeLogicalType (default_int_size);
     else if (name == MakeDalibId("is_in_procs"))
        type = MakeLogicalType (default_int_size);
      else
       type = MakeIntegerType (default_int_size);

    var = mVAR_DECL (name, 0, type);
    NewHelpVars = mDECL_LIST (var, NewHelpVars);
    var = mEXTERNAL_DECL (name, 0);
    NewHelpVars = mDECL_LIST (var, NewHelpVars);
  
  }
   return;
 }

;
}

static rbool IsAlreadyNewHelpFn
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree decls)
# else
(name, decls)
 register tIdent name;
 register tTree decls;
# endif
{
  if (decls->Kind == kDECL_LIST) {
  if (decls->DECL_LIST.Elem->Kind == kVAR_DECL) {
/* line 520 "CodeGeneral.puma" */
  {
/* line 521 "CodeGeneral.puma" */
   if (! ((name == decls->DECL_LIST.Elem->VAR_DECL.Ident))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
/* line 524 "CodeGeneral.puma" */
  {
/* line 525 "CodeGeneral.puma" */
   if (! ((IsAlreadyNewHelpFn (name, decls->DECL_LIST.Next)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

tTree MakeExtensionParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_EMPTY) {
/* line 536 "CodeGeneral.puma" */
   return mBTP_EMPTY ();

  }
  if (t->Kind == kSHAPE_EMPTY) {
/* line 540 "CodeGeneral.puma" */
   return mBTP_EMPTY ();

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 544 "CodeGeneral.puma" */
   return mBTP_LIST (ExpToVarParam (CopyTree (t->BTE_LIST.Elem->SLICE_EXP.FIRST)), mBTP_LIST (ExpToVarParam (CopyTree (t->BTE_LIST.Elem->SLICE_EXP.STOP)), MakeExtensionParams (t->BTE_LIST.Next)));

  }
  }
  if (t->Kind == kSHAPE_LIST) {
  if (t->SHAPE_LIST.Elem->Kind == kEXPLICIT_SHAPE) {
/* line 550 "CodeGeneral.puma" */
   return mBTP_LIST (ExpToVarParam (CopyTree (t->SHAPE_LIST.Elem->EXPLICIT_SHAPE.LOWER)), mBTP_LIST (ExpToVarParam (CopyTree (t->SHAPE_LIST.Elem->EXPLICIT_SHAPE.UPPER)), MakeExtensionParams (t->SHAPE_LIST.Next)));

  }
  if (t->SHAPE_LIST.Elem->Kind == kDEFERRED_SHAPE) {
/* line 556 "CodeGeneral.puma" */
   return mBTP_LIST (ExpToVarParam (MakeConstant (0)), mBTP_LIST (ExpToVarParam (MakeConstant (0)), MakeExtensionParams (t->SHAPE_LIST.Next)));

  }
  if (t->SHAPE_LIST.Elem->Kind == kASSUMED_SHAPE) {
/* line 562 "CodeGeneral.puma" */
   return mBTP_LIST (ExpToVarParam (MakeConstant (1)), mBTP_LIST (ExpToVarParam (CopyTree (t->SHAPE_LIST.Elem->ASSUMED_SHAPE.LOWER)), MakeExtensionParams (t->SHAPE_LIST.Next)));

  }
  }
/* line 568 "CodeGeneral.puma" */
  {
/* line 569 "CodeGeneral.puma" */
   failure_protocol (MODULE, "MakeExtensionParams", t);
  }
   return NoTree;

}

tTree MakeSectionParams
# if defined __STDC__ | defined __cplusplus
(register tTree indexes)
# else
(indexes)
 register tTree indexes;
# endif
{
 yyRecursion:
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 584 "CodeGeneral.puma" */
 {
  tTree params;
  {
/* line 588 "CodeGeneral.puma" */
   params = MakeSectionParams (indexes->BTE_LIST.Next);
/* line 589 "CodeGeneral.puma" */
   params = mBTP_LIST (MakeIncParameter (indexes->BTE_LIST.Elem->SLICE_EXP.INC), params);
/* line 590 "CodeGeneral.puma" */
   params = mBTP_LIST (ExpToVarParam (CopyTree (indexes->BTE_LIST.Elem->SLICE_EXP.STOP)), params);
/* line 591 "CodeGeneral.puma" */
   params = mBTP_LIST (ExpToVarParam (CopyTree (indexes->BTE_LIST.Elem->SLICE_EXP.FIRST)), params);
/* line 592 "CodeGeneral.puma" */
   params = mBTP_LIST (ExpToVarParam (MakeConstant (1)), params);
  }
   return params;
 }

  }
/* line 597 "CodeGeneral.puma" */
 {
  tTree params;
  tTree zero;
  {
/* line 599 "CodeGeneral.puma" */
   if (! ((TreeRank (indexes->BTE_LIST.Elem) == 0))) goto yyL2;
  {
/* line 604 "CodeGeneral.puma" */
   zero = ExpToVarParam (MakeConstant (0));
/* line 606 "CodeGeneral.puma" */
   params = MakeSectionParams (indexes->BTE_LIST.Next);
/* line 607 "CodeGeneral.puma" */
   params = mBTP_LIST (zero, params);
/* line 608 "CodeGeneral.puma" */
   params = mBTP_LIST (zero, params);
/* line 609 "CodeGeneral.puma" */
   params = mBTP_LIST (ExpToVarParam (CopyTree (indexes->BTE_LIST.Elem)), params);
/* line 610 "CodeGeneral.puma" */
   params = mBTP_LIST (zero, params);
  }
  }
   return params;
 }
yyL2:;

  if (indexes->BTE_LIST.Elem->Kind == kVAR_EXP) {
  if (indexes->BTE_LIST.Elem->VAR_EXP.V->Kind == kINDEXED_VAR) {
/* line 615 "CodeGeneral.puma" */
 {
  tTree params;
  tTree kind;
  {
/* line 617 "CodeGeneral.puma" */
   if (! ((TreeRank (indexes->BTE_LIST.Elem->VAR_EXP.V) == 1))) goto yyL3;
  {
/* line 619 "CodeGeneral.puma" */
   if (! ((IsContiguousSection (indexes->BTE_LIST.Elem->VAR_EXP.V)))) goto yyL3;
  {
/* line 624 "CodeGeneral.puma" */
   kind = ExpToVarParam (MakeConstant (2));
/* line 626 "CodeGeneral.puma" */
   params = MakeSectionParams (indexes->BTE_LIST.Next);
/* line 627 "CodeGeneral.puma" */
   params = mBTP_LIST (kind, params);
/* line 628 "CodeGeneral.puma" */
   params = mBTP_LIST (ExpToVarParam (MakeElemsExp (indexes->BTE_LIST.Elem->VAR_EXP.V)), params);
/* line 629 "CodeGeneral.puma" */
   params = mBTP_LIST (mVAR_PARAM (FirstArrayElement (CopyTree (indexes->BTE_LIST.Elem->VAR_EXP.V))), params);
/* line 631 "CodeGeneral.puma" */
   params = mBTP_LIST (kind, params);
  }
  }
  }
   return params;
 }
yyL3:;

  }
  }
/* line 636 "CodeGeneral.puma" */
  {
/* line 638 "CodeGeneral.puma" */
   error_protocol ("illegal section");
/* line 639 "CodeGeneral.puma" */
   tree_protocol ("illegal index: ", indexes->BTE_LIST.Elem);
  }
   indexes = indexes->BTE_LIST.Next;
   goto yyRecursion;

  }
  if (indexes->Kind == kBTE_EMPTY) {
/* line 644 "CodeGeneral.puma" */
   return mBTP_EMPTY ();

  }
/* line 649 "CodeGeneral.puma" */
  {
/* line 651 "CodeGeneral.puma" */
   failure_protocol (MODULE, "MakeSectionParams", indexes);
  }
   return NoTree;

}

static tTree MakeIncParameter
# if defined __STDC__ | defined __cplusplus
(register tTree inc)
# else
(inc)
 register tTree inc;
# endif
{
/* line 657 "CodeGeneral.puma" */
  {
/* line 658 "CodeGeneral.puma" */
   if (! ((inc == NoTree))) goto yyL1;
  }
   return ExpToVarParam (MakeConstant (1));
yyL1:;

  if (inc->Kind == kDUMMY_EXP) {
/* line 662 "CodeGeneral.puma" */
   return ExpToVarParam (MakeConstant (1));

  }
/* line 666 "CodeGeneral.puma" */
   return ExpToVarParam (CopyTree (inc));

}

void BeginCodeGeneral ARGS ((void))
{
}

void CloseCodeGeneral ARGS ((void))
{
}
