# include "CodeCalling.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 28 "CodeCalling.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"
# include "Types.h"

# include "protocol.h"

# include "Objects.h"
# include "Intrinsics.h"
# include "TreeOps.h"
# include "Distributions.h"
# include "Rank.h"

# include "Expressions.h"         /* MakeConstant            */
# include "Transform.h"           /* CombineACF, CombineBTP  */
# include "Traverse.h"
# include "Dalib.h"               /* FirstArrayElement       */
# include "Nesting.h"             /* GetCurrentModel         */
# include "CodeDescriptors.h"
# include "CodeGeneral.h"         /* DUMMY_SUFFIX            */
# include "Shapes.h"              /* IsWholeVar              */

# define MODULE "CodeCalling"

static int section_counter;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCodeCalling.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* CodeCalling_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CodeCalling, routine %s failed\n",
  yyFunction);
 CodeCalling_Exit ();
}

tTree CodeCalling ARGS ((tTree t));
tTree CodeCallArguments ARGS ((tTree t));
static void CodeCallStmt ARGS ((tTree call, tTree * yyP2, tTree * yyP1));
static tTree DoubleArguments ARGS ((tTree arguments));
static tTree MakeDataParams ARGS ((tTree arguments));
static void SetDataParamAttributes ARGS ((tTree t));
static tTree MakeHandleParams ARGS ((tTree arguments));
static void SetHandleParamAttributes ARGS ((tTree t));
static void TranslateArguments ARGS ((tTree arguments, tTree * yyP4, tTree * yyP3));
static void TranslateArg ARGS ((tTree arg, tTree * yyP7, tTree * yyP6, tTree * yyP5));
static void MakeDescriptorParameter ARGS ((tTree param, tTree * yyP10, tTree * yyP9, tTree * yyP8));
static void NewAccess ARGS ((tTree t, tTree * yyP11));
static rbool NeedsNewAccess ARGS ((tDefinitions obj, int pointer, int dynamic));
static tTree MakeNewAccessStmt ARGS ((tTree var));
void UpdateLocalCalls ARGS ((tTree t));
static void UpdateCalling ARGS ((tTree t));
static tTree TranslateActualParams ARGS ((tTree call, tTree params));
static tTree FirstLocalDataElement ARGS ((tTree t));
static tTree LocalIndex ARGS ((tTree v, pvar vard, int dim));
static void TranslateRandomNumber ARGS ((tTree call));
static void TranslateHPFSend ARGS ((tTree call));
static void TranslateHPFSendInit ARGS ((tTree call));
static void TranslateHPFRecv ARGS ((tTree call));
static void TranslateHPFRecvInit ARGS ((tTree call));
static void TranslateHPFBcast ARGS ((tTree call));

tTree CodeCalling
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 66 "CodeCalling.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 68 "CodeCalling.puma" */
   UpdateLocalCalls (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS);
/* line 70 "CodeCalling.puma" */
   CodeCallStmt (t->ACF_BASIC.BASIC_STMT, & yyV1, & yyV2);
/* line 72 "CodeCalling.puma" */
 t->Kind = kACF_BASIC; 
  }
   return CombineACF (yyV1, CombineACF (t, yyV2));
 }

  }
  }
/* line 77 "CodeCalling.puma" */
  {
/* line 78 "CodeCalling.puma" */
   failure_protocol (MODULE, "CodeCalling", t);
  }
   return NoTree;

}

tTree CodeCallArguments
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 94 "CodeCalling.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 96 "CodeCalling.puma" */
   TranslateArguments (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
   return CombineACF (yyV1, CombineACF (t, yyV2));
 }

  }
  }
/* line 101 "CodeCalling.puma" */
  {
/* line 103 "CodeCalling.puma" */
   failure_protocol (MODULE, "CodeCallArguments", t);
  }
   return NoTree;

}

static void CodeCallStmt
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree * yyP2, register tTree * yyP1)
# else
(call, yyP2, yyP1)
 register tTree call;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (call->Kind == kCALL_STMT) {
/* line 115 "CodeCalling.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 117 "CodeCalling.puma" */
   if (! ((IsIntrCall (call)))) goto yyL1;
  {
/* line 118 "CodeCalling.puma" */
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Ident == IsIdent ("RANDOM_NUMBER")))) goto yyL1;
  {
/* line 120 "CodeCalling.puma" */
   TranslateRandomNumber (call);
/* line 121 "CodeCalling.puma" */
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL1:;

/* line 124 "CodeCalling.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 126 "CodeCalling.puma" */
   if (! ((IsIntrCall (call)))) goto yyL2;
  {
/* line 127 "CodeCalling.puma" */
   if (! ((IntrFuncDalib (call->CALL_STMT.CALL_ID->PROC_OBJ.Ident)))) goto yyL2;
  {
/* line 129 "CodeCalling.puma" */
 call->CALL_STMT.CALL_PARAMS = DoubleArguments (call->CALL_STMT.CALL_PARAMS); 
/* line 131 "CodeCalling.puma" */
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL2:;

/* line 134 "CodeCalling.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 136 "CodeCalling.puma" */
   if (! ((IsIntrCall (call)))) goto yyL3;
  {
/* line 137 "CodeCalling.puma" */
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Ident == IsIdent ("HPF_SEND")))) goto yyL3;
  {
/* line 139 "CodeCalling.puma" */
   TranslateHPFSend (call);
/* line 140 "CodeCalling.puma" */
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL3:;

/* line 143 "CodeCalling.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 147 "CodeCalling.puma" */
   if (! ((IsIntrCall (call)))) goto yyL4;
  {
/* line 148 "CodeCalling.puma" */
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Ident == IsIdent ("HPF_SEND_INIT")))) goto yyL4;
  {
/* line 150 "CodeCalling.puma" */
   TranslateHPFSendInit (call);
/* line 151 "CodeCalling.puma" */
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL4:;

/* line 154 "CodeCalling.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 158 "CodeCalling.puma" */
   if (! ((IsIntrCall (call)))) goto yyL5;
  {
/* line 159 "CodeCalling.puma" */
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Ident == IsIdent ("HPF_RECV")))) goto yyL5;
  {
/* line 161 "CodeCalling.puma" */
   TranslateHPFRecv (call);
/* line 162 "CodeCalling.puma" */
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL5:;

/* line 165 "CodeCalling.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 169 "CodeCalling.puma" */
   if (! ((IsIntrCall (call)))) goto yyL6;
  {
/* line 170 "CodeCalling.puma" */
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Ident == IsIdent ("HPF_RECV_INIT")))) goto yyL6;
  {
/* line 172 "CodeCalling.puma" */
   TranslateHPFRecvInit (call);
/* line 173 "CodeCalling.puma" */
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL6:;

/* line 176 "CodeCalling.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 178 "CodeCalling.puma" */
   if (! ((IsIntrCall (call)))) goto yyL7;
  {
/* line 179 "CodeCalling.puma" */
   if (! ((call->CALL_STMT.CALL_ID->PROC_OBJ.Ident == IsIdent ("HPF_BCAST")))) goto yyL7;
  {
/* line 181 "CodeCalling.puma" */
   TranslateHPFBcast (call);
/* line 182 "CodeCalling.puma" */
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
  }
  }
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }
yyL7:;

/* line 185 "CodeCalling.puma" */
  {
/* line 189 "CodeCalling.puma" */
   if (! ((IsIntrCall (call)))) goto yyL8;
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;
yyL8:;

/* line 192 "CodeCalling.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 196 "CodeCalling.puma" */
 if (!IsF77Call (call))

       call->CALL_STMT.CALL_PARAMS = DoubleArguments (call->CALL_STMT.CALL_PARAMS);
   
/* line 201 "CodeCalling.puma" */
   stmt_protocol ("translate arguments of call");
/* line 202 "CodeCalling.puma" */
   TranslateArguments (call->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2);
/* line 203 "CodeCalling.puma" */
   stmt_protocol ("arguments are translated");
/* line 205 "CodeCalling.puma" */
 if ( IsLocalCall (call) && IsNonLocalModel (GetCurrentModel()) )

       { tTree stmt;

         stmt = mPROC_OBJ (MakeDalibId ("push_local_context"));
         stmt = mCALL_STMT (stmt, mBTP_EMPTY ());
         stmt = mACF_BASIC (stmt);

         yyV1 = CombineACF (yyV1, stmt);

         stmt = mPROC_OBJ (MakeDalibId ("pop_local_context"));
         stmt = mCALL_STMT (stmt, mBTP_EMPTY ());
         stmt = mACF_BASIC (stmt);

         yyV2 = CombineACF (yyV2, stmt);
       }
   
  }
   * yyP2 = yyV1;
   * yyP1 = yyV2;
   return;
 }

  }
/* line 224 "CodeCalling.puma" */
  {
/* line 226 "CodeCalling.puma" */
   failure_protocol (MODULE, "CodeCallStmt", call);
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static tTree DoubleArguments
# if defined __STDC__ | defined __cplusplus
(register tTree arguments)
# else
(arguments)
 register tTree arguments;
# endif
{
/* line 240 "CodeCalling.puma" */
   return CombineBTP (MakeDataParams (arguments), MakeHandleParams (arguments));

}

static tTree MakeDataParams
# if defined __STDC__ | defined __cplusplus
(register tTree arguments)
# else
(arguments)
 register tTree arguments;
# endif
{
  if (arguments->Kind == kBTP_EMPTY) {
/* line 256 "CodeCalling.puma" */
   return arguments;

  }
  if (arguments->Kind == kBTP_LIST) {
/* line 261 "CodeCalling.puma" */
   return mBTP_LIST (MakeDataParams (arguments->BTP_LIST.Elem), MakeDataParams (arguments->BTP_LIST.Next));

  }
  if (arguments->Kind == kVAR_PARAM) {
/* line 266 "CodeCalling.puma" */
 {
  tTree t;
  {
/* line 270 "CodeCalling.puma" */
 t = mVAR_PARAM (arguments->VAR_PARAM.V);
      SetDataParamAttributes (t);
    
  }
   return t;
 }

  }
/* line 277 "CodeCalling.puma" */
   return arguments;

}

static void SetDataParamAttributes
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
/* line 284 "CodeCalling.puma" */
  {
/* line 286 "CodeCalling.puma" */
 t->VAR_PARAM.pass_by = kDATA_PASS_BY; 
  }
   return;

  }
  if (t->Kind == kNO_PARAM) {
/* line 289 "CodeCalling.puma" */
   return;

  }
/* line 292 "CodeCalling.puma" */
  {
/* line 293 "CodeCalling.puma" */
   failure_protocol (MODULE, "SetDataParamAttributes", t);
  }
   return;

;
}

static tTree MakeHandleParams
# if defined __STDC__ | defined __cplusplus
(register tTree arguments)
# else
(arguments)
 register tTree arguments;
# endif
{
  if (arguments->Kind == kBTP_EMPTY) {
/* line 307 "CodeCalling.puma" */
   return arguments;

  }
  if (arguments->Kind == kBTP_LIST) {
/* line 312 "CodeCalling.puma" */
  {
/* line 314 "CodeCalling.puma" */
 arguments->BTP_LIST.Elem = MakeHandleParams (arguments->BTP_LIST.Elem);
      arguments->BTP_LIST.Next = MakeHandleParams (arguments->BTP_LIST.Next);
    
  }
   return arguments;

  }
  if (arguments->Kind == kVAR_PARAM) {
/* line 321 "CodeCalling.puma" */
  {
/* line 323 "CodeCalling.puma" */
   SetHandleParamAttributes (arguments);
  }
   return arguments;

  }
/* line 328 "CodeCalling.puma" */
   return mNO_PARAM (kDUMMY_TYPE);

}

static void SetHandleParamAttributes
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
/* line 335 "CodeCalling.puma" */
  {
/* line 337 "CodeCalling.puma" */
 t->VAR_PARAM.pass_by = kHPF_HANDLE_PASS_BY; 
  }
   return;

  }
;
}

static void TranslateArguments
# if defined __STDC__ | defined __cplusplus
(register tTree arguments, register tTree * yyP4, register tTree * yyP3)
# else
(arguments, yyP4, yyP3)
 register tTree arguments;
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{
  if (arguments->Kind == kBTP_EMPTY) {
/* line 358 "CodeCalling.puma" */
  {
/* line 360 "CodeCalling.puma" */
 section_counter = 1; 
  }
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

  }
  if (arguments->Kind == kBTP_LIST) {
/* line 363 "CodeCalling.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
/* line 366 "CodeCalling.puma" */
   TranslateArguments (arguments->BTP_LIST.Next, & yyV1, & yyV2);
/* line 367 "CodeCalling.puma" */
   TranslateArg (arguments->BTP_LIST.Elem, & yyV3, & yyV4, & yyV5);
/* line 369 "CodeCalling.puma" */
 arguments->BTP_LIST.Elem = yyV3; 
  }
   * yyP4 = CombineACF (yyV4, yyV1);
   * yyP3 = CombineACF (yyV2, yyV5);
   return;
 }

  }
/* line 372 "CodeCalling.puma" */
  {
/* line 374 "CodeCalling.puma" */
   failure_protocol (MODULE, "TranslateArguments", arguments);
  }
   * yyP4 = NoTree;
   * yyP3 = NoTree;
   return;

;
}

static void TranslateArg
# if defined __STDC__ | defined __cplusplus
(register tTree arg, register tTree * yyP7, register tTree * yyP6, register tTree * yyP5)
# else
(arg, yyP7, yyP6, yyP5)
 register tTree arg;
 register tTree * yyP7;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
  if (arg->Kind == kVAR_PARAM) {
/* line 379 "CodeCalling.puma" */
  {
/* line 381 "CodeCalling.puma" */
   if (! ((arg->VAR_PARAM.pass_by == kDEFAULT_PASS_BY))) goto yyL1;
  {
/* line 382 "CodeCalling.puma" */
 arg->VAR_PARAM.pass_by = kDATA_PASS_BY; 
/* line 383 "CodeCalling.puma" */
   goto yyL1;
  }
  }
yyL1:;

  if (arg->VAR_PARAM.V->Kind == kINDEXED_VAR) {
/* line 386 "CodeCalling.puma" */
  {
/* line 388 "CodeCalling.puma" */
   if (! ((arg->VAR_PARAM.pass_by == kDATA_PASS_BY))) goto yyL2;
  {
/* line 390 "CodeCalling.puma" */
 arg->VAR_PARAM.V = FirstLocalDataElement (arg->VAR_PARAM.V); 
  }
  }
   * yyP7 = arg;
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;
yyL2:;

  }
/* line 393 "CodeCalling.puma" */
  {
/* line 395 "CodeCalling.puma" */
   if (! ((arg->VAR_PARAM.pass_by == kDATA_PASS_BY))) goto yyL3;
  }
   * yyP7 = arg;
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;
yyL3:;

/* line 398 "CodeCalling.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 400 "CodeCalling.puma" */
   if (! ((arg->VAR_PARAM.pass_by == kHPF_HANDLE_PASS_BY))) goto yyL4;
  {
/* line 402 "CodeCalling.puma" */
   MakeDescriptorParameter (arg, & yyV1, & yyV2, & yyV3);
  }
  }
   * yyP7 = yyV1;
   * yyP6 = yyV2;
   * yyP5 = yyV3;
   return;
 }
yyL4:;

  }
  if (arg->Kind == kNO_PARAM) {
/* line 405 "CodeCalling.puma" */
   * yyP7 = arg;
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

  }
  if (arg->Kind == kPROC_PARAM) {
/* line 408 "CodeCalling.puma" */
   * yyP7 = arg;
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

  }
  if (arg->Kind == kFUNC_PARAM) {
/* line 411 "CodeCalling.puma" */
   * yyP7 = arg;
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

  }
;
}

static void MakeDescriptorParameter
# if defined __STDC__ | defined __cplusplus
(register tTree param, register tTree * yyP10, register tTree * yyP9, register tTree * yyP8)
# else
(param, yyP10, yyP9, yyP8)
 register tTree param;
 register tTree * yyP10;
 register tTree * yyP9;
 register tTree * yyP8;
# endif
{
  if (param->Kind == kVAR_PARAM) {
/* line 423 "CodeCalling.puma" */
 {
  tTree pre;
  tTree post;
  tTree dsp;
  int pack;
  {
/* line 425 "CodeCalling.puma" */
   if (! (((param->VAR_PARAM.layout == kHPF_LOCAL_LAYOUT) || (param->VAR_PARAM.layout == kF77_LOCAL_LAYOUT)))) goto yyL1;
  {
/* line 427 "CodeCalling.puma" */
   if (! ((TreeRank (param->VAR_PARAM.V) > 0))) goto yyL1;
  {
/* line 435 "CodeCalling.puma" */
 if (param->VAR_PARAM.layout == kF77_LOCAL_LAYOUT)
        pack = 1;
       else
        pack = 0;
   
/* line 441 "CodeCalling.puma" */
   DalibLocalTranslation (section_counter, pack, param->VAR_PARAM.V, & pre, & dsp, & post);
/* line 443 "CodeCalling.puma" */
 if (pre != NoTree) section_counter ++; 
  }
  }
  }
   * yyP10 = dsp;
   * yyP9 = pre;
   * yyP8 = post;
   return;
 }
yyL1:;

/* line 446 "CodeCalling.puma" */
 {
  tTree pre;
  tTree post;
  tTree dsp;
  tTree yyV1;
  {
/* line 454 "CodeCalling.puma" */
   if (! ((TreeRank (param->VAR_PARAM.V) > 0))) goto yyL2;
  {
/* line 460 "CodeCalling.puma" */
   NewAccess (param, & yyV1);
/* line 462 "CodeCalling.puma" */
   DalibSectionTranslation (section_counter, param->VAR_PARAM.V, & pre, & dsp, & post);
/* line 464 "CodeCalling.puma" */
 if (pre != NoTree) section_counter ++; 

     post = CombineACF (post, yyV1);
   
  }
  }
   * yyP10 = dsp;
   * yyP9 = pre;
   * yyP8 = post;
   return;
 }
yyL2:;

  if (param->VAR_PARAM.V->Kind == kUSED_VAR) {
/* line 474 "CodeCalling.puma" */
 {
  tTree dsp;
  {
/* line 477 "CodeCalling.puma" */
   if (! ((VarRank (param->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object) == 0))) goto yyL3;
  {
/* line 478 "CodeCalling.puma" */
   if (! ((IsVarDummy (param->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL3;
  {
/* line 482 "CodeCalling.puma" */
   dsp = mVAR_PARAM (MakeUsedVarA (param->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Ident, DUMMY_SUFFIX));
  }
  }
  }
   * yyP10 = dsp;
   * yyP9 = NoTree;
   * yyP8 = NoTree;
   return;
 }
yyL3:;

  }
  }
/* line 487 "CodeCalling.puma" */
   * yyP10 = mNO_PARAM (kDUMMY_TYPE);
   * yyP9 = NoTree;
   * yyP8 = NoTree;
   return;

;
}

static void NewAccess
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP11)
# else
(t, yyP11)
 register tTree t;
 register tTree * yyP11;
# endif
{
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kADDR) {
/* line 497 "CodeCalling.puma" */
   * yyP11 = NoTree;
   return;

  }
/* line 500 "CodeCalling.puma" */
 {
  tTree access_stmt;
  {
/* line 504 "CodeCalling.puma" */
   if (! (NeedsNewAccess (GetVarAccessObject (t->VAR_PARAM.V), t->VAR_PARAM.pointer, t->VAR_PARAM.dynamic))) goto yyL2;
  {
/* line 506 "CodeCalling.puma" */
   access_stmt = MakeNewAccessStmt (t->VAR_PARAM.V);
  }
  }
   * yyP11 = access_stmt;
   return;
 }
yyL2:;

  }
/* line 509 "CodeCalling.puma" */
   * yyP11 = NoTree;
   return;

;
}

static rbool NeedsNewAccess
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int pointer, register int dynamic)
# else
(obj, pointer, dynamic)
 register tDefinitions obj;
 register int pointer;
 register int dynamic;
# endif
{
/* line 514 "CodeCalling.puma" */
  {
/* line 516 "CodeCalling.puma" */
   if (! ((VarRank (obj) == 0))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 519 "CodeCalling.puma" */
  {
/* line 521 "CodeCalling.puma" */
   if (! ((pointer == kIS_POINTER))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 524 "CodeCalling.puma" */
  {
/* line 526 "CodeCalling.puma" */
   if (! ((dynamic == kHPF_NOT_DYNAMIC))) goto yyL3;
  {
/* line 527 "CodeCalling.puma" */
   return rfalse;
  }
  }
yyL3:;

/* line 530 "CodeCalling.puma" */
  {
/* line 532 "CodeCalling.puma" */
   if (! ((dynamic == kHPF_IS_DYNAMIC))) goto yyL4;
  {
/* line 533 "CodeCalling.puma" */
   if (! ((IsHPFDynamic (obj)))) goto yyL4;
  }
  }
   return rtrue;
yyL4:;

/* line 536 "CodeCalling.puma" */
  {
/* line 538 "CodeCalling.puma" */
   if (! ((dynamic == kHPF_DEFAULT_DYNAMIC))) goto yyL5;
  {
/* line 539 "CodeCalling.puma" */
   if (! ((IsHPFDynamic (obj)))) goto yyL5;
  }
  }
   return rtrue;
yyL5:;

  return rfalse;
}

static tTree MakeNewAccessStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kINDEXED_VAR) {
/* line 553 "CodeCalling.puma" */
   var = var->INDEXED_VAR.IND_VAR;
   goto yyRecursion;

  }
/* line 558 "CodeCalling.puma" */
 {
  tTree stmt;
  {
/* line 562 "CodeCalling.puma" */
 stmt = mACCESS_STMT (CopyTree(var));
     stmt = mACF_BASIC (stmt); 
   
  }
   return stmt;
 }

}

void UpdateLocalCalls
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 579 "CodeCalling.puma" */
  {
/* line 581 "CodeCalling.puma" */
   FullTraverseAST (t, UpdateCalling);
  }
   return;

;
}

static void UpdateCalling
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kCALL_STMT) {
/* line 596 "CodeCalling.puma" */
  {
/* line 598 "CodeCalling.puma" */
   if (! ((IsIntrCall (t)))) goto yyL1;
  }
   return;
yyL1:;

/* line 601 "CodeCalling.puma" */
  {
/* line 603 "CodeCalling.puma" */
   if (! ((IsPureCall (t)))) goto yyL2;
  }
   return;
yyL2:;

/* line 606 "CodeCalling.puma" */
  {
/* line 608 "CodeCalling.puma" */
 

     t->CALL_STMT.CALL_PARAMS = TranslateActualParams (t, t->CALL_STMT.CALL_PARAMS);

   
  }
   return;

  }
  if (t->Kind == kFUNC_CALL_EXP) {
  if (t->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
/* line 615 "CodeCalling.puma" */
  {
/* line 617 "CodeCalling.puma" */
   if (! ((IsIntrCall (t)))) goto yyL4;
  {
/* line 619 "CodeCalling.puma" */
   if (! ((t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("PRESENT")))) goto yyL4;
  {
/* line 621 "CodeCalling.puma" */
   SetDataParamAttributes (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem);
  }
  }
  }
   return;
yyL4:;

/* line 624 "CodeCalling.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 626 "CodeCalling.puma" */
   if (! ((IsIntrCall (t)))) goto yyL5;
  {
/* line 628 "CodeCalling.puma" */
   if (! ((t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("ALLOCATED")))) goto yyL5;
  {
/* line 630 "CodeCalling.puma" */
   SetHandleParamAttributes (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem);
/* line 631 "CodeCalling.puma" */
   TranslateArg (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, & yyV1, & yyV2, & yyV3);
/* line 633 "CodeCalling.puma" */
 t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem = yyV1;

     if ((yyV2 != NoTree) || (yyV3 != NoTree))
        error_protocol ("ALLOCATED only with full array");
   
  }
  }
  }
   return;
 }
yyL5:;

  }
/* line 640 "CodeCalling.puma" */
  {
/* line 642 "CodeCalling.puma" */
   if (! ((IsUserCall (t)))) goto yyL6;
  {
/* line 644 "CodeCalling.puma" */
 

     t->FUNC_CALL_EXP.FUNC_PARAMS = TranslateActualParams (t, t->FUNC_CALL_EXP.FUNC_PARAMS);

   
  }
  }
   return;
yyL6:;

  }
;
}

static tTree TranslateActualParams
# if defined __STDC__ | defined __cplusplus
(register tTree call, register tTree params)
# else
(call, params)
 register tTree call;
 register tTree params;
# endif
{
/* line 659 "CodeCalling.puma" */
 {
  tTree new;
  tTree yyV1;
  tTree yyV2;
  {
/* line 663 "CodeCalling.puma" */
 if (IsF77Call (call))
        new = params;
      else
        new = DoubleArguments (params); 
   
/* line 669 "CodeCalling.puma" */
   TranslateArguments (new, & yyV1, & yyV2);
/* line 671 "CodeCalling.puma" */
 if ((yyV1 != NoTree) || (yyV2 != NoTree))

      { warning_protocol ("descriptors are not validated");
        print_protocol ("descriptor is needed");
      }
   
  }
   return new;
 }

}

static tTree FirstLocalDataElement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kUSED_VAR) {
/* line 691 "CodeCalling.puma" */
   return t;

  }
  if (t->Kind == kINDEXED_VAR) {
/* line 695 "CodeCalling.puma" */
 {
  var_descriptor vard;
  int dim;
  tTree new_indexes;
  int no;
  int rank;
  {
/* line 703 "CodeCalling.puma" */
   SetVarDescriptor (t, & vard);
/* line 705 "CodeCalling.puma" */
 new_indexes = mBTE_EMPTY ();
 
     no   = TreeListLength (t->INDEXED_VAR.IND_EXPS);
     rank = vard.formal_rank;

     
  
     for (dim=rank; dim > rank-no; dim--)
        new_indexes = mBTE_LIST (LocalIndex (t->INDEXED_VAR.IND_VAR, &vard, dim), new_indexes);

   
  }
   return mINDEXED_VAR (t->INDEXED_VAR.IND_VAR, new_indexes);
 }

  }
/* line 720 "CodeCalling.puma" */
  {
/* line 722 "CodeCalling.puma" */
   failure_protocol (MODULE, "FirstLocalElement", t);
  }
   return t;

}

static tTree LocalIndex
# if defined __STDC__ | defined __cplusplus
(register tTree v, pvar vard, register int dim)
# else
(v, vard, dim)
 register tTree v;
 pvar vard;
 register int dim;
# endif
{
/* line 728 "CodeCalling.puma" */
  {
/* line 732 "CodeCalling.puma" */
   if (! ((vard -> actual_shape [dim - 1] [0] == vard -> actual_shape [dim - 1] [1]))) goto yyL1;
  }
   return vard -> actual_shape [dim - 1] [0];
yyL1:;

/* line 737 "CodeCalling.puma" */
  {
/* line 741 "CodeCalling.puma" */
   if (! ((vard -> distribution_kind [dim - 1] == kSERIAL_DIM))) goto yyL2;
  }
   return vard -> actual_shape [dim - 1] [0];
yyL2:;

/* line 746 "CodeCalling.puma" */
   return mBOUND_EXP (v, dim, 0, 1);

}

static void TranslateRandomNumber
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kCALL_STMT) {
  if (call->CALL_STMT.CALL_PARAMS->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 761 "CodeCalling.puma" */
 {
  tTree size;
  {
/* line 764 "CodeCalling.puma" */
   if (! ((TreeRank (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem) == 0))) goto yyL1;
  {
/* line 768 "CodeCalling.puma" */
   size = ExpToVarParam (MakeConstant (TreeSize (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem)));
/* line 770 "CodeCalling.puma" */
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem);
/* line 771 "CodeCalling.puma" */
   SetDataParamAttributes (size);
/* line 773 "CodeCalling.puma" */
   call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next = mBTP_LIST (size, call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next);
/* line 775 "CodeCalling.puma" */
   call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("SINGLE_RANDOM");
  }
  }
   return;
 }
yyL1:;

  }
  }
/* line 778 "CodeCalling.puma" */
  {
/* line 780 "CodeCalling.puma" */
 call->CALL_STMT.CALL_PARAMS = DoubleArguments (call->CALL_STMT.CALL_PARAMS); 
  }
   return;

  }
/* line 783 "CodeCalling.puma" */
  {
/* line 785 "CodeCalling.puma" */
   failure_protocol (MODULE, "TranslateRandomNumber", call);
  }
   return;

;
}

static void TranslateHPFSend
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kCALL_STMT) {
  if (call->CALL_STMT.CALL_PARAMS->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 796 "CodeCalling.puma" */
 {
  tTree size;
  {
/* line 799 "CodeCalling.puma" */
   if (! ((TreeRank (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem) == 0))) goto yyL1;
  {
/* line 803 "CodeCalling.puma" */
   size = ExpToVarParam (MakeConstant (TreeSize (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem)));
/* line 805 "CodeCalling.puma" */
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem);
/* line 806 "CodeCalling.puma" */
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
/* line 807 "CodeCalling.puma" */
   SetDataParamAttributes (size);
/* line 809 "CodeCalling.puma" */
   call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next = mBTP_LIST (size, call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next);
/* line 811 "CodeCalling.puma" */
   call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("HPF_SEND_SCALAR");
  }
  }
   return;
 }
yyL1:;

  }
  }
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 814 "CodeCalling.puma" */
 {
  tTree ptr_data;
  {
/* line 817 "CodeCalling.puma" */
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
/* line 822 "CodeCalling.puma" */
   ptr_data = CopyTree (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem);
/* line 823 "CodeCalling.puma" */
   SetDataParamAttributes (ptr_data);
/* line 825 "CodeCalling.puma" */
   call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next = mBTP_LIST (ptr_data, call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next);
/* line 827 "CodeCalling.puma" */
   call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("HPF_SEND_ARRAY");
  }
   return;
 }

  }
  }
  }
  }
;
}

static void TranslateHPFSendInit
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kCALL_STMT) {
  if (call->CALL_STMT.CALL_PARAMS->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 840 "CodeCalling.puma" */
  {
/* line 843 "CodeCalling.puma" */
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
/* line 844 "CodeCalling.puma" */
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
  }
  }
;
}

static void TranslateHPFRecv
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kCALL_STMT) {
  if (call->CALL_STMT.CALL_PARAMS->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 855 "CodeCalling.puma" */
 {
  tTree size;
  {
/* line 858 "CodeCalling.puma" */
   if (! ((TreeRank (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem) == 0))) goto yyL1;
  {
/* line 862 "CodeCalling.puma" */
   size = ExpToVarParam (MakeConstant (TreeSize (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem)));
/* line 864 "CodeCalling.puma" */
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem);
/* line 865 "CodeCalling.puma" */
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
/* line 866 "CodeCalling.puma" */
   SetDataParamAttributes (size);
/* line 868 "CodeCalling.puma" */
   call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next = mBTP_LIST (size, call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next);
/* line 870 "CodeCalling.puma" */
   call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("HPF_RECV_SCALAR");
  }
  }
   return;
 }
yyL1:;

  }
  }
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 873 "CodeCalling.puma" */
 {
  tTree ptr_data;
  {
/* line 876 "CodeCalling.puma" */
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
/* line 881 "CodeCalling.puma" */
   ptr_data = CopyTree (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem);
/* line 882 "CodeCalling.puma" */
   SetDataParamAttributes (ptr_data);
/* line 884 "CodeCalling.puma" */
   call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next = mBTP_LIST (ptr_data, call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next);
/* line 886 "CodeCalling.puma" */
   call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("HPF_RECV_ARRAY");
  }
   return;
 }

  }
  }
  }
  }
;
}

static void TranslateHPFRecvInit
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kCALL_STMT) {
  if (call->CALL_STMT.CALL_PARAMS->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 897 "CodeCalling.puma" */
  {
/* line 901 "CodeCalling.puma" */
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
/* line 902 "CodeCalling.puma" */
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
  }
   return;

  }
  }
  }
  }
  }
;
}

static void TranslateHPFBcast
# if defined __STDC__ | defined __cplusplus
(register tTree call)
# else
(call)
 register tTree call;
# endif
{
  if (call->Kind == kCALL_STMT) {
  if (call->CALL_STMT.CALL_PARAMS->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 913 "CodeCalling.puma" */
 {
  tTree size;
  {
/* line 916 "CodeCalling.puma" */
   if (! ((TreeRank (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem) == 0))) goto yyL1;
  {
/* line 920 "CodeCalling.puma" */
   size = ExpToVarParam (MakeConstant (TreeSize (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem)));
/* line 922 "CodeCalling.puma" */
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Elem);
/* line 923 "CodeCalling.puma" */
   SetDataParamAttributes (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
/* line 924 "CodeCalling.puma" */
   SetDataParamAttributes (size);
/* line 926 "CodeCalling.puma" */
   call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next = mBTP_LIST (size, call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next);
/* line 928 "CodeCalling.puma" */
   call->CALL_STMT.CALL_ID->PROC_OBJ.Ident = IsIdent ("HPF_BCAST_SCALAR");
  }
  }
   return;
 }
yyL1:;

  }
  }
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (call->CALL_STMT.CALL_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 931 "CodeCalling.puma" */
  {
/* line 934 "CodeCalling.puma" */
   error_protocol ("HPF_BCAST: not possible for arrays");
  }
   return;

  }
  }
  }
  }
;
}

void BeginCodeCalling ARGS ((void))
{
}

void CloseCodeCalling ARGS ((void))
{
}
