# include "Classification.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 23 "Classification.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Types.h"
# include "Objects.h"
# include "Intrinsics.h"
# include "Loops.h"
# include "Distributions.h"
# include "Transform.h"      /* CombineACF, CombineBTV, ... */

# include "Nesting.h"        /* GetCurrentUnit   */
# include "Independence.h"

    /*******************************************
    *                                          *
    *  PrePhases : Movement, MakeOn            *
    *                                          *
    *******************************************/
 
# include "MakeMovement.h"      /* MakeMovement */
# include "MakeOn.h"            /* MakeOn        */

    /*******************************************
    *                                          *
    *  used for own phase of classification    *
    *                                          *
    *******************************************/
 
# include "UserFunctions.h"  /* TranslateUserFunction */
# include "Barriers.h"       
# include "Scatter.h"
# include "Traverse.h"
# include "Reductions.h"      /* ResolveReduce         */

# include "VarDescriptor.h"
# include "Ownership.h"
# include "ReductionComm.h"

# include "SMParallel.h"
# include "RemoteAccess.h"
# include "MoveControl.h"
# include "ExpDescriptor.h"
# include "Rank.h"

# define MODULE "Classification"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyClassification.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Classification_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Classification, routine %s failed\n",
  yyFunction);
 Classification_Exit ();
}

void Classification ARGS ((tTree t));
static void ClassifyBody ARGS ((tTree t));
static rbool StopClassification ARGS ((tTree t));
static tTree DoClassification ARGS ((tTree t));
static tTree ClassifySimple ARGS ((tTree t));
static tTree ClassifyAssignment ARGS ((tTree stmt, tTree var, tTree exp));
static tTree ClassifyMovement ARGS ((tTree t));
static tTree MakeMoveBroadcast ARGS ((tTree t));
static tTree MakeOwnerBroadcast ARGS ((tTree var, tTree on_stmt));
static void VarOwnership ARGS ((tTree var, tTree * yyP2, tTree * yyP1));
static tTree OnOwnership ARGS ((tTree stmt, tTree var));
static void CheckMovement ARGS ((tTree target_var, tTree source_exp));
static tTree ClassifyOnStatement ARGS ((tTree on_stmt));
static void UpdateOnBody ARGS ((tTree t));
static void ClassifyRMA ARGS ((tTree t));
static rbool StopRMA ARGS ((tTree t));
static tTree DoRMA ARGS ((tTree t));

void Classification
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kCOMP_UNIT) {
/* line 87 "Classification.puma" */
  {
/* line 89 "Classification.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  }
  if (t->Kind == kUNIT_EMPTY) {
/* line 92 "Classification.puma" */
   return;

  }
  if (t->Kind == kUNIT_LIST) {
  if (t->UNIT_LIST.Elem->Kind == kPROGRAM_DECL) {
/* line 95 "Classification.puma" */
  {
/* line 97 "Classification.puma" */
   NestOpenUnit (t->UNIT_LIST.Elem);
/* line 98 "Classification.puma" */
   Classification (t->UNIT_LIST.Elem->PROGRAM_DECL.PROGRAM_BODY);
/* line 99 "Classification.puma" */
   NestCloseUnit (t->UNIT_LIST.Elem);
/* line 100 "Classification.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->UNIT_LIST.Elem->Kind == kPROC_DECL) {
/* line 103 "Classification.puma" */
  {
/* line 105 "Classification.puma" */
   NestOpenUnit (t->UNIT_LIST.Elem);
/* line 106 "Classification.puma" */
   Classification (t->UNIT_LIST.Elem->PROC_DECL.PROC_BODY);
/* line 107 "Classification.puma" */
   NestCloseUnit (t->UNIT_LIST.Elem);
/* line 108 "Classification.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->UNIT_LIST.Elem->Kind == kFUNC_DECL) {
/* line 111 "Classification.puma" */
 {
  tTree p;
  {
/* line 115 "Classification.puma" */
   NestOpenUnit (t->UNIT_LIST.Elem);
/* line 116 "Classification.puma" */
   Classification (t->UNIT_LIST.Elem->FUNC_DECL.FUNC_BODY);
/* line 117 "Classification.puma" */
 p = TranslateUserFunction (t->UNIT_LIST.Elem); 
/* line 118 "Classification.puma" */
   NestCloseUnit (t->UNIT_LIST.Elem);
/* line 119 "Classification.puma" */
 t->UNIT_LIST.Elem = p; 
/* line 120 "Classification.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }
 }

  }
  if (t->UNIT_LIST.Elem->Kind == kBLOCK_DATA_DECL) {
/* line 123 "Classification.puma" */
  {
/* line 125 "Classification.puma" */
   NestOpenUnit (t->UNIT_LIST.Elem);
/* line 126 "Classification.puma" */
   Classification (t->UNIT_LIST.Elem->BLOCK_DATA_DECL.DATA_BODY);
/* line 127 "Classification.puma" */
   NestCloseUnit (t->UNIT_LIST.Elem);
/* line 128 "Classification.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->UNIT_LIST.Elem->Kind == kMODULE_DECL) {
/* line 131 "Classification.puma" */
  {
/* line 133 "Classification.puma" */
   NestOpenUnit (t->UNIT_LIST.Elem);
/* line 134 "Classification.puma" */
   Classification (t->UNIT_LIST.Elem->MODULE_DECL.MODULE_BODY);
/* line 135 "Classification.puma" */
   NestCloseUnit (t->UNIT_LIST.Elem);
/* line 136 "Classification.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  if (t->Kind == kBODY_NODE) {
/* line 139 "Classification.puma" */
  {
/* line 141 "Classification.puma" */
   print_protocol ("Step 1 : classification of movements");
/* line 142 "Classification.puma" */
   print_protocol ("====================================");
/* line 143 "Classification.puma" */
   MakeMovement (t);
/* line 144 "Classification.puma" */
   print_protocol ("");
/* line 145 "Classification.puma" */
   print_protocol ("Step 2 : check independence");
/* line 146 "Classification.puma" */
   print_protocol ("===========================");
/* line 147 "Classification.puma" */
   CheckIndependence (t);
/* line 148 "Classification.puma" */
   print_protocol ("");
/* line 149 "Classification.puma" */
   print_protocol ("Step 2a : find SM parallelism");
/* line 150 "Classification.puma" */
   print_protocol ("=============================");
/* line 151 "Classification.puma" */
   FindSMParallel (t);
/* line 152 "Classification.puma" */
   print_protocol ("");
/* line 153 "Classification.puma" */
   print_protocol ("Step 2b : identify reductions");
/* line 154 "Classification.puma" */
   print_protocol ("=============================");
/* line 155 "Classification.puma" */
   ReductionCommunication (t);
/* line 156 "Classification.puma" */
   print_protocol ("");
/* line 157 "Classification.puma" */
   tree_protocol (" after step 2 : \n", t);
/* line 158 "Classification.puma" */
   print_protocol ("Step 3 : ownership for local loops");
/* line 159 "Classification.puma" */
   print_protocol ("==================================");
/* line 160 "Classification.puma" */
   MakeOn (t);
/* line 161 "Classification.puma" */
   print_protocol ("");
/* line 162 "Classification.puma" */
   print_protocol ("Step 4 : identify SM parallelism");
/* line 163 "Classification.puma" */
   print_protocol ("================================");
/* line 164 "Classification.puma" */
   MakeSMParallel (t);
/* line 165 "Classification.puma" */
   print_protocol ("");
/* line 166 "Classification.puma" */
   print_protocol ("Step 5 : classification");
/* line 167 "Classification.puma" */
   print_protocol ("=======================");
/* line 168 "Classification.puma" */
   ClassifyBody (t);
/* line 169 "Classification.puma" */
   print_protocol ("");
/* line 170 "Classification.puma" */
   print_protocol ("Step 6 : RMA accesses");
/* line 171 "Classification.puma" */
   print_protocol ("=====================");
/* line 172 "Classification.puma" */
   ClassifyRMA (t);
/* line 174 "Classification.puma" */
   t = t->BODY_NODE.INTERNALS;
   goto yyRecursion;
  }

  }
;
}

static void ClassifyBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 185 "Classification.puma" */
  {
/* line 187 "Classification.puma" */
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopClassification, DoClassification); 
  }
   return;

  }
/* line 190 "Classification.puma" */
  {
/* line 191 "Classification.puma" */
   failure_protocol (MODULE, "ClassifyBody", t);
  }
   return;

;
}

static rbool StopClassification
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_ON) {
/* line 205 "Classification.puma" */
   return rtrue;

  }
  if (Tree_IsType (t, kBT_STMT)) {
/* line 208 "Classification.puma" */
   return rtrue;

  }
  if (t->Kind == kACF_WHERE) {
/* line 219 "Classification.puma" */
  {
/* line 220 "Classification.puma" */
   if (! ((IsParallelLoop (t)))) goto yyL3;
  {
/* line 221 "Classification.puma" */
   error_protocol ("here should be no where statements");
  }
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

static tTree DoClassification
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kACF_ON:
/* line 242 "Classification.puma" */
 {
  tTree new;
  {
/* line 246 "Classification.puma" */
 new = GetBarriers (t);
     new = CombineACF (CopyTree(new), 
             CombineACF (ClassifyOnStatement (t), 
               CombineACF (new, GetUpdates(t))));
   
  }
   return new;
 }

  case kACF_BASIC:
/* line 254 "Classification.puma" */
 {
  tTree barriers;
  tTree updates;
  tTree new;
  {
/* line 261 "Classification.puma" */
 barriers = GetBarriers (t);
     updates  = GetUpdates  (t);

     new = ComposeNewACF (CopyTree(barriers), ClassifySimple (t), barriers);

     if (t != new)
        stmt_protocol ("basic statement has been new classified");

     new = CombineACF (new, updates);

   
  }
   return new;
 }

  case kACF_WHILE:
/* line 276 "Classification.puma" */
  {
/* line 278 "Classification.puma" */
   if (! ((TreeReadDistribution (t->ACF_WHILE.WHILE_EXP) != 0))) goto yyL3;
  {
/* line 279 "Classification.puma" */
   error_protocol ("rboolean expression in DO WHILE is not replicated");
  }
  }
   return t;
yyL3:;

/* line 284 "Classification.puma" */
   return t;

  case kACF_DO:
/* line 289 "Classification.puma" */
  {
/* line 291 "Classification.puma" */
   if (! ((TreeReadDistribution (t->ACF_DO.DO_RANGE) != 0))) goto yyL5;
  {
/* line 293 "Classification.puma" */
   set_protocol_stmt (t);
/* line 294 "Classification.puma" */
   error_protocol ("range in DO loop is not replicated");
  }
  }
   return t;
yyL5:;

/* line 299 "Classification.puma" */
   return t;

  case kACF_REDUCTION:
/* line 306 "Classification.puma" */
   return t->ACF_REDUCTION.REDUCTION_BODY;

  case kACF_FORALL:
/* line 311 "Classification.puma" */
  {
/* line 313 "Classification.puma" */
   if (! ((TreeReadDistribution (t->ACF_FORALL.FORALL_RANGE) != 0))) goto yyL8;
  {
/* line 315 "Classification.puma" */
   error_protocol ("range in FORALL statement/construct is not replicated");
  }
  }
   return t;
yyL8:;

/* line 320 "Classification.puma" */
   return t;

  case kACF_IF:
/* line 325 "Classification.puma" */
  {
/* line 327 "Classification.puma" */
   if (! ((TreeReadDistribution (t->ACF_IF.IF_EXP) != 0))) goto yyL10;
  {
/* line 329 "Classification.puma" */
   error_protocol ("rboolean expression in IF statement is not replicated");
  }
  }
   return t;
yyL10:;

/* line 334 "Classification.puma" */
   return t;

  case kACF_WHERE:
/* line 339 "Classification.puma" */
  {
/* line 341 "Classification.puma" */
   error_protocol ("where statements do not exist here");
  }
   return t;

  }

/* line 345 "Classification.puma" */
   return t;

}

static tTree ClassifySimple
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 366 "Classification.puma" */
 {
  tTree new;
  {
/* line 369 "Classification.puma" */
   if (! ((IsIntrCall (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID)))) goto yyL1;
  {
/* line 370 "Classification.puma" */
   if (! ((IntrFuncScatter (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL1;
  {
/* line 374 "Classification.puma" */
 stmt_protocol ("translate scatter operation");
      new = MakeScatterStmt (t);
      tree_protocol ("new scatter stmt : \n", new);
    
  }
  }
  }
   t = new;
   goto yyRecursion;
 }
yyL1:;

/* line 389 "Classification.puma" */
 {
  tTree param;
  {
/* line 391 "Classification.puma" */
   if (! ((FunctionBecomesSubroutine (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID)))) goto yyL2;
  {
/* line 395 "Classification.puma" */
 param = mVAR_PARAM (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
      t->ACF_BASIC.BASIC_STMT  = mCALL_STMT (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID, mBTP_LIST (param, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS));
    
  }
  }
   goto yyRecursion;
 }
yyL2:;

  }
/* line 419 "Classification.puma" */
   return ClassifyAssignment (t, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 408 "Classification.puma" */
   return ResolveReduce (t);

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 433 "Classification.puma" */
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kSCATTER_STMT) {
/* line 438 "Classification.puma" */
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kMOVE_STMT) {
/* line 443 "Classification.puma" */
   return ClassifyMovement (t);

  }
/* line 457 "Classification.puma" */
   return t;

  }
/* line 462 "Classification.puma" */
  {
/* line 463 "Classification.puma" */
   failure_protocol (MODULE, "ClassifySimple", t);
  }
   return t;

}

static tTree ClassifyAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree var, register tTree exp)
# else
(stmt, var, exp)
 register tTree stmt;
 register tTree var;
 register tTree exp;
# endif
{
/* line 483 "Classification.puma" */
  {
/* line 485 "Classification.puma" */
   if (! ((IsPureUnit (GetCurrentUnit ())))) goto yyL1;
  {
/* line 486 "Classification.puma" */
   stmt_protocol ("statement not changed in PURE procedure");
  }
  }
   return stmt;
yyL1:;

/* line 490 "Classification.puma" */
  {
/* line 492 "Classification.puma" */
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL2;
  {
/* line 493 "Classification.puma" */
   stmt_protocol ("statement not changed in LOCAL procedure");
  }
  }
   return stmt;
yyL2:;

/* line 503 "Classification.puma" */
  {
/* line 505 "Classification.puma" */
   if (! ((CountMovements (var, exp) == 0))) goto yyL3;
  {
/* line 507 "Classification.puma" */
   stmt_protocol ("local statement");
  }
  }
   return stmt;
yyL3:;

  if (stmt->Kind == kACF_BASIC) {
/* line 521 "Classification.puma" */
  {
/* line 523 "Classification.puma" */
   if (! ((TreeRank (exp) != TreeRank (var)))) goto yyL4;
  {
/* line 524 "Classification.puma" */
   error_protocol ("illegal data movement (rank mismatch)");
  }
  }
   return stmt;
yyL4:;

/* line 529 "Classification.puma" */
  {
/* line 531 "Classification.puma" */
   CheckMovement (var, exp);
/* line 532 "Classification.puma" */
 stmt->Kind = kACF_MOVE; 
/* line 533 "Classification.puma" */
   stmt_protocol ("data movement");
  }
   return stmt;

  }
 yyAbort ("ClassifyAssignment");
 { tTree yyDummy; return yyDummy; }
}

static tTree ClassifyMovement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kMOVE_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->MOVE_STMT.MASK->Kind == kNO_PARAM) {
/* line 550 "Classification.puma" */
  {
/* line 552 "Classification.puma" */
   if (! ((TreeRank (t->ACF_BASIC.BASIC_STMT->MOVE_STMT.TARGET) == 0))) goto yyL1;
  {
/* line 553 "Classification.puma" */
   if (! ((CountMovements (t->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE, t->ACF_BASIC.BASIC_STMT->MOVE_STMT.TARGET) == 0))) goto yyL1;
  {
/* line 555 "Classification.puma" */
 

     t->ACF_BASIC.BASIC_STMT = mASSIGN_STMT (t->ACF_BASIC.BASIC_STMT->MOVE_STMT.TARGET, mVAR_EXP (t->ACF_BASIC.BASIC_STMT->MOVE_STMT.SOURCE));

   
  }
  }
  }
   return MakeMoveBroadcast (t);
yyL1:;

  }
/* line 564 "Classification.puma" */
  {
/* line 566 "Classification.puma" */
 t->Kind = kACF_MOVE; 
  }
   return t;

  }
  }
 yyAbort ("ClassifyMovement");
 { tTree yyDummy; return yyDummy; }
}

static tTree MakeMoveBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
/* line 578 "Classification.puma" */
 {
  tTree new;
  {
/* line 582 "Classification.puma" */
 new = OnOwnership (t, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V);
     new = CombineACF (new, MakeOwnerBroadcast (CopyTree (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR), new));
   
  }
   return new;
 }

  }
  }
  }
 yyAbort ("MakeMoveBroadcast");
 { tTree yyDummy; return yyDummy; }
}

static tTree MakeOwnerBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree on_stmt)
# else
(var, on_stmt)
 register tTree var;
 register tTree on_stmt;
# endif
{
  if (on_stmt->Kind == kACF_ON) {
/* line 597 "Classification.puma" */
   return mACF_BASIC (mBROADCAST_STMT (mBTV_LIST (var, mBTV_EMPTY ()), on_stmt->ACF_ON.ON_HOME, on_stmt->ACF_ON.ON_SPECS));

  }
 yyAbort ("MakeOwnerBroadcast");
 { tTree yyDummy; return yyDummy; }
}

static void VarOwnership
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree * yyP2, register tTree * yyP1)
# else
(var, yyP2, yyP1)
 register tTree var;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
/* line 613 "Classification.puma" */
 {
  var_descriptor owner;
  tTree on_top;
  tTree on_spec;
  rbool found;
  {
/* line 620 "Classification.puma" */
   GetVarDescriptor (var, & found, & owner);
/* line 621 "Classification.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 623 "Classification.puma" */
 

   if (owner.topology_rank < -1 )
     { error_protocol ("illegal ownerhip");
       tree_protocol ("illegal variable is : ", var);
     }

   on_top  = MakeOnTopology (&owner);
   on_spec = MakeOnSpecs   (&owner);
 
  }
  }
   * yyP2 = on_top;
   * yyP1 = on_spec;
   return;
 }
yyL1:;

/* line 635 "Classification.puma" */
  {
/* line 636 "Classification.puma" */
   error_protocol ("problems to get ownership");
/* line 637 "Classification.puma" */
   tree_protocol ("no var descriptor for this variable : ", var);
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static tTree OnOwnership
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree var)
# else
(stmt, var)
 register tTree stmt;
 register tTree var;
# endif
{
/* line 642 "Classification.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 644 "Classification.puma" */
   VarOwnership (var, & yyV1, & yyV2);
  }
   return mACF_ON (yyV1, yyV2, mACF_LIST (stmt, mACF_EMPTY ()));
 }

}

static void CheckMovement
# if defined __STDC__ | defined __cplusplus
(register tTree target_var, register tTree source_exp)
# else
(target_var, source_exp)
 register tTree target_var;
 register tTree source_exp;
# endif
{
 yyRecursion:
  if (source_exp->Kind == kVAR_EXP) {
/* line 657 "Classification.puma" */
  {
/* line 659 "Classification.puma" */
   source_exp = source_exp->VAR_EXP.V;
   goto yyRecursion;
  }

  }
  if (source_exp->Kind == kPERM_EXP) {
  if (source_exp->PERM_EXP.VAL->Kind == kVAR_EXP) {
/* line 662 "Classification.puma" */
  {
/* line 664 "Classification.puma" */
   source_exp = source_exp->PERM_EXP.VAL->VAR_EXP.V;
   goto yyRecursion;
  }

  }
  }
  if (source_exp->Kind == kFUNC_CALL_EXP) {
  if (source_exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (source_exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 667 "Classification.puma" */
  {
/* line 670 "Classification.puma" */
   if (! ((IsIntrCall (source_exp)))) goto yyL3;
  {
/* line 672 "Classification.puma" */
   if (! ((source_exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("TRANSPOSE", 9)))) goto yyL3;
  {
/* line 673 "Classification.puma" */
   source_exp = source_exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V;
   goto yyRecursion;
  }
  }
  }
yyL3:;

  }
  }
  }
  if (source_exp->Kind == kINDEXED_VAR) {
/* line 677 "Classification.puma" */
 {
  rbool okay;
  {
/* line 681 "Classification.puma" */
 okay = IsSameExpType (source_exp, target_var);

     if (!okay)
        { error_protocol ("Movement requires same type");
          tree_protocol ("Source type is ", TreeType (source_exp));
          tree_protocol ("Target type is ", TreeType (target_var));
        }
   
  }
   return;
 }

  }
/* line 691 "Classification.puma" */
  {
/* line 692 "Classification.puma" */
   error_protocol ("illegal movement (could not be classified)");
  }
   return;

;
}

static tTree ClassifyOnStatement
# if defined __STDC__ | defined __cplusplus
(register tTree on_stmt)
# else
(on_stmt)
 register tTree on_stmt;
# endif
{
  if (on_stmt->Kind == kACF_ON) {
/* line 731 "Classification.puma" */
  {
/* line 733 "Classification.puma" */
   set_protocol_stmt (on_stmt);
/* line 735 "Classification.puma" */
 stmt_protocol ("ON classification");

      

      UpdateOnBody (on_stmt->ACF_ON.ON_BODY);  

    
  }
   return on_stmt;

  }
 yyAbort ("ClassifyOnStatement");
 { tTree yyDummy; return yyDummy; }
}

static void UpdateOnBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kACF_ON:
/* line 754 "Classification.puma" */
  {
/* line 755 "Classification.puma" */
   t = t->ACF_ON.ON_BODY;
   goto yyRecursion;
  }

  case kACF_TASK_REGION:
/* line 758 "Classification.puma" */
  {
/* line 760 "Classification.puma" */
   t = t->ACF_TASK_REGION.TASK_BODY;
   goto yyRecursion;
  }

  case kACF_PARALLEL:
/* line 763 "Classification.puma" */
  {
/* line 765 "Classification.puma" */
   t = t->ACF_PARALLEL.PARALLEL_BODY;
   goto yyRecursion;
  }

  case kACF_DO:
/* line 768 "Classification.puma" */
  {
/* line 770 "Classification.puma" */
   if (! ((IsParallelLoop (t)))) goto yyL4;
  {
/* line 772 "Classification.puma" */
   t = t->ACF_DO.DO_BODY;
   goto yyRecursion;
  }
  }
yyL4:;

/* line 817 "Classification.puma" */
  {
/* line 819 "Classification.puma" */
   t = t->ACF_DO.DO_BODY;
   goto yyRecursion;
  }

  case kACF_LIST:
  if (t->ACF_LIST.Elem->Kind == kACF_BASIC) {
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 775 "Classification.puma" */
 {
  tTree param;
  {
/* line 778 "Classification.puma" */
   if (! ((FunctionBecomesSubroutine (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID)))) goto yyL5;
  {
/* line 784 "Classification.puma" */
 param = mVAR_PARAM (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
      t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT  = mCALL_STMT (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_ID, mBTP_LIST (param, t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS));
    
/* line 788 "Classification.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }
  }
 }
yyL5:;

  }
  }
  if (t->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 791 "Classification.puma" */
  {
/* line 795 "Classification.puma" */
 t->ACF_LIST.Elem = ResolveReduce (t->ACF_LIST.Elem); 
/* line 797 "Classification.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  }
/* line 800 "Classification.puma" */
  {
/* line 801 "Classification.puma" */
   UpdateOnBody (t->ACF_LIST.Elem);
/* line 802 "Classification.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kACF_EMPTY:
/* line 805 "Classification.puma" */
   return;

  case kACF_IF:
/* line 808 "Classification.puma" */
  {
/* line 809 "Classification.puma" */
   UpdateOnBody (t->ACF_IF.THEN_PART);
/* line 810 "Classification.puma" */
   t = t->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  case kACF_WHILE:
/* line 813 "Classification.puma" */
  {
/* line 814 "Classification.puma" */
   t = t->ACF_WHILE.WHILE_BODY;
   goto yyRecursion;
  }

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 826 "Classification.puma" */
   return;

  }
/* line 829 "Classification.puma" */
   return;

  case kACF_DUMMY:
/* line 832 "Classification.puma" */
   return;

  }

/* line 835 "Classification.puma" */
  {
/* line 836 "Classification.puma" */
   failure_protocol (MODULE, "UpdateOnBody", t);
  }
   return;

;
}

static void ClassifyRMA
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 847 "Classification.puma" */
  {
/* line 849 "Classification.puma" */
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopRMA, DoRMA); 
  }
   return;

  }
/* line 852 "Classification.puma" */
  {
/* line 853 "Classification.puma" */
   failure_protocol (MODULE, "ClassifyRMA", t);
  }
   return;

;
}

static rbool StopRMA
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 864 "Classification.puma" */
  {
/* line 865 "Classification.puma" */
   return rfalse;
  }

}

static tTree DoRMA
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 870 "Classification.puma" */
   return TranslateRMA (t);

  }
  }
/* line 875 "Classification.puma" */
   return t;

}

void BeginClassification ARGS ((void))
{
}

void CloseClassification ARGS ((void))
{
}
