# include "CheckHome.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 31 "CheckHome.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Transform.h" 
# include "Traverse.h" 

# include "Descriptor.h"
# include "FindHome.h"
# include "Accepted.h"
# include "HomeDescriptor.h"
# include "MoveDescriptor.h"
# include "ParNest.h"

# define MODULE "CheckHome"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCheckHome.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* CheckHome_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CheckHome, routine %s failed\n",
  yyFunction);
 CheckHome_Exit ();
}

void CheckHome ARGS ((tTree t));
static rbool StopCheckHome ARGS ((tTree t));
static tTree DoCheckHome ARGS ((tTree t));
static tTree ValidateHome ARGS ((tTree stmt, pvar outer_home));
static tTree ValidateHomeDirective ARGS ((tTree on_stmt, pvar outer_home));
static tTree RemoveResidentVars ARGS ((tTree stmt));
static tTree PropagateOnDirective ARGS ((tTree body, tTree on_stmt, pvar outer_home));

void CheckHome
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 61 "CheckHome.puma" */
  {
/* line 63 "CheckHome.puma" */
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopCheckHome, DoCheckHome); 
  }
   return;

  }
/* line 66 "CheckHome.puma" */
  {
/* line 67 "CheckHome.puma" */
   failure_protocol (MODULE, "CheckHome", t);
  }
   return;

;
}

static rbool StopCheckHome
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_HOME) {
/* line 80 "CheckHome.puma" */
   return rtrue;

  }
  if (t->Kind == kACF_BASIC) {
/* line 83 "CheckHome.puma" */
   return rtrue;

  }
  if (Tree_IsType (t, kBT_EXP)) {
/* line 86 "CheckHome.puma" */
   return rtrue;

  }
  return rfalse;
}

static tTree DoCheckHome
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_HOME) {
/* line 99 "CheckHome.puma" */
 {
  var_descriptor home;
  {
/* line 103 "CheckHome.puma" */
   MakeReplicatedDescriptor (& home);
  }
   return ValidateHome (t, & home);
 }

  }
  if (t->Kind == kACF_TASK_REGION) {
/* line 108 "CheckHome.puma" */
 {
  var_descriptor home;
  {
/* line 112 "CheckHome.puma" */
   MakeReplicatedDescriptor (& home);
  }
   return ValidateHome (t, & home);
 }

  }
/* line 117 "CheckHome.puma" */
   return t;

}

static tTree ValidateHome
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar outer_home)
# else
(stmt, outer_home)
 register tTree stmt;
 pvar outer_home;
# endif
{

  switch (stmt->Kind) {
  case kACF_LIST:
/* line 138 "CheckHome.puma" */
 {
  tTree newacf;
  {
/* line 142 "CheckHome.puma" */
   set_protocol_stmt (stmt->ACF_LIST.Elem);
/* line 144 "CheckHome.puma" */
 newacf = ValidateHome (stmt->ACF_LIST.Elem, outer_home);         
     stmt->ACF_LIST.Next   = ValidateHome (stmt->ACF_LIST.Next, outer_home);         
   
/* line 148 "CheckHome.puma" */
   newacf = ReplaceACF (stmt, newacf, stmt->ACF_LIST.Next);
  }
   return newacf;
 }

  case kACF_EMPTY:
/* line 153 "CheckHome.puma" */
   return stmt;

  case kACF_FORALL:
/* line 160 "CheckHome.puma" */
  {
/* line 162 "CheckHome.puma" */
   IncParNesting (stmt);
/* line 164 "CheckHome.puma" */
 stmt->ACF_FORALL.FORALL_BODY = ValidateHome (stmt->ACF_FORALL.FORALL_BODY, outer_home); 
/* line 166 "CheckHome.puma" */
   DecParNesting (stmt);
  }
   return stmt;

  case kACF_DO:
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 171 "CheckHome.puma" */
  {
/* line 173 "CheckHome.puma" */
   IncParNesting (stmt);
/* line 175 "CheckHome.puma" */
 stmt->ACF_DO.DO_BODY = ValidateHome (stmt->ACF_DO.DO_BODY, outer_home); 
/* line 177 "CheckHome.puma" */
   DecParNesting (stmt);
  }
   return stmt;

  }
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 182 "CheckHome.puma" */
  {
/* line 184 "CheckHome.puma" */
 stmt->ACF_DO.DO_BODY = ValidateHome (stmt->ACF_DO.DO_BODY, outer_home); 
  }
   return stmt;

  }
  break;
  case kACF_NEW:
/* line 189 "CheckHome.puma" */
  {
/* line 191 "CheckHome.puma" */
   IncParNesting (stmt);
/* line 193 "CheckHome.puma" */
 stmt->ACF_NEW.NEW_BODY = ValidateHome (stmt->ACF_NEW.NEW_BODY, outer_home); 
/* line 195 "CheckHome.puma" */
   DecParNesting (stmt);
  }
   return stmt;

  case kACF_REDUCTION:
/* line 200 "CheckHome.puma" */
  {
/* line 202 "CheckHome.puma" */
   IncParNesting (stmt);
/* line 204 "CheckHome.puma" */
 stmt->ACF_REDUCTION.REDUCTION_BODY = ValidateHome (stmt->ACF_REDUCTION.REDUCTION_BODY, outer_home); 
/* line 206 "CheckHome.puma" */
   DecParNesting (stmt);
  }
   return stmt;

  case kACF_RESIDENT:
/* line 211 "CheckHome.puma" */
  {
/* line 213 "CheckHome.puma" */
   IncParNesting (stmt);
/* line 215 "CheckHome.puma" */
 stmt->ACF_RESIDENT.RESIDENT_BODY = ValidateHome (stmt->ACF_RESIDENT.RESIDENT_BODY, outer_home); 
/* line 217 "CheckHome.puma" */
   DecParNesting (stmt);
  }
   return stmt;

  case kACF_HOME:
/* line 222 "CheckHome.puma" */
   return ValidateHomeDirective (stmt, outer_home);

  case kACF_IF:
/* line 227 "CheckHome.puma" */
  {
/* line 229 "CheckHome.puma" */
   IncParNesting (stmt);
/* line 231 "CheckHome.puma" */
 stmt->ACF_IF.THEN_PART = ValidateHome (stmt->ACF_IF.THEN_PART, outer_home);
     stmt->ACF_IF.ELSE_PART = ValidateHome (stmt->ACF_IF.ELSE_PART, outer_home);
   
/* line 235 "CheckHome.puma" */
   DecParNesting (stmt);
  }
   return stmt;

  case kACF_TASK_REGION:
/* line 240 "CheckHome.puma" */
  {
/* line 242 "CheckHome.puma" */
   IncParNesting (stmt);
/* line 244 "CheckHome.puma" */
 stmt->ACF_TASK_REGION.TASK_BODY = ValidateHome (stmt->ACF_TASK_REGION.TASK_BODY, outer_home); 
/* line 246 "CheckHome.puma" */
   DecParNesting (stmt);
  }
   return stmt;

  case kACF_WHILE:
/* line 251 "CheckHome.puma" */
  {
/* line 253 "CheckHome.puma" */
   IncParNesting (stmt);
/* line 255 "CheckHome.puma" */
 stmt->ACF_WHILE.WHILE_BODY = ValidateHome (stmt->ACF_WHILE.WHILE_BODY, outer_home); 
/* line 257 "CheckHome.puma" */
   DecParNesting (stmt);
  }
   return stmt;

  case kACF_BASIC:
/* line 262 "CheckHome.puma" */
   return stmt;

  case kACF_DUMMY:
/* line 267 "CheckHome.puma" */
   return stmt;

  }

/* line 272 "CheckHome.puma" */
  {
/* line 274 "CheckHome.puma" */
   failure_protocol (MODULE, "ValidateHome", stmt);
  }
   return NoTree;

}

static tTree ValidateHomeDirective
# if defined __STDC__ | defined __cplusplus
(register tTree on_stmt, pvar outer_home)
# else
(on_stmt, outer_home)
 register tTree on_stmt;
 pvar outer_home;
# endif
{
  if (on_stmt->Kind == kACF_HOME) {
  if (on_stmt->ACF_HOME.HOME_VAR->Kind == kON_VAR_CLAUSE) {
/* line 290 "CheckHome.puma" */
  {
/* line 292 "CheckHome.puma" */
   if (! ((! IsDescriptorVar (on_stmt->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR)))) goto yyL1;
  {
/* line 294 "CheckHome.puma" */
   serious_warning_protocol ("ON directive ignored (no indirection/function allowed in home)");
  }
  }
   return ValidateHome (RemoveResidentVars (on_stmt->ACF_HOME.HOME_BODY), outer_home);
yyL1:;

/* line 308 "CheckHome.puma" */
 {
  var_descriptor new_home;
  {
/* line 314 "CheckHome.puma" */
   SetVarDescriptor (on_stmt->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & new_home);
/* line 316 "CheckHome.puma" */
   if (! ((! IsParallelHomeDescriptor (& new_home)))) goto yyL2;
  {
/* line 318 "CheckHome.puma" */
   serious_warning_protocol ("ON directive ignored (missing parallel loop index(es) in home)");
  }
  }
   return ValidateHome (RemoveResidentVars (on_stmt->ACF_HOME.HOME_BODY), outer_home);
 }
yyL2:;

/* line 332 "CheckHome.puma" */
 {
  var_descriptor new_home;
  {
/* line 338 "CheckHome.puma" */
   SetVarDescriptor (on_stmt->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & new_home);
/* line 340 "CheckHome.puma" */
   if (! ((! VDIsSubSet (& new_home, outer_home)))) goto yyL3;
  {
/* line 342 "CheckHome.puma" */
   serious_warning_protocol ("ON directive ignored (home not subset of outer home");
/* line 344 "CheckHome.puma" */
   tree_protocol ("outer home : ", PrintableDescriptorVar (outer_home));
  }
  }
   return ValidateHome (RemoveResidentVars (on_stmt->ACF_HOME.HOME_BODY), outer_home);
 }
yyL3:;

/* line 360 "CheckHome.puma" */
 {
  var_descriptor new_home;
  var_descriptor min_home;
  var_descriptor good_home;
  {
/* line 368 "CheckHome.puma" */
   SetVarDescriptor (on_stmt->ACF_HOME.HOME_VAR->ON_VAR_CLAUSE.ON_VAR, & new_home);
/* line 372 "CheckHome.puma" */
   IncParNesting (on_stmt);
/* line 374 "CheckHome.puma" */
 on_stmt->ACF_HOME.HOME_BODY = ValidateHome (on_stmt->ACF_HOME.HOME_BODY, &new_home); 
/* line 376 "CheckHome.puma" */
   FindHome (on_stmt->ACF_HOME.HOME_BODY, & min_home, & good_home);
/* line 378 "CheckHome.puma" */
   DecParNesting (on_stmt);
/* line 382 "CheckHome.puma" */
   if (! ((! VDIsSubSet (& min_home, & new_home)))) goto yyL4;
  {
/* line 384 "CheckHome.puma" */
   set_protocol_stmt (on_stmt);
/* line 386 "CheckHome.puma" */
   serious_warning_protocol ("ON directive ignored (home not sufficient)");
/* line 389 "CheckHome.puma" */
   tree_protocol ("outer home : ", PrintableDescriptorVar (outer_home));
/* line 390 "CheckHome.puma" */
   tree_protocol ("min   home : ", PrintableDescriptorVar (& min_home));
/* line 391 "CheckHome.puma" */
   tree_protocol ("good  home : ", PrintableDescriptorVar (& good_home));
  }
  }
   return PropagateOnDirective (on_stmt->ACF_HOME.HOME_BODY, on_stmt, outer_home);
 }
yyL4:;

  }
/* line 400 "CheckHome.puma" */
 {
  var_descriptor min_home;
  var_descriptor good_home;
  {
/* line 405 "CheckHome.puma" */
   IncParNesting (on_stmt);
/* line 407 "CheckHome.puma" */
   FindHome (on_stmt->ACF_HOME.HOME_BODY, & min_home, & good_home);
/* line 409 "CheckHome.puma" */
   DecParNesting (on_stmt);
/* line 411 "CheckHome.puma" */
   set_protocol_stmt (on_stmt);
/* line 413 "CheckHome.puma" */
   stmt_protocol ("on directive is correctly placed");
/* line 414 "CheckHome.puma" */
   tree_protocol ("outer home : ", PrintableDescriptorVar (outer_home));
/* line 415 "CheckHome.puma" */
   tree_protocol ("min   home : ", PrintableDescriptorVar (& min_home));
/* line 416 "CheckHome.puma" */
   tree_protocol ("good  home : ", PrintableDescriptorVar (& good_home));
  }
   return on_stmt;
 }

  }
/* line 421 "CheckHome.puma" */
  {
/* line 423 "CheckHome.puma" */
   failure_protocol (MODULE, "ValidateHomeDirective", on_stmt);
  }
   return NoTree;

}

static tTree RemoveResidentVars
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{

  switch (stmt->Kind) {
  case kACF_LIST:
/* line 443 "CheckHome.puma" */
 {
  tTree newacf;
  {
/* line 447 "CheckHome.puma" */
   set_protocol_stmt (stmt->ACF_LIST.Elem);
/* line 449 "CheckHome.puma" */
 newacf = RemoveResidentVars (stmt->ACF_LIST.Elem);         
     stmt->ACF_LIST.Next   = RemoveResidentVars (stmt->ACF_LIST.Next);         
   
/* line 453 "CheckHome.puma" */
   newacf = ReplaceACF (stmt, newacf, stmt->ACF_LIST.Next);
  }
   return newacf;
 }

  case kACF_EMPTY:
/* line 458 "CheckHome.puma" */
   return stmt;

  case kACF_FORALL:
/* line 463 "CheckHome.puma" */
  {
/* line 465 "CheckHome.puma" */
   IncParNesting (stmt);
/* line 466 "CheckHome.puma" */
 stmt->ACF_FORALL.FORALL_BODY = RemoveResidentVars (stmt->ACF_FORALL.FORALL_BODY); 
/* line 467 "CheckHome.puma" */
   DecParNesting (stmt);
  }
   return stmt;

  case kACF_DO:
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 472 "CheckHome.puma" */
  {
/* line 474 "CheckHome.puma" */
   IncParNesting (stmt);
/* line 475 "CheckHome.puma" */
 stmt->ACF_DO.DO_BODY = RemoveResidentVars (stmt->ACF_DO.DO_BODY); 
/* line 476 "CheckHome.puma" */
   DecParNesting (stmt);
  }
   return stmt;

  }
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 481 "CheckHome.puma" */
  {
/* line 483 "CheckHome.puma" */
 stmt->ACF_DO.DO_BODY = RemoveResidentVars (stmt->ACF_DO.DO_BODY); 
  }
   return stmt;

  }
  break;
  case kACF_NEW:
/* line 488 "CheckHome.puma" */
  {
/* line 490 "CheckHome.puma" */
 stmt->ACF_NEW.NEW_BODY = RemoveResidentVars (stmt->ACF_NEW.NEW_BODY); 
  }
   return stmt;

  case kACF_TASK_REGION:
/* line 495 "CheckHome.puma" */
  {
/* line 497 "CheckHome.puma" */
 stmt->ACF_TASK_REGION.TASK_BODY = RemoveResidentVars (stmt->ACF_TASK_REGION.TASK_BODY); 
  }
   return stmt;

  case kACF_REDUCTION:
/* line 502 "CheckHome.puma" */
  {
/* line 504 "CheckHome.puma" */
 stmt->ACF_REDUCTION.REDUCTION_BODY = RemoveResidentVars (stmt->ACF_REDUCTION.REDUCTION_BODY); 
  }
   return stmt;

  case kACF_RESIDENT:
/* line 509 "CheckHome.puma" */
  {
/* line 511 "CheckHome.puma" */
   serious_warning_protocol ("RESIDENT directive ignored (home changed)");
/* line 513 "CheckHome.puma" */
 stmt->ACF_RESIDENT.RESIDENT_VAR = mBTV_EMPTY();
     stmt->ACF_RESIDENT.RESIDENT_BODY  = RemoveResidentVars (stmt->ACF_RESIDENT.RESIDENT_BODY);
   
  }
   return stmt->ACF_RESIDENT.RESIDENT_BODY;

  case kACF_HOME:
/* line 524 "CheckHome.puma" */
   return stmt;

  case kACF_IF:
/* line 529 "CheckHome.puma" */
  {
/* line 531 "CheckHome.puma" */
 stmt->ACF_IF.THEN_PART = RemoveResidentVars (stmt->ACF_IF.THEN_PART);
     stmt->ACF_IF.ELSE_PART = RemoveResidentVars (stmt->ACF_IF.ELSE_PART);
   
  }
   return stmt;

  case kACF_WHILE:
/* line 538 "CheckHome.puma" */
  {
/* line 540 "CheckHome.puma" */
 stmt->ACF_WHILE.WHILE_BODY = RemoveResidentVars (stmt->ACF_WHILE.WHILE_BODY); 
  }
   return stmt;

  case kACF_BASIC:
/* line 545 "CheckHome.puma" */
   return stmt;

  }

/* line 550 "CheckHome.puma" */
  {
/* line 552 "CheckHome.puma" */
   failure_protocol (MODULE, "RemoveResidentVars", stmt);
  }
   return NoTree;

}

static tTree PropagateOnDirective
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree on_stmt, pvar outer_home)
# else
(body, on_stmt, outer_home)
 register tTree body;
 register tTree on_stmt;
 pvar outer_home;
# endif
{
/* line 582 "CheckHome.puma" */
   return ValidateHome (RemoveResidentVars (body), outer_home);

}

void BeginCheckHome ARGS ((void))
{
}

void CloseCheckHome ARGS ((void))
{
}
