# include "CheckComm.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 39 "CheckComm.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Nesting.h"
# include "ParNest.h"

# include "Descriptor.h"
# include "Extraction.h"

# include "Objects.h"
# include "Rank.h"
# include "VarComm.h"
# include "HomeDescriptor.h"
# include "MoveDescriptor.h"
# include "MoveControl.h"
# include "ExpDescriptor.h"
# include "Accepted.h"        /* IsDescriptorVar */
# include "Loops.h"
# include "IndShadow.h"

# define MODULE "CheckComm"

static int communication_errors;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCheckComm.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* CheckComm_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CheckComm, routine %s failed\n",
  yyFunction);
 CheckComm_Exit ();
}

int CheckCommunication ARGS ((tTree stmt));
int CheckCommunicationExp ARGS ((tTree exp));
static void CheckCommACF ARGS ((tTree stmt, pvar home));
static void CheckCommExp ARGS ((tTree exp, pvar home));
static void CheckCommParams ARGS ((tTree params, pvar home));
static tTree CheckCommVarParam ARGS ((tTree var, int intent, pvar home));
static void CheckCommVarIndexes ARGS ((tTree var, pvar home));
static rbool LocalVarIndexes ARGS ((tTree var, pvar home));
static tTree CheckCommScalarParam ARGS ((tTree var, int intent, pvar home));
static void CheckCommArrayParam ARGS ((pvar vard, int intent, pvar home));
static void CheckCommReduceParams ARGS ((tTree params, pvar home));
static rbool NoReplicatedIndex ARGS ((tTree var));
void GetTheBodyHome ARGS ((tTree s, pvar home));
static void SetLoopHome ARGS ((tTree hvar, pvar home));
rbool IsLocalAssignment ARGS ((tTree var, tTree exp, pvar home));
rbool IsCopyInAssignment ARGS ((tTree var, tTree exp, pvar home));
rbool IsCopyOutAssignment ARGS ((tTree var, tTree exp, pvar home));
static rbool IsLegalIndirect ARGS ((tTree var, pvar home));
static rbool LegalIndexExpression ARGS ((tTree explist, pvar home));
static rbool AcceptedIndirectIndex ARGS ((tTree index_exp, pvar home));

int CheckCommunication
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (Tree_IsType (stmt, kACF_NODE)) {
/* line 80 "CheckComm.puma" */
 {
  var_descriptor home;
  {
/* line 84 "CheckComm.puma" */
   MakeReplicatedDescriptor (& home);
/* line 86 "CheckComm.puma" */
   communication_errors = 0;
/* line 88 "CheckComm.puma" */
   set_protocol_stmt (stmt);
/* line 90 "CheckComm.puma" */
   CheckCommACF (stmt, & home);
  }
   return communication_errors;
 }

  }
/* line 95 "CheckComm.puma" */
  {
/* line 97 "CheckComm.puma" */
   failure_protocol (MODULE, "CheckCommunication", stmt);
  }
   return 1;

}

int CheckCommunicationExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (Tree_IsType (exp, kBT_EXP)) {
/* line 104 "CheckComm.puma" */
 {
  var_descriptor home;
  {
/* line 108 "CheckComm.puma" */
   MakeReplicatedDescriptor (& home);
/* line 110 "CheckComm.puma" */
   communication_errors = 0;
/* line 112 "CheckComm.puma" */
   tree_protocol ("CHECK EXP COMMUNICATION for : ", exp);
/* line 114 "CheckComm.puma" */
   CheckCommExp (exp, & home);
  }
   return communication_errors;
 }

  }
/* line 119 "CheckComm.puma" */
  {
/* line 120 "CheckComm.puma" */
   failure_protocol (MODULE, "CheckCommunicationExp", exp);
  }
   return 1;

}

static void CheckCommACF
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, pvar home)
# else
(stmt, home)
 register tTree stmt;
 pvar home;
# endif
{
 yyRecursion:

  switch (stmt->Kind) {
  case kACF_LIST:
/* line 135 "CheckComm.puma" */
  {
/* line 137 "CheckComm.puma" */
   set_protocol_stmt (stmt->ACF_LIST.Elem);
/* line 139 "CheckComm.puma" */
   CheckCommACF (stmt->ACF_LIST.Elem, home);
/* line 140 "CheckComm.puma" */
   stmt = stmt->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kACF_EMPTY:
/* line 143 "CheckComm.puma" */
   return;

  case kACF_DUMMY:
/* line 146 "CheckComm.puma" */
   return;

  case kACF_HOME:
/* line 155 "CheckComm.puma" */
 {
  var_descriptor body_home;
  {
/* line 159 "CheckComm.puma" */
   GetTheBodyHome (stmt, & body_home);
/* line 161 "CheckComm.puma" */
   IncParNesting (stmt);
/* line 162 "CheckComm.puma" */
   CheckCommACF (stmt->ACF_HOME.HOME_BODY, & body_home);
/* line 163 "CheckComm.puma" */
   DecParNesting (stmt);
  }
   return;
 }

  case kACF_DO:
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 172 "CheckComm.puma" */
 {
  var_descriptor body_home;
  {
/* line 175 "CheckComm.puma" */
   CheckCommExp (stmt->ACF_DO.DO_RANGE, home);
/* line 179 "CheckComm.puma" */
   GetTheBodyHome (stmt, & body_home);
/* line 181 "CheckComm.puma" */
   IncParNesting (stmt);
/* line 182 "CheckComm.puma" */
   CheckCommACF (stmt->ACF_DO.DO_BODY, & body_home);
/* line 183 "CheckComm.puma" */
   DecParNesting (stmt);
  }
   return;
 }

  }
  if (stmt->ACF_DO.DO_DEP_INFO->Kind == kSERIAL_INFO) {
/* line 192 "CheckComm.puma" */
  {
/* line 194 "CheckComm.puma" */
   CheckCommExp (stmt->ACF_DO.DO_RANGE, home);
/* line 196 "CheckComm.puma" */
   IncParNesting (stmt);
/* line 197 "CheckComm.puma" */
   CheckCommACF (stmt->ACF_DO.DO_BODY, home);
/* line 198 "CheckComm.puma" */
   DecParNesting (stmt);
  }
   return;

  }
  break;
  case kACF_FORALL:
/* line 209 "CheckComm.puma" */
 {
  var_descriptor body_home;
  {
/* line 211 "CheckComm.puma" */
   CheckCommExp (stmt->ACF_FORALL.FORALL_RANGE, home);
/* line 215 "CheckComm.puma" */
   GetTheBodyHome (stmt, & body_home);
/* line 217 "CheckComm.puma" */
   IncParNesting (stmt);
/* line 218 "CheckComm.puma" */
   CheckCommACF (stmt->ACF_FORALL.FORALL_BODY, & body_home);
/* line 219 "CheckComm.puma" */
   DecParNesting (stmt);
  }
   return;
 }

  case kACF_NEW:
/* line 228 "CheckComm.puma" */
  {
/* line 230 "CheckComm.puma" */
   IncParNesting (stmt);
/* line 231 "CheckComm.puma" */
   CheckCommACF (stmt->ACF_NEW.NEW_BODY, home);
/* line 232 "CheckComm.puma" */
   DecParNesting (stmt);
  }
   return;

  case kACF_RESIDENT:
/* line 241 "CheckComm.puma" */
  {
/* line 243 "CheckComm.puma" */
   IncParNesting (stmt);
/* line 244 "CheckComm.puma" */
   CheckCommACF (stmt->ACF_RESIDENT.RESIDENT_BODY, home);
/* line 245 "CheckComm.puma" */
   DecParNesting (stmt);
  }
   return;

  case kACF_TASK_REGION:
/* line 254 "CheckComm.puma" */
  {
/* line 256 "CheckComm.puma" */
   IncParNesting (stmt);
/* line 257 "CheckComm.puma" */
   CheckCommACF (stmt->ACF_TASK_REGION.TASK_BODY, home);
/* line 258 "CheckComm.puma" */
   DecParNesting (stmt);
  }
   return;

  case kACF_REDUCTION:
/* line 267 "CheckComm.puma" */
  {
/* line 269 "CheckComm.puma" */
   IncParNesting (stmt);
/* line 270 "CheckComm.puma" */
   CheckCommACF (stmt->ACF_REDUCTION.REDUCTION_BODY, home);
/* line 271 "CheckComm.puma" */
   DecParNesting (stmt);
  }
   return;

  case kACF_WHILE:
/* line 280 "CheckComm.puma" */
  {
/* line 282 "CheckComm.puma" */
   IncParNesting (stmt);
/* line 283 "CheckComm.puma" */
   CheckCommExp (stmt->ACF_WHILE.WHILE_EXP, home);
/* line 284 "CheckComm.puma" */
   CheckCommACF (stmt->ACF_WHILE.WHILE_BODY, home);
/* line 285 "CheckComm.puma" */
   DecParNesting (stmt);
  }
   return;

  case kACF_IF:
/* line 294 "CheckComm.puma" */
  {
/* line 296 "CheckComm.puma" */
   CheckCommExp (stmt->ACF_IF.IF_EXP, home);
/* line 298 "CheckComm.puma" */
   IncParNesting (stmt);
/* line 299 "CheckComm.puma" */
   CheckCommACF (stmt->ACF_IF.THEN_PART, home);
/* line 300 "CheckComm.puma" */
   CheckCommACF (stmt->ACF_IF.ELSE_PART, home);
/* line 301 "CheckComm.puma" */
   DecParNesting (stmt);
  }
   return;

  case kACF_BASIC:

  switch (stmt->ACF_BASIC.BASIC_STMT->Kind) {
  case kREDUCE_STMT:
/* line 310 "CheckComm.puma" */
  {
/* line 312 "CheckComm.puma" */
   CheckCommReduceParams (stmt->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS, home);
  }
   return;

  case kCALL_STMT:
/* line 321 "CheckComm.puma" */
  {
/* line 325 "CheckComm.puma" */
   CheckCommParams (stmt->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, home);
  }
   return;

  case kASSIGN_STMT:
  if (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 334 "CheckComm.puma" */
 {
  tTree new;
  {
/* line 338 "CheckComm.puma" */
 new = CheckWriteComm (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, home); 

     CheckCommVarIndexes (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, home);

     CheckCommParams (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, home);

     if (TreeRank (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR) == 0)
        CheckCommScalarParam (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, IntentOut, home);
      else

        { var_descriptor vard;
          SetVarDescriptor (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, &vard);
          if ((!IsNewVariable (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR)) && (!IsResidentVariable (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR)))
             CheckCommArrayParam (&vard, IntentOut, home);
        }

     if (new == NoTree) communication_errors++;

        else stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = new;   
   
  }
   return;
 }

  }
/* line 366 "CheckComm.puma" */
 {
  tTree new;
  {
/* line 370 "CheckComm.puma" */
 new = CheckWriteComm (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, home); 
/* line 372 "CheckComm.puma" */
   CheckCommVarIndexes (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, home);
/* line 373 "CheckComm.puma" */
   CheckCommExp (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, home);
/* line 375 "CheckComm.puma" */
 if (IsLocalAssignment (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, home))
        tree_protocol ("LOCAL   : ", stmt->ACF_BASIC.BASIC_STMT);
      else if (IsCopyInAssignment (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, home))
        tree_protocol ("COPY IN : ", stmt->ACF_BASIC.BASIC_STMT);
      else if (IsCopyOutAssignment (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, home))
        tree_protocol ("COPY OUT: ", stmt->ACF_BASIC.BASIC_STMT);

     if (new == NoTree) communication_errors++;

       else stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = new;  
   
  }
   return;
 }

  case kIO_STMT:
/* line 394 "CheckComm.puma" */
  {
/* line 396 "CheckComm.puma" */
   CheckCommParams (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS, home);
  }
   return;

  case kALLOCATE_STMT:
/* line 399 "CheckComm.puma" */
   return;

  case kDEALLOCATE_STMT:
/* line 402 "CheckComm.puma" */
   return;

  case kCREATE_DSP_STMT:
/* line 405 "CheckComm.puma" */
   return;

  case kFREE_DSP_STMT:
/* line 408 "CheckComm.puma" */
   return;

  case kCOMP_IF_STMT:
/* line 411 "CheckComm.puma" */
  {
/* line 413 "CheckComm.puma" */
   CheckCommExp (stmt->ACF_BASIC.BASIC_STMT->COMP_IF_STMT.IF_EXP, home);
  }
   return;

  }

  break;
  }

/* line 416 "CheckComm.puma" */
  {
/* line 418 "CheckComm.puma" */
   if (! ((IsReplicatedDescriptor (home)))) goto yyL24;
  }
   return;
yyL24:;

/* line 421 "CheckComm.puma" */
  {
/* line 423 "CheckComm.puma" */
   serious_warning_protocol ("this statement in parallel loop not supported");
/* line 425 "CheckComm.puma" */
   communication_errors = communication_errors + 1;
  }
   return;

;
}

static void CheckCommExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar home)
# else
(exp, home)
 register tTree exp;
 pvar home;
# endif
{
 yyRecursion:

  switch (exp->Kind) {
  case kDUMMY_EXP:
/* line 438 "CheckComm.puma" */
   return;

  case kCONST_EXP:
/* line 441 "CheckComm.puma" */
   return;

  case kBOUND_EXP:
/* line 444 "CheckComm.puma" */
   return;

  case kRANK_EXP:
/* line 447 "CheckComm.puma" */
   return;

  case kOP_EXP:
/* line 450 "CheckComm.puma" */
  {
/* line 452 "CheckComm.puma" */
   CheckCommExp (exp->OP_EXP.OPND1, home);
/* line 453 "CheckComm.puma" */
   exp = exp->OP_EXP.OPND2;
   goto yyRecursion;
  }

  case kOP1_EXP:
/* line 456 "CheckComm.puma" */
  {
/* line 458 "CheckComm.puma" */
   exp = exp->OP1_EXP.OPND;
   goto yyRecursion;
  }

  case kFUNC_CALL_EXP:
/* line 461 "CheckComm.puma" */
  {
/* line 463 "CheckComm.puma" */
   if (! ((IsPureCall (exp)))) goto yyL7;
  {
/* line 465 "CheckComm.puma" */
   CheckCommParams (exp->FUNC_CALL_EXP.FUNC_PARAMS, home);
  }
  }
   return;
yyL7:;

/* line 468 "CheckComm.puma" */
  {
/* line 470 "CheckComm.puma" */
   if (! ((IsSerialCall (exp)))) goto yyL8;
  {
/* line 472 "CheckComm.puma" */
   CheckCommParams (exp->FUNC_CALL_EXP.FUNC_PARAMS, home);
  }
  }
   return;
yyL8:;

/* line 475 "CheckComm.puma" */
  {
/* line 477 "CheckComm.puma" */
   if (! ((IsStmtCall (exp)))) goto yyL9;
  {
/* line 479 "CheckComm.puma" */
   CheckCommParams (exp->FUNC_CALL_EXP.FUNC_PARAMS, home);
  }
  }
   return;
yyL9:;

/* line 482 "CheckComm.puma" */
  {
/* line 484 "CheckComm.puma" */
   CheckCommParams (exp->FUNC_CALL_EXP.FUNC_PARAMS, home);
  }
   return;

  case kTYPE_EXP:
/* line 501 "CheckComm.puma" */
  {
/* line 503 "CheckComm.puma" */
   exp = exp->TYPE_EXP.ELEMENTS;
   goto yyRecursion;
  }

  case kARRAY_EXP:
/* line 512 "CheckComm.puma" */
  {
/* line 514 "CheckComm.puma" */
   exp = exp->ARRAY_EXP.ELEMENTS;
   goto yyRecursion;
  }

  case kBTE_LIST:
/* line 517 "CheckComm.puma" */
  {
/* line 519 "CheckComm.puma" */
   CheckCommExp (exp->BTE_LIST.Elem, home);
/* line 520 "CheckComm.puma" */
   exp = exp->BTE_LIST.Next;
   goto yyRecursion;
  }

  case kBTE_EMPTY:
/* line 523 "CheckComm.puma" */
   return;

  case kSLICE_EXP:
/* line 526 "CheckComm.puma" */
  {
/* line 528 "CheckComm.puma" */
   CheckCommExp (exp->SLICE_EXP.FIRST, home);
/* line 529 "CheckComm.puma" */
   CheckCommExp (exp->SLICE_EXP.STOP, home);
/* line 530 "CheckComm.puma" */
   exp = exp->SLICE_EXP.INC;
   goto yyRecursion;
  }

  case kDO_EXP:
/* line 533 "CheckComm.puma" */
  {
/* line 535 "CheckComm.puma" */
   CheckCommExp (exp->DO_EXP.RANGE, home);
/* line 537 "CheckComm.puma" */
   IncParNesting (exp);
/* line 538 "CheckComm.puma" */
   CheckCommExp (exp->DO_EXP.BODY, home);
/* line 539 "CheckComm.puma" */
   DecParNesting (exp);
  }
   return;

  case kVAR_EXP:
/* line 542 "CheckComm.puma" */
 {
  tTree new;
  {
/* line 544 "CheckComm.puma" */
   CheckCommVarIndexes (exp->VAR_EXP.V, home);
/* line 548 "CheckComm.puma" */
 new = CheckReadComm (exp->VAR_EXP.V, home);

     if (new == NoTree)
        communication_errors ++;
      else
        exp->VAR_EXP.V = new;   
   
  }
   return;
 }

  }

/* line 557 "CheckComm.puma" */
  {
/* line 559 "CheckComm.puma" */
   serious_warning_protocol ("illegal expression found");
/* line 560 "CheckComm.puma" */
   tree_protocol ("illegal expresion = ", exp);
/* line 562 "CheckComm.puma" */
   communication_errors = communication_errors + 1;
  }
   return;

;
}

static void CheckCommParams
# if defined __STDC__ | defined __cplusplus
(register tTree params, pvar home)
# else
(params, home)
 register tTree params;
 pvar home;
# endif
{
 yyRecursion:
  if (params->Kind == kBTP_LIST) {
/* line 573 "CheckComm.puma" */
  {
/* line 575 "CheckComm.puma" */
   CheckCommParams (params->BTP_LIST.Elem, home);
/* line 576 "CheckComm.puma" */
   params = params->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  if (params->Kind == kBTP_EMPTY) {
/* line 579 "CheckComm.puma" */
   return;

  }
  if (params->Kind == kVAR_PARAM) {
  if (params->VAR_PARAM.V->Kind == kADDR) {
/* line 582 "CheckComm.puma" */
  {
/* line 584 "CheckComm.puma" */
   CheckCommExp (params->VAR_PARAM.V->ADDR.E, home);
  }
   return;

  }
/* line 589 "CheckComm.puma" */
  {
/* line 591 "CheckComm.puma" */
 params->VAR_PARAM.V = CheckCommVarParam (params->VAR_PARAM.V, params->VAR_PARAM.intent, home); 
  }
   return;

  }
  if (params->Kind == kNO_PARAM) {
/* line 594 "CheckComm.puma" */
   return;

  }
  if (params->Kind == kFUNC_PARAM) {
/* line 597 "CheckComm.puma" */
   return;

  }
  if (params->Kind == kPROC_PARAM) {
/* line 600 "CheckComm.puma" */
   return;

  }
/* line 603 "CheckComm.puma" */
  {
/* line 605 "CheckComm.puma" */
   serious_warning_protocol ("illegal parameter found");
/* line 606 "CheckComm.puma" */
   tree_protocol ("illegal parameter is : ", params);
/* line 608 "CheckComm.puma" */
   communication_errors = communication_errors + 1;
  }
   return;

;
}

static tTree CheckCommVarParam
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int intent, pvar home)
# else
(var, intent, home)
 register tTree var;
 register int intent;
 pvar home;
# endif
{
  if (var->Kind == kDO_VAR) {
/* line 620 "CheckComm.puma" */
  {
/* line 622 "CheckComm.puma" */
   IncParNesting (var);
/* line 623 "CheckComm.puma" */
 var->DO_VAR.BODY = CheckCommVarParam (var->DO_VAR.BODY, intent, home); 
/* line 624 "CheckComm.puma" */
   DecParNesting (var);
  }
   return var;

  }
  if (var->Kind == kBTV_LIST) {
/* line 629 "CheckComm.puma" */
  {
/* line 631 "CheckComm.puma" */
 var->BTV_LIST.Elem = CheckCommVarParam (var->BTV_LIST.Elem, intent, home); 
      var->BTV_LIST.Next = CheckCommVarParam (var->BTV_LIST.Next, intent, home);
    
  }
   return var;

  }
  if (var->Kind == kBTV_EMPTY) {
/* line 638 "CheckComm.puma" */
   return var;

  }
/* line 643 "CheckComm.puma" */
  {
/* line 645 "CheckComm.puma" */
   if (! ((IsNewVariable (var)))) goto yyL4;
  }
   return var;
yyL4:;

/* line 650 "CheckComm.puma" */
  {
/* line 652 "CheckComm.puma" */
   if (! ((IsResidentVariable (var)))) goto yyL5;
  }
   return var;
yyL5:;

/* line 657 "CheckComm.puma" */
  {
/* line 659 "CheckComm.puma" */
   if (! ((TreeRank (var) == 0))) goto yyL6;
  {
/* line 661 "CheckComm.puma" */
   CheckCommVarIndexes (var, home);
  }
  }
   return CheckCommScalarParam (var, intent, home);
yyL6:;

/* line 666 "CheckComm.puma" */
 {
  var_descriptor vard;
  {
/* line 668 "CheckComm.puma" */
   CheckCommVarIndexes (var, home);
/* line 672 "CheckComm.puma" */
   SetVarDescriptor (var, & vard);
/* line 681 "CheckComm.puma" */
   CheckCommArrayParam (& vard, intent, home);
  }
   return var;
 }

}

static void CheckCommVarIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
 yyRecursion:
  if (var->Kind == kREMOTE_VAR) {
/* line 694 "CheckComm.puma" */
  {
/* line 696 "CheckComm.puma" */
   var = var->REMOTE_VAR.VAR;
   goto yyRecursion;
  }

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 699 "CheckComm.puma" */
  {
/* line 701 "CheckComm.puma" */
   var = var->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;
  }

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 704 "CheckComm.puma" */
  {
/* line 706 "CheckComm.puma" */
   CheckCommVarIndexes (var->INDEXED_VAR.IND_VAR, home);
/* line 707 "CheckComm.puma" */
   CheckCommExp (var->INDEXED_VAR.IND_EXPS, home);
  }
   return;

  }
  if (var->Kind == kSUBSTRING_VAR) {
/* line 710 "CheckComm.puma" */
  {
/* line 712 "CheckComm.puma" */
   CheckCommVarIndexes (var->SUBSTRING_VAR.IND_VAR, home);
/* line 713 "CheckComm.puma" */
   CheckCommExp (var->SUBSTRING_VAR.IND_EXP, home);
  }
   return;

  }
  if (var->Kind == kUSED_VAR) {
/* line 716 "CheckComm.puma" */
   return;

  }
  if (var->Kind == kLOOP_VAR) {
/* line 719 "CheckComm.puma" */
   return;

  }
/* line 722 "CheckComm.puma" */
  {
/* line 724 "CheckComm.puma" */
   failure_protocol (MODULE, "CheckCommVarIndexes", var);
  }
   return;

;
}

static rbool LocalVarIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
  if (var->Kind == kSELECTED_VAR) {
/* line 735 "CheckComm.puma" */
  {
/* line 737 "CheckComm.puma" */
   if (! ((LocalVarIndexes (var->SELECTED_VAR.SELEC_VAR, home)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 740 "CheckComm.puma" */
  {
/* line 742 "CheckComm.puma" */
   if (! ((LocalVarIndexes (var->INDEXED_VAR.IND_VAR, home)))) goto yyL2;
  {
/* line 743 "CheckComm.puma" */
   if (! ((! CountCommunication (home, var->INDEXED_VAR.IND_EXPS)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  if (var->Kind == kSUBSTRING_VAR) {
/* line 746 "CheckComm.puma" */
  {
/* line 748 "CheckComm.puma" */
   if (! ((LocalVarIndexes (var->SUBSTRING_VAR.IND_VAR, home)))) goto yyL3;
  {
/* line 749 "CheckComm.puma" */
   if (! ((! CountCommunication (home, var->SUBSTRING_VAR.IND_EXP)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  }
  if (var->Kind == kUSED_VAR) {
/* line 752 "CheckComm.puma" */
   return rtrue;

  }
  if (var->Kind == kLOOP_VAR) {
/* line 755 "CheckComm.puma" */
   return rtrue;

  }
  return rfalse;
}

static tTree CheckCommScalarParam
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int intent, pvar home)
# else
(var, intent, home)
 register tTree var;
 register int intent;
 pvar home;
# endif
{
/* line 769 "CheckComm.puma" */
 {
  tTree new;
  {
/* line 771 "CheckComm.puma" */
   if (! ((intent == IntentIn))) goto yyL1;
  {
/* line 775 "CheckComm.puma" */
 new = CheckReadComm (var, home);
      if (new == NoTree) communication_errors++;
    
  }
  }
   return new;
 }
yyL1:;

/* line 782 "CheckComm.puma" */
 {
  tTree new;
  {
/* line 784 "CheckComm.puma" */
   if (! ((intent == IntentOut))) goto yyL2;
  {
/* line 788 "CheckComm.puma" */
 new = CheckWriteComm (var, home);
      if (new == NoTree) communication_errors++;
    
  }
  }
   return new;
 }
yyL2:;

/* line 795 "CheckComm.puma" */
 {
  tTree new;
  {
/* line 797 "CheckComm.puma" */
 if (intent == IntentNo)
         tree_warning_protocol ("param has no intention : ", var);
    
/* line 803 "CheckComm.puma" */
 new = CheckReadComm (var, home);
      if (new == NoTree) communication_errors++;
        else { new = CheckWriteComm (var, home);
               if (new == NoTree) communication_errors++;
             }
    
  }
   return new;
 }

}

static void CheckCommArrayParam
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int intent, pvar home)
# else
(vard, intent, home)
 pvar vard;
 register int intent;
 pvar home;
# endif
{
/* line 831 "CheckComm.puma" */
  {
/* line 833 "CheckComm.puma" */
   if (! ((IsReplicatedDescriptor (home)))) goto yyL1;
  }
   return;
yyL1:;

/* line 842 "CheckComm.puma" */
  {
/* line 844 "CheckComm.puma" */
   if (! ((VDIsSubSet (vard, home)))) goto yyL2;
  }
   return;
yyL2:;

/* line 847 "CheckComm.puma" */
  {
/* line 849 "CheckComm.puma" */
   if (! ((intent == IntentIn))) goto yyL3;
  {
/* line 850 "CheckComm.puma" */
   if (! ((VDIsOwner (home, vard)))) goto yyL3;
  }
  }
   return;
yyL3:;

/* line 859 "CheckComm.puma" */
  {
/* line 861 "CheckComm.puma" */
   if (! ((IsHostDescriptor (home)))) goto yyL4;
  {
/* line 862 "CheckComm.puma" */
   if (! ((IsReplicatedDescriptor (vard)))) goto yyL4;
  }
  }
   return;
yyL4:;

/* line 865 "CheckComm.puma" */
  {
/* line 867 "CheckComm.puma" */
 

     error_protocol ("array argument not local (unsupported redistribution)");
     tree_protocol ("illegal arg is : ", PrintableDescriptorVar (vard));
   
  }
   return;

;
}

static void CheckCommReduceParams
# if defined __STDC__ | defined __cplusplus
(register tTree params, pvar home)
# else
(params, home)
 register tTree params;
 pvar home;
# endif
{
 yyRecursion:
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 884 "CheckComm.puma" */
 {
  tTree new;
  {
/* line 888 "CheckComm.puma" */
 new = CheckReductionComm  (params->BTP_LIST.Elem->VAR_PARAM.V, home);
     if (new == NoTree) communication_errors++; 
   
/* line 892 "CheckComm.puma" */
   CheckCommVarIndexes (params->BTP_LIST.Elem->VAR_PARAM.V, home);
/* line 893 "CheckComm.puma" */
   CheckCommParams (params->BTP_LIST.Next->BTP_LIST.Elem, home);
/* line 895 "CheckComm.puma" */
   params = params->BTP_LIST.Next->BTP_LIST.Next;
   goto yyRecursion;
  }
 }

  }
  }
  }
  if (params->Kind == kBTP_EMPTY) {
/* line 898 "CheckComm.puma" */
   return;

  }
/* line 901 "CheckComm.puma" */
  {
/* line 903 "CheckComm.puma" */
   error_protocol ("illegal reduce parameter list");
/* line 904 "CheckComm.puma" */
   tree_protocol ("illegal list : ", params);
  }
   return;

;
}

static rbool NoReplicatedIndex
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 930 "CheckComm.puma" */
 {
  rbool okay;
  var_descriptor vard;
  {
/* line 935 "CheckComm.puma" */
   GetVarDescriptor (var, & okay, & vard);
/* line 937 "CheckComm.puma" */
   if (! ((okay))) goto yyL1;
  {
/* line 939 "CheckComm.puma" */
   if (! ((vard . var_tree != NoTree))) goto yyL1;
  {
/* line 941 "CheckComm.puma" */
 int i, n;

     okay = rtrue;

     n = vard.formal_rank;

     for (i=0; i<n; i++)

        { if ((vard.distribution_kind[i] == kSERIAL_DIM) && okay)

             okay = NoParallelLoopIndex (vard.actual_shape[i][0]);

          
        }
   
/* line 957 "CheckComm.puma" */
   if (! ((okay))) goto yyL1;
  }
  }
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

void GetTheBodyHome
# if defined __STDC__ | defined __cplusplus
(register tTree s, pvar home)
# else
(s, home)
 register tTree s;
 pvar home;
# endif
{
  if (s->Kind == kACF_DO) {
  if (s->ACF_DO.DO_HOME_INFO->Kind == kCOMM_INFO) {
/* line 970 "CheckComm.puma" */
  {
/* line 972 "CheckComm.puma" */
   SetLoopHome (s->ACF_DO.DO_HOME_INFO->COMM_INFO.home_var, home);
  }
   return;

  }
  }
  if (s->Kind == kACF_FORALL) {
  if (s->ACF_FORALL.FORALL_HOME_INFO->Kind == kCOMM_INFO) {
/* line 975 "CheckComm.puma" */
  {
/* line 977 "CheckComm.puma" */
   SetLoopHome (s->ACF_FORALL.FORALL_HOME_INFO->COMM_INFO.home_var, home);
  }
   return;

  }
  }
  if (s->Kind == kACF_HOME) {
/* line 980 "CheckComm.puma" */
  {
/* line 982 "CheckComm.puma" */
   MakeClauseDescriptor (s->ACF_HOME.HOME_VAR, home);
  }
   return;

  }
/* line 985 "CheckComm.puma" */
  {
/* line 987 "CheckComm.puma" */
   MakeReplicatedDescriptor (home);
/* line 989 "CheckComm.puma" */
   error_protocol ("should not happen here");
  }
   return;

;
}

static void SetLoopHome
# if defined __STDC__ | defined __cplusplus
(register tTree hvar, pvar home)
# else
(hvar, home)
 register tTree hvar;
 pvar home;
# endif
{
  if (hvar->Kind == kDUMMY_VAR) {
/* line 996 "CheckComm.puma" */
  {
/* line 996 "CheckComm.puma" */
   MakeReplicatedDescriptor (home);
  }
   return;

  }
/* line 997 "CheckComm.puma" */
  {
/* line 997 "CheckComm.puma" */
   SetVarDescriptor (hvar, home);
  }
   return;

;
}

rbool IsLocalAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp, pvar home)
# else
(var, exp, home)
 register tTree var;
 register tTree exp;
 pvar home;
# endif
{
  if (exp->Kind == kVAR_EXP) {
/* line 1014 "CheckComm.puma" */
  {
/* line 1016 "CheckComm.puma" */
   if (! ((LocalVarIndexes (var, home)))) goto yyL1;
  {
/* line 1017 "CheckComm.puma" */
   if (! ((LocalVarIndexes (exp->VAR_EXP.V, home)))) goto yyL1;
  {
/* line 1018 "CheckComm.puma" */
   if (! ((IsLocalVarRead (exp->VAR_EXP.V, home)))) goto yyL1;
  {
/* line 1019 "CheckComm.puma" */
   if (! ((IsLocalVarWrite (var, home)))) goto yyL1;
  }
  }
  }
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

rbool IsCopyInAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp, pvar home)
# else
(var, exp, home)
 register tTree var;
 register tTree exp;
 pvar home;
# endif
{
  if (exp->Kind == kVAR_EXP) {
/* line 1039 "CheckComm.puma" */
  {
/* line 1041 "CheckComm.puma" */
   if (! ((! IsParallelMasked ()))) goto yyL1;
  {
/* line 1043 "CheckComm.puma" */
   if (! ((LocalVarIndexes (var, home)))) goto yyL1;
  {
/* line 1044 "CheckComm.puma" */
   if (! ((LocalVarIndexes (exp->VAR_EXP.V, home)))) goto yyL1;
  {
/* line 1046 "CheckComm.puma" */
   if (! ((IsDescriptorVar (var)))) goto yyL1;
  {
/* line 1047 "CheckComm.puma" */
   if (! ((IsDescriptorVar (exp->VAR_EXP.V)))) goto yyL1;
  {
/* line 1049 "CheckComm.puma" */
   if (! ((! IsIndShadowVariable (exp->VAR_EXP.V, home)))) goto yyL1;
  {
/* line 1050 "CheckComm.puma" */
   if (! ((IsLocalVarGlobal (var, home)))) goto yyL1;
  {
/* line 1051 "CheckComm.puma" */
   if (! ((IsFullParLoopVar (exp->VAR_EXP.V)))) goto yyL1;
  {
/* line 1052 "CheckComm.puma" */
   if (! ((IsFullLoopVar (var)))) goto yyL1;
  }
  }
  }
  }
  }
  }
  }
  }
  }
   return rtrue;
yyL1:;

/* line 1055 "CheckComm.puma" */
  {
/* line 1057 "CheckComm.puma" */
   if (! ((OuterLoops () > 0))) goto yyL2;
  {
/* line 1058 "CheckComm.puma" */
   if (! ((IsLocalVarWrite (var, home)))) goto yyL2;
  {
/* line 1059 "CheckComm.puma" */
   if (! ((IsLegalIndirect (exp->VAR_EXP.V, home)))) goto yyL2;
  {
/* line 1060 "CheckComm.puma" */
   if (! ((! IsLocalVarRead (exp->VAR_EXP.V, home)))) goto yyL2;
  {
/* line 1061 "CheckComm.puma" */
   if (! ((! IsIndShadowVariable (exp->VAR_EXP.V, home)))) goto yyL2;
  }
  }
  }
  }
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

rbool IsCopyOutAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp, pvar home)
# else
(var, exp, home)
 register tTree var;
 register tTree exp;
 pvar home;
# endif
{
  if (exp->Kind == kVAR_EXP) {
/* line 1072 "CheckComm.puma" */
  {
/* line 1074 "CheckComm.puma" */
   if (! ((! IsParallelMasked ()))) goto yyL1;
  {
/* line 1076 "CheckComm.puma" */
   if (! ((IsLocalVarWrite (exp->VAR_EXP.V, home)))) goto yyL1;
  {
/* line 1077 "CheckComm.puma" */
   if (! ((! IsIndShadowVariable (var, home)))) goto yyL1;
  {
/* line 1078 "CheckComm.puma" */
   if (! ((IsDescriptorVar (var)))) goto yyL1;
  {
/* line 1079 "CheckComm.puma" */
   if (! ((IsFullLoopVar (var)))) goto yyL1;
  }
  }
  }
  }
  }
   return rtrue;
yyL1:;

/* line 1082 "CheckComm.puma" */
  {
/* line 1084 "CheckComm.puma" */
   if (! ((OuterLoops () > 0))) goto yyL2;
  {
/* line 1085 "CheckComm.puma" */
   if (! ((IsLocalVarWrite (exp->VAR_EXP.V, home)))) goto yyL2;
  {
/* line 1086 "CheckComm.puma" */
   if (! ((! IsLocalVarWrite (var, home)))) goto yyL2;
  {
/* line 1087 "CheckComm.puma" */
   if (! ((! IsIndShadowVariable (var, home)))) goto yyL2;
  {
/* line 1088 "CheckComm.puma" */
   if (! ((IsLegalIndirect (var, home)))) goto yyL2;
  }
  }
  }
  }
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

static rbool IsLegalIndirect
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 1101 "CheckComm.puma" */
  {
/* line 1103 "CheckComm.puma" */
   if (! ((LegalIndexExpression (var->INDEXED_VAR.IND_EXPS, home)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static rbool LegalIndexExpression
# if defined __STDC__ | defined __cplusplus
(register tTree explist, pvar home)
# else
(explist, home)
 register tTree explist;
 pvar home;
# endif
{
  if (explist->Kind == kBTE_LIST) {
/* line 1108 "CheckComm.puma" */
  {
/* line 1110 "CheckComm.puma" */
   if (! ((AcceptedIndirectIndex (explist->BTE_LIST.Elem, home)))) goto yyL1;
  {
/* line 1111 "CheckComm.puma" */
   if (! ((LegalIndexExpression (explist->BTE_LIST.Next, home)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  if (explist->Kind == kBTE_EMPTY) {
/* line 1114 "CheckComm.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool AcceptedIndirectIndex
# if defined __STDC__ | defined __cplusplus
(register tTree index_exp, pvar home)
# else
(index_exp, home)
 register tTree index_exp;
 pvar home;
# endif
{
  if (index_exp->Kind == kVAR_EXP) {
/* line 1128 "CheckComm.puma" */
  {
/* line 1130 "CheckComm.puma" */
   if (! ((IsLocalVarWrite (index_exp->VAR_EXP.V, home)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
/* line 1133 "CheckComm.puma" */
  {
/* line 1135 "CheckComm.puma" */
   if (! ((TreeRank (index_exp) == 0))) goto yyL2;
  {
/* line 1136 "CheckComm.puma" */
   if (! ((IsParallelInvariant (index_exp)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  return rfalse;
}

void BeginCheckComm ARGS ((void))
{
}

void CloseCheckComm ARGS ((void))
{
}
