# include "ChangeDefs.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 55 "ChangeDefs.puma" */


# include <string.h>

# include "Idents.h"
# include "StringM.h"

# include "Objects.h"
# include "protocol.h"

# include "DefTable.h"
# include "TreeOps.h"
# include "Types.h"
# include "Rank.h"
# include "Nesting.h"

# define MODULE "ChangeDefs"

/*********************************************************************
*                                                                    *
*  void attribute_error_protocol (char msg[], Object obj)            *
*                                                                    *
*  - special error message for illegal attribute                     *
*                                                                    *
*      SELECT attribute already set for VarObject A                  *
*      type attribute illegal for TemplateObject T                   *
*                                                                    *
*********************************************************************/

void attribute_error_protocol (msg, obj)

char msg[]; 
tObject obj;

{ char full_msg [256];
  char string   [60];
  const char *kind_name;

  GetString (obj->Object.Ident, string);
  kind_name = Definitions_NodeName [obj->Kind];
 
  sprintf (full_msg, "%s %s %s", msg, kind_name, string);
  error_protocol (full_msg);
  obj_protocol ("object is : ", obj);

} /* attribute_error_protocol */
   


# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyChangeDefs.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* ChangeDefs_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ChangeDefs, routine %s failed\n",
  yyFunction);
 ChangeDefs_Exit ();
}

tDefinitions GetLocalVarEntity ARGS ((tIdent name, int pos, tDefinitions unit));
static rbool OwnObject ARGS ((tDefinitions obj, tDefinitions unit));
void MakeObjType ARGS ((tTree type, tDefinitions obj));
void MakeObjParameter ARGS ((tTree val, tDefinitions obj));
void MakeObjDimension ARGS ((tTree indexes, tDefinitions obj));
void MakeObjIntent ARGS ((tDefinitions obj, int intent));
void MakeObjOptional ARGS ((tDefinitions obj));
void MakeObjAllocatable ARGS ((tDefinitions obj));
void MakeObjPointer ARGS ((tDefinitions obj));
void MakeObjTarget ARGS ((tDefinitions obj));
void MakeObjPrivate ARGS ((tDefinitions obj));
void MakeObjPublic ARGS ((tDefinitions obj));
void MakeObjShared ARGS ((tDefinitions obj, int kind));
void MakeObjDynamic ARGS ((tDefinitions obj));
void MakeObjTrace ARGS ((tDefinitions obj));
void MakeObjNoDescriptor ARGS ((tDefinitions obj));
void MakeObjTree ARGS ((tDefinitions obj));
void MakeObjShadow ARGS ((tDefinitions obj, tTree shadow_spec));
void MakeObjSelection ARGS ((tDefinitions obj, tTree selection));
void MakeObjInherited ARGS ((tDefinitions obj));
void MakeObjActive ARGS ((tDefinitions obj));
void MakeObjLayout ARGS ((tStringRef kind, tDefinitions obj));
void MakeObjPassBy ARGS ((tStringRef kind, tDefinitions obj));
void MakeObjMapTo ARGS ((tStringRef kind, tDefinitions obj));
void MakeObjCommon ARGS ((tTree decl, tDefinitions obj));
void MakeObjSequential ARGS ((tDefinitions v));
void MakeObjNoSequential ARGS ((tDefinitions v));
void MakeObjSave ARGS ((tDefinitions v));
static tDefinitions MakeNewRoutineObject ARGS ((tTree decl, int kind, tDefinitions unit));
void MakeObjExternal ARGS ((tDefinitions oldobj));
static tDefinitions MakeObjSubroutine ARGS ((tDefinitions oldobj));
static tDefinitions MakeObjFunction ARGS ((tDefinitions oldobj));
static rbool UnUsedDummy ARGS ((tDefinitions obj));
static tTree MakeProcDecl ARGS ((tIdent name, int pos));
static tTree MakeFuncDecl ARGS ((tIdent name, int pos, tTree type));
tDefinitions GetFuncObject ARGS ((tIdent name, tDefinitions unit));
static rbool IsValidFuncObject ARGS ((tDefinitions obj));
tDefinitions GetProcObject ARGS ((tIdent name, tDefinitions unit));
void SetExternalEntry ARGS ((tDefinitions obj));
static tTree SetCompType ARGS ((tDefinitions obj, tTree old_type, tTree new_type));
static tTree NewCompType ARGS ((tTree type, tTree comp));

tDefinitions GetLocalVarEntity
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int pos, register tDefinitions unit)
# else
(name, pos, unit)
 register tIdent name;
 register int pos;
 register tDefinitions unit;
# endif
{
/* line 112 "ChangeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 116 "ChangeDefs.puma" */
   Obj = GetLocalObject (name);
/* line 118 "ChangeDefs.puma" */
 if (Obj == NoObject)
 
       { Obj = MakeNewObject (mVAR_DECL (name, pos, mDUMMY_TYPE ()), unit);
         InsertEntry (Obj);
       }

      else if (!OwnObject (Obj, unit))

      { 

        if (Obj->Object.in == NoObject)
           error_protocol ("cannot attribute intrinsics/externals");
         else
           error_protocol ("cannot attribute objects from other units");

        obj_protocol ("this is used object", Obj);

        

      }

   
  }
   return Obj;
 }

}

static rbool OwnObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions unit)
# else
(obj, unit)
 register tDefinitions obj;
 register tDefinitions unit;
# endif
{
/* line 154 "ChangeDefs.puma" */
  {
/* line 156 "ChangeDefs.puma" */
   if (! ((unit == NoObject))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (obj->Kind == kFuncObject) {
/* line 159 "ChangeDefs.puma" */
  {
/* line 162 "ChangeDefs.puma" */
   if (! ((unit == obj))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
/* line 167 "ChangeDefs.puma" */
  {
/* line 169 "ChangeDefs.puma" */
   if (! ((obj->Object.in == NoObject))) goto yyL3;
  {
/* line 178 "ChangeDefs.puma" */
   return rfalse;
  }
  }
yyL3:;

  if (obj->Object.in->Kind == kRaggedObject) {
/* line 181 "ChangeDefs.puma" */
  {
/* line 183 "ChangeDefs.puma" */
   if (! ((obj->Object.in->RaggedObject.in == unit))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
/* line 186 "ChangeDefs.puma" */
  {
/* line 188 "ChangeDefs.puma" */
   if (! ((obj->Object.in == unit))) goto yyL5;
  }
   return rtrue;
yyL5:;

  return rfalse;
}

void MakeObjType
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tDefinitions obj)
# else
(type, obj)
 register tTree type;
 register tDefinitions obj;
# endif
{
 yyRecursion:
  if (type->Kind == kARRAY_TYPE) {
/* line 205 "ChangeDefs.puma" */
  {
/* line 207 "ChangeDefs.puma" */
   MakeObjDimension (type->ARRAY_TYPE.ARRAY_INDEX_TYPES, obj);
/* line 208 "ChangeDefs.puma" */
   type = type->ARRAY_TYPE.ARRAY_COMP_TYPE;
   goto yyRecursion;
  }

  }
  if (type->Kind == kDUMMY_TYPE) {
/* line 211 "ChangeDefs.puma" */
   return;

  }
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_DECL) {
/* line 214 "ChangeDefs.puma" */
  {
/* line 222 "ChangeDefs.puma" */
 obj->VarObject.decl->VAR_DECL.VAL = SetCompType (obj, obj->VarObject.decl->VAR_DECL.VAL, type); 
  }
   return;

  }
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
/* line 225 "ChangeDefs.puma" */
  {
/* line 227 "ChangeDefs.puma" */
 obj->VarObject.decl->VAR_PARAM_DECL.VAL = SetCompType (obj, obj->VarObject.decl->VAR_PARAM_DECL.VAL, type); 
  }
   return;

  }
  }
  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 230 "ChangeDefs.puma" */
  {
/* line 232 "ChangeDefs.puma" */
 obj->FuncObject.decl->FUNC_DECL.RESULT_TYPE = SetCompType (obj, obj->FuncObject.decl->FUNC_DECL.RESULT_TYPE, type); 
  }
   return;

  }
  }
  if (obj->Kind == kExternalObject) {
  if (obj->ExternalObject.decl->Kind == kEXTERNAL_DECL) {
/* line 235 "ChangeDefs.puma" */
  {
/* line 239 "ChangeDefs.puma" */
 obj->ExternalObject.decl = MakeFuncDecl (obj->ExternalObject.Ident, obj->ExternalObject.decl->EXTERNAL_DECL.Line, type);
      obj->Kind = kFuncObject;
    
  }
   return;

  }
  }
/* line 244 "ChangeDefs.puma" */
  {
/* line 246 "ChangeDefs.puma" */
   attribute_error_protocol ("type attribute illegal for", obj);
  }
   return;

;
}

void MakeObjParameter
# if defined __STDC__ | defined __cplusplus
(register tTree val, register tDefinitions obj)
# else
(val, obj)
 register tTree val;
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_DECL) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
/* line 259 "ChangeDefs.puma" */
  {
/* line 262 "ChangeDefs.puma" */
   obj->VarObject.Kind = mVarParameter (val);
  }
   return;

  }
  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 265 "ChangeDefs.puma" */
  {
/* line 267 "ChangeDefs.puma" */
   attribute_error_protocol ("PARAMETER not allowed for dummy", obj);
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarCommon) {
/* line 270 "ChangeDefs.puma" */
  {
/* line 272 "ChangeDefs.puma" */
   attribute_error_protocol ("PARAMETER not allowed for COMMON", obj);
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarParameter) {
/* line 275 "ChangeDefs.puma" */
  {
/* line 277 "ChangeDefs.puma" */
   attribute_error_protocol ("PARAMETER used twice for", obj);
  }
   return;

  }
  }
/* line 280 "ChangeDefs.puma" */
  {
/* line 282 "ChangeDefs.puma" */
   attribute_error_protocol ("PARAMETER not allowed for", obj);
  }
   return;

;
}

void MakeObjDimension
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register tDefinitions obj)
# else
(indexes, obj)
 register tTree indexes;
 register tDefinitions obj;
# endif
{
/* line 293 "ChangeDefs.puma" */
  {
/* line 295 "ChangeDefs.puma" */
   if (! ((TreeListLength (indexes) > MAX_DIMENSIONS))) goto yyL1;
  {
/* line 296 "ChangeDefs.puma" */
   error_protocol ("too many formal dimensions");
  }
  }
   return;
yyL1:;

/* line 299 "ChangeDefs.puma" */
  {
/* line 301 "ChangeDefs.puma" */
   if (! ((IsArrayType (GetObjectType (obj))))) goto yyL2;
  {
/* line 303 "ChangeDefs.puma" */
   attribute_error_protocol ("DIMENSION already defined for", obj);
  }
  }
   return;
yyL2:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_DECL) {
/* line 306 "ChangeDefs.puma" */
  {
/* line 308 "ChangeDefs.puma" */
 obj->VarObject.decl->VAR_DECL.VAL = mARRAY_TYPE (indexes, obj->VarObject.decl->VAR_DECL.VAL); 
  }
   return;

  }
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
/* line 311 "ChangeDefs.puma" */
  {
/* line 313 "ChangeDefs.puma" */
 obj->VarObject.decl->VAR_PARAM_DECL.VAL = mARRAY_TYPE (indexes, obj->VarObject.decl->VAR_PARAM_DECL.VAL); 
  }
   return;

  }
  }
  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 316 "ChangeDefs.puma" */
  {
/* line 318 "ChangeDefs.puma" */
 obj->FuncObject.decl->FUNC_DECL.RESULT_TYPE = mARRAY_TYPE (indexes, obj->FuncObject.decl->FUNC_DECL.RESULT_TYPE); 
  }
   return;

  }
  }
/* line 321 "ChangeDefs.puma" */
  {
/* line 323 "ChangeDefs.puma" */
   attribute_error_protocol ("DIMENSION illegal for", obj);
  }
   return;

;
}

void MakeObjIntent
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int intent)
# else
(obj, intent)
 register tDefinitions obj;
 register int intent;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 334 "ChangeDefs.puma" */
  {
/* line 336 "ChangeDefs.puma" */
   if (! ((obj->VarObject.Kind->VarDummy.Intent != IntentNo))) goto yyL1;
  {
/* line 338 "ChangeDefs.puma" */
   attribute_error_protocol ("INTENT attribute already set for", obj);
  }
  }
   return;
yyL1:;

/* line 341 "ChangeDefs.puma" */
  {
/* line 343 "ChangeDefs.puma" */
 obj->VarObject.Kind->VarDummy.Intent = intent;
  }
   return;

  }
  }
/* line 346 "ChangeDefs.puma" */
  {
/* line 348 "ChangeDefs.puma" */
   attribute_error_protocol ("INTENT attribute illegal for", obj);
  }
   return;

;
}

void MakeObjOptional
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 359 "ChangeDefs.puma" */
  {
/* line 361 "ChangeDefs.puma" */
   if (! ((obj->VarObject.Kind->VarDummy.optional))) goto yyL1;
  {
/* line 363 "ChangeDefs.puma" */
   attribute_error_protocol ("OPTIONAL already set for", obj);
  }
  }
   return;
yyL1:;

/* line 366 "ChangeDefs.puma" */
  {
/* line 368 "ChangeDefs.puma" */
 obj->VarObject.Kind->VarDummy.optional = rtrue; 
  }
   return;

  }
  }
/* line 371 "ChangeDefs.puma" */
  {
/* line 373 "ChangeDefs.puma" */
   attribute_error_protocol ("OPTIONAL illegal for", obj);
  }
   return;

;
}

void MakeObjAllocatable
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 387 "ChangeDefs.puma" */
  {
/* line 389 "ChangeDefs.puma" */
   if (! ((obj->VarObject.Kind->VarDummy.function != NoTree))) goto yyL1;
  {
/* line 391 "ChangeDefs.puma" */
   attribute_error_protocol ("function result cannot have ALLOCATABLE attribute", obj);
  }
  }
   return;
yyL1:;

/* line 395 "ChangeDefs.puma" */
  {
/* line 397 "ChangeDefs.puma" */
   error_protocol ("dummy argument cannot have ALLOCATABLE attribute");
/* line 398 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
   return;

  }
/* line 401 "ChangeDefs.puma" */
  {
/* line 403 "ChangeDefs.puma" */
   if (! ((obj->VarObject.arr_kind == arr_pointer))) goto yyL3;
  {
/* line 405 "ChangeDefs.puma" */
   error_protocol ("ALLOCATABLE attribute must not be used with POINTER");
/* line 406 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL3:;

/* line 409 "ChangeDefs.puma" */
  {
/* line 411 "ChangeDefs.puma" */
   if (! ((obj->VarObject.arr_kind == arr_allocatable))) goto yyL4;
  {
/* line 413 "ChangeDefs.puma" */
   error_protocol ("object has already ALLOCATABLE attribute");
/* line 414 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL4:;

/* line 417 "ChangeDefs.puma" */
  {
/* line 419 "ChangeDefs.puma" */
 obj->VarObject.arr_kind = arr_allocatable; 
  }
   return;

  }
/* line 422 "ChangeDefs.puma" */
  {
/* line 424 "ChangeDefs.puma" */
   error_protocol ("object cannot have ALLOCATABLE attribute");
/* line 425 "ChangeDefs.puma" */
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjPointer
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 436 "ChangeDefs.puma" */
  {
/* line 438 "ChangeDefs.puma" */
   if (! ((obj->VarObject.Kind->VarDummy.function == NoTree))) goto yyL1;
  {
/* line 439 "ChangeDefs.puma" */
   if (! ((obj->VarObject.Kind->VarDummy.Intent != IntentNo))) goto yyL1;
  {
/* line 441 "ChangeDefs.puma" */
   serious_warning_protocol ("POINTER shall not be specified with INTENT");
/* line 442 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
/* line 444 "ChangeDefs.puma" */
   goto yyL1;
  }
  }
  }
yyL1:;

  }
/* line 447 "ChangeDefs.puma" */
  {
/* line 449 "ChangeDefs.puma" */
   if (! ((obj->VarObject.arr_kind == arr_allocatable))) goto yyL2;
  {
/* line 451 "ChangeDefs.puma" */
   error_protocol ("POINTER shall not be specified with ALLOCATABLE");
/* line 452 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL2:;

/* line 455 "ChangeDefs.puma" */
  {
/* line 457 "ChangeDefs.puma" */
   if (! ((obj->VarObject.target))) goto yyL3;
  {
/* line 459 "ChangeDefs.puma" */
   error_protocol ("POINTER shall not be specified with TARGET");
/* line 460 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL3:;

/* line 463 "ChangeDefs.puma" */
  {
/* line 465 "ChangeDefs.puma" */
   if (! ((obj->VarObject.arr_kind == arr_pointer))) goto yyL4;
  {
/* line 467 "ChangeDefs.puma" */
   error_protocol ("object has already POINTER attribute");
/* line 468 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL4:;

/* line 471 "ChangeDefs.puma" */
  {
/* line 473 "ChangeDefs.puma" */
 obj->VarObject.arr_kind = arr_pointer; 
  }
   return;

  }
/* line 476 "ChangeDefs.puma" */
  {
/* line 477 "ChangeDefs.puma" */
   error_protocol ("object cannot have POINTER attribute");
/* line 478 "ChangeDefs.puma" */
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjTarget
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarParameter) {
/* line 489 "ChangeDefs.puma" */
  {
/* line 491 "ChangeDefs.puma" */
   attribute_error_protocol ("TARGET shall not be specified with PARAMETER:", obj);
/* line 494 "ChangeDefs.puma" */
   goto yyL1;
  }
yyL1:;

  }
/* line 497 "ChangeDefs.puma" */
  {
/* line 499 "ChangeDefs.puma" */
   if (! ((obj->VarObject.arr_kind == arr_pointer))) goto yyL2;
  {
/* line 501 "ChangeDefs.puma" */
   attribute_error_protocol ("TARGET shall not be specified with POINTER:", obj);
/* line 504 "ChangeDefs.puma" */
   goto yyL2;
  }
  }
yyL2:;

/* line 507 "ChangeDefs.puma" */
  {
/* line 509 "ChangeDefs.puma" */
   if (! ((obj->VarObject.target))) goto yyL3;
  {
/* line 511 "ChangeDefs.puma" */
   attribute_error_protocol ("TARGET attribute specified twice:", obj);
  }
  }
   return;
yyL3:;

/* line 514 "ChangeDefs.puma" */
  {
/* line 516 "ChangeDefs.puma" */
 obj->VarObject.target = rtrue; 
  }
   return;

  }
/* line 519 "ChangeDefs.puma" */
  {
/* line 521 "ChangeDefs.puma" */
   attribute_error_protocol ("TARGET attribute illegal for:");
  }
   return;

;
}

void MakeObjPrivate
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 532 "ChangeDefs.puma" */
  {
/* line 534 "ChangeDefs.puma" */
   if (! ((obj->Object.private != Default))) goto yyL1;
  {
/* line 536 "ChangeDefs.puma" */
   error_protocol ("object has already been defined PUBLIC/PRIVATE");
  }
  }
   return;
yyL1:;

/* line 539 "ChangeDefs.puma" */
  {
/* line 541 "ChangeDefs.puma" */
   obj->Object.private = Private;
  }
   return;

;
}

void MakeObjPublic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 546 "ChangeDefs.puma" */
  {
/* line 548 "ChangeDefs.puma" */
   if (! ((obj->Object.private != Default))) goto yyL1;
  {
/* line 550 "ChangeDefs.puma" */
   error_protocol ("object has already been defined PUBLIC/PRIVATE");
  }
  }
   return;
yyL1:;

/* line 553 "ChangeDefs.puma" */
  {
/* line 555 "ChangeDefs.puma" */
   obj->Object.private = Public;
  }
   return;

;
}

void MakeObjShared
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int kind)
# else
(obj, kind)
 register tDefinitions obj;
 register int kind;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 570 "ChangeDefs.puma" */
  {
/* line 572 "ChangeDefs.puma" */
   if (! ((obj->VarObject.Dist->Mapping.shared != kDEFAULT_SHARED))) goto yyL1;
  {
/* line 573 "ChangeDefs.puma" */
   error_protocol ("object has already SHARED attribute");
/* line 574 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL1:;

  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 577 "ChangeDefs.puma" */
  {
/* line 579 "ChangeDefs.puma" */
 obj->VarObject.Dist->Mapping.shared = kind; 
  }
   return;

  }
/* line 582 "ChangeDefs.puma" */
  {
/* line 584 "ChangeDefs.puma" */
   if (! ((kind == kIS_SHARED))) goto yyL3;
  {
/* line 586 "ChangeDefs.puma" */
   error_protocol ("* SHARED attribute only for dummy");
/* line 587 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL3:;

/* line 590 "ChangeDefs.puma" */
  {
/* line 592 "ChangeDefs.puma" */
 obj->VarObject.Dist->Mapping.shared = kind; 
  }
   return;

  }
/* line 595 "ChangeDefs.puma" */
  {
/* line 596 "ChangeDefs.puma" */
   error_protocol ("object cannot be shared");
/* line 597 "ChangeDefs.puma" */
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjDynamic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 610 "ChangeDefs.puma" */
  {
/* line 612 "ChangeDefs.puma" */
   if (! ((IsVarAssumedSize (obj)))) goto yyL1;
  {
/* line 614 "ChangeDefs.puma" */
   error_protocol ("DYNAMIC attribute not allowed for assumed size arrays");
/* line 615 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL1:;

  if (obj->Kind == kVarObject) {
/* line 618 "ChangeDefs.puma" */
  {
/* line 620 "ChangeDefs.puma" */
   if (! ((obj->VarObject.Dist->Mapping.dynamic))) goto yyL2;
  {
/* line 622 "ChangeDefs.puma" */
   error_protocol ("object is already DYNAMIC");
/* line 623 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL2:;

/* line 626 "ChangeDefs.puma" */
  {
/* line 628 "ChangeDefs.puma" */
 obj->VarObject.Dist->Mapping.dynamic = 1; 
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
/* line 631 "ChangeDefs.puma" */
  {
/* line 633 "ChangeDefs.puma" */
   if (! ((obj->TemplateObject.Dist->Mapping.dynamic))) goto yyL4;
  {
/* line 635 "ChangeDefs.puma" */
   error_protocol ("TEMPLATE is already DYNAMIC");
/* line 636 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL4:;

/* line 639 "ChangeDefs.puma" */
  {
/* line 641 "ChangeDefs.puma" */
 obj->TemplateObject.Dist->Mapping.dynamic = 1; 
  }
   return;

  }
/* line 644 "ChangeDefs.puma" */
  {
/* line 646 "ChangeDefs.puma" */
   error_protocol ("object cannot be DYNAMIC");
/* line 647 "ChangeDefs.puma" */
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjTrace
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 658 "ChangeDefs.puma" */
  {
/* line 660 "ChangeDefs.puma" */
   if (! ((obj->VarObject.trace))) goto yyL1;
  {
/* line 661 "ChangeDefs.puma" */
   error_protocol ("object has already TRACE attribute");
/* line 662 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL1:;

/* line 665 "ChangeDefs.puma" */
  {
/* line 666 "ChangeDefs.puma" */
 obj->VarObject.trace = 1; 
  }
   return;

  }
/* line 669 "ChangeDefs.puma" */
  {
/* line 670 "ChangeDefs.puma" */
   error_protocol ("object cannot be TRACEd");
/* line 671 "ChangeDefs.puma" */
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjNoDescriptor
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 682 "ChangeDefs.puma" */
  {
/* line 684 "ChangeDefs.puma" */
   if (! ((obj->VarObject.dsp_kind != kDEFAULT_DSP))) goto yyL1;
  {
/* line 686 "ChangeDefs.puma" */
   error_protocol ("object has already DESCRIPTOR attribute");
/* line 687 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL1:;

/* line 690 "ChangeDefs.puma" */
  {
/* line 692 "ChangeDefs.puma" */
 obj->VarObject.dsp_kind = kNO_DSP; 
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
/* line 695 "ChangeDefs.puma" */
  {
/* line 696 "ChangeDefs.puma" */
   error_protocol ("TEMPLATE cannot have NODESCRIPTOR attribute");
/* line 697 "ChangeDefs.puma" */
   obj_protocol ("illegal template is ", obj);
  }
   return;

  }
/* line 700 "ChangeDefs.puma" */
  {
/* line 701 "ChangeDefs.puma" */
   error_protocol ("object cannot have NODESCRIPTOR attribute");
/* line 702 "ChangeDefs.puma" */
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjTree
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 713 "ChangeDefs.puma" */
  {
/* line 714 "ChangeDefs.puma" */
   if (! ((obj->VarObject.tree))) goto yyL1;
  {
/* line 715 "ChangeDefs.puma" */
   error_protocol ("object has already TREE attribute");
/* line 716 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL1:;

/* line 719 "ChangeDefs.puma" */
  {
/* line 720 "ChangeDefs.puma" */
 obj->VarObject.tree = 1; 
  }
   return;

  }
/* line 723 "ChangeDefs.puma" */
  {
/* line 724 "ChangeDefs.puma" */
   error_protocol ("object cannot have TREE attribute");
/* line 725 "ChangeDefs.puma" */
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjShadow
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree shadow_spec)
# else
(obj, shadow_spec)
 register tDefinitions obj;
 register tTree shadow_spec;
# endif
{
/* line 740 "ChangeDefs.puma" */
  {
/* line 742 "ChangeDefs.puma" */
   if (! ((IsVarAssumedSize (obj)))) goto yyL1;
  {
/* line 744 "ChangeDefs.puma" */
   error_protocol ("SHADOW attribute not allowed for assumed size arrays");
/* line 745 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL1:;

  if (obj->Kind == kVarObject) {
/* line 748 "ChangeDefs.puma" */
  {
/* line 750 "ChangeDefs.puma" */
   if (! ((obj->VarObject.shadow != NoTree))) goto yyL2;
  {
/* line 752 "ChangeDefs.puma" */
   attribute_error_protocol ("SHADOW already set for", obj);
  }
  }
   return;
yyL2:;

/* line 755 "ChangeDefs.puma" */
  {
/* line 759 "ChangeDefs.puma" */
 if (VarRank (obj) != TreeListLength (shadow_spec))

        attribute_error_protocol ("SHADOW mismatches dimensions for", obj);

      else

        obj->VarObject.shadow = shadow_spec; 
   
  }
   return;

  }
/* line 769 "ChangeDefs.puma" */
  {
/* line 771 "ChangeDefs.puma" */
   attribute_error_protocol ("SHADOW attribute illegal for", obj);
  }
   return;

;
}

void MakeObjSelection
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree selection)
# else
(obj, selection)
 register tDefinitions obj;
 register tTree selection;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 787 "ChangeDefs.puma" */
  {
/* line 789 "ChangeDefs.puma" */
   if (! ((obj->VarObject.select != NoTree))) goto yyL1;
  {
/* line 791 "ChangeDefs.puma" */
   attribute_error_protocol ("SELECT attribute already set for", obj);
  }
  }
   return;
yyL1:;

/* line 801 "ChangeDefs.puma" */
  {
/* line 805 "ChangeDefs.puma" */
 if (VarRank (obj) != TreeListLength (selection))

        attribute_error_protocol ("SELECT mismatches dimensions for", obj);

      else

        obj->VarObject.select = selection; 
   
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
/* line 794 "ChangeDefs.puma" */
  {
/* line 796 "ChangeDefs.puma" */
   if (! ((obj->TemplateObject.select != NoTree))) goto yyL2;
  {
/* line 798 "ChangeDefs.puma" */
   attribute_error_protocol ("SELECT attribute already set for", obj);
  }
  }
   return;
yyL2:;

/* line 815 "ChangeDefs.puma" */
  {
/* line 819 "ChangeDefs.puma" */
 if (VarRank (obj) != TreeListLength (selection))

        error_protocol ("SELECT mismatches dimensions");

      else

        obj->TemplateObject.select = selection; 
   
  }
   return;

  }
/* line 829 "ChangeDefs.puma" */
  {
/* line 831 "ChangeDefs.puma" */
   attribute_error_protocol ("SELECT attribute illegal for", obj);
  }
   return;

;
}

void MakeObjInherited
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 842 "ChangeDefs.puma" */
  {
/* line 844 "ChangeDefs.puma" */
   if (! ((! IsVarDummy (obj)))) goto yyL1;
  {
/* line 846 "ChangeDefs.puma" */
   error_protocol ("only dummy var arguments can be INHERITED");
/* line 847 "ChangeDefs.puma" */
   obj_protocol ("illegal object is ", obj);
  }
  }
   return;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapDefault) {
/* line 850 "ChangeDefs.puma" */
  {
/* line 852 "ChangeDefs.puma" */
 obj->VarObject.Dist->Mapping.spec->Kind = kMapInherited; 
  }
   return;

  }
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapInherited) {
/* line 855 "ChangeDefs.puma" */
  {
/* line 857 "ChangeDefs.puma" */
   error_protocol ("object is already INHERITED");
/* line 858 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
   return;

  }
/* line 861 "ChangeDefs.puma" */
  {
/* line 863 "ChangeDefs.puma" */
   error_protocol ("INHERITED: already mapping specified");
/* line 864 "ChangeDefs.puma" */
   obj_protocol ("illegal object is ", obj);
  }
   return;

  }
;
}

void MakeObjActive
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kTopologyObject) {
/* line 875 "ChangeDefs.puma" */
  {
/* line 877 "ChangeDefs.puma" */
   if (! ((obj->TopologyObject.active))) goto yyL1;
  {
/* line 878 "ChangeDefs.puma" */
   error_protocol ("object is already ACITVE");
/* line 879 "ChangeDefs.puma" */
   obj_protocol ("object is : ", obj);
  }
  }
   return;
yyL1:;

/* line 882 "ChangeDefs.puma" */
  {
/* line 884 "ChangeDefs.puma" */
 obj->TopologyObject.active = 1; 
  }
   return;

  }
/* line 887 "ChangeDefs.puma" */
  {
/* line 888 "ChangeDefs.puma" */
   error_protocol ("only processor arrangement can be ACTIVE");
/* line 889 "ChangeDefs.puma" */
   obj_protocol ("illegal object is ", obj);
  }
   return;

;
}

void MakeObjLayout
# if defined __STDC__ | defined __cplusplus
(register tStringRef kind, register tDefinitions obj)
# else
(kind, obj)
 register tStringRef kind;
 register tDefinitions obj;
# endif
{
/* line 900 "ChangeDefs.puma" */

char str_layout[20];
char msg[50];

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 905 "ChangeDefs.puma" */
  {
/* line 907 "ChangeDefs.puma" */
   if (! ((obj->VarObject.Kind->VarDummy.layout))) goto yyL1;
  {
/* line 909 "ChangeDefs.puma" */
   error_protocol ("LAYOUT already set for this dummy argument");
/* line 910 "ChangeDefs.puma" */
   obj_protocol ("dummy is", obj);
  }
  }
   return;
yyL1:;

/* line 913 "ChangeDefs.puma" */
 {
  rbool is_f77;
  {
/* line 917 "ChangeDefs.puma" */
   StGetString (kind, str_layout);
/* line 919 "ChangeDefs.puma" */
 if (strcmp (str_layout, "HPF_ARRAY") == 0)

        { is_f77 = rfalse;

          obj->VarObject.Kind->VarDummy.layout = GetLayout (is_f77, GetCurrentModel ());
        }
           
      else if (strcmp (str_layout, "F77_ARRAY") == 0)

        { is_f77 = rtrue;

          obj->VarObject.Kind->VarDummy.layout = GetLayout (is_f77, GetCurrentModel ());
        }
           
      else 

        { sprintf (msg, "%s is unknown layout", str_layout);
          error_protocol (msg);
        }
   
  }
   return;
 }

  }
  }
/* line 941 "ChangeDefs.puma" */
  {
/* line 943 "ChangeDefs.puma" */
   error_protocol ("LAYOUT illegal for this entity");
/* line 944 "ChangeDefs.puma" */
   obj_protocol ("this object can not have a layout attribute", obj);
  }
   return;

;
}

void MakeObjPassBy
# if defined __STDC__ | defined __cplusplus
(register tStringRef kind, register tDefinitions obj)
# else
(kind, obj)
 register tStringRef kind;
 register tDefinitions obj;
# endif
{
/* line 955 "ChangeDefs.puma" */

char str_pass_by [20];

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 959 "ChangeDefs.puma" */
  {
/* line 961 "ChangeDefs.puma" */
   StGetString (kind, str_pass_by);
/* line 963 "ChangeDefs.puma" */
 if (strcmp (str_pass_by, "*") == 0)
        obj->VarObject.Kind->VarDummy.pass_by = kDATA_PASS_BY;
      else if (strcmp (str_pass_by, "HPF_HANDLE") == 0)
        obj->VarObject.Kind->VarDummy.pass_by = kHPF_HANDLE_PASS_BY;
      else 
        obj->VarObject.Kind->VarDummy.pass_by = kDEFAULT_PASS_BY;
   
  }
   return;

  }
  }
/* line 972 "ChangeDefs.puma" */
  {
/* line 974 "ChangeDefs.puma" */
   error_protocol ("PASS_BY illegal for this entity");
/* line 975 "ChangeDefs.puma" */
   obj_protocol ("this object can not have a PASS_BY attribute", obj);
  }
   return;

;
}

void MakeObjMapTo
# if defined __STDC__ | defined __cplusplus
(register tStringRef kind, register tDefinitions obj)
# else
(kind, obj)
 register tStringRef kind;
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 986 "ChangeDefs.puma" */
  {
/* line 988 "ChangeDefs.puma" */
 obj->VarObject.Kind->VarDummy.map_to = 1; 
  }
   return;

  }
  }
/* line 991 "ChangeDefs.puma" */
  {
/* line 993 "ChangeDefs.puma" */
   error_protocol ("MAP_TO illegal for this entity");
/* line 994 "ChangeDefs.puma" */
   obj_protocol ("this object can not have a MAP_TO attribute", obj);
  }
   return;

;
}

void MakeObjCommon
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tDefinitions obj)
# else
(decl, obj)
 register tTree decl;
 register tDefinitions obj;
# endif
{
/* line 1005 "ChangeDefs.puma" */
 char string [100], msg[150]; 
/* line 1007 "ChangeDefs.puma" */
  {
/* line 1009 "ChangeDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 1010 "ChangeDefs.puma" */
   error_protocol ("no object for item in COMMON");
  }
  }
   return;
yyL1:;

  if (decl->Kind == kCOMMON_DECL) {
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
/* line 1013 "ChangeDefs.puma" */
  {
/* line 1016 "ChangeDefs.puma" */
   GetString (obj->VarObject.Ident, string);
/* line 1017 "ChangeDefs.puma" */
 if (obj->VarObject.Kind->VarLocal.save != 0)
        { obj_error_protocol ("Save Variabe not in COMMON : ", obj);
          tree_protocol ("Declaration is : ", decl);
        }
    
/* line 1022 "ChangeDefs.puma" */
   obj->VarObject.Kind = mVarCommon (decl->COMMON_DECL.Ident, NoObject);
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 1025 "ChangeDefs.puma" */
  {
/* line 1028 "ChangeDefs.puma" */
   obj_error_protocol ("Dummy variable must not be in COMMON: ", obj);
/* line 1029 "ChangeDefs.puma" */
   tree_protocol ("COMMON is : ", decl);
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarCommon) {
/* line 1032 "ChangeDefs.puma" */
  {
/* line 1035 "ChangeDefs.puma" */
   GetString (obj->VarObject.Kind->VarCommon.Block, string);
/* line 1036 "ChangeDefs.puma" */
   sprintf (msg, "Variable is already in COMMON %s : ", string);
/* line 1037 "ChangeDefs.puma" */
   tree_error_protocol (msg, obj->VarObject.decl);
/* line 1038 "ChangeDefs.puma" */
   tree_protocol ("New COMMON is : ", decl);
  }
   return;

  }
  if (obj->VarObject.Kind->Kind == kVarParameter) {
/* line 1041 "ChangeDefs.puma" */
  {
/* line 1044 "ChangeDefs.puma" */
   error_protocol ("parameter object cannot be in COMMON");
/* line 1045 "ChangeDefs.puma" */
   tree_error_protocol ("this is old definition : ", obj->VarObject.decl);
  }
   return;

  }
  }
  }
/* line 1048 "ChangeDefs.puma" */
  {
/* line 1049 "ChangeDefs.puma" */
   obj_error_protocol ("Object", obj);
/* line 1050 "ChangeDefs.puma" */
   tree_protocol ("object must not be in this COMMON", decl);
  }
   return;

;
}

void MakeObjSequential
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
/* line 1061 "ChangeDefs.puma" */
  {
/* line 1063 "ChangeDefs.puma" */
 if (v->VarObject.sequence == IsNoSequence)
        error_protocol ("object has already NO SEQUENCE association");
      else if (v->VarObject.sequence == IsSequence)
        error_protocol ("object has already SEQUENCE association");
      else
        v->VarObject.sequence = IsSequence;   
   
  }
   return;

  }
  if (v->Kind == kCommonObject) {
/* line 1072 "ChangeDefs.puma" */
  {
/* line 1074 "ChangeDefs.puma" */
 if (v->CommonObject.sequence == IsNoSequence)
        error_protocol ("COMMON has already NO SEQUENCE association");
      else if (v->CommonObject.sequence == IsSequence)
        error_protocol ("COMMON has already SEQUENCE association");
      else
        v->CommonObject.sequence = IsSequence;   
   
  }
   return;

  }
/* line 1083 "ChangeDefs.puma" */
  {
/* line 1084 "ChangeDefs.puma" */
   error_protocol ("SEQUENCE not supported for this object");
  }
   return;

;
}

void MakeObjNoSequential
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
/* line 1095 "ChangeDefs.puma" */
  {
/* line 1097 "ChangeDefs.puma" */
 if (v->VarObject.sequence == IsNoSequence)
        error_protocol ("object has already NO SEQUENCE association");
      else if (v->VarObject.sequence == IsSequence)
        error_protocol ("object has already SEQUENCE association");
      else
        v->VarObject.sequence = IsNoSequence;   
   
  }
   return;

  }
  if (v->Kind == kCommonObject) {
/* line 1106 "ChangeDefs.puma" */
  {
/* line 1108 "ChangeDefs.puma" */
 if (v->CommonObject.sequence == IsNoSequence)
        error_protocol ("COMMON has already NO SEQUENCE association");
      else if (v->CommonObject.sequence == IsSequence)
        error_protocol ("COMMON has already SEQUENCE association");
      else
        v->CommonObject.sequence = IsNoSequence;   
   
  }
   return;

  }
/* line 1117 "ChangeDefs.puma" */
  {
/* line 1118 "ChangeDefs.puma" */
   error_protocol ("NO SEQUENCE not supported for this object");
  }
   return;

;
}

void MakeObjSave
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarLocal) {
/* line 1129 "ChangeDefs.puma" */
  {
/* line 1131 "ChangeDefs.puma" */
 if (v->VarObject.Kind->VarLocal.save)
       error_protocol ("Local Variable is already save");
     v->VarObject.Kind->VarLocal.save = rtrue;
   
  }
   return;

  }
  if (v->VarObject.Kind->Kind == kVarDummy) {
/* line 1137 "ChangeDefs.puma" */
  {
/* line 1139 "ChangeDefs.puma" */
   error_protocol ("dummy argument cannot be save");
  }
   return;

  }
  if (v->VarObject.Kind->Kind == kVarParameter) {
/* line 1142 "ChangeDefs.puma" */
  {
/* line 1143 "ChangeDefs.puma" */
   error_protocol ("parameter cannot be save");
  }
   return;

  }
  if (v->VarObject.Kind->Kind == kVarCommon) {
/* line 1146 "ChangeDefs.puma" */
  {
/* line 1147 "ChangeDefs.puma" */
   error_protocol ("only a whole common block can be save");
  }
   return;

  }
  }
/* line 1150 "ChangeDefs.puma" */
  {
/* line 1151 "ChangeDefs.puma" */
   error_protocol ("entity cannot be save");
  }
   return;

;
}

static tDefinitions MakeNewRoutineObject
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register int kind, register tDefinitions unit)
# else
(decl, kind, unit)
 register tTree decl;
 register int kind;
 register tDefinitions unit;
# endif
{
  if (decl->Kind == kFUNC_DECL) {
/* line 1164 "ChangeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1168 "ChangeDefs.puma" */
 Obj = mFuncObject (decl->FUNC_DECL.Ident, decl, Default, NoObject,
                         kind, mENTRY_EMPTY ());
      SetExternalEntry (Obj);
    
  }
   return Obj;
 }

  }
  if (decl->Kind == kEXTERNAL_DECL) {
/* line 1176 "ChangeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1180 "ChangeDefs.puma" */
 Obj = mExternalObject (decl->EXTERNAL_DECL.Ident, decl, Default, NoObject,
                             kind, mENTRY_EMPTY ());
      SetExternalEntry (Obj);
    
  }
   return Obj;
 }

  }
  if (decl->Kind == kPROC_DECL) {
/* line 1188 "ChangeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1192 "ChangeDefs.puma" */
 Obj = mProcObject (decl->PROC_DECL.Ident, decl, Default, NoObject,
                         kind, mENTRY_EMPTY ());
      SetExternalEntry (Obj);
    
  }
   return Obj;
 }

  }
/* line 1200 "ChangeDefs.puma" */
  {
/* line 1201 "ChangeDefs.puma" */
   failure_protocol (MODULE, "MakeNewRoutineObject", decl);
  }
   return NoObject;

}

void MakeObjExternal
# if defined __STDC__ | defined __cplusplus
(register tDefinitions oldobj)
# else
(oldobj)
 register tDefinitions oldobj;
# endif
{
  if (oldobj->Kind == kVarObject) {
  if (oldobj->VarObject.decl->Kind == kVAR_DECL) {
  if (oldobj->VarObject.Kind->Kind == kVarLocal) {
/* line 1214 "ChangeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1221 "ChangeDefs.puma" */
   Obj = MakeNewRoutineObject (MakeFuncDecl (oldobj->VarObject.Ident, oldobj->VarObject.decl->VAR_DECL.Line, oldobj->VarObject.decl->VAR_DECL.VAL), UserRoutine, oldobj->VarObject.in);
/* line 1226 "ChangeDefs.puma" */
   ChangeEntry (oldobj->VarObject.Ident, Obj);
  }
   return;
 }

  }
  }
  if (oldobj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (oldobj->VarObject.decl->VAR_PARAM_DECL.VAL->Kind == kDUMMY_TYPE) {
/* line 1238 "ChangeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1243 "ChangeDefs.puma" */
   Obj = MakeNewRoutineObject (mEXTERNAL_DECL (oldobj->VarObject.Ident, oldobj->VarObject.decl->VAR_PARAM_DECL.Line), DummyRoutine, oldobj->VarObject.in);
/* line 1246 "ChangeDefs.puma" */
   ChangeEntry (oldobj->VarObject.Ident, Obj);
  }
   return;
 }

  }
/* line 1257 "ChangeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1263 "ChangeDefs.puma" */
   Obj = MakeNewRoutineObject (MakeFuncDecl (oldobj->VarObject.Ident, oldobj->VarObject.decl->VAR_PARAM_DECL.Line, oldobj->VarObject.decl->VAR_PARAM_DECL.VAL), DummyRoutine, oldobj->VarObject.in);
/* line 1266 "ChangeDefs.puma" */
   ChangeEntry (oldobj->VarObject.Ident, Obj);
  }
   return;
 }

  }
  }
/* line 1269 "ChangeDefs.puma" */
  {
/* line 1270 "ChangeDefs.puma" */
   error_protocol ("this entity cannot be external");
  }
   return;

;
}

static tDefinitions MakeObjSubroutine
# if defined __STDC__ | defined __cplusplus
(register tDefinitions oldobj)
# else
(oldobj)
 register tDefinitions oldobj;
# endif
{
  if (oldobj->Kind == kProcObject) {
  if (oldobj->ProcObject.decl->Kind == kPROGRAM_DECL) {
/* line 1284 "ChangeDefs.puma" */
  {
/* line 1286 "ChangeDefs.puma" */
   error_protocol ("cannot call main program");
/* line 1287 "ChangeDefs.puma" */
   obj_protocol ("object for main program is ", oldobj);
  }
   return oldobj;

  }
/* line 1291 "ChangeDefs.puma" */
   return oldobj;

  }
  if (oldobj->Kind == kGenericObject) {
/* line 1296 "ChangeDefs.puma" */
   return oldobj;

  }
  if (oldobj->Kind == kExternalObject) {
  if (oldobj->ExternalObject.decl->Kind == kEXTERNAL_DECL) {
/* line 1311 "ChangeDefs.puma" */
  {
/* line 1315 "ChangeDefs.puma" */
 oldobj->ExternalObject.decl = MakeProcDecl (oldobj->ExternalObject.Ident, oldobj->ExternalObject.decl->EXTERNAL_DECL.Line); 
      oldobj->Kind = kProcObject; 
    
  }
   return oldobj;

  }
  }
  if (oldobj->Kind == kVarObject) {
  if (oldobj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (oldobj->VarObject.decl->VAR_PARAM_DECL.VAL->Kind == kDUMMY_TYPE) {
/* line 1329 "ChangeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1332 "ChangeDefs.puma" */
   if (! ((UnUsedDummy (oldobj)))) goto yyL5;
  {
/* line 1336 "ChangeDefs.puma" */
   Obj = MakeNewRoutineObject (MakeProcDecl (oldobj->VarObject.Ident, oldobj->VarObject.decl->VAR_PARAM_DECL.Line), DummyRoutine, oldobj->VarObject.in);
/* line 1339 "ChangeDefs.puma" */
   ChangeEntry (oldobj->VarObject.Ident, Obj);
  }
  }
   return Obj;
 }
yyL5:;

  }
  }
  }
/* line 1343 "ChangeDefs.puma" */
  {
/* line 1344 "ChangeDefs.puma" */
   error_protocol ("name is not a subroutine");
/* line 1345 "ChangeDefs.puma" */
   obj_protocol ("object is ", oldobj);
  }
   return oldobj;

}

static tDefinitions MakeObjFunction
# if defined __STDC__ | defined __cplusplus
(register tDefinitions oldobj)
# else
(oldobj)
 register tDefinitions oldobj;
# endif
{
  if (oldobj->Kind == kFuncObject) {
/* line 1360 "ChangeDefs.puma" */
   return oldobj;

  }
  if (oldobj->Kind == kGenericObject) {
/* line 1367 "ChangeDefs.puma" */
   return oldobj;

  }
  if (oldobj->Kind == kExternalObject) {
  if (oldobj->ExternalObject.decl->Kind == kEXTERNAL_DECL) {
/* line 1374 "ChangeDefs.puma" */
  {
/* line 1378 "ChangeDefs.puma" */
 oldobj->ExternalObject.decl = MakeFuncDecl (oldobj->ExternalObject.Ident, oldobj->ExternalObject.decl->EXTERNAL_DECL.Line, mDUMMY_TYPE());
      oldobj->Kind = kFuncObject; 
    
  }
   return oldobj;

  }
  }
  if (oldobj->Kind == kVarObject) {
  if (oldobj->VarObject.decl->Kind == kVAR_DECL) {
  if (oldobj->VarObject.Kind->Kind == kVarLocal) {
/* line 1390 "ChangeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1396 "ChangeDefs.puma" */
   Obj = MakeNewRoutineObject (MakeFuncDecl (oldobj->VarObject.Ident, oldobj->VarObject.decl->VAR_DECL.Line, oldobj->VarObject.decl->VAR_DECL.VAL), UserRoutine, oldobj->VarObject.in);
/* line 1401 "ChangeDefs.puma" */
   ChangeEntry (oldobj->VarObject.Ident, Obj);
  }
   return Obj;
 }

  }
  }
  if (oldobj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (oldobj->VarObject.Kind->Kind == kVarDummy) {
/* line 1414 "ChangeDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1418 "ChangeDefs.puma" */
   if (! ((UnUsedDummy (oldobj)))) goto yyL5;
  {
/* line 1422 "ChangeDefs.puma" */
   Obj = MakeNewRoutineObject (MakeFuncDecl (oldobj->VarObject.Ident, oldobj->VarObject.decl->VAR_PARAM_DECL.Line, oldobj->VarObject.decl->VAR_PARAM_DECL.VAL), DummyRoutine, oldobj->VarObject.in);
/* line 1425 "ChangeDefs.puma" */
   ChangeEntry (oldobj->VarObject.Ident, Obj);
  }
  }
   return Obj;
 }
yyL5:;

  }
  }
  }
/* line 1430 "ChangeDefs.puma" */
  {
/* line 1431 "ChangeDefs.puma" */
   error_protocol ("name is not a function");
/* line 1432 "ChangeDefs.puma" */
   obj_protocol ("object is ", oldobj);
  }
   return oldobj;

}

static rbool UnUsedDummy
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
/* line 1447 "ChangeDefs.puma" */
  {
/* line 1450 "ChangeDefs.puma" */
   if (! ((obj->VarObject.uses->VarUse.ArrayUse == 0))) goto yyL1;
  {
/* line 1451 "ChangeDefs.puma" */
   if (! ((obj->VarObject.uses->VarUse.ReadUse == 0))) goto yyL1;
  {
/* line 1452 "ChangeDefs.puma" */
   if (! ((obj->VarObject.uses->VarUse.WriteUse == 0))) goto yyL1;
  }
  }
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

static tTree MakeProcDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int pos)
# else
(name, pos)
 register tIdent name;
 register int pos;
# endif
{
/* line 1464 "ChangeDefs.puma" */
 {
  tTree decl;
  {
/* line 1467 "ChangeDefs.puma" */
   decl = mPROC_DECL (name, pos, mDECL_EMPTY (), NoTree);
/* line 1469 "ChangeDefs.puma" */
   decl->PROC_DECL.IsPure = rfalse;
/* line 1470 "ChangeDefs.puma" */
   decl->PROC_DECL.IsRecursive = rfalse;
/* line 1471 "ChangeDefs.puma" */
   decl->PROC_DECL.HPFExtrinsic = DefaultId ();
  }
   return decl;
 }

}

static tTree MakeFuncDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int pos, register tTree type)
# else
(name, pos, type)
 register tIdent name;
 register int pos;
 register tTree type;
# endif
{
/* line 1478 "ChangeDefs.puma" */
 {
  tTree decl;
  {
/* line 1481 "ChangeDefs.puma" */
   decl = mFUNC_DECL (name, pos, mDECL_EMPTY (), NoTree, type, rfalse, DefaultId ());
/* line 1484 "ChangeDefs.puma" */
   decl->FUNC_DECL.IsPure = rfalse;
/* line 1485 "ChangeDefs.puma" */
   decl->FUNC_DECL.IsRecursive = rfalse;
/* line 1486 "ChangeDefs.puma" */
   decl->FUNC_DECL.HPFExtrinsic = DefaultId ();
  }
   return decl;
 }

}

tDefinitions GetFuncObject
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tDefinitions unit)
# else
(name, unit)
 register tIdent name;
 register tDefinitions unit;
# endif
{
/* line 1501 "ChangeDefs.puma" */

tObject Obj;

/* line 1509 "ChangeDefs.puma" */
  {
/* line 1511 "ChangeDefs.puma" */
   Obj = GetLocalObject (name);
/* line 1513 "ChangeDefs.puma" */
   if (! ((Obj != NoObject))) goto yyL1;
  {
/* line 1515 "ChangeDefs.puma" */
   if (! ((! IsValidFuncObject (Obj)))) goto yyL1;
  }
  }
   return MakeObjFunction (Obj);
yyL1:;

/* line 1524 "ChangeDefs.puma" */
  {
/* line 1526 "ChangeDefs.puma" */
   Obj = GetGlobalObject (name);
/* line 1528 "ChangeDefs.puma" */
   if (! ((Obj != NoObject))) goto yyL2;
  {
/* line 1530 "ChangeDefs.puma" */
   if (! ((IsValidFuncObject (Obj)))) goto yyL2;
  }
  }
   return Obj;
yyL2:;

/* line 1539 "ChangeDefs.puma" */
  {
/* line 1541 "ChangeDefs.puma" */
   Obj = GetDeclEntry (name, GetIntrinsicEntries ());
/* line 1543 "ChangeDefs.puma" */
   if (! ((Obj != NoObject))) goto yyL3;
  {
/* line 1545 "ChangeDefs.puma" */
   if (! ((IsValidFuncObject (Obj)))) goto yyL3;
  }
  }
   return Obj;
yyL3:;

/* line 1554 "ChangeDefs.puma" */
  {
/* line 1556 "ChangeDefs.puma" */
   Obj = MakeNewRoutineObject (MakeFuncDecl (name, 0, mDUMMY_TYPE ()), UserRoutine, unit);
/* line 1559 "ChangeDefs.puma" */
   InsertEntry (Obj);
  }
   return Obj;

}

static rbool IsValidFuncObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kFuncObject) {
/* line 1566 "ChangeDefs.puma" */
   return rtrue;

  }
  if (obj->Kind == kGenericObject) {
/* line 1571 "ChangeDefs.puma" */
   return rtrue;

  }
  return rfalse;
}

tDefinitions GetProcObject
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tDefinitions unit)
# else
(name, unit)
 register tIdent name;
 register tDefinitions unit;
# endif
{
/* line 1586 "ChangeDefs.puma" */

tObject Obj;

/* line 1590 "ChangeDefs.puma" */
  {
/* line 1592 "ChangeDefs.puma" */
   Obj = GetLocalObject (name);
/* line 1594 "ChangeDefs.puma" */
   if (! ((Obj != NoObject))) goto yyL1;
  }
   return MakeObjSubroutine (Obj);
yyL1:;

/* line 1599 "ChangeDefs.puma" */
  {
/* line 1601 "ChangeDefs.puma" */
   Obj = GetDeclEntry (name, GetIntrinsicEntries ());
/* line 1603 "ChangeDefs.puma" */
   if (! ((Obj != NoObject))) goto yyL2;
  {
/* line 1605 "ChangeDefs.puma" */
   if (! ((Obj -> Kind == kProcObject))) goto yyL2;
  }
  }
   return Obj;
yyL2:;

/* line 1610 "ChangeDefs.puma" */
  {
/* line 1612 "ChangeDefs.puma" */
   Obj = MakeNewRoutineObject (MakeProcDecl (name, 0), UserRoutine, unit);
/* line 1615 "ChangeDefs.puma" */
   InsertEntry (Obj);
  }
   return Obj;

}

void SetExternalEntry
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 1630 "ChangeDefs.puma" */
  {
/* line 1632 "ChangeDefs.puma" */
   if (! ((GetDeclEntry (obj->Object.Ident, GetUnitEntries ()) != NoObject))) goto yyL1;
  }
   return;
yyL1:;

/* line 1635 "ChangeDefs.puma" */
  {
/* line 1637 "ChangeDefs.puma" */
   if (! ((GetDeclEntry (obj->Object.Ident, GetExternalEntries ()) != NoObject))) goto yyL2;
  }
   return;
yyL2:;

/* line 1640 "ChangeDefs.puma" */
  {
/* line 1642 "ChangeDefs.puma" */
   InsertExternalEntry (obj);
  }
   return;

;
}

static tTree SetCompType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree old_type, register tTree new_type)
# else
(obj, old_type, new_type)
 register tDefinitions obj;
 register tTree old_type;
 register tTree new_type;
# endif
{
/* line 1653 "ChangeDefs.puma" */
  {
/* line 1655 "ChangeDefs.puma" */
   if (! ((IsSameBaseType (GetBaseType (old_type), new_type)))) goto yyL1;
  {
/* line 1657 "ChangeDefs.puma" */
   serious_warning_protocol ("same type defined twice");
  }
  }
   return old_type;
yyL1:;

/* line 1661 "ChangeDefs.puma" */
  {
/* line 1663 "ChangeDefs.puma" */
   if (! ((! IsDummyType (old_type)))) goto yyL2;
  {
/* line 1665 "ChangeDefs.puma" */
   error_protocol ("illegal retyping");
/* line 1666 "ChangeDefs.puma" */
   tree_protocol ("this is the old type : ", old_type);
/* line 1667 "ChangeDefs.puma" */
   tree_protocol ("this is the new type : ", new_type);
  }
  }
   return old_type;
yyL2:;

/* line 1672 "ChangeDefs.puma" */
   return NewCompType (old_type, new_type);

}

static tTree NewCompType
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tTree comp)
# else
(type, comp)
 register tTree type;
 register tTree comp;
# endif
{
  if (type->Kind == kDUMMY_TYPE) {
/* line 1688 "ChangeDefs.puma" */
   return comp;

  }
  if (type->Kind == kARRAY_TYPE) {
  if (type->ARRAY_TYPE.ARRAY_COMP_TYPE->Kind == kDUMMY_TYPE) {
/* line 1693 "ChangeDefs.puma" */
   return mARRAY_TYPE (type->ARRAY_TYPE.ARRAY_INDEX_TYPES, comp);

  }
  }
/* line 1698 "ChangeDefs.puma" */
  {
/* line 1700 "ChangeDefs.puma" */
   failure_protocol (MODULE, "NewCompType", type);
  }
   return type;

}

void BeginChangeDefs ARGS ((void))
{
}

void CloseChangeDefs ARGS ((void))
{
}
