# include "Candidates.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 25 "Candidates.puma" */


# include "DynArray.h"
# include "protocol.h"

# include "TreeOps.h"     /* TreeVarName */
# include "PTreeOps.h"    /* IsVarUsed   */

# undef DEBUG
# define MODULE "Candidates"

/*********************************************************************
*                                                                    *
*                                                                    *
*********************************************************************/

typedef struct { tTree candidate, info; } cand_info; 

# define CANDIDATE_INIT_SIZE  10

static unsigned long all_cand_max = 0;   /* must be a long variable */

static cand_info *all_candidates;        /* size is given by all_cand_max */

static int no_candidates = 0;            /* number of candidates */

/*********************************************************************
*                                                                    *
*  rbool FindCandidate (var : Tree)                                  *
*                                                                    *
*********************************************************************/

static rbool FindCandidate (var)

tTree var;

{ rbool found;
  int   i;
  tIdent id;

  id = TreeVarName (var);

  found = rfalse;

  for (i=0; (i < no_candidates) && (!found); i++)

     found = (id == TreeVarName (all_candidates[i].candidate));

  return found;

} /* FindCandidate */

/*********************************************************************
*                                                                    *
*  void SetNewCandidate (candidate : Tree, info : Tree)              *
*                                                                    *
*********************************************************************/

static void SetNewCandidate (candidate, info)

tTree candidate, info;

{ /* make sure that all_candidates[all_cand_max] is big enough */

  if (no_candidates >= all_cand_max)

     { /* we have to make/extend the dynamic array 'all_candidates' */

       if (all_cand_max == 0)

           { all_cand_max = CANDIDATE_INIT_SIZE;
             MakeArray ((char * *) &all_candidates, &all_cand_max,
                        (long) sizeof (cand_info));
           }
  
        else
 
           ExtendArray ((char * *) &all_candidates, &all_cand_max,
                        (long) sizeof (cand_info));

#ifdef DEBUG
        printf ("Made/Extended array all_candidates to size = %d\n",
                 all_cand_max);
#endif

        if (all_candidates == (cand_info *) 0)

          failure_protocol (MODULE,
             "could not make/extend array for candidates", candidate);
      }
       
   all_candidates [no_candidates].candidate = candidate;
   all_candidates [no_candidates].info      = info;

   no_candidates ++;
     
# ifdef DEBUG
   printf ("SetCandidate (candidate = "); 
   FileUnparse (stdout, candidate);
   printf (", info = ");
   FileUnparse (stdout, info);
   printf (") set, no_candidates = %d\n", no_candidates);
# endif

} /* SetCandidate */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCandidates.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Candidates_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Candidates, routine %s failed\n",
  yyFunction);
 Candidates_Exit ();
}

void InitCandidates ARGS ((void));
void AddCandidate ARGS ((tTree candidate, tTree info, rbool no_double));
rbool IsCandidate ARGS ((tTree candidate));
int NoCandidates ARGS ((void));
tTree GetCandidate ARGS ((int n));
tTree GetCandidateInfo ARGS ((int n));

void InitCandidates
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 140 "Candidates.puma" */
  {
/* line 141 "Candidates.puma" */
   no_candidates = 0;
  }
   return;

;
}

void AddCandidate
# if defined __STDC__ | defined __cplusplus
(register tTree candidate, register tTree info, register rbool no_double)
# else
(candidate, info, no_double)
 register tTree candidate;
 register tTree info;
 register rbool no_double;
# endif
{
/* line 146 "Candidates.puma" */
  {
/* line 148 "Candidates.puma" */
   if (! ((no_double))) goto yyL1;
  {
/* line 150 "Candidates.puma" */
   if (! ((FindCandidate (candidate)))) goto yyL1;
  }
  }
   return;
yyL1:;

/* line 153 "Candidates.puma" */
  {
/* line 155 "Candidates.puma" */
   SetNewCandidate (candidate, info);
  }
   return;

;
}

rbool IsCandidate
# if defined __STDC__ | defined __cplusplus
(register tTree candidate)
# else
(candidate)
 register tTree candidate;
# endif
{
/* line 160 "Candidates.puma" */
  {
/* line 162 "Candidates.puma" */
   if (! ((FindCandidate (candidate)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

int NoCandidates
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 167 "Candidates.puma" */
   return no_candidates;

}

tTree GetCandidate
# if defined __STDC__ | defined __cplusplus
(register int n)
# else
(n)
 register int n;
# endif
{
/* line 174 "Candidates.puma" */
   return  all_candidates[n-1].candidate ;

}

tTree GetCandidateInfo
# if defined __STDC__ | defined __cplusplus
(register int n)
# else
(n)
 register int n;
# endif
{
/* line 181 "Candidates.puma" */
   return  all_candidates[n-1].info ;

}

void BeginCandidates ARGS ((void))
{
}

void CloseCandidates ARGS ((void))
{
}
