# include "Calling.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"
# include "CallGraph.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 41 "Calling.puma" */


# include "Tree.h"
# include "Definitions.h"
# include "Types.h"
# include "CallGraphFns.h"
# include "Nesting.h"
# include "Traverse.h"
# include "Objects.h"   /* NoInterfaceObj */

# include "DefTable.h"

# undef DEBUG

static tCallGraph CurrentUnit;   /* globally used for a unit */

FILE *CGFile;


# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCalling.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Calling_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Calling, routine %s failed\n",
  yyFunction);
 Calling_Exit ();
}

void Calling ARGS ((tTree t));
static rbool StopForCallGraph ARGS ((tTree t));
static void DoForCallGraph ARGS ((tTree t));
static void SetCurrentUnit ARGS ((tDefinitions unit_obj));
static void InsertCallEdge ARGS ((tCallGraph caller, tDefinitions called));
void OutCallGraph ARGS ((tCallGraph c));
static void OutCallEdges ARGS ((tCallGraph c));
int UnitKind ARGS ((tDefinitions unit_object));
static tCallGraph FindTheMainNode ARGS ((tCallGraph c));
static void SetUserKind ARGS ((tCallGraph c));
static void DFS ARGS ((tCallGraph c, int depth));
static void PrintObject ARGS ((tDefinitions obj, int depth, int mark));
static void PrintObjectId ARGS ((tDefinitions obj));
static void PrintHierarchy ARGS ((tCallGraph c));
static void GetUnitReference ARGS ((tDefinitions obj, tDefinitions * yyP2, int * yyP1));

void Calling
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 96 "Calling.puma" */
  {
/* line 97 "Calling.puma" */
   TraverseAST (t, StopForCallGraph, DoForCallGraph);
  }
   return;

;
}

static rbool StopForCallGraph
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kINTERFACE_DECL) {
/* line 112 "Calling.puma" */
   return rtrue;

  }
  return rfalse;
}

static void DoForCallGraph
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kPROGRAM_DECL:
/* line 126 "Calling.puma" */
  {
/* line 128 "Calling.puma" */
   SetCurrentUnit (GetCurrentUnitObject ());
  }
   return;

  case kPROC_DECL:
/* line 131 "Calling.puma" */
  {
/* line 133 "Calling.puma" */
   SetCurrentUnit (GetCurrentUnitObject ());
  }
   return;

  case kFUNC_DECL:
/* line 136 "Calling.puma" */
  {
/* line 138 "Calling.puma" */
   SetCurrentUnit (GetCurrentUnitObject ());
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 141 "Calling.puma" */
  {
/* line 143 "Calling.puma" */
   SetCurrentUnit (GetCurrentUnitObject ());
  }
   return;

  case kMODULE_DECL:
/* line 146 "Calling.puma" */
  {
/* line 148 "Calling.puma" */
   SetCurrentUnit (GetCurrentUnitObject ());
  }
   return;

  case kCALL_STMT:
/* line 151 "Calling.puma" */
  {
/* line 153 "Calling.puma" */
   InsertCallEdge (CurrentUnit, t->CALL_STMT.CALL_ID->PROC_OBJ.Object);
  }
   return;

  case kFUNC_CALL_EXP:
/* line 156 "Calling.puma" */
  {
/* line 158 "Calling.puma" */
   InsertCallEdge (CurrentUnit, t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object);
  }
   return;

  }

;
}

static void SetCurrentUnit
# if defined __STDC__ | defined __cplusplus
(register tDefinitions unit_obj)
# else
(unit_obj)
 register tDefinitions unit_obj;
# endif
{
/* line 169 "Calling.puma" */

char name[128];

/* line 173 "Calling.puma" */
 {
  tDefinitions yyV1;
  int yyV2;
  {
/* line 175 "Calling.puma" */
   GetUnitReference (unit_obj, & yyV1, & yyV2);
/* line 177 "Calling.puma" */
 
#ifdef DEBUG
     GetString (unit_obj->Object.Ident, name);
     if (unit_obj == yyV1)
        printf ("SetCurrentUnit %s (kind = %d), own ref\n", name, yyV2);
      else
        printf ("SetCurrentUnit %s (kind = %d), other ref\n", name, yyV2);
#endif
   
/* line 187 "Calling.puma" */
   CurrentUnit = CallGraphSearchNode (yyV1, yyV2);
  }
   return;
 }

;
}

static void InsertCallEdge
# if defined __STDC__ | defined __cplusplus
(register tCallGraph caller, register tDefinitions called)
# else
(caller, called)
 register tCallGraph caller;
 register tDefinitions called;
# endif
{
/* line 200 "Calling.puma" */
 {
  tDefinitions yyV1;
  int yyV2;
  tCallGraph CN;
  {
/* line 202 "Calling.puma" */
   GetUnitReference (called, & yyV1, & yyV2);
/* line 204 "Calling.puma" */
   if (! ((yyV2 >= 0))) goto yyL1;
  {
/* line 205 "Calling.puma" */
   if (! ((yyV2 <= 2))) goto yyL1;
  {
/* line 209 "Calling.puma" */
   CN = CallGraphSearchNode (yyV1, yyV2);
/* line 210 "Calling.puma" */
   CallGraphInsertEdge (caller, CN);
  }
  }
  }
   return;
 }
yyL1:;

;
}

void OutCallGraph
# if defined __STDC__ | defined __cplusplus
(register tCallGraph c)
# else
(c)
 register tCallGraph c;
# endif
{
/* line 221 "Calling.puma" */

unsigned char string[256];

  if (c->Kind == kCallingGraph) {
/* line 225 "Calling.puma" */
  {
/* line 226 "Calling.puma" */
   PrintHierarchy (c);
/* line 227 "Calling.puma" */
   fprintf (CGFile, "UserNodes : \n");
/* line 228 "Calling.puma" */
   fprintf (CGFile, "=========== \n\n");
/* line 229 "Calling.puma" */
 if (c->CallingGraph.UserNodes != NoCallGraph) OutCallGraph (c->CallingGraph.UserNodes); 
/* line 230 "Calling.puma" */
   fprintf (CGFile, "\n");
/* line 231 "Calling.puma" */
   fprintf (CGFile, "Called Intrinsics : \n");
/* line 232 "Calling.puma" */
   fprintf (CGFile, "=================== \n\n");
/* line 233 "Calling.puma" */
 if (c->CallingGraph.IntrinsicNodes != NoCallGraph)
                    OutCallGraph (c->CallingGraph.IntrinsicNodes); 
/* line 235 "Calling.puma" */
   fprintf (CGFile, "\n");
/* line 236 "Calling.puma" */
   fprintf (CGFile, "Called Externals : \n");
/* line 237 "Calling.puma" */
   fprintf (CGFile, "================== \n\n");
/* line 238 "Calling.puma" */
 if (c->CallingGraph.ExternalNodes != NoCallGraph)
                    OutCallGraph (c->CallingGraph.ExternalNodes); 
/* line 240 "Calling.puma" */
   fprintf (CGFile, "\n");
  }
   return;

  }
  if (c->Kind == kCallNodeList) {
/* line 243 "Calling.puma" */
  {
/* line 244 "Calling.puma" */
   OutCallGraph (c->CallNodeList.Elem);
/* line 245 "Calling.puma" */
 if (c->CallNodeList.Next != NoCallGraph)
            OutCallGraph (c->CallNodeList.Next);   
  }
   return;

  }
  if (c->Kind == kCallNode) {
  if (c->CallNode.val->Kind == kProcObject) {
  if (c->CallNode.val->ProcObject.decl->Kind == kPROGRAM_DECL) {
/* line 249 "Calling.puma" */
  {
/* line 250 "Calling.puma" */
   GetString (c->CallNode.val->ProcObject.decl->PROGRAM_DECL.Ident, string);
/* line 251 "Calling.puma" */
   fprintf (CGFile, "PROGRAM %s -- \n", string);
/* line 252 "Calling.puma" */
 if (c->CallNode.calling != NoCallGraph)
            { fprintf (CGFile, "  %s : calls ", string);
              OutCallEdges (c->CallNode.calling);
              fprintf (CGFile, "\n");           }
       
/* line 257 "Calling.puma" */
 if (c->CallNode.called_by != NoCallGraph)
            { fprintf (CGFile, "  %s : called by ", string);
              OutCallEdges (c->CallNode.called_by);
              fprintf (CGFile, "\n");           }
       
  }
   return;

  }
/* line 264 "Calling.puma" */
  {
/* line 265 "Calling.puma" */
   GetString (c->CallNode.val->ProcObject.Ident, string);
/* line 266 "Calling.puma" */
   fprintf (CGFile, "SUBROUTINE %s -- \n", string);
/* line 267 "Calling.puma" */
 if (c->CallNode.calling != NoCallGraph)
            { fprintf (CGFile, "  %s : calls ", string);
              OutCallEdges (c->CallNode.calling);
              fprintf (CGFile, "\n");           }
       
/* line 272 "Calling.puma" */
 if (c->CallNode.called_by != NoCallGraph)
            { fprintf (CGFile, "  %s : called by ", string);
              OutCallEdges (c->CallNode.called_by);
              fprintf (CGFile, "\n");           }
       
  }
   return;

  }
  if (c->CallNode.val->Kind == kFuncObject) {
/* line 279 "Calling.puma" */
  {
/* line 280 "Calling.puma" */
   GetString (c->CallNode.val->FuncObject.Ident, string);
/* line 281 "Calling.puma" */
   fprintf (CGFile, "FUNCTION %s -- \n", string);
/* line 282 "Calling.puma" */
 if (c->CallNode.calling != NoCallGraph)
            { fprintf (CGFile, "  %s : calls ", string);
              OutCallEdges (c->CallNode.calling);
              fprintf (CGFile, "\n");           }
       
/* line 287 "Calling.puma" */
 if (c->CallNode.called_by != NoCallGraph)
            { fprintf (CGFile, "  %s : called by ", string);
              OutCallEdges (c->CallNode.called_by);
              fprintf (CGFile, "\n");           }
       
  }
   return;

  }
  }
;
}

static void OutCallEdges
# if defined __STDC__ | defined __cplusplus
(register tCallGraph c)
# else
(c)
 register tCallGraph c;
# endif
{
/* line 297 "Calling.puma" */

unsigned char string[256];

  if (c->Kind == kCallEdgeList) {
/* line 301 "Calling.puma" */
  {
/* line 302 "Calling.puma" */
   OutCallEdges (c->CallEdgeList.Node);
/* line 303 "Calling.puma" */
 if (c->CallEdgeList.count > 1)
             fprintf (CGFile,"(%d)", c->CallEdgeList.count); 
/* line 305 "Calling.puma" */
 if (c->CallEdgeList.Next != NoCallGraph)
            { fprintf (CGFile,",");
              OutCallEdges (c->CallEdgeList.Next);  }
        
  }
   return;

  }
  if (c->Kind == kCallNode) {
  if (c->CallNode.val->Kind == kProcObject) {
/* line 311 "Calling.puma" */
  {
/* line 312 "Calling.puma" */
   GetString (c->CallNode.val->ProcObject.Ident, string);
/* line 313 "Calling.puma" */
   fprintf (CGFile, "%s", string);
  }
   return;

  }
  if (c->CallNode.val->Kind == kFuncObject) {
/* line 316 "Calling.puma" */
  {
/* line 317 "Calling.puma" */
   GetString (c->CallNode.val->FuncObject.Ident, string);
/* line 318 "Calling.puma" */
   fprintf (CGFile, "%s", string);
  }
   return;

  }
  }
;
}

int UnitKind
# if defined __STDC__ | defined __cplusplus
(register tDefinitions unit_object)
# else
(unit_object)
 register tDefinitions unit_object;
# endif
{
/* line 331 "Calling.puma" */
 {
  tDefinitions yyV1;
  int yyV2;
  {
/* line 333 "Calling.puma" */
   GetUnitReference (unit_object, & yyV1, & yyV2);
  }
   return yyV2;
 }

}

static tCallGraph FindTheMainNode
# if defined __STDC__ | defined __cplusplus
(register tCallGraph c)
# else
(c)
 register tCallGraph c;
# endif
{
 yyRecursion:
/* line 347 "Calling.puma" */
  {
/* line 348 "Calling.puma" */
   if (! ((c == NoCallGraph))) goto yyL1;
  }
   return c;
yyL1:;

  if (c->Kind == kCallingGraph) {
/* line 352 "Calling.puma" */
   c = c->CallingGraph.UserNodes;
   goto yyRecursion;

  }
  if (c->Kind == kCallNodeList) {
  if (c->CallNodeList.Elem->CallNode.val->Kind == kProcObject) {
  if (c->CallNodeList.Elem->CallNode.val->ProcObject.decl->Kind == kPROGRAM_DECL) {
/* line 356 "Calling.puma" */
   return c->CallNodeList.Elem;

  }
  }
/* line 360 "Calling.puma" */
   c = c->CallNodeList.Next;
   goto yyRecursion;

  }
/* line 364 "Calling.puma" */
   return NoCallGraph;

}

static void SetUserKind
# if defined __STDC__ | defined __cplusplus
(register tCallGraph c)
# else
(c)
 register tCallGraph c;
# endif
{
 yyRecursion:
/* line 378 "Calling.puma" */
  {
/* line 379 "Calling.puma" */
   if (! ((c == NoCallGraph))) goto yyL1;
  }
   return;
yyL1:;

  if (c->Kind == kCallingGraph) {
/* line 382 "Calling.puma" */
  {
/* line 383 "Calling.puma" */
   c = c->CallingGraph.UserNodes;
   goto yyRecursion;
  }

  }
  if (c->Kind == kCallNodeList) {
/* line 386 "Calling.puma" */
  {
/* line 387 "Calling.puma" */
   SetUserKind (c->CallNodeList.Elem);
/* line 388 "Calling.puma" */
   c = c->CallNodeList.Next;
   goto yyRecursion;
  }

  }
  if (c->Kind == kCallNode) {
/* line 391 "Calling.puma" */
  {
/* line 392 "Calling.puma" */
 c->CallNode.unitkind = 0; 
  }
   return;

  }
;
}

static void DFS
# if defined __STDC__ | defined __cplusplus
(register tCallGraph c, register int depth)
# else
(c, depth)
 register tCallGraph c;
 register int depth;
# endif
{
 yyRecursion:
/* line 403 "Calling.puma" */
  {
/* line 405 "Calling.puma" */
   if (! ((c == NoCallGraph))) goto yyL1;
  }
   return;
yyL1:;

  if (c->Kind == kCallNode) {
/* line 408 "Calling.puma" */
  {
/* line 410 "Calling.puma" */
   if (! ((UnitKind (c->CallNode.val) == 0))) goto yyL2;
  {
/* line 412 "Calling.puma" */
   PrintObject (c->CallNode.val, depth, c->CallNode.unitkind);
/* line 414 "Calling.puma" */
 if (c->CallNode.unitkind == 0)  
      { c->CallNode.unitkind = 1;
        DFS (c->CallNode.calling, depth + 1);
      }
     else  
      c->CallNode.unitkind = 1;
  
  }
  }
   return;
yyL2:;

  }
  if (c->Kind == kCallEdgeList) {
/* line 423 "Calling.puma" */
  {
/* line 424 "Calling.puma" */
   DFS (c->CallEdgeList.Node, depth);
/* line 425 "Calling.puma" */
   c = c->CallEdgeList.Next;
   goto yyRecursion;
  }

  }
;
}

static void PrintObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int depth, register int mark)
# else
(obj, depth, mark)
 register tDefinitions obj;
 register int depth;
 register int mark;
# endif
{
/* line 441 "Calling.puma" */
  {
/* line 443 "Calling.puma" */
 int i;
     for (i=0; i<depth; i++)
        fprintf (CGFile, " . ");
     PrintObjectId (obj);
     if (mark == 1)  
        fprintf (CGFile, " (+)");
     fprintf (CGFile, "\n");
   
  }
   return;

;
}

static void PrintObjectId
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 455 "Calling.puma" */

char string[256];

/* line 459 "Calling.puma" */
  {
/* line 461 "Calling.puma" */
   if (! ((obj->Object.in == NoObject))) goto yyL1;
  {
/* line 462 "Calling.puma" */
   GetString (obj->Object.Ident, string);
/* line 463 "Calling.puma" */
   fprintf (CGFile, string);
  }
  }
   return;
yyL1:;

/* line 466 "Calling.puma" */
  {
/* line 468 "Calling.puma" */
   PrintObjectId (obj->Object.in);
/* line 469 "Calling.puma" */
   fprintf (CGFile, ".");
/* line 470 "Calling.puma" */
   GetString (obj->Object.Ident, string);
/* line 471 "Calling.puma" */
   fprintf (CGFile, string);
  }
   return;

;
}

static void PrintHierarchy
# if defined __STDC__ | defined __cplusplus
(register tCallGraph c)
# else
(c)
 register tCallGraph c;
# endif
{
  if (c->Kind == kCallingGraph) {
/* line 482 "Calling.puma" */
 {
  tCallGraph main;
  {
/* line 486 "Calling.puma" */
 main = FindTheMainNode (c->CallingGraph.UserNodes);

     if (main == NoCallGraph)
        fprintf (CGFile, "no main program for hierarchy found\n");
      else 
        { fprintf (CGFile, "CALL Hierarchy (User Nodes)\n");
          fprintf (CGFile, "===========================\n");
          DFS (main, 0);
          SetUserKind (c->CallingGraph.UserNodes);
          fprintf (CGFile, "\n");
        }
   
  }
   return;
 }

  }
/* line 500 "Calling.puma" */
  {
/* line 501 "Calling.puma" */
   fprintf (CGFile, "illegal call of PrintHierarchy\n");
  }
   return;

;
}

static void GetUnitReference
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions * yyP2, register int * yyP1)
# else
(obj, yyP2, yyP1)
 register tDefinitions obj;
 register tDefinitions * yyP2;
 register int * yyP1;
# endif
{
/* line 517 "Calling.puma" */
  {
/* line 519 "Calling.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  }
   * yyP2 = obj;
   * yyP1 = - 1;
   return;
yyL1:;

/* line 522 "Calling.puma" */
  {
/* line 524 "Calling.puma" */

#ifdef DEBUG
     char string[50];
     GetString (obj->Object.Ident, string);
     printf ("get unit reference = %s\n", string); 
#endif
   
/* line 532 "Calling.puma" */
   goto yyL2;
  }
yyL2:;

  if (obj->Kind == kProcObject) {
  if (obj->ProcObject.decl->Kind == kINTRINSIC_DECL) {
/* line 539 "Calling.puma" */
   * yyP2 = obj;
   * yyP1 = 1;
   return;

  }
/* line 549 "Calling.puma" */
  {
/* line 551 "Calling.puma" */
   if (! ((obj->ProcObject.Kind == DummyRoutine))) goto yyL5;
  }
   * yyP2 = obj;
   * yyP1 = 3;
   return;
yyL5:;

/* line 563 "Calling.puma" */
  {
/* line 565 "Calling.puma" */
   if (! ((obj->ProcObject.in != NoObject))) goto yyL7;
  {
/* line 566 "Calling.puma" */
   if (! ((! NoInterfaceObj (obj)))) goto yyL7;
  }
  }
   * yyP2 = obj;
   * yyP1 = 0;
   return;
yyL7:;

  if (obj->ProcObject.decl->Kind == kPROGRAM_DECL) {
/* line 580 "Calling.puma" */
 {
  tDefinitions ref_obj;
  {
/* line 584 "Calling.puma" */
   ref_obj = GetDeclEntry (obj->ProcObject.Ident, GetUnitEntries ());
/* line 586 "Calling.puma" */
   if (! ((ref_obj != NoObject))) goto yyL9;
  }
   * yyP2 = ref_obj;
   * yyP1 = 0;
   return;
 }
yyL9:;

  }
  if (obj->ProcObject.decl->Kind == kPROC_DECL) {
/* line 589 "Calling.puma" */
 {
  tDefinitions ref_obj;
  {
/* line 593 "Calling.puma" */
   ref_obj = GetDeclEntry (obj->ProcObject.Ident, GetUnitEntries ());
/* line 595 "Calling.puma" */
   if (! ((ref_obj != NoObject))) goto yyL10;
  }
   * yyP2 = ref_obj;
   * yyP1 = 0;
   return;
 }
yyL10:;

  }
  }
  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kINTRINSIC_DECL) {
/* line 542 "Calling.puma" */
   * yyP2 = obj;
   * yyP1 = 1;
   return;

  }
/* line 554 "Calling.puma" */
  {
/* line 556 "Calling.puma" */
   if (! ((obj->FuncObject.Kind == DummyRoutine))) goto yyL6;
  }
   * yyP2 = obj;
   * yyP1 = 3;
   return;
yyL6:;

/* line 569 "Calling.puma" */
  {
/* line 571 "Calling.puma" */
   if (! ((obj->FuncObject.in != NoObject))) goto yyL8;
  {
/* line 572 "Calling.puma" */
   if (! ((! NoInterfaceObj (obj)))) goto yyL8;
  }
  }
   * yyP2 = obj;
   * yyP1 = 0;
   return;
yyL8:;

  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 598 "Calling.puma" */
 {
  tDefinitions ref_obj;
  {
/* line 602 "Calling.puma" */
   ref_obj = GetDeclEntry (obj->FuncObject.Ident, GetUnitEntries ());
/* line 604 "Calling.puma" */
   if (! ((ref_obj != NoObject))) goto yyL11;
  }
   * yyP2 = ref_obj;
   * yyP1 = 0;
   return;
 }
yyL11:;

  }
  }
/* line 612 "Calling.puma" */
   * yyP2 = obj;
   * yyP1 = 2;
   return;

;
}

void BeginCalling ARGS ((void))
{
/* line 81 "Calling.puma" */

BeginCallGraphFns ();

}

void CloseCalling ARGS ((void))
{
}
