# include "CallGraphFns.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"
# include "CallGraph.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 37 "CallGraphFns.puma" */

#define NoCallNodes NoCallGraph
#define NoCallNode  NoCallGraph
#define NoCallEdges NoCallGraph

static tCallGraph FoundCallNode;

tCallGraph  TheCallGraph;   /* for Output */

void CallGraphError (s)
char s[];
{  fprintf (stderr, "Internal Error for Call Graph : %s\n", s);
}



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyCallGraphFns.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* CallGraphFns_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module CallGraphFns, routine %s failed\n",
  yyFunction);
 CallGraphFns_Exit ();
}

static tCallGraph InsertNode ARGS ((tCallGraph NodeList, tObject nobj, int kind));
static rbool SameNode ARGS ((tDefinitions obj1, tDefinitions obj2));
tCallGraph CallGraphSearchNode ARGS ((tObject nobj, int kind));
static tCallGraph LocalSearchNode ARGS ((tCallGraph CG, tObject nobj, int kind));
static tCallGraph EdgeListInsert ARGS ((tCallGraph edgelist, tCallGraph node));
void CallGraphInsertEdge ARGS ((tCallGraph source, tCallGraph target));

static tCallGraph InsertNode
# if defined __STDC__ | defined __cplusplus
(register tCallGraph NodeList, tObject nobj, register int kind)
# else
(NodeList, nobj, kind)
 register tCallGraph NodeList;
 tObject nobj;
 register int kind;
# endif
{
/* line 90 "CallGraphFns.puma" */
 {
  register tCallGraph yyV2;
  register tCallGraph yyV1;
  {
/* line 92 "CallGraphFns.puma" */
   if (! ((NodeList == NoCallGraph))) goto yyL1;
  {
/* line 94 "CallGraphFns.puma" */
   yyALLOC (tCallGraph,CallGraph_PoolFreePtr,CallGraph_PoolStartPtr,
    CallGraph_Alloc,yCallNode,MakeCallGraph,yyV1,kCallNode,CallGraph_InitHead)
    yyV1->CallNode.val = nobj;
    yyV1->CallNode.unitkind = kind;
    yyV1->CallNode.calling = NoCallEdges;
    yyV1->CallNode.called_by = NoCallEdges;
   FoundCallNode = yyV1;
  }
  }
   yyALLOC (tCallGraph,CallGraph_PoolFreePtr,CallGraph_PoolStartPtr,
    CallGraph_Alloc,yCallNodeList,MakeCallGraph,yyV2,kCallNodeList,CallGraph_InitHead)
    yyV2->CallNodeList.Elem = FoundCallNode;
    yyV2->CallNodeList.Next = NoCallNodes;
   return yyV2;
 }
yyL1:;

/* line 98 "CallGraphFns.puma" */
  {
/* line 100 "CallGraphFns.puma" */
   if (! ((SameNode (NodeList->CallNodeList.Elem->CallNode.val, nobj)))) goto yyL2;
  {
/* line 102 "CallGraphFns.puma" */
   FoundCallNode = NodeList->CallNodeList.Elem;
  }
  }
   return NodeList;
yyL2:;

/* line 106 "CallGraphFns.puma" */
  {
/* line 107 "CallGraphFns.puma" */
   NodeList->CallNodeList.Next = InsertNode (NodeList->CallNodeList.Next, nobj, kind);
  }
   return NodeList;

}

static rbool SameNode
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj1, register tDefinitions obj2)
# else
(obj1, obj2)
 register tDefinitions obj1;
 register tDefinitions obj2;
# endif
{
  if (obj1->Kind == kFuncObject) {
  if (obj2->Kind == kFuncObject) {
/* line 121 "CallGraphFns.puma" */
  {
/* line 124 "CallGraphFns.puma" */
   if (! ((obj1->FuncObject.Ident == obj2->FuncObject.Ident))) goto yyL1;
  {
/* line 125 "CallGraphFns.puma" */
   if (! ((obj1->FuncObject.in == obj2->FuncObject.in))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

  }
  }
  if (obj1->Kind == kProcObject) {
  if (obj2->Kind == kProcObject) {
/* line 128 "CallGraphFns.puma" */
  {
/* line 131 "CallGraphFns.puma" */
   if (! ((obj1->ProcObject.Ident == obj2->ProcObject.Ident))) goto yyL2;
  {
/* line 132 "CallGraphFns.puma" */
   if (! ((obj1->ProcObject.in == obj2->ProcObject.in))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  }
  return rfalse;
}

tCallGraph CallGraphSearchNode
# if defined __STDC__ | defined __cplusplus
(tObject nobj, register int kind)
# else
(nobj, kind)
 tObject nobj;
 register int kind;
# endif
{
/* line 145 "CallGraphFns.puma" */
   return LocalSearchNode (TheCallGraph, nobj, kind);

}

static tCallGraph LocalSearchNode
# if defined __STDC__ | defined __cplusplus
(register tCallGraph CG, tObject nobj, register int kind)
# else
(CG, nobj, kind)
 register tCallGraph CG;
 tObject nobj;
 register int kind;
# endif
{
/* line 151 "CallGraphFns.puma" */
  {
/* line 152 "CallGraphFns.puma" */
   if (! ((nobj == NoObject))) goto yyL1;
  {
/* line 153 "CallGraphFns.puma" */
   CallGraphError ("no object for searching node");
  }
  }
   return NoCallNode;
yyL1:;

  if (CG->Kind == kCallingGraph) {
  if (equalint (kind, 0)) {
/* line 157 "CallGraphFns.puma" */
  {
/* line 158 "CallGraphFns.puma" */
   CG->CallingGraph.UserNodes = InsertNode (CG->CallingGraph.UserNodes, nobj, kind);
  }
   return FoundCallNode;

  }
  if (equalint (kind, 1)) {
/* line 162 "CallGraphFns.puma" */
  {
/* line 163 "CallGraphFns.puma" */
   CG->CallingGraph.IntrinsicNodes = InsertNode (CG->CallingGraph.IntrinsicNodes, nobj, kind);
  }
   return FoundCallNode;

  }
  if (equalint (kind, 2)) {
/* line 167 "CallGraphFns.puma" */
  {
/* line 168 "CallGraphFns.puma" */
   CG->CallingGraph.ExternalNodes = InsertNode (CG->CallingGraph.ExternalNodes, nobj, kind);
  }
   return FoundCallNode;

  }
  }
 yyAbort ("LocalSearchNode");
 { tCallGraph yyDummy; return yyDummy; }
}

static tCallGraph EdgeListInsert
# if defined __STDC__ | defined __cplusplus
(register tCallGraph edgelist, register tCallGraph node)
# else
(edgelist, node)
 register tCallGraph edgelist;
 register tCallGraph node;
# endif
{
/* line 182 "CallGraphFns.puma" */
 {
  register tCallGraph yyV1;
  {
/* line 183 "CallGraphFns.puma" */
   if (! ((edgelist == NoCallEdges))) goto yyL1;
  }
   yyALLOC (tCallGraph,CallGraph_PoolFreePtr,CallGraph_PoolStartPtr,
    CallGraph_Alloc,yCallEdgeList,MakeCallGraph,yyV1,kCallEdgeList,CallGraph_InitHead)
    yyV1->CallEdgeList.Node = node;
    yyV1->CallEdgeList.count = 1;
    yyV1->CallEdgeList.Next = NoCallEdges;
   return yyV1;
 }
yyL1:;

/* line 187 "CallGraphFns.puma" */
  {
/* line 188 "CallGraphFns.puma" */
   if (! ((edgelist->CallEdgeList.Node == node))) goto yyL2;
  {
/* line 189 "CallGraphFns.puma" */
   edgelist->CallEdgeList.count = edgelist->CallEdgeList.count + 1;
  }
  }
   return edgelist;
yyL2:;

/* line 193 "CallGraphFns.puma" */
  {
/* line 194 "CallGraphFns.puma" */
   edgelist->CallEdgeList.Next = EdgeListInsert (edgelist->CallEdgeList.Next, node);
  }
   return edgelist;

}

void CallGraphInsertEdge
# if defined __STDC__ | defined __cplusplus
(register tCallGraph source, register tCallGraph target)
# else
(source, target)
 register tCallGraph source;
 register tCallGraph target;
# endif
{
/* line 206 "CallGraphFns.puma" */
  {
/* line 207 "CallGraphFns.puma" */
   if (! ((source == NoCallNode))) goto yyL1;
  {
/* line 208 "CallGraphFns.puma" */
   CallGraphError ("Insert edge with source == NIL");
  }
  }
   return;
yyL1:;

/* line 211 "CallGraphFns.puma" */
  {
/* line 212 "CallGraphFns.puma" */
   if (! ((target == NoCallNode))) goto yyL2;
  {
/* line 213 "CallGraphFns.puma" */
   CallGraphError ("Insert edge with target == NIL");
  }
  }
   return;
yyL2:;

/* line 216 "CallGraphFns.puma" */
  {
/* line 218 "CallGraphFns.puma" */
   source->CallNode.calling = EdgeListInsert (source->CallNode.calling, target);
/* line 219 "CallGraphFns.puma" */
   target->CallNode.called_by = EdgeListInsert (target->CallNode.called_by, source);
  }
   return;

;
}

void BeginCallGraphFns ARGS ((void))
{
/* line 74 "CallGraphFns.puma" */


TheCallGraph  = mCallingGraph (NoCallNodes, NoCallNodes, NoCallNodes);
                /* all three lists are empty */


}

void CloseCallGraphFns ARGS ((void))
{
}
