# include "CallGraph.h"
# ifdef __cplusplus
extern "C" {
# include "Reuse.h"
# include "rSystem.h"
# include "General.h"
# include "rMemory.h"
# include "DynArray.h"
}
# else
# include "Reuse.h"
# include "rSystem.h"
# include "General.h"
# include "rMemory.h"
# include "DynArray.h"
# endif

char CallGraph_module_does_not_match_evaluator_module_158242;
char generate_CallGraph_module_without_option_0;

/* line 41 "fortran.call" */


# include <string.h>


# ifdef __cplusplus
#  ifndef yyALLOC
#   define yyALLOC(size1, size2) yyALLOCi (size1, size2)
#  endif
inline tCallGraph yyALLOCi (unsigned long yysize1, unsigned long yysize2)
{ return CallGraph_PoolFreePtr >= CallGraph_PoolStartPtr + yysize1 ?
  (tCallGraph) (CallGraph_PoolFreePtr -= yysize1) : CallGraph_Alloc (yysize2); }
inline tCallGraph yyALLOCk (unsigned long yysize)
{ return yyALLOC (yysize, yysize); }
inline tCallGraph yyALLOCt (unsigned long yysize)
{ return yyALLOC (yyAlignedSize (yysize), yysize); }
# else
#  define yyALLOCk(size) yyALLOC (size, size)
#  define yyALLOCt(size) yyALLOC (yyAlignedSize (size), size)
#  ifndef yyALLOC
#   define yyALLOC(size1, size2) (CallGraph_PoolFreePtr -= (long) size1) >= \
     CallGraph_PoolStartPtr ? (tCallGraph) CallGraph_PoolFreePtr : CallGraph_Alloc (size2)
#  endif
# endif
# ifndef yyFREE
# define yyFREE(ptr, size) 
# endif
# ifdef getchar
# undef getchar
# endif
# ifdef putchar
# undef putchar
# endif
# include "yyCallGraph.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* CallGraph_Exit) ARGS ((void)) = yyExit;

tCallGraph CallGraphRoot;
unsigned long CallGraph_HeapUsed = 0;

yytCallGraph_BlockPtr CallGraph_BlockList	= (yytCallGraph_BlockPtr) NoCallGraph;
char * CallGraph_PoolFreePtr = (char *) & CallGraph_BlockList;
char * CallGraph_PoolStartPtr = (char *) & CallGraph_BlockList;
const unsigned short CallGraph_NodeSize [5] = { 0,
 yyAlignedSize (sizeof (yCallingGraph)),
 yyAlignedSize (sizeof (yCallNode)),
 yyAlignedSize (sizeof (yCallNodeList)),
 yyAlignedSize (sizeof (yCallEdgeList)),
};
static const CallGraph_tKind yyTypeRange [5] = { 0,
 kCallingGraph,
 kCallNode,
 kCallNodeList,
 kCallEdgeList,
};
const char * const CallGraph_NodeName [5] = {
 "NoCallGraph",
 "CallingGraph",
 "CallNode",
 "CallNodeList",
 "CallEdgeList",
};

tCallGraph CallGraph_Alloc
# if defined __STDC__ | defined __cplusplus
 (unsigned short yySize)
# else
 (yySize) unsigned short yySize;
# endif
{
 register yytCallGraph_BlockPtr yyBlockPtr = CallGraph_BlockList;
 CallGraph_BlockList = (yytCallGraph_BlockPtr) Alloc ((unsigned long) sizeof (yytCallGraph_Block));
 if ((tCallGraph) CallGraph_BlockList == NoCallGraph) {
  (void) fprintf (stderr, "CallGraph: out of memory\n"); CallGraph_Exit ();
 }
 CallGraph_BlockList->yySuccessor = yyBlockPtr;
 CallGraph_PoolStartPtr = (char *) CallGraph_BlockList;
 CallGraph_HeapUsed += sizeof (yytCallGraph_Block);
 return (tCallGraph) (CallGraph_PoolFreePtr = CallGraph_PoolStartPtr +
  (yyBlockSize - yyAlignedSize (yySize)));
}

tCallGraph MakeCallGraph
# if defined __STDC__ | defined __cplusplus
 (CallGraph_tKind yyKind)
# else
 (yyKind) CallGraph_tKind yyKind;
# endif
{
 register tCallGraph yyt = yyALLOCk (CallGraph_NodeSize [yyKind]);
 CallGraph_InitHead (yyt, yyKind)
 return yyt;
}

rbool CallGraph_IsType
# if defined __STDC__ | defined __cplusplus
 (register tCallGraph yyt, register CallGraph_tKind yyKind)
# else
 (yyt, yyKind) register tCallGraph yyt; register CallGraph_tKind yyKind;
# endif
{
 return yyt != NoCallGraph && yyKind <= yyt->Kind &&
  yyt->Kind <= yyTypeRange [yyKind];
}


tCallGraph mCallingGraph
# if defined __STDC__ | defined __cplusplus
(tCallGraph pUserNodes, tCallGraph pIntrinsicNodes, tCallGraph pExternalNodes)
# else
(pUserNodes, pIntrinsicNodes, pExternalNodes)
tCallGraph pUserNodes;
tCallGraph pIntrinsicNodes;
tCallGraph pExternalNodes;
# endif
{
 register tCallGraph yyt = yyALLOCt (sizeof (yCallingGraph));
 CallGraph_InitHead (yyt, kCallingGraph)
 yyt->CallingGraph.UserNodes = pUserNodes;
 yyt->CallingGraph.IntrinsicNodes = pIntrinsicNodes;
 yyt->CallingGraph.ExternalNodes = pExternalNodes;
 return yyt;
}

tCallGraph mCallNode
# if defined __STDC__ | defined __cplusplus
(tObject pval, int punitkind, tCallGraph pcalling, tCallGraph pcalled_by)
# else
(pval, punitkind, pcalling, pcalled_by)
tObject pval;
int punitkind;
tCallGraph pcalling;
tCallGraph pcalled_by;
# endif
{
 register tCallGraph yyt = yyALLOCt (sizeof (yCallNode));
 CallGraph_InitHead (yyt, kCallNode)
 yyt->CallNode.val = pval;
 yyt->CallNode.unitkind = punitkind;
 yyt->CallNode.calling = pcalling;
 yyt->CallNode.called_by = pcalled_by;
 return yyt;
}

tCallGraph mCallNodeList
# if defined __STDC__ | defined __cplusplus
(tCallGraph pElem, tCallGraph pNext)
# else
(pElem, pNext)
tCallGraph pElem;
tCallGraph pNext;
# endif
{
 register tCallGraph yyt = yyALLOCt (sizeof (yCallNodeList));
 CallGraph_InitHead (yyt, kCallNodeList)
 yyt->CallNodeList.Elem = pElem;
 yyt->CallNodeList.Next = pNext;
 return yyt;
}

tCallGraph mCallEdgeList
# if defined __STDC__ | defined __cplusplus
(tCallGraph pNode, int pcount, tCallGraph pNext)
# else
(pNode, pcount, pNext)
tCallGraph pNode;
int pcount;
tCallGraph pNext;
# endif
{
 register tCallGraph yyt = yyALLOCt (sizeof (yCallEdgeList));
 CallGraph_InitHead (yyt, kCallEdgeList)
 yyt->CallEdgeList.Node = pNode;
 yyt->CallEdgeList.count = pcount;
 yyt->CallEdgeList.Next = pNext;
 return yyt;
}

static FILE * yyf;

static void yyMark
# if defined __STDC__ | defined __cplusplus
 (register tCallGraph yyt)
# else
 (yyt) register tCallGraph yyt;
# endif
{
 for (;;) {
  if (yyt == NoCallGraph || ++ yyt->yyHead.yyMark > 1) return;

  switch (yyt->Kind) {
case kCallingGraph:
yyMark (yyt->CallingGraph.UserNodes);
yyMark (yyt->CallingGraph.IntrinsicNodes);
yyt = yyt->CallingGraph.ExternalNodes; break;
case kCallNode:
yyMark (yyt->CallNode.calling);
yyt = yyt->CallNode.called_by; break;
case kCallNodeList:
yyMark (yyt->CallNodeList.Elem);
yyt = yyt->CallNodeList.Next; break;
case kCallEdgeList:
yyMark (yyt->CallEdgeList.Node);
yyt = yyt->CallEdgeList.Next; break;
  default: return;
  }
 }
}

# define yyMapToTree(yyLabel) yyTreeStorePtr [yyLabel]
# define yyInitTreeStoreSize 32

static unsigned long yyTreeStoreSize = yyInitTreeStoreSize;
static tCallGraph * yyTreeStorePtr;
static long yyLabelCount;
static short yyRecursionLevel = 0;

static void yyMakeTreeStore ARGS ((void))
{
 if (yyRecursionLevel ++ == 0) {
  MakeArray ((char * *) & yyTreeStorePtr, & yyTreeStoreSize,
   (unsigned long) sizeof (tCallGraph)); yyLabelCount = 0;
 }
}

static void yyReleaseTreeStore ARGS ((void))
{
 if (-- yyRecursionLevel == 0) {
  ReleaseArray ((char * *) & yyTreeStorePtr, & yyTreeStoreSize,
   (unsigned long) sizeof (tCallGraph));
 }
}

static CallGraph_tLabel yyMapToLabel
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 register long yyi;
 for (yyi = 1; yyi <= yyLabelCount; yyi ++)
  if (yyTreeStorePtr [yyi] == yyt) return (CallGraph_tLabel) yyi;
 if (++ yyLabelCount == (long) yyTreeStoreSize)
  ExtendArray ((char * *) & yyTreeStorePtr, & yyTreeStoreSize,
   (unsigned long) sizeof (tCallGraph));
 yyTreeStorePtr [yyLabelCount] = yyt;
 return (CallGraph_tLabel) yyLabelCount;
}

static void yyWriteCallGraph ARGS ((tCallGraph yyt));

static void yyWriteNl ARGS ((void)) { (void) putc ('\n', yyf); }

static void yyWriteSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi = 16 - strlen (yys);
 (void) fputs (yys, yyf);
 while (yyi -- > 0) (void) putc (' ', yyf);
 (void) fputs (" = ", yyf);
}

static void yyWriteHex
# if defined __STDC__ | defined __cplusplus
 (unsigned char * yyx, int yysize)
# else
 (yyx, yysize) unsigned char * yyx; int yysize;
# endif
{ register int yyi; for (yyi = 0; yyi < yysize; yyi ++)
   (void) fprintf (yyf, "%02x ", yyx [yyi]); }

static void yyWriteAdr
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 if (yyt == NoCallGraph) (void) fputs ("NoCallGraph", yyf);
 else (void) fprintf (yyf, "%08lx *", (unsigned long) yyt);
 yyWriteNl ();
}

static void yWriteNodeCallingGraph
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyWriteSelector ("UserNodes");
 yyWriteAdr (yyt->CallingGraph.UserNodes);
 yyWriteSelector ("IntrinsicNodes");
 yyWriteAdr (yyt->CallingGraph.IntrinsicNodes);
 yyWriteSelector ("ExternalNodes");
 yyWriteAdr (yyt->CallingGraph.ExternalNodes);
}

static void yWriteNodeCallNode
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyWriteSelector ("val");
 writetObject (yyt->CallNode.val) yyWriteNl ();
 yyWriteSelector ("unitkind");
 writeint (yyt->CallNode.unitkind) yyWriteNl ();
 yyWriteSelector ("calling");
 yyWriteAdr (yyt->CallNode.calling);
 yyWriteSelector ("called_by");
 yyWriteAdr (yyt->CallNode.called_by);
}

static void yWriteNodeCallNodeList
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyWriteSelector ("Elem");
 yyWriteAdr (yyt->CallNodeList.Elem);
 yyWriteSelector ("Next");
 yyWriteAdr (yyt->CallNodeList.Next);
}

static void yWriteNodeCallEdgeList
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyWriteSelector ("Node");
 yyWriteAdr (yyt->CallEdgeList.Node);
 yyWriteSelector ("count");
 writeint (yyt->CallEdgeList.count) yyWriteNl ();
 yyWriteSelector ("Next");
 yyWriteAdr (yyt->CallEdgeList.Next);
}

void WriteCallGraphNode
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tCallGraph yyt)
# else
 (yyyf, yyt) FILE * yyyf; tCallGraph yyt;
# endif
{
 yyf = yyyf;
 if (yyt == NoCallGraph) { (void) fputs ("NoCallGraph\n", yyf); return; }

 (void) fputs (CallGraph_NodeName [yyt->Kind], yyf); (void) fputc ('\n', yyf);
 writeNodeHead (yyt)
 switch (yyt->Kind) {
case kCallingGraph:
 yWriteNodeCallingGraph (yyt); break;
case kCallNode:
 yWriteNodeCallNode (yyt); break;
case kCallNodeList:
 yWriteNodeCallNodeList (yyt); break;
case kCallEdgeList:
 yWriteNodeCallEdgeList (yyt); break;
 default: ;
 }
}

static short yyIndentLevel;

void WriteCallGraph
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tCallGraph yyt)
# else
 (yyyf, yyt) FILE * yyyf; tCallGraph yyt;
# endif
{
 short yySaveLevel = yyIndentLevel;
 yyf = yyyf;
 yyMark (yyt);
 yyIndentLevel = 0;
 yyMakeTreeStore ();
 yyWriteCallGraph (yyt);
 yyReleaseTreeStore ();
 yyIndentLevel = yySaveLevel;
 if (ferror (yyyf)) {
  (void) fputs ("CallGraph: error in WriteCallGraph\n", stderr); CallGraph_Exit ();
 }
}

static void yyIndentSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
 yyWriteSelector (yys);
}

static void yyIndentSelectorTree
# if defined __STDC__ | defined __cplusplus
 (char * yys, tCallGraph yyt)
# else
 (yys, yyt) char * yys; tCallGraph yyt;
# endif
{ yyIndentSelector (yys); yyWriteCallGraph (yyt); }

static void yWriteCallingGraph
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyIndentSelectorTree ("UserNodes", yyt->CallingGraph.UserNodes);
 yyIndentSelectorTree ("IntrinsicNodes", yyt->CallingGraph.IntrinsicNodes);
}

static void yWriteCallNode
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyIndentSelector ("val");
writetObject (yyt->CallNode.val) yyWriteNl ();
 yyIndentSelector ("unitkind");
writeint (yyt->CallNode.unitkind) yyWriteNl ();
 yyIndentSelectorTree ("calling", yyt->CallNode.calling);
}

static void yWriteCallNodeList
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyIndentSelectorTree ("Elem", yyt->CallNodeList.Elem);
}

static void yWriteCallEdgeList
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyIndentSelectorTree ("Node", yyt->CallEdgeList.Node);
 yyIndentSelector ("count");
writeint (yyt->CallEdgeList.count) yyWriteNl ();
}

static void yyWriteCallGraph
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{ unsigned short yyLevel = yyIndentLevel;
 for (;;) {
  if (yyt == NoCallGraph) { (void) fputs (" NoCallGraph\n", yyf); goto yyExit;
  } else if (yyt->yyHead.yyMark == 0) {
   (void) fprintf (yyf, "^%d\n", yyMapToLabel (yyt)); goto yyExit;
  } else if (yyt->yyHead.yyMark > 1) {
   register int yyi;
   (void) fprintf (yyf, "\n%06d:", yyMapToLabel (yyt));
   for (yyi = 8; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
  } else (void) putc (' ', yyf);
  yyt->yyHead.yyMark = 0;
  yyIndentLevel += 2;

  (void) fputs (CallGraph_NodeName [yyt->Kind], yyf); (void) fputc ('\n', yyf);
  writeNodeHead (yyt)
  switch (yyt->Kind) {
case kCallingGraph: yWriteCallingGraph (yyt);
yyIndentSelector ("ExternalNodes");
yyt = yyt->CallingGraph.ExternalNodes; break;
case kCallNode: yWriteCallNode (yyt);
yyIndentSelector ("called_by");
yyt = yyt->CallNode.called_by; break;
case kCallNodeList: yWriteCallNodeList (yyt);
yyIndentSelector ("Next");
yyt = yyt->CallNodeList.Next; break;
case kCallEdgeList: yWriteCallEdgeList (yyt);
yyIndentSelector ("Next");
yyt = yyt->CallEdgeList.Next; break;
  default: goto yyExit;
  }
 }
yyExit:
 yyIndentLevel = yyLevel;
}

# define yyNil	(unsigned char) 0374
# define yyNoLabel	(unsigned char) 0375
# define yyLabelDef	(unsigned char) 0376
# define yyLabelUse	(unsigned char) 0377

static rbool yyResult;

static void yyCheckCallGraph ARGS ((tCallGraph yyt));

rbool CheckCallGraph
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 yyMark (yyt);
 yyResult = rtrue;
 yyCheckCallGraph (yyt);
 return yyResult;
}

static void yyCheckChild2
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyParent, tCallGraph yyyChild, CallGraph_tKind yyType, char * yySelector)
# else
 (yyParent, yyyChild, yyType, yySelector)
 tCallGraph yyParent, yyyChild;
 CallGraph_tKind yyType;
 char * yySelector;
# endif
{
 if (! CallGraph_IsType (yyyChild, yyType)) {
  yyResult = rfalse;
  (void) fputs ("CheckTree: parent = ", stderr);
  WriteCallGraphNode (stderr, yyParent);
  (void) fprintf (stderr, "\nselector: %s child = ", yySelector);
  WriteCallGraphNode (stderr, yyyChild);
  (void) fputc ('\n', stderr);
 }
}

static void yyCheckChild
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyParent, tCallGraph yyyChild, CallGraph_tKind yyType, char * yySelector)
# else
 (yyParent, yyyChild, yyType, yySelector)
 tCallGraph yyParent, yyyChild;
 CallGraph_tKind yyType;
 char * yySelector;
# endif
{
 yyCheckChild2 (yyParent, yyyChild, yyType, yySelector);
 yyCheckCallGraph (yyyChild);
}

static void yyCheckCallGraph
# if defined __STDC__ | defined __cplusplus
 (tCallGraph yyt)
# else
 (yyt) tCallGraph yyt;
# endif
{
 for (;;) {
  if (yyt == NoCallGraph) { yyResult = rfalse; return; }
  if (yyt->yyHead.yyMark == 0) return;
  yyt->yyHead.yyMark = 0;

  switch (yyt->Kind) {
case kCallingGraph:
yyCheckChild (yyt, yyt->CallingGraph.UserNodes,
kCallNodeList, "UserNodes");
yyCheckChild (yyt, yyt->CallingGraph.IntrinsicNodes,
kCallNodeList, "IntrinsicNodes");
yyCheckChild2 (yyt, yyt->CallingGraph.ExternalNodes,
kCallNodeList, "ExternalNodes");
yyt = yyt->CallingGraph.ExternalNodes; break;
case kCallNode:
yyCheckChild (yyt, yyt->CallNode.calling,
kCallEdgeList, "calling");
yyCheckChild2 (yyt, yyt->CallNode.called_by,
kCallEdgeList, "called_by");
yyt = yyt->CallNode.called_by; break;
case kCallNodeList:
yyCheckChild (yyt, yyt->CallNodeList.Elem,
kCallNode, "Elem");
yyCheckChild2 (yyt, yyt->CallNodeList.Next,
kCallNodeList, "Next");
yyt = yyt->CallNodeList.Next; break;
case kCallEdgeList:
yyCheckChild (yyt, yyt->CallEdgeList.Node,
kCallNode, "Node");
yyCheckChild2 (yyt, yyt->CallEdgeList.Next,
kCallEdgeList, "Next");
yyt = yyt->CallEdgeList.Next; break;
  default: return;
  }
 }
}

void BeginCallGraph ARGS ((void))
{
}

void CloseCallGraph ARGS ((void))
{
/* line 47 "fortran.call" */


}
