# include "BuildTree.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 74 "BuildTree.puma" */


# include <string.h>
# include <ctype.h>

# include "Idents.h"     
# include "StringM.h"    /* GetString, ... */

# define MODEL_GLOBAL  1
# define MODEL_TASK    2
# define MODEL_LOCAL   4
# define MODEL_SERIAL  8

# define LANGUAGE_HPF 16
# define LANGUAGE_F77 32

  /***********************************************************
  *                                                          *
  *  void BuildTreeError (char error_message[])              *
  *                                                          *
  ***********************************************************/

void BuildTreeError (error_message)
char error_message[];

{ fprintf (stderr, "serious error when building the AST : %s\n",
                   error_message);

} /* BuildTreeError */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyBuildTree.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* BuildTree_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module BuildTree, routine %s failed\n",
  yyFunction);
 BuildTree_Exit ();
}

tTree ConcatUnits ARGS ((tTree list1, tTree list2));
tTree CompleteUnits ARGS ((tTree list));
tTree ConcatDecls ARGS ((tTree list1, tTree list2));
tTree CompleteDecls ARGS ((tTree list));
tTree SetDefaultSize ARGS ((tTree type));
tTree SetTypeKind ARGS ((tTree type, tTree kind));
tTree SetTypeSize ARGS ((tTree type, int size));
void SetImplicitType ARGS ((tTree declist, tTree type));
void SetIntent ARGS ((tTree declist, int intent));
static void SetNewAttributes ARGS ((tTree attlist, tTree entity, rbool is_last));
void SetAttributes ARGS ((tTree attlist, tTree entlist));
void SetACFNode ARGS ((tTree node, int label, int line));
void SetACFNodeLine ARGS ((tTree node, int line));
void SetACFNodeLabel ARGS ((tTree node, int label));
static void ResetACFNode ARGS ((tTree node, int label, int line));
void Spec_Exec_Separation ARGS ((tTree body));
static void ExtractSpecifications ARGS ((tTree stats, tTree * yyP2, tTree * yyP1));
static rbool IsSpecification ARGS ((tTree elem));
void LabelForEnd ARGS ((tTree body, int label, int line));
static tTree AppendStmt ARGS ((tTree stmtlist, tTree new));
void SetDefinitionLabel ARGS ((tTree decls, int label));
void MakePrivateDecls ARGS ((tTree t));
void MakePublicDecls ARGS ((tTree t));
tTree MakeComplexConstant ARGS ((tTree exp1, tTree exp2));
static tStringRef RealValue ARGS ((tTree exp));
tTree SetParInfoNew ARGS ((tTree info, tTree new));
tTree SetParInfoReduction ARGS ((tTree info, tTree new));
tTree SetParInfoHome ARGS ((tTree info, tTree home));
tTree SetParInfoResident ARGS ((tTree info, tTree res_var));
void SetIndependent ARGS ((tTree loop));
void SetSerial ARGS ((tTree loop));
tTree ApplyParInfo ARGS ((tTree stmt, tTree info, int line));
void ApplyNewClause ARGS ((tTree stmt, tTree new_vars, int line));
void ApplyResidentClause ARGS ((tTree stmt, tTree res_vars, int line));
static void ApplyHomeClause ARGS ((tTree stmt, tTree home_var, int line));
void SetBody ARGS ((tTree stmt, tTree new_body));
void SetProcessorId ARGS ((tTree spec, tTree id));
void CheckSameIdent ARGS ((tIdent id1, tIdent id2));
void SetMapKind ARGS ((int kind, tStringRef val, tTree decls));
void SetSharedKind ARGS ((int kind, tTree decls));
tTree BuildSingleReductions ARGS ((tTree t));
void SpreadSelection ARGS ((tTree selectees, tTree selections));
tIdent DecodeExtrinsic ARGS ((int kind));
int CodeExtrinsic ARGS ((tStringRef t));
int CodeExtrinsic1 ARGS ((tIdent id, tStringRef t));
int MixExtrinsic ARGS ((int kind1, int kind2));

tTree ConcatUnits
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
/* line 117 "BuildTree.puma" */
  {
/* line 119 "BuildTree.puma" */
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kUNIT_EMPTY) {
/* line 124 "BuildTree.puma" */
   return list2;

  }
  if (list1->Kind == kUNIT_LIST) {
/* line 129 "BuildTree.puma" */
  {
/* line 131 "BuildTree.puma" */
 list1->UNIT_LIST.Next = ConcatUnits (list1->UNIT_LIST.Next, list2); 
  }
   return list1;

  }
/* line 135 "BuildTree.puma" */
  {
/* line 137 "BuildTree.puma" */
   BuildTreeError ("ConcatUnits failed");
  }
   return NoTree;

}

tTree CompleteUnits
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
/* line 143 "BuildTree.puma" */
  {
/* line 144 "BuildTree.puma" */
   if (! ((list == NoTree))) goto yyL1;
  }
   return mUNIT_EMPTY ();
yyL1:;

  if (list->Kind == kUNIT_EMPTY) {
/* line 148 "BuildTree.puma" */
   return list;

  }
  if (list->Kind == kUNIT_LIST) {
/* line 152 "BuildTree.puma" */
  {
/* line 153 "BuildTree.puma" */
 list->UNIT_LIST.Next = CompleteUnits (list->UNIT_LIST.Next); 
  }
   return list;

  }
 yyAbort ("CompleteUnits");
 { tTree yyDummy; return yyDummy; }
}

tTree ConcatDecls
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
/* line 168 "BuildTree.puma" */
  {
/* line 170 "BuildTree.puma" */
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kDECL_EMPTY) {
/* line 174 "BuildTree.puma" */
   return list2;

  }
  if (list1->Kind == kDECL_LIST) {
/* line 179 "BuildTree.puma" */
  {
/* line 181 "BuildTree.puma" */
 list1->DECL_LIST.Next = ConcatDecls (list1->DECL_LIST.Next, list2); 
  }
   return list1;

  }
/* line 185 "BuildTree.puma" */
  {
/* line 186 "BuildTree.puma" */
   BuildTreeError ("ConcatDecls failed");
/* line 187 "BuildTree.puma" */
   WriteTree (stdout, list1);
/* line 188 "BuildTree.puma" */
   WriteTree (stdout, list2);
  }
   return NoTree;

}

tTree CompleteDecls
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
/* line 194 "BuildTree.puma" */
  {
/* line 195 "BuildTree.puma" */
   if (! ((list == NoTree))) goto yyL1;
  }
   return mDECL_EMPTY ();
yyL1:;

  if (list->Kind == kDECL_EMPTY) {
/* line 199 "BuildTree.puma" */
   return list;

  }
  if (list->Kind == kDECL_LIST) {
/* line 203 "BuildTree.puma" */
  {
/* line 204 "BuildTree.puma" */
 list->DECL_LIST.Next = CompleteDecls (list->DECL_LIST.Next); 
  }
   return list;

  }
 yyAbort ("CompleteDecls");
 { tTree yyDummy; return yyDummy; }
}

tTree SetDefaultSize
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
  if (type->Kind == kINTEGER_TYPE) {
/* line 216 "BuildTree.puma" */
  {
/* line 217 "BuildTree.puma" */
   type->INTEGER_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (default_int_size));
  }
   return type;

  }
  if (type->Kind == kBOOLEAN_TYPE) {
/* line 221 "BuildTree.puma" */
  {
/* line 222 "BuildTree.puma" */
   type->BOOLEAN_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (default_int_size));
  }
   return type;

  }
  if (type->Kind == kREAL_TYPE) {
/* line 226 "BuildTree.puma" */
  {
/* line 228 "BuildTree.puma" */
   if (! ((is_double_precision))) goto yyL3;
  {
/* line 229 "BuildTree.puma" */
   type->REAL_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (2 * default_real_size));
  }
  }
   return type;
yyL3:;

/* line 233 "BuildTree.puma" */
  {
/* line 235 "BuildTree.puma" */
   type->REAL_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (default_real_size));
  }
   return type;

  }
  if (type->Kind == kCOMPLEX_TYPE) {
/* line 239 "BuildTree.puma" */
  {
/* line 240 "BuildTree.puma" */
   type->COMPLEX_TYPE.SIZE = mCONST_EXP (mINT_CONSTANT (2 * default_real_size));
  }
   return type;

  }
 yyAbort ("SetDefaultSize");
 { tTree yyDummy; return yyDummy; }
}

tTree SetTypeKind
# if defined __STDC__ | defined __cplusplus
(register tTree type, register tTree kind)
# else
(type, kind)
 register tTree type;
 register tTree kind;
# endif
{
  if (type->Kind == kINTEGER_TYPE) {
/* line 252 "BuildTree.puma" */
  {
/* line 254 "BuildTree.puma" */
   type->INTEGER_TYPE.SIZE = kind;
  }
   return type;

  }
  if (type->Kind == kBOOLEAN_TYPE) {
/* line 257 "BuildTree.puma" */
  {
/* line 259 "BuildTree.puma" */
   type->BOOLEAN_TYPE.SIZE = kind;
  }
   return type;

  }
  if (type->Kind == kREAL_TYPE) {
/* line 262 "BuildTree.puma" */
  {
/* line 264 "BuildTree.puma" */
   type->REAL_TYPE.SIZE = kind;
  }
   return type;

  }
  if (type->Kind == kCOMPLEX_TYPE) {
/* line 267 "BuildTree.puma" */
  {
/* line 269 "BuildTree.puma" */
   type->COMPLEX_TYPE.SIZE = kind;
  }
   return type;

  }
 yyAbort ("SetTypeKind");
 { tTree yyDummy; return yyDummy; }
}

tTree SetTypeSize
# if defined __STDC__ | defined __cplusplus
(register tTree type, register int size)
# else
(type, size)
 register tTree type;
 register int size;
# endif
{
/* line 280 "BuildTree.puma" */
 {
  tTree size_exp;
  register tTree yyV1;
  {
/* line 282 "BuildTree.puma" */
   yyALLOC (tTree,Tree_PoolFreePtr,Tree_PoolStartPtr,
    Tree_Alloc,yCONST_EXP,MakeTree,yyV1,kCONST_EXP,Tree_InitHead)
   {register tTree yyW1;
    yyALLOC (tTree,Tree_PoolFreePtr,Tree_PoolStartPtr,
     Tree_Alloc,yINT_CONSTANT,MakeTree,yyW1,kINT_CONSTANT,Tree_InitHead)
    yyV1->CONST_EXP.C = yyW1;
    yyW1->INT_CONSTANT.value = size;
   }
   size_exp = yyV1;
  }
   return SetTypeKind (type, size_exp);
 }

}

void SetImplicitType
# if defined __STDC__ | defined __cplusplus
(register tTree declist, register tTree type)
# else
(declist, type)
 register tTree declist;
 register tTree type;
# endif
{
 yyRecursion:
/* line 295 "BuildTree.puma" */
  {
/* line 296 "BuildTree.puma" */
   if (! ((declist == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (declist->Kind == kDECL_LIST) {
  if (declist->DECL_LIST.Elem->Kind == kIMPLICIT_DECL) {
/* line 299 "BuildTree.puma" */
  {
/* line 301 "BuildTree.puma" */
 declist->DECL_LIST.Elem->IMPLICIT_DECL.TYPE = type; 
/* line 302 "BuildTree.puma" */
   declist = declist->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
/* line 305 "BuildTree.puma" */
  {
/* line 306 "BuildTree.puma" */
   declist = declist->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
/* line 309 "BuildTree.puma" */
  {
/* line 310 "BuildTree.puma" */
   printf ("illegal call of SetImplicitType\n");
/* line 311 "BuildTree.puma" */
   WriteTree (stdout, declist);
  }
   return;

;
}

void SetIntent
# if defined __STDC__ | defined __cplusplus
(register tTree declist, register int intent)
# else
(declist, intent)
 register tTree declist;
 register int intent;
# endif
{
 yyRecursion:
/* line 322 "BuildTree.puma" */
  {
/* line 323 "BuildTree.puma" */
   if (! ((declist == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (declist->Kind == kDECL_LIST) {
  if (declist->DECL_LIST.Elem->Kind == kINTENT_DECL) {
/* line 326 "BuildTree.puma" */
  {
/* line 328 "BuildTree.puma" */
 declist->DECL_LIST.Elem->INTENT_DECL.intent = intent; 
/* line 329 "BuildTree.puma" */
   declist = declist->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  }
/* line 332 "BuildTree.puma" */
  {
/* line 333 "BuildTree.puma" */
   printf ("illegal call of SetIntent\n");
/* line 334 "BuildTree.puma" */
   WriteTree (stdout, declist);
  }
   return;

;
}

static void SetNewAttributes
# if defined __STDC__ | defined __cplusplus
(register tTree attlist, register tTree entity, register rbool is_last)
# else
(attlist, entity, is_last)
 register tTree attlist;
 register tTree entity;
 register rbool is_last;
# endif
{
/* line 351 "BuildTree.puma" */
  {
/* line 352 "BuildTree.puma" */
   if (! ((attlist == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (attlist->Kind == kDECL_LIST) {
  if (entity->Kind == kENTITY_DECL) {
/* line 355 "BuildTree.puma" */
  {
/* line 357 "BuildTree.puma" */
   if (! ((is_last == rtrue))) goto yyL2;
  {
/* line 358 "BuildTree.puma" */
   SetNewAttributes (attlist->DECL_LIST.Next, entity, is_last);
/* line 359 "BuildTree.puma" */
 attlist->DECL_LIST.Next       = entity->ENTITY_DECL.ATTRIBUTES;
    entity->ENTITY_DECL.ATTRIBUTES = attlist;
  
  }
  }
   return;
yyL2:;

/* line 364 "BuildTree.puma" */
  {
/* line 365 "BuildTree.puma" */
   if (! ((is_last != rtrue))) goto yyL3;
  {
/* line 366 "BuildTree.puma" */
   SetNewAttributes (attlist->DECL_LIST.Next, entity, is_last);
/* line 367 "BuildTree.puma" */
 entity->ENTITY_DECL.ATTRIBUTES = mDECL_LIST (CopyTree (attlist->DECL_LIST.Elem), entity->ENTITY_DECL.ATTRIBUTES); 
  }
  }
   return;
yyL3:;

  }
  }
/* line 370 "BuildTree.puma" */
  {
/* line 371 "BuildTree.puma" */
   printf ("illegal call of SetNewAttributes\n");
/* line 372 "BuildTree.puma" */
   WriteTree (stdout, attlist);
  }
   return;

;
}

void SetAttributes
# if defined __STDC__ | defined __cplusplus
(register tTree attlist, register tTree entlist)
# else
(attlist, entlist)
 register tTree attlist;
 register tTree entlist;
# endif
{
 yyRecursion:
/* line 390 "BuildTree.puma" */
  {
/* line 391 "BuildTree.puma" */
   if (! ((entlist == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (entlist->Kind == kDECL_LIST) {
  if (entlist->DECL_LIST.Elem->Kind == kENTITY_DECL) {
/* line 395 "BuildTree.puma" */
 {
  rbool is_last;
  {
/* line 399 "BuildTree.puma" */
 is_last = (entlist->DECL_LIST.Next == NoTree); 
    SetNewAttributes (attlist, entlist->DECL_LIST.Elem, is_last);
  
/* line 402 "BuildTree.puma" */
   entlist = entlist->DECL_LIST.Next;
   goto yyRecursion;
  }
 }

  }
  }
/* line 405 "BuildTree.puma" */
  {
/* line 406 "BuildTree.puma" */
   printf ("illegal call of SetAttributes\n");
/* line 407 "BuildTree.puma" */
   WriteTree (stdout, entlist);
  }
   return;

;
}

void SetACFNode
# if defined __STDC__ | defined __cplusplus
(register tTree node, register int label, register int line)
# else
(node, label, line)
 register tTree node;
 register int label;
 register int line;
# endif
{
  if (Tree_IsType (node, kACF_NODE)) {
/* line 420 "BuildTree.puma" */
  {
/* line 422 "BuildTree.puma" */
   node->ACF_NODE.Label = label;
/* line 423 "BuildTree.puma" */
   node->ACF_NODE.Line = line;
  }
   return;

  }
;
}

void SetACFNodeLine
# if defined __STDC__ | defined __cplusplus
(register tTree node, register int line)
# else
(node, line)
 register tTree node;
 register int line;
# endif
{
  if (Tree_IsType (node, kACF_NODE)) {
/* line 428 "BuildTree.puma" */
  {
/* line 430 "BuildTree.puma" */
   node->ACF_NODE.Line = line;
  }
   return;

  }
;
}

void SetACFNodeLabel
# if defined __STDC__ | defined __cplusplus
(register tTree node, register int label)
# else
(node, label)
 register tTree node;
 register int label;
# endif
{
  if (Tree_IsType (node, kACF_NODE)) {
/* line 435 "BuildTree.puma" */
  {
/* line 437 "BuildTree.puma" */
   if (! ((label == 0))) goto yyL1;
  }
   return;
yyL1:;

/* line 440 "BuildTree.puma" */
  {
/* line 442 "BuildTree.puma" */
   if (! ((node->ACF_NODE.Label == 0))) goto yyL2;
  {
/* line 444 "BuildTree.puma" */
   node->ACF_NODE.Label = label;
  }
  }
   return;
yyL2:;

/* line 447 "BuildTree.puma" */
  {
/* line 449 "BuildTree.puma" */
 char msg[100];
     sprintf (msg, "two labels for a node (old=%d,new=%d)", 
                   node->ACF_NODE.Label, label);
     BuildTreeError (msg);
   
  }
   return;

  }
;
}

static void ResetACFNode
# if defined __STDC__ | defined __cplusplus
(register tTree node, register int label, register int line)
# else
(node, label, line)
 register tTree node;
 register int label;
 register int line;
# endif
{
  if (Tree_IsType (node, kACF_NODE)) {
/* line 464 "BuildTree.puma" */
  {
/* line 466 "BuildTree.puma" */
   if (! ((node->ACF_NODE.Label != 0))) goto yyL1;
  {
/* line 467 "BuildTree.puma" */
   if (! ((label != 0))) goto yyL1;
  {
/* line 469 "BuildTree.puma" */
   fprintf (stderr, "ERROR: Statement is labelled twice, old label = %d, new label = %d\n", node->ACF_NODE.Label, label);
/* line 473 "BuildTree.puma" */
   node->ACF_NODE.Line = line;
  }
  }
  }
   return;
yyL1:;

/* line 476 "BuildTree.puma" */
  {
/* line 480 "BuildTree.puma" */
   if (! ((node->ACF_NODE.Label != 0))) goto yyL2;
  {
/* line 481 "BuildTree.puma" */
   node->ACF_NODE.Line = line;
  }
  }
   return;
yyL2:;

/* line 484 "BuildTree.puma" */
  {
/* line 486 "BuildTree.puma" */
   node->ACF_NODE.Label = label;
/* line 487 "BuildTree.puma" */
   node->ACF_NODE.Line = line;
  }
   return;

  }
;
}

void Spec_Exec_Separation
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
/* line 500 "BuildTree.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 502 "BuildTree.puma" */
   ExtractSpecifications (body->BODY_NODE.STATS, & yyV1, & yyV2);
/* line 504 "BuildTree.puma" */
 body->BODY_NODE.STATS = yyV1; 
     if (yyV2 != NoTree)
       body->BODY_NODE.DECLS = ConcatDecls (body->BODY_NODE.DECLS, CompleteDecls (yyV2));
   
  }
   return;
 }

  }
;
}

static void ExtractSpecifications
# if defined __STDC__ | defined __cplusplus
(register tTree stats, register tTree * yyP2, register tTree * yyP1)
# else
(stats, yyP2, yyP1)
 register tTree stats;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{

  switch (stats->Kind) {
  case kACF_LIST:
/* line 512 "BuildTree.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 514 "BuildTree.puma" */
   if (! ((IsSpecification (stats->ACF_LIST.Elem)))) goto yyL1;
  {
/* line 515 "BuildTree.puma" */
   ExtractSpecifications (stats->ACF_LIST.Next, & yyV1, & yyV2);
  }
  }
   * yyP2 = yyV1;
   * yyP1 = ConcatDecls (stats->ACF_LIST.Elem, yyV2);
   return;
 }
yyL1:;

/* line 518 "BuildTree.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 520 "BuildTree.puma" */
   ExtractSpecifications (stats->ACF_LIST.Elem, & yyV1, & yyV2);
/* line 521 "BuildTree.puma" */
   ExtractSpecifications (stats->ACF_LIST.Next, & yyV3, & yyV4);
/* line 522 "BuildTree.puma" */
 stats->ACF_LIST.Next = yyV3; 
  }
   * yyP2 = stats;
   * yyP1 = ConcatDecls (yyV2, yyV4);
   return;
 }

  case kACF_EMPTY:
/* line 525 "BuildTree.puma" */
   * yyP2 = stats;
   * yyP1 = NoTree;
   return;

  case kACF_DO:
/* line 528 "BuildTree.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 530 "BuildTree.puma" */
   ExtractSpecifications (stats->ACF_DO.DO_BODY, & yyV1, & yyV2);
/* line 531 "BuildTree.puma" */
 stats->ACF_DO.DO_BODY = yyV1; 
  }
   * yyP2 = stats;
   * yyP1 = yyV2;
   return;
 }

  case kACF_FORALL:
/* line 534 "BuildTree.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 536 "BuildTree.puma" */
   ExtractSpecifications (stats->ACF_FORALL.FORALL_BODY, & yyV1, & yyV2);
/* line 537 "BuildTree.puma" */
 stats->ACF_FORALL.FORALL_BODY = yyV1; 
  }
   * yyP2 = stats;
   * yyP1 = yyV2;
   return;
 }

  case kACF_WHILE:
/* line 540 "BuildTree.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 542 "BuildTree.puma" */
   ExtractSpecifications (stats->ACF_WHILE.WHILE_BODY, & yyV1, & yyV2);
/* line 543 "BuildTree.puma" */
 stats->ACF_WHILE.WHILE_BODY = yyV1; 
  }
   * yyP2 = stats;
   * yyP1 = yyV2;
   return;
 }

  case kACF_IF:
/* line 546 "BuildTree.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 548 "BuildTree.puma" */
   ExtractSpecifications (stats->ACF_IF.THEN_PART, & yyV1, & yyV2);
/* line 549 "BuildTree.puma" */
   ExtractSpecifications (stats->ACF_IF.ELSE_PART, & yyV3, & yyV4);
/* line 550 "BuildTree.puma" */
 stats->ACF_IF.THEN_PART = yyV1; stats->ACF_IF.ELSE_PART = yyV3; 
  }
   * yyP2 = stats;
   * yyP1 = ConcatDecls (yyV2, yyV4);
   return;
 }

  case kACF_WHERE:
/* line 553 "BuildTree.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 555 "BuildTree.puma" */
   ExtractSpecifications (stats->ACF_WHERE.TRUE_PART, & yyV1, & yyV2);
/* line 556 "BuildTree.puma" */
   ExtractSpecifications (stats->ACF_WHERE.FALSE_PART, & yyV3, & yyV4);
/* line 557 "BuildTree.puma" */
 stats->ACF_WHERE.TRUE_PART = yyV1; stats->ACF_WHERE.FALSE_PART = yyV3; 
  }
   * yyP2 = stats;
   * yyP1 = ConcatDecls (yyV2, yyV4);
   return;
 }

  case kACF_NODE:
  case kACF_DUMMY:
  case kACF_BASIC:
  case kACF_CASE:
  case kACF_REPEAT:
  case kACF_LOOP:
  case kACF_FLOW_GRAPH:
  case kACF_ENTRY:
  case kACF_HOME:
  case kACF_RESIDENT:
  case kACF_NEW:
  case kACF_REDUCTION:
  case kACF_TASK_REGION:
  case kACF_PARALLEL:
  case kACF_CRITICAL:
  case kACF_ON:
  case kACF_RM_READ:
  case kACF_RM_WRITE:
  case kACF_MOVE:
  case kACF_BARRIER:
  case kACF_UPDATE:
/* line 560 "BuildTree.puma" */
   * yyP2 = stats;
   * yyP1 = NoTree;
   return;

  }

/* line 563 "BuildTree.puma" */
  {
/* line 564 "BuildTree.puma" */
   fprintf (stderr, "illegal tree in ExtractSpecifications");
  }
   * yyP2 = stats;
   * yyP1 = NoTree;
   return;

;
}

static rbool IsSpecification
# if defined __STDC__ | defined __cplusplus
(register tTree elem)
# else
(elem)
 register tTree elem;
# endif
{
  if (elem->Kind == kDECL_LIST) {
/* line 569 "BuildTree.puma" */
   return rtrue;

  }
  return rfalse;
}

void LabelForEnd
# if defined __STDC__ | defined __cplusplus
(register tTree body, register int label, register int line)
# else
(body, label, line)
 register tTree body;
 register int label;
 register int line;
# endif
{
/* line 592 "BuildTree.puma" */
  {
/* line 593 "BuildTree.puma" */
   if (! ((label == 0))) goto yyL1;
  }
   return;
yyL1:;

  if (body->Kind == kBODY_NODE) {
/* line 596 "BuildTree.puma" */
 {
  tTree cont;
  {
/* line 600 "BuildTree.puma" */
 cont = mACF_DUMMY ();
     cont->ACF_NODE.Label = label;
     cont->ACF_NODE.Line  = line;

     body->BODY_NODE.STATS = AppendStmt (body->BODY_NODE.STATS, cont);
   
  }
   return;
 }

  }
;
}

static tTree AppendStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmtlist, register tTree new)
# else
(stmtlist, new)
 register tTree stmtlist;
 register tTree new;
# endif
{
  if (stmtlist->Kind == kACF_EMPTY) {
/* line 610 "BuildTree.puma" */
   return mACF_LIST (new, stmtlist);

  }
  if (stmtlist->Kind == kACF_LIST) {
/* line 614 "BuildTree.puma" */
  {
/* line 615 "BuildTree.puma" */
 stmtlist->ACF_LIST.Next = AppendStmt (stmtlist->ACF_LIST.Next, new); 
  }
   return stmtlist;

  }
 yyAbort ("AppendStmt");
 { tTree yyDummy; return yyDummy; }
}

void SetDefinitionLabel
# if defined __STDC__ | defined __cplusplus
(register tTree decls, register int label)
# else
(decls, label)
 register tTree decls;
 register int label;
# endif
{
 yyRecursion:
/* line 629 "BuildTree.puma" */
  {
/* line 630 "BuildTree.puma" */
   if (! ((label == 0))) goto yyL1;
  }
   return;
yyL1:;

/* line 633 "BuildTree.puma" */
  {
/* line 634 "BuildTree.puma" */
   if (! ((decls == NoTree))) goto yyL2;
  }
   return;
yyL2:;

  if (decls->Kind == kDECL_LIST) {
  if (decls->DECL_LIST.Elem->Kind == kFORMAT_DECL) {
/* line 637 "BuildTree.puma" */
  {
/* line 639 "BuildTree.puma" */
   decls->DECL_LIST.Elem->FORMAT_DECL.label = label;
/* line 640 "BuildTree.puma" */
   decls = decls->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  }
;
}

void MakePrivateDecls
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
/* line 651 "BuildTree.puma" */
  {
/* line 652 "BuildTree.puma" */
   if (! ((t == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kDECL_LIST) {
/* line 655 "BuildTree.puma" */
  {
/* line 656 "BuildTree.puma" */
   MakePrivateDecls (t->DECL_LIST.Elem);
/* line 657 "BuildTree.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kNAME_DECL) {
/* line 660 "BuildTree.puma" */
  {
/* line 661 "BuildTree.puma" */
 t->Kind = kPRIVATE_DECL; 
  }
   return;

  }
;
}

void MakePublicDecls
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
/* line 666 "BuildTree.puma" */
  {
/* line 667 "BuildTree.puma" */
   if (! ((t == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kDECL_LIST) {
/* line 670 "BuildTree.puma" */
  {
/* line 671 "BuildTree.puma" */
   MakePublicDecls (t->DECL_LIST.Elem);
/* line 672 "BuildTree.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kNAME_DECL) {
/* line 675 "BuildTree.puma" */
  {
/* line 676 "BuildTree.puma" */
 t->Kind = kPUBLIC_DECL; 
  }
   return;

  }
;
}

tTree MakeComplexConstant
# if defined __STDC__ | defined __cplusplus
(register tTree exp1, register tTree exp2)
# else
(exp1, exp2)
 register tTree exp1;
 register tTree exp2;
# endif
{
/* line 687 "BuildTree.puma" */
   return mCOMPLEX_CONSTANT (RealValue (exp1), RealValue (exp2));

}

static tStringRef RealValue
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
 yyRecursion:
  if (exp->Kind == kCONST_EXP) {
/* line 694 "BuildTree.puma" */
   exp = exp->CONST_EXP.C;
   goto yyRecursion;

  }
  if (exp->Kind == kREAL_CONSTANT) {
/* line 699 "BuildTree.puma" */
   return exp->REAL_CONSTANT.value;

  }
  if (exp->Kind == kINT_CONSTANT) {
/* line 704 "BuildTree.puma" */
 {
  tStringRef p;
  {
/* line 708 "BuildTree.puma" */
 char number[20];
     sprintf (number, "%d", exp->INT_CONSTANT.value);
     p = PutString (number, strlen (number));
   
  }
   return p;
 }

  }
  if (exp->Kind == kOP1_EXP) {
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_PSIGN) {
/* line 716 "BuildTree.puma" */
   exp = exp->OP1_EXP.OPND;
   goto yyRecursion;

  }
  if (exp->OP1_EXP.EXP_OP1->Kind == kOP1_SIGN) {
/* line 721 "BuildTree.puma" */
 {
  tStringRef p;
  {
/* line 725 "BuildTree.puma" */
 char number[40], number1[40];
     p = RealValue (exp->OP1_EXP.OPND);
     StGetString (p, number1);
     sprintf (number, "-%s", number1);
     p = PutString (number, strlen (number));
   
  }
   return p;
 }

  }
  }
/* line 735 "BuildTree.puma" */
  {
/* line 737 "BuildTree.puma" */
 extern void SourceError();   

     SourceError ("illegal complex constant");
     fprintf (stderr, " (please use unsigned real numbers)\n");
   
  }
   return PutString ("1.0", 3);

}

tTree SetParInfoNew
# if defined __STDC__ | defined __cplusplus
(register tTree info, register tTree new)
# else
(info, new)
 register tTree info;
 register tTree new;
# endif
{
  if (info->Kind == kPARALLEL_INFO) {
/* line 754 "BuildTree.puma" */
  {
/* line 756 "BuildTree.puma" */
   if (! ((info->PARALLEL_INFO.new_vars == NoTree))) goto yyL1;
  {
/* line 758 "BuildTree.puma" */
   info->PARALLEL_INFO.new_vars = new;
  }
  }
   return info;
yyL1:;

  }
/* line 763 "BuildTree.puma" */
   return info;

}

tTree SetParInfoReduction
# if defined __STDC__ | defined __cplusplus
(register tTree info, register tTree new)
# else
(info, new)
 register tTree info;
 register tTree new;
# endif
{
  if (info->Kind == kPARALLEL_INFO) {
/* line 770 "BuildTree.puma" */
  {
/* line 772 "BuildTree.puma" */
   if (! ((info->PARALLEL_INFO.reduction_vars == NoTree))) goto yyL1;
  {
/* line 774 "BuildTree.puma" */
   info->PARALLEL_INFO.reduction_vars = new;
  }
  }
   return info;
yyL1:;

  }
/* line 779 "BuildTree.puma" */
   return info;

}

tTree SetParInfoHome
# if defined __STDC__ | defined __cplusplus
(register tTree info, register tTree home)
# else
(info, home)
 register tTree info;
 register tTree home;
# endif
{
  if (info->Kind == kPARALLEL_INFO) {
/* line 786 "BuildTree.puma" */
  {
/* line 788 "BuildTree.puma" */
   if (! ((info->PARALLEL_INFO.home_var == NoTree))) goto yyL1;
  {
/* line 790 "BuildTree.puma" */
   info->PARALLEL_INFO.home_var = home;
  }
  }
   return info;
yyL1:;

  }
/* line 795 "BuildTree.puma" */
   return info;

}

tTree SetParInfoResident
# if defined __STDC__ | defined __cplusplus
(register tTree info, register tTree res_var)
# else
(info, res_var)
 register tTree info;
 register tTree res_var;
# endif
{
  if (info->Kind == kPARALLEL_INFO) {
/* line 802 "BuildTree.puma" */
  {
/* line 804 "BuildTree.puma" */
   if (! ((info->PARALLEL_INFO.resident_vars == NoTree))) goto yyL1;
  {
/* line 806 "BuildTree.puma" */
   info->PARALLEL_INFO.resident_vars = res_var;
  }
  }
   return info;
yyL1:;

  }
/* line 811 "BuildTree.puma" */
   return info;

}

void SetIndependent
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
/* line 827 "BuildTree.puma" */
  {
/* line 831 "BuildTree.puma" */
 loop->ACF_DO.DO_DEP_INFO = mINDEP_INFO (rtrue, 0, NoTree, NoTree); 
  }
   return;

  }
  if (loop->Kind == kACF_FORALL) {
  if (loop->ACF_FORALL.FORALL_BODY->Kind == kACF_LIST) {
  if (loop->ACF_FORALL.FORALL_BODY->ACF_LIST.Elem->Kind == kACF_FORALL) {
  if (loop->ACF_FORALL.FORALL_BODY->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 835 "BuildTree.puma" */
  {
/* line 839 "BuildTree.puma" */
   SetIndependent (loop->ACF_FORALL.FORALL_BODY->ACF_LIST.Elem);
/* line 841 "BuildTree.puma" */
   goto yyL2;
  }
yyL2:;

  }
  }
  }
/* line 844 "BuildTree.puma" */
  {
/* line 846 "BuildTree.puma" */
   if (! ((loop->ACF_FORALL.FORALL_DEP_INFO == NoTree))) goto yyL3;
  {
/* line 850 "BuildTree.puma" */
 loop->ACF_FORALL.FORALL_DEP_INFO = mINDEP_INFO (rtrue, 0, NoTree, NoTree); 
  }
  }
   return;
yyL3:;

  }
;
}

void SetSerial
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_FORALL) {
  if (loop->ACF_FORALL.FORALL_BODY->Kind == kACF_LIST) {
  if (loop->ACF_FORALL.FORALL_BODY->ACF_LIST.Elem->Kind == kACF_FORALL) {
  if (loop->ACF_FORALL.FORALL_BODY->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 861 "BuildTree.puma" */
  {
/* line 865 "BuildTree.puma" */
   SetSerial (loop->ACF_FORALL.FORALL_BODY->ACF_LIST.Elem);
/* line 867 "BuildTree.puma" */
   goto yyL1;
  }
yyL1:;

  }
  }
  }
/* line 870 "BuildTree.puma" */
  {
/* line 872 "BuildTree.puma" */
   if (! ((loop->ACF_FORALL.FORALL_DEP_INFO == NoTree))) goto yyL2;
  {
/* line 874 "BuildTree.puma" */
 loop->ACF_FORALL.FORALL_DEP_INFO = mSERIAL_INFO (); 
  }
  }
   return;
yyL2:;

  }
;
}

tTree ApplyParInfo
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree info, register int line)
# else
(stmt, info, line)
 register tTree stmt;
 register tTree info;
 register int line;
# endif
{
 yyRecursion:
  if (info->Kind == kPARALLEL_INFO) {
/* line 885 "BuildTree.puma" */
  {
/* line 887 "BuildTree.puma" */
   if (! ((info->PARALLEL_INFO.new_vars != NoTree))) goto yyL1;
  {
/* line 889 "BuildTree.puma" */
   ApplyNewClause (stmt, info->PARALLEL_INFO.new_vars, line);
/* line 891 "BuildTree.puma" */
 info->PARALLEL_INFO.new_vars = NoTree;    
  }
  }
   goto yyRecursion;
yyL1:;

/* line 896 "BuildTree.puma" */
  {
/* line 898 "BuildTree.puma" */
   if (! ((info->PARALLEL_INFO.resident_vars != NoTree))) goto yyL2;
  {
/* line 900 "BuildTree.puma" */
   ApplyResidentClause (stmt, info->PARALLEL_INFO.resident_vars, line);
/* line 902 "BuildTree.puma" */
 info->PARALLEL_INFO.resident_vars = NoTree;    
  }
  }
   goto yyRecursion;
yyL2:;

/* line 907 "BuildTree.puma" */
  {
/* line 909 "BuildTree.puma" */
   if (! ((info->PARALLEL_INFO.home_var != NoTree))) goto yyL3;
  {
/* line 911 "BuildTree.puma" */
   ApplyHomeClause (stmt, info->PARALLEL_INFO.home_var, line);
/* line 913 "BuildTree.puma" */
 info->PARALLEL_INFO.home_var = NoTree;    
  }
  }
   goto yyRecursion;
yyL3:;

/* line 918 "BuildTree.puma" */
 {
  tTree new;
  tTree h_red_vars;
  {
/* line 920 "BuildTree.puma" */
   if (! ((info->PARALLEL_INFO.reduction_vars != NoTree))) goto yyL4;
  {
/* line 926 "BuildTree.puma" */
   h_red_vars = info->PARALLEL_INFO.reduction_vars;
/* line 927 "BuildTree.puma" */
   info->PARALLEL_INFO.reduction_vars = NoTree;
/* line 929 "BuildTree.puma" */
   new = ApplyParInfo (stmt, info, line);
/* line 930 "BuildTree.puma" */
   new = mACF_LIST (new, mACF_EMPTY ());
/* line 931 "BuildTree.puma" */
   new = mACF_REDUCTION (kDEFAULT_REDUCTION, h_red_vars, mPROC_OBJ (DefaultId ()), new);
/* line 933 "BuildTree.puma" */
   SetACFNodeLine (new, line);
/* line 934 "BuildTree.puma" */
   new = BuildSingleReductions (new);
  }
  }
   return new;
 }
yyL4:;

  }
/* line 939 "BuildTree.puma" */
   return stmt;

}

void ApplyNewClause
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree new_vars, register int line)
# else
(stmt, new_vars, line)
 register tTree stmt;
 register tTree new_vars;
 register int line;
# endif
{
  if (stmt->Kind == kACF_DO) {
/* line 952 "BuildTree.puma" */
 {
  tTree help;
  {
/* line 956 "BuildTree.puma" */
 help = mACF_NEW (new_vars, stmt->ACF_DO.DO_BODY);
    SetACFNodeLine (help, line);
    stmt->ACF_DO.DO_BODY = mACF_LIST (help, mACF_EMPTY ()); 
  
  }
   return;
 }

  }
  if (stmt->Kind == kACF_HOME) {
/* line 962 "BuildTree.puma" */
 {
  tTree help;
  {
/* line 966 "BuildTree.puma" */
 help = mACF_NEW (new_vars, stmt->ACF_HOME.HOME_BODY);
    SetACFNodeLine (help, line);
    stmt->ACF_HOME.HOME_BODY = mACF_LIST (help, mACF_EMPTY ()); 
  
  }
   return;
 }

  }
  if (stmt->Kind == kACF_FORALL) {
/* line 972 "BuildTree.puma" */
  {
/* line 974 "BuildTree.puma" */
   fprintf (stderr, "NEW not allowed for FORALL statement/construct\n");
  }
   return;

  }
;
}

void ApplyResidentClause
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree res_vars, register int line)
# else
(stmt, res_vars, line)
 register tTree stmt;
 register tTree res_vars;
 register int line;
# endif
{
  if (stmt->Kind == kACF_DO) {
/* line 987 "BuildTree.puma" */
 {
  tTree help;
  {
/* line 991 "BuildTree.puma" */
 help = mACF_RESIDENT (res_vars, stmt->ACF_DO.DO_BODY);
    SetACFNodeLine (help, line);
    stmt->ACF_DO.DO_BODY = mACF_LIST (help, mACF_EMPTY ()); 
  
  }
   return;
 }

  }
  if (stmt->Kind == kACF_HOME) {
/* line 997 "BuildTree.puma" */
 {
  tTree help;
  {
/* line 1001 "BuildTree.puma" */
 help = mACF_RESIDENT (res_vars, stmt->ACF_HOME.HOME_BODY);
    SetACFNodeLine (help, line);
    stmt->ACF_HOME.HOME_BODY = mACF_LIST (help, mACF_EMPTY ()); 
  
  }
   return;
 }

  }
  if (stmt->Kind == kACF_FORALL) {
/* line 1007 "BuildTree.puma" */
  {
/* line 1009 "BuildTree.puma" */
   fprintf (stderr, "RESIDENT not allowed for FORALL statement/construct\n");
  }
   return;

  }
;
}

static void ApplyHomeClause
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree home_var, register int line)
# else
(stmt, home_var, line)
 register tTree stmt;
 register tTree home_var;
 register int line;
# endif
{
  if (stmt->Kind == kACF_DO) {
/* line 1022 "BuildTree.puma" */
 {
  tTree help;
  {
/* line 1026 "BuildTree.puma" */
 help = mACF_HOME (home_var, rtrue, stmt->ACF_DO.DO_BODY);
    SetACFNodeLine (help, line);
    stmt->ACF_DO.DO_BODY = mACF_LIST (help, mACF_EMPTY ()); 
  
  }
   return;
 }

  }
  if (stmt->Kind == kACF_FORALL) {
/* line 1032 "BuildTree.puma" */
  {
/* line 1034 "BuildTree.puma" */
   fprintf (stderr, "HOME not allowed for FORALL statement/construct\n");
  }
   return;

  }
;
}

void SetBody
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree new_body)
# else
(stmt, new_body)
 register tTree stmt;
 register tTree new_body;
# endif
{
 yyRecursion:
  if (stmt->Kind == kACF_LIST) {
  if (stmt->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 1047 "BuildTree.puma" */
  {
/* line 1049 "BuildTree.puma" */
   stmt = stmt->ACF_LIST.Elem;
   goto yyRecursion;
  }

  }
  }
  if (stmt->Kind == kACF_HOME) {
/* line 1052 "BuildTree.puma" */
  {
/* line 1054 "BuildTree.puma" */
   if (! ((stmt->ACF_HOME.HOME_BODY == NoTree))) goto yyL2;
  {
/* line 1056 "BuildTree.puma" */
 stmt->ACF_HOME.HOME_BODY = new_body; 
  }
  }
   return;
yyL2:;

/* line 1059 "BuildTree.puma" */
  {
/* line 1061 "BuildTree.puma" */
   stmt = stmt->ACF_HOME.HOME_BODY;
   goto yyRecursion;
  }

  }
  if (stmt->Kind == kACF_NEW) {
/* line 1064 "BuildTree.puma" */
  {
/* line 1066 "BuildTree.puma" */
   if (! ((stmt->ACF_NEW.NEW_BODY == NoTree))) goto yyL4;
  {
/* line 1068 "BuildTree.puma" */
 stmt->ACF_NEW.NEW_BODY = new_body; 
  }
  }
   return;
yyL4:;

/* line 1071 "BuildTree.puma" */
  {
/* line 1073 "BuildTree.puma" */
   stmt = stmt->ACF_NEW.NEW_BODY;
   goto yyRecursion;
  }

  }
  if (stmt->Kind == kACF_RESIDENT) {
/* line 1076 "BuildTree.puma" */
  {
/* line 1078 "BuildTree.puma" */
   if (! ((stmt->ACF_RESIDENT.RESIDENT_BODY == NoTree))) goto yyL6;
  {
/* line 1080 "BuildTree.puma" */
 stmt->ACF_RESIDENT.RESIDENT_BODY = new_body; 
  }
  }
   return;
yyL6:;

/* line 1083 "BuildTree.puma" */
  {
/* line 1085 "BuildTree.puma" */
   stmt = stmt->ACF_RESIDENT.RESIDENT_BODY;
   goto yyRecursion;
  }

  }
;
}

void SetProcessorId
# if defined __STDC__ | defined __cplusplus
(register tTree spec, register tTree id)
# else
(spec, id)
 register tTree spec;
 register tTree id;
# endif
{
  if (spec->Kind == kPROCESSOR_ARRAY) {
/* line 1096 "BuildTree.puma" */
  {
/* line 1098 "BuildTree.puma" */
 spec->PROCESSOR_ARRAY.TOPNAME = id; 
  }
   return;

  }
  if (spec->Kind == kPROCESSOR_SUBSET) {
/* line 1101 "BuildTree.puma" */
  {
/* line 1103 "BuildTree.puma" */
 spec->PROCESSOR_SUBSET.FULLTOP = id; 
     spec->PROCESSOR_SUBSET.SUBTOP  = CopyTree (id); 
   
  }
   return;

  }
;
}

void CheckSameIdent
# if defined __STDC__ | defined __cplusplus
(register tIdent id1, register tIdent id2)
# else
(id1, id2)
 register tIdent id1;
 register tIdent id2;
# endif
{
/* line 1116 "BuildTree.puma" */
  {
/* line 1118 "BuildTree.puma" */
   if (! ((id2 == DefaultId ()))) goto yyL1;
  }
   return;
yyL1:;

/* line 1121 "BuildTree.puma" */
  {
/* line 1123 "BuildTree.puma" */
   if (! ((id1 == id2))) goto yyL2;
  }
   return;
yyL2:;

/* line 1126 "BuildTree.puma" */
  {
/* line 1128 "BuildTree.puma" */
 char name1[100], name2[100], msg[200];

    GetString (id1, name1);
    GetString (id2, name2);

    sprintf (msg, "illegal nesting : ... %s   END %s", name1, name2);

    BuildTreeError (msg);
  
  }
   return;

;
}

void SetMapKind
# if defined __STDC__ | defined __cplusplus
(register int kind, register tStringRef val, register tTree decls)
# else
(kind, val, decls)
 register int kind;
 register tStringRef val;
 register tTree decls;
# endif
{
 yyRecursion:
/* line 1150 "BuildTree.puma" */
  {
/* line 1152 "BuildTree.puma" */
   if (! ((decls == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (decls->Kind == kDECL_LIST) {
/* line 1155 "BuildTree.puma" */
  {
/* line 1157 "BuildTree.puma" */
   SetMapKind (kind, val, decls->DECL_LIST.Elem);
/* line 1158 "BuildTree.puma" */
   decls = decls->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (decls->Kind == kMAP_TO_DECL) {
/* line 1161 "BuildTree.puma" */
  {
/* line 1163 "BuildTree.puma" */
 decls->MAP_TO_DECL.kind = val;
     decls->Kind = kind;
   
  }
   return;

  }
;
}

void SetSharedKind
# if defined __STDC__ | defined __cplusplus
(register int kind, register tTree decls)
# else
(kind, decls)
 register int kind;
 register tTree decls;
# endif
{
 yyRecursion:
/* line 1178 "BuildTree.puma" */
  {
/* line 1180 "BuildTree.puma" */
   if (! ((decls == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (decls->Kind == kDECL_LIST) {
/* line 1183 "BuildTree.puma" */
  {
/* line 1185 "BuildTree.puma" */
   SetSharedKind (kind, decls->DECL_LIST.Elem);
/* line 1186 "BuildTree.puma" */
   decls = decls->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (decls->Kind == kSHARED_DECL) {
/* line 1189 "BuildTree.puma" */
  {
/* line 1191 "BuildTree.puma" */
 decls->SHARED_DECL.kind = kind; 
  }
   return;

  }
;
}

tTree BuildSingleReductions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_REDUCTION) {
  if (t->ACF_REDUCTION.REDUCTION_VAR->Kind == kBTV_LIST) {
  if (t->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next->Kind == kBTV_LIST) {
/* line 1209 "BuildTree.puma" */
 {
  tTree new_body;
  {
/* line 1216 "BuildTree.puma" */
 new_body = mACF_REDUCTION (t->ACF_REDUCTION.red_kind, t->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next, 
                                mPROC_OBJ (DefaultId()), t->ACF_REDUCTION.REDUCTION_BODY);
     SetACFNodeLine (new_body, t->ACF_REDUCTION.Line);
     new_body = BuildSingleReductions (new_body);
     new_body = mACF_LIST (new_body, mACF_EMPTY ());
     t->ACF_REDUCTION.REDUCTION_BODY     = new_body;
     t->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next     = mBTV_EMPTY ();
   
  }
   return t;
 }

  }
  }
  }
/* line 1228 "BuildTree.puma" */
   return t;

}

void SpreadSelection
# if defined __STDC__ | defined __cplusplus
(register tTree selectees, register tTree selections)
# else
(selectees, selections)
 register tTree selectees;
 register tTree selections;
# endif
{
 yyRecursion:
  if (selectees->Kind == kDECL_LIST) {
  if (selectees->DECL_LIST.Elem->Kind == kSELECT_DECL) {
/* line 1243 "BuildTree.puma" */
  {
/* line 1245 "BuildTree.puma" */
   if (! ((selectees->DECL_LIST.Next == NoTree))) goto yyL1;
  {
/* line 1247 "BuildTree.puma" */
 selectees->DECL_LIST.Elem->SELECT_DECL.SELECTIONS = selections; 
  }
  }
   return;
yyL1:;

/* line 1250 "BuildTree.puma" */
  {
/* line 1252 "BuildTree.puma" */
 selectees->DECL_LIST.Elem->SELECT_DECL.SELECTIONS = CopyTree (selections); 
/* line 1254 "BuildTree.puma" */
   selectees = selectees->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  }
/* line 1257 "BuildTree.puma" */
  {
/* line 1259 "BuildTree.puma" */
   BuildTreeError ("SpreadSelection fails");
  }
   return;

;
}

tIdent DecodeExtrinsic
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
/* line 1272 "BuildTree.puma" */
  {
/* line 1274 "BuildTree.puma" */
   if (! ((kind & LANGUAGE_HPF))) goto yyL1;
  {
/* line 1275 "BuildTree.puma" */
   if (! ((kind & MODEL_GLOBAL))) goto yyL1;
  }
  }
   return IsIdent ("HPF_GLOBAL");
yyL1:;

/* line 1280 "BuildTree.puma" */
  {
/* line 1282 "BuildTree.puma" */
   if (! ((kind & LANGUAGE_HPF))) goto yyL2;
  {
/* line 1283 "BuildTree.puma" */
   if (! ((kind & MODEL_TASK))) goto yyL2;
  }
  }
   return IsIdent ("HPF_TASK");
yyL2:;

/* line 1288 "BuildTree.puma" */
  {
/* line 1290 "BuildTree.puma" */
   if (! ((kind & LANGUAGE_HPF))) goto yyL3;
  {
/* line 1291 "BuildTree.puma" */
   if (! ((kind & MODEL_LOCAL))) goto yyL3;
  }
  }
   return IsIdent ("HPF_LOCAL");
yyL3:;

/* line 1296 "BuildTree.puma" */
  {
/* line 1298 "BuildTree.puma" */
   if (! ((kind & LANGUAGE_HPF))) goto yyL4;
  {
/* line 1299 "BuildTree.puma" */
   if (! ((kind & MODEL_SERIAL))) goto yyL4;
  }
  }
   return IsIdent ("HPF_SERIAL");
yyL4:;

/* line 1304 "BuildTree.puma" */
  {
/* line 1306 "BuildTree.puma" */
   if (! ((kind & LANGUAGE_HPF))) goto yyL5;
  }
   return IsIdent ("HPF_GLOBAL");
yyL5:;

/* line 1311 "BuildTree.puma" */
  {
/* line 1313 "BuildTree.puma" */
   if (! ((kind & LANGUAGE_F77))) goto yyL6;
  {
/* line 1314 "BuildTree.puma" */
   if (! ((kind & MODEL_LOCAL))) goto yyL6;
  }
  }
   return IsIdent ("F77_LOCAL");
yyL6:;

/* line 1319 "BuildTree.puma" */
  {
/* line 1321 "BuildTree.puma" */
   if (! ((kind & LANGUAGE_F77))) goto yyL7;
  {
/* line 1322 "BuildTree.puma" */
   if (! ((kind & MODEL_SERIAL))) goto yyL7;
  }
  }
   return IsIdent ("F77_SERIAL");
yyL7:;

/* line 1327 "BuildTree.puma" */
  {
/* line 1329 "BuildTree.puma" */
   if (! ((kind & LANGUAGE_F77))) goto yyL8;
  }
   return IsIdent ("F77_SERIAL");
yyL8:;

/* line 1334 "BuildTree.puma" */
   return IsIdent ("UNKNOWN");

}

int CodeExtrinsic
# if defined __STDC__ | defined __cplusplus
(register tStringRef t)
# else
(t)
 register tStringRef t;
# endif
{
/* line 1349 "BuildTree.puma" */

char name[60], msg[100];
int i, len;
int kind;

/* line 1355 "BuildTree.puma" */
  {
/* line 1357 "BuildTree.puma" */
 StGetString (t, name);
     len = strlen (name);

     

     for (i=0; i<len; i++) name[i] = toupper(name[i]);

     kind = 0;

     if (strcmp (name, "HPF") == 0) kind = LANGUAGE_HPF;
     if (strcmp (name, "F77") == 0) kind = LANGUAGE_F77;

     if (strcmp (name, "LOCAL") == 0)  kind = MODEL_LOCAL;
     if (strcmp (name, "SERIAL") == 0) kind = MODEL_SERIAL;
     if (strcmp (name, "GLOBAL") == 0) kind = MODEL_GLOBAL;
     if (strcmp (name, "TASK") == 0)   kind = MODEL_TASK;

     if (kind == 0)
 
        { sprintf (msg, "%s is unknown EXTRINISC specification", name);
          BuildTreeError (msg);
        }

   
  }
   return kind;

}

int CodeExtrinsic1
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tStringRef t)
# else
(id, t)
 register tIdent id;
 register tStringRef t;
# endif
{
/* line 1396 "BuildTree.puma" */
   return CodeExtrinsic (t);

}

int MixExtrinsic
# if defined __STDC__ | defined __cplusplus
(register int kind1, register int kind2)
# else
(kind1, kind2)
 register int kind1;
 register int kind2;
# endif
{
/* line 1411 "BuildTree.puma" */
   return (kind1 | kind2);

}

void BeginBuildTree ARGS ((void))
{
}

void CloseBuildTree ARGS ((void))
{
}
