# include "Barriers.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 29 "Barriers.puma" */


# define MODULE "Barriers"

# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "Types.h"
# include "TreeOps.h"
# include "Objects.h"
# include "Transform.h"       /* CompleteBTVs */
# include "Distributions.h"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyBarriers.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Barriers_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Barriers, routine %s failed\n",
  yyFunction);
 Barriers_Exit ();
}

tTree GetBarriers ARGS ((tTree stmt));
tTree GetUpdates ARGS ((tTree stmt));
static tTree GetSharedAccesses ARGS ((tTree stmt, tTree varlist));
static tTree GetSharedWriteVars ARGS ((tTree var, tTree varlist));
static tTree SpecWriteAccesses ARGS ((tTree p, tTree varlist));
static tTree MergeVars ARGS ((tTree var, tTree varlist));
static tTree GetTracedUpdates ARGS ((tTree stmt, tTree varlist));
static tTree GetTracedVars ARGS ((tTree var, tTree varlist));
static tTree GetRemoteAccesses ARGS ((tTree exp, tTree varlist));

tTree GetBarriers
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
/* line 63 "Barriers.puma" */
 {
  tTree shared_vars;
  {
/* line 67 "Barriers.puma" */
 shared_vars = NoTree;
     shared_vars = GetSharedAccesses (stmt, shared_vars);
     if (shared_vars != NoTree)
        shared_vars = mACF_BARRIER (CompleteBTVs(shared_vars));
   
  }
   return shared_vars;
 }

}

tTree GetUpdates
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
/* line 78 "Barriers.puma" */
 {
  tTree trace_vars;
  {
/* line 82 "Barriers.puma" */
 trace_vars = NoTree;
     trace_vars = GetTracedUpdates (stmt, trace_vars);
     if (trace_vars != NoTree)
        trace_vars = mACF_BASIC (mDIRTY_STMT (CompleteBTVs(trace_vars)));
   
  }
   return trace_vars;
 }

}

static tTree GetSharedAccesses
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree varlist)
# else
(stmt, varlist)
 register tTree stmt;
 register tTree varlist;
# endif
{
 yyRecursion:

  switch (stmt->Kind) {
  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 108 "Barriers.puma" */
 {
  tTree new_varlist;
  {
/* line 112 "Barriers.puma" */
   new_varlist = varlist;
/* line 113 "Barriers.puma" */
   new_varlist = GetSharedWriteVars (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, new_varlist);
/* line 114 "Barriers.puma" */
   new_varlist = GetRemoteAccesses (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, new_varlist);
/* line 115 "Barriers.puma" */
   new_varlist = GetRemoteAccesses (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, new_varlist);
  }
   return new_varlist;
 }

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
/* line 126 "Barriers.puma" */
  {
/* line 128 "Barriers.puma" */
   if (! ((stmt->ACF_BASIC.BASIC_STMT->IO_STMT.ID->PROC_OBJ.Ident == MakeIdent ("READ", 4)))) goto yyL2;
  }
   return GetSharedWriteVars (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS, varlist);
yyL2:;

/* line 139 "Barriers.puma" */
   return varlist;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 150 "Barriers.puma" */
   return GetSharedWriteVars (stmt->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, varlist);

  }
/* line 155 "Barriers.puma" */
   return varlist;

  case kACF_ON:
/* line 159 "Barriers.puma" */
   stmt = stmt->ACF_ON.ON_BODY;
   goto yyRecursion;

  case kACF_TASK_REGION:
/* line 164 "Barriers.puma" */
   stmt = stmt->ACF_TASK_REGION.TASK_BODY;
   goto yyRecursion;

  case kACF_PARALLEL:
/* line 169 "Barriers.puma" */
   stmt = stmt->ACF_PARALLEL.PARALLEL_BODY;
   goto yyRecursion;

  case kACF_LIST:
/* line 174 "Barriers.puma" */
   return GetSharedAccesses (stmt->ACF_LIST.Elem, GetSharedAccesses (stmt->ACF_LIST.Next, varlist));

  case kACF_EMPTY:
/* line 180 "Barriers.puma" */
   return varlist;

  case kACF_DUMMY:
/* line 184 "Barriers.puma" */
   return varlist;

  case kACF_IF:
/* line 188 "Barriers.puma" */
   return GetSharedAccesses (stmt->ACF_IF.THEN_PART, GetSharedAccesses (stmt->ACF_IF.ELSE_PART, varlist));

  case kACF_WHILE:
/* line 194 "Barriers.puma" */
   stmt = stmt->ACF_WHILE.WHILE_BODY;
   goto yyRecursion;

  case kACF_HOME:
/* line 199 "Barriers.puma" */
   stmt = stmt->ACF_HOME.HOME_BODY;
   goto yyRecursion;

  case kACF_DO:
/* line 204 "Barriers.puma" */
   stmt = stmt->ACF_DO.DO_BODY;
   goto yyRecursion;

  }

/* line 209 "Barriers.puma" */
  {
/* line 211 "Barriers.puma" */
   failure_protocol (MODULE, "GetSharedAccesses", stmt);
  }
   return varlist;

}

static tTree GetSharedWriteVars
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree varlist)
# else
(var, varlist)
 register tTree var;
 register tTree varlist;
# endif
{
 yyRecursion:

  switch (var->Kind) {
  case kUSED_VAR:
/* line 223 "Barriers.puma" */
  {
/* line 233 "Barriers.puma" */
   if (! ((GetVarSharedKind (var->USED_VAR.VARNAME->VAR_OBJ.Object) == kGLOBAL_SHARED))) goto yyL1;
  }
   return MergeVars (var, varlist);
yyL1:;

  break;
  case kINDEXED_VAR:
/* line 238 "Barriers.puma" */
   var = var->INDEXED_VAR.IND_VAR;
   goto yyRecursion;

  case kBTP_LIST:
/* line 243 "Barriers.puma" */
   return GetSharedWriteVars (var->BTP_LIST.Elem, GetSharedWriteVars (var->BTP_LIST.Next, varlist));

  case kBTP_EMPTY:
/* line 248 "Barriers.puma" */
   return varlist;

  case kVAR_PARAM:
  if (var->VAR_PARAM.V->Kind == kADDR) {
/* line 253 "Barriers.puma" */
   return varlist;

  }
/* line 258 "Barriers.puma" */
   var = var->VAR_PARAM.V;
   goto yyRecursion;

  case kDO_VAR:
/* line 263 "Barriers.puma" */
   var = var->DO_VAR.BODY;
   goto yyRecursion;

  case kBTV_LIST:
/* line 268 "Barriers.puma" */
   return GetSharedWriteVars (var->BTV_LIST.Elem, GetSharedWriteVars (var->BTV_LIST.Next, varlist));

  case kBTV_EMPTY:
/* line 273 "Barriers.puma" */
   return varlist;

  }

/* line 278 "Barriers.puma" */
   return varlist;

}

static tTree SpecWriteAccesses
# if defined __STDC__ | defined __cplusplus
(register tTree p, register tTree varlist)
# else
(p, varlist)
 register tTree p;
 register tTree varlist;
# endif
{
  if (p->Kind == kBTP_LIST) {
/* line 290 "Barriers.puma" */
   return SpecWriteAccesses (p->BTP_LIST.Elem, SpecWriteAccesses (p->BTP_LIST.Next, varlist));

  }
  if (p->Kind == kBTP_EMPTY) {
/* line 296 "Barriers.puma" */
   return varlist;

  }
  if (p->Kind == kNAMED_PARAM) {
/* line 300 "Barriers.puma" */
  {
/* line 302 "Barriers.puma" */
   if (! (((p->NAMED_PARAM.Name == MakeIdent ("EXISTS", 6)) || (p->NAMED_PARAM.Name == MakeIdent ("IOSTAT", 6))))) goto yyL3;
  }
   return GetSharedWriteVars (p->NAMED_PARAM.VAL, varlist);
yyL3:;

/* line 308 "Barriers.puma" */
   return varlist;

  }
  if (p->Kind == kVAR_PARAM) {
  if (p->VAR_PARAM.V->Kind == kUSED_VAR) {
  if (p->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kNameListObject) {
  if (p->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object->NameListObject.decl->Kind == kNAMELIST_DECL) {
/* line 312 "Barriers.puma" */
   return varlist;

  }
  }
  }
/* line 319 "Barriers.puma" */
   return varlist;

  }
/* line 323 "Barriers.puma" */
  {
/* line 324 "Barriers.puma" */
   failure_protocol (MODULE, "SpecWriteAccesses", p);
  }
   return varlist;

}

static tTree MergeVars
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree varlist)
# else
(var, varlist)
 register tTree var;
 register tTree varlist;
# endif
{
/* line 338 "Barriers.puma" */
  {
/* line 340 "Barriers.puma" */
   if (! ((varlist == NoTree))) goto yyL1;
  }
   return mBTV_LIST (var, varlist);
yyL1:;

  if (varlist->Kind == kBTV_LIST) {
/* line 345 "Barriers.puma" */
  {
/* line 347 "Barriers.puma" */
   if (! ((TreeVarName (varlist->BTV_LIST.Elem) == TreeVarName (var)))) goto yyL2;
  }
   return varlist;
yyL2:;

/* line 352 "Barriers.puma" */
  {
/* line 354 "Barriers.puma" */
 varlist->BTV_LIST.Next = MergeVars (var, varlist->BTV_LIST.Next); 
  }
   return varlist;

  }
 yyAbort ("MergeVars");
 { tTree yyDummy; return yyDummy; }
}

static tTree GetTracedUpdates
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree varlist)
# else
(stmt, varlist)
 register tTree stmt;
 register tTree varlist;
# endif
{
 yyRecursion:

  switch (stmt->Kind) {
  case kACF_BASIC:
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 376 "Barriers.puma" */
   return GetTracedVars (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, varlist);

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
/* line 387 "Barriers.puma" */
  {
/* line 389 "Barriers.puma" */
   if (! ((stmt->ACF_BASIC.BASIC_STMT->IO_STMT.ID->PROC_OBJ.Ident == MakeIdent ("READ", 4)))) goto yyL2;
  }
   return GetTracedVars (stmt->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS, varlist);
yyL2:;

/* line 400 "Barriers.puma" */
   return varlist;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 411 "Barriers.puma" */
   return GetTracedVars (stmt->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, varlist);

  }
/* line 416 "Barriers.puma" */
   return varlist;

  case kACF_ON:
/* line 420 "Barriers.puma" */
   stmt = stmt->ACF_ON.ON_BODY;
   goto yyRecursion;

  case kACF_TASK_REGION:
/* line 425 "Barriers.puma" */
   stmt = stmt->ACF_TASK_REGION.TASK_BODY;
   goto yyRecursion;

  case kACF_PARALLEL:
/* line 430 "Barriers.puma" */
   stmt = stmt->ACF_PARALLEL.PARALLEL_BODY;
   goto yyRecursion;

  case kACF_LIST:
/* line 435 "Barriers.puma" */
   return GetTracedUpdates (stmt->ACF_LIST.Elem, GetTracedUpdates (stmt->ACF_LIST.Next, varlist));

  case kACF_EMPTY:
/* line 440 "Barriers.puma" */
   return varlist;

  case kACF_DUMMY:
/* line 444 "Barriers.puma" */
   return varlist;

  case kACF_IF:
/* line 448 "Barriers.puma" */
   return GetTracedUpdates (stmt->ACF_IF.THEN_PART, GetTracedUpdates (stmt->ACF_IF.ELSE_PART, varlist));

  case kACF_WHILE:
/* line 454 "Barriers.puma" */
   stmt = stmt->ACF_WHILE.WHILE_BODY;
   goto yyRecursion;

  case kACF_HOME:
/* line 459 "Barriers.puma" */
   stmt = stmt->ACF_HOME.HOME_BODY;
   goto yyRecursion;

  case kACF_DO:
/* line 464 "Barriers.puma" */
   stmt = stmt->ACF_DO.DO_BODY;
   goto yyRecursion;

  }

/* line 469 "Barriers.puma" */
  {
/* line 470 "Barriers.puma" */
   failure_protocol (MODULE, "GetTracedUpdates", stmt);
  }
   return varlist;

}

static tTree GetTracedVars
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree varlist)
# else
(var, varlist)
 register tTree var;
 register tTree varlist;
# endif
{
 yyRecursion:

  switch (var->Kind) {
  case kUSED_VAR:
  if (var->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kVarObject) {
/* line 482 "Barriers.puma" */
  {
/* line 484 "Barriers.puma" */
   if (! ((var->USED_VAR.VARNAME->VAR_OBJ.Object->VarObject.trace))) goto yyL1;
  }
   return MergeVars (var, varlist);
yyL1:;

  }
  break;
  case kINDEXED_VAR:
/* line 489 "Barriers.puma" */
   var = var->INDEXED_VAR.IND_VAR;
   goto yyRecursion;

  case kBTP_LIST:
/* line 494 "Barriers.puma" */
   return GetTracedVars (var->BTP_LIST.Elem, GetTracedVars (var->BTP_LIST.Next, varlist));

  case kBTP_EMPTY:
/* line 499 "Barriers.puma" */
   return varlist;

  case kVAR_PARAM:
  if (var->VAR_PARAM.V->Kind == kADDR) {
/* line 504 "Barriers.puma" */
   return varlist;

  }
/* line 509 "Barriers.puma" */
  {
/* line 511 "Barriers.puma" */
   if (! ((var->VAR_PARAM.intent == IntentIn))) goto yyL6;
  }
   return varlist;
yyL6:;

/* line 516 "Barriers.puma" */
  {
/* line 518 "Barriers.puma" */
   if (! ((var->VAR_PARAM.trace))) goto yyL7;
  }
   return varlist;
yyL7:;

/* line 523 "Barriers.puma" */
   var = var->VAR_PARAM.V;
   goto yyRecursion;

  case kDO_VAR:
/* line 528 "Barriers.puma" */
   var = var->DO_VAR.BODY;
   goto yyRecursion;

  case kBTV_LIST:
/* line 533 "Barriers.puma" */
   return GetTracedVars (var->BTV_LIST.Elem, GetTracedVars (var->BTV_LIST.Next, varlist));

  case kBTV_EMPTY:
/* line 538 "Barriers.puma" */
   return varlist;

  }

/* line 542 "Barriers.puma" */
   return varlist;

}

static tTree GetRemoteAccesses
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree varlist)
# else
(exp, varlist)
 register tTree exp;
 register tTree varlist;
# endif
{
 yyRecursion:
  if (exp->Kind == kVAR_EXP) {
/* line 555 "Barriers.puma" */
   exp = exp->VAR_EXP.V;
   goto yyRecursion;

  }
  if (exp->Kind == kREMOTE_VAR) {
/* line 560 "Barriers.puma" */
   return MergeVars (GetUsedVar (exp->REMOTE_VAR.VAR), varlist);

  }
/* line 565 "Barriers.puma" */
   return varlist;

}

void BeginBarriers ARGS ((void))
{
}

void CloseBarriers ARGS ((void))
{
}
