# include "AutoNew.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

# line 17 "AutoNew.puma"


# include "protocol.h"

# include "Candidates.h"    /* collect new varialbes  */
# include "Traverse.h"      /* ReplaceAST             */
# include "PTreeOps.h"      /* IsVarUsed              */
# include "Rank.h"          /* TreeRank               */

# undef DEBUG
# define MODULE "AutoNew"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyAutoNew.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* AutoNew_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module AutoNew, routine %s failed\n",
  yyFunction);
 AutoNew_Exit ();
}

void AutoNew ARGS ((tTree body));
static rbool StopAutoNew ARGS ((tTree t));
static void ApplyAutoNew ARGS ((tTree loop));
static tTree CollectNewVars ARGS ((int n));
static void FindNewCandidates ARGS ((tTree stmts, tTree all_stmts, int n));
static rbool NoUseBefore ARGS ((tTree var, tTree stmtlist, int n));

void AutoNew
# if defined __STDC__ | defined __cplusplus
(register tTree body)
# else
(body)
 register tTree body;
# endif
{
  if (body->Kind == kBODY_NODE) {
# line 41 "AutoNew.puma"
  {
# line 43 "AutoNew.puma"
   TraverseAST (body->BODY_NODE.STATS, StopAutoNew, ApplyAutoNew);
  }
   return;

  }
# line 46 "AutoNew.puma"
  {
# line 48 "AutoNew.puma"
   failure_protocol (MODULE, "AutoNew", body);
  }
   return;

;
}

static rbool StopAutoNew
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (Tree_IsType (t, kBT_STMT)) {
# line 61 "AutoNew.puma"
   return rtrue;

  }
  if (Tree_IsType (t, kBT_EXP)) {
# line 64 "AutoNew.puma"
   return rtrue;

  }
  return rfalse;
}

static void ApplyAutoNew
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
# line 75 "AutoNew.puma"
 {
  tTree new_vars;
  int no_vars;
  {
# line 80 "AutoNew.puma"
   InitCandidates ();
# line 82 "AutoNew.puma"
   FindNewCandidates (loop->ACF_DO.DO_BODY, loop->ACF_DO.DO_BODY, 1);
# line 84 "AutoNew.puma"
   no_vars = NoCandidates ();
# line 86 "AutoNew.puma"
   if ((no_vars > 0)) {
# line 88 "AutoNew.puma"
   set_protocol_stmt (loop);
# line 90 "AutoNew.puma"
   new_vars = CollectNewVars (no_vars);
# line 91 "AutoNew.puma"
   loop->ACF_DO.DO_BODY = mACF_LIST (mACF_NEW (new_vars, loop->ACF_DO.DO_BODY), mACF_EMPTY ());
# line 93 "AutoNew.puma"
   stmt_protocol ("new variables set in DO loop");
   }
  }
   return;
 }

  }
;
}

static tTree CollectNewVars
# if defined __STDC__ | defined __cplusplus
(register int n)
# else
(n)
 register int n;
# endif
{
# line 106 "AutoNew.puma"
 {
  tTree new_vars;
  int i;
  {
# line 111 "AutoNew.puma"
   new_vars = mBTV_EMPTY ();
# line 113 "AutoNew.puma"
# line 113 "AutoNew.puma"
   i = 1;
   while (i <= n) {
# line 115 "AutoNew.puma"
 char msg[100];
        char var_string[MAX_ID_LENGTH];
      
# line 119 "AutoNew.puma"
   new_vars = mBTV_LIST (CopyTree (GetCandidate (i)), new_vars);
# line 121 "AutoNew.puma"
   StrUnparse (var_string, MAX_ID_LENGTH, GetCandidate (i));
# line 122 "AutoNew.puma"
   sprintf (msg, "%s becomes NEW var in DO loop (no last val assumed)", var_string);
# line 124 "AutoNew.puma"
   serious_warning_protocol (msg);
# line 113 "AutoNew.puma"
   i ++;
   }
  }
   return new_vars;
 }

}

static void FindNewCandidates
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, register tTree all_stmts, register int n)
# else
(stmts, all_stmts, n)
 register tTree stmts;
 register tTree all_stmts;
 register int n;
# endif
{
 yyRecursion:
  if (stmts->Kind == kACF_LIST) {
# line 138 "AutoNew.puma"
  {
# line 140 "AutoNew.puma"
   if (stmts->ACF_LIST.Elem->Kind != kACF_BASIC) goto yyL1;
   if (stmts->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind != kASSIGN_STMT) goto yyL1;
# line 141 "AutoNew.puma"
   if (stmts->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR->Kind != kUSED_VAR) goto yyL1;
# line 143 "AutoNew.puma"
   if (! ((TreeRank (stmts->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR) == 0))) goto yyL1;
  {
# line 145 "AutoNew.puma"
   if (! ((! IsCandidate (stmts->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR)))) goto yyL1;
  {
# line 147 "AutoNew.puma"
   if (! ((! IsVarUsed (stmts->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmts->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL1;
  {
# line 148 "AutoNew.puma"
   if (! ((NoUseBefore (stmts->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, all_stmts, n - 1)))) goto yyL1;
  {
# line 152 "AutoNew.puma"
   AddCandidate (stmts->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, NoTree, rfalse);
# line 154 "AutoNew.puma"
   goto yyL1;
  }
  }
  }
  }
  }
yyL1:;

# line 157 "AutoNew.puma"
  {
# line 159 "AutoNew.puma"
   stmts = stmts->ACF_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }

  }
;
}

static rbool NoUseBefore
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stmtlist, register int n)
# else
(var, stmtlist, n)
 register tTree var;
 register tTree stmtlist;
 register int n;
# endif
{
# line 173 "AutoNew.puma"
  {
# line 175 "AutoNew.puma"
   if (! ((n == 0))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (stmtlist->Kind == kACF_LIST) {
# line 178 "AutoNew.puma"
  {
# line 180 "AutoNew.puma"
   if (! ((! IsVarUsed (var, stmtlist->ACF_LIST.Elem)))) goto yyL2;
  {
# line 181 "AutoNew.puma"
   if (! ((NoUseBefore (var, stmtlist->ACF_LIST.Next, n - 1)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

void BeginAutoNew ARGS ((void))
{
}

void CloseAutoNew ARGS ((void))
{
}
