# include "ArrayDescriptor.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 22 "ArrayDescriptor.puma" */


# define MODULE "ArrayDescriptor"

# undef DEBUG

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"
# include "Objects.h"
# include "Nesting.h"
# include "Distributions.h"
# include "Rank.h"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyArrayDescriptor.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* ArrayDescriptor_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ArrayDescriptor, routine %s failed\n",
  yyFunction);
 ArrayDescriptor_Exit ();
}

void CheckDspKind ARGS ((tDefinitions obj));
int GetDspKind ARGS ((tDefinitions obj));
static int CalculateDspKind ARGS ((tDefinitions obj));
rbool IsStaticObj ARGS ((tDefinitions obj));
static rbool NeedsDescriptor ARGS ((tDefinitions obj));
int GetDspDynKind ARGS ((tDefinitions obj));

void CheckDspKind
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 51 "ArrayDescriptor.puma" */

char string[50], msg[100];

  if (obj->Kind == kVarObject) {
/* line 55 "ArrayDescriptor.puma" */
  {
/* line 57 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.dsp_kind == kNO_DSP))) goto yyL1;
  {
/* line 59 "ArrayDescriptor.puma" */
   if (! ((NeedsDescriptor (obj)))) goto yyL1;
  {
/* line 61 "ArrayDescriptor.puma" */
   GetString (obj->VarObject.Ident, string);
/* line 62 "ArrayDescriptor.puma" */
   set_protocol_stmt (obj->VarObject.decl);
/* line 63 "ArrayDescriptor.puma" */
   sprintf (msg, "%s must have a descriptor (kind=%d)", string, CalculateDspKind (obj));
/* line 65 "ArrayDescriptor.puma" */
   error_protocol (msg);
/* line 66 "ArrayDescriptor.puma" */
   obj_protocol ("illegal object is : ", obj);
/* line 68 "ArrayDescriptor.puma" */
   obj->VarObject.dsp_kind = CalculateDspKind (obj);
  }
  }
  }
   return;
yyL1:;

/* line 72 "ArrayDescriptor.puma" */
  {
/* line 74 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.dsp_kind == kDEFAULT_DSP))) goto yyL2;
  {
/* line 76 "ArrayDescriptor.puma" */
 obj->VarObject.dsp_kind = CalculateDspKind (obj); 
  }
  }
   return;
yyL2:;

  }
;
}

int GetDspKind
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 89 "ArrayDescriptor.puma" */
  {
/* line 93 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.dsp_kind == kNO_DSP))) goto yyL1;
  }
   return obj->VarObject.dsp_kind;
yyL1:;

/* line 98 "ArrayDescriptor.puma" */
  {
/* line 100 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.dsp_kind == kDEFAULT_DSP))) goto yyL2;
  {
/* line 102 "ArrayDescriptor.puma" */
 obj->VarObject.dsp_kind = CalculateDspKind (obj); 
  }
  }
   return obj->VarObject.dsp_kind;
yyL2:;

/* line 107 "ArrayDescriptor.puma" */
   return obj->VarObject.dsp_kind;

  }
/* line 112 "ArrayDescriptor.puma" */
   return CalculateDspKind (obj);

}

static int CalculateDspKind
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 125 "ArrayDescriptor.puma" */
  {
/* line 127 "ArrayDescriptor.puma" */
   if (! ((VarRank (obj) == 0))) goto yyL1;
  }
   return kNO_DSP;
yyL1:;

  if (obj->Kind == kRaggedObject) {
/* line 132 "ArrayDescriptor.puma" */
   return kALLOCATE_DSP;

  }
  if (obj->Kind == kVarObject) {
/* line 137 "ArrayDescriptor.puma" */
  {
/* line 139 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.tree))) goto yyL3;
  }
   return kALLOCATE_DSP;
yyL3:;

  if (obj->VarObject.Kind->Kind == kVarLocal) {
/* line 150 "ArrayDescriptor.puma" */
  {
/* line 152 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.arr_kind == arr_fixed_size))) goto yyL4;
  {
/* line 154 "ArrayDescriptor.puma" */
   if (! ((IsStaticObj (obj)))) goto yyL4;
  }
  }
   return kFIXED_DSP;
yyL4:;

/* line 165 "ArrayDescriptor.puma" */
   return kALLOCATE_DSP;

  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 178 "ArrayDescriptor.puma" */
  {
/* line 180 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.arr_kind == arr_explicit_shape))) goto yyL6;
  {
/* line 182 "ArrayDescriptor.puma" */
   if (! ((GetCurrentModel () == HPF_SERIAL))) goto yyL6;
  }
  }
   return kFIXED_DSP;
yyL6:;

/* line 195 "ArrayDescriptor.puma" */
  {
/* line 197 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.arr_kind == arr_explicit_shape))) goto yyL7;
  }
   return kDUMMY_DSP;
yyL7:;

/* line 208 "ArrayDescriptor.puma" */
  {
/* line 210 "ArrayDescriptor.puma" */
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL8;
  {
/* line 211 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.arr_kind == arr_assumed_shape))) goto yyL8;
  }
  }
   return kLOCAL_DSP;
yyL8:;

/* line 216 "ArrayDescriptor.puma" */
  {
/* line 218 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.arr_kind == arr_assumed_shape))) goto yyL9;
  }
   return kASSUMED_DSP;
yyL9:;

/* line 223 "ArrayDescriptor.puma" */
  {
/* line 225 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.arr_kind == arr_pointer))) goto yyL10;
  }
   return kASSUMED_DSP;
yyL10:;

/* line 230 "ArrayDescriptor.puma" */
  {
/* line 232 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.arr_kind == arr_assumed_size))) goto yyL11;
  }
   return kNO_DSP;
yyL11:;

  }
  if (obj->VarObject.Kind->Kind == kVarCommon) {
/* line 248 "ArrayDescriptor.puma" */
  {
/* line 250 "ArrayDescriptor.puma" */
   if (! ((IsMainUnit (GetCurrentUnit ())))) goto yyL12;
  {
/* line 252 "ArrayDescriptor.puma" */
   if (! ((IsStaticObj (obj)))) goto yyL12;
  }
  }
   return kFIXED_DSP;
yyL12:;

/* line 257 "ArrayDescriptor.puma" */
  {
/* line 259 "ArrayDescriptor.puma" */
   if (! ((IsMainUnit (GetCurrentUnit ())))) goto yyL13;
  }
   return kALLOCATE_DSP;
yyL13:;

/* line 271 "ArrayDescriptor.puma" */
   return kATTACH_DSP;

  }
  }
  if (obj->Kind == kTemplateObject) {
/* line 276 "ArrayDescriptor.puma" */
   return kTEMPLATE_DSP;

  }
  if (obj->Kind == kTopologyObject) {
/* line 281 "ArrayDescriptor.puma" */
   return kTOPOLOGY_DSP;

  }
/* line 286 "ArrayDescriptor.puma" */
   return kNO_DSP;

}

rbool IsStaticObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 308 "ArrayDescriptor.puma" */
  {
/* line 310 "ArrayDescriptor.puma" */
   if (! ((IsHPFDynamic (obj)))) goto yyL1;
  {
/* line 311 "ArrayDescriptor.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 314 "ArrayDescriptor.puma" */
  {
/* line 316 "ArrayDescriptor.puma" */
   if (! ((VarDistribution (obj) != 0))) goto yyL2;
  {
/* line 317 "ArrayDescriptor.puma" */
   if (! ((! static_flag))) goto yyL2;
  {
/* line 319 "ArrayDescriptor.puma" */
   return rfalse;
  }
  }
  }
yyL2:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
/* line 324 "ArrayDescriptor.puma" */
  {
/* line 326 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.arr_kind != arr_fixed_size))) goto yyL3;
  {
/* line 327 "ArrayDescriptor.puma" */
   return rfalse;
  }
  }
yyL3:;

  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 330 "ArrayDescriptor.puma" */
  {
/* line 332 "ArrayDescriptor.puma" */
   return rfalse;
  }

  }
  }
/* line 335 "ArrayDescriptor.puma" */
  {
/* line 337 "ArrayDescriptor.puma" */
   if (! ((IsVarExplicitShape (obj)))) goto yyL5;
  }
   return rtrue;
yyL5:;

  return rfalse;
}

static rbool NeedsDescriptor
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 348 "ArrayDescriptor.puma" */
  {
/* line 350 "ArrayDescriptor.puma" */
   if (! ((GetCurrentModel () != HPF_SERIAL))) goto yyL1;
  {
/* line 351 "ArrayDescriptor.puma" */
   if (! ((VarDistribution (obj) != 0))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 354 "ArrayDescriptor.puma" */
  {
/* line 356 "ArrayDescriptor.puma" */
   if (! ((GetCurrentModel () != HPF_SERIAL))) goto yyL2;
  {
/* line 357 "ArrayDescriptor.puma" */
   if (! ((IsHPFDynamic (obj)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  if (obj->VarObject.Kind->Kind == kVarLocal) {
/* line 360 "ArrayDescriptor.puma" */
  {
/* line 362 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.arr_kind != arr_fixed_size))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 365 "ArrayDescriptor.puma" */
  {
/* line 367 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.arr_kind == arr_pointer))) goto yyL4;
  }
   return rtrue;
yyL4:;

/* line 370 "ArrayDescriptor.puma" */
  {
/* line 372 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.arr_kind == arr_assumed_shape))) goto yyL5;
  }
   return rtrue;
yyL5:;

  }
/* line 375 "ArrayDescriptor.puma" */
  {
/* line 377 "ArrayDescriptor.puma" */
   if (! ((obj->VarObject.trace))) goto yyL6;
  }
   return rtrue;
yyL6:;

  }
  return rfalse;
}

int GetDspDynKind
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kTopologyObject) {
/* line 389 "ArrayDescriptor.puma" */
   return kIS_DYNAMIC;

  }
/* line 394 "ArrayDescriptor.puma" */
  {
/* line 396 "ArrayDescriptor.puma" */
   if (! ((IsStaticObj (obj)))) goto yyL2;
  }
   return kIS_STATIC;
yyL2:;

/* line 401 "ArrayDescriptor.puma" */
   return kIS_DYNAMIC;

}

void BeginArrayDescriptor ARGS ((void))
{
}

void CloseArrayDescriptor ARGS ((void))
{
}
