# include "ArrayData.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 24 "ArrayData.puma" */


# define MODULE "ArrayData"

# include "protocol.h"

# include "Objects.h"            /* GetVarShadow */
# include "Expressions.h"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyArrayData.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* ArrayData_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ArrayData, routine %s failed\n",
  yyFunction);
 ArrayData_Exit ();
}

void SetActualData ARGS ((tTree stmt));
void SetActualOverlap ARGS ((tTree stmt));
static void ResetValidOverlap ARGS ((tTree shadows));
static void SetValidOverlap ARGS ((tTree shadows, tTree size));

void SetActualData
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
 yyRecursion:
  if (stmt->Kind == kACF_BASIC) {
/* line 43 "ArrayData.puma" */
  {
/* line 45 "ArrayData.puma" */
   stmt = stmt->ACF_BASIC.BASIC_STMT;
   goto yyRecursion;
  }

  }
  if (stmt->Kind == kREG_SHADOW_GET) {
/* line 48 "ArrayData.puma" */
  {
/* line 50 "ArrayData.puma" */
   SetActualOverlap (stmt);
  }
   return;

  }
;
}

void SetActualOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kREG_SHADOW_GET) {
  if (stmt->REG_SHADOW_GET.SHADOW_VAR->Kind == kUSED_VAR) {
  if (stmt->REG_SHADOW_GET.SHADOW_SIZE->Kind == kBTE_EMPTY) {
/* line 64 "ArrayData.puma" */
  {
/* line 66 "ArrayData.puma" */
   ResetValidOverlap (GetVarShadow (stmt->REG_SHADOW_GET.SHADOW_VAR->USED_VAR.VARNAME->VAR_OBJ.Object));
  }
   return;

  }
  }
  if (stmt->REG_SHADOW_GET.SHADOW_VAR->Kind == kINDEXED_VAR) {
  if (stmt->REG_SHADOW_GET.SHADOW_VAR->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 69 "ArrayData.puma" */
  {
/* line 71 "ArrayData.puma" */
   SetValidOverlap (GetVarShadow (stmt->REG_SHADOW_GET.SHADOW_VAR->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object), stmt->REG_SHADOW_GET.SHADOW_SIZE);
  }
   return;

  }
  }
  }
/* line 74 "ArrayData.puma" */
  {
/* line 75 "ArrayData.puma" */
   failure_protocol (MODULE, "SetActualOverlap", stmt);
  }
   return;

;
}

static void ResetValidOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree shadows)
# else
(shadows)
 register tTree shadows;
# endif
{
 yyRecursion:
/* line 80 "ArrayData.puma" */
  {
/* line 82 "ArrayData.puma" */
   if (! ((shadows == NoTree))) goto yyL1;
  {
/* line 83 "ArrayData.puma" */
   failure_protocol (MODULE, "ResetValidOverlap", shadows);
  }
  }
   return;
yyL1:;

  if (shadows->Kind == kSHADOW_EMPTY) {
/* line 86 "ArrayData.puma" */
   return;

  }
  if (shadows->Kind == kSHADOW_LIST) {
/* line 89 "ArrayData.puma" */
  {
/* line 91 "ArrayData.puma" */
   ResetValidOverlap (shadows->SHADOW_LIST.Elem);
/* line 92 "ArrayData.puma" */
   shadows = shadows->SHADOW_LIST.Next;
   goto yyRecursion;
  }

  }
  if (shadows->Kind == kSHADOW_SPEC) {
/* line 95 "ArrayData.puma" */
  {
/* line 97 "ArrayData.puma" */
 shadows->SHADOW_SPEC.left_update = 0; shadows->SHADOW_SPEC.right_update = 0; 
  }
   return;

  }
/* line 100 "ArrayData.puma" */
  {
/* line 101 "ArrayData.puma" */
   failure_protocol (MODULE, "ResetValidOverlap", shadows);
  }
   return;

;
}

static void SetValidOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree shadows, register tTree size)
# else
(shadows, size)
 register tTree shadows;
 register tTree size;
# endif
{
 yyRecursion:
/* line 106 "ArrayData.puma" */
  {
/* line 108 "ArrayData.puma" */
   if (! ((shadows == NoTree))) goto yyL1;
  {
/* line 109 "ArrayData.puma" */
   failure_protocol (MODULE, "SetValidOverlap", shadows);
  }
  }
   return;
yyL1:;

  if (shadows->Kind == kSHADOW_EMPTY) {
  if (size->Kind == kBTE_EMPTY) {
/* line 112 "ArrayData.puma" */
   return;

  }
  }
  if (shadows->Kind == kSHADOW_LIST) {
  if (size->Kind == kBTE_LIST) {
/* line 115 "ArrayData.puma" */
  {
/* line 117 "ArrayData.puma" */
   SetValidOverlap (shadows->SHADOW_LIST.Elem, size->BTE_LIST.Elem);
/* line 118 "ArrayData.puma" */
   shadows = shadows->SHADOW_LIST.Next;
   size = size->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  if (shadows->Kind == kSHADOW_SPEC) {
  if (size->Kind == kSLICE_EXP) {
/* line 121 "ArrayData.puma" */
 {
  rbool found;
  int val;
  {
/* line 127 "ArrayData.puma" */
   GetIntConstValue (size->SLICE_EXP.FIRST, & found, & val);
/* line 128 "ArrayData.puma" */
   if (! ((found))) goto yyL4;
  {
/* line 129 "ArrayData.puma" */
 if (val>shadows->SHADOW_SPEC.left_update) shadows->SHADOW_SPEC.left_update = val; 
/* line 131 "ArrayData.puma" */
   GetIntConstValue (size->SLICE_EXP.STOP, & found, & val);
/* line 132 "ArrayData.puma" */
   if (! ((found))) goto yyL4;
  {
/* line 133 "ArrayData.puma" */
 if (val>shadows->SHADOW_SPEC.right_update) shadows->SHADOW_SPEC.right_update = val; 
  }
  }
  }
   return;
 }
yyL4:;

  }
  }
/* line 136 "ArrayData.puma" */
  {
/* line 138 "ArrayData.puma" */
   failure2_protocol (MODULE, "SetValidOverlap", shadows, size);
  }
   return;

;
}

void BeginArrayData ARGS ((void))
{
}

void CloseArrayData ARGS ((void))
{
}
