# include "AnaOverlap.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 33 "AnaOverlap.puma" */


# define MODULE "AnaOverlap"

# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "Types.h"
# include "Transform.h"             /* ReplaceACF       */
# include "Expressions.h"           /* MakeConstant     */

# include "Traverse.h"              /* FullTraverseAST  */

# include "MoveControl.h"           /* GetShifting, ... */
# include "Rank.h"
# include "Objects.h"
# include "Nesting.h"
# include "Intrinsics.h"
# include "RegShadow.h"

# include "OverlapUpdate.h"         /* SetOverlapUpdate, ... */

/*********************************************************************
*                                                                    * 
*    global variable for a WHERE statement                           *
*                                                                    * 
*    - necessary as overlapping is not possible for                  * 
*      variables updated inside the where body                       * 
*                                                                    * 
*********************************************************************/

static tTree global_where_stmt = NoTree;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyAnaOverlap.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* AnaOverlap_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module AnaOverlap, routine %s failed\n",
  yyFunction);
 AnaOverlap_Exit ();
}

void OverlapAnalysis ARGS ((tTree t));
static void DetermineOverlapSize ARGS ((tTree t));
static void CheckForMaskOverlap ARGS ((tTree stmt, tTree mask));
static void CheckForOverlap ARGS ((tTree var, tTree exp));
static void CheckIndexOverlap ARGS ((tTree owner, tTree var));
static void CheckForVarOverlap ARGS ((tTree left_var, tTree right_var));
static void CheckCShiftOverlap ARGS ((tTree exp));
static void UpdateShadowArea ARGS ((tTree var, int full_flag, pshift pos));
static void PrintNewVarDecl ARGS ((tDefinitions obj));
static tTree MakeShadowDecl ARGS ((int n, pshift pos));
static void GetShadowSizes ARGS ((int pos, int * yyP2, int * yyP1));
static void SetVarShadow ARGS ((tTree shadow_specs, int dim, int full_flag, pshift pos));

void OverlapAnalysis
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 83 "AnaOverlap.puma" */
  {
/* line 85 "AnaOverlap.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  case kUNIT_EMPTY:
/* line 88 "AnaOverlap.puma" */
   return;

  case kUNIT_LIST:
/* line 91 "AnaOverlap.puma" */
  {
/* line 92 "AnaOverlap.puma" */
   OverlapAnalysis (t->UNIT_LIST.Elem);
/* line 93 "AnaOverlap.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kPROGRAM_DECL:
/* line 104 "AnaOverlap.puma" */
  {
/* line 106 "AnaOverlap.puma" */
   NestOpenUnit (t);
/* line 107 "AnaOverlap.puma" */
   OverlapAnalysis (t->PROGRAM_DECL.PROGRAM_BODY);
/* line 108 "AnaOverlap.puma" */
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
/* line 111 "AnaOverlap.puma" */
  {
/* line 113 "AnaOverlap.puma" */
   NestOpenUnit (t);
/* line 114 "AnaOverlap.puma" */
   OverlapAnalysis (t->PROC_DECL.PROC_BODY);
/* line 115 "AnaOverlap.puma" */
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
/* line 118 "AnaOverlap.puma" */
  {
/* line 120 "AnaOverlap.puma" */
   NestOpenUnit (t);
/* line 121 "AnaOverlap.puma" */
   OverlapAnalysis (t->FUNC_DECL.FUNC_BODY);
/* line 122 "AnaOverlap.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 125 "AnaOverlap.puma" */
  {
/* line 127 "AnaOverlap.puma" */
   NestOpenUnit (t);
/* line 128 "AnaOverlap.puma" */
   OverlapAnalysis (t->BLOCK_DATA_DECL.DATA_BODY);
/* line 129 "AnaOverlap.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
/* line 132 "AnaOverlap.puma" */
  {
/* line 134 "AnaOverlap.puma" */
   NestOpenUnit (t);
/* line 135 "AnaOverlap.puma" */
   OverlapAnalysis (t->MODULE_DECL.MODULE_BODY);
/* line 136 "AnaOverlap.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
/* line 139 "AnaOverlap.puma" */
  {
/* line 141 "AnaOverlap.puma" */
   if (! ((IsLocalUnit (GetCurrentUnit ())))) goto yyL9;
  }
   return;
yyL9:;

/* line 144 "AnaOverlap.puma" */
  {
/* line 146 "AnaOverlap.puma" */
   if (! ((optimization == 0))) goto yyL10;
  }
   return;
yyL10:;

/* line 149 "AnaOverlap.puma" */
  {
/* line 151 "AnaOverlap.puma" */
   FullTraverseAST (t, DetermineOverlapSize);
  }
   return;

  }

/* line 154 "AnaOverlap.puma" */
  {
/* line 155 "AnaOverlap.puma" */
   failure_protocol (MODULE, "OverlapAnalysis", t);
  }
   return;

;
}

static void DetermineOverlapSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kASSIGN_STMT) {
/* line 174 "AnaOverlap.puma" */
  {
/* line 176 "AnaOverlap.puma" */
   CheckForOverlap (t->ASSIGN_STMT.ASSIGN_VAR, t->ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  }
  if (t->Kind == kACF_WHERE) {
/* line 179 "AnaOverlap.puma" */
  {
/* line 181 "AnaOverlap.puma" */
   CheckForMaskOverlap (t->ACF_WHERE.TRUE_PART, t->ACF_WHERE.WHERE_EXP);
/* line 182 "AnaOverlap.puma" */
   CheckForMaskOverlap (t->ACF_WHERE.FALSE_PART, t->ACF_WHERE.WHERE_EXP);
  }
   return;

  }
  if (t->Kind == kACF_IF) {
/* line 185 "AnaOverlap.puma" */
  {
/* line 187 "AnaOverlap.puma" */
   CheckForMaskOverlap (t->ACF_IF.THEN_PART, t->ACF_IF.IF_EXP);
/* line 188 "AnaOverlap.puma" */
   CheckForMaskOverlap (t->ACF_IF.ELSE_PART, t->ACF_IF.IF_EXP);
  }
   return;

  }
;
}

static void CheckForMaskOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree mask)
# else
(stmt, mask)
 register tTree stmt;
 register tTree mask;
# endif
{
 yyRecursion:
  if (stmt->Kind == kACF_EMPTY) {
/* line 205 "AnaOverlap.puma" */
   return;

  }
  if (stmt->Kind == kACF_LIST) {
/* line 208 "AnaOverlap.puma" */
  {
/* line 210 "AnaOverlap.puma" */
   CheckForMaskOverlap (stmt->ACF_LIST.Elem, mask);
/* line 211 "AnaOverlap.puma" */
   stmt = stmt->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 214 "AnaOverlap.puma" */
  {
/* line 216 "AnaOverlap.puma" */
   CheckForOverlap (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, mask);
  }
   return;

  }
  }
  if (stmt->Kind == kACF_WHERE) {
/* line 219 "AnaOverlap.puma" */
  {
/* line 221 "AnaOverlap.puma" */
   CheckForMaskOverlap (stmt->ACF_WHERE.TRUE_PART, mask);
/* line 222 "AnaOverlap.puma" */
   stmt = stmt->ACF_WHERE.FALSE_PART;
   goto yyRecursion;
  }

  }
  if (stmt->Kind == kACF_IF) {
/* line 225 "AnaOverlap.puma" */
  {
/* line 227 "AnaOverlap.puma" */
   CheckForMaskOverlap (stmt->ACF_IF.THEN_PART, mask);
/* line 228 "AnaOverlap.puma" */
   stmt = stmt->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  }
;
}

static void CheckForOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{
 yyRecursion:

  switch (exp->Kind) {
  case kDUMMY_EXP:
/* line 241 "AnaOverlap.puma" */
   return;

  case kCONST_EXP:
/* line 244 "AnaOverlap.puma" */
   return;

  case kARRAY_EXP:
/* line 247 "AnaOverlap.puma" */
   return;

  case kBOUND_EXP:
/* line 250 "AnaOverlap.puma" */
   return;

  case kTYPE_EXP:
/* line 253 "AnaOverlap.puma" */
   return;

  case kSLICE_EXP:
/* line 256 "AnaOverlap.puma" */
   return;

  case kOP_EXP:
/* line 259 "AnaOverlap.puma" */
  {
/* line 260 "AnaOverlap.puma" */
   CheckForOverlap (var, exp->OP_EXP.OPND1);
/* line 261 "AnaOverlap.puma" */
   exp = exp->OP_EXP.OPND2;
   goto yyRecursion;
  }

  case kOP1_EXP:
/* line 264 "AnaOverlap.puma" */
  {
/* line 265 "AnaOverlap.puma" */
   exp = exp->OP1_EXP.OPND;
   goto yyRecursion;
  }

  case kPERM_EXP:
/* line 268 "AnaOverlap.puma" */
   return;

  case kVAR_EXP:
/* line 271 "AnaOverlap.puma" */
  {
/* line 272 "AnaOverlap.puma" */
   CheckForVarOverlap (var, exp->VAR_EXP.V);
/* line 273 "AnaOverlap.puma" */
   CheckIndexOverlap (var, exp->VAR_EXP.V);
  }
   return;

  case kFUNC_CALL_EXP:
/* line 276 "AnaOverlap.puma" */
  {
/* line 277 "AnaOverlap.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL11;
  {
/* line 278 "AnaOverlap.puma" */
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("CSHIFT", 6)))) goto yyL11;
  {
/* line 279 "AnaOverlap.puma" */
   CheckCShiftOverlap (exp);
  }
  }
  }
   return;
yyL11:;

/* line 282 "AnaOverlap.puma" */
  {
/* line 283 "AnaOverlap.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL12;
  {
/* line 284 "AnaOverlap.puma" */
   if (! ((IntrFuncElemental (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL12;
  {
/* line 285 "AnaOverlap.puma" */
   exp = exp->FUNC_CALL_EXP.FUNC_PARAMS;
   goto yyRecursion;
  }
  }
  }
yyL12:;

/* line 288 "AnaOverlap.puma" */
   return;

  case kBTP_LIST:
/* line 292 "AnaOverlap.puma" */
  {
/* line 293 "AnaOverlap.puma" */
   CheckForOverlap (var, exp->BTP_LIST.Elem);
/* line 294 "AnaOverlap.puma" */
   exp = exp->BTP_LIST.Next;
   goto yyRecursion;
  }

  case kBTP_EMPTY:
/* line 297 "AnaOverlap.puma" */
   return;

  case kBTE_LIST:
/* line 300 "AnaOverlap.puma" */
  {
/* line 301 "AnaOverlap.puma" */
   CheckForOverlap (var, exp->BTE_LIST.Elem);
/* line 302 "AnaOverlap.puma" */
   exp = exp->BTE_LIST.Next;
   goto yyRecursion;
  }

  case kBTE_EMPTY:
/* line 305 "AnaOverlap.puma" */
   return;

  case kNO_PARAM:
/* line 308 "AnaOverlap.puma" */
   return;

  case kVAR_PARAM:
  if (exp->VAR_PARAM.V->Kind == kADDR) {
/* line 311 "AnaOverlap.puma" */
  {
/* line 312 "AnaOverlap.puma" */
   exp = exp->VAR_PARAM.V->ADDR.E;
   goto yyRecursion;
  }

  }
/* line 315 "AnaOverlap.puma" */
  {
/* line 316 "AnaOverlap.puma" */
   CheckForVarOverlap (var, exp->VAR_PARAM.V);
  }
   return;

  }

/* line 319 "AnaOverlap.puma" */
  {
/* line 320 "AnaOverlap.puma" */
   failure_protocol (MODULE, "CheckForOverlap", exp);
  }
   return;

;
}

static void CheckIndexOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree owner, register tTree var)
# else
(owner, var)
 register tTree owner;
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kINDEXED_VAR) {
/* line 325 "AnaOverlap.puma" */
  {
/* line 327 "AnaOverlap.puma" */
   CheckIndexOverlap (owner, var->INDEXED_VAR.IND_VAR);
/* line 328 "AnaOverlap.puma" */
   CheckForOverlap (owner, var->INDEXED_VAR.IND_EXPS);
  }
   return;

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 331 "AnaOverlap.puma" */
  {
/* line 333 "AnaOverlap.puma" */
   var = var->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;
  }

  }
  if (var->Kind == kSUBSTRING_VAR) {
/* line 336 "AnaOverlap.puma" */
  {
/* line 338 "AnaOverlap.puma" */
   CheckIndexOverlap (owner, var->SUBSTRING_VAR.IND_VAR);
/* line 339 "AnaOverlap.puma" */
   CheckForOverlap (owner, var->SUBSTRING_VAR.IND_EXP);
  }
   return;

  }
;
}

static void CheckForVarOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree left_var, register tTree right_var)
# else
(left_var, right_var)
 register tTree left_var;
 register tTree right_var;
# endif
{
/* line 350 "AnaOverlap.puma" */
 {
  shift_vector pos;
  rbool found;
  {
/* line 355 "AnaOverlap.puma" */
   GetShifting (left_var, right_var, & found, & pos);
/* line 357 "AnaOverlap.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 359 "AnaOverlap.puma" */
   if (! ((IsOverlapUpdate (& pos)))) goto yyL1;
  {
/* line 361 "AnaOverlap.puma" */
   stmt_protocol ("shadow reduces movement");
/* line 363 "AnaOverlap.puma" */
   UpdateShadowArea (right_var, 0, & pos);
  }
  }
  }
   return;
 }
yyL1:;

/* line 366 "AnaOverlap.puma" */
   return;

;
}

static void CheckCShiftOverlap
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kFUNC_CALL_EXP) {
/* line 377 "AnaOverlap.puma" */
 {
  shift_vector pos;
  rbool found;
  tTree var;
  {
/* line 383 "AnaOverlap.puma" */
   GetCircularShifting (exp, & found, & var, & pos);
/* line 385 "AnaOverlap.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 387 "AnaOverlap.puma" */
   stmt_protocol ("shadow (also serial dim)  will remove circular shifting");
/* line 389 "AnaOverlap.puma" */
   if (! ((IsOverlapUpdate (& pos)))) goto yyL1;
  {
/* line 393 "AnaOverlap.puma" */
   UpdateShadowArea (var, 1, & pos);
  }
  }
  }
   return;
 }
yyL1:;

  }
/* line 396 "AnaOverlap.puma" */
   return;

;
}

static void UpdateShadowArea
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int full_flag, pshift pos)
# else
(var, full_flag, pos)
 register tTree var;
 register int full_flag;
 pshift pos;
# endif
{
 yyRecursion:
  if (var->Kind == kINDEXED_VAR) {
/* line 409 "AnaOverlap.puma" */
  {
/* line 411 "AnaOverlap.puma" */
   var = var->INDEXED_VAR.IND_VAR;
   goto yyRecursion;
  }

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 414 "AnaOverlap.puma" */
  {
/* line 416 "AnaOverlap.puma" */
   var = var->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;
  }

  }
  if (var->Kind == kUSED_VAR) {
/* line 419 "AnaOverlap.puma" */
  {
/* line 421 "AnaOverlap.puma" */
   var = var->USED_VAR.VARNAME;
   goto yyRecursion;
  }

  }
  if (var->Kind == kVAR_OBJ) {
  if (var->VAR_OBJ.Object->Kind == kVarObject) {
/* line 424 "AnaOverlap.puma" */
  {
/* line 426 "AnaOverlap.puma" */
   if (! ((VarRank (var->VAR_OBJ.Object) == pos -> shift_rank))) goto yyL4;
  {
/* line 428 "AnaOverlap.puma" */
 if (var->VAR_OBJ.Object->VarObject.shadow == NoTree)
        SetDefaultShadow (var->VAR_OBJ.Object);
   
/* line 432 "AnaOverlap.puma" */
   SetVarShadow (var->VAR_OBJ.Object->VarObject.shadow, 0, full_flag, pos);
/* line 433 "AnaOverlap.puma" */
   FixShadowVarObject (var->VAR_OBJ.Object);
/* line 434 "AnaOverlap.puma" */
   PrintNewVarDecl (var->VAR_OBJ.Object);
  }
  }
   return;
yyL4:;

  }
/* line 437 "AnaOverlap.puma" */
  {
/* line 439 "AnaOverlap.puma" */
   PrintNewVarDecl (var->VAR_OBJ.Object);
  }
   return;

  }
/* line 442 "AnaOverlap.puma" */
  {
/* line 444 "AnaOverlap.puma" */
   failure_protocol (MODULE, "UpdateShadowArea", var);
  }
   return;

;
}

static void PrintNewVarDecl
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 455 "AnaOverlap.puma" */
  {
/* line 457 "AnaOverlap.puma" */
   tree_protocol ("array with shadow : \n", obj->VarObject.decl);
/* line 459 "AnaOverlap.puma" */
   if (! ((obj->VarObject.shadow != NoTree))) goto yyL1;
  {
/* line 461 "AnaOverlap.puma" */
   tree_protocol ("new shadow : \n", obj->VarObject.shadow);
  }
  }
   return;
yyL1:;

  }
;
}

static tTree MakeShadowDecl
# if defined __STDC__ | defined __cplusplus
(register int n, pshift pos)
# else
(n, pos)
 register int n;
 pshift pos;
# endif
{
/* line 472 "AnaOverlap.puma" */
  {
/* line 474 "AnaOverlap.puma" */
   if (! ((n >= pos -> shift_rank))) goto yyL1;
  }
   return mSHADOW_EMPTY ();
yyL1:;

/* line 479 "AnaOverlap.puma" */
 {
  tTree shadow_spec;
  int yyV1;
  int yyV2;
  {
/* line 483 "AnaOverlap.puma" */
   GetShadowSizes (pos -> shift_pos [n], & yyV1, & yyV2);
/* line 485 "AnaOverlap.puma" */
 shadow_spec = mSHADOW_SPEC (0, mDUMMY_EXP(), mDUMMY_EXP(),
                                 yyV1, yyV2, 0, 0); 
   
  }
   return mSHADOW_LIST (shadow_spec, MakeShadowDecl (n + 1, pos));
 }

}

static void GetShadowSizes
# if defined __STDC__ | defined __cplusplus
(register int pos, register int * yyP2, register int * yyP1)
# else
(pos, yyP2, yyP1)
 register int pos;
 register int * yyP2;
 register int * yyP1;
# endif
{
/* line 494 "AnaOverlap.puma" */
  {
/* line 496 "AnaOverlap.puma" */
   if (! ((pos < 0))) goto yyL1;
  {
/* line 497 "AnaOverlap.puma" */
   if (! ((- pos <= MAX_SHADOW_SIZE))) goto yyL1;
  }
  }
   * yyP2 = 0;
   * yyP1 = - pos;
   return;
yyL1:;

/* line 500 "AnaOverlap.puma" */
  {
/* line 502 "AnaOverlap.puma" */
   if (! ((pos < 0))) goto yyL2;
  }
   * yyP2 = 0;
   * yyP1 = MAX_SHADOW_SIZE;
   return;
yyL2:;

/* line 505 "AnaOverlap.puma" */
  {
/* line 507 "AnaOverlap.puma" */
   if (! ((pos > 0))) goto yyL3;
  {
/* line 508 "AnaOverlap.puma" */
   if (! ((pos <= MAX_SHADOW_SIZE))) goto yyL3;
  }
  }
   * yyP2 = pos;
   * yyP1 = 0;
   return;
yyL3:;

/* line 511 "AnaOverlap.puma" */
  {
/* line 513 "AnaOverlap.puma" */
   if (! ((pos > 0))) goto yyL4;
  }
   * yyP2 = MAX_SHADOW_SIZE;
   * yyP1 = 0;
   return;
yyL4:;

/* line 516 "AnaOverlap.puma" */
   * yyP2 = 0;
   * yyP1 = 0;
   return;

;
}

static void SetVarShadow
# if defined __STDC__ | defined __cplusplus
(register tTree shadow_specs, register int dim, register int full_flag, pshift pos)
# else
(shadow_specs, dim, full_flag, pos)
 register tTree shadow_specs;
 register int dim;
 register int full_flag;
 pshift pos;
# endif
{
 yyRecursion:
  if (shadow_specs->Kind == kSHADOW_EMPTY) {
/* line 528 "AnaOverlap.puma" */
   return;

  }
  if (shadow_specs->Kind == kSHADOW_LIST) {
/* line 533 "AnaOverlap.puma" */
  {
/* line 535 "AnaOverlap.puma" */
   IncShadowSystemSize (shadow_specs->SHADOW_LIST.Elem, full_flag, pos -> shift_pos [dim]);
/* line 536 "AnaOverlap.puma" */
   shadow_specs = shadow_specs->SHADOW_LIST.Next;
   dim = dim + 1;
   goto yyRecursion;
  }

  }
/* line 539 "AnaOverlap.puma" */
  {
/* line 541 "AnaOverlap.puma" */
   failure_protocol (MODULE, "SetVarShadow", shadow_specs);
  }
   return;

;
}

void BeginAnaOverlap ARGS ((void))
{
}

void CloseAnaOverlap ARGS ((void))
{
}
