# include "Addressing.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 24 "Addressing.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"
# include "Types.h"
# include "protocol.h"

# include "FArguments.h"
# include "Transform.h"         /* ReplaceDECL, ...    */
# include "Expressions.h"       /* MakeConstant, ...   */
# include "Dalib.h"             /* MakeVarDeclA, ...   */
# include "Shapes.h"            /* MakeFullShape, ...  */

# include "Rank.h"              /* VarRank, ...        */
# include "Traverse.h"          /* ReplaceAST, ...     */

# include "PseudoDynamic.h"     /* MakeVarDeclA, ...   */
# include "Distributions.h"
# include "Nesting.h"
# include "Objects.h"
# include "ArrayDescriptor.h"
# include "CodeGeneral.h"       /* NewHelpVars         */

# include "DefTable.h"

# include "VarDescriptor.h"

# define MODULE "Addressing"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyAddressing.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Addressing_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Addressing, routine %s failed\n",
  yyFunction);
 Addressing_Exit ();
}

void Addressing ARGS ((tTree t));
static rbool IsFullDynamic ARGS ((tDefinitions obj));
static rbool IsPseudoDynamic ARGS ((tDefinitions obj));
static rbool IsNoDynamic ARGS ((tDefinitions obj));
static void Localize ARGS ((tTree t));
static rbool localize_pred ARGS ((tTree t));
static tTree localize_func ARGS ((tTree t));
static void LocalizeSelection ARGS ((tTree var));
static tTree LocalizeVarDecl ARGS ((tTree t, tDefinitions obj));
static tTree MakeAllocatableArray ARGS ((tTree type));
static void CheckUpIndexedAccess ARGS ((tTree var));
static void LocalizeIndexedAccess ARGS ((tTree var));
static rbool IsMappedDim ARGS ((int dist_kind, tTree dist_size));
static rbool IsCyclicOne ARGS ((int dist_kind, tTree dist_size));
static void GlobalToLocalIndex ARGS ((tTree indexes, int pos, int dim, tIdent id));
static rbool IsLegalObject ARGS ((tTree var_obj));
static tTree TranslateAccess ARGS ((tTree var));
static tTree MakeDalibAllocate ARGS ((tTree var));
static tTree TranslateDeallocate ARGS ((tTree var));
static void GetVarObject ARGS ((tTree var, tDefinitions * yyP1));
static tTree MakeCommonVarAddr ARGS ((tTree common_ids));

void Addressing
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 64 "Addressing.puma" */
  {
/* line 66 "Addressing.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  case kUNIT_LIST:
/* line 69 "Addressing.puma" */
  {
/* line 71 "Addressing.puma" */
   Addressing (t->UNIT_LIST.Elem);
/* line 72 "Addressing.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kUNIT_EMPTY:
/* line 75 "Addressing.puma" */
   return;

  case kPROGRAM_DECL:
/* line 78 "Addressing.puma" */
  {
/* line 80 "Addressing.puma" */
   NestOpenUnit (t);
/* line 81 "Addressing.puma" */
   Addressing (t->PROGRAM_DECL.PROGRAM_BODY);
/* line 82 "Addressing.puma" */
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
/* line 85 "Addressing.puma" */
  {
/* line 87 "Addressing.puma" */
   NestOpenUnit (t);
/* line 88 "Addressing.puma" */
   Addressing (t->PROC_DECL.PROC_BODY);
/* line 89 "Addressing.puma" */
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
/* line 92 "Addressing.puma" */
  {
/* line 94 "Addressing.puma" */
   NestOpenUnit (t);
/* line 95 "Addressing.puma" */
   Addressing (t->FUNC_DECL.FUNC_BODY);
/* line 96 "Addressing.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 99 "Addressing.puma" */
  {
/* line 101 "Addressing.puma" */
   NestOpenUnit (t);
/* line 102 "Addressing.puma" */
   Addressing (t->BLOCK_DATA_DECL.DATA_BODY);
/* line 103 "Addressing.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
/* line 106 "Addressing.puma" */
  {
/* line 108 "Addressing.puma" */
   NestOpenUnit (t);
/* line 109 "Addressing.puma" */
   Addressing (t->MODULE_DECL.MODULE_BODY);
/* line 110 "Addressing.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
/* line 113 "Addressing.puma" */
  {
/* line 115 "Addressing.puma" */
   Localize (t);
/* line 116 "Addressing.puma" */
   t = t->BODY_NODE.INTERNALS;
   goto yyRecursion;
  }

  }

;
}

static rbool IsFullDynamic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 149 "Addressing.puma" */
  {
/* line 150 "Addressing.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 151 "Addressing.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
/* line 154 "Addressing.puma" */
  {
/* line 156 "Addressing.puma" */
   if (! ((obj->VarObject.arr_kind != arr_fixed_size))) goto yyL2;
  {
/* line 157 "Addressing.puma" */
   if (! ((! FortranNoDynamicArrays ()))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

/* line 160 "Addressing.puma" */
  {
/* line 162 "Addressing.puma" */
   if (! ((obj->VarObject.arr_kind == arr_fixed_size))) goto yyL3;
  {
/* line 164 "Addressing.puma" */
   if (! (((VarDistribution (obj) == 1) || IsHPFDynamic (obj)))) goto yyL3;
  {
/* line 166 "Addressing.puma" */
   if (! ((! FortranNoDynamicArrays ()))) goto yyL3;
  }
  }
  }
   return rtrue;
yyL3:;

  }
  }
  return rfalse;
}

static rbool IsPseudoDynamic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 177 "Addressing.puma" */
  {
/* line 179 "Addressing.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 180 "Addressing.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 183 "Addressing.puma" */
  {
/* line 185 "Addressing.puma" */
   if (! ((GetObjDimension (obj) == NoTree))) goto yyL2;
  {
/* line 187 "Addressing.puma" */
   return rfalse;
  }
  }
yyL2:;

  if (obj->Kind == kVarObject) {
/* line 193 "Addressing.puma" */
  {
/* line 195 "Addressing.puma" */
   if (! ((IsVarAssumedSize (obj)))) goto yyL3;
  {
/* line 197 "Addressing.puma" */
   return rfalse;
  }
  }
yyL3:;

/* line 200 "Addressing.puma" */
  {
/* line 202 "Addressing.puma" */
   if (! ((! IsStaticObj (obj)))) goto yyL4;
  }
   return rtrue;
yyL4:;

/* line 205 "Addressing.puma" */
  {
/* line 207 "Addressing.puma" */
   obj_protocol ("this object is not pseudo dynamic", obj);
/* line 208 "Addressing.puma" */
   return rfalse;
  }

  }
  return rfalse;
}

static rbool IsNoDynamic
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 219 "Addressing.puma" */
  {
/* line 221 "Addressing.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (obj->Kind == kVarObject) {
/* line 224 "Addressing.puma" */
  {
/* line 226 "Addressing.puma" */
   if (! ((IsStaticObj (obj)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 229 "Addressing.puma" */
  {
/* line 231 "Addressing.puma" */
   if (! ((IsVarAssumedSize (obj)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

static void Localize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 247 "Addressing.puma" */
  {
/* line 249 "Addressing.puma" */
   NewHelpVars = mDECL_EMPTY ();
/* line 251 "Addressing.puma" */
 t->BODY_NODE.DECLS     = ReplaceAST (t->BODY_NODE.DECLS,     localize_pred, localize_func); 
     t->BODY_NODE.NEW_DECLS = ReplaceAST (t->BODY_NODE.NEW_DECLS, localize_pred, localize_func); 
     t->BODY_NODE.STATS     = ReplaceAST (t->BODY_NODE.STATS,     localize_pred, localize_func); 

     t->BODY_NODE.NEW_DECLS = AppendDECLS (t->BODY_NODE.NEW_DECLS, NewHelpVars);

   
  }
   return;

  }
/* line 260 "Addressing.puma" */
  {
/* line 262 "Addressing.puma" */
   failure_protocol (MODULE, "Localize", t);
  }
   return;

;
}

static rbool localize_pred
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
/* line 277 "Addressing.puma" */
   return rtrue;

  }
  if (t->Kind == kCOMMON_DECL) {
/* line 280 "Addressing.puma" */
   return rtrue;

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
/* line 285 "Addressing.puma" */
   return rtrue;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
/* line 288 "Addressing.puma" */
   return rtrue;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kACCESS_STMT) {
/* line 291 "Addressing.puma" */
   return rtrue;

  }
  }
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kUSED_VAR) {
/* line 294 "Addressing.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static tTree localize_func
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_DECL) {
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
/* line 307 "Addressing.puma" */
   return LocalizeVarDecl (t, GetLocalObject (t->VAR_DECL.Ident));

  }
  }
  if (t->Kind == kCOMMON_DECL) {
/* line 314 "Addressing.puma" */
 {
  tTree common_addr_decls;
  tTree new_common;
  tIdent common_id;
  {
/* line 320 "Addressing.puma" */
   new_common = t;
/* line 322 "Addressing.puma" */
   common_addr_decls = MakeCommonVarAddr (t->COMMON_DECL.IDS);
/* line 324 "Addressing.puma" */
   if ((common_addr_decls != NoTree)) {
/* line 326 "Addressing.puma" */
   if ((t->COMMON_DECL.Ident == DefaultId ())) {
/* line 327 "Addressing.puma" */
   common_id = IsIdent ("BLANK_ADDR");
   } else {
/* line 328 "Addressing.puma" */
   common_id = MakeNewId (t->COMMON_DECL.Ident, "_ADDR");
   }
/* line 331 "Addressing.puma" */
   common_addr_decls = mCOMMON_DECL (common_id, t->COMMON_DECL.Line, common_addr_decls);
/* line 333 "Addressing.puma" */
   new_common = mDECL_LIST (new_common, mDECL_LIST (common_addr_decls, NoTree));
   }
  }
   return new_common;
 }

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kACCESS_STMT) {
/* line 342 "Addressing.puma" */
  {
/* line 346 "Addressing.puma" */
   stmt_protocol ("translate access");
/* line 348 "Addressing.puma" */
   LocalizeSelection (t->ACF_BASIC.BASIC_STMT->ACCESS_STMT.VAR);
/* line 350 "Addressing.puma" */
 t->ACF_BASIC.BASIC_STMT = TranslateAccess (t->ACF_BASIC.BASIC_STMT->ACCESS_STMT.VAR); 
/* line 352 "Addressing.puma" */
   stmt_protocol ("translated access");
  }
   return t;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kALLOCATE_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS->Kind == kBTP_LIST) {
  if (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 359 "Addressing.puma" */
  {
/* line 362 "Addressing.puma" */
   stmt_protocol ("translate allocate");
/* line 364 "Addressing.puma" */
   LocalizeSelection (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS->BTP_LIST.Elem->VAR_PARAM.V);
/* line 366 "Addressing.puma" */
 t->ACF_BASIC.BASIC_STMT = MakeDalibAllocate (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS->BTP_LIST.Elem->VAR_PARAM.V); 
/* line 368 "Addressing.puma" */
   stmt_protocol ("translated allocate");
  }
   return t;

  }
  }
  }
  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kDEALLOCATE_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS->Kind == kBTP_LIST) {
  if (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 373 "Addressing.puma" */
  {
/* line 376 "Addressing.puma" */
   stmt_protocol ("translate deallocate");
/* line 378 "Addressing.puma" */
   LocalizeSelection (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS->BTP_LIST.Elem->VAR_PARAM.V);
/* line 380 "Addressing.puma" */
 t->ACF_BASIC.BASIC_STMT = TranslateDeallocate (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS->BTP_LIST.Elem->VAR_PARAM.V); 
/* line 382 "Addressing.puma" */
   stmt_protocol ("translated deallocate");
  }
   return t;

  }
  }
  }
  }
  }
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kUSED_VAR) {
/* line 387 "Addressing.puma" */
  {
/* line 389 "Addressing.puma" */
   if (! ((IsPseudoDynamic (t->VAR_PARAM.V->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL6;
  {
/* line 390 "Addressing.puma" */
 t->VAR_PARAM.V = FirstArrayElement (MakeFullShape (t->VAR_PARAM.V)); 
     LocalizeIndexedAccess (t->VAR_PARAM.V);
     CheckUpIndexedAccess (t->VAR_PARAM.V);
   
  }
  }
   return t;
yyL6:;

  }
  }
  if (t->Kind == kINDEXED_VAR) {
/* line 397 "Addressing.puma" */
  {
/* line 399 "Addressing.puma" */
   LocalizeIndexedAccess (t);
/* line 400 "Addressing.puma" */
   CheckUpIndexedAccess (t);
  }
   return t;

  }
  if (t->Kind == kSIZE_EXP) {
  if (t->SIZE_EXP.VAR->Kind == kUSED_VAR) {
/* line 404 "Addressing.puma" */
 {
  tTree indexes;
  {
/* line 406 "Addressing.puma" */
   if (! ((IsPseudoDynamic (t->SIZE_EXP.VAR->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL8;
  {
/* line 410 "Addressing.puma" */
 indexes = mBTE_LIST (MakeConstant (1), mBTE_EMPTY ());
     t->SIZE_EXP.VAR = mINDEXED_VAR (t->SIZE_EXP.VAR, indexes); 
   
  }
  }
   return t;
 }
yyL8:;

  }
  if (t->SIZE_EXP.VAR->Kind == kSELECTED_VAR) {
/* line 417 "Addressing.puma" */
 {
  tTree indexes;
  {
/* line 419 "Addressing.puma" */
   if (! ((IsPseudoDynamic (t->SIZE_EXP.VAR->SELECTED_VAR.SELECTOR->REC_COMP.Object)))) goto yyL9;
  {
/* line 423 "Addressing.puma" */
 indexes = mBTE_LIST (MakeConstant (1), mBTE_EMPTY ());
     t->SIZE_EXP.VAR = mINDEXED_VAR (t->SIZE_EXP.VAR, indexes); 
   
  }
  }
   return t;
 }
yyL9:;

  }
/* line 430 "Addressing.puma" */
  {
/* line 432 "Addressing.puma" */
 t->SIZE_EXP.VAR = FirstArrayElement (MakeFullShape (t->SIZE_EXP.VAR)); 
  }
   return t;

  }
/* line 437 "Addressing.puma" */
   return t;

}

static void LocalizeSelection
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kSELECTED_VAR) {
/* line 452 "Addressing.puma" */
  {
/* line 454 "Addressing.puma" */
 var->SELECTED_VAR.SELEC_VAR = ReplaceAST (var->SELECTED_VAR.SELEC_VAR, localize_pred, localize_func);  
  }
   return;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 457 "Addressing.puma" */
  {
/* line 459 "Addressing.puma" */
   var = var->INDEXED_VAR.IND_VAR;
   goto yyRecursion;
  }

  }
  if (var->Kind == kSUBSTRING_VAR) {
/* line 462 "Addressing.puma" */
  {
/* line 464 "Addressing.puma" */
   var = var->SUBSTRING_VAR.IND_VAR;
   goto yyRecursion;
  }

  }
;
}

static tTree LocalizeVarDecl
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions obj)
# else
(t, obj)
 register tTree t;
 register tDefinitions obj;
# endif
{
  if (t->Kind == kVAR_DECL) {
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
/* line 475 "Addressing.puma" */
  {
/* line 477 "Addressing.puma" */
   if (! ((IsFullDynamic (obj)))) goto yyL1;
  {
/* line 478 "Addressing.puma" */
 if (!IsVarAllocatable(obj))
       t->VAR_DECL.VAL = MakeAllocatableArray (t->VAR_DECL.VAL); 
   
  }
  }
   return t;
yyL1:;

/* line 484 "Addressing.puma" */
  {
/* line 486 "Addressing.puma" */
   if (! ((IsPseudoDynamic (obj)))) goto yyL2;
  }
   return MakePseudoDynamicArray (t);
yyL2:;

  }
  }
/* line 490 "Addressing.puma" */
  {
/* line 491 "Addressing.puma" */
   if (! ((IsNoDynamic (obj)))) goto yyL3;
  }
   return t;
yyL3:;

/* line 495 "Addressing.puma" */
  {
/* line 497 "Addressing.puma" */
   obj_error_protocol ("dynamic kind is unknown", obj);
/* line 498 "Addressing.puma" */
   failure_protocol (MODULE, "LocalizeVarDecl (unknown dynamic kind)", t);
  }
   return t;

}

static tTree MakeAllocatableArray
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
  if (type->Kind == kARRAY_TYPE) {
/* line 512 "Addressing.puma" */
   return mARRAY_TYPE (MakeAllocatableArray (type->ARRAY_TYPE.ARRAY_INDEX_TYPES), type->ARRAY_TYPE.ARRAY_COMP_TYPE);

  }
  if (type->Kind == kSHAPE_LIST) {
  if (type->SHAPE_LIST.Elem->Kind == kEXPLICIT_SHAPE) {
/* line 516 "Addressing.puma" */
 {
  tTree new;
  {
/* line 520 "Addressing.puma" */
 new = mDEFERRED_SHAPE (); 
  }
   return mSHAPE_LIST (new, MakeAllocatableArray (type->SHAPE_LIST.Next));
 }

  }
  }
  if (type->Kind == kSHAPE_EMPTY) {
/* line 525 "Addressing.puma" */
   return type;

  }
/* line 529 "Addressing.puma" */
  {
/* line 530 "Addressing.puma" */
   failure_protocol (MODULE, "MakeAllocatableArray", type);
  }
   return type;

}

static void CheckUpIndexedAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
  if (var->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 542 "Addressing.puma" */
  {
/* line 544 "Addressing.puma" */
   if (! ((IsPseudoDynamic (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL1;
  {
/* line 545 "Addressing.puma" */
   PseudoDynamicIndexing (var);
  }
  }
   return;
yyL1:;

  }
  if (var->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
/* line 548 "Addressing.puma" */
  {
/* line 552 "Addressing.puma" */
   if (! ((IsPseudoDynamic (var->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELECTOR->REC_COMP.Object)))) goto yyL2;
  {
/* line 553 "Addressing.puma" */
   PseudoDynamicIndexing (var);
  }
  }
   return;
yyL2:;

  }
  }
;
}

static void LocalizeIndexedAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
  if (var->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 564 "Addressing.puma" */
 {
  var_descriptor vard;
  int i;
  {
/* line 566 "Addressing.puma" */
   if (! ((IsLegalObject (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME)))) goto yyL1;
  {
/* line 571 "Addressing.puma" */
   SetVarDescriptor (var, & vard);
/* line 573 "Addressing.puma" */
 for (i=0; i < vard.formal_rank; i++)

       { if (IsMappedDim (vard.distribution_kind[i],
                          vard.distribution_size[i]) )

            GlobalToLocalIndex (var->INDEXED_VAR.IND_EXPS, 1, i+1, var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
    
       }
  
  }
  }
   return;
 }
yyL1:;

  }
  }
;
}

static rbool IsMappedDim
# if defined __STDC__ | defined __cplusplus
(register int dist_kind, register tTree dist_size)
# else
(dist_kind, dist_size)
 register int dist_kind;
 register tTree dist_size;
# endif
{
/* line 595 "Addressing.puma" */
  {
/* line 597 "Addressing.puma" */
   if (! ((dist_kind == kINDIRECT_DIM))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 600 "Addressing.puma" */
  {
/* line 602 "Addressing.puma" */
   if (! ((dist_kind == kARBITRARY_DIM))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 605 "Addressing.puma" */
  {
/* line 607 "Addressing.puma" */
   if (! ((dist_kind == kCYCLIC_DIM))) goto yyL3;
  {
/* line 608 "Addressing.puma" */
   if (! ((! IsCyclicOne (dist_kind, dist_size)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  return rfalse;
}

static rbool IsCyclicOne
# if defined __STDC__ | defined __cplusplus
(register int dist_kind, register tTree dist_size)
# else
(dist_kind, dist_size)
 register int dist_kind;
 register tTree dist_size;
# endif
{
/* line 613 "Addressing.puma" */
  {
/* line 615 "Addressing.puma" */
   if (! ((dist_kind == kCYCLIC_DIM))) goto yyL1;
  {
/* line 616 "Addressing.puma" */
   if (! ((dist_size == NoTree))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 619 "Addressing.puma" */
 {
  rbool found;
  int val;
  {
/* line 624 "Addressing.puma" */
   if (! ((dist_kind == kCYCLIC_DIM))) goto yyL2;
  {
/* line 625 "Addressing.puma" */
   if (! ((dist_size != NoTree))) goto yyL2;
  {
/* line 627 "Addressing.puma" */
   GetIntConstValue (dist_size, & found, & val);
/* line 629 "Addressing.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 630 "Addressing.puma" */
   if (! ((val == 1))) goto yyL2;
  }
  }
  }
  }
   return rtrue;
 }
yyL2:;

  return rfalse;
}

static void GlobalToLocalIndex
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int pos, register int dim, register tIdent id)
# else
(indexes, pos, dim, id)
 register tTree indexes;
 register int pos;
 register int dim;
 register tIdent id;
# endif
{
 yyRecursion:
  if (indexes->Kind == kBTE_LIST) {
/* line 635 "Addressing.puma" */
  {
/* line 637 "Addressing.puma" */
   if (! ((pos < dim))) goto yyL1;
  {
/* line 639 "Addressing.puma" */
   indexes = indexes->BTE_LIST.Next;
   pos = pos + 1;
   goto yyRecursion;
  }
  }
yyL1:;

/* line 642 "Addressing.puma" */
  {
/* line 644 "Addressing.puma" */
   if (! ((pos == dim))) goto yyL2;
  {
/* line 646 "Addressing.puma" */
 indexes->BTE_LIST.Elem = DalibGlobalToLocal (id, dim, indexes->BTE_LIST.Elem); 
  }
  }
   return;
yyL2:;

  }
;
}

static rbool IsLegalObject
# if defined __STDC__ | defined __cplusplus
(register tTree var_obj)
# else
(var_obj)
 register tTree var_obj;
# endif
{
  if (var_obj->Kind == kVAR_OBJ) {
/* line 652 "Addressing.puma" */
  {
/* line 654 "Addressing.puma" */
   if (! ((var_obj->VAR_OBJ.Object == NoObject))) goto yyL1;
  {
/* line 655 "Addressing.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 658 "Addressing.puma" */
  {
/* line 660 "Addressing.puma" */
   if (! ((var_obj->VAR_OBJ.Reaching == NoTree))) goto yyL2;
  {
/* line 661 "Addressing.puma" */
   return rfalse;
  }
  }
yyL2:;

/* line 664 "Addressing.puma" */
   return rtrue;

  }
  return rfalse;
}

static tTree TranslateAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 682 "Addressing.puma" */
 {
  tTree paramlist;
  tTree param;
  tIdent sub_name;
  rbool is_char;
  tDefinitions yyV1;
  {
/* line 689 "Addressing.puma" */
   GetVarObject (var, & yyV1);
/* line 691 "Addressing.puma" */
 is_char = IsStringType (GetBaseType (GetObjectType (yyV1)));

     if (IsPseudoDynamic (yyV1))

       { paramlist = PseudoDynamicParams (var, VarRank (yyV1));
         sub_name  = MakeDalibCId ("array_access", is_char);
       }

      else

       { paramlist = mBTP_EMPTY ();
         sub_name  = MakeDalibCId ("array_setdata", is_char);
       }

     param     = mVAR_PARAM (MakeVarSuffixA (var, ""));
     paramlist = mBTP_LIST (param, paramlist);
     param     = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
     paramlist = mBTP_LIST (param, paramlist);

    
  }
   return mCALL_STMT (mPROC_OBJ (sub_name), paramlist);
 }

}

static tTree MakeDalibAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 726 "Addressing.puma" */
 {
  tTree paramlist;
  tTree param;
  tIdent sub_name;
  rbool is_char;
  tDefinitions yyV1;
  {
/* line 733 "Addressing.puma" */
   GetVarObject (var, & yyV1);
/* line 735 "Addressing.puma" */
 is_char = IsStringType (GetBaseType (GetObjectType (yyV1)));

     paramlist = mBTP_EMPTY ();
     param     = mVAR_PARAM (MakeVarSuffixA (var, ""));
     paramlist = mBTP_LIST (param, paramlist);
     param     = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
     paramlist = mBTP_LIST (param, paramlist);

     sub_name  = MakeDalibCId ("array_allocate", is_char);

   
  }
   return mCALL_STMT (mPROC_OBJ (sub_name), paramlist);
 }

}

static tTree TranslateDeallocate
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 765 "Addressing.puma" */
 {
  tTree params;
  tTree call;
  {
/* line 770 "Addressing.puma" */
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX)), mBTP_EMPTY ());
/* line 773 "Addressing.puma" */
 call  = mPROC_OBJ (MakeDalibId ("array_deallocate")); 
/* line 775 "Addressing.puma" */
   call = mCALL_STMT (call, params);
  }
   return call;
 }

}

static void GetVarObject
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions * yyP1)
# else
(var, yyP1)
 register tTree var;
 register tDefinitions * yyP1;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 788 "Addressing.puma" */
   * yyP1 = var->USED_VAR.VARNAME->VAR_OBJ.Object;
   return;

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 791 "Addressing.puma" */
   * yyP1 = var->SELECTED_VAR.SELECTOR->REC_COMP.Object;
   return;

  }
/* line 794 "Addressing.puma" */
  {
/* line 796 "Addressing.puma" */
   failure_protocol (MODULE, "GetVarObject", var);
  }
   * yyP1 = NoObject;
   return;

;
}

static tTree MakeCommonVarAddr
# if defined __STDC__ | defined __cplusplus
(register tTree common_ids)
# else
(common_ids)
 register tTree common_ids;
# endif
{
  if (common_ids->Kind == kDECL_EMPTY) {
/* line 817 "Addressing.puma" */
   return NoTree;

  }
  if (common_ids->Kind == kDECL_LIST) {
  if (common_ids->DECL_LIST.Elem->Kind == kVAR_DECL) {
/* line 822 "Addressing.puma" */
 {
  tDefinitions obj;
  tTree new;
  int kind;
  {
/* line 828 "Addressing.puma" */
   obj = GetLocalObject (common_ids->DECL_LIST.Elem->VAR_DECL.Ident);
/* line 829 "Addressing.puma" */
   new = MakeCommonVarAddr (common_ids->DECL_LIST.Next);
/* line 831 "Addressing.puma" */
   if ((IsPseudoDynamic (obj))) {
/* line 835 "Addressing.puma" */
   if ((new == NoTree)) {
/* line 835 "Addressing.puma" */
   new = mDECL_EMPTY ();
   }
/* line 837 "Addressing.puma" */
   new = AppendDECLS (PseudoDynamicCommDecls (common_ids->DECL_LIST.Elem->VAR_DECL.Ident, VarRank (obj)), new);
   }
  }
   return new;
 }

  }
  }
/* line 844 "Addressing.puma" */
  {
/* line 846 "Addressing.puma" */
   failure_protocol (MODULE, "MakeCommonVarAddr", common_ids);
  }
   return NoTree;

}

void BeginAddressing ARGS ((void))
{
}

void CloseAddressing ARGS ((void))
{
}
