# include "AdaptF77.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 44 "AdaptF77.puma" */

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Types.h"
# include "Transform.h"    /* AppendDECLS, CombineACF  */
# include "Shapes.h"
# include "Rank.h"
# include "Distributions.h"
# include "Loops.h"

# include "Temporary.h"    /* GetLoopTemporary */

# include "Expressions.h"
# include "Reductions.h"

# include "IndexShapes.h"  /* FindShapeExp */
# include "ReplaceExp.h"   /* RenameLoopId */

# include "Accepted.h"     /* DoLoopExpression */
# include "MakeLoops.h" 

# include "BuildTree.h"
# include "VarDescriptor.h"  
# include "ExpDescriptor.h"   
# include "MoveControl.h"
# include "Nesting.h"        /* NestOpenType     */
# include "DefTable.h"       /*                  */
# include "Objects.h"        /* IsPointerObject  */

# undef DEBUG

# define MODULE "AdaptF77"

       /***************************************
       *                                      *
       *  split_shape :     dim  = d          *
       *                                      *
       *                                      *
       *   ug1:og1:str1                       *
       *   ....                               *
       *   ugd:ogd:strd   -> move to s1       *
       *   ....                               *
       *   ugn:ogn:strn                       *
       *                                      *
       ***************************************/

void split_shape (s, s1, dim)
shape s, s1;
int dim;
{ int i, j;

  if ((dim < 1) || (dim > s->rank))

     { failure_protocol (MODULE, 
           "split_shape: Illegal shape - dim in split_shape", NoTree);
     }

  /* set up one-dimensional shape for reduction loop */

  s1->rank = 1;
  for (i = 0; i < 3; i ++)
    s1->bounds[0][i] = s->bounds[dim-1][i];
  s1->perm[0] = s->perm[dim-1];

  /* reduced shape back in s */

  for (j = 0; j < s->rank; j ++)
    if (j >= dim)
      for (i = 0; i < 3; i++)
        { s->bounds[j-1][i] = s->bounds[j][i];
          s->perm[j-1] = s->perm[j];
        }

  s->rank = s->rank - 1;

} /* split_shape */

static tEntries RecordScope;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyAdaptF77.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* AdaptF77_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module AdaptF77, routine %s failed\n",
  yyFunction);
 AdaptF77_Exit ();
}

static void FreeTemporaries0 ARGS ((void));
tTree F77Where ARGS ((tTree t));
tTree F77Merge ARGS ((tTree var, tTree params));
tTree F77ArrayItems ARGS ((tTree items));
tTree F77TypeItems ARGS ((tTree item_list));
static tTree ExpandDoVarList ARGS ((tTree var_list));
static tTree ExpandDoExpList ARGS ((tTree exp_list));
static tTree TranslateTypeItem ARGS ((tTree item));
static tTree MakeSelectedVars ARGS ((tTree item, tTree components));
static tTree ExpandVar ARGS ((tTree var));
static void ChangeToExpList ARGS ((tTree var_list));
static void ChangeToParamList ARGS ((tTree var_list));
tTree F77Assign ARGS ((tTree t));
tTree F77Reduction ARGS ((int line, tTree var, tTree exp));
static tTree MaskExp ARGS ((tTree mask));
static tTree MakeFullReduction ARGS ((int line, tTree var, tTree f, tTree pexp, tTree mask));
static tTree MakeDimReduction ARGS ((int line, int dim, tTree var, tTree f, tTree pexp, tTree mask));
tTree F77LocReduction ARGS ((int line, tTree var, tTree exp));
static void FindValVar ARGS ((tTree array, tTree mask, tTree * yyP2, tTree * yyP1));
static void InsertLocParams ARGS ((tTree var, tTree stmt, int n, tTree p));
static tTree MakePosParams ARGS ((tTree var, int n, tTree id, tTree slice));
static void SetIntentIn ARGS ((tTree param));
static tTree NthPos ARGS ((tTree var, int n));
tTree F77ManyAssign ARGS ((tTree t));
static tTree MakeAssignments ARGS ((tTree var, int n, tTree elements));
static tTree MakeAssignment ARGS ((tTree var, int n, tTree elem));
static void SetIndexValue ARGS ((tTree indexes, int n));
static void GetExpShape ARGS ((tTree exp, shape s));
tTree F77TypeAssign ARGS ((tTree t));
static tTree MakeTypeVarAssign ARGS ((tTree var1, tTree var2, tTree components));
static tTree MakeTypeExpAssign ARGS ((tTree var, tTree elems, tTree components));
static void GetRecordType ARGS ((tTree t, tTree * yyP3));

static void FreeTemporaries0
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 139 "AdaptF77.puma" */
 {
  tTree help;
  {
/* line 142 "AdaptF77.puma" */
 FreeTemporaries (&help, &help); 
  }
   return;
 }

;
}

tTree F77Where
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_WHERE) {
/* line 159 "AdaptF77.puma" */
 {
  struct_shape shp;
  tTree new;
  {
/* line 164 "AdaptF77.puma" */
 GetActualShape (t, &shp);

     if (shp.rank == 0)

        { error_protocol ("where statement: no shape found");
          new = NoTree;
        }

      else

        { 

          t->ACF_WHERE.WHERE_EXP   = SetActualShape (t->ACF_WHERE.WHERE_EXP, &shp);
          t->ACF_WHERE.TRUE_PART = SetActualShape (t->ACF_WHERE.TRUE_PART, &shp);
          t->ACF_WHERE.FALSE_PART = SetActualShape (t->ACF_WHERE.FALSE_PART, &shp);

          

          new = mACF_IF (t->ACF_WHERE.WHERE_EXP, t->ACF_WHERE.TRUE_PART, t->ACF_WHERE.FALSE_PART);
          SetACFNode (new, 0, t->ACF_WHERE.Line);

          
          new = MakeOuterLoops (t->ACF_WHERE.Line, &shp, new, GEN_DO_INDEPENDENT); 
        }
   
/* line 190 "AdaptF77.puma" */
   FreeTemporaries0 ();
  }
   return new;
 }

  }
/* line 194 "AdaptF77.puma" */
  {
/* line 196 "AdaptF77.puma" */
   failure_protocol (MODULE, "F77Where", t);
  }
   return NoTree;

}

tTree F77Merge
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree params)
# else
(var, params)
 register tTree var;
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 210 "AdaptF77.puma" */
 {
  struct_shape shp;
  tTree new;
  tTree hnew;
  {
/* line 216 "AdaptF77.puma" */
 GetActualShape (var, &shp);

     if (shp.rank > 0)

        { var   = SetActualShape (var, &shp);
          params->BTP_LIST.Elem = SetActualShape (params->BTP_LIST.Elem, &shp);
          params->BTP_LIST.Next->BTP_LIST.Elem = SetActualShape (params->BTP_LIST.Next->BTP_LIST.Elem, &shp);
          params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem  = SetActualShape (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, &shp);
        }

     

     hnew = mASSIGN_STMT (CopyTree (var), VarParamToExp (params->BTP_LIST.Next->BTP_LIST.Elem));
     hnew = mACF_LIST (mACF_BASIC (hnew), mACF_EMPTY ());
   
     

     new = mASSIGN_STMT (var, VarParamToExp (params->BTP_LIST.Elem));
     new = mACF_LIST (mACF_BASIC (new), mACF_EMPTY ());

     

     new = mACF_IF (VarParamToExp (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem), new, hnew);

     

     if (shp.rank > 0)
        new = MakeOuterLoops (0, &shp, new, GEN_DO_INDEPENDENT);

   
/* line 246 "AdaptF77.puma" */
   FreeTemporaries0 ();
  }
   return new;
 }

  }
  }
  }
  }
/* line 251 "AdaptF77.puma" */
  {
/* line 253 "AdaptF77.puma" */
   failure_protocol (MODULE, "F77Merge", params);
  }
   return NoTree;

}

tTree F77ArrayItems
# if defined __STDC__ | defined __cplusplus
(register tTree items)
# else
(items)
 register tTree items;
# endif
{
/* line 268 "AdaptF77.puma" */

struct_shape shp;
tTree new;

  if (items->Kind == kBTP_LIST) {
  if (items->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (items->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
  if (items->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E->Kind == kDO_EXP) {
/* line 273 "AdaptF77.puma" */
  {
/* line 277 "AdaptF77.puma" */
 items->BTP_LIST.Next = F77ArrayItems (items->BTP_LIST.Next); 
  }
   return items;

  }
/* line 291 "AdaptF77.puma" */
  {
/* line 293 "AdaptF77.puma" */
   if (! ((TreeRank (items->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E) > 0))) goto yyL3;
  {
/* line 297 "AdaptF77.puma" */
 GetExpShape (items->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E, &shp);
     new = SetActualShape (items->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E, &shp);
     new = MakeOuterImpliedLoops (&shp, new);
     items->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E = new;
     FreeTemporaries0 ();
     items->BTP_LIST.Next = F77ArrayItems (items->BTP_LIST.Next); 
   
  }
  }
   return items;
yyL3:;

  }
  if (items->BTP_LIST.Elem->VAR_PARAM.V->Kind == kDO_VAR) {
/* line 282 "AdaptF77.puma" */
  {
/* line 286 "AdaptF77.puma" */
 items->BTP_LIST.Next = F77ArrayItems (items->BTP_LIST.Next); 
  }
   return items;

  }
  if (items->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
/* line 308 "AdaptF77.puma" */
  {
/* line 312 "AdaptF77.puma" */
 items->BTP_LIST.Next = F77ArrayItems (items->BTP_LIST.Next); 
  }
   return items;

  }
/* line 317 "AdaptF77.puma" */
  {
/* line 319 "AdaptF77.puma" */
   if (! ((TreeRank (items->BTP_LIST.Elem->VAR_PARAM.V) > 0))) goto yyL5;
  {
/* line 323 "AdaptF77.puma" */
 GetExpShape (items->BTP_LIST.Elem->VAR_PARAM.V, &shp);

     new = SetActualShape (items->BTP_LIST.Elem->VAR_PARAM.V, &shp);
     new = MakeOuterImpliedLoopsV (&shp, new);
     items->BTP_LIST.Elem->VAR_PARAM.V = new;
     FreeTemporaries0 ();
     items->BTP_LIST.Next = F77ArrayItems (items->BTP_LIST.Next); 

   
  }
  }
   return items;
yyL5:;

  }
/* line 336 "AdaptF77.puma" */
  {
/* line 338 "AdaptF77.puma" */
 items->BTP_LIST.Next = F77ArrayItems (items->BTP_LIST.Next); 
  }
   return items;

  }
  if (items->Kind == kBTP_EMPTY) {
/* line 343 "AdaptF77.puma" */
   return items;

  }
/* line 348 "AdaptF77.puma" */
  {
/* line 350 "AdaptF77.puma" */
   failure_protocol (MODULE, "F77ArrayItems", items);
  }
   return items;

}

tTree F77TypeItems
# if defined __STDC__ | defined __cplusplus
(register tTree item_list)
# else
(item_list)
 register tTree item_list;
# endif
{
  if (item_list->Kind == kBTP_LIST) {
  if (item_list->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (item_list->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
/* line 365 "AdaptF77.puma" */
 {
  tTree var_list;
  {
/* line 367 "AdaptF77.puma" */
   if (! ((IsDerivedType (TreeType (item_list->BTP_LIST.Elem->VAR_PARAM.V))))) goto yyL1;
  {
/* line 371 "AdaptF77.puma" */
 var_list = TranslateTypeItem (item_list->BTP_LIST.Elem->VAR_PARAM.V); 
     ChangeToParamList (var_list);
   
  }
  }
   return CombineBTP (var_list, F77TypeItems (item_list->BTP_LIST.Next));
 }
yyL1:;

  }
  if (item_list->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
  if (item_list->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E->Kind == kDO_EXP) {
/* line 378 "AdaptF77.puma" */
  {
/* line 380 "AdaptF77.puma" */
 item_list->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E->DO_EXP.BODY = ExpandDoExpList (item_list->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E->DO_EXP.BODY);
     item_list->BTP_LIST.Next  = F77TypeItems (item_list->BTP_LIST.Next); 
   
  }
   return item_list;

  }
  }
  if (item_list->BTP_LIST.Elem->VAR_PARAM.V->Kind == kDO_VAR) {
/* line 387 "AdaptF77.puma" */
  {
/* line 389 "AdaptF77.puma" */
 item_list->BTP_LIST.Elem->VAR_PARAM.V->DO_VAR.BODY = ExpandDoVarList (item_list->BTP_LIST.Elem->VAR_PARAM.V->DO_VAR.BODY);
     item_list->BTP_LIST.Next  = F77TypeItems (item_list->BTP_LIST.Next); 
   
  }
   return item_list;

  }
  }
/* line 396 "AdaptF77.puma" */
  {
/* line 398 "AdaptF77.puma" */
 item_list->BTP_LIST.Next = F77TypeItems (item_list->BTP_LIST.Next); 
  }
   return item_list;

  }
  if (item_list->Kind == kBTP_EMPTY) {
/* line 403 "AdaptF77.puma" */
   return item_list;

  }
  if (item_list->Kind == kBTV_EMPTY) {
/* line 408 "AdaptF77.puma" */
   return item_list;

  }
/* line 413 "AdaptF77.puma" */
  {
/* line 415 "AdaptF77.puma" */
   failure_protocol (MODULE, "F77TypeItems", item_list);
  }
   return item_list;

}

static tTree ExpandDoVarList
# if defined __STDC__ | defined __cplusplus
(register tTree var_list)
# else
(var_list)
 register tTree var_list;
# endif
{
  if (var_list->Kind == kBTV_LIST) {
  if (var_list->BTV_LIST.Elem->Kind == kDO_VAR) {
/* line 432 "AdaptF77.puma" */
  {
/* line 434 "AdaptF77.puma" */
 var_list->BTV_LIST.Elem->DO_VAR.BODY = ExpandDoVarList (var_list->BTV_LIST.Elem->DO_VAR.BODY);
     var_list->BTV_LIST.Next  = ExpandDoVarList (var_list->BTV_LIST.Next);
   
  }
   return var_list;

  }
/* line 441 "AdaptF77.puma" */
 {
  tTree new_vars;
  {
/* line 443 "AdaptF77.puma" */
   if (! ((IsDerivedType (TreeType (var_list->BTV_LIST.Elem))))) goto yyL2;
  {
/* line 447 "AdaptF77.puma" */
 new_vars = TranslateTypeItem (var_list->BTV_LIST.Elem); 
  }
  }
   return CombineBTV (new_vars, ExpandDoVarList (var_list->BTV_LIST.Next));
 }
yyL2:;

/* line 452 "AdaptF77.puma" */
  {
/* line 454 "AdaptF77.puma" */
 var_list->BTV_LIST.Next = ExpandDoVarList (var_list->BTV_LIST.Next); 
  }
   return var_list;

  }
  if (var_list->Kind == kBTV_EMPTY) {
/* line 459 "AdaptF77.puma" */
   return var_list;

  }
/* line 464 "AdaptF77.puma" */
  {
/* line 466 "AdaptF77.puma" */
   failure_protocol (MODULE, "ExpandDoVarList", var_list);
  }
   return var_list;

}

static tTree ExpandDoExpList
# if defined __STDC__ | defined __cplusplus
(register tTree exp_list)
# else
(exp_list)
 register tTree exp_list;
# endif
{
  if (exp_list->Kind == kBTE_LIST) {
  if (exp_list->BTE_LIST.Elem->Kind == kDO_EXP) {
/* line 480 "AdaptF77.puma" */
  {
/* line 482 "AdaptF77.puma" */
 exp_list->BTE_LIST.Elem->DO_EXP.BODY = ExpandDoExpList (exp_list->BTE_LIST.Elem->DO_EXP.BODY);
     exp_list->BTE_LIST.Next  = ExpandDoExpList (exp_list->BTE_LIST.Next);
   
  }
   return exp_list;

  }
  if (exp_list->BTE_LIST.Elem->Kind == kVAR_EXP) {
/* line 489 "AdaptF77.puma" */
 {
  tTree var_list;
  {
/* line 491 "AdaptF77.puma" */
   if (! ((IsDerivedType (TreeType (exp_list->BTE_LIST.Elem->VAR_EXP.V))))) goto yyL2;
  {
/* line 495 "AdaptF77.puma" */
 var_list = TranslateTypeItem (exp_list->BTE_LIST.Elem->VAR_EXP.V); 
     ChangeToExpList (var_list);
   
  }
  }
   return CombineBTE (var_list, ExpandDoExpList (exp_list->BTE_LIST.Next));
 }
yyL2:;

  }
/* line 502 "AdaptF77.puma" */
  {
/* line 504 "AdaptF77.puma" */
 exp_list->BTE_LIST.Next = ExpandDoExpList (exp_list->BTE_LIST.Next); 
  }
   return exp_list;

  }
  if (exp_list->Kind == kBTE_EMPTY) {
/* line 509 "AdaptF77.puma" */
   return exp_list;

  }
/* line 514 "AdaptF77.puma" */
  {
/* line 516 "AdaptF77.puma" */
   failure_protocol (MODULE, "ExpandDoExpList", exp_list);
  }
   return exp_list;

}

static tTree TranslateTypeItem
# if defined __STDC__ | defined __cplusplus
(register tTree item)
# else
(item)
 register tTree item;
# endif
{
  if (item->Kind == kTYPE_EXP) {
/* line 530 "AdaptF77.puma" */
   return ExpListToVarParamList (item->TYPE_EXP.ELEMENTS);

  }
/* line 535 "AdaptF77.puma" */
 {
  tTree yyV1;
  {
/* line 537 "AdaptF77.puma" */
   GetRecordType (TreeType (item), & yyV1);
  }
   return MakeSelectedVars (item, yyV1);
 }

}

static tTree MakeSelectedVars
# if defined __STDC__ | defined __cplusplus
(register tTree item, register tTree components)
# else
(item, components)
 register tTree item;
 register tTree components;
# endif
{
  if (components->Kind == kRECORD_TYPE) {
/* line 552 "AdaptF77.puma" */
 {
  tTree params;
  {
/* line 556 "AdaptF77.puma" */
   params = MakeSelectedVars (item, components->RECORD_TYPE.COMPONENTS);
  }
   return params;
 }

  }
  if (components->Kind == kDECL_LIST) {
/* line 561 "AdaptF77.puma" */
   return CombineBTV (MakeSelectedVars (item, components->DECL_LIST.Elem), MakeSelectedVars (item, components->DECL_LIST.Next));

  }
  if (components->Kind == kDECL_EMPTY) {
/* line 567 "AdaptF77.puma" */
   return NoTree;

  }
  if (components->Kind == kVAR_DECL) {
/* line 572 "AdaptF77.puma" */
 {
  tTree selector;
  tDefinitions obj;
  tTree svar;
  {
/* line 578 "AdaptF77.puma" */
 selector = mREC_COMP (components->VAR_DECL.Ident);
     obj = GetDeclEntry (components->VAR_DECL.Ident, RecordScope);
     selector->REC_COMP.Object = obj;

     svar = mSELECTED_VAR (CopyTree (item), selector);

     if (IsPointerObject (obj))
        warning_protocol ("IO item is pointer");

   
  }
   return ExpandVar (MakeFullShape (svar));
 }

  }
/* line 592 "AdaptF77.puma" */
   return NoTree;

}

static tTree ExpandVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kDO_VAR) {
/* line 605 "AdaptF77.puma" */
  {
/* line 607 "AdaptF77.puma" */
 var->DO_VAR.BODY = ExpandDoVarList (var->DO_VAR.BODY); 
  }
   return var;

  }
/* line 612 "AdaptF77.puma" */
 {
  struct_shape shp;
  tTree new;
  {
/* line 614 "AdaptF77.puma" */
   if (! ((TreeRank (var) > 0))) goto yyL2;
  {
/* line 619 "AdaptF77.puma" */
 GetExpShape (var, &shp);

     new = SetActualShape (var, &shp);
     new = MakeOuterImpliedLoopsV (&shp, new);
     FreeTemporaries0 ();
   
  }
  }
   var = new;
   goto yyRecursion;
 }
yyL2:;

/* line 631 "AdaptF77.puma" */
 {
  tTree yyV1;
  {
/* line 633 "AdaptF77.puma" */
   if (! ((IsDerivedType (TreeType (var))))) goto yyL3;
  {
/* line 635 "AdaptF77.puma" */
   GetRecordType (TreeType (var), & yyV1);
  }
  }
   return MakeSelectedVars (var, yyV1);
 }
yyL3:;

/* line 640 "AdaptF77.puma" */
   return var;

}

static void ChangeToExpList
# if defined __STDC__ | defined __cplusplus
(register tTree var_list)
# else
(var_list)
 register tTree var_list;
# endif
{
/* line 656 "AdaptF77.puma" */
  {
/* line 658 "AdaptF77.puma" */
   if (! ((var_list == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (var_list->Kind == kBTV_LIST) {
/* line 661 "AdaptF77.puma" */
  {
/* line 663 "AdaptF77.puma" */
 var_list->BTV_LIST.Elem = mVAR_EXP (var_list->BTV_LIST.Elem); 
     var_list->Kind = kBTE_LIST;
     ChangeToExpList (var_list->BTV_LIST.Next);
   
  }
   return;

  }
  if (var_list->Kind == kBTV_EMPTY) {
/* line 669 "AdaptF77.puma" */
  {
/* line 671 "AdaptF77.puma" */
 var_list->Kind = kBTE_EMPTY; 
  }
   return;

  }
/* line 674 "AdaptF77.puma" */
  {
/* line 675 "AdaptF77.puma" */
   failure_protocol (MODULE, "ChangeToExpList", var_list);
  }
   return;

;
}

static void ChangeToParamList
# if defined __STDC__ | defined __cplusplus
(register tTree var_list)
# else
(var_list)
 register tTree var_list;
# endif
{
/* line 680 "AdaptF77.puma" */
  {
/* line 682 "AdaptF77.puma" */
   if (! ((var_list == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (var_list->Kind == kBTV_LIST) {
/* line 685 "AdaptF77.puma" */
  {
/* line 687 "AdaptF77.puma" */
 var_list->BTV_LIST.Elem = mVAR_PARAM (var_list->BTV_LIST.Elem); 
     var_list->Kind = kBTP_LIST;
     ChangeToParamList (var_list->BTV_LIST.Next);
   
  }
   return;

  }
  if (var_list->Kind == kBTV_EMPTY) {
/* line 693 "AdaptF77.puma" */
  {
/* line 695 "AdaptF77.puma" */
 var_list->Kind = kBTP_EMPTY; 
  }
   return;

  }
/* line 698 "AdaptF77.puma" */
  {
/* line 699 "AdaptF77.puma" */
   failure_protocol (MODULE, "ChangeToParamList", var_list);
  }
   return;

;
}

tTree F77Assign
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 710 "AdaptF77.puma" */
 {
  struct_shape shp;
  tTree new;
  {
/* line 715 "AdaptF77.puma" */
 GetActualShape (t, &shp);

# ifdef DEBUG
     printf ("Call of F77 Assign\n"); FileUnparse (stdout, t);
     printf ("Here is the Actual shape of the lhs variable\n");
     PrintShape (&shp);
     printf ("Will actualize shape in var and exp\n");
# endif

     if (shp.rank > 0)

       { 

         t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = SetActualShape (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, &shp);
         t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP = SetActualShape (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, &shp); 
         new = MakeOuterLoops (t->ACF_BASIC.Line, &shp, t, GEN_DO_INDEPENDENT); 
       }

     else

       new = t;

   
/* line 739 "AdaptF77.puma" */
   FreeTemporaries0 ();
  }
   return new;
 }

  }
  }
/* line 743 "AdaptF77.puma" */
  {
/* line 745 "AdaptF77.puma" */
   failure_protocol (MODULE, "F77Assign", t);
  }
   return NoTree;

}

tTree F77Reduction
# if defined __STDC__ | defined __cplusplus
(register int line, register tTree var, register tTree exp)
# else
(line, var, exp)
 register int line;
 register tTree var;
 register tTree exp;
# endif
{
  if (exp->Kind == kFUNC_CALL_EXP) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 767 "AdaptF77.puma" */
   return MakeFullReduction (line, var, exp->FUNC_CALL_EXP.FUNC_ID, exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, MaskExp (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem));

  }
  }
  }
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 779 "AdaptF77.puma" */
 {
  int idim;
  rbool found;
  {
/* line 785 "AdaptF77.puma" */
   GetIntConstValue (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, & found, & idim);
/* line 786 "AdaptF77.puma" */
   if (! ((found))) goto yyL2;
  }
   return MakeDimReduction (line, idim, var, exp->FUNC_CALL_EXP.FUNC_ID, exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, MaskExp (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem));
 }
yyL2:;

/* line 791 "AdaptF77.puma" */
  {
/* line 794 "AdaptF77.puma" */
   error_protocol ("dim parameter of reduction unknown at compile time");
  }
   return NoTree;

  }
  }
  }
  }
  }
/* line 798 "AdaptF77.puma" */
  {
/* line 800 "AdaptF77.puma" */
   failure_protocol (MODULE, "F77Reduction", exp);
  }
   return NoTree;

}

static tTree MaskExp
# if defined __STDC__ | defined __cplusplus
(register tTree mask)
# else
(mask)
 register tTree mask;
# endif
{
/* line 812 "AdaptF77.puma" */
  {
/* line 813 "AdaptF77.puma" */
   if (! ((mask == NoTree))) goto yyL1;
  }
   return mask;
yyL1:;

  if (mask->Kind == kVAR_PARAM) {
  if (mask->VAR_PARAM.V->Kind == kADDR) {
/* line 817 "AdaptF77.puma" */
   return mask->VAR_PARAM.V->ADDR.E;

  }
/* line 821 "AdaptF77.puma" */
   return mVAR_EXP (mask->VAR_PARAM.V);

  }
  if (mask->Kind == kNO_PARAM) {
/* line 825 "AdaptF77.puma" */
   return NoTree;

  }
/* line 829 "AdaptF77.puma" */
  {
/* line 831 "AdaptF77.puma" */
   failure_protocol (MODULE, "MaskExp", mask);
  }
   return mask;

}

static tTree MakeFullReduction
# if defined __STDC__ | defined __cplusplus
(register int line, register tTree var, register tTree f, register tTree pexp, register tTree mask)
# else
(line, var, f, pexp, mask)
 register int line;
 register tTree var;
 register tTree f;
 register tTree pexp;
 register tTree mask;
# endif
{
  if (pexp->Kind == kVAR_PARAM) {
/* line 857 "AdaptF77.puma" */
 {
  tTree stmt;
  tTree init;
  struct_shape shp;
  tTree params;
  {
/* line 864 "AdaptF77.puma" */
 GetActualShape (pexp->VAR_PARAM.V, &shp);
     pexp->VAR_PARAM.V = SetActualShape (pexp->VAR_PARAM.V, &shp);
     params = mBTP_EMPTY();
     params = mBTP_LIST (pexp, params);
     params = mBTP_LIST (mVAR_PARAM (var), params);
     stmt   = mREDUCE_STMT (kPRIVATE_REDUCTION, f, params);
     stmt   = mACF_BASIC (stmt);
     LineACFNode (stmt, line);
     if (mask != NoTree)
        { mask = SetActualShape (mask, &shp);
          stmt = mACF_LIST (stmt, mACF_EMPTY ());
          stmt = mACF_IF (mask, stmt, mACF_EMPTY());
        }
     stmt   = MakeOuterLoops (line, &shp, stmt, GEN_DO_INDEPENDENT); 
     stmt   = mACF_LIST (stmt, mACF_EMPTY());
     stmt   = mACF_REDUCTION (kPRIVATE_REDUCTION,
                              mBTV_LIST (CopyTree (var), mBTV_EMPTY()), 
                              CopyTree (f), stmt);
     LineACFNode (stmt, line);
     stmt   = mACF_LIST (stmt, NoTree);
     init   = InitReductionStmt (CopyTree(var), TreeType(var), f);
     LineACFNode (init, line);
     stmt   = mACF_LIST (init, stmt);
   
/* line 889 "AdaptF77.puma" */
   FreeTemporaries0 ();
  }
   return stmt;
 }

  }
 yyAbort ("MakeFullReduction");
 { tTree yyDummy; return yyDummy; }
}

static tTree MakeDimReduction
# if defined __STDC__ | defined __cplusplus
(register int line, register int dim, register tTree var, register tTree f, register tTree pexp, register tTree mask)
# else
(line, dim, var, f, pexp, mask)
 register int line;
 register int dim;
 register tTree var;
 register tTree f;
 register tTree pexp;
 register tTree mask;
# endif
{
  if (pexp->Kind == kVAR_PARAM) {
/* line 917 "AdaptF77.puma" */
 {
  tTree stmt;
  tTree init;
  struct_shape shp;
  struct_shape shp_red;
  tTree params;
  tTree var1;
  tTree red_var;
  {
/* line 927 "AdaptF77.puma" */
  red_var = CopyTree (var);

      GetActualShape (pexp->VAR_PARAM.V, &shp);
      pexp->VAR_PARAM.V = SetActualShape (pexp->VAR_PARAM.V, &shp);

      if (mask != NoTree)
         mask = SetActualShape (mask, &shp);

      split_shape (&shp, &shp_red, dim);  
      var1 = SetActualShape (var, &shp);

      params = mBTP_EMPTY();
      params = mBTP_LIST (pexp, params);
      params = mBTP_LIST (mVAR_PARAM (var1), params);
      stmt   = mREDUCE_STMT (kPRIVATE_REDUCTION, f, params);
      stmt   = mACF_BASIC (stmt);
      LineACFNode (stmt, line);

      if (mask != NoTree)

         { stmt = MakeStmtList (stmt);
           stmt = mACF_IF (mask, stmt, mACF_EMPTY());
         }

      stmt   = MakeOuterLoops (line, &shp_red, stmt, GEN_DO_INDEPENDENT); 

      stmt   = MakeStmtList (stmt);   

      stmt   = MakeOuterLoops (line, &shp, stmt, GEN_DO_INDEPENDENT); 

      stmt   = MakeStmtList (stmt);  

      stmt   = mACF_REDUCTION (kPRIVATE_REDUCTION,
                               mBTV_LIST (red_var, mBTV_EMPTY()), 
                               CopyTree (f), stmt);

      

      init   = InitReductionStmt (CopyTree(var1), TreeType(var1), f);
      LineACFNode (init, line);

      init   = MakeOuterLoops (line, &shp, init, GEN_DO_INDEPENDENT);

      

      stmt   = CombineACF (init, mACF_LIST (stmt, NoTree));

    
/* line 976 "AdaptF77.puma" */
   FreeTemporaries0 ();
  }
   return stmt;
 }

  }
 yyAbort ("MakeDimReduction");
 { tTree yyDummy; return yyDummy; }
}

tTree F77LocReduction
# if defined __STDC__ | defined __cplusplus
(register int line, register tTree var, register tTree exp)
# else
(line, var, exp)
 register int line;
 register tTree var;
 register tTree exp;
# endif
{
/* line 989 "AdaptF77.puma" */
  {
/* line 991 "AdaptF77.puma" */
   if (! ((TreeWriteDistribution (var) != 0))) goto yyL1;
  {
/* line 992 "AdaptF77.puma" */
   error_protocol ("pos array must be replicated for minloc/maxloc");
  }
  }
   return NoTree;
yyL1:;

  if (exp->Kind == kFUNC_CALL_EXP) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 1002 "AdaptF77.puma" */
 {
  int rank;
  tTree minval_var;
  tTree stmt;
  {
/* line 1011 "AdaptF77.puma" */
   rank = TreeRank (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem);
/* line 1015 "AdaptF77.puma" */
   minval_var = MakeScalarTemporary (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V);
/* line 1019 "AdaptF77.puma" */
 if (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("MINLOC")) exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = IsIdent ("MINVAL");
     if (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("MAXLOC")) exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident = IsIdent ("MAXVAL");
   
/* line 1025 "AdaptF77.puma" */
 stmt = MakeFullReduction (line, minval_var, exp->FUNC_CALL_EXP.FUNC_ID, exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, MaskExp (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem)); 
     InsertLocParams (var, stmt, rank, mBTP_EMPTY());
   
/* line 1028 "AdaptF77.puma" */
   FreeTemporaries0 ();
  }
   return stmt;
 }

  }
  }
  }
  }
  }
  }
/* line 1032 "AdaptF77.puma" */
  {
/* line 1033 "AdaptF77.puma" */
   error_protocol ("MINLOC / MAXLOC : do not support DIM argument");
  }
   return mACF_DUMMY ();

  }
 yyAbort ("F77LocReduction");
 { tTree yyDummy; return yyDummy; }
}

static void FindValVar
# if defined __STDC__ | defined __cplusplus
(register tTree array, register tTree mask, register tTree * yyP2, register tTree * yyP1)
# else
(array, mask, yyP2, yyP1)
 register tTree array;
 register tTree mask;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
/* line 1039 "AdaptF77.puma" */
 {
  tTree new_var;
  tTree maj_var;
  int code;
  {
/* line 1045 "AdaptF77.puma" */
   GetMajorityVar (array, & code, & maj_var);
/* line 1047 "AdaptF77.puma" */
 new_var = NoTree;
      if (code == -1)
        error_protocol ("implicit movement for array in minloc/maxloc");
      else if (code == 0)  
        error_protocol ("problem: cannot create var for value");
      else 
        { 

          new_var = GetScalarTemporary (TreeType (maj_var));
        }
    
  }
   * yyP2 = new_var;
   * yyP1 = maj_var;
   return;
 }

;
}

static void InsertLocParams
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stmt, register int n, register tTree p)
# else
(var, stmt, n, p)
 register tTree var;
 register tTree stmt;
 register int n;
 register tTree p;
# endif
{
 yyRecursion:
/* line 1078 "AdaptF77.puma" */
  {
/* line 1079 "AdaptF77.puma" */
   if (! ((stmt == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (stmt->Kind == kACF_REDUCTION) {
  if (stmt->ACF_REDUCTION.REDUCTION_VAR->Kind == kBTV_LIST) {
  if (stmt->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 1082 "AdaptF77.puma" */
 {
  tTree red_vars;
  int i;
  {
/* line 1088 "AdaptF77.puma" */
 red_vars = stmt->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next;
     for (i=n; i>=1; i--)
         red_vars = mBTV_LIST (NthPos (var, i), red_vars);
     stmt->ACF_REDUCTION.REDUCTION_VAR->BTV_LIST.Next = red_vars;
   
/* line 1094 "AdaptF77.puma" */
   stmt = stmt->ACF_REDUCTION.REDUCTION_BODY;
   goto yyRecursion;
  }
 }

  }
  }
  }
  if (stmt->Kind == kACF_LIST) {
/* line 1097 "AdaptF77.puma" */
  {
/* line 1098 "AdaptF77.puma" */
   if (! ((stmt->ACF_LIST.Next == NoTree))) goto yyL3;
  {
/* line 1099 "AdaptF77.puma" */
   stmt = stmt->ACF_LIST.Elem;
   goto yyRecursion;
  }
  }
yyL3:;

/* line 1102 "AdaptF77.puma" */
  {
/* line 1103 "AdaptF77.puma" */
   InsertLocParams (var, stmt->ACF_LIST.Elem, n, p);
/* line 1104 "AdaptF77.puma" */
   stmt = stmt->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  if (stmt->Kind == kACF_EMPTY) {
/* line 1107 "AdaptF77.puma" */
   return;

  }
  if (stmt->Kind == kACF_DO) {
/* line 1110 "AdaptF77.puma" */
 {
  tTree params;
  {
/* line 1112 "AdaptF77.puma" */
   if (! ((IsParallelLoop (stmt)))) goto yyL6;
  {
/* line 1116 "AdaptF77.puma" */
 params = MakePosParams (var, n, stmt->ACF_DO.DO_ID, stmt->ACF_DO.DO_RANGE);
     params = ConcatParams (params, p);
   
/* line 1119 "AdaptF77.puma" */
   stmt = stmt->ACF_DO.DO_BODY;
   n = n - 1;
   p = params;
   goto yyRecursion;
  }
  }
 }
yyL6:;

  }
  if (stmt->Kind == kACF_IF) {
/* line 1122 "AdaptF77.puma" */
  {
/* line 1123 "AdaptF77.puma" */
   InsertLocParams (var, stmt->ACF_IF.THEN_PART, n, p);
/* line 1124 "AdaptF77.puma" */
   stmt = stmt->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  }
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 1127 "AdaptF77.puma" */
   return;

  }
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 1130 "AdaptF77.puma" */
  {
/* line 1132 "AdaptF77.puma" */
 stmt->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS = ConcatParams (stmt->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS, p); 
  }
   return;

  }
  }
/* line 1135 "AdaptF77.puma" */
  {
/* line 1137 "AdaptF77.puma" */
   failure_protocol ("AdaptF77", "InsertLocParams", stmt);
  }
   return;

;
}

static tTree MakePosParams
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int n, register tTree id, register tTree slice)
# else
(var, n, id, slice)
 register tTree var;
 register int n;
 register tTree id;
 register tTree slice;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
  if (slice->Kind == kSLICE_EXP) {
/* line 1142 "AdaptF77.puma" */
 {
  tTree param1;
  tTree param2;
  {
/* line 1147 "AdaptF77.puma" */
 param1 = mVAR_PARAM (NthPos (var, n));

     param2 = mVAR_EXP (CopyTree (id));
     param2 = MakeRangeExp (slice->SLICE_EXP.FIRST, param2, slice->SLICE_EXP.INC);   
     param2 = ExpToVarParam (param2);

     SetIntentIn (param2);

   
  }
   return mBTP_LIST (param1, mBTP_LIST (param2, NoTree));
 }

  }
  }
/* line 1160 "AdaptF77.puma" */
  {
/* line 1161 "AdaptF77.puma" */
   failure_protocol ("AdaptF77", "MakePosParams", var);
  }
   return NoTree;

}

static void SetIntentIn
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
/* line 1167 "AdaptF77.puma" */
  {
/* line 1169 "AdaptF77.puma" */
 param->VAR_PARAM.intent = IntentIn; 
  }
   return;

  }
/* line 1172 "AdaptF77.puma" */
  {
/* line 1174 "AdaptF77.puma" */
   failure_protocol (MODULE, "SetIntentIn", param);
  }
   return;

;
}

static tTree NthPos
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int n)
# else
(var, n)
 register tTree var;
 register int n;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 1191 "AdaptF77.puma" */
   return mINDEXED_VAR (var->INDEXED_VAR.IND_VAR, NthPos (var->INDEXED_VAR.IND_EXPS, n));

  }
  if (var->Kind == kBTE_LIST) {
/* line 1195 "AdaptF77.puma" */
   return mBTE_LIST (NthPos (var->BTE_LIST.Elem, n), NthPos (var->BTE_LIST.Next, n));

  }
  if (var->Kind == kBTE_EMPTY) {
/* line 1199 "AdaptF77.puma" */
   return var;

  }
  if (var->Kind == kSLICE_EXP) {
/* line 1203 "AdaptF77.puma" */
 {
  rbool found;
  int val;
  {
/* line 1208 "AdaptF77.puma" */
   SliceIncrement (var, & found, & val);
/* line 1209 "AdaptF77.puma" */
   if (! ((found))) goto yyL4;
  }
   return AddConstant (CopyTree (var->SLICE_EXP.FIRST), (n - 1) * val);
 }
yyL4:;

/* line 1213 "AdaptF77.puma" */
 {
  tTree exp;
  {
/* line 1216 "AdaptF77.puma" */
 exp = MultConstant (CopyTree(var->SLICE_EXP.INC), n-1);
     exp = mOP_EXP (mOP_PLUS(), CopyTree(var->SLICE_EXP.FIRST), exp);
   
  }
   return exp;
 }

  }
/* line 1222 "AdaptF77.puma" */
   return CopyTree (var);

}

tTree F77ManyAssign
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kARRAY_EXP) {
/* line 1238 "AdaptF77.puma" */
   return MakeAssignments (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, 0, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->ARRAY_EXP.ELEMENTS);

  }
  }
  }
/* line 1243 "AdaptF77.puma" */
  {
/* line 1244 "AdaptF77.puma" */
   failure_protocol (MODULE, "F77ManyAssign", t);
  }
   return NoTree;

}

static tTree MakeAssignments
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int n, register tTree elements)
# else
(var, n, elements)
 register tTree var;
 register int n;
 register tTree elements;
# endif
{
  if (elements->Kind == kBTE_LIST) {
/* line 1250 "AdaptF77.puma" */
   return mACF_LIST (MakeAssignment (CopyTree (var), n, elements->BTE_LIST.Elem), MakeAssignments (var, n + 1, elements->BTE_LIST.Next));

  }
  if (elements->Kind == kBTE_EMPTY) {
/* line 1255 "AdaptF77.puma" */
   return NoTree;

  }
/* line 1259 "AdaptF77.puma" */
  {
/* line 1260 "AdaptF77.puma" */
   failure_protocol (MODULE, "MakeAssignments", var);
  }
   return NoTree;

}

static tTree MakeAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int n, register tTree elem)
# else
(var, n, elem)
 register tTree var;
 register int n;
 register tTree elem;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 1272 "AdaptF77.puma" */
  {
/* line 1274 "AdaptF77.puma" */
   SetIndexValue (var->INDEXED_VAR.IND_EXPS, n);
  }
   return mACF_BASIC (mASSIGN_STMT (var, elem));

  }
/* line 1278 "AdaptF77.puma" */
  {
/* line 1280 "AdaptF77.puma" */
   failure_protocol (MODULE, "MakeAssignment", var);
  }
   return NoTree;

}

static void SetIndexValue
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, register int n)
# else
(indexes, n)
 register tTree indexes;
 register int n;
# endif
{
 yyRecursion:
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 1286 "AdaptF77.puma" */
 {
  rbool found;
  int val;
  {
/* line 1291 "AdaptF77.puma" */
   SliceIncrement (indexes->BTE_LIST.Elem, & found, & val);
/* line 1292 "AdaptF77.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 1294 "AdaptF77.puma" */
 indexes->BTE_LIST.Elem = AddConstant (indexes->BTE_LIST.Elem->SLICE_EXP.FIRST, val*n); 
  }
  }
   return;
 }
yyL1:;

/* line 1297 "AdaptF77.puma" */
  {
/* line 1299 "AdaptF77.puma" */
 indexes->BTE_LIST.Elem = mOP_EXP (mOP_PLUS(), indexes->BTE_LIST.Elem->SLICE_EXP.FIRST, MultConstant (indexes->BTE_LIST.Elem->SLICE_EXP.INC, n)); 
  }
   return;

  }
/* line 1302 "AdaptF77.puma" */
  {
/* line 1303 "AdaptF77.puma" */
   indexes = indexes->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
  if (indexes->Kind == kBTE_EMPTY) {
/* line 1306 "AdaptF77.puma" */
  {
/* line 1307 "AdaptF77.puma" */
   error_protocol ("could not make single assignments");
  }
   return;

  }
;
}

static void GetExpShape
# if defined __STDC__ | defined __cplusplus
(register tTree exp, shape s)
# else
(exp, s)
 register tTree exp;
 shape s;
# endif
{
/* line 1320 "AdaptF77.puma" */
  {
/* line 1322 "AdaptF77.puma" */
   if (! ((! DoLoopExpression (exp)))) goto yyL1;
  {
/* line 1324 "AdaptF77.puma" */
   failure_protocol (MODULE, "GetExpShape (illegal tree)", exp);
  }
  }
   return;
yyL1:;

/* line 1327 "AdaptF77.puma" */
  {
/* line 1329 "AdaptF77.puma" */
   GetActualShape (exp, s);
  }
   return;

;
}

tTree F77TypeAssign
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
/* line 1344 "AdaptF77.puma" */
 {
  tTree yyV1;
  {
/* line 1346 "AdaptF77.puma" */
   GetRecordType (TreeType (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR), & yyV1);
  }
   return MakeTypeVarAssign (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V, yyV1);
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kTYPE_EXP) {
/* line 1351 "AdaptF77.puma" */
 {
  tTree yyV1;
  {
/* line 1353 "AdaptF77.puma" */
   GetRecordType (TreeType (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR), & yyV1);
  }
   return MakeTypeExpAssign (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->TYPE_EXP.ELEMENTS, yyV1);
 }

  }
  }
  }
/* line 1358 "AdaptF77.puma" */
  {
/* line 1359 "AdaptF77.puma" */
   failure_protocol (MODULE, "F77TypeAssign", t);
  }
   return NoTree;

}

static tTree MakeTypeVarAssign
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register tTree var2, register tTree components)
# else
(var1, var2, components)
 register tTree var1;
 register tTree var2;
 register tTree components;
# endif
{
  if (components->Kind == kRECORD_TYPE) {
/* line 1371 "AdaptF77.puma" */
 {
  tTree stmts;
  {
/* line 1375 "AdaptF77.puma" */
   stmts = MakeTypeVarAssign (var1, var2, components->RECORD_TYPE.COMPONENTS);
  }
   return stmts;
 }

  }
  if (components->Kind == kDECL_LIST) {
/* line 1380 "AdaptF77.puma" */
   return CombineACF (MakeTypeVarAssign (var1, var2, components->DECL_LIST.Elem), MakeTypeVarAssign (var1, var2, components->DECL_LIST.Next));

  }
  if (components->Kind == kDECL_EMPTY) {
/* line 1386 "AdaptF77.puma" */
   return NoTree;

  }
  if (components->Kind == kVAR_DECL) {
/* line 1391 "AdaptF77.puma" */
 {
  tTree selector;
  tDefinitions obj;
  tTree svar1;
  tTree svar2;
  tTree stmt;
  {
/* line 1399 "AdaptF77.puma" */
 selector = mREC_COMP (components->VAR_DECL.Ident);
     obj = GetDeclEntry (components->VAR_DECL.Ident, RecordScope);
     selector->REC_COMP.Object = obj;

     svar1 = mSELECTED_VAR (CopyTree (var1), selector);
     svar2 = mSELECTED_VAR (CopyTree (var2), selector);
     svar2 = MakeFullShape (svar2);

     if (IsPointerObject (obj))
        stmt = mPTR_ASSIGN_STMT (svar1, mVAR_EXP (svar2));
      else
        stmt = mASSIGN_STMT (MakeFullShape (svar1), mVAR_EXP (svar2));
   
  }
   return mACF_BASIC (stmt);
 }

  }
/* line 1416 "AdaptF77.puma" */
   return NoTree;

}

static tTree MakeTypeExpAssign
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree elems, register tTree components)
# else
(var, elems, components)
 register tTree var;
 register tTree elems;
 register tTree components;
# endif
{
 yyRecursion:
  if (components->Kind == kRECORD_TYPE) {
/* line 1429 "AdaptF77.puma" */
 {
  tTree stmts;
  {
/* line 1433 "AdaptF77.puma" */
   stmts = MakeTypeExpAssign (var, elems, components->RECORD_TYPE.COMPONENTS);
  }
   return stmts;
 }

  }
  if (elems->Kind == kBTE_LIST) {
  if (components->Kind == kDECL_LIST) {
  if (components->DECL_LIST.Elem->Kind == kVAR_DECL) {
/* line 1438 "AdaptF77.puma" */
   return CombineACF (MakeTypeExpAssign (var, elems->BTE_LIST.Elem, components->DECL_LIST.Elem), MakeTypeExpAssign (var, elems->BTE_LIST.Next, components->DECL_LIST.Next));

  }
/* line 1447 "AdaptF77.puma" */
   components = components->DECL_LIST.Next;
   goto yyRecursion;

  }
  }
  if (elems->Kind == kBTE_EMPTY) {
/* line 1452 "AdaptF77.puma" */
   return NoTree;

  }
  if (Tree_IsType (elems, kBT_EXP)) {
  if (components->Kind == kVAR_DECL) {
/* line 1457 "AdaptF77.puma" */
 {
  tTree selector;
  tDefinitions obj;
  tTree svar;
  tTree stmt;
  {
/* line 1464 "AdaptF77.puma" */
 selector = mREC_COMP (components->VAR_DECL.Ident);
     obj = GetDeclEntry (components->VAR_DECL.Ident, RecordScope);
     selector->REC_COMP.Object = obj;

     svar  = mSELECTED_VAR (CopyTree (var), selector);

     if (IsPointerObject (obj))
        stmt = mPTR_ASSIGN_STMT (svar, elems) ;
      else
        stmt = mASSIGN_STMT (MakeFullShape (svar), elems);
   
  }
   return mACF_BASIC (stmt);
 }

  }
  }
/* line 1482 "AdaptF77.puma" */
  {
/* line 1484 "AdaptF77.puma" */
   failure2_protocol (MODULE, "MakeTypeExpAssign", elems, components);
  }
   return NoTree;

}

static void GetRecordType
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP3)
# else
(t, yyP3)
 register tTree t;
 register tTree * yyP3;
# endif
{
  if (t->Kind == kTYPE_ID) {
/* line 1496 "AdaptF77.puma" */
 {
  tTree yyV1;
  {
/* line 1498 "AdaptF77.puma" */
   GetRecordType (t->TYPE_ID.ID, & yyV1);
  }
   * yyP3 = yyV1;
   return;
 }

  }
  if (t->Kind == kTYPE_OBJ) {
  if (t->TYPE_OBJ.Object->Kind == kTypeObject) {
  if (t->TYPE_OBJ.Object->TypeObject.decl->Kind == kTYPE_DECL) {
/* line 1501 "AdaptF77.puma" */
  {
/* line 1504 "AdaptF77.puma" */
   RecordScope = t->TYPE_OBJ.Object->TypeObject.Components;
  }
   * yyP3 = t->TYPE_OBJ.Object->TypeObject.decl->TYPE_DECL.VAL;
   return;

  }
  }
  }
/* line 1507 "AdaptF77.puma" */
  {
/* line 1509 "AdaptF77.puma" */
   failure_protocol (MODULE, "GetRecordType", t);
  }
   * yyP3 = NoTree;
   return;

;
}

void BeginAdaptF77 ARGS ((void))
{
}

void CloseAdaptF77 ARGS ((void))
{
}
