# include "AdaptAnalysis.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 62 "AdaptAnalysis.puma" */


# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "ShowDefs.h"

# include "TreeOps.h"
# include "Objects.h"
# include "Types.h"
# include "Rank.h"
# include "Intrinsics.h"

# include "DefTable.h"
# include "Distributions.h"

# include "ArrayData.h"        /* SetActualOverlap                  */

# include "Common.h"           /* CheckCommonDistributions         */
# include "Expressions.h"      /* GetIntConstValue                 */

# include "Nesting.h"          /* always needed with units         */
# include "Traverse.h"         /* FullTraverse                     */

static int match_error;      /* global error flag */
static int overlap_error;    /* global error flag */

# define MODULE "AdaptAnalysis"

/*********************************************************************
*                                                                    * 
*    A s s e r t   F o r t r a n 9 0                                 * 
*                                                                    * 
*    - prints error message if target language is not Fortran 90     * 
*      or Fortran 95                                                 * 
*                                                                    * 
*********************************************************************/

static void AssertFortran90 (kind)
char *kind;

{ char msg[MAX_LINE_LENGTH];

  if (target_language == FORTRAN_90) return;
  if (target_language == FORTRAN_95) return;
 
  sprintf (msg, "%s unsupported if not Fortran 90 (use flag -F90)", kind);

  if (semantic_check == 0)
     serious_warning_protocol (msg);
    else
     error_protocol (msg);

} /* AssertFortran90 */

/*********************************************************************
*                                                                    * 
*    U n s u p p o r t e d                                           * 
*                                                                    * 
*    - prints error message if feature is not supported by ADAPTOR   * 
*                                                                    * 
*********************************************************************/

static void Unsupported (kind)
char *kind;

{ char msg[MAX_LINE_LENGTH];

  if (test_flag) return;

  sprintf (msg, "%s might cause problems with ADAPTOR", kind);
  serious_warning_protocol (msg);

} /* Unsupported */

/*********************************************************************
*                                                                    * 
*  void AssertApprovedExtension (char kind[])                        * 
*                                                                    * 
*********************************************************************/

static void AssertApprovedExtension (kind)
char *kind;

{ char msg[MAX_LINE_LENGTH];

  if (source_language == HPF_ADP)  return;
  if (source_language == HPF_FULL) return;

  sprintf (msg, "%s is approved extension (use flag -HPF or -HPF_ADP)", 
           kind);

  if (semantic_check == 0)
     serious_warning_protocol (msg);
    else
     error_protocol (msg);

} /* AssertApprovedExtension */

/*********************************************************************
*                                                                    * 
*  void AssertAdaptorExtension (char kind[])                        * 
*                                                                    * 
*********************************************************************/

static void AssertAdaptorExtension (kind)
char *kind;

{ char msg[MAX_LINE_LENGTH];

  if (source_language == HPF_ADP)  return;

  sprintf (msg, "%s is Adaptor extension (use flag -HPF_ADP)", 
           kind);

  if (semantic_check == 0)
     serious_warning_protocol (msg);
    else
     error_protocol (msg);

} /* AssertAdaptorExtension */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyAdaptAnalysis.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* AdaptAnalysis_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module AdaptAnalysis, routine %s failed\n",
  yyFunction);
 AdaptAnalysis_Exit ();
}

void AdaptAnalysis ARGS ((tTree t));
static void CheckRecursion ARGS ((tTree t));
static void CheckUnsupported ARGS ((tTree t));
static void CheckInternals ARGS ((tTree internals));
static void CheckReplicatedVars ARGS ((tTree t, tTree decl));
static void CheckNameListVars ARGS ((tTree t, tTree nl));
static void AdaptAnaDistributions ARGS ((tDefinitions t));
static void CheckObjMapping ARGS ((tDefinitions Obj));
static void CheckObjKind ARGS ((tDefinitions obj));
static rbool IsMappedObj ARGS ((tDefinitions obj));
static void VerifySpecMapping ARGS ((tDefinitions d, tDefinitions Obj));
static void VerifyRangeMapping ARGS ((tDefinitions d, tDefinitions Obj));
static void CheckAlignSourceList ARGS ((tDefinitions dl));
static void ValidateActual ARGS ((tDefinitions actual_obj, tDefinitions formal_obj));
static void AnaIntrinsicFunction ARGS ((tIdent name, tTree params));
static void AnaReductionParameters ARGS ((tTree params));
static void AdaptAnalReduceParams ARGS ((tTree t));
static rbool DistributedParameters ARGS ((tTree plist));
static rbool ReplicatedParameters ARGS ((tTree plist));
static void CheckCommons ARGS ((tDefinitions t));
static void AnaPureCheck ARGS ((tTree t));
static void PureCheck ARGS ((tTree t));
static void AdaptAnaOverlaps ARGS ((tDefinitions t));
static tTree GetCommonDeclarations ARGS ((tDefinitions obj));
static void CheckDistributeSpec ARGS ((tTree spec));
static void CheckProcessorsSpec ARGS ((tTree p));

void AdaptAnalysis
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 196 "AdaptAnalysis.puma" */
  {
/* line 198 "AdaptAnalysis.puma" */
   AdaptAnalysis (t->COMP_UNIT.COMP_ELEMENTS);
/* line 199 "AdaptAnalysis.puma" */
   CheckCommons (GetCommonEntries ());
  }
   return;

  case kUNIT_EMPTY:
/* line 202 "AdaptAnalysis.puma" */
   return;

  case kUNIT_LIST:
/* line 205 "AdaptAnalysis.puma" */
  {
/* line 206 "AdaptAnalysis.puma" */
   AdaptAnalysis (t->UNIT_LIST.Elem);
/* line 207 "AdaptAnalysis.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kPROGRAM_DECL:
/* line 219 "AdaptAnalysis.puma" */
  {
/* line 221 "AdaptAnalysis.puma" */
   NestOpenUnit (t);
/* line 222 "AdaptAnalysis.puma" */
   AdaptAnalysis (t->PROGRAM_DECL.PROGRAM_BODY);
/* line 223 "AdaptAnalysis.puma" */
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
/* line 226 "AdaptAnalysis.puma" */
  {
/* line 228 "AdaptAnalysis.puma" */
   CheckRecursion (t);
/* line 229 "AdaptAnalysis.puma" */
   NestOpenUnit (t);
/* line 230 "AdaptAnalysis.puma" */
   AdaptAnalysis (t->PROC_DECL.PROC_BODY);
/* line 231 "AdaptAnalysis.puma" */
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
/* line 234 "AdaptAnalysis.puma" */
  {
/* line 236 "AdaptAnalysis.puma" */
   CheckRecursion (t);
/* line 237 "AdaptAnalysis.puma" */
   NestOpenUnit (t);
/* line 238 "AdaptAnalysis.puma" */
   AdaptAnalysis (t->FUNC_DECL.FUNC_BODY);
/* line 239 "AdaptAnalysis.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
/* line 242 "AdaptAnalysis.puma" */
  {
/* line 244 "AdaptAnalysis.puma" */
   AssertFortran90 ("MODULE");
/* line 245 "AdaptAnalysis.puma" */
   NestOpenUnit (t);
/* line 246 "AdaptAnalysis.puma" */
   AdaptAnalysis (t->MODULE_DECL.MODULE_BODY);
/* line 247 "AdaptAnalysis.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 250 "AdaptAnalysis.puma" */
  {
/* line 252 "AdaptAnalysis.puma" */
   NestOpenUnit (t);
/* line 253 "AdaptAnalysis.puma" */
   AdaptAnalysis (t->BLOCK_DATA_DECL.DATA_BODY);
/* line 254 "AdaptAnalysis.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
/* line 257 "AdaptAnalysis.puma" */
  {
/* line 259 "AdaptAnalysis.puma" */
   FullTraverseAST (t, CheckUnsupported);
  }
   return;

  }

;
}

static void CheckRecursion
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kPROC_DECL) {
/* line 270 "AdaptAnalysis.puma" */
  {
/* line 272 "AdaptAnalysis.puma" */
   if (! ((t->PROC_DECL.IsRecursive))) goto yyL1;
  {
/* line 273 "AdaptAnalysis.puma" */
   set_protocol_unit (t);
/* line 274 "AdaptAnalysis.puma" */
   set_protocol_stmt (NoTree);
/* line 275 "AdaptAnalysis.puma" */
   AssertFortran90 ("RECURSIVE");
  }
  }
   return;
yyL1:;

  }
  if (t->Kind == kFUNC_DECL) {
/* line 278 "AdaptAnalysis.puma" */
  {
/* line 280 "AdaptAnalysis.puma" */
   if (! ((t->FUNC_DECL.IsRecursive))) goto yyL2;
  {
/* line 281 "AdaptAnalysis.puma" */
   set_protocol_unit (t);
/* line 282 "AdaptAnalysis.puma" */
   set_protocol_stmt (NoTree);
/* line 283 "AdaptAnalysis.puma" */
   AssertFortran90 ("RECURSIVE");
  }
  }
   return;
yyL2:;

  }
;
}

static void CheckUnsupported
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kBODY_NODE:
/* line 297 "AdaptAnalysis.puma" */
  {
/* line 299 "AdaptAnalysis.puma" */
   AdaptAnaDistributions (GetCurrentScope ());
/* line 300 "AdaptAnalysis.puma" */
   AdaptAnaOverlaps (GetCurrentScope ());
/* line 302 "AdaptAnalysis.puma" */
   AnaPureCheck (t);
/* line 304 "AdaptAnalysis.puma" */
   CheckInternals (t->BODY_NODE.INTERNALS);
  }
   return;

  case kPROCESSORS_DECL:
/* line 307 "AdaptAnalysis.puma" */
  {
/* line 309 "AdaptAnalysis.puma" */
   if (! ((TreeListLength (t->PROCESSORS_DECL.DIMENSIONS) > MAX_TORUS_RANK))) goto yyL2;
  {
/* line 311 "AdaptAnalysis.puma" */
   error_protocol ("too many dimensions for PROCESSOR ARRAY");
  }
  }
   return;
yyL2:;

  break;
  case kINIT_DATA_DECL:
/* line 314 "AdaptAnalysis.puma" */
  {
/* line 316 "AdaptAnalysis.puma" */
   error_protocol ("INIT not allowed (make initial statements)");
  }
   return;

  case kTARGET_DECL:
/* line 319 "AdaptAnalysis.puma" */
  {
/* line 321 "AdaptAnalysis.puma" */
   Unsupported ("TARGET attribute");
  }
   return;

  case kPOINTER_DECL:
/* line 324 "AdaptAnalysis.puma" */
   return;

  case kPRIVATE_DECL:
/* line 329 "AdaptAnalysis.puma" */
  {
/* line 331 "AdaptAnalysis.puma" */
   AssertFortran90 ("PRIVATE");
  }
   return;

  case kSEQUENCE_DECL:
/* line 334 "AdaptAnalysis.puma" */
  {
/* line 336 "AdaptAnalysis.puma" */
   AssertFortran90 ("SEQUENCE");
  }
   return;

  case kRANGE_DECL:
/* line 339 "AdaptAnalysis.puma" */
  {
/* line 341 "AdaptAnalysis.puma" */
   CheckDistributeSpec (t->RANGE_DECL.RANGES);
  }
   return;

  case kDYNAMIC_DECL:
/* line 344 "AdaptAnalysis.puma" */
  {
/* line 346 "AdaptAnalysis.puma" */
   AssertApprovedExtension ("DYNAMIC directive");
  }
   return;

  case kTRACE_DECL:
/* line 349 "AdaptAnalysis.puma" */
  {
/* line 351 "AdaptAnalysis.puma" */
   AssertAdaptorExtension ("TRACE directive");
  }
   return;

  case kNAMELIST_DECL:
/* line 354 "AdaptAnalysis.puma" */
  {
/* line 358 "AdaptAnalysis.puma" */
   CheckNameListVars (t->NAMELIST_DECL.IDS, t);
  }
   return;

  case kCOMMON_DECL:
/* line 361 "AdaptAnalysis.puma" */
  {
/* line 366 "AdaptAnalysis.puma" */
   match_error = 0;
/* line 368 "AdaptAnalysis.puma" */
   CheckCommonDescriptors (t, ValidateActual);
/* line 370 "AdaptAnalysis.puma" */
 if (match_error != 0)
        { simple_error_protocol ("MISMATCH of COMMON BLOCK");
          PrintCommonBlock (t, 1);
        }
    
  }
   return;

  case kEQV_DECL:
/* line 377 "AdaptAnalysis.puma" */
  {
/* line 379 "AdaptAnalysis.puma" */
   CheckReplicatedVars (t->EQV_DECL.VARS, t);
  }
   return;

  case kDATA_DECL:
/* line 382 "AdaptAnalysis.puma" */
  {
/* line 384 "AdaptAnalysis.puma" */
   CheckReplicatedVars (t->DATA_DECL.VARS, t);
  }
   return;

  case kUSE_DECL:
/* line 387 "AdaptAnalysis.puma" */
  {
/* line 389 "AdaptAnalysis.puma" */
   if (! ((t->USE_DECL.use == IsIdent ("HPF_LIBRARY")))) goto yyL15;
  }
   return;
yyL15:;

/* line 392 "AdaptAnalysis.puma" */
  {
/* line 394 "AdaptAnalysis.puma" */
   if (! ((t->USE_DECL.use == IsIdent ("HPF_LOCAL_LIBRARY")))) goto yyL16;
  }
   return;
yyL16:;

/* line 397 "AdaptAnalysis.puma" */
  {
/* line 399 "AdaptAnalysis.puma" */
   if (! ((t->USE_DECL.use == IsIdent ("HPF_TASK_LIBRARY")))) goto yyL17;
  }
   return;
yyL17:;

  if (t->USE_DECL.RENAMINGS->Kind == kDECL_EMPTY) {
/* line 402 "AdaptAnalysis.puma" */
  {
/* line 404 "AdaptAnalysis.puma" */
   AssertFortran90 ("USE");
  }
   return;

  }
/* line 407 "AdaptAnalysis.puma" */
  {
/* line 409 "AdaptAnalysis.puma" */
   AssertFortran90 ("USE");
/* line 410 "AdaptAnalysis.puma" */
   Unsupported ("USE with renaming");
  }
   return;

  case kONLY_USE_DECL:
  if (t->ONLY_USE_DECL.NAMES->Kind == kDECL_EMPTY) {
/* line 413 "AdaptAnalysis.puma" */
  {
/* line 415 "AdaptAnalysis.puma" */
   AssertFortran90 ("USE ONLY");
  }
   return;

  }
/* line 418 "AdaptAnalysis.puma" */
  {
/* line 420 "AdaptAnalysis.puma" */
   AssertFortran90 ("USE ONLY");
/* line 421 "AdaptAnalysis.puma" */
   Unsupported ("USE with renaming");
  }
   return;

  case kACF_CASE:
/* line 424 "AdaptAnalysis.puma" */
  {
/* line 426 "AdaptAnalysis.puma" */
   error_protocol ("CASE should have been converted");
  }
   return;

  case kACF_LOOP:
/* line 429 "AdaptAnalysis.puma" */
  {
/* line 431 "AdaptAnalysis.puma" */
   error_protocol ("LOOP should have been converted");
  }
   return;

  case kACF_TASK_REGION:
/* line 434 "AdaptAnalysis.puma" */
  {
/* line 436 "AdaptAnalysis.puma" */
   Unsupported ("TASK_REGION");
  }
   return;

  case kCALL_STMT:
/* line 439 "AdaptAnalysis.puma" */
  {
/* line 443 "AdaptAnalysis.puma" */
   match_error = 0;
/* line 445 "AdaptAnalysis.puma" */
   CheckActualDescriptors (t, ValidateActual);
/* line 447 "AdaptAnalysis.puma" */
 if (match_error > 0)
       { print_protocol ("MISMATCH of ACTUAL arguments with DUMMIES");
         PrintCall (t);
       }
   
  }
   return;

  case kREDUCE_STMT:
/* line 454 "AdaptAnalysis.puma" */
  {
/* line 456 "AdaptAnalysis.puma" */
   AdaptAnalReduceParams (t->REDUCE_STMT.RED_PARAMS);
  }
   return;

  case kREDISTRIBUTE_STMT:
/* line 459 "AdaptAnalysis.puma" */
  {
/* line 461 "AdaptAnalysis.puma" */
   CheckDistributeSpec (t->REDISTRIBUTE_STMT.DISTRIBUTION);
  }
   return;

  case kCYCLE_STMT:
/* line 464 "AdaptAnalysis.puma" */
  {
/* line 466 "AdaptAnalysis.puma" */
   error_protocol ("illegal CYCLE statement");
  }
   return;

  case kEXIT_STMT:
/* line 469 "AdaptAnalysis.puma" */
  {
/* line 471 "AdaptAnalysis.puma" */
   error_protocol ("illegal EXIT statement");
  }
   return;

  case kRETURN_STMT:
/* line 474 "AdaptAnalysis.puma" */
  {
/* line 476 "AdaptAnalysis.puma" */
   error_protocol ("Remove RETURN, jump to END of subroutine/function");
  }
   return;

  case kTYPE_EXP:
/* line 479 "AdaptAnalysis.puma" */
  {
/* line 481 "AdaptAnalysis.puma" */
   AssertFortran90 ("derived type");
  }
   return;

  case kFUNC_CALL_EXP:
/* line 484 "AdaptAnalysis.puma" */
  {
/* line 486 "AdaptAnalysis.puma" */
   if (! ((IsIntrCall (t)))) goto yyL32;
  {
/* line 488 "AdaptAnalysis.puma" */
   AnaIntrinsicFunction (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, t->FUNC_CALL_EXP.FUNC_PARAMS);
  }
  }
   return;
yyL32:;

  break;
  }

/* line 492 "AdaptAnalysis.puma" */
   return;

;
}

static void CheckInternals
# if defined __STDC__ | defined __cplusplus
(register tTree internals)
# else
(internals)
 register tTree internals;
# endif
{
  if (internals->Kind == kUNIT_EMPTY) {
/* line 505 "AdaptAnalysis.puma" */
   return;

  }
  if (internals->Kind == kUNIT_LIST) {
/* line 508 "AdaptAnalysis.puma" */
  {
/* line 510 "AdaptAnalysis.puma" */
   AssertFortran90 ("Internal Routines");
  }
   return;

  }
;
}

static void CheckReplicatedVars
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree decl)
# else
(t, decl)
 register tTree t;
 register tTree decl;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kBTV_LIST:
/* line 523 "AdaptAnalysis.puma" */
  {
/* line 525 "AdaptAnalysis.puma" */
   CheckReplicatedVars (t->BTV_LIST.Elem, decl);
/* line 526 "AdaptAnalysis.puma" */
   t = t->BTV_LIST.Next;
   goto yyRecursion;
  }

  case kBTV_EMPTY:
/* line 529 "AdaptAnalysis.puma" */
   return;

  case kUSED_VAR:
/* line 532 "AdaptAnalysis.puma" */
  {
/* line 534 "AdaptAnalysis.puma" */
   t = t->USED_VAR.VARNAME;
   goto yyRecursion;
  }

  case kINDEXED_VAR:
/* line 537 "AdaptAnalysis.puma" */
  {
/* line 539 "AdaptAnalysis.puma" */
   t = t->INDEXED_VAR.IND_VAR;
   goto yyRecursion;
  }

  case kSUBSTRING_VAR:
/* line 542 "AdaptAnalysis.puma" */
  {
/* line 544 "AdaptAnalysis.puma" */
   t = t->SUBSTRING_VAR.IND_VAR;
   goto yyRecursion;
  }

  case kSELECTED_VAR:
/* line 547 "AdaptAnalysis.puma" */
  {
/* line 549 "AdaptAnalysis.puma" */
   t = t->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;
  }

  case kVAR_OBJ:
/* line 552 "AdaptAnalysis.puma" */
  {
/* line 554 "AdaptAnalysis.puma" */
   if (! ((TreeWriteDistribution (t) != 0))) goto yyL7;
  {
/* line 556 "AdaptAnalysis.puma" */
   Unsupported ("DATA, EQUIVALENCE with distributed varaibles");
/* line 558 "AdaptAnalysis.puma" */
   tree_protocol ("Illegal declaration is : \n", decl);
/* line 559 "AdaptAnalysis.puma" */
   tree_protocol ("Illegal variable is : ", t);
  }
  }
   return;
yyL7:;

/* line 562 "AdaptAnalysis.puma" */
   return;

  case kDO_VAR:
/* line 565 "AdaptAnalysis.puma" */
  {
/* line 567 "AdaptAnalysis.puma" */
   t = t->DO_VAR.BODY;
   goto yyRecursion;
  }

  }

/* line 570 "AdaptAnalysis.puma" */
  {
/* line 572 "AdaptAnalysis.puma" */
   failure_protocol (MODULE, "CheckReplicatedVars", t);
  }
   return;

;
}

static void CheckNameListVars
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree nl)
# else
(t, nl)
 register tTree t;
 register tTree nl;
# endif
{
 yyRecursion:
  if (t->Kind == kDECL_LIST) {
/* line 585 "AdaptAnalysis.puma" */
  {
/* line 587 "AdaptAnalysis.puma" */
   CheckNameListVars (t->DECL_LIST.Elem, nl);
/* line 588 "AdaptAnalysis.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kVAR_DECL) {
/* line 591 "AdaptAnalysis.puma" */
  {
/* line 593 "AdaptAnalysis.puma" */
   if (! ((VarDistribution (GetGlobalObject (t->VAR_DECL.Ident)) == 1))) goto yyL2;
  {
/* line 595 "AdaptAnalysis.puma" */
   Unsupported ("distributed variable in NAMELIST");
/* line 596 "AdaptAnalysis.puma" */
   tree_protocol ("namelist        : ", nl);
/* line 597 "AdaptAnalysis.puma" */
   tree_protocol ("distributed var : ", t);
  }
  }
   return;
yyL2:;

  }
;
}

static void AdaptAnaDistributions
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
 yyRecursion:
  if (t->Kind == kENTRY_LIST) {
/* line 611 "AdaptAnalysis.puma" */
  {
/* line 613 "AdaptAnalysis.puma" */
   set_protocol_stmt (t->ENTRY_LIST.Elem->Object.decl);
/* line 615 "AdaptAnalysis.puma" */
   CheckObjKind (t->ENTRY_LIST.Elem);
/* line 616 "AdaptAnalysis.puma" */
   CheckObjMapping (t->ENTRY_LIST.Elem);
/* line 617 "AdaptAnalysis.puma" */
   t = t->ENTRY_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kENTRY_EMPTY) {
/* line 620 "AdaptAnalysis.puma" */
   return;

  }
;
}

static void CheckObjMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj)
# else
(Obj)
 register tDefinitions Obj;
# endif
{
  if (Obj->Kind == kVarObject) {
/* line 631 "AdaptAnalysis.puma" */
  {
/* line 633 "AdaptAnalysis.puma" */
   VerifySpecMapping (Obj->VarObject.Dist->Mapping.spec, Obj);
/* line 634 "AdaptAnalysis.puma" */
   VerifyRangeMapping (Obj->VarObject.Dist->Mapping.range, Obj);
  }
   return;

  }
  if (Obj->Kind == kTemplateObject) {
/* line 637 "AdaptAnalysis.puma" */
  {
/* line 639 "AdaptAnalysis.puma" */
   VerifySpecMapping (Obj->TemplateObject.Dist->Mapping.spec, Obj);
/* line 640 "AdaptAnalysis.puma" */
   VerifyRangeMapping (Obj->TemplateObject.Dist->Mapping.range, Obj);
  }
   return;

  }
;
}

static void CheckObjKind
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
/* line 653 "AdaptAnalysis.puma" */
  {
/* line 655 "AdaptAnalysis.puma" */
   if (! ((obj->VarObject.Kind->VarLocal.save))) goto yyL1;
  {
/* line 656 "AdaptAnalysis.puma" */
   if (! ((IsMappedObj (obj)))) goto yyL1;
  {
/* line 657 "AdaptAnalysis.puma" */
   Unsupported ("SAVE for distributed arrays");
/* line 658 "AdaptAnalysis.puma" */
   obj_protocol ("illegal obj : ", obj);
  }
  }
  }
   return;
yyL1:;

  }
  if (obj->VarObject.Kind->Kind == kVarDummy) {
/* line 661 "AdaptAnalysis.puma" */
  {
/* line 664 "AdaptAnalysis.puma" */
   if (! ((obj->VarObject.arr_kind == arr_assumed_size))) goto yyL2;
  {
/* line 666 "AdaptAnalysis.puma" */
   if (! ((IsMappedObj (obj)))) goto yyL2;
  {
/* line 667 "AdaptAnalysis.puma" */
   error_protocol ("assumed size arrays must not be distributed");
/* line 668 "AdaptAnalysis.puma" */
   obj_protocol ("illegal obj : ", obj);
  }
  }
  }
   return;
yyL2:;

  }
/* line 671 "AdaptAnalysis.puma" */
  {
/* line 673 "AdaptAnalysis.puma" */
   if (! ((obj->VarObject.trace))) goto yyL3;
  {
/* line 674 "AdaptAnalysis.puma" */
   if (! ((VarRank (obj) == 0))) goto yyL3;
  {
/* line 675 "AdaptAnalysis.puma" */
   error_protocol ("scalar cannot be traced");
/* line 676 "AdaptAnalysis.puma" */
   obj_protocol ("illegal obj : ", obj);
  }
  }
  }
   return;
yyL3:;

  }
/* line 679 "AdaptAnalysis.puma" */
   return;

;
}

static rbool IsMappedObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapDist) {
/* line 684 "AdaptAnalysis.puma" */
   return rtrue;

  }
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapAlign) {
/* line 687 "AdaptAnalysis.puma" */
   return rtrue;

  }
  if (obj->VarObject.Dist->Mapping.spec->Kind == kMapInherited) {
/* line 690 "AdaptAnalysis.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static void VerifySpecMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, register tDefinitions Obj)
# else
(d, Obj)
 register tDefinitions d;
 register tDefinitions Obj;
# endif
{
  if (d->Kind == kMapDefault) {
/* line 701 "AdaptAnalysis.puma" */
  {
/* line 703 "AdaptAnalysis.puma" */
   obj_error_protocol ("object has still default distribution", Obj);
  }
   return;

  }
  if (d->Kind == kMapDecl) {
/* line 706 "AdaptAnalysis.puma" */
  {
/* line 708 "AdaptAnalysis.puma" */
   obj_error_protocol ("layout directive should have been evaluated", Obj);
  }
   return;

  }
  if (d->Kind == kMapReplicated) {
/* line 711 "AdaptAnalysis.puma" */
   return;

  }
  if (d->Kind == kMapDist) {
/* line 714 "AdaptAnalysis.puma" */
  {
/* line 716 "AdaptAnalysis.puma" */
 

    if (VarRank (d->MapDist.Distribution->Distribution.top_obj) > MAX_TORUS_RANK)

      { char msg [MAX_LINE_LENGTH];

        sprintf (msg,"ARRAY has %d distributed dims, only %d are allowed",
                 VarRank (d->MapDist.Distribution->Distribution.top_obj), MAX_TORUS_RANK);
        error_protocol (msg);
        obj_protocol ("illegal object : ", Obj);
      }
   
  }
   return;

  }
  if (d->Kind == kMapAlign) {
/* line 730 "AdaptAnalysis.puma" */
  {
/* line 732 "AdaptAnalysis.puma" */
   CheckAlignSourceList (d->MapAlign.Alignment->Alignment.SourceList);
  }
   return;

  }
  if (d->Kind == kMapInherited) {
/* line 737 "AdaptAnalysis.puma" */
   return;

  }
/* line 740 "AdaptAnalysis.puma" */
  {
/* line 742 "AdaptAnalysis.puma" */
   error_protocol ("not supported distribution");
/* line 743 "AdaptAnalysis.puma" */
   obj_protocol ("illegal obj : ", Obj);
  }
   return;

;
}

static void VerifyRangeMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, register tDefinitions Obj)
# else
(d, Obj)
 register tDefinitions d;
 register tDefinitions Obj;
# endif
{
  if (d->Kind == kRangeDefault) {
/* line 753 "AdaptAnalysis.puma" */
  {
/* line 755 "AdaptAnalysis.puma" */
   obj_error_protocol ("object has still default range", Obj);
  }
   return;

  }
  if (d->Kind == kRangeDecl) {
/* line 758 "AdaptAnalysis.puma" */
  {
/* line 760 "AdaptAnalysis.puma" */
   obj_error_protocol ("range directive should have been evaluated", Obj);
  }
   return;

  }
  if (d->Kind == kRangeNone) {
/* line 763 "AdaptAnalysis.puma" */
   return;

  }
;
}

static void CheckAlignSourceList
# if defined __STDC__ | defined __cplusplus
(register tDefinitions dl)
# else
(dl)
 register tDefinitions dl;
# endif
{
 yyRecursion:
  if (dl->Kind == kDIM_LIST) {
/* line 774 "AdaptAnalysis.puma" */
  {
/* line 776 "AdaptAnalysis.puma" */
   CheckAlignSourceList (dl->DIM_LIST.Elem);
/* line 777 "AdaptAnalysis.puma" */
   dl = dl->DIM_LIST.Next;
   goto yyRecursion;
  }

  }
  if (dl->Kind == kDIM_EMPTY) {
/* line 780 "AdaptAnalysis.puma" */
   return;

  }
  if (dl->Kind == kAlignedDimension) {
/* line 783 "AdaptAnalysis.puma" */
 {
  rbool found;
  int val;
  {
/* line 788 "AdaptAnalysis.puma" */
 GetIntConstValue (dl->AlignedDimension.mult, &found, &val);
     if (!found)
      { error_protocol ("mult val in alignment must be known at compile time");
        tree_protocol ("unknown the val of : ", dl->AlignedDimension.mult);
      }
     GetIntConstValue (dl->AlignedDimension.add, &found, &val);
     if (!found)
      { error_protocol ("add val in alignment must be known at compile time");
        tree_protocol ("unknown the val of : ", dl->AlignedDimension.add);
      }
   
  }
   return;
 }

  }
;
}

static void ValidateActual
# if defined __STDC__ | defined __cplusplus
(register tDefinitions actual_obj, register tDefinitions formal_obj)
# else
(actual_obj, formal_obj)
 register tDefinitions actual_obj;
 register tDefinitions formal_obj;
# endif
{
/* line 815 "AdaptAnalysis.puma" */
   return;

;
}

static void AnaIntrinsicFunction
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params)
# else
(name, params)
 register tIdent name;
 register tTree params;
# endif
{
/* line 826 "AdaptAnalysis.puma" */
  {
/* line 828 "AdaptAnalysis.puma" */
   if (! ((name == IsIdent ("MODULO")))) goto yyL1;
  {
/* line 829 "AdaptAnalysis.puma" */
   AssertFortran90 ("intrinsic MODULO");
  }
  }
   return;
yyL1:;

/* line 832 "AdaptAnalysis.puma" */
  {
/* line 834 "AdaptAnalysis.puma" */
   if (! ((IntrFuncRed (name)))) goto yyL2;
  {
/* line 835 "AdaptAnalysis.puma" */
   AnaReductionParameters (params);
  }
  }
   return;
yyL2:;

  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
/* line 838 "AdaptAnalysis.puma" */
  {
/* line 840 "AdaptAnalysis.puma" */
   if (! ((IntrFuncLocRed (name)))) goto yyL3;
  }
   return;
yyL3:;

  }
  }
  }
/* line 843 "AdaptAnalysis.puma" */
  {
/* line 845 "AdaptAnalysis.puma" */
   if (! ((IntrFuncLocRed (name)))) goto yyL4;
  {
/* line 847 "AdaptAnalysis.puma" */
   error_protocol ("dim argument must be available in MINLOC/MAXLOC");
  }
  }
   return;
yyL4:;

  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 850 "AdaptAnalysis.puma" */
  {
/* line 853 "AdaptAnalysis.puma" */
   if (! (((name == IsIdent ("LBOUND")) || (name == IsIdent ("UBOUND"))))) goto yyL5;
  {
/* line 856 "AdaptAnalysis.puma" */
   error_protocol ("dim argument must be available in LBOUND/UBOUND");
  }
  }
   return;
yyL5:;

  }
  }
  }
  }
;
}

static void AnaReductionParameters
# if defined __STDC__ | defined __cplusplus
(register tTree params)
# else
(params)
 register tTree params;
# endif
{
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
/* line 864 "AdaptAnalysis.puma" */
   return;

  }
/* line 869 "AdaptAnalysis.puma" */
 {
  int idim;
  rbool found;
  {
/* line 876 "AdaptAnalysis.puma" */
   GetIntConstValue (params->BTP_LIST.Next->BTP_LIST.Elem, & found, & idim);
/* line 877 "AdaptAnalysis.puma" */
   if (! ((found))) goto yyL2;
  }
   return;
 }
yyL2:;

  }
  }
/* line 880 "AdaptAnalysis.puma" */
  {
/* line 882 "AdaptAnalysis.puma" */
   error_protocol ("dim of reduction must be known at compile time");
  }
   return;

;
}

static void AdaptAnalReduceParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTP_EMPTY) {
/* line 901 "AdaptAnalysis.puma" */
   return;

  }
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 904 "AdaptAnalysis.puma" */
  {
/* line 906 "AdaptAnalysis.puma" */
   t = t->BTP_LIST.Next->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  }
;
}

static rbool DistributedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree plist)
# else
(plist)
 register tTree plist;
# endif
{
 yyRecursion:
  if (plist->Kind == kBTP_LIST) {
  if (plist->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 919 "AdaptAnalysis.puma" */
  {
/* line 920 "AdaptAnalysis.puma" */
   if (! ((TreeWriteDistribution (plist->BTP_LIST.Elem->VAR_PARAM.V) == 1))) goto yyL1;
  {
/* line 921 "AdaptAnalysis.puma" */
   plist = plist->BTP_LIST.Next;
   goto yyRecursion;
  }
  }
yyL1:;

  }
  if (plist->BTP_LIST.Elem->Kind == kFUNC_PARAM) {
  if (plist->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 924 "AdaptAnalysis.puma" */
   return rtrue;

  }
  }
  }
  if (plist->Kind == kBTP_EMPTY) {
/* line 928 "AdaptAnalysis.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool ReplicatedParameters
# if defined __STDC__ | defined __cplusplus
(register tTree plist)
# else
(plist)
 register tTree plist;
# endif
{
 yyRecursion:
  if (plist->Kind == kBTP_LIST) {
  if (plist->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 941 "AdaptAnalysis.puma" */
  {
/* line 942 "AdaptAnalysis.puma" */
   if (! ((TreeWriteDistribution (plist->BTP_LIST.Elem->VAR_PARAM.V) == 0))) goto yyL1;
  {
/* line 943 "AdaptAnalysis.puma" */
   plist = plist->BTP_LIST.Next;
   goto yyRecursion;
  }
  }
yyL1:;

  }
  if (plist->BTP_LIST.Elem->Kind == kFUNC_PARAM) {
  if (plist->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 946 "AdaptAnalysis.puma" */
   return rtrue;

  }
  }
  }
  if (plist->Kind == kBTP_EMPTY) {
/* line 950 "AdaptAnalysis.puma" */
   return rtrue;

  }
  return rfalse;
}

static void CheckCommons
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
 yyRecursion:
  if (t->Kind == kENTRY_LIST) {
/* line 964 "AdaptAnalysis.puma" */
  {
/* line 966 "AdaptAnalysis.puma" */
   set_protocol_stmt (t->ENTRY_LIST.Elem->Object.decl);
/* line 968 "AdaptAnalysis.puma" */
   CheckCommons (t->ENTRY_LIST.Next);
/* line 969 "AdaptAnalysis.puma" */
   t = t->ENTRY_LIST.Elem;
   goto yyRecursion;
  }

  }
  if (t->Kind == kENTRY_EMPTY) {
/* line 972 "AdaptAnalysis.puma" */
   return;

  }
  if (t->Kind == kCommonObject) {
/* line 975 "AdaptAnalysis.puma" */
  {
/* line 977 "AdaptAnalysis.puma" */
   if (! ((t->CommonObject.sequence == 1))) goto yyL3;
  {
/* line 978 "AdaptAnalysis.puma" */
   if (! ((t->CommonObject.distributed_vars > 0))) goto yyL3;
  {
/* line 980 "AdaptAnalysis.puma" */
   error_protocol ("SEQUENCE association for COMMON with distributed vars");
  }
  }
  }
   return;
yyL3:;

/* line 983 "AdaptAnalysis.puma" */
  {
/* line 985 "AdaptAnalysis.puma" */
   if (! ((t->CommonObject.main != rtrue))) goto yyL4;
  {
/* line 989 "AdaptAnalysis.puma" */
   if (! ((t->CommonObject.distributed_vars > 0))) goto yyL4;
  {
/* line 990 "AdaptAnalysis.puma" */
   error_protocol ("COMMON with distributed variables not defined in main");
  }
  }
  }
   return;
yyL4:;

  }
;
}

static void AnaPureCheck
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 1005 "AdaptAnalysis.puma" */
  {
/* line 1007 "AdaptAnalysis.puma" */
   if (! ((! IsPureUnit (GetCurrentUnit ())))) goto yyL1;
  }
   return;
yyL1:;

  if (t->Kind == kBODY_NODE) {
/* line 1010 "AdaptAnalysis.puma" */
  {
/* line 1012 "AdaptAnalysis.puma" */
   FullTraverseAST (t->BODY_NODE.DECLS, PureCheck);
/* line 1013 "AdaptAnalysis.puma" */
   FullTraverseAST (t->BODY_NODE.STATS, PureCheck);
  }
   return;

  }
;
}

static void PureCheck
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
/* line 1018 "AdaptAnalysis.puma" */
  {
/* line 1020 "AdaptAnalysis.puma" */
   serious_warning_protocol ("IO in PURE subprograms not allowed");
  }
   return;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 1023 "AdaptAnalysis.puma" */
  {
/* line 1027 "AdaptAnalysis.puma" */
   if (! ((! IsPureCall (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_ID)))) goto yyL2;
  {
/* line 1028 "AdaptAnalysis.puma" */
   error_protocol ("CALL of not pure subroutine in PURE subprogram");
  }
  }
   return;
yyL2:;

  }
  }
  if (t->Kind == kFUNC_CALL_EXP) {
/* line 1031 "AdaptAnalysis.puma" */
  {
/* line 1033 "AdaptAnalysis.puma" */
   if (! ((! IsPureCall (t)))) goto yyL3;
  {
/* line 1034 "AdaptAnalysis.puma" */
   error_protocol ("CALL of a not pure function in PURE subprogram");
  }
  }
   return;
yyL3:;

  }
;
}

static void AdaptAnaOverlaps
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
 yyRecursion:
  if (t->Kind == kENTRY_LIST) {
/* line 1048 "AdaptAnalysis.puma" */
  {
/* line 1050 "AdaptAnalysis.puma" */
   AdaptAnaOverlaps (t->ENTRY_LIST.Elem);
/* line 1051 "AdaptAnalysis.puma" */
   t = t->ENTRY_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kENTRY_EMPTY) {
/* line 1054 "AdaptAnalysis.puma" */
   return;

  }
  if (t->Kind == kVarObject) {
  if (t->VarObject.Kind->Kind == kVarCommon) {
/* line 1063 "AdaptAnalysis.puma" */
   return;

  }
  }
;
}

static tTree GetCommonDeclarations
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 1074 "AdaptAnalysis.puma" */
  {
/* line 1075 "AdaptAnalysis.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  }
   return NoTree;
yyL1:;

  if (obj->Kind == kCommonObject) {
  if (obj->CommonObject.decl->Kind == kCOMMON_DECL) {
/* line 1079 "AdaptAnalysis.puma" */
   return obj->CommonObject.decl->COMMON_DECL.IDS;

  }
  }
 yyAbort ("GetCommonDeclarations");
 { tTree yyDummy; return yyDummy; }
}

static void CheckDistributeSpec
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
 yyRecursion:

  switch (spec->Kind) {
  case kNODE_DISTRIBUTION:
/* line 1093 "AdaptAnalysis.puma" */
  {
/* line 1095 "AdaptAnalysis.puma" */
   spec = spec->NODE_DISTRIBUTION.MAPPING;
   goto yyRecursion;
  }

  case kDEFAULT_DISTRIBUTION:
/* line 1098 "AdaptAnalysis.puma" */
  {
/* line 1100 "AdaptAnalysis.puma" */
   error_protocol ("default distribution not evaluated");
  }
   return;

  case kANY_DISTRIBUTION:
/* line 1103 "AdaptAnalysis.puma" */
  {
/* line 1105 "AdaptAnalysis.puma" */
   error_protocol ("DISTRIBUTE * not supported yet");
  }
   return;

  case kREPL_DISTRIBUTION:
/* line 1108 "AdaptAnalysis.puma" */
   return;

  case kRANGE_EMPTY:
/* line 1111 "AdaptAnalysis.puma" */
   return;

  case kRANGE_LIST:
/* line 1114 "AdaptAnalysis.puma" */
  {
/* line 1116 "AdaptAnalysis.puma" */
   CheckDistributeSpec (spec->RANGE_LIST.Elem);
/* line 1117 "AdaptAnalysis.puma" */
   spec = spec->RANGE_LIST.Next;
   goto yyRecursion;
  }

  case kDIST_EMPTY:
/* line 1120 "AdaptAnalysis.puma" */
   return;

  case kDIST_LIST:
/* line 1123 "AdaptAnalysis.puma" */
  {
/* line 1125 "AdaptAnalysis.puma" */
   CheckDistributeSpec (spec->DIST_LIST.Elem);
/* line 1126 "AdaptAnalysis.puma" */
   spec = spec->DIST_LIST.Next;
   goto yyRecursion;
  }

  case kBLOCK_DISTRIBUTION:
  if (spec->BLOCK_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
/* line 1129 "AdaptAnalysis.puma" */
   return;

  }
/* line 1132 "AdaptAnalysis.puma" */
 {
  int size;
  rbool found;
  {
/* line 1137 "AdaptAnalysis.puma" */
   GetIntConstValue (spec->BLOCK_DISTRIBUTION.SIZE, & found, & size);
/* line 1139 "AdaptAnalysis.puma" */
 if (!found)
         error_protocol ("size of BLOCK unknown at compile time");
    
  }
   return;
 }

  case kCYCLIC_DISTRIBUTION:
  if (spec->CYCLIC_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
/* line 1144 "AdaptAnalysis.puma" */
   return;

  }
/* line 1147 "AdaptAnalysis.puma" */
 {
  int size;
  rbool found;
  {
/* line 1152 "AdaptAnalysis.puma" */
   GetIntConstValue (spec->CYCLIC_DISTRIBUTION.SIZE, & found, & size);
/* line 1154 "AdaptAnalysis.puma" */
 if (!found)
         error_protocol ("size of CYCLIC unknown at compile time");
       else if (size != 1);
         Unsupported ("CYCLIC(N) for N > 1");
    
  }
   return;
 }

  case kSERIAL_DISTRIBUTION:
/* line 1161 "AdaptAnalysis.puma" */
   return;

  case kGEN_BLOCK_DISTRIBUTION:
/* line 1164 "AdaptAnalysis.puma" */
  {
/* line 1166 "AdaptAnalysis.puma" */
 if (TreeWriteDistribution (spec->GEN_BLOCK_DISTRIBUTION.ARRAY) != 0)

       { error_protocol ("array for GEN_BLOCK distribution must be replicated");
         tree_protocol ("illegal array is : ", spec->GEN_BLOCK_DISTRIBUTION.ARRAY);
       }
   
  }
   return;

  case kINDIRECT_DISTRIBUTION:
/* line 1174 "AdaptAnalysis.puma" */
  {
/* line 1176 "AdaptAnalysis.puma" */
   Unsupported ("INDIRECT distribution");
  }
   return;

  case kARBITRARY_DISTRIBUTION:
/* line 1179 "AdaptAnalysis.puma" */
  {
/* line 1181 "AdaptAnalysis.puma" */
   Unsupported ("ARBITRARY distribution");
  }
   return;

  case kANY_BLOCK_DISTRIBUTION:
/* line 1184 "AdaptAnalysis.puma" */
   return;

  case kANY_CYCLIC_DISTRIBUTION:
/* line 1187 "AdaptAnalysis.puma" */
  {
/* line 1189 "AdaptAnalysis.puma" */
   Unsupported ("CYCLIC() for dummies");
  }
   return;

  case kANY_GEN_BLOCK_DISTRIBUTION:
/* line 1192 "AdaptAnalysis.puma" */
  {
/* line 1194 "AdaptAnalysis.puma" */
   Unsupported ("GEN_BLOCK() for dummies");
  }
   return;

  case kANY_INDIRECT_DISTRIBUTION:
/* line 1197 "AdaptAnalysis.puma" */
  {
/* line 1199 "AdaptAnalysis.puma" */
   Unsupported ("INDIRECT() for dummies");
  }
   return;

  case kANY_ARBITRARY_DISTRIBUTION:
/* line 1202 "AdaptAnalysis.puma" */
  {
/* line 1204 "AdaptAnalysis.puma" */
   Unsupported ("ARBITRARY() for dummies");
  }
   return;

  case kANY_DIM_DISTRIBUTION:
/* line 1207 "AdaptAnalysis.puma" */
   return;

  }

/* line 1210 "AdaptAnalysis.puma" */
  {
/* line 1211 "AdaptAnalysis.puma" */
   failure_protocol (MODULE, "CheckDistributeSpec", spec);
  }
   return;

;
}

static void CheckProcessorsSpec
# if defined __STDC__ | defined __cplusplus
(register tTree p)
# else
(p)
 register tTree p;
# endif
{
  if (p->Kind == kANY_PROCESSOR_ARRAY) {
/* line 1216 "AdaptAnalysis.puma" */
   return;

  }
  if (p->Kind == kDEFAULT_PROCESSOR_ARRAY) {
/* line 1221 "AdaptAnalysis.puma" */
  {
/* line 1223 "AdaptAnalysis.puma" */
   error_protocol ("default processor array not replaced");
  }
   return;

  }
;
}

void BeginAdaptAnalysis ARGS ((void))
{
}

void CloseAdaptAnalysis ARGS ((void))
{
}
